/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaDataType* _base_type;
	gboolean* boolean_type;
	gboolean* integer_type;
	gboolean* floating_type;
	gboolean* decimal_floating_type;
	gboolean* simple_type;
	gint* rank;
	gint* _width;
	gboolean* _signed;
	gboolean* _is_immutable;
	ValaMethod* _default_construction_method;
};


static gpointer vala_struct_parent_class = NULL;

#define VALA_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT, ValaStructPrivate))
static void vala_struct_real_add_constant (ValaSymbol* base,
                                    ValaConstant* c);
static void vala_struct_real_add_field (ValaSymbol* base,
                                 ValaField* f);
static void vala_struct_real_add_method (ValaSymbol* base,
                                  ValaMethod* m);
static void vala_struct_real_add_property (ValaSymbol* base,
                                    ValaProperty* prop);
static void vala_struct_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                const gchar* name);
static void vala_struct_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                         ValaTypeSymbol* t);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self,
                                              ValaCodeContext* context,
                                              ValaDataType* type);
static gboolean vala_struct_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_struct_finalize (ValaCodeNode * obj);


/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct*
vala_struct_construct (GType object_type,
                       const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaStruct* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaStruct*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaStruct*
vala_struct_new (const gchar* name,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_struct_add_type_parameter (ValaStruct* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_struct_get_type_parameters (ValaStruct* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
static void
vala_struct_real_add_constant (ValaSymbol* base,
                               ValaConstant* c)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}


/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
static void
vala_struct_real_add_field (ValaSymbol* base,
                            ValaField* f)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (f != NULL);
	vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp0_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp0_, f);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList*
vala_struct_get_fields (ValaStruct* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_struct_get_constants (ValaStruct* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_struct_real_add_method (ValaSymbol* base,
                             ValaMethod* m)
{
	ValaStruct * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaList* _tmp53_;
	ValaScope* _tmp54_;
	ValaScope* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	self = (ValaStruct*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		_tmp3_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_parameter_new ("this", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		vala_method_set_this_parameter (m, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp4_);
		_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_method_get_this_parameter (m);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_get_this_parameter (m);
		_tmp14_ = _tmp13_;
		vala_scope_add (_tmp8_, _tmp12_, (ValaSymbol*) _tmp14_);
	}
	_tmp16_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp17_ = _tmp16_;
	if (!VALA_IS_VOID_TYPE (_tmp17_)) {
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = vala_method_get_postconditions (m);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_ > 0;
		_vala_iterable_unref0 (_tmp19_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		_tmp22_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_data_type_copy (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_local_variable_new (_tmp25_, "result", NULL, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		vala_local_variable_set_is_result (_tmp31_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp34_;
		gboolean _tmp35_ = FALSE;
		ValaCreationMethod* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == NULL) {
			vala_struct_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp34_;
		_tmp36_ = cm;
		_tmp37_ = vala_creation_method_get_class_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (_tmp38_ != NULL) {
			ValaCreationMethod* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp39_ = cm;
			_tmp40_ = vala_creation_method_get_class_name (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp43_ = _tmp42_;
			_tmp35_ = g_strcmp0 (_tmp41_, _tmp43_) != 0;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			ValaCreationMethod* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = cm;
			_tmp49_ = vala_creation_method_get_class_name (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp47_, _tmp50_);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp45_, _tmp52_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp53_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp53_, m);
	_tmp54_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp57_ = _tmp56_;
	vala_scope_add (_tmp55_, _tmp57_, (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_struct_get_methods (ValaStruct* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this struct.
 *
 * @param prop a property
 */
static void
vala_struct_real_add_property (ValaSymbol* base,
                               ValaProperty* prop)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaParameter* _tmp7_;
	ValaParameter* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaParameter* _tmp15_;
	ValaParameter* _tmp16_;
	ValaField* _tmp17_;
	ValaField* _tmp18_;
	self = (ValaStruct*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	vala_collection_add ((ValaCollection*) _tmp0_, prop);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) prop);
	_tmp5_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_parameter_new ("this", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	vala_property_set_this_parameter (prop, _tmp8_);
	_vala_code_node_unref0 (_tmp8_);
	_vala_code_node_unref0 (_tmp6_);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_property_get_this_parameter (prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_property_get_this_parameter (prop);
	_tmp16_ = _tmp15_;
	vala_scope_add (_tmp10_, _tmp14_, (ValaSymbol*) _tmp16_);
	_tmp17_ = vala_property_get_field (prop);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaField* _tmp19_;
		ValaField* _tmp20_;
		_tmp19_ = vala_property_get_field (prop);
		_tmp20_ = _tmp19_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp20_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
ValaList*
vala_struct_get_properties (ValaStruct* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_struct_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_struct (visitor, self);
}


static void
vala_struct_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_struct_get_base_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _p_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _p_index = 0;
		_tmp4_ = self->priv->type_parameters;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_p_list = _tmp5_;
		_tmp6_ = _p_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaTypeParameter* _tmp14_;
			_p_index = _p_index + 1;
			_tmp9_ = _p_index;
			_tmp10_ = _p_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _p_list;
			_tmp12_ = _p_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			p = (ValaTypeParameter*) _tmp13_;
			_tmp14_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _f_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _f_index = 0;
		_tmp15_ = self->priv->fields;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_f_list = _tmp16_;
		_tmp17_ = _f_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_f_size = _tmp19_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaField* f = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaField* _tmp25_;
			_f_index = _f_index + 1;
			_tmp20_ = _f_index;
			_tmp21_ = _f_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _f_list;
			_tmp23_ = _f_index;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			f = (ValaField*) _tmp24_;
			_tmp25_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _c_size = 0;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _c_index = 0;
		_tmp26_ = self->priv->constants;
		_tmp27_ = _vala_iterable_ref0 (_tmp26_);
		_c_list = _tmp27_;
		_tmp28_ = _c_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_c_size = _tmp30_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			ValaConstant* c = NULL;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaConstant* _tmp36_;
			_c_index = _c_index + 1;
			_tmp31_ = _c_index;
			_tmp32_ = _c_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _c_list;
			_tmp34_ = _c_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			c = (ValaConstant*) _tmp35_;
			_tmp36_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp37_;
		ValaList* _tmp38_;
		gint _m_size = 0;
		ValaList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _m_index = 0;
		_tmp37_ = self->priv->methods;
		_tmp38_ = _vala_iterable_ref0 (_tmp37_);
		_m_list = _tmp38_;
		_tmp39_ = _m_list;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_m_size = _tmp41_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			ValaMethod* m = NULL;
			ValaList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_;
			ValaMethod* _tmp47_;
			_m_index = _m_index + 1;
			_tmp42_ = _m_index;
			_tmp43_ = _m_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _m_list;
			_tmp45_ = _m_index;
			_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
			m = (ValaMethod*) _tmp46_;
			_tmp47_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp47_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp48_;
		ValaList* _tmp49_;
		gint _prop_size = 0;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _prop_index = 0;
		_tmp48_ = self->priv->properties;
		_tmp49_ = _vala_iterable_ref0 (_tmp48_);
		_prop_list = _tmp49_;
		_tmp50_ = _prop_list;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_prop_size = _tmp52_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp53_;
			gint _tmp54_;
			ValaProperty* prop = NULL;
			ValaList* _tmp55_;
			gint _tmp56_;
			gpointer _tmp57_;
			ValaProperty* _tmp58_;
			_prop_index = _prop_index + 1;
			_tmp53_ = _prop_index;
			_tmp54_ = _prop_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _prop_list;
			_tmp56_ = _prop_index;
			_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
			prop = (ValaProperty*) _tmp57_;
			_tmp58_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
}


/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_struct_is_boolean_type (ValaStruct* self)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_boolean_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->boolean_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		ValaAttribute* _tmp8_;
		gboolean _tmp9_;
		gboolean* _tmp10_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_ != NULL;
		_tmp10_ = __bool_dup0 (&_tmp9_);
		_g_free0 (self->priv->boolean_type);
		self->priv->boolean_type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	}
	_tmp11_ = self->priv->boolean_type;
	result = *_tmp11_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean
vala_struct_is_integer_type (ValaStruct* self)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_integer_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->integer_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		ValaAttribute* _tmp8_;
		gboolean _tmp9_;
		gboolean* _tmp10_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_ != NULL;
		_tmp10_ = __bool_dup0 (&_tmp9_);
		_g_free0 (self->priv->integer_type);
		self->priv->integer_type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	}
	_tmp11_ = self->priv->integer_type;
	result = *_tmp11_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean
vala_struct_is_floating_type (ValaStruct* self)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_floating_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->floating_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		ValaAttribute* _tmp8_;
		gboolean _tmp9_;
		gboolean* _tmp10_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_ != NULL;
		_tmp10_ = __bool_dup0 (&_tmp9_);
		_g_free0 (self->priv->floating_type);
		self->priv->floating_type = _tmp10_;
		_vala_code_node_unref0 (_tmp8_);
	}
	_tmp11_ = self->priv->floating_type;
	result = *_tmp11_;
	_vala_code_node_unref0 (st);
	return result;
}


gboolean
vala_struct_is_decimal_floating_type (ValaStruct* self)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_decimal_floating_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->decimal_floating_type;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_;
		gboolean* _tmp8_;
		_tmp7_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "FloatingType", "decimal", FALSE);
		_tmp8_ = __bool_dup0 (&_tmp7_);
		_g_free0 (self->priv->decimal_floating_type);
		self->priv->decimal_floating_type = _tmp8_;
	}
	_tmp9_ = self->priv->decimal_floating_type;
	result = *_tmp9_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns the rank of this integer or floating point type.
 *
 * @return the rank if this is an integer or floating point type
 */
static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}


gint
vala_struct_get_rank (ValaStruct* self)
{
	gint result = 0;
	gint* _tmp0_;
	gint* _tmp15_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->rank;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		if (vala_struct_is_integer_type (self)) {
			_tmp1_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "IntegerType", "rank");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint _tmp2_;
			gint* _tmp3_;
			_tmp2_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", 0);
			_tmp3_ = __int_dup0 (&_tmp2_);
			_g_free0 (self->priv->rank);
			self->priv->rank = _tmp3_;
		} else {
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "FloatingType", "rank")) {
				gint _tmp4_;
				gint* _tmp5_;
				_tmp4_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", 0);
				_tmp5_ = __int_dup0 (&_tmp4_);
				_g_free0 (self->priv->rank);
				self->priv->rank = _tmp5_;
			} else {
				ValaStruct* st = NULL;
				ValaStruct* _tmp6_;
				ValaStruct* _tmp7_;
				ValaStruct* _tmp8_;
				ValaStruct* _tmp9_;
				_tmp6_ = vala_struct_get_base_struct (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _vala_code_node_ref0 (_tmp7_);
				st = _tmp8_;
				_tmp9_ = st;
				if (_tmp9_ != NULL) {
					ValaStruct* _tmp10_;
					gint _tmp11_;
					gint* _tmp12_;
					_tmp10_ = st;
					_tmp11_ = vala_struct_get_rank (_tmp10_);
					_tmp12_ = __int_dup0 (&_tmp11_);
					_g_free0 (self->priv->rank);
					self->priv->rank = _tmp12_;
				} else {
					ValaSourceReference* _tmp13_;
					ValaSourceReference* _tmp14_;
					_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp14_ = _tmp13_;
					vala_report_error (_tmp14_, "internal error: struct has no rank");
					result = 0;
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	_tmp15_ = self->priv->rank;
	result = *_tmp15_;
	return result;
}


/**
 * Sets the rank of this integer or floating point type.
 */
void
vala_struct_set_rank (ValaStruct* self,
                      gint rank)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&rank);
	_g_free0 (self->priv->rank);
	self->priv->rank = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", rank, NULL);
	} else {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", rank, NULL);
	}
}


static gint
vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                           const gchar* name)
{
	ValaStruct * self;
	gint result = 0;
	gint i = 0;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			p = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = p;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				_vala_iterable_unref0 (_p_list);
				return result;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	result = -1;
	return result;
}


/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean
vala_struct_is_simple_type (ValaStruct* self)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_simple_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->simple_type;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaAttribute* _tmp10_;
		ValaAttribute* _tmp11_;
		gboolean _tmp12_;
		gboolean* _tmp19_;
		_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType");
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ != NULL;
		_vala_code_node_unref0 (_tmp11_);
		if (_tmp12_) {
			_tmp9_ = TRUE;
		} else {
			ValaAttribute* _tmp13_;
			ValaAttribute* _tmp14_;
			_tmp13_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp14_ != NULL;
			_vala_code_node_unref0 (_tmp14_);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			ValaAttribute* _tmp15_;
			ValaAttribute* _tmp16_;
			_tmp15_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
			_tmp16_ = _tmp15_;
			_tmp8_ = _tmp16_ != NULL;
			_vala_code_node_unref0 (_tmp16_);
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			ValaAttribute* _tmp17_;
			ValaAttribute* _tmp18_;
			_tmp17_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
			_tmp18_ = _tmp17_;
			_tmp7_ = _tmp18_ != NULL;
			_vala_code_node_unref0 (_tmp18_);
		}
		_tmp19_ = __bool_dup0 (&_tmp7_);
		_g_free0 (self->priv->simple_type);
		self->priv->simple_type = _tmp19_;
	}
	_tmp20_ = self->priv->simple_type;
	result = *_tmp20_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void
vala_struct_set_simple_type (ValaStruct* self,
                             gboolean simple_type)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&simple_type);
	_g_free0 (self->priv->simple_type);
	self->priv->simple_type = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SimpleType", simple_type, NULL);
}


static void
vala_struct_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_struct_set_base_type (self, new_type);
	}
}


static gboolean
vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                ValaTypeSymbol* t)
{
	ValaStruct * self;
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp3_ = vala_struct_get_base_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_get_data_type (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_tmp7_ = vala_struct_get_base_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp2_ = vala_typesymbol_is_subtype_of (_tmp10_, t);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean
vala_struct_is_disposable (ValaStruct* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ValaStruct* _tmp3_;
	ValaStruct* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "destroy_function", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = vala_struct_get_base_struct (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		ValaStruct* _tmp6_;
		_tmp5_ = vala_struct_get_base_struct (self);
		_tmp6_ = _tmp5_;
		result = vala_struct_is_disposable (_tmp6_);
		return result;
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _f_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _f_index = 0;
		_tmp7_ = self->priv->fields;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_f_list = _tmp8_;
		_tmp9_ = _f_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_f_size = _tmp11_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaField* f = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			ValaField* _tmp19_;
			ValaMemberBinding _tmp20_;
			ValaMemberBinding _tmp21_;
			_f_index = _f_index + 1;
			_tmp12_ = _f_index;
			_tmp13_ = _f_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _f_list;
			_tmp15_ = _f_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			f = (ValaField*) _tmp16_;
			_tmp19_ = f;
			_tmp20_ = vala_field_get_binding (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp22_;
				_tmp22_ = f;
				_tmp18_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp22_, "CCode", "delegate_target", TRUE);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaField* _tmp23_;
				ValaDataType* _tmp24_;
				ValaDataType* _tmp25_;
				_tmp23_ = f;
				_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp17_ = vala_data_type_is_disposable (_tmp25_);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				result = TRUE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	result = FALSE;
	return result;
}


static gboolean
vala_struct_is_recursive_value_type (ValaStruct* self,
                                     ValaCodeContext* context,
                                     ValaDataType* type)
{
	gboolean result = FALSE;
	ValaStructValueType* struct_type = NULL;
	gboolean _tmp0_ = FALSE;
	ValaStructValueType* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	struct_type = VALA_IS_STRUCT_VALUE_TYPE (type) ? ((ValaStructValueType*) type) : NULL;
	_tmp1_ = struct_type;
	if (_tmp1_ != NULL) {
		ValaStructValueType* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = struct_type;
		_tmp3_ = vala_data_type_get_nullable ((ValaDataType*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaStruct* st = NULL;
		ValaStructValueType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaStruct* _tmp8_;
		ValaStruct* _tmp9_;
		_tmp5_ = struct_type;
		_tmp6_ = vala_value_type_get_type_symbol ((ValaValueType*) _tmp5_);
		_tmp7_ = _tmp6_;
		st = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp8_ = st;
		if (_tmp8_ == self) {
			result = TRUE;
			return result;
		}
		_tmp9_ = st;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp9_, context)) {
			result = FALSE;
			return result;
		}
		{
			ValaList* _f_list = NULL;
			ValaStruct* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _f_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _f_index = 0;
			_tmp10_ = st;
			_tmp11_ = _tmp10_->priv->fields;
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_f_list = _tmp12_;
			_tmp13_ = _f_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_f_size = _tmp15_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaField* f = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				gboolean _tmp21_ = FALSE;
				ValaField* _tmp22_;
				ValaMemberBinding _tmp23_;
				ValaMemberBinding _tmp24_;
				_f_index = _f_index + 1;
				_tmp16_ = _f_index;
				_tmp17_ = _f_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _f_list;
				_tmp19_ = _f_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				f = (ValaField*) _tmp20_;
				_tmp22_ = f;
				_tmp23_ = vala_field_get_binding (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ == VALA_MEMBER_BINDING_INSTANCE) {
					ValaField* _tmp25_;
					ValaDataType* _tmp26_;
					ValaDataType* _tmp27_;
					_tmp25_ = f;
					_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp21_ = vala_struct_is_recursive_value_type (self, context, _tmp27_);
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					_vala_iterable_unref0 (_f_list);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_struct_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaStruct * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_;
	gboolean _tmp117_;
	ValaSemanticAnalyzer* _tmp153_;
	ValaSemanticAnalyzer* _tmp154_;
	ValaSourceFile* _tmp155_;
	ValaSemanticAnalyzer* _tmp156_;
	ValaSemanticAnalyzer* _tmp157_;
	ValaSymbol* _tmp158_;
	gboolean _tmp159_;
	gboolean _tmp160_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_struct_get_base_type (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		_tmp26_ = vala_struct_get_base_type (self);
		_tmp27_ = _tmp26_;
		vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
		_tmp28_ = vala_struct_get_base_type (self);
		_tmp29_ = _tmp28_;
		if (!VALA_IS_VALUE_TYPE (_tmp29_)) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_struct_get_base_type (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup_printf ("The base type `%s` of struct `%s` is not a struct", _tmp35_, _tmp37_);
			_tmp39_ = _tmp38_;
			vala_report_error (_tmp31_, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _p_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _p_index = 0;
		_tmp40_ = self->priv->type_parameters;
		_tmp41_ = _vala_iterable_ref0 (_tmp40_);
		_p_list = _tmp41_;
		_tmp42_ = _p_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_p_size = _tmp44_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaTypeParameter* _tmp50_;
			_p_index = _p_index + 1;
			_tmp45_ = _p_index;
			_tmp46_ = _p_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _p_list;
			_tmp48_ = _p_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			p = (ValaTypeParameter*) _tmp49_;
			_tmp50_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp50_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		gint _f_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _f_index = 0;
		_tmp51_ = self->priv->fields;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_f_list = _tmp52_;
		_tmp53_ = _f_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_f_size = _tmp55_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			ValaField* f = NULL;
			ValaList* _tmp58_;
			gint _tmp59_;
			gpointer _tmp60_;
			ValaField* _tmp61_;
			gboolean _tmp62_ = FALSE;
			ValaField* _tmp63_;
			ValaMemberBinding _tmp64_;
			ValaMemberBinding _tmp65_;
			gboolean _tmp72_ = FALSE;
			ValaField* _tmp73_;
			ValaMemberBinding _tmp74_;
			ValaMemberBinding _tmp75_;
			_f_index = _f_index + 1;
			_tmp56_ = _f_index;
			_tmp57_ = _f_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _f_list;
			_tmp59_ = _f_index;
			_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
			f = (ValaField*) _tmp60_;
			_tmp61_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp61_, context);
			_tmp63_ = f;
			_tmp64_ = vala_field_get_binding (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp66_;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				_tmp66_ = f;
				_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp62_ = vala_struct_is_recursive_value_type (self, context, _tmp68_);
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaField* _tmp69_;
				ValaSourceReference* _tmp70_;
				ValaSourceReference* _tmp71_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp69_ = f;
				_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp69_);
				_tmp71_ = _tmp70_;
				vala_report_error (_tmp71_, "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp73_ = f;
			_tmp74_ = vala_field_get_binding (_tmp73_);
			_tmp75_ = _tmp74_;
			if (_tmp75_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp76_;
				ValaExpression* _tmp77_;
				ValaExpression* _tmp78_;
				_tmp76_ = f;
				_tmp77_ = vala_variable_get_initializer ((ValaVariable*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp72_ = _tmp78_ != NULL;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ValaField* _tmp79_;
				ValaSourceReference* _tmp80_;
				ValaSourceReference* _tmp81_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp79_ = f;
				_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				vala_report_error (_tmp81_, "Instance field initializers not supported");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp82_;
		ValaList* _tmp83_;
		gint _c_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _c_index = 0;
		_tmp82_ = self->priv->constants;
		_tmp83_ = _vala_iterable_ref0 (_tmp82_);
		_c_list = _tmp83_;
		_tmp84_ = _c_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_c_size = _tmp86_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp87_;
			gint _tmp88_;
			ValaConstant* c = NULL;
			ValaList* _tmp89_;
			gint _tmp90_;
			gpointer _tmp91_;
			ValaConstant* _tmp92_;
			_c_index = _c_index + 1;
			_tmp87_ = _c_index;
			_tmp88_ = _c_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _c_list;
			_tmp90_ = _c_index;
			_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
			c = (ValaConstant*) _tmp91_;
			_tmp92_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp93_;
		ValaList* _tmp94_;
		gint _m_size = 0;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _m_index = 0;
		_tmp93_ = self->priv->methods;
		_tmp94_ = _vala_iterable_ref0 (_tmp93_);
		_m_list = _tmp94_;
		_tmp95_ = _m_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_m_size = _tmp97_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp98_;
			gint _tmp99_;
			ValaMethod* m = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaMethod* _tmp103_;
			_m_index = _m_index + 1;
			_tmp98_ = _m_index;
			_tmp99_ = _m_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _m_list;
			_tmp101_ = _m_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			m = (ValaMethod*) _tmp102_;
			_tmp103_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp104_;
		ValaList* _tmp105_;
		gint _prop_size = 0;
		ValaList* _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		gint _prop_index = 0;
		_tmp104_ = self->priv->properties;
		_tmp105_ = _vala_iterable_ref0 (_tmp104_);
		_prop_list = _tmp105_;
		_tmp106_ = _prop_list;
		_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		_prop_size = _tmp108_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp109_;
			gint _tmp110_;
			ValaProperty* prop = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaProperty* _tmp114_;
			_prop_index = _prop_index + 1;
			_tmp109_ = _prop_index;
			_tmp110_ = _prop_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _prop_list;
			_tmp112_ = _prop_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			prop = (ValaProperty*) _tmp113_;
			_tmp114_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp116_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp117_ = _tmp116_;
	if (!_tmp117_) {
		gboolean _tmp118_;
		gboolean _tmp119_;
		_tmp118_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp119_ = _tmp118_;
		_tmp115_ = !_tmp119_;
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		gboolean _tmp120_ = FALSE;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_ = FALSE;
		ValaDataType* _tmp124_;
		ValaDataType* _tmp125_;
		_tmp124_ = vala_struct_get_base_type (self);
		_tmp125_ = _tmp124_;
		if (_tmp125_ == NULL) {
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			_tmp126_ = vala_struct_get_fields (self);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp123_ = _tmp129_ == 0;
			_vala_iterable_unref0 (_tmp127_);
		} else {
			_tmp123_ = FALSE;
		}
		if (_tmp123_) {
			_tmp122_ = !vala_struct_is_boolean_type (self);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			_tmp121_ = !vala_struct_is_integer_type (self);
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			_tmp120_ = !vala_struct_is_floating_type (self);
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("structs cannot be empty: %s", _tmp133_);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp131_, _tmp135_);
			_g_free0 (_tmp135_);
		} else {
			ValaDataType* _tmp136_;
			ValaDataType* _tmp137_;
			_tmp136_ = vala_struct_get_base_type (self);
			_tmp137_ = _tmp136_;
			if (_tmp137_ != NULL) {
				{
					ValaList* _f_list = NULL;
					ValaList* _tmp138_;
					ValaList* _tmp139_;
					gint _f_size = 0;
					ValaList* _tmp140_;
					gint _tmp141_;
					gint _tmp142_;
					gint _f_index = 0;
					_tmp138_ = self->priv->fields;
					_tmp139_ = _vala_iterable_ref0 (_tmp138_);
					_f_list = _tmp139_;
					_tmp140_ = _f_list;
					_tmp141_ = vala_collection_get_size ((ValaCollection*) _tmp140_);
					_tmp142_ = _tmp141_;
					_f_size = _tmp142_;
					_f_index = -1;
					while (TRUE) {
						gint _tmp143_;
						gint _tmp144_;
						ValaField* f = NULL;
						ValaList* _tmp145_;
						gint _tmp146_;
						gpointer _tmp147_;
						ValaField* _tmp148_;
						ValaMemberBinding _tmp149_;
						ValaMemberBinding _tmp150_;
						_f_index = _f_index + 1;
						_tmp143_ = _f_index;
						_tmp144_ = _f_size;
						if (!(_tmp143_ < _tmp144_)) {
							break;
						}
						_tmp145_ = _f_list;
						_tmp146_ = _f_index;
						_tmp147_ = vala_list_get (_tmp145_, _tmp146_);
						f = (ValaField*) _tmp147_;
						_tmp148_ = f;
						_tmp149_ = vala_field_get_binding (_tmp148_);
						_tmp150_ = _tmp149_;
						if (_tmp150_ == VALA_MEMBER_BINDING_INSTANCE) {
							ValaSourceReference* _tmp151_;
							ValaSourceReference* _tmp152_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp152_ = _tmp151_;
							vala_report_error (_tmp152_, "derived structs may not have instance fields");
							_vala_code_node_unref0 (f);
							break;
						}
						_vala_code_node_unref0 (f);
					}
					_vala_iterable_unref0 (_f_list);
				}
			}
		}
	}
	_tmp153_ = vala_code_context_get_analyzer (context);
	_tmp154_ = _tmp153_;
	_tmp155_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp154_, _tmp155_);
	_tmp156_ = vala_code_context_get_analyzer (context);
	_tmp157_ = _tmp156_;
	_tmp158_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp157_, _tmp158_);
	_tmp159_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp160_ = _tmp159_;
	result = !_tmp160_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType*
vala_struct_get_base_type (ValaStruct* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}


void
vala_struct_set_base_type (ValaStruct* self,
                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) value, (ValaCodeNode*) self);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_type);
	self->priv->_base_type = _tmp0_;
}


ValaStruct*
vala_struct_get_base_struct (ValaStruct* self)
{
	ValaStruct* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = vala_data_type_get_data_type (_tmp1_);
		_tmp3_ = _tmp2_;
		result = VALA_IS_STRUCT (_tmp3_) ? ((ValaStruct*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


ValaMethod*
vala_struct_get_default_construction_method (ValaStruct* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_struct_set_default_construction_method (ValaStruct* self,
                                             ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


gboolean
vala_struct_get_is_immutable (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_is_immutable;
	result = *_tmp5_;
	return result;
}


void
vala_struct_set_is_immutable (ValaStruct* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gint
vala_struct_get_width (ValaStruct* self)
{
	gint result;
	gint* _tmp0_;
	gint* _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	if (_tmp0_ == NULL) {
		if (vala_struct_is_integer_type (self)) {
			gint _tmp1_;
			gint* _tmp2_;
			_tmp1_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", 32);
			_tmp2_ = __int_dup0 (&_tmp1_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp2_;
		} else {
			gint _tmp3_;
			gint* _tmp4_;
			_tmp3_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", 32);
			_tmp4_ = __int_dup0 (&_tmp3_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp4_;
		}
	}
	_tmp5_ = self->priv->_width;
	result = *_tmp5_;
	return result;
}


void
vala_struct_set_width (ValaStruct* self,
                       gint value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&value);
	_g_free0 (self->priv->_width);
	self->priv->_width = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", value, NULL);
	} else {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", value, NULL);
	}
}


gboolean
vala_struct_get_signed (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signed;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_signed);
		self->priv->_signed = _tmp2_;
	}
	_tmp3_ = self->priv->_signed;
	result = *_tmp3_;
	return result;
}


void
vala_struct_set_signed (ValaStruct* self,
                        gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_signed);
	self->priv->_signed = _tmp0_;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", value, NULL);
}


static void
vala_struct_class_init (ValaStructClass * klass)
{
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructPrivate));
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_struct_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_struct_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_struct_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_struct_real_add_property;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept_children;
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_struct_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_struct_real_replace_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_struct_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_struct_real_check;
}


static void
vala_struct_instance_init (ValaStruct * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	self->priv = VALA_STRUCT_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	self->priv->_base_type = NULL;
}


static void
vala_struct_finalize (ValaCodeNode * obj)
{
	ValaStruct * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_STRUCT, ValaStruct);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->boolean_type);
	_g_free0 (self->priv->integer_type);
	_g_free0 (self->priv->floating_type);
	_g_free0 (self->priv->decimal_floating_type);
	_g_free0 (self->priv->simple_type);
	_g_free0 (self->priv->rank);
	_g_free0 (self->priv->_width);
	_g_free0 (self->priv->_signed);
	_g_free0 (self->priv->_is_immutable);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}


/**
 * Represents a struct declaration in the source code.
 */
GType
vala_struct_get_type (void)
{
	static volatile gsize vala_struct_type_id__volatile = 0;
	if (g_once_init_enter (&vala_struct_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		GType vala_struct_type_id;
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
		g_once_init_leave (&vala_struct_type_id__volatile, vala_struct_type_id);
	}
	return vala_struct_type_id__volatile;
}



