/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* namespaces;
	ValaList* using_directives;
};


static gpointer vala_namespace_parent_class = NULL;

#define VALA_NAMESPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE, ValaNamespacePrivate))
static void vala_namespace_real_add_namespace (ValaSymbol* base,
                                        ValaNamespace* ns);
static void vala_namespace_real_add_class (ValaSymbol* base,
                                    ValaClass* cl);
static void vala_namespace_real_add_interface (ValaSymbol* base,
                                        ValaInterface* iface);
static void vala_namespace_real_add_struct (ValaSymbol* base,
                                     ValaStruct* st);
static void vala_namespace_real_add_enum (ValaSymbol* base,
                                   ValaEnum* en);
static void vala_namespace_real_add_error_domain (ValaSymbol* base,
                                           ValaErrorDomain* edomain);
static void vala_namespace_real_add_delegate (ValaSymbol* base,
                                       ValaDelegate* d);
static void vala_namespace_real_add_constant (ValaSymbol* base,
                                       ValaConstant* constant);
static void vala_namespace_real_add_field (ValaSymbol* base,
                                    ValaField* f);
static void vala_namespace_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_namespace_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_namespace_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_namespace_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static gchar* vala_namespace_real_to_string (ValaCodeNode* base);
static void vala_namespace_finalize (ValaCodeNode * obj);


/**
 * Creates a new namespace.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace
 */
ValaNamespace*
vala_namespace_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference)
{
	ValaNamespace* self = NULL;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaNamespace*
vala_namespace_new (const gchar* name,
                    ValaSourceReference* source_reference)
{
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}


/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void
vala_namespace_add_using_directive (ValaNamespace* self,
                                    ValaUsingDirective* ns)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->using_directives;
	vala_collection_add ((ValaCollection*) _tmp0_, ns);
}


void
vala_namespace_add_comment (ValaNamespace* self,
                            ValaComment* comment)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->comments;
	vala_collection_add ((ValaCollection*) _tmp0_, comment);
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return comment list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_namespace_get_comments (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->comments;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified namespace to this source file.
 *
 * @param ns a namespace
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_namespace_real_add_namespace (ValaSymbol* base,
                                   ValaNamespace* ns)
{
	ValaNamespace * self;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_owner ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		vala_source_file_add_node (_tmp5_, (ValaCodeNode*) ns);
	}
	_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_scope_lookup (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = VALA_IS_NAMESPACE (_tmp11_);
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaNamespace* old_ns = NULL;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ValaSymbol* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaNamespace* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		GList* _tmp160_;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_scope_lookup (_tmp14_, _tmp16_);
		old_ns = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_NAMESPACE, ValaNamespace);
		_tmp19_ = old_ns;
		_tmp20_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
			_tmp23_ = _tmp22_;
			_tmp18_ = !_tmp23_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaNamespace* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp24_ = old_ns;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp26_ = _tmp25_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp24_, _tmp26_);
		}
		{
			ValaList* _using_directive_list = NULL;
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			gint _using_directive_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _using_directive_index = 0;
			_tmp27_ = ns->priv->using_directives;
			_tmp28_ = _vala_iterable_ref0 (_tmp27_);
			_using_directive_list = _tmp28_;
			_tmp29_ = _using_directive_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_using_directive_size = _tmp31_;
			_using_directive_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				ValaUsingDirective* using_directive = NULL;
				ValaList* _tmp34_;
				gint _tmp35_;
				gpointer _tmp36_;
				ValaNamespace* _tmp37_;
				ValaUsingDirective* _tmp38_;
				_using_directive_index = _using_directive_index + 1;
				_tmp32_ = _using_directive_index;
				_tmp33_ = _using_directive_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _using_directive_list;
				_tmp35_ = _using_directive_index;
				_tmp36_ = vala_list_get (_tmp34_, _tmp35_);
				using_directive = (ValaUsingDirective*) _tmp36_;
				_tmp37_ = old_ns;
				_tmp38_ = using_directive;
				vala_namespace_add_using_directive (_tmp37_, _tmp38_);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_iterable_unref0 (_using_directive_list);
		}
		{
			ValaList* _sub_ns_list = NULL;
			ValaList* _tmp39_;
			gint _sub_ns_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _sub_ns_index = 0;
			_tmp39_ = vala_namespace_get_namespaces (ns);
			_sub_ns_list = _tmp39_;
			_tmp40_ = _sub_ns_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_sub_ns_size = _tmp42_;
			_sub_ns_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				ValaNamespace* sub_ns = NULL;
				ValaList* _tmp45_;
				gint _tmp46_;
				gpointer _tmp47_;
				ValaNamespace* _tmp48_;
				ValaNamespace* _tmp49_;
				_sub_ns_index = _sub_ns_index + 1;
				_tmp43_ = _sub_ns_index;
				_tmp44_ = _sub_ns_size;
				if (!(_tmp43_ < _tmp44_)) {
					break;
				}
				_tmp45_ = _sub_ns_list;
				_tmp46_ = _sub_ns_index;
				_tmp47_ = vala_list_get (_tmp45_, _tmp46_);
				sub_ns = (ValaNamespace*) _tmp47_;
				_tmp48_ = old_ns;
				_tmp49_ = sub_ns;
				vala_symbol_add_namespace ((ValaSymbol*) _tmp48_, _tmp49_);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_iterable_unref0 (_sub_ns_list);
		}
		{
			ValaList* _cl_list = NULL;
			ValaList* _tmp50_;
			gint _cl_size = 0;
			ValaList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _cl_index = 0;
			_tmp50_ = vala_namespace_get_classes (ns);
			_cl_list = _tmp50_;
			_tmp51_ = _cl_list;
			_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_cl_size = _tmp53_;
			_cl_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				ValaClass* cl = NULL;
				ValaList* _tmp56_;
				gint _tmp57_;
				gpointer _tmp58_;
				ValaNamespace* _tmp59_;
				ValaClass* _tmp60_;
				_cl_index = _cl_index + 1;
				_tmp54_ = _cl_index;
				_tmp55_ = _cl_size;
				if (!(_tmp54_ < _tmp55_)) {
					break;
				}
				_tmp56_ = _cl_list;
				_tmp57_ = _cl_index;
				_tmp58_ = vala_list_get (_tmp56_, _tmp57_);
				cl = (ValaClass*) _tmp58_;
				_tmp59_ = old_ns;
				_tmp60_ = cl;
				vala_symbol_add_class ((ValaSymbol*) _tmp59_, _tmp60_);
				_vala_code_node_unref0 (cl);
			}
			_vala_iterable_unref0 (_cl_list);
		}
		{
			ValaList* _st_list = NULL;
			ValaList* _tmp61_;
			gint _st_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _st_index = 0;
			_tmp61_ = vala_namespace_get_structs (ns);
			_st_list = _tmp61_;
			_tmp62_ = _st_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_st_size = _tmp64_;
			_st_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				ValaStruct* st = NULL;
				ValaList* _tmp67_;
				gint _tmp68_;
				gpointer _tmp69_;
				ValaNamespace* _tmp70_;
				ValaStruct* _tmp71_;
				_st_index = _st_index + 1;
				_tmp65_ = _st_index;
				_tmp66_ = _st_size;
				if (!(_tmp65_ < _tmp66_)) {
					break;
				}
				_tmp67_ = _st_list;
				_tmp68_ = _st_index;
				_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
				st = (ValaStruct*) _tmp69_;
				_tmp70_ = old_ns;
				_tmp71_ = st;
				vala_symbol_add_struct ((ValaSymbol*) _tmp70_, _tmp71_);
				_vala_code_node_unref0 (st);
			}
			_vala_iterable_unref0 (_st_list);
		}
		{
			ValaList* _iface_list = NULL;
			ValaList* _tmp72_;
			gint _iface_size = 0;
			ValaList* _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			gint _iface_index = 0;
			_tmp72_ = vala_namespace_get_interfaces (ns);
			_iface_list = _tmp72_;
			_tmp73_ = _iface_list;
			_tmp74_ = vala_collection_get_size ((ValaCollection*) _tmp73_);
			_tmp75_ = _tmp74_;
			_iface_size = _tmp75_;
			_iface_index = -1;
			while (TRUE) {
				gint _tmp76_;
				gint _tmp77_;
				ValaInterface* iface = NULL;
				ValaList* _tmp78_;
				gint _tmp79_;
				gpointer _tmp80_;
				ValaNamespace* _tmp81_;
				ValaInterface* _tmp82_;
				_iface_index = _iface_index + 1;
				_tmp76_ = _iface_index;
				_tmp77_ = _iface_size;
				if (!(_tmp76_ < _tmp77_)) {
					break;
				}
				_tmp78_ = _iface_list;
				_tmp79_ = _iface_index;
				_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
				iface = (ValaInterface*) _tmp80_;
				_tmp81_ = old_ns;
				_tmp82_ = iface;
				vala_symbol_add_interface ((ValaSymbol*) _tmp81_, _tmp82_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		{
			ValaList* _d_list = NULL;
			ValaList* _tmp83_;
			gint _d_size = 0;
			ValaList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _d_index = 0;
			_tmp83_ = vala_namespace_get_delegates (ns);
			_d_list = _tmp83_;
			_tmp84_ = _d_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_d_size = _tmp86_;
			_d_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaDelegate* d = NULL;
				ValaList* _tmp89_;
				gint _tmp90_;
				gpointer _tmp91_;
				ValaNamespace* _tmp92_;
				ValaDelegate* _tmp93_;
				_d_index = _d_index + 1;
				_tmp87_ = _d_index;
				_tmp88_ = _d_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _d_list;
				_tmp90_ = _d_index;
				_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
				d = (ValaDelegate*) _tmp91_;
				_tmp92_ = old_ns;
				_tmp93_ = d;
				vala_symbol_add_delegate ((ValaSymbol*) _tmp92_, _tmp93_);
				_vala_code_node_unref0 (d);
			}
			_vala_iterable_unref0 (_d_list);
		}
		{
			ValaList* _en_list = NULL;
			ValaList* _tmp94_;
			gint _en_size = 0;
			ValaList* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			gint _en_index = 0;
			_tmp94_ = vala_namespace_get_enums (ns);
			_en_list = _tmp94_;
			_tmp95_ = _en_list;
			_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
			_tmp97_ = _tmp96_;
			_en_size = _tmp97_;
			_en_index = -1;
			while (TRUE) {
				gint _tmp98_;
				gint _tmp99_;
				ValaEnum* en = NULL;
				ValaList* _tmp100_;
				gint _tmp101_;
				gpointer _tmp102_;
				ValaNamespace* _tmp103_;
				ValaEnum* _tmp104_;
				_en_index = _en_index + 1;
				_tmp98_ = _en_index;
				_tmp99_ = _en_size;
				if (!(_tmp98_ < _tmp99_)) {
					break;
				}
				_tmp100_ = _en_list;
				_tmp101_ = _en_index;
				_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
				en = (ValaEnum*) _tmp102_;
				_tmp103_ = old_ns;
				_tmp104_ = en;
				vala_symbol_add_enum ((ValaSymbol*) _tmp103_, _tmp104_);
				_vala_code_node_unref0 (en);
			}
			_vala_iterable_unref0 (_en_list);
		}
		{
			ValaList* _ed_list = NULL;
			ValaList* _tmp105_;
			gint _ed_size = 0;
			ValaList* _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			gint _ed_index = 0;
			_tmp105_ = vala_namespace_get_error_domains (ns);
			_ed_list = _tmp105_;
			_tmp106_ = _ed_list;
			_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
			_tmp108_ = _tmp107_;
			_ed_size = _tmp108_;
			_ed_index = -1;
			while (TRUE) {
				gint _tmp109_;
				gint _tmp110_;
				ValaErrorDomain* ed = NULL;
				ValaList* _tmp111_;
				gint _tmp112_;
				gpointer _tmp113_;
				ValaNamespace* _tmp114_;
				ValaErrorDomain* _tmp115_;
				_ed_index = _ed_index + 1;
				_tmp109_ = _ed_index;
				_tmp110_ = _ed_size;
				if (!(_tmp109_ < _tmp110_)) {
					break;
				}
				_tmp111_ = _ed_list;
				_tmp112_ = _ed_index;
				_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
				ed = (ValaErrorDomain*) _tmp113_;
				_tmp114_ = old_ns;
				_tmp115_ = ed;
				vala_symbol_add_error_domain ((ValaSymbol*) _tmp114_, _tmp115_);
				_vala_code_node_unref0 (ed);
			}
			_vala_iterable_unref0 (_ed_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp116_;
			gint _c_size = 0;
			ValaList* _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			gint _c_index = 0;
			_tmp116_ = vala_namespace_get_constants (ns);
			_c_list = _tmp116_;
			_tmp117_ = _c_list;
			_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
			_tmp119_ = _tmp118_;
			_c_size = _tmp119_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp120_;
				gint _tmp121_;
				ValaConstant* c = NULL;
				ValaList* _tmp122_;
				gint _tmp123_;
				gpointer _tmp124_;
				ValaNamespace* _tmp125_;
				ValaConstant* _tmp126_;
				_c_index = _c_index + 1;
				_tmp120_ = _c_index;
				_tmp121_ = _c_size;
				if (!(_tmp120_ < _tmp121_)) {
					break;
				}
				_tmp122_ = _c_list;
				_tmp123_ = _c_index;
				_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
				c = (ValaConstant*) _tmp124_;
				_tmp125_ = old_ns;
				_tmp126_ = c;
				vala_symbol_add_constant ((ValaSymbol*) _tmp125_, _tmp126_);
				_vala_code_node_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp127_;
			gint _f_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _f_index = 0;
			_tmp127_ = vala_namespace_get_fields (ns);
			_f_list = _tmp127_;
			_tmp128_ = _f_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_f_size = _tmp130_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp131_;
				gint _tmp132_;
				ValaField* f = NULL;
				ValaList* _tmp133_;
				gint _tmp134_;
				gpointer _tmp135_;
				ValaNamespace* _tmp136_;
				ValaField* _tmp137_;
				_f_index = _f_index + 1;
				_tmp131_ = _f_index;
				_tmp132_ = _f_size;
				if (!(_tmp131_ < _tmp132_)) {
					break;
				}
				_tmp133_ = _f_list;
				_tmp134_ = _f_index;
				_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
				f = (ValaField*) _tmp135_;
				_tmp136_ = old_ns;
				_tmp137_ = f;
				vala_symbol_add_field ((ValaSymbol*) _tmp136_, _tmp137_);
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp138_;
			gint _m_size = 0;
			ValaList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _m_index = 0;
			_tmp138_ = vala_namespace_get_methods (ns);
			_m_list = _tmp138_;
			_tmp139_ = _m_list;
			_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
			_tmp141_ = _tmp140_;
			_m_size = _tmp141_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp142_;
				gint _tmp143_;
				ValaMethod* m = NULL;
				ValaList* _tmp144_;
				gint _tmp145_;
				gpointer _tmp146_;
				ValaNamespace* _tmp147_;
				ValaMethod* _tmp148_;
				_m_index = _m_index + 1;
				_tmp142_ = _m_index;
				_tmp143_ = _m_size;
				if (!(_tmp142_ < _tmp143_)) {
					break;
				}
				_tmp144_ = _m_list;
				_tmp145_ = _m_index;
				_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
				m = (ValaMethod*) _tmp146_;
				_tmp147_ = old_ns;
				_tmp148_ = m;
				vala_symbol_add_method ((ValaSymbol*) _tmp147_, _tmp148_);
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp149_;
			gint _c_size = 0;
			ValaList* _tmp150_;
			gint _tmp151_;
			gint _tmp152_;
			gint _c_index = 0;
			_tmp149_ = vala_namespace_get_comments (ns);
			_c_list = _tmp149_;
			_tmp150_ = _c_list;
			_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
			_tmp152_ = _tmp151_;
			_c_size = _tmp152_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp153_;
				gint _tmp154_;
				ValaComment* c = NULL;
				ValaList* _tmp155_;
				gint _tmp156_;
				gpointer _tmp157_;
				ValaNamespace* _tmp158_;
				ValaComment* _tmp159_;
				_c_index = _c_index + 1;
				_tmp153_ = _c_index;
				_tmp154_ = _c_size;
				if (!(_tmp153_ < _tmp154_)) {
					break;
				}
				_tmp155_ = _c_list;
				_tmp156_ = _c_index;
				_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
				c = (ValaComment*) _tmp157_;
				_tmp158_ = old_ns;
				_tmp159_ = c;
				vala_namespace_add_comment (_tmp158_, _tmp159_);
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		_tmp160_ = ((ValaCodeNode*) ns)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp160_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp161_;
				ValaAttribute* a = NULL;
				_tmp161_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp161_;
				{
					ValaNamespace* _tmp162_;
					ValaAttribute* _tmp163_;
					const gchar* _tmp164_;
					const gchar* _tmp165_;
					ValaAttribute* _tmp166_;
					ValaAttribute* _tmp167_;
					gboolean _tmp168_;
					_tmp162_ = old_ns;
					_tmp163_ = a;
					_tmp164_ = vala_attribute_get_name (_tmp163_);
					_tmp165_ = _tmp164_;
					_tmp166_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp162_, _tmp165_);
					_tmp167_ = _tmp166_;
					_tmp168_ = _tmp167_ == NULL;
					_vala_code_node_unref0 (_tmp167_);
					if (_tmp168_) {
						ValaNamespace* _tmp169_;
						ValaAttribute* _tmp170_;
						ValaAttribute* _tmp171_;
						_tmp169_ = old_ns;
						_tmp170_ = a;
						_tmp171_ = _vala_code_node_ref0 (_tmp170_);
						((ValaCodeNode*) _tmp169_)->attributes = g_list_append (((ValaCodeNode*) _tmp169_)->attributes, _tmp171_);
					}
					_vala_code_node_unref0 (a);
				}
			}
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		ValaList* _tmp172_;
		ValaScope* _tmp173_;
		ValaScope* _tmp174_;
		const gchar* _tmp175_;
		const gchar* _tmp176_;
		_tmp172_ = self->priv->namespaces;
		vala_collection_add ((ValaCollection*) _tmp172_, ns);
		_tmp173_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp174_ = _tmp173_;
		_tmp175_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp176_ = _tmp175_;
		vala_scope_add (_tmp174_, _tmp176_, (ValaSymbol*) ns);
	}
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return namespace list
 */
ValaList*
vala_namespace_get_namespaces (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->namespaces;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified class to this namespace.
 *
 * @param cl a class
 */
static void
vala_namespace_real_add_class (ValaSymbol* base,
                               ValaClass* cl)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) cl);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) cl);
	}
	_tmp8_ = self->priv->classes;
	vala_collection_add ((ValaCollection*) _tmp8_, cl);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) cl);
}


/**
 * Adds the specified interface to this namespace.
 *
 * @param iface an interface
 */
static void
vala_namespace_real_add_interface (ValaSymbol* base,
                                   ValaInterface* iface)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) iface);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) iface);
	}
	_tmp8_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp8_, iface);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) iface);
}


/**
 * Adds the specified struct to this namespace.
 *
 * @param st a struct
 */
static void
vala_namespace_real_add_struct (ValaSymbol* base,
                                ValaStruct* st)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) st);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) st);
	}
	_tmp8_ = self->priv->structs;
	vala_collection_add ((ValaCollection*) _tmp8_, st);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) st);
}


/**
 * Removes the specified struct from this namespace.
 *
 * @param st a struct
 */
void
vala_namespace_remove_struct (ValaNamespace* self,
                              ValaStruct* st)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	vala_collection_remove ((ValaCollection*) _tmp0_, st);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp4_ = _tmp3_;
	vala_scope_remove (_tmp2_, _tmp4_);
}


/**
 * Adds the specified enum to this namespace.
 *
 * @param en an enum
 */
static void
vala_namespace_real_add_enum (ValaSymbol* base,
                              ValaEnum* en)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) en);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) en);
	}
	_tmp8_ = self->priv->enums;
	vala_collection_add ((ValaCollection*) _tmp8_, en);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) en);
}


/**
 * Adds the specified error domain to this namespace.
 *
 * @param edomain an error domain
 */
static void
vala_namespace_real_add_error_domain (ValaSymbol* base,
                                      ValaErrorDomain* edomain)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) edomain);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) edomain);
	}
	_tmp8_ = self->priv->error_domains;
	vala_collection_add ((ValaCollection*) _tmp8_, edomain);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) edomain);
}


/**
 * Adds the specified delegate to this namespace.
 *
 * @param d a delegate
 */
static void
vala_namespace_real_add_delegate (ValaSymbol* base,
                                  ValaDelegate* d)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) d);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) d);
	}
	_tmp8_ = self->priv->delegates;
	vala_collection_add ((ValaCollection*) _tmp8_, d);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) d);
}


/**
 * Returns a copy of the list of structs.
 *
 * @return struct list
 */
ValaList*
vala_namespace_get_structs (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of classes.
 *
 * @return class list
 */
ValaList*
vala_namespace_get_classes (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of interfaces.
 *
 * @return interface list
 */
ValaList*
vala_namespace_get_interfaces (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return enum list
 */
ValaList*
vala_namespace_get_enums (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of error domains.
 *
 * @return error domain list
 */
ValaList*
vala_namespace_get_error_domains (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->error_domains;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of fields.
 *
 * @return field list
 */
ValaList*
vala_namespace_get_fields (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return constant list
 */
ValaList*
vala_namespace_get_constants (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return delegate list
 */
ValaList*
vala_namespace_get_delegates (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of methods.
 *
 * @return method list
 */
ValaList*
vala_namespace_get_methods (ValaNamespace* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant to this namespace.
 *
 * @param constant a constant
 */
static void
vala_namespace_real_add_constant (ValaSymbol* base,
                                  ValaConstant* constant)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) constant);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) constant);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) constant);
	}
	_tmp8_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp8_, constant);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) constant);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) constant);
}


/**
 * Adds the specified field to this namespace.
 *
 * @param f a field
 */
static void
vala_namespace_real_add_field (ValaSymbol* base,
                               ValaField* f)
{
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaList* _tmp18_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	self = (ValaNamespace*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_field_get_binding (f);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_field_set_binding (f, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp2_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp4_ = vala_field_get_binding (f);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp8_;
		ValaMemberBinding _tmp9_;
		_tmp8_ = vala_field_get_binding (f);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp11_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
			return;
		}
	}
	_tmp12_ = vala_symbol_get_owner ((ValaSymbol*) f);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceFile* _tmp16_;
		ValaSourceFile* _tmp17_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_source_reference_get_file (_tmp15_);
		_tmp17_ = _tmp16_;
		vala_source_file_add_node (_tmp17_, (ValaCodeNode*) f);
	}
	_tmp18_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp18_, f);
	_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp22_ = _tmp21_;
	vala_scope_add (_tmp20_, _tmp22_, (ValaSymbol*) f);
}


/**
 * Adds the specified method to this namespace.
 *
 * @param m a method
 */
static void
vala_namespace_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	gboolean _tmp14_ = FALSE;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaList* _tmp37_;
	ValaScope* _tmp38_;
	ValaScope* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	self = (ValaNamespace*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp2_ = vala_symbol_get_access ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp6_ = vala_method_get_binding (m);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp10_;
		ValaMemberBinding _tmp11_;
		_tmp10_ = vala_method_get_binding (m);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp16_ = _tmp15_;
	if (!VALA_IS_VOID_TYPE (_tmp16_)) {
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp17_ = vala_method_get_postconditions (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_ > 0;
		_vala_iterable_unref0 (_tmp18_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaLocalVariable* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		_tmp21_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_data_type_copy (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_local_variable_new (_tmp24_, "result", NULL, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
		_vala_code_node_unref0 (_tmp24_);
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		vala_local_variable_set_is_result (_tmp30_, TRUE);
	}
	_tmp31_ = vala_symbol_get_owner ((ValaSymbol*) m);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == NULL) {
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaSourceFile* _tmp35_;
		ValaSourceFile* _tmp36_;
		_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_source_reference_get_file (_tmp34_);
		_tmp36_ = _tmp35_;
		vala_source_file_add_node (_tmp36_, (ValaCodeNode*) m);
	}
	_tmp37_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp37_, m);
	_tmp38_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp41_ = _tmp40_;
	vala_scope_add (_tmp39_, _tmp41_, (ValaSymbol*) m);
}


static void
vala_namespace_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}


static void
vala_namespace_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ns_ref_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _ns_ref_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ns_ref_index = 0;
		_tmp0_ = self->priv->using_directives;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_ns_ref_list = _tmp1_;
		_tmp2_ = _ns_ref_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ns_ref_size = _tmp4_;
		_ns_ref_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaUsingDirective* ns_ref = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaUsingDirective* _tmp10_;
			_ns_ref_index = _ns_ref_index + 1;
			_tmp5_ = _ns_ref_index;
			_tmp6_ = _ns_ref_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ns_ref_list;
			_tmp8_ = _ns_ref_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			ns_ref = (ValaUsingDirective*) _tmp9_;
			_tmp10_ = ns_ref;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_iterable_unref0 (_ns_ref_list);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _ns_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _ns_index = 0;
		_tmp11_ = self->priv->namespaces;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_ns_list = _tmp12_;
		_tmp13_ = _ns_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_ns_size = _tmp15_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaNamespace* ns = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaNamespace* _tmp21_;
			_ns_index = _ns_index + 1;
			_tmp16_ = _ns_index;
			_tmp17_ = _ns_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _ns_list;
			_tmp19_ = _ns_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			ns = (ValaNamespace*) _tmp20_;
			_tmp21_ = ns;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp22_ = self->priv->enums;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			ValaEnum* en = NULL;
			ValaList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_;
			ValaEnum* _tmp32_;
			_en_index = _en_index + 1;
			_tmp27_ = _en_index;
			_tmp28_ = _en_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _en_list;
			_tmp30_ = _en_index;
			_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
			en = (ValaEnum*) _tmp31_;
			_tmp32_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _edomain_list = NULL;
		ValaList* _tmp33_;
		ValaList* _tmp34_;
		gint _edomain_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _edomain_index = 0;
		_tmp33_ = self->priv->error_domains;
		_tmp34_ = _vala_iterable_ref0 (_tmp33_);
		_edomain_list = _tmp34_;
		_tmp35_ = _edomain_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_edomain_size = _tmp37_;
		_edomain_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			ValaErrorDomain* edomain = NULL;
			ValaList* _tmp40_;
			gint _tmp41_;
			gpointer _tmp42_;
			ValaErrorDomain* _tmp43_;
			_edomain_index = _edomain_index + 1;
			_tmp38_ = _edomain_index;
			_tmp39_ = _edomain_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _edomain_list;
			_tmp41_ = _edomain_index;
			_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
			edomain = (ValaErrorDomain*) _tmp42_;
			_tmp43_ = edomain;
			vala_code_node_accept ((ValaCodeNode*) _tmp43_, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_iterable_unref0 (_edomain_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp44_;
		ValaList* _tmp45_;
		gint _cl_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _cl_index = 0;
		_tmp44_ = self->priv->classes;
		_tmp45_ = _vala_iterable_ref0 (_tmp44_);
		_cl_list = _tmp45_;
		_tmp46_ = _cl_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_cl_size = _tmp48_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			ValaClass* cl = NULL;
			ValaList* _tmp51_;
			gint _tmp52_;
			gpointer _tmp53_;
			ValaClass* _tmp54_;
			_cl_index = _cl_index + 1;
			_tmp49_ = _cl_index;
			_tmp50_ = _cl_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _cl_list;
			_tmp52_ = _cl_index;
			_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
			cl = (ValaClass*) _tmp53_;
			_tmp54_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp54_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp55_;
		ValaList* _tmp56_;
		gint _iface_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _iface_index = 0;
		_tmp55_ = self->priv->interfaces;
		_tmp56_ = _vala_iterable_ref0 (_tmp55_);
		_iface_list = _tmp56_;
		_tmp57_ = _iface_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_iface_size = _tmp59_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			ValaInterface* iface = NULL;
			ValaList* _tmp62_;
			gint _tmp63_;
			gpointer _tmp64_;
			ValaInterface* _tmp65_;
			_iface_index = _iface_index + 1;
			_tmp60_ = _iface_index;
			_tmp61_ = _iface_size;
			if (!(_tmp60_ < _tmp61_)) {
				break;
			}
			_tmp62_ = _iface_list;
			_tmp63_ = _iface_index;
			_tmp64_ = vala_list_get (_tmp62_, _tmp63_);
			iface = (ValaInterface*) _tmp64_;
			_tmp65_ = iface;
			vala_code_node_accept ((ValaCodeNode*) _tmp65_, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp66_;
		ValaList* _tmp67_;
		gint _st_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _st_index = 0;
		_tmp66_ = self->priv->structs;
		_tmp67_ = _vala_iterable_ref0 (_tmp66_);
		_st_list = _tmp67_;
		_tmp68_ = _st_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_st_size = _tmp70_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			ValaStruct* st = NULL;
			ValaList* _tmp73_;
			gint _tmp74_;
			gpointer _tmp75_;
			ValaStruct* _tmp76_;
			_st_index = _st_index + 1;
			_tmp71_ = _st_index;
			_tmp72_ = _st_size;
			if (!(_tmp71_ < _tmp72_)) {
				break;
			}
			_tmp73_ = _st_list;
			_tmp74_ = _st_index;
			_tmp75_ = vala_list_get (_tmp73_, _tmp74_);
			st = (ValaStruct*) _tmp75_;
			_tmp76_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp76_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		gint _d_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _d_index = 0;
		_tmp77_ = self->priv->delegates;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_d_list = _tmp78_;
		_tmp79_ = _d_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_d_size = _tmp81_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaDelegate* d = NULL;
			ValaList* _tmp84_;
			gint _tmp85_;
			gpointer _tmp86_;
			ValaDelegate* _tmp87_;
			_d_index = _d_index + 1;
			_tmp82_ = _d_index;
			_tmp83_ = _d_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _d_list;
			_tmp85_ = _d_index;
			_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
			d = (ValaDelegate*) _tmp86_;
			_tmp87_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp87_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp88_;
		ValaList* _tmp89_;
		gint _c_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _c_index = 0;
		_tmp88_ = self->priv->constants;
		_tmp89_ = _vala_iterable_ref0 (_tmp88_);
		_c_list = _tmp89_;
		_tmp90_ = _c_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_c_size = _tmp92_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			ValaConstant* c = NULL;
			ValaList* _tmp95_;
			gint _tmp96_;
			gpointer _tmp97_;
			ValaConstant* _tmp98_;
			_c_index = _c_index + 1;
			_tmp93_ = _c_index;
			_tmp94_ = _c_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _c_list;
			_tmp96_ = _c_index;
			_tmp97_ = vala_list_get (_tmp95_, _tmp96_);
			c = (ValaConstant*) _tmp97_;
			_tmp98_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp98_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp99_;
		ValaList* _tmp100_;
		gint _f_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _f_index = 0;
		_tmp99_ = self->priv->fields;
		_tmp100_ = _vala_iterable_ref0 (_tmp99_);
		_f_list = _tmp100_;
		_tmp101_ = _f_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_f_size = _tmp103_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			ValaField* f = NULL;
			ValaList* _tmp106_;
			gint _tmp107_;
			gpointer _tmp108_;
			ValaField* _tmp109_;
			_f_index = _f_index + 1;
			_tmp104_ = _f_index;
			_tmp105_ = _f_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _f_list;
			_tmp107_ = _f_index;
			_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
			f = (ValaField*) _tmp108_;
			_tmp109_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp109_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp110_;
		ValaList* _tmp111_;
		gint _m_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _m_index = 0;
		_tmp110_ = self->priv->methods;
		_tmp111_ = _vala_iterable_ref0 (_tmp110_);
		_m_list = _tmp111_;
		_tmp112_ = _m_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_m_size = _tmp114_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			ValaMethod* m = NULL;
			ValaList* _tmp117_;
			gint _tmp118_;
			gpointer _tmp119_;
			ValaMethod* _tmp120_;
			_m_index = _m_index + 1;
			_tmp115_ = _m_index;
			_tmp116_ = _m_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _m_list;
			_tmp118_ = _m_index;
			_tmp119_ = vala_list_get (_tmp117_, _tmp118_);
			m = (ValaMethod*) _tmp119_;
			_tmp120_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp120_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}


static gboolean
vala_namespace_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaNamespace * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaAttribute* _tmp6_;
	gboolean _tmp15_ = FALSE;
	ValaAttribute* _tmp16_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
	a = _tmp4_;
	_tmp6_ = a;
	if (_tmp6_ != NULL) {
		ValaAttribute* _tmp7_;
		_tmp7_ = a;
		_tmp5_ = vala_attribute_has_argument (_tmp7_, "gir_namespace");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceFile* _tmp10_;
		ValaSourceFile* _tmp11_;
		ValaAttribute* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_source_reference_get_file (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = a;
		_tmp13_ = vala_attribute_get_string (_tmp12_, "gir_namespace", NULL);
		_tmp14_ = _tmp13_;
		vala_source_file_set_gir_namespace (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
	}
	_tmp16_ = a;
	if (_tmp16_ != NULL) {
		ValaAttribute* _tmp17_;
		_tmp17_ = a;
		_tmp15_ = vala_attribute_has_argument (_tmp17_, "gir_version");
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		ValaAttribute* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = a;
		_tmp23_ = vala_attribute_get_string (_tmp22_, "gir_version", NULL);
		_tmp24_ = _tmp23_;
		vala_source_file_set_gir_version (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _ns_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _ns_index = 0;
		_tmp25_ = self->priv->namespaces;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_ns_list = _tmp26_;
		_tmp27_ = _ns_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_ns_size = _tmp29_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			ValaNamespace* ns = NULL;
			ValaList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaNamespace* _tmp35_;
			_ns_index = _ns_index + 1;
			_tmp30_ = _ns_index;
			_tmp31_ = _ns_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _ns_list;
			_tmp33_ = _ns_index;
			_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
			ns = (ValaNamespace*) _tmp34_;
			_tmp35_ = ns;
			vala_code_node_check ((ValaCodeNode*) _tmp35_, context);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp36_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	result = !_tmp37_;
	_vala_code_node_unref0 (a);
	return result;
}


static gchar*
vala_namespace_real_to_string (ValaCodeNode* base)
{
	ValaNamespace * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaNamespace*) base;
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("(root namespace)");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("namespace %s", _tmp4_);
		result = _tmp5_;
		return result;
	}
}


static void
vala_namespace_class_init (ValaNamespaceClass * klass)
{
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_namespace_finalize;
	g_type_class_add_private (klass, sizeof (ValaNamespacePrivate));
	((ValaSymbolClass *) klass)->add_namespace = (void (*) (ValaSymbol*, ValaNamespace*)) vala_namespace_real_add_namespace;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_namespace_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_namespace_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_namespace_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_namespace_real_add_enum;
	((ValaSymbolClass *) klass)->add_error_domain = (void (*) (ValaSymbol*, ValaErrorDomain*)) vala_namespace_real_add_error_domain;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_namespace_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_namespace_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_namespace_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_namespace_real_add_method;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_namespace_real_check;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_namespace_real_to_string;
}


static void
vala_namespace_instance_init (ValaNamespace * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	GEqualFunc _tmp22_;
	ValaArrayList* _tmp23_;
	self->priv = VALA_NAMESPACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->classes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->interfaces = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->structs = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->enums = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->error_domains = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->delegates = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->constants = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->fields = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->methods = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, (GDestroyNotify) vala_comment_unref, _tmp18_);
	self->priv->comments = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->namespaces = (ValaList*) _tmp21_;
	_tmp22_ = g_direct_equal;
	_tmp23_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp22_);
	self->priv->using_directives = (ValaList*) _tmp23_;
}


static void
vala_namespace_finalize (ValaCodeNode * obj)
{
	ValaNamespace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_NAMESPACE, ValaNamespace);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->error_domains);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->namespaces);
	_vala_iterable_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}


/**
 * Represents a namespace declaration in the source code.
 */
GType
vala_namespace_get_type (void)
{
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
		GType vala_namespace_type_id;
		vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}



