/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gpointer vala_method_call_parent_class = NULL;

#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* expr = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaExpression* _tmp12_;
			_expr_index = _expr_index + 1;
			_tmp7_ = _expr_index;
			_tmp8_ = _expr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _expr_list;
			_tmp10_ = _expr_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			expr = (ValaExpression*) _tmp11_;
			_tmp12_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gint _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp3_ = index;
	if (_tmp3_ >= 0) {
		ValaList* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->argument_list;
		_tmp5_ = index;
		vala_list_set (_tmp4_, _tmp5_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			if (!vala_expression_is_accessible (_tmp10_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp11_ = vala_method_call_get_call (self);
	_tmp12_ = _tmp11_;
	result = vala_expression_is_accessible (_tmp12_, sym);
	return result;
}


static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	gboolean gobject_chainup = FALSE;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaClass* _tmp120_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp239_ = FALSE;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	gboolean _tmp314_ = FALSE;
	gboolean _tmp315_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp330_;
	ValaDataType* _tmp331_;
	ValaList* params = NULL;
	ValaDataType* _tmp332_;
	ValaList* _tmp333_;
	ValaDataType* _tmp334_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp407_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp408_;
	ValaIterator* _tmp409_;
	gboolean _tmp461_ = FALSE;
	ValaDataType* _tmp462_;
	gboolean _tmp486_ = FALSE;
	ValaDataType* _tmp487_;
	ValaDataType* _tmp560_;
	ValaDataType* _tmp571_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaList* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	gboolean _tmp580_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp603_;
	ValaSemanticAnalyzer* _tmp923_;
	ValaSemanticAnalyzer* _tmp924_;
	ValaDataType* _tmp925_;
	ValaList* _tmp926_;
	ValaList* _tmp927_;
	ValaList* _tmp928_;
	gboolean _tmp929_;
	gboolean _tmp957_ = FALSE;
	gboolean _tmp958_ = FALSE;
	ValaCreationMethod* _tmp959_;
	gboolean _tmp988_;
	gboolean _tmp1044_;
	gboolean _tmp1045_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp62_) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp78_) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				ValaAttribute* _tmp99_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp99_ = _tmp98_;
				_tmp91_ = _tmp99_ != NULL;
				_vala_code_node_unref0 (_tmp99_);
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp100_;
				ValaList* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp100_ = vala_method_call_get_argument_list (self);
				args = _tmp100_;
				_tmp101_ = args;
				_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ == 1) {
					ValaList* _tmp104_;
					gpointer _tmp105_;
					ValaExpression* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaSourceReference* _tmp108_;
					_tmp104_ = args;
					_tmp105_ = vala_list_get (_tmp104_, 0);
					_tmp106_ = (ValaExpression*) _tmp105_;
					_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp108_);
					_vala_code_node_unref0 (_tmp106_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp109_ = vala_method_call_get_call (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_expression_get_value_type (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = _vala_code_node_ref0 (_tmp112_);
	mtype = _tmp113_;
	_tmp114_ = vala_method_call_get_call (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_expression_get_symbol_reference (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = _tmp119_->object_type;
	gobject_chainup = _tmp117_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_SYMBOL, ValaSymbol);
	_tmp121_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp121_);
	_tmp122_ = gobject_chainup;
	if (!_tmp122_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp126_) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = VALA_IS_CREATION_METHOD (_tmp132_);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp144_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = VALA_IS_CREATION_METHOD (_tmp148_) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp159_)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (VALA_IS_CREATION_METHOD (_tmp192_)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = VALA_IS_CLASS (_tmp198_);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp214_;
				_tmp214_ = gobject_chainup;
				if (_tmp214_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaSymbol* _tmp217_;
					ValaClass* _tmp218_;
					gboolean _tmp219_ = FALSE;
					ValaClass* _tmp220_;
					ValaExpression* _tmp227_;
					ValaExpression* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaSemanticAnalyzer* _tmp230_;
					ValaClass* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaObjectType* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaDataType* _tmp238_;
					_tmp215_ = cm;
					_tmp216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp217_) ? ((ValaClass*) _tmp217_) : NULL);
					cl = _tmp218_;
					_tmp220_ = cl;
					if (_tmp220_ == NULL) {
						_tmp219_ = TRUE;
					} else {
						ValaClass* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaClass* _tmp224_;
						_tmp221_ = cl;
						_tmp222_ = vala_code_context_get_analyzer (context);
						_tmp223_ = _tmp222_;
						_tmp224_ = _tmp223_->object_type;
						_tmp219_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp221_, (ValaTypeSymbol*) _tmp224_);
					}
					if (_tmp219_) {
						ValaSourceReference* _tmp225_;
						ValaSourceReference* _tmp226_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp226_ = _tmp225_;
						vala_report_error (_tmp226_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp227_ = vala_method_call_get_call (self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_code_context_get_analyzer (context);
					_tmp230_ = _tmp229_;
					_tmp231_ = _tmp230_->object_type;
					_tmp232_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp231_);
					_tmp233_ = _tmp232_;
					vala_expression_set_value_type (_tmp228_, (ValaDataType*) _tmp233_);
					_vala_code_node_unref0 (_tmp233_);
					_tmp234_ = vala_method_call_get_call (self);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_value_type (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (_tmp237_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp238_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp240_ = vala_method_call_get_call (self);
	_tmp241_ = _tmp240_;
	if (VALA_IS_MEMBER_ACCESS (_tmp241_)) {
		gboolean _tmp242_ = FALSE;
		gboolean _tmp243_ = FALSE;
		ValaExpression* _tmp244_;
		ValaExpression* _tmp245_;
		ValaSymbol* _tmp246_;
		ValaSymbol* _tmp247_;
		_tmp244_ = vala_method_call_get_call (self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
		_tmp247_ = _tmp246_;
		if (VALA_IS_CREATION_METHOD (_tmp247_)) {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			_tmp248_ = vala_method_call_get_call (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp252_ = vala_symbol_get_parent_symbol (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp243_ = VALA_IS_STRUCT (_tmp253_);
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			_tmp242_ = TRUE;
		} else {
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp254_ = vala_method_call_get_call (self);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp242_ = VALA_IS_STRUCT (_tmp257_);
		}
		_tmp239_ = _tmp242_;
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp258_;
		ValaExpression* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaSymbol* _tmp261_;
		ValaStruct* _tmp262_;
		gboolean _tmp263_ = FALSE;
		gboolean _tmp264_ = FALSE;
		ValaStruct* _tmp265_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp281_;
		ValaObjectCreationExpression* _tmp293_;
		ValaDataType* _tmp294_;
		ValaDataType* _tmp295_;
		ValaSemanticAnalyzer* _tmp296_;
		ValaSemanticAnalyzer* _tmp297_;
		ValaList* _tmp298_;
		ValaCodeNode* _tmp299_;
		ValaCodeNode* _tmp300_;
		ValaObjectCreationExpression* _tmp301_;
		ValaObjectCreationExpression* _tmp302_;
		_tmp258_ = vala_method_call_get_call (self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp261_) ? ((ValaStruct*) _tmp261_) : NULL);
		st = _tmp262_;
		_tmp265_ = st;
		if (_tmp265_ != NULL) {
			ValaStruct* _tmp266_;
			ValaMethod* _tmp267_;
			ValaMethod* _tmp268_;
			_tmp266_ = st;
			_tmp267_ = vala_struct_get_default_construction_method (_tmp266_);
			_tmp268_ = _tmp267_;
			_tmp264_ = _tmp268_ == NULL;
		} else {
			_tmp264_ = FALSE;
		}
		if (_tmp264_) {
			gboolean _tmp269_ = FALSE;
			gboolean _tmp270_ = FALSE;
			ValaStruct* _tmp271_;
			_tmp271_ = st;
			if (vala_struct_is_boolean_type (_tmp271_)) {
				_tmp270_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp270_ = vala_struct_is_integer_type (_tmp272_);
			}
			if (_tmp270_) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp273_;
				_tmp273_ = st;
				_tmp269_ = vala_struct_is_floating_type (_tmp273_);
			}
			_tmp263_ = _tmp269_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaSourceReference* _tmp274_;
			ValaSourceReference* _tmp275_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp275_ = _tmp274_;
			vala_report_error (_tmp275_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp276_ = vala_method_call_get_call (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp279_);
		struct_creation_expression = _tmp280_;
		_tmp281_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp281_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp282_;
			gint _arg_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _arg_index = 0;
			_tmp282_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp282_;
			_tmp283_ = _arg_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_arg_size = _tmp285_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				ValaExpression* arg = NULL;
				ValaList* _tmp288_;
				gint _tmp289_;
				gpointer _tmp290_;
				ValaObjectCreationExpression* _tmp291_;
				ValaExpression* _tmp292_;
				_arg_index = _arg_index + 1;
				_tmp286_ = _arg_index;
				_tmp287_ = _arg_size;
				if (!(_tmp286_ < _tmp287_)) {
					break;
				}
				_tmp288_ = _arg_list;
				_tmp289_ = _arg_index;
				_tmp290_ = vala_list_get (_tmp288_, _tmp289_);
				arg = (ValaExpression*) _tmp290_;
				_tmp291_ = struct_creation_expression;
				_tmp292_ = arg;
				vala_object_creation_expression_add_argument (_tmp291_, _tmp292_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp293_ = struct_creation_expression;
		_tmp294_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp295_ = _tmp294_;
		vala_expression_set_target_type ((ValaExpression*) _tmp293_, _tmp295_);
		_tmp296_ = vala_code_context_get_analyzer (context);
		_tmp297_ = _tmp296_;
		_tmp298_ = _tmp297_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp298_, (ValaCodeNode*) self);
		_tmp299_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp300_ = _tmp299_;
		_tmp301_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp300_, (ValaExpression*) self, (ValaExpression*) _tmp301_);
		_tmp302_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp302_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp303_ = FALSE;
		gboolean _tmp304_ = FALSE;
		gboolean _tmp305_;
		_tmp305_ = self->priv->_is_chainup;
		if (!_tmp305_) {
			ValaExpression* _tmp306_;
			ValaExpression* _tmp307_;
			_tmp306_ = vala_method_call_get_call (self);
			_tmp307_ = _tmp306_;
			_tmp304_ = VALA_IS_MEMBER_ACCESS (_tmp307_);
		} else {
			_tmp304_ = FALSE;
		}
		if (_tmp304_) {
			ValaExpression* _tmp308_;
			ValaExpression* _tmp309_;
			ValaSymbol* _tmp310_;
			ValaSymbol* _tmp311_;
			_tmp308_ = vala_method_call_get_call (self);
			_tmp309_ = _tmp308_;
			_tmp310_ = vala_expression_get_symbol_reference (_tmp309_);
			_tmp311_ = _tmp310_;
			_tmp303_ = VALA_IS_CREATION_METHOD (_tmp311_);
		} else {
			_tmp303_ = FALSE;
		}
		if (_tmp303_) {
			ValaSourceReference* _tmp312_;
			ValaSourceReference* _tmp313_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp313_ = _tmp312_;
			vala_report_error (_tmp313_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp315_ = self->priv->_is_chainup;
	if (!_tmp315_) {
		ValaDataType* _tmp316_;
		_tmp316_ = mtype;
		_tmp314_ = VALA_IS_OBJECT_TYPE (_tmp316_);
	} else {
		_tmp314_ = FALSE;
	}
	if (_tmp314_) {
		ValaSourceReference* _tmp317_;
		ValaSourceReference* _tmp318_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp318_ = _tmp317_;
		vala_report_error (_tmp318_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp319_ = FALSE;
		ValaDataType* _tmp320_;
		_tmp320_ = mtype;
		if (_tmp320_ != NULL) {
			ValaDataType* _tmp321_;
			_tmp321_ = mtype;
			_tmp319_ = vala_data_type_is_invokable (_tmp321_);
		} else {
			_tmp319_ = FALSE;
		}
		if (_tmp319_) {
		} else {
			ValaExpression* _tmp322_;
			ValaExpression* _tmp323_;
			ValaSymbol* _tmp324_;
			ValaSymbol* _tmp325_;
			_tmp322_ = vala_method_call_get_call (self);
			_tmp323_ = _tmp322_;
			_tmp324_ = vala_expression_get_symbol_reference (_tmp323_);
			_tmp325_ = _tmp324_;
			if (VALA_IS_CLASS (_tmp325_)) {
				ValaSourceReference* _tmp326_;
				ValaSourceReference* _tmp327_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp327_ = _tmp326_;
				vala_report_error (_tmp327_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp328_;
				ValaSourceReference* _tmp329_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp329_ = _tmp328_;
				vala_report_error (_tmp329_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp330_ = mtype;
	_tmp331_ = vala_data_type_get_return_type (_tmp330_);
	ret_type = _tmp331_;
	_tmp332_ = mtype;
	_tmp333_ = vala_data_type_get_parameters (_tmp332_);
	params = _tmp333_;
	_tmp334_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp334_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp335_;
		ValaMethod* _tmp336_;
		ValaMethod* _tmp337_;
		ValaMethod* _tmp338_;
		gboolean _tmp339_ = FALSE;
		ValaMethod* _tmp340_;
		ValaMethod* _tmp377_;
		_tmp335_ = mtype;
		_tmp336_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp337_ = _tmp336_;
		_tmp338_ = _vala_code_node_ref0 (_tmp337_);
		m = _tmp338_;
		_tmp340_ = m;
		if (_tmp340_ != NULL) {
			ValaMethod* _tmp341_;
			gboolean _tmp342_;
			gboolean _tmp343_;
			_tmp341_ = m;
			_tmp342_ = vala_method_get_coroutine (_tmp341_);
			_tmp343_ = _tmp342_;
			_tmp339_ = _tmp343_;
		} else {
			_tmp339_ = FALSE;
		}
		if (_tmp339_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaMemberAccess* _tmp346_;
			gboolean _tmp347_;
			_tmp344_ = vala_method_call_get_call (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp346_;
			_tmp347_ = self->priv->_is_yield_expression;
			if (!_tmp347_) {
				ValaMemberAccess* _tmp348_;
				const gchar* _tmp349_;
				const gchar* _tmp350_;
				_tmp348_ = ma;
				_tmp349_ = vala_member_access_get_member_name (_tmp348_);
				_tmp350_ = _tmp349_;
				if (g_strcmp0 (_tmp350_, "end") != 0) {
					ValaMemberAccess* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					ValaMethod* _tmp357_;
					ValaList* _tmp358_;
					ValaVoidType* _tmp359_;
					_tmp351_ = ma;
					_tmp352_ = vala_member_access_get_member_name (_tmp351_);
					_tmp353_ = _tmp352_;
					if (g_strcmp0 (_tmp353_, "begin") != 0) {
						ValaMemberAccess* _tmp354_;
						ValaSourceReference* _tmp355_;
						ValaSourceReference* _tmp356_;
						_tmp354_ = ma;
						_tmp355_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp354_);
						_tmp356_ = _tmp355_;
						vala_report_deprecated (_tmp356_, "implicit .begin is deprecated");
					}
					_tmp357_ = m;
					_tmp358_ = vala_method_get_async_begin_parameters (_tmp357_);
					_vala_iterable_unref0 (params);
					params = _tmp358_;
					_tmp359_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp359_;
				} else {
					ValaMethod* _tmp360_;
					ValaList* _tmp361_;
					_tmp360_ = m;
					_tmp361_ = vala_method_get_async_end_parameters (_tmp360_);
					_vala_iterable_unref0 (params);
					params = _tmp361_;
				}
			} else {
				gboolean _tmp362_ = FALSE;
				ValaMemberAccess* _tmp363_;
				const gchar* _tmp364_;
				const gchar* _tmp365_;
				_tmp363_ = ma;
				_tmp364_ = vala_member_access_get_member_name (_tmp363_);
				_tmp365_ = _tmp364_;
				if (g_strcmp0 (_tmp365_, "begin") == 0) {
					_tmp362_ = TRUE;
				} else {
					ValaMemberAccess* _tmp366_;
					const gchar* _tmp367_;
					const gchar* _tmp368_;
					_tmp366_ = ma;
					_tmp367_ = vala_member_access_get_member_name (_tmp366_);
					_tmp368_ = _tmp367_;
					_tmp362_ = g_strcmp0 (_tmp368_, "end") == 0;
				}
				if (_tmp362_) {
					ValaMemberAccess* _tmp369_;
					ValaSourceReference* _tmp370_;
					ValaSourceReference* _tmp371_;
					ValaMemberAccess* _tmp372_;
					const gchar* _tmp373_;
					const gchar* _tmp374_;
					gchar* _tmp375_;
					gchar* _tmp376_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp369_ = ma;
					_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = ma;
					_tmp373_ = vala_member_access_get_member_name (_tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp374_);
					_tmp376_ = _tmp375_;
					vala_report_error (_tmp371_, _tmp376_);
					_g_free0 (_tmp376_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp377_ = m;
		if (_tmp377_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp378_;
			ValaExpression* _tmp379_;
			ValaMemberAccess* _tmp380_;
			gint n_type_params = 0;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			ValaList* _tmp383_;
			gint _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp387_;
			ValaList* _tmp388_;
			ValaList* _tmp389_;
			gint _tmp390_;
			gint _tmp391_;
			gint _tmp392_;
			gboolean _tmp393_ = FALSE;
			gint _tmp394_;
			_tmp378_ = vala_method_call_get_call (self);
			_tmp379_ = _tmp378_;
			_tmp380_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp379_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_type_parameters (_tmp381_);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_collection_get_size ((ValaCollection*) _tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = _tmp385_;
			_vala_iterable_unref0 (_tmp383_);
			n_type_params = _tmp386_;
			_tmp387_ = ma;
			_tmp388_ = vala_member_access_get_type_arguments (_tmp387_);
			_tmp389_ = _tmp388_;
			_tmp390_ = vala_collection_get_size ((ValaCollection*) _tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = _tmp391_;
			_vala_iterable_unref0 (_tmp389_);
			n_type_args = _tmp392_;
			_tmp394_ = n_type_args;
			if (_tmp394_ > 0) {
				gint _tmp395_;
				gint _tmp396_;
				_tmp395_ = n_type_args;
				_tmp396_ = n_type_params;
				_tmp393_ = _tmp395_ < _tmp396_;
			} else {
				_tmp393_ = FALSE;
			}
			if (_tmp393_) {
				ValaMemberAccess* _tmp397_;
				ValaSourceReference* _tmp398_;
				ValaSourceReference* _tmp399_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp397_ = ma;
				_tmp398_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp397_);
				_tmp399_ = _tmp398_;
				vala_report_error (_tmp399_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp400_ = FALSE;
				gint _tmp401_;
				_tmp401_ = n_type_args;
				if (_tmp401_ > 0) {
					gint _tmp402_;
					gint _tmp403_;
					_tmp402_ = n_type_args;
					_tmp403_ = n_type_params;
					_tmp400_ = _tmp402_ > _tmp403_;
				} else {
					_tmp400_ = FALSE;
				}
				if (_tmp400_) {
					ValaMemberAccess* _tmp404_;
					ValaSourceReference* _tmp405_;
					ValaSourceReference* _tmp406_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp404_ = ma;
					_tmp405_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp404_);
					_tmp406_ = _tmp405_;
					vala_report_error (_tmp406_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp407_ = vala_method_call_get_argument_list (self);
	args = _tmp407_;
	_tmp408_ = args;
	_tmp409_ = vala_iterable_iterator ((ValaIterable*) _tmp408_);
	arg_it = _tmp409_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp410_;
		ValaList* _tmp411_;
		gint _param_size = 0;
		ValaList* _tmp412_;
		gint _tmp413_;
		gint _tmp414_;
		gint _param_index = 0;
		_tmp410_ = params;
		_tmp411_ = _vala_iterable_ref0 (_tmp410_);
		_param_list = _tmp411_;
		_tmp412_ = _param_list;
		_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
		_tmp414_ = _tmp413_;
		_param_size = _tmp414_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp415_;
			gint _tmp416_;
			ValaParameter* param = NULL;
			ValaList* _tmp417_;
			gint _tmp418_;
			gpointer _tmp419_;
			ValaParameter* _tmp420_;
			ValaParameter* _tmp421_;
			gboolean _tmp422_;
			gboolean _tmp423_;
			ValaParameter* _tmp424_;
			gboolean _tmp425_;
			gboolean _tmp426_;
			ValaIterator* _tmp444_;
			_param_index = _param_index + 1;
			_tmp415_ = _param_index;
			_tmp416_ = _param_size;
			if (!(_tmp415_ < _tmp416_)) {
				break;
			}
			_tmp417_ = _param_list;
			_tmp418_ = _param_index;
			_tmp419_ = vala_list_get (_tmp417_, _tmp418_);
			param = (ValaParameter*) _tmp419_;
			_tmp420_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp420_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp421_ = param;
			_tmp422_ = vala_parameter_get_ellipsis (_tmp421_);
			_tmp423_ = _tmp422_;
			if (_tmp423_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp424_ = param;
			_tmp425_ = vala_parameter_get_params_array (_tmp424_);
			_tmp426_ = _tmp425_;
			if (_tmp426_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaArrayType* _tmp430_;
				_tmp427_ = param;
				_tmp428_ = vala_variable_get_variable_type ((ValaVariable*) _tmp427_);
				_tmp429_ = _tmp428_;
				_tmp430_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp429_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp430_;
				while (TRUE) {
					ValaIterator* _tmp431_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp432_;
					gpointer _tmp433_;
					ValaExpression* _tmp434_;
					ValaArrayType* _tmp435_;
					ValaDataType* _tmp436_;
					ValaDataType* _tmp437_;
					ValaExpression* _tmp438_;
					ValaDataType* _tmp439_;
					ValaDataType* _tmp440_;
					ValaArrayType* _tmp441_;
					gboolean _tmp442_;
					gboolean _tmp443_;
					_tmp431_ = arg_it;
					if (!vala_iterator_next (_tmp431_)) {
						break;
					}
					_tmp432_ = arg_it;
					_tmp433_ = vala_iterator_get (_tmp432_);
					arg = (ValaExpression*) _tmp433_;
					_tmp434_ = arg;
					_tmp435_ = array_type;
					_tmp436_ = vala_array_type_get_element_type (_tmp435_);
					_tmp437_ = _tmp436_;
					vala_expression_set_target_type (_tmp434_, _tmp437_);
					_tmp438_ = arg;
					_tmp439_ = vala_expression_get_target_type (_tmp438_);
					_tmp440_ = _tmp439_;
					_tmp441_ = array_type;
					_tmp442_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp441_);
					_tmp443_ = _tmp442_;
					vala_data_type_set_value_owned (_tmp440_, _tmp443_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp444_ = arg_it;
			if (vala_iterator_next (_tmp444_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp445_;
				gpointer _tmp446_;
				ValaExpression* _tmp447_;
				ValaParameter* _tmp448_;
				ValaDataType* _tmp449_;
				ValaDataType* _tmp450_;
				ValaExpression* _tmp451_;
				ValaExpression* _tmp452_;
				ValaDataType* _tmp453_;
				ValaDataType* _tmp454_;
				ValaDataType* _tmp455_;
				ValaList* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				ValaExpression* _tmp459_;
				ValaExpression* _tmp460_;
				_tmp445_ = arg_it;
				_tmp446_ = vala_iterator_get (_tmp445_);
				arg = (ValaExpression*) _tmp446_;
				_tmp447_ = arg;
				_tmp448_ = param;
				_tmp449_ = vala_variable_get_variable_type ((ValaVariable*) _tmp448_);
				_tmp450_ = _tmp449_;
				vala_expression_set_formal_target_type (_tmp447_, _tmp450_);
				_tmp451_ = arg;
				_tmp452_ = arg;
				_tmp453_ = vala_expression_get_formal_target_type (_tmp452_);
				_tmp454_ = _tmp453_;
				_tmp455_ = target_object_type;
				_tmp456_ = method_type_args;
				_tmp457_ = vala_data_type_get_actual_type (_tmp454_, _tmp455_, _tmp456_, (ValaCodeNode*) self);
				_tmp458_ = _tmp457_;
				vala_expression_set_target_type (_tmp451_, _tmp458_);
				_vala_code_node_unref0 (_tmp458_);
				_tmp459_ = arg;
				_tmp460_ = _vala_code_node_ref0 (_tmp459_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp460_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp462_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp462_)) {
		ValaDataType* _tmp463_;
		ValaMethod* _tmp464_;
		ValaMethod* _tmp465_;
		ValaAttribute* _tmp466_;
		ValaAttribute* _tmp467_;
		_tmp463_ = mtype;
		_tmp464_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp463_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp465_, "Print");
		_tmp467_ = _tmp466_;
		_tmp461_ = _tmp467_ != NULL;
		_vala_code_node_unref0 (_tmp467_);
	} else {
		_tmp461_ = FALSE;
	}
	if (_tmp461_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp468_;
		ValaSourceReference* _tmp469_;
		ValaTemplate* _tmp470_;
		ValaList* _tmp484_;
		ValaTemplate* _tmp485_;
		_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_template_new (_tmp469_);
		template = _tmp470_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp471_;
			ValaList* _tmp472_;
			gint _arg_size = 0;
			ValaList* _tmp473_;
			gint _tmp474_;
			gint _tmp475_;
			gint _arg_index = 0;
			_tmp471_ = self->priv->argument_list;
			_tmp472_ = _vala_iterable_ref0 (_tmp471_);
			_arg_list = _tmp472_;
			_tmp473_ = _arg_list;
			_tmp474_ = vala_collection_get_size ((ValaCollection*) _tmp473_);
			_tmp475_ = _tmp474_;
			_arg_size = _tmp475_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp476_;
				gint _tmp477_;
				ValaExpression* arg = NULL;
				ValaList* _tmp478_;
				gint _tmp479_;
				gpointer _tmp480_;
				ValaExpression* _tmp481_;
				ValaTemplate* _tmp482_;
				ValaExpression* _tmp483_;
				_arg_index = _arg_index + 1;
				_tmp476_ = _arg_index;
				_tmp477_ = _arg_size;
				if (!(_tmp476_ < _tmp477_)) {
					break;
				}
				_tmp478_ = _arg_list;
				_tmp479_ = _arg_index;
				_tmp480_ = vala_list_get (_tmp478_, _tmp479_);
				arg = (ValaExpression*) _tmp480_;
				_tmp481_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp481_, NULL);
				_tmp482_ = template;
				_tmp483_ = arg;
				vala_template_add_expression (_tmp482_, _tmp483_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp484_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp484_);
		_tmp485_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp485_);
		_vala_code_node_unref0 (template);
	}
	_tmp487_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp487_)) {
		ValaDataType* _tmp488_;
		ValaMethod* _tmp489_;
		ValaMethod* _tmp490_;
		gboolean _tmp491_;
		gboolean _tmp492_;
		_tmp488_ = mtype;
		_tmp489_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp488_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp490_ = _tmp489_;
		_tmp491_ = vala_method_get_printf_format (_tmp490_);
		_tmp492_ = _tmp491_;
		_tmp486_ = _tmp492_;
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp493_;
		ValaStringLiteral* _tmp541_;
		format_literal = NULL;
		_tmp493_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp493_)) {
		} else {
			ValaExpression* _tmp494_;
			_tmp494_ = last_arg;
			if (_tmp494_ != NULL) {
				ValaExpression* _tmp495_;
				ValaStringLiteral* _tmp496_;
				gboolean _tmp497_ = FALSE;
				ValaStringLiteral* _tmp498_;
				_tmp495_ = last_arg;
				_tmp496_ = vala_string_literal_get_format_literal (_tmp495_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp496_;
				_tmp498_ = format_literal;
				if (_tmp498_ == NULL) {
					ValaList* _tmp499_;
					gint _tmp500_;
					gint _tmp501_;
					ValaList* _tmp502_;
					gint _tmp503_;
					gint _tmp504_;
					_tmp499_ = args;
					_tmp500_ = vala_collection_get_size ((ValaCollection*) _tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = params;
					_tmp503_ = vala_collection_get_size ((ValaCollection*) _tmp502_);
					_tmp504_ = _tmp503_;
					_tmp497_ = _tmp501_ == (_tmp504_ - 1);
				} else {
					_tmp497_ = FALSE;
				}
				if (_tmp497_) {
					ValaStringLiteral* _tmp505_;
					ValaStringLiteral* _tmp506_;
					ValaSemanticAnalyzer* _tmp507_;
					ValaSemanticAnalyzer* _tmp508_;
					ValaDataType* _tmp509_;
					ValaDataType* _tmp510_;
					ValaDataType* _tmp511_;
					ValaList* _tmp512_;
					ValaList* _tmp513_;
					gint _tmp514_;
					gint _tmp515_;
					ValaStringLiteral* _tmp516_;
					ValaList* _tmp517_;
					ValaIterator* _tmp518_;
					_tmp505_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp505_;
					_tmp506_ = format_literal;
					_tmp507_ = vala_code_context_get_analyzer (context);
					_tmp508_ = _tmp507_;
					_tmp509_ = _tmp508_->string_type;
					_tmp510_ = vala_data_type_copy (_tmp509_);
					_tmp511_ = _tmp510_;
					vala_expression_set_target_type ((ValaExpression*) _tmp506_, _tmp511_);
					_vala_code_node_unref0 (_tmp511_);
					_tmp512_ = self->priv->argument_list;
					_tmp513_ = args;
					_tmp514_ = vala_collection_get_size ((ValaCollection*) _tmp513_);
					_tmp515_ = _tmp514_;
					_tmp516_ = format_literal;
					vala_list_insert (_tmp512_, _tmp515_ - 1, (ValaExpression*) _tmp516_);
					_tmp517_ = self->priv->argument_list;
					_tmp518_ = vala_iterable_iterator ((ValaIterable*) _tmp517_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp518_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp519_;
						ValaList* _tmp520_;
						gint _param_size = 0;
						ValaList* _tmp521_;
						gint _tmp522_;
						gint _tmp523_;
						gint _param_index = 0;
						_tmp519_ = params;
						_tmp520_ = _vala_iterable_ref0 (_tmp519_);
						_param_list = _tmp520_;
						_tmp521_ = _param_list;
						_tmp522_ = vala_collection_get_size ((ValaCollection*) _tmp521_);
						_tmp523_ = _tmp522_;
						_param_size = _tmp523_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp524_;
							gint _tmp525_;
							ValaParameter* param = NULL;
							ValaList* _tmp526_;
							gint _tmp527_;
							gpointer _tmp528_;
							ValaParameter* _tmp529_;
							gboolean _tmp530_;
							gboolean _tmp531_;
							ValaIterator* _tmp532_;
							_param_index = _param_index + 1;
							_tmp524_ = _param_index;
							_tmp525_ = _param_size;
							if (!(_tmp524_ < _tmp525_)) {
								break;
							}
							_tmp526_ = _param_list;
							_tmp527_ = _param_index;
							_tmp528_ = vala_list_get (_tmp526_, _tmp527_);
							param = (ValaParameter*) _tmp528_;
							_tmp529_ = param;
							_tmp530_ = vala_parameter_get_ellipsis (_tmp529_);
							_tmp531_ = _tmp530_;
							if (_tmp531_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp532_ = arg_it;
							vala_iterator_next (_tmp532_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp533_;
				ValaExpression* _tmp534_;
				ValaMemberAccess* _tmp535_;
				ValaMemberAccess* _tmp536_;
				_tmp533_ = vala_method_call_get_call (self);
				_tmp534_ = _tmp533_;
				_tmp535_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp534_) ? ((ValaMemberAccess*) _tmp534_) : NULL);
				ma = _tmp535_;
				_tmp536_ = ma;
				if (_tmp536_ != NULL) {
					ValaMemberAccess* _tmp537_;
					ValaExpression* _tmp538_;
					ValaExpression* _tmp539_;
					ValaStringLiteral* _tmp540_;
					_tmp537_ = ma;
					_tmp538_ = vala_member_access_get_inner (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = vala_string_literal_get_format_literal (_tmp539_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp540_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp541_ = format_literal;
		if (_tmp541_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp542_;
			gchar* _tmp543_;
			ValaSemanticAnalyzer* _tmp544_;
			ValaSemanticAnalyzer* _tmp545_;
			const gchar* _tmp546_;
			ValaIterator* _tmp547_;
			ValaSourceReference* _tmp548_;
			ValaSourceReference* _tmp549_;
			_tmp542_ = format_literal;
			_tmp543_ = vala_string_literal_eval (_tmp542_);
			format = _tmp543_;
			_tmp544_ = vala_code_context_get_analyzer (context);
			_tmp545_ = _tmp544_;
			_tmp546_ = format;
			_tmp547_ = arg_it;
			_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp549_ = _tmp548_;
			if (!vala_semantic_analyzer_check_print_format (_tmp545_, _tmp546_, _tmp547_, _tmp549_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp550_;
		gint _arg_size = 0;
		ValaList* _tmp551_;
		gint _tmp552_;
		gint _tmp553_;
		gint _arg_index = 0;
		_tmp550_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp550_;
		_tmp551_ = _arg_list;
		_tmp552_ = vala_collection_get_size ((ValaCollection*) _tmp551_);
		_tmp553_ = _tmp552_;
		_arg_size = _tmp553_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp554_;
			gint _tmp555_;
			ValaExpression* arg = NULL;
			ValaList* _tmp556_;
			gint _tmp557_;
			gpointer _tmp558_;
			ValaExpression* _tmp559_;
			_arg_index = _arg_index + 1;
			_tmp554_ = _arg_index;
			_tmp555_ = _arg_size;
			if (!(_tmp554_ < _tmp555_)) {
				break;
			}
			_tmp556_ = _arg_list;
			_tmp557_ = _arg_index;
			_tmp558_ = vala_list_get (_tmp556_, _tmp557_);
			arg = (ValaExpression*) _tmp558_;
			_tmp559_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp559_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp560_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp560_)) {
		gboolean _tmp561_ = FALSE;
		gboolean _tmp562_ = FALSE;
		ValaCodeNode* _tmp563_;
		ValaCodeNode* _tmp564_;
		_tmp563_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp564_ = _tmp563_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp564_)) {
			ValaCodeNode* _tmp565_;
			ValaCodeNode* _tmp566_;
			_tmp565_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp566_ = _tmp565_;
			_tmp562_ = !VALA_IS_FOR_STATEMENT (_tmp566_);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaCodeNode* _tmp567_;
			ValaCodeNode* _tmp568_;
			_tmp567_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp568_ = _tmp567_;
			_tmp561_ = !VALA_IS_YIELD_STATEMENT (_tmp568_);
		} else {
			_tmp561_ = FALSE;
		}
		if (_tmp561_) {
			ValaSourceReference* _tmp569_;
			ValaSourceReference* _tmp570_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp570_ = _tmp569_;
			vala_report_error (_tmp570_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp571_ = ret_type;
	_tmp572_ = vala_data_type_copy (_tmp571_);
	_tmp573_ = _tmp572_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp573_);
	_vala_code_node_unref0 (_tmp573_);
	_tmp574_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp575_ = _tmp574_;
	_tmp576_ = target_object_type;
	_tmp577_ = method_type_args;
	_tmp578_ = vala_data_type_get_actual_type (_tmp575_, _tmp576_, _tmp577_, (ValaCodeNode*) self);
	_tmp579_ = _tmp578_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp579_);
	_vala_code_node_unref0 (_tmp579_);
	_tmp580_ = self->priv->_is_yield_expression;
	if (_tmp580_) {
		gboolean _tmp581_ = FALSE;
		ValaDataType* _tmp582_;
		gboolean _tmp590_ = FALSE;
		ValaSemanticAnalyzer* _tmp591_;
		ValaSemanticAnalyzer* _tmp592_;
		ValaMethod* _tmp593_;
		ValaMethod* _tmp594_;
		_tmp582_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp582_)) {
			_tmp581_ = TRUE;
		} else {
			ValaDataType* _tmp583_;
			ValaMethod* _tmp584_;
			ValaMethod* _tmp585_;
			gboolean _tmp586_;
			gboolean _tmp587_;
			_tmp583_ = mtype;
			_tmp584_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp583_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_method_get_coroutine (_tmp585_);
			_tmp587_ = _tmp586_;
			_tmp581_ = !_tmp587_;
		}
		if (_tmp581_) {
			ValaSourceReference* _tmp588_;
			ValaSourceReference* _tmp589_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp589_ = _tmp588_;
			vala_report_error (_tmp589_, "yield expression requires async method");
		}
		_tmp591_ = vala_code_context_get_analyzer (context);
		_tmp592_ = _tmp591_;
		_tmp593_ = vala_semantic_analyzer_get_current_method (_tmp592_);
		_tmp594_ = _tmp593_;
		if (_tmp594_ == NULL) {
			_tmp590_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp595_;
			ValaSemanticAnalyzer* _tmp596_;
			ValaMethod* _tmp597_;
			ValaMethod* _tmp598_;
			gboolean _tmp599_;
			gboolean _tmp600_;
			_tmp595_ = vala_code_context_get_analyzer (context);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_semantic_analyzer_get_current_method (_tmp596_);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_method_get_coroutine (_tmp598_);
			_tmp600_ = _tmp599_;
			_tmp590_ = !_tmp600_;
		}
		if (_tmp590_) {
			ValaSourceReference* _tmp601_;
			ValaSourceReference* _tmp602_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp602_ = _tmp601_;
			vala_report_error (_tmp602_, "yield expression not available outside async method");
		}
	}
	may_throw = FALSE;
	_tmp603_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp603_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp604_;
		ValaMethod* _tmp605_;
		ValaMethod* _tmp606_;
		ValaMethod* _tmp607_;
		gboolean _tmp608_ = FALSE;
		gboolean _tmp609_ = FALSE;
		gboolean _tmp610_ = FALSE;
		ValaMethod* _tmp611_;
		ValaMethod* _tmp636_;
		gboolean _tmp637_;
		gboolean _tmp638_;
		ValaMethod* _tmp641_;
		gboolean _tmp642_;
		gboolean _tmp643_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp671_;
		ValaSymbol* _tmp672_;
		ValaSymbol* _tmp673_;
		gboolean _tmp674_ = FALSE;
		ValaSignal* _tmp675_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp688_;
		ValaSymbol* _tmp689_;
		ValaSymbol* _tmp690_;
		ValaDynamicSignal* _tmp691_;
		gboolean _tmp692_ = FALSE;
		ValaDynamicSignal* _tmp693_;
		gboolean _tmp739_ = FALSE;
		ValaMethod* _tmp740_;
		gboolean _tmp862_ = FALSE;
		ValaMethod* _tmp863_;
		_tmp604_ = mtype;
		_tmp605_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp606_ = _tmp605_;
		_tmp607_ = _vala_code_node_ref0 (_tmp606_);
		m = _tmp607_;
		_tmp611_ = m;
		if (_tmp611_ != NULL) {
			ValaMethod* _tmp612_;
			gboolean _tmp613_;
			gboolean _tmp614_;
			_tmp612_ = m;
			_tmp613_ = vala_method_get_coroutine (_tmp612_);
			_tmp614_ = _tmp613_;
			_tmp610_ = _tmp614_;
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
			gboolean _tmp615_;
			_tmp615_ = self->priv->_is_yield_expression;
			_tmp609_ = !_tmp615_;
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			const gchar* _tmp618_;
			const gchar* _tmp619_;
			_tmp616_ = vala_method_call_get_call (self);
			_tmp617_ = _tmp616_;
			_tmp618_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp619_ = _tmp618_;
			_tmp608_ = g_strcmp0 (_tmp619_, "end") != 0;
		} else {
			_tmp608_ = FALSE;
		}
		if (_tmp608_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp620_;
				ValaList* _tmp621_;
				gint _error_type_size = 0;
				ValaList* _tmp622_;
				gint _tmp623_;
				gint _tmp624_;
				gint _error_type_index = 0;
				_tmp620_ = m;
				_tmp621_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp620_);
				_error_type_list = _tmp621_;
				_tmp622_ = _error_type_list;
				_tmp623_ = vala_collection_get_size ((ValaCollection*) _tmp622_);
				_tmp624_ = _tmp623_;
				_error_type_size = _tmp624_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp625_;
					gint _tmp626_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp627_;
					gint _tmp628_;
					gpointer _tmp629_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp630_;
					ValaDataType* _tmp631_;
					ValaDataType* _tmp632_;
					ValaSourceReference* _tmp633_;
					ValaSourceReference* _tmp634_;
					ValaDataType* _tmp635_;
					_error_type_index = _error_type_index + 1;
					_tmp625_ = _error_type_index;
					_tmp626_ = _error_type_size;
					if (!(_tmp625_ < _tmp626_)) {
						break;
					}
					_tmp627_ = _error_type_list;
					_tmp628_ = _error_type_index;
					_tmp629_ = vala_list_get (_tmp627_, _tmp628_);
					error_type = (ValaDataType*) _tmp629_;
					may_throw = TRUE;
					_tmp630_ = error_type;
					_tmp631_ = vala_data_type_copy (_tmp630_);
					call_error_type = _tmp631_;
					_tmp632_ = call_error_type;
					_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp634_ = _tmp633_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp632_, _tmp634_);
					_tmp635_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp635_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp636_ = m;
		_tmp637_ = vala_method_get_returns_floating_reference (_tmp636_);
		_tmp638_ = _tmp637_;
		if (_tmp638_) {
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			_tmp639_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp640_ = _tmp639_;
			vala_data_type_set_floating_reference (_tmp640_, TRUE);
		}
		_tmp641_ = m;
		_tmp642_ = vala_method_get_returns_modified_pointer (_tmp641_);
		_tmp643_ = _tmp642_;
		if (_tmp643_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaExpression* _tmp646_;
			ValaExpression* _tmp647_;
			ValaExpression* _tmp648_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp649_;
			ValaSymbol* _tmp650_;
			ValaSymbol* _tmp651_;
			gboolean _tmp652_ = FALSE;
			ValaProperty* _tmp653_;
			_tmp644_ = vala_method_call_get_call (self);
			_tmp645_ = _tmp644_;
			_tmp646_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp645_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp647_ = _tmp646_;
			inner = _tmp647_;
			_tmp648_ = inner;
			vala_expression_set_lvalue (_tmp648_, TRUE);
			_tmp649_ = inner;
			_tmp650_ = vala_expression_get_symbol_reference (_tmp649_);
			_tmp651_ = _tmp650_;
			prop = VALA_IS_PROPERTY (_tmp651_) ? ((ValaProperty*) _tmp651_) : NULL;
			_tmp653_ = prop;
			if (_tmp653_ != NULL) {
				gboolean _tmp654_ = FALSE;
				ValaProperty* _tmp655_;
				ValaPropertyAccessor* _tmp656_;
				ValaPropertyAccessor* _tmp657_;
				_tmp655_ = prop;
				_tmp656_ = vala_property_get_set_accessor (_tmp655_);
				_tmp657_ = _tmp656_;
				if (_tmp657_ == NULL) {
					_tmp654_ = TRUE;
				} else {
					ValaProperty* _tmp658_;
					ValaPropertyAccessor* _tmp659_;
					ValaPropertyAccessor* _tmp660_;
					gboolean _tmp661_;
					gboolean _tmp662_;
					_tmp658_ = prop;
					_tmp659_ = vala_property_get_set_accessor (_tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_property_accessor_get_writable (_tmp660_);
					_tmp662_ = _tmp661_;
					_tmp654_ = !_tmp662_;
				}
				_tmp652_ = _tmp654_;
			} else {
				_tmp652_ = FALSE;
			}
			if (_tmp652_) {
				ValaExpression* _tmp663_;
				ValaSourceReference* _tmp664_;
				ValaSourceReference* _tmp665_;
				ValaProperty* _tmp666_;
				gchar* _tmp667_;
				gchar* _tmp668_;
				gchar* _tmp669_;
				gchar* _tmp670_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp663_ = inner;
				_tmp664_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp663_);
				_tmp665_ = _tmp664_;
				_tmp666_ = prop;
				_tmp667_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = g_strdup_printf ("Property `%s' is read-only", _tmp668_);
				_tmp670_ = _tmp669_;
				vala_report_error (_tmp665_, _tmp670_);
				_g_free0 (_tmp670_);
				_g_free0 (_tmp668_);
			}
		}
		_tmp671_ = m;
		_tmp672_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp671_);
		_tmp673_ = _tmp672_;
		sig = VALA_IS_SIGNAL (_tmp673_) ? ((ValaSignal*) _tmp673_) : NULL;
		_tmp675_ = sig;
		if (_tmp675_ != NULL) {
			ValaMethod* _tmp676_;
			const gchar* _tmp677_;
			const gchar* _tmp678_;
			_tmp676_ = m;
			_tmp677_ = vala_symbol_get_name ((ValaSymbol*) _tmp676_);
			_tmp678_ = _tmp677_;
			_tmp674_ = g_strcmp0 (_tmp678_, "disconnect") == 0;
		} else {
			_tmp674_ = FALSE;
		}
		if (_tmp674_) {
			gboolean _tmp679_ = FALSE;
			ValaList* _tmp680_;
			gboolean _tmp681_;
			gboolean _tmp682_;
			_tmp680_ = self->priv->argument_list;
			_tmp681_ = vala_collection_get_is_empty ((ValaCollection*) _tmp680_);
			_tmp682_ = _tmp681_;
			if (!_tmp682_) {
				ValaList* _tmp683_;
				gpointer _tmp684_;
				ValaExpression* _tmp685_;
				_tmp683_ = self->priv->argument_list;
				_tmp684_ = vala_list_get (_tmp683_, 0);
				_tmp685_ = (ValaExpression*) _tmp684_;
				_tmp679_ = VALA_IS_LAMBDA_EXPRESSION (_tmp685_);
				_vala_code_node_unref0 (_tmp685_);
			} else {
				_tmp679_ = FALSE;
			}
			if (_tmp679_) {
				ValaSourceReference* _tmp686_;
				ValaSourceReference* _tmp687_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp686_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp687_ = _tmp686_;
				vala_report_error (_tmp687_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_code_node_unref0 (m);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp688_ = m;
		_tmp689_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp688_);
		_tmp690_ = _tmp689_;
		_tmp691_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_SIGNAL (_tmp690_) ? ((ValaDynamicSignal*) _tmp690_) : NULL);
		dynamic_sig = _tmp691_;
		_tmp693_ = dynamic_sig;
		if (_tmp693_ != NULL) {
			ValaDynamicSignal* _tmp694_;
			ValaExpression* _tmp695_;
			ValaExpression* _tmp696_;
			_tmp694_ = dynamic_sig;
			_tmp695_ = vala_dynamic_signal_get_handler (_tmp694_);
			_tmp696_ = _tmp695_;
			_tmp692_ = _tmp696_ != NULL;
		} else {
			_tmp692_ = FALSE;
		}
		if (_tmp692_) {
			ValaDynamicSignal* _tmp697_;
			ValaDynamicSignal* _tmp698_;
			ValaExpression* _tmp699_;
			ValaExpression* _tmp700_;
			ValaDataType* _tmp701_;
			ValaDataType* _tmp702_;
			ValaDataType* _tmp703_;
			ValaDataType* _tmp704_;
			ValaDataType* _tmp705_;
			ValaDataType* _tmp706_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp726_;
			ValaExpression* _tmp727_;
			ValaExpression* _tmp728_;
			ValaDynamicSignal* _tmp729_;
			ValaDynamicSignal* _tmp730_;
			ValaSymbol* _tmp731_;
			ValaSymbol* _tmp732_;
			ValaObjectType* _tmp733_;
			ValaObjectType* _tmp734_;
			ValaDelegate* _tmp735_;
			ValaDelegate* _tmp736_;
			ValaDelegateType* _tmp737_;
			ValaDelegateType* _tmp738_;
			_tmp697_ = dynamic_sig;
			_tmp698_ = dynamic_sig;
			_tmp699_ = vala_dynamic_signal_get_handler (_tmp698_);
			_tmp700_ = _tmp699_;
			_tmp701_ = vala_expression_get_value_type (_tmp700_);
			_tmp702_ = _tmp701_;
			_tmp703_ = vala_data_type_get_return_type (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_data_type_copy (_tmp704_);
			_tmp706_ = _tmp705_;
			vala_callable_set_return_type ((ValaCallable*) _tmp697_, _tmp706_);
			_vala_code_node_unref0 (_tmp706_);
			_vala_code_node_unref0 (_tmp704_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp707_;
				ValaExpression* _tmp708_;
				ValaExpression* _tmp709_;
				ValaDataType* _tmp710_;
				ValaDataType* _tmp711_;
				ValaList* _tmp712_;
				gint _param_size = 0;
				ValaList* _tmp713_;
				gint _tmp714_;
				gint _tmp715_;
				gint _param_index = 0;
				_tmp707_ = dynamic_sig;
				_tmp708_ = vala_dynamic_signal_get_handler (_tmp707_);
				_tmp709_ = _tmp708_;
				_tmp710_ = vala_expression_get_value_type (_tmp709_);
				_tmp711_ = _tmp710_;
				_tmp712_ = vala_data_type_get_parameters (_tmp711_);
				_param_list = _tmp712_;
				_tmp713_ = _param_list;
				_tmp714_ = vala_collection_get_size ((ValaCollection*) _tmp713_);
				_tmp715_ = _tmp714_;
				_param_size = _tmp715_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp716_;
					gint _tmp717_;
					ValaParameter* param = NULL;
					ValaList* _tmp718_;
					gint _tmp719_;
					gpointer _tmp720_;
					gboolean _tmp721_;
					_param_index = _param_index + 1;
					_tmp716_ = _param_index;
					_tmp717_ = _param_size;
					if (!(_tmp716_ < _tmp717_)) {
						break;
					}
					_tmp718_ = _param_list;
					_tmp719_ = _param_index;
					_tmp720_ = vala_list_get (_tmp718_, _tmp719_);
					param = (ValaParameter*) _tmp720_;
					_tmp721_ = first;
					if (_tmp721_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp722_;
						ValaParameter* _tmp723_;
						ValaParameter* _tmp724_;
						ValaParameter* _tmp725_;
						_tmp722_ = dynamic_sig;
						_tmp723_ = param;
						_tmp724_ = vala_parameter_copy (_tmp723_);
						_tmp725_ = _tmp724_;
						vala_callable_add_parameter ((ValaCallable*) _tmp722_, _tmp725_);
						_vala_code_node_unref0 (_tmp725_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp726_ = dynamic_sig;
			_tmp727_ = vala_dynamic_signal_get_handler (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp729_ = dynamic_sig;
			_tmp730_ = dynamic_sig;
			_tmp731_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp730_);
			_tmp732_ = _tmp731_;
			_tmp733_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp732_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp734_ = _tmp733_;
			_tmp735_ = vala_signal_get_delegate ((ValaSignal*) _tmp729_, (ValaDataType*) _tmp734_, (ValaCodeNode*) self);
			_tmp736_ = _tmp735_;
			_tmp737_ = vala_delegate_type_new (_tmp736_);
			_tmp738_ = _tmp737_;
			vala_expression_set_target_type (_tmp728_, (ValaDataType*) _tmp738_);
			_vala_code_node_unref0 (_tmp738_);
			_vala_code_node_unref0 (_tmp736_);
			_vala_code_node_unref0 (_tmp734_);
		}
		_tmp740_ = m;
		if (_tmp740_ != NULL) {
			ValaMethod* _tmp741_;
			ValaList* _tmp742_;
			ValaList* _tmp743_;
			gint _tmp744_;
			gint _tmp745_;
			_tmp741_ = m;
			_tmp742_ = vala_method_get_type_parameters (_tmp741_);
			_tmp743_ = _tmp742_;
			_tmp744_ = vala_collection_get_size ((ValaCollection*) _tmp743_);
			_tmp745_ = _tmp744_;
			_tmp739_ = _tmp745_ > 0;
			_vala_iterable_unref0 (_tmp743_);
		} else {
			_tmp739_ = FALSE;
		}
		if (_tmp739_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp746_;
			ValaExpression* _tmp747_;
			ValaMemberAccess* _tmp748_;
			ValaMemberAccess* _tmp749_;
			ValaList* _tmp750_;
			ValaList* _tmp751_;
			gint _tmp752_;
			gint _tmp753_;
			gboolean _tmp754_;
			_tmp746_ = vala_method_call_get_call (self);
			_tmp747_ = _tmp746_;
			_tmp748_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp748_;
			_tmp749_ = ma;
			_tmp750_ = vala_member_access_get_type_arguments (_tmp749_);
			_tmp751_ = _tmp750_;
			_tmp752_ = vala_collection_get_size ((ValaCollection*) _tmp751_);
			_tmp753_ = _tmp752_;
			_tmp754_ = _tmp753_ == 0;
			_vala_iterable_unref0 (_tmp751_);
			if (_tmp754_) {
				ValaList* _tmp826_;
				ValaIterator* _tmp827_;
				ValaDataType* _tmp856_;
				ValaDataType* _tmp857_;
				ValaDataType* _tmp858_;
				ValaList* _tmp859_;
				ValaDataType* _tmp860_;
				ValaDataType* _tmp861_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp755_;
					ValaList* _tmp756_;
					gint _type_param_size = 0;
					ValaList* _tmp757_;
					gint _tmp758_;
					gint _tmp759_;
					gint _type_param_index = 0;
					_tmp755_ = m;
					_tmp756_ = vala_method_get_type_parameters (_tmp755_);
					_type_param_list = _tmp756_;
					_tmp757_ = _type_param_list;
					_tmp758_ = vala_collection_get_size ((ValaCollection*) _tmp757_);
					_tmp759_ = _tmp758_;
					_type_param_size = _tmp759_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp760_;
						gint _tmp761_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp762_;
						gint _tmp763_;
						gpointer _tmp764_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp765_;
						ValaIterator* _tmp766_;
						gboolean _tmp804_ = FALSE;
						ValaDataType* _tmp805_;
						ValaDataType* _tmp815_;
						ValaMemberAccess* _tmp824_;
						ValaDataType* _tmp825_;
						_type_param_index = _type_param_index + 1;
						_tmp760_ = _type_param_index;
						_tmp761_ = _type_param_size;
						if (!(_tmp760_ < _tmp761_)) {
							break;
						}
						_tmp762_ = _type_param_list;
						_tmp763_ = _type_param_index;
						_tmp764_ = vala_list_get (_tmp762_, _tmp763_);
						type_param = (ValaTypeParameter*) _tmp764_;
						type_arg = NULL;
						_tmp765_ = args;
						_tmp766_ = vala_iterable_iterator ((ValaIterable*) _tmp765_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp766_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp767_;
							ValaList* _tmp768_;
							gint _param_size = 0;
							ValaList* _tmp769_;
							gint _tmp770_;
							gint _tmp771_;
							gint _param_index = 0;
							_tmp767_ = params;
							_tmp768_ = _vala_iterable_ref0 (_tmp767_);
							_param_list = _tmp768_;
							_tmp769_ = _param_list;
							_tmp770_ = vala_collection_get_size ((ValaCollection*) _tmp769_);
							_tmp771_ = _tmp770_;
							_param_size = _tmp771_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp772_;
								gint _tmp773_;
								ValaParameter* param = NULL;
								ValaList* _tmp774_;
								gint _tmp775_;
								gpointer _tmp776_;
								gboolean _tmp777_ = FALSE;
								ValaParameter* _tmp778_;
								gboolean _tmp779_;
								gboolean _tmp780_;
								ValaIterator* _tmp784_;
								_param_index = _param_index + 1;
								_tmp772_ = _param_index;
								_tmp773_ = _param_size;
								if (!(_tmp772_ < _tmp773_)) {
									break;
								}
								_tmp774_ = _param_list;
								_tmp775_ = _param_index;
								_tmp776_ = vala_list_get (_tmp774_, _tmp775_);
								param = (ValaParameter*) _tmp776_;
								_tmp778_ = param;
								_tmp779_ = vala_parameter_get_ellipsis (_tmp778_);
								_tmp780_ = _tmp779_;
								if (_tmp780_) {
									_tmp777_ = TRUE;
								} else {
									ValaParameter* _tmp781_;
									gboolean _tmp782_;
									gboolean _tmp783_;
									_tmp781_ = param;
									_tmp782_ = vala_parameter_get_params_array (_tmp781_);
									_tmp783_ = _tmp782_;
									_tmp777_ = _tmp783_;
								}
								if (_tmp777_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp784_ = arg_it;
								if (vala_iterator_next (_tmp784_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp785_;
									gpointer _tmp786_;
									ValaParameter* _tmp787_;
									ValaDataType* _tmp788_;
									ValaDataType* _tmp789_;
									ValaTypeParameter* _tmp790_;
									ValaExpression* _tmp791_;
									ValaDataType* _tmp792_;
									ValaDataType* _tmp793_;
									ValaDataType* _tmp794_;
									ValaDataType* _tmp795_;
									ValaExpression* _tmp796_;
									ValaExpression* _tmp797_;
									ValaDataType* _tmp798_;
									ValaDataType* _tmp799_;
									ValaDataType* _tmp800_;
									ValaList* _tmp801_;
									ValaDataType* _tmp802_;
									ValaDataType* _tmp803_;
									_tmp785_ = arg_it;
									_tmp786_ = vala_iterator_get (_tmp785_);
									arg = (ValaExpression*) _tmp786_;
									_tmp787_ = param;
									_tmp788_ = vala_variable_get_variable_type ((ValaVariable*) _tmp787_);
									_tmp789_ = _tmp788_;
									_tmp790_ = type_param;
									_tmp791_ = arg;
									_tmp792_ = vala_expression_get_value_type (_tmp791_);
									_tmp793_ = _tmp792_;
									_tmp794_ = vala_data_type_infer_type_argument (_tmp789_, _tmp790_, _tmp793_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp794_;
									_tmp795_ = type_arg;
									if (_tmp795_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp796_ = arg;
									_tmp797_ = arg;
									_tmp798_ = vala_expression_get_formal_target_type (_tmp797_);
									_tmp799_ = _tmp798_;
									_tmp800_ = target_object_type;
									_tmp801_ = method_type_args;
									_tmp802_ = vala_data_type_get_actual_type (_tmp799_, _tmp800_, _tmp801_, (ValaCodeNode*) self);
									_tmp803_ = _tmp802_;
									vala_expression_set_target_type (_tmp796_, _tmp803_);
									_vala_code_node_unref0 (_tmp803_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp805_ = type_arg;
						if (_tmp805_ == NULL) {
							ValaDataType* _tmp806_;
							ValaDataType* _tmp807_;
							_tmp806_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp807_ = _tmp806_;
							_tmp804_ = _tmp807_ != NULL;
						} else {
							_tmp804_ = FALSE;
						}
						if (_tmp804_) {
							ValaMethod* _tmp808_;
							ValaDataType* _tmp809_;
							ValaDataType* _tmp810_;
							ValaTypeParameter* _tmp811_;
							ValaDataType* _tmp812_;
							ValaDataType* _tmp813_;
							ValaDataType* _tmp814_;
							_tmp808_ = m;
							_tmp809_ = vala_callable_get_return_type ((ValaCallable*) _tmp808_);
							_tmp810_ = _tmp809_;
							_tmp811_ = type_param;
							_tmp812_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp813_ = _tmp812_;
							_tmp814_ = vala_data_type_infer_type_argument (_tmp810_, _tmp811_, _tmp813_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp814_;
						}
						_tmp815_ = type_arg;
						if (_tmp815_ == NULL) {
							ValaMemberAccess* _tmp816_;
							ValaSourceReference* _tmp817_;
							ValaSourceReference* _tmp818_;
							ValaTypeParameter* _tmp819_;
							gchar* _tmp820_;
							gchar* _tmp821_;
							gchar* _tmp822_;
							gchar* _tmp823_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp816_ = ma;
							_tmp817_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp816_);
							_tmp818_ = _tmp817_;
							_tmp819_ = type_param;
							_tmp820_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp819_);
							_tmp821_ = _tmp820_;
							_tmp822_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp821_);
							_tmp823_ = _tmp822_;
							vala_report_error (_tmp818_, _tmp823_);
							_g_free0 (_tmp823_);
							_g_free0 (_tmp821_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp824_ = ma;
						_tmp825_ = type_arg;
						vala_member_access_add_type_argument (_tmp824_, _tmp825_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp826_ = args;
				_tmp827_ = vala_iterable_iterator ((ValaIterable*) _tmp826_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp827_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp828_;
					ValaList* _tmp829_;
					gint _param_size = 0;
					ValaList* _tmp830_;
					gint _tmp831_;
					gint _tmp832_;
					gint _param_index = 0;
					_tmp828_ = params;
					_tmp829_ = _vala_iterable_ref0 (_tmp828_);
					_param_list = _tmp829_;
					_tmp830_ = _param_list;
					_tmp831_ = vala_collection_get_size ((ValaCollection*) _tmp830_);
					_tmp832_ = _tmp831_;
					_param_size = _tmp832_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp833_;
						gint _tmp834_;
						ValaParameter* param = NULL;
						ValaList* _tmp835_;
						gint _tmp836_;
						gpointer _tmp837_;
						gboolean _tmp838_ = FALSE;
						ValaParameter* _tmp839_;
						gboolean _tmp840_;
						gboolean _tmp841_;
						ValaIterator* _tmp845_;
						_param_index = _param_index + 1;
						_tmp833_ = _param_index;
						_tmp834_ = _param_size;
						if (!(_tmp833_ < _tmp834_)) {
							break;
						}
						_tmp835_ = _param_list;
						_tmp836_ = _param_index;
						_tmp837_ = vala_list_get (_tmp835_, _tmp836_);
						param = (ValaParameter*) _tmp837_;
						_tmp839_ = param;
						_tmp840_ = vala_parameter_get_ellipsis (_tmp839_);
						_tmp841_ = _tmp840_;
						if (_tmp841_) {
							_tmp838_ = TRUE;
						} else {
							ValaParameter* _tmp842_;
							gboolean _tmp843_;
							gboolean _tmp844_;
							_tmp842_ = param;
							_tmp843_ = vala_parameter_get_params_array (_tmp842_);
							_tmp844_ = _tmp843_;
							_tmp838_ = _tmp844_;
						}
						if (_tmp838_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp845_ = arg_it;
						if (vala_iterator_next (_tmp845_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp846_;
							gpointer _tmp847_;
							ValaExpression* _tmp848_;
							ValaExpression* _tmp849_;
							ValaDataType* _tmp850_;
							ValaDataType* _tmp851_;
							ValaDataType* _tmp852_;
							ValaList* _tmp853_;
							ValaDataType* _tmp854_;
							ValaDataType* _tmp855_;
							_tmp846_ = arg_it;
							_tmp847_ = vala_iterator_get (_tmp846_);
							arg = (ValaExpression*) _tmp847_;
							_tmp848_ = arg;
							_tmp849_ = arg;
							_tmp850_ = vala_expression_get_formal_target_type (_tmp849_);
							_tmp851_ = _tmp850_;
							_tmp852_ = target_object_type;
							_tmp853_ = method_type_args;
							_tmp854_ = vala_data_type_get_actual_type (_tmp851_, _tmp852_, _tmp853_, (ValaCodeNode*) self);
							_tmp855_ = _tmp854_;
							vala_expression_set_target_type (_tmp848_, _tmp855_);
							_vala_code_node_unref0 (_tmp855_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp856_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp857_ = _tmp856_;
				_tmp858_ = target_object_type;
				_tmp859_ = method_type_args;
				_tmp860_ = vala_data_type_get_actual_type (_tmp857_, _tmp858_, _tmp859_, (ValaCodeNode*) self);
				_tmp861_ = _tmp860_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp861_);
				_vala_code_node_unref0 (_tmp861_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp863_ = m;
		if (_tmp863_ != NULL) {
			ValaMethod* _tmp864_;
			gboolean _tmp865_;
			gboolean _tmp866_;
			_tmp864_ = m;
			_tmp865_ = vala_method_get_coroutine (_tmp864_);
			_tmp866_ = _tmp865_;
			_tmp862_ = _tmp866_;
		} else {
			_tmp862_ = FALSE;
		}
		if (_tmp862_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp867_;
			ValaExpression* _tmp868_;
			ValaMemberAccess* _tmp869_;
			ValaMemberAccess* _tmp870_;
			const gchar* _tmp871_;
			const gchar* _tmp872_;
			_tmp867_ = vala_method_call_get_call (self);
			_tmp868_ = _tmp867_;
			_tmp869_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp869_;
			_tmp870_ = ma;
			_tmp871_ = vala_member_access_get_member_name (_tmp870_);
			_tmp872_ = _tmp871_;
			if (g_strcmp0 (_tmp872_, "end") == 0) {
				ValaMethod* _tmp873_;
				ValaMethod* _tmp874_;
				ValaMethod* _tmp875_;
				ValaMethodType* _tmp876_;
				_tmp873_ = m;
				_tmp874_ = vala_method_get_end_method (_tmp873_);
				_tmp875_ = _tmp874_;
				_tmp876_ = vala_method_type_new (_tmp875_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp876_;
				_vala_code_node_unref0 (_tmp875_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp877_;
		_tmp877_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp877_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp878_;
			ValaObjectTypeSymbol* _tmp879_;
			ValaObjectTypeSymbol* _tmp880_;
			ValaClass* _tmp881_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp882_;
			ValaCreationMethod* _tmp883_;
			ValaCreationMethod* _tmp884_;
			ValaCreationMethod* _tmp885_;
			_tmp878_ = mtype;
			_tmp879_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp878_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp880_ = _tmp879_;
			_tmp881_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp880_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp881_;
			_tmp882_ = cl;
			_tmp883_ = vala_class_get_default_construction_method (_tmp882_);
			_tmp884_ = _tmp883_;
			_tmp885_ = _vala_code_node_ref0 (_tmp884_);
			m = _tmp885_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp886_;
				ValaList* _tmp887_;
				gint _error_type_size = 0;
				ValaList* _tmp888_;
				gint _tmp889_;
				gint _tmp890_;
				gint _error_type_index = 0;
				_tmp886_ = m;
				_tmp887_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp886_);
				_error_type_list = _tmp887_;
				_tmp888_ = _error_type_list;
				_tmp889_ = vala_collection_get_size ((ValaCollection*) _tmp888_);
				_tmp890_ = _tmp889_;
				_error_type_size = _tmp890_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp891_;
					gint _tmp892_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp893_;
					gint _tmp894_;
					gpointer _tmp895_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp896_;
					ValaDataType* _tmp897_;
					ValaDataType* _tmp898_;
					ValaSourceReference* _tmp899_;
					ValaSourceReference* _tmp900_;
					ValaDataType* _tmp901_;
					_error_type_index = _error_type_index + 1;
					_tmp891_ = _error_type_index;
					_tmp892_ = _error_type_size;
					if (!(_tmp891_ < _tmp892_)) {
						break;
					}
					_tmp893_ = _error_type_list;
					_tmp894_ = _error_type_index;
					_tmp895_ = vala_list_get (_tmp893_, _tmp894_);
					error_type = (ValaDataType*) _tmp895_;
					may_throw = TRUE;
					_tmp896_ = error_type;
					_tmp897_ = vala_data_type_copy (_tmp896_);
					call_error_type = _tmp897_;
					_tmp898_ = call_error_type;
					_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp900_ = _tmp899_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp898_, _tmp900_);
					_tmp901_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp901_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp902_;
			_tmp902_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp902_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp903_;
				ValaDelegate* _tmp904_;
				ValaDelegate* _tmp905_;
				ValaDelegate* _tmp906_;
				_tmp903_ = mtype;
				_tmp904_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp903_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp905_ = _tmp904_;
				_tmp906_ = _vala_code_node_ref0 (_tmp905_);
				d = _tmp906_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp907_;
					ValaList* _tmp908_;
					gint _error_type_size = 0;
					ValaList* _tmp909_;
					gint _tmp910_;
					gint _tmp911_;
					gint _error_type_index = 0;
					_tmp907_ = d;
					_tmp908_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp907_);
					_error_type_list = _tmp908_;
					_tmp909_ = _error_type_list;
					_tmp910_ = vala_collection_get_size ((ValaCollection*) _tmp909_);
					_tmp911_ = _tmp910_;
					_error_type_size = _tmp911_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp912_;
						gint _tmp913_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp914_;
						gint _tmp915_;
						gpointer _tmp916_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp917_;
						ValaDataType* _tmp918_;
						ValaDataType* _tmp919_;
						ValaSourceReference* _tmp920_;
						ValaSourceReference* _tmp921_;
						ValaDataType* _tmp922_;
						_error_type_index = _error_type_index + 1;
						_tmp912_ = _error_type_index;
						_tmp913_ = _error_type_size;
						if (!(_tmp912_ < _tmp913_)) {
							break;
						}
						_tmp914_ = _error_type_list;
						_tmp915_ = _error_type_index;
						_tmp916_ = vala_list_get (_tmp914_, _tmp915_);
						error_type = (ValaDataType*) _tmp916_;
						may_throw = TRUE;
						_tmp917_ = error_type;
						_tmp918_ = vala_data_type_copy (_tmp917_);
						call_error_type = _tmp918_;
						_tmp919_ = call_error_type;
						_tmp920_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp921_ = _tmp920_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp919_, _tmp921_);
						_tmp922_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp922_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp923_ = vala_code_context_get_analyzer (context);
	_tmp924_ = _tmp923_;
	_tmp925_ = mtype;
	_tmp926_ = params;
	_tmp927_ = vala_method_call_get_argument_list (self);
	_tmp928_ = _tmp927_;
	_tmp929_ = !vala_semantic_analyzer_check_arguments (_tmp924_, (ValaExpression*) self, _tmp925_, _tmp926_, _tmp928_);
	_vala_iterable_unref0 (_tmp928_);
	if (_tmp929_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp930_;
		gint _arg_size = 0;
		ValaList* _tmp931_;
		gint _tmp932_;
		gint _tmp933_;
		gint _arg_index = 0;
		_tmp930_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp930_;
		_tmp931_ = _arg_list;
		_tmp932_ = vala_collection_get_size ((ValaCollection*) _tmp931_);
		_tmp933_ = _tmp932_;
		_arg_size = _tmp933_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp934_;
			gint _tmp935_;
			ValaExpression* arg = NULL;
			ValaList* _tmp936_;
			gint _tmp937_;
			gpointer _tmp938_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp939_;
			gboolean _tmp940_ = FALSE;
			ValaSizeofExpression* _tmp941_;
			_arg_index = _arg_index + 1;
			_tmp934_ = _arg_index;
			_tmp935_ = _arg_size;
			if (!(_tmp934_ < _tmp935_)) {
				break;
			}
			_tmp936_ = _arg_list;
			_tmp937_ = _arg_index;
			_tmp938_ = vala_list_get (_tmp936_, _tmp937_);
			arg = (ValaExpression*) _tmp938_;
			_tmp939_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp939_) ? ((ValaSizeofExpression*) _tmp939_) : NULL;
			_tmp941_ = sizeof_expr;
			if (_tmp941_ != NULL) {
				ValaSizeofExpression* _tmp942_;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				_tmp942_ = sizeof_expr;
				_tmp943_ = vala_sizeof_expression_get_type_reference (_tmp942_);
				_tmp944_ = _tmp943_;
				_tmp940_ = VALA_IS_GENERIC_TYPE (_tmp944_);
			} else {
				_tmp940_ = FALSE;
			}
			if (_tmp940_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp945_;
				ValaDataType* _tmp946_;
				ValaDataType* _tmp947_;
				ValaDataType* _tmp948_;
				ValaList* _tmp949_;
				ValaDataType* _tmp950_;
				ValaExpression* _tmp951_;
				ValaDataType* _tmp952_;
				ValaSourceReference* _tmp953_;
				ValaSourceReference* _tmp954_;
				ValaSizeofExpression* _tmp955_;
				ValaSizeofExpression* _tmp956_;
				_tmp945_ = sizeof_expr;
				_tmp946_ = vala_sizeof_expression_get_type_reference (_tmp945_);
				_tmp947_ = _tmp946_;
				_tmp948_ = target_object_type;
				_tmp949_ = method_type_args;
				_tmp950_ = vala_data_type_get_actual_type (_tmp947_, _tmp948_, _tmp949_, (ValaCodeNode*) self);
				sizeof_type = _tmp950_;
				_tmp951_ = arg;
				_tmp952_ = sizeof_type;
				_tmp953_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp954_ = _tmp953_;
				_tmp955_ = vala_sizeof_expression_new (_tmp952_, _tmp954_);
				_tmp956_ = _tmp955_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp951_, (ValaExpression*) _tmp956_);
				_vala_code_node_unref0 (_tmp956_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp959_ = base_cm;
	if (_tmp959_ != NULL) {
		ValaCreationMethod* _tmp960_;
		_tmp960_ = base_cm;
		_tmp958_ = vala_method_is_variadic ((ValaMethod*) _tmp960_);
	} else {
		_tmp958_ = FALSE;
	}
	if (_tmp958_) {
		ValaList* _tmp961_;
		gint _tmp962_;
		gint _tmp963_;
		ValaCreationMethod* _tmp964_;
		ValaList* _tmp965_;
		ValaList* _tmp966_;
		gint _tmp967_;
		gint _tmp968_;
		_tmp961_ = args;
		_tmp962_ = vala_collection_get_size ((ValaCollection*) _tmp961_);
		_tmp963_ = _tmp962_;
		_tmp964_ = base_cm;
		_tmp965_ = vala_callable_get_parameters ((ValaCallable*) _tmp964_);
		_tmp966_ = _tmp965_;
		_tmp967_ = vala_collection_get_size ((ValaCollection*) _tmp966_);
		_tmp968_ = _tmp967_;
		_tmp957_ = _tmp963_ == _tmp968_;
		_vala_iterable_unref0 (_tmp966_);
	} else {
		_tmp957_ = FALSE;
	}
	if (_tmp957_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp969_;
		ValaList* _tmp970_;
		gint _tmp971_;
		gint _tmp972_;
		gpointer _tmp973_;
		gboolean _tmp974_ = FALSE;
		ValaExpression* _tmp975_;
		ValaDataType* _tmp976_;
		ValaDataType* _tmp977_;
		_tmp969_ = args;
		_tmp970_ = args;
		_tmp971_ = vala_collection_get_size ((ValaCollection*) _tmp970_);
		_tmp972_ = _tmp971_;
		_tmp973_ = vala_list_get (_tmp969_, _tmp972_ - 1);
		this_last_arg = (ValaExpression*) _tmp973_;
		_tmp975_ = this_last_arg;
		_tmp976_ = vala_expression_get_value_type (_tmp975_);
		_tmp977_ = _tmp976_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp977_)) {
			ValaExpression* _tmp978_;
			ValaDataType* _tmp979_;
			ValaDataType* _tmp980_;
			ValaTypeSymbol* _tmp981_;
			ValaTypeSymbol* _tmp982_;
			ValaSemanticAnalyzer* _tmp983_;
			ValaSemanticAnalyzer* _tmp984_;
			ValaDataType* _tmp985_;
			ValaTypeSymbol* _tmp986_;
			ValaTypeSymbol* _tmp987_;
			_tmp978_ = this_last_arg;
			_tmp979_ = vala_expression_get_value_type (_tmp978_);
			_tmp980_ = _tmp979_;
			_tmp981_ = vala_data_type_get_data_type (_tmp980_);
			_tmp982_ = _tmp981_;
			_tmp983_ = vala_code_context_get_analyzer (context);
			_tmp984_ = _tmp983_;
			_tmp985_ = _tmp984_->va_list_type;
			_tmp986_ = vala_data_type_get_data_type (_tmp985_);
			_tmp987_ = _tmp986_;
			_tmp974_ = _tmp982_ == _tmp987_;
		} else {
			_tmp974_ = FALSE;
		}
		if (_tmp974_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp988_ = may_throw;
	if (_tmp988_) {
		gboolean _tmp989_ = FALSE;
		ValaCodeNode* _tmp990_;
		ValaCodeNode* _tmp991_;
		_tmp990_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp991_ = _tmp990_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp991_)) {
			_tmp989_ = TRUE;
		} else {
			ValaCodeNode* _tmp992_;
			ValaCodeNode* _tmp993_;
			_tmp992_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp993_ = _tmp992_;
			_tmp989_ = VALA_IS_EXPRESSION_STATEMENT (_tmp993_);
		}
		if (_tmp989_) {
		} else {
			ValaSemanticAnalyzer* _tmp994_;
			ValaSemanticAnalyzer* _tmp995_;
			ValaSymbol* _tmp996_;
			ValaSymbol* _tmp997_;
			_tmp994_ = vala_code_context_get_analyzer (context);
			_tmp995_ = _tmp994_;
			_tmp996_ = vala_semantic_analyzer_get_current_symbol (_tmp995_);
			_tmp997_ = _tmp996_;
			if (!VALA_IS_BLOCK (_tmp997_)) {
				ValaSourceReference* _tmp998_;
				ValaSourceReference* _tmp999_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp998_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp999_ = _tmp998_;
				vala_report_error (_tmp999_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp1000_;
				ValaCodeNode* _tmp1001_;
				ValaCodeNode* _tmp1002_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp1003_;
				ValaDataType* _tmp1004_;
				ValaDataType* _tmp1005_;
				ValaDataType* _tmp1006_;
				gchar* _tmp1007_;
				gchar* _tmp1008_;
				ValaSourceReference* _tmp1009_;
				ValaSourceReference* _tmp1010_;
				ValaLocalVariable* _tmp1011_;
				ValaLocalVariable* _tmp1012_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp1013_;
				ValaSourceReference* _tmp1014_;
				ValaSourceReference* _tmp1015_;
				ValaDeclarationStatement* _tmp1016_;
				ValaSemanticAnalyzer* _tmp1017_;
				ValaSemanticAnalyzer* _tmp1018_;
				ValaBlock* _tmp1019_;
				ValaDeclarationStatement* _tmp1020_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp1021_;
				ValaDataType* _tmp1022_;
				ValaDataType* _tmp1023_;
				ValaExpression* _tmp1024_;
				ValaExpression* _tmp1025_;
				ValaDataType* _tmp1026_;
				ValaDataType* _tmp1027_;
				ValaLocalVariable* _tmp1028_;
				ValaDeclarationStatement* _tmp1029_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp1030_;
				ValaSemanticAnalyzer* _tmp1031_;
				ValaSymbol* _tmp1032_;
				ValaSymbol* _tmp1033_;
				ValaBlock* _tmp1034_;
				ValaBlock* _tmp1035_;
				ValaLocalVariable* _tmp1036_;
				ValaSemanticAnalyzer* _tmp1037_;
				ValaSemanticAnalyzer* _tmp1038_;
				ValaBlock* _tmp1039_;
				ValaLocalVariable* _tmp1040_;
				ValaCodeNode* _tmp1041_;
				ValaExpression* _tmp1042_;
				ValaExpression* _tmp1043_;
				_tmp1000_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp1001_ = _tmp1000_;
				_tmp1002_ = _vala_code_node_ref0 (_tmp1001_);
				old_parent_node = _tmp1002_;
				_tmp1003_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1004_ = _tmp1003_;
				_tmp1005_ = vala_data_type_copy (_tmp1004_);
				_tmp1006_ = _tmp1005_;
				_tmp1007_ = vala_code_node_get_temp_name ();
				_tmp1008_ = _tmp1007_;
				_tmp1009_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1010_ = _tmp1009_;
				_tmp1011_ = vala_local_variable_new (_tmp1006_, _tmp1008_, NULL, _tmp1010_);
				_tmp1012_ = _tmp1011_;
				_g_free0 (_tmp1008_);
				_vala_code_node_unref0 (_tmp1006_);
				local = _tmp1012_;
				_tmp1013_ = local;
				_tmp1014_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1015_ = _tmp1014_;
				_tmp1016_ = vala_declaration_statement_new ((ValaSymbol*) _tmp1013_, _tmp1015_);
				decl = _tmp1016_;
				_tmp1017_ = vala_code_context_get_analyzer (context);
				_tmp1018_ = _tmp1017_;
				_tmp1019_ = _tmp1018_->insert_block;
				_tmp1020_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp1019_, (ValaStatement*) _tmp1020_);
				_tmp1021_ = local;
				_tmp1022_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1023_ = _tmp1022_;
				_tmp1024_ = vala_semantic_analyzer_create_temp_access (_tmp1021_, _tmp1023_);
				temp_access = _tmp1024_;
				_tmp1025_ = temp_access;
				_tmp1026_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp1027_ = _tmp1026_;
				vala_expression_set_formal_target_type (_tmp1025_, _tmp1027_);
				_tmp1028_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp1028_, (ValaExpression*) self);
				_tmp1029_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp1029_, context);
				_tmp1030_ = vala_code_context_get_analyzer (context);
				_tmp1031_ = _tmp1030_;
				_tmp1032_ = vala_semantic_analyzer_get_current_symbol (_tmp1031_);
				_tmp1033_ = _tmp1032_;
				_tmp1034_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1033_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp1034_;
				_tmp1035_ = block;
				_tmp1036_ = local;
				vala_block_remove_local_variable (_tmp1035_, _tmp1036_);
				_tmp1037_ = vala_code_context_get_analyzer (context);
				_tmp1038_ = _tmp1037_;
				_tmp1039_ = _tmp1038_->insert_block;
				_tmp1040_ = local;
				vala_block_add_local_variable (_tmp1039_, _tmp1040_);
				_tmp1041_ = old_parent_node;
				_tmp1042_ = temp_access;
				vala_code_node_replace_expression (_tmp1041_, (ValaExpression*) self, _tmp1042_);
				_tmp1043_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp1043_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp1044_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1045_ = _tmp1044_;
	result = !_tmp1045_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = VALA_IS_SIGNAL (_tmp11_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaExpression* expr = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaExpression* _tmp30_;
			_expr_index = _expr_index + 1;
			_tmp25_ = _expr_index;
			_tmp26_ = _expr_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _expr_list;
			_tmp28_ = _expr_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			expr = (ValaExpression*) _tmp29_;
			_tmp30_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp30_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaExpression* _tmp12_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = _arg_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			arg = (ValaExpression*) _tmp11_;
			_tmp12_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp12_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaExpression* _tmp12_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = _arg_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			arg = (ValaExpression*) _tmp11_;
			_tmp12_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp12_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		_tmp10_ = format_arg;
		if (_tmp10_ >= 0) {
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = format_arg;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp11_ < _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaStringLiteral* _tmp19_;
			ValaStringLiteral* _tmp20_;
			_tmp15_ = self->priv->argument_list;
			_tmp16_ = format_arg;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_tmp19_ = vala_string_literal_get_format_literal (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_code_node_unref0 (_tmp18_);
			result = _tmp20_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaExpression* expr = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			gboolean _tmp20_;
			GString* _tmp22_;
			ValaExpression* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp15_ = _expr_index;
			_tmp16_ = _expr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _expr_list;
			_tmp18_ = _expr_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			expr = (ValaExpression*) _tmp19_;
			_tmp20_ = first;
			if (!_tmp20_) {
				GString* _tmp21_;
				_tmp21_ = b;
				g_string_append (_tmp21_, ", ");
			}
			_tmp22_ = b;
			_tmp23_ = expr;
			_tmp24_ = vala_code_node_to_string ((ValaCodeNode*) _tmp23_);
			_tmp25_ = _tmp24_;
			g_string_append (_tmp22_, _tmp25_);
			_g_free0 (_tmp25_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp26_ = b;
	g_string_append (_tmp26_, "))");
	_tmp27_ = b;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	result = _tmp29_;
	_g_string_free0 (b);
	return result;
}


ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}


gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}


gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}


static void
vala_method_call_class_init (ValaMethodCallClass * klass)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}


static void
vala_method_call_instance_init (ValaMethodCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



