/* valaforstatement.c generated by valac, the Vala compiler
 * generated from valaforstatement.vala, do not modify */

/* valaforstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForStatementPrivate {
	ValaList* initializer;
	ValaList* iterator;
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gpointer vala_for_statement_parent_class = NULL;
static ValaStatementIface * vala_for_statement_vala_statement_parent_iface = NULL;

#define VALA_FOR_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOR_STATEMENT, ValaForStatementPrivate))
static void vala_for_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_for_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_for_statement_always_true (ValaForStatement* self,
                                         ValaExpression* condition);
static gboolean vala_for_statement_always_false (ValaForStatement* self,
                                          ValaExpression* condition);
static gboolean vala_for_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_for_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new for statement.
 *
 * @param condition        loop condition
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created for statement
 */
ValaForStatement*
vala_for_statement_construct (GType object_type,
                              ValaExpression* condition,
                              ValaBlock* body,
                              ValaSourceReference* source_reference)
{
	ValaForStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForStatement*) vala_code_node_construct (object_type);
	vala_for_statement_set_condition (self, condition);
	vala_for_statement_set_body (self, body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaForStatement*
vala_for_statement_new (ValaExpression* condition,
                        ValaBlock* body,
                        ValaSourceReference* source_reference)
{
	return vala_for_statement_construct (VALA_TYPE_FOR_STATEMENT, condition, body, source_reference);
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void
vala_for_statement_add_initializer (ValaForStatement* self,
                                    ValaExpression* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
	_tmp0_ = self->priv->initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
}


/**
 * Returns a copy of the list of initializers.
 *
 * @return initializer list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_for_statement_get_initializer (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void
vala_for_statement_add_iterator (ValaForStatement* self,
                                 ValaExpression* iter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) iter, (ValaCodeNode*) self);
	_tmp0_ = self->priv->iterator;
	vala_collection_add ((ValaCollection*) _tmp0_, iter);
}


/**
 * Returns a copy of the iterator.
 *
 * @return iterator
 */
ValaList*
vala_for_statement_get_iterator (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->iterator;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_for_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_for_statement (visitor, self);
}


static void
vala_for_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaBlock* _tmp30_;
	ValaBlock* _tmp31_;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _init_expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _init_expr_index = 0;
		_tmp0_ = self->priv->initializer;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_init_expr_list = _tmp1_;
		_tmp2_ = _init_expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_init_expr_size = _tmp4_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			_init_expr_index = _init_expr_index + 1;
			_tmp5_ = _init_expr_index;
			_tmp6_ = _init_expr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _init_expr_list;
			_tmp8_ = _init_expr_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			init_expr = (ValaExpression*) _tmp9_;
			_tmp10_ = init_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_tmp11_ = init_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp11_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp12_ = vala_for_statement_get_condition (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp14_ = vala_for_statement_get_condition (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
		_tmp16_ = vala_for_statement_get_condition (self);
		_tmp17_ = _tmp16_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp17_);
	}
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _it_expr_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _it_expr_index = 0;
		_tmp18_ = self->priv->iterator;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_it_expr_list = _tmp19_;
		_tmp20_ = _it_expr_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_it_expr_size = _tmp22_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaExpression* _tmp28_;
			ValaExpression* _tmp29_;
			_it_expr_index = _it_expr_index + 1;
			_tmp23_ = _it_expr_index;
			_tmp24_ = _it_expr_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _it_expr_list;
			_tmp26_ = _it_expr_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			it_expr = (ValaExpression*) _tmp27_;
			_tmp28_ = it_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_tmp29_ = it_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp29_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp30_ = vala_for_statement_get_body (self);
	_tmp31_ = _tmp30_;
	vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
}


static void
vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaForStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_for_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_for_statement_set_condition (self, new_node);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				ValaList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gpointer _tmp10_;
				ValaExpression* _tmp11_;
				gboolean _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->initializer;
				_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->initializer;
				_tmp9_ = i;
				_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
				_tmp11_ = (ValaExpression*) _tmp10_;
				_tmp12_ = _tmp11_ == old_node;
				_vala_code_node_unref0 (_tmp11_);
				if (_tmp12_) {
					ValaList* _tmp13_;
					gint _tmp14_;
					_tmp13_ = self->priv->initializer;
					_tmp14_ = i;
					vala_list_set (_tmp13_, _tmp14_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				ValaList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = self->priv->iterator;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				if (!(_tmp17_ < _tmp20_)) {
					break;
				}
				_tmp21_ = self->priv->iterator;
				_tmp22_ = i;
				_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = _tmp24_ == old_node;
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gint _tmp27_;
					_tmp26_ = self->priv->iterator;
					_tmp27_ = i;
					vala_list_set (_tmp26_, _tmp27_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_for_statement_always_true (ValaForStatement* self,
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_for_statement_always_false (ValaForStatement* self,
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_for_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaForStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	gboolean _tmp24_ = FALSE;
	ValaExpression* _tmp25_;
	ValaExpression* _tmp26_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp68_;
	ValaSemanticAnalyzer* _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	ValaDataType* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaSourceReference* _tmp76_;
	ValaBooleanLiteral* _tmp77_;
	ValaBooleanLiteral* _tmp78_;
	ValaSourceReference* _tmp79_;
	ValaSourceReference* _tmp80_;
	ValaLocalVariable* _tmp81_;
	ValaLocalVariable* _tmp82_;
	ValaBlock* _tmp83_;
	ValaLocalVariable* _tmp84_;
	ValaSourceReference* _tmp85_;
	ValaSourceReference* _tmp86_;
	ValaDeclarationStatement* _tmp87_;
	ValaDeclarationStatement* _tmp88_;
	ValaBlock* iterator_block = NULL;
	ValaSourceReference* _tmp89_;
	ValaSourceReference* _tmp90_;
	ValaBlock* _tmp91_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp109_;
	const gchar* _tmp110_;
	const gchar* _tmp111_;
	ValaSourceReference* _tmp112_;
	ValaSourceReference* _tmp113_;
	ValaMemberAccess* _tmp114_;
	ValaMemberAccess* _tmp115_;
	ValaSourceReference* _tmp116_;
	ValaSourceReference* _tmp117_;
	ValaUnaryExpression* _tmp118_;
	ValaUnaryExpression* _tmp119_;
	ValaBlock* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSourceReference* _tmp122_;
	ValaIfStatement* _tmp123_;
	ValaIfStatement* _tmp124_;
	ValaBlock* _tmp125_;
	ValaBlock* _tmp126_;
	ValaIfStatement* _tmp127_;
	ValaBlock* _tmp128_;
	ValaBlock* _tmp129_;
	ValaLocalVariable* _tmp130_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	ValaSourceReference* _tmp133_;
	ValaSourceReference* _tmp134_;
	ValaMemberAccess* _tmp135_;
	ValaMemberAccess* _tmp136_;
	ValaSourceReference* _tmp137_;
	ValaSourceReference* _tmp138_;
	ValaBooleanLiteral* _tmp139_;
	ValaBooleanLiteral* _tmp140_;
	ValaSourceReference* _tmp141_;
	ValaSourceReference* _tmp142_;
	ValaAssignment* _tmp143_;
	ValaAssignment* _tmp144_;
	ValaSourceReference* _tmp145_;
	ValaSourceReference* _tmp146_;
	ValaExpressionStatement* _tmp147_;
	ValaExpressionStatement* _tmp148_;
	ValaBlock* _tmp149_;
	ValaBlock* _tmp150_;
	ValaBlock* _tmp151_;
	ValaSourceReference* _tmp152_;
	ValaSourceReference* _tmp153_;
	ValaLoop* _tmp154_;
	ValaLoop* _tmp155_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp156_;
	ValaCodeNode* _tmp157_;
	ValaBlock* _tmp158_;
	ValaBlock* _tmp159_;
	ValaBlock* _tmp160_;
	ValaBlock* _tmp161_;
	gboolean _tmp162_;
	gboolean _tmp163_;
	self = (ValaForStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	block = _tmp6_;
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _init_expr_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _init_expr_index = 0;
		_tmp7_ = self->priv->initializer;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_init_expr_list = _tmp8_;
		_tmp9_ = _init_expr_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_init_expr_size = _tmp11_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaBlock* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaExpressionStatement* _tmp22_;
			ValaExpressionStatement* _tmp23_;
			_init_expr_index = _init_expr_index + 1;
			_tmp12_ = _init_expr_index;
			_tmp13_ = _init_expr_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _init_expr_list;
			_tmp15_ = _init_expr_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			init_expr = (ValaExpression*) _tmp16_;
			_tmp17_ = block;
			_tmp18_ = init_expr;
			_tmp19_ = init_expr;
			_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_expression_statement_new (_tmp18_, _tmp21_);
			_tmp23_ = _tmp22_;
			vala_block_add_statement (_tmp17_, (ValaStatement*) _tmp23_);
			_vala_code_node_unref0 (_tmp23_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp25_ = vala_for_statement_get_condition (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == NULL) {
		_tmp24_ = TRUE;
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_for_statement_get_condition (self);
		_tmp28_ = _tmp27_;
		_tmp24_ = vala_for_statement_always_true (self, _tmp28_);
	}
	if (_tmp24_) {
	} else {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		_tmp29_ = vala_for_statement_get_condition (self);
		_tmp30_ = _tmp29_;
		if (vala_for_statement_always_false (self, _tmp30_)) {
			ValaBlock* _tmp31_;
			ValaBlock* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaBreakStatement* _tmp37_;
			ValaBreakStatement* _tmp38_;
			_tmp31_ = vala_for_statement_get_body (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_for_statement_get_condition (self);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_break_statement_new (_tmp36_);
			_tmp38_ = _tmp37_;
			vala_block_insert_statement (_tmp32_, 0, (ValaStatement*) _tmp38_);
			_vala_code_node_unref0 (_tmp38_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp39_;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			ValaSourceReference* _tmp43_;
			ValaSourceReference* _tmp44_;
			ValaUnaryExpression* _tmp45_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaSourceReference* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaBlock* _tmp50_;
			ValaBlock* _tmp51_;
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaBreakStatement* _tmp56_;
			ValaBreakStatement* _tmp57_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp58_;
			ValaBlock* _tmp59_;
			ValaExpression* _tmp60_;
			ValaExpression* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaIfStatement* _tmp64_;
			ValaBlock* _tmp65_;
			ValaBlock* _tmp66_;
			ValaIfStatement* _tmp67_;
			_tmp39_ = vala_for_statement_get_condition (self);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_for_statement_get_condition (self);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp40_, _tmp44_);
			if_condition = _tmp45_;
			_tmp46_ = vala_for_statement_get_condition (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_block_new (_tmp49_);
			true_block = _tmp50_;
			_tmp51_ = true_block;
			_tmp52_ = vala_for_statement_get_condition (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_break_statement_new (_tmp55_);
			_tmp57_ = _tmp56_;
			vala_block_add_statement (_tmp51_, (ValaStatement*) _tmp57_);
			_vala_code_node_unref0 (_tmp57_);
			_tmp58_ = if_condition;
			_tmp59_ = true_block;
			_tmp60_ = vala_for_statement_get_condition (self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_if_statement_new ((ValaExpression*) _tmp58_, _tmp59_, NULL, _tmp63_);
			if_stmt = _tmp64_;
			_tmp65_ = vala_for_statement_get_body (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = if_stmt;
			vala_block_insert_statement (_tmp66_, 0, (ValaStatement*) _tmp67_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp68_ = vala_code_context_get_analyzer (context);
	_tmp69_ = _tmp68_;
	_tmp70_ = _tmp69_->bool_type;
	_tmp71_ = vala_data_type_copy (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_code_node_get_temp_name ();
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_boolean_literal_new (TRUE, _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_local_variable_new (_tmp72_, _tmp74_, (ValaExpression*) _tmp78_, _tmp80_);
	_tmp82_ = _tmp81_;
	_vala_code_node_unref0 (_tmp78_);
	_g_free0 (_tmp74_);
	_vala_code_node_unref0 (_tmp72_);
	first_local = _tmp82_;
	_tmp83_ = block;
	_tmp84_ = first_local;
	_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_declaration_statement_new ((ValaSymbol*) _tmp84_, _tmp86_);
	_tmp88_ = _tmp87_;
	vala_block_add_statement (_tmp83_, (ValaStatement*) _tmp88_);
	_vala_code_node_unref0 (_tmp88_);
	_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_block_new (_tmp90_);
	iterator_block = _tmp91_;
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp92_;
		ValaList* _tmp93_;
		gint _it_expr_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _it_expr_index = 0;
		_tmp92_ = self->priv->iterator;
		_tmp93_ = _vala_iterable_ref0 (_tmp92_);
		_it_expr_list = _tmp93_;
		_tmp94_ = _it_expr_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_it_expr_size = _tmp96_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp99_;
			gint _tmp100_;
			gpointer _tmp101_;
			ValaBlock* _tmp102_;
			ValaExpression* _tmp103_;
			ValaExpression* _tmp104_;
			ValaSourceReference* _tmp105_;
			ValaSourceReference* _tmp106_;
			ValaExpressionStatement* _tmp107_;
			ValaExpressionStatement* _tmp108_;
			_it_expr_index = _it_expr_index + 1;
			_tmp97_ = _it_expr_index;
			_tmp98_ = _it_expr_size;
			if (!(_tmp97_ < _tmp98_)) {
				break;
			}
			_tmp99_ = _it_expr_list;
			_tmp100_ = _it_expr_index;
			_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
			it_expr = (ValaExpression*) _tmp101_;
			_tmp102_ = iterator_block;
			_tmp103_ = it_expr;
			_tmp104_ = it_expr;
			_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_expression_statement_new (_tmp103_, _tmp106_);
			_tmp108_ = _tmp107_;
			vala_block_add_statement (_tmp102_, (ValaStatement*) _tmp108_);
			_vala_code_node_unref0 (_tmp108_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp109_ = first_local;
	_tmp110_ = vala_symbol_get_name ((ValaSymbol*) _tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_member_access_new_simple (_tmp111_, _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp115_, _tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = iterator_block;
	_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_if_statement_new ((ValaExpression*) _tmp119_, _tmp120_, NULL, _tmp122_);
	_tmp124_ = _tmp123_;
	_vala_code_node_unref0 (_tmp119_);
	_vala_code_node_unref0 (_tmp115_);
	first_if = _tmp124_;
	_tmp125_ = vala_for_statement_get_body (self);
	_tmp126_ = _tmp125_;
	_tmp127_ = first_if;
	vala_block_insert_statement (_tmp126_, 0, (ValaStatement*) _tmp127_);
	_tmp128_ = vala_for_statement_get_body (self);
	_tmp129_ = _tmp128_;
	_tmp130_ = first_local;
	_tmp131_ = vala_symbol_get_name ((ValaSymbol*) _tmp130_);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_member_access_new_simple (_tmp132_, _tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_boolean_literal_new (FALSE, _tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_assignment_new ((ValaExpression*) _tmp136_, (ValaExpression*) _tmp140_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_expression_statement_new ((ValaExpression*) _tmp144_, _tmp146_);
	_tmp148_ = _tmp147_;
	vala_block_insert_statement (_tmp129_, 1, (ValaStatement*) _tmp148_);
	_vala_code_node_unref0 (_tmp148_);
	_vala_code_node_unref0 (_tmp144_);
	_vala_code_node_unref0 (_tmp140_);
	_vala_code_node_unref0 (_tmp136_);
	_tmp149_ = block;
	_tmp150_ = vala_for_statement_get_body (self);
	_tmp151_ = _tmp150_;
	_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp153_ = _tmp152_;
	_tmp154_ = vala_loop_new (_tmp151_, _tmp153_);
	_tmp155_ = _tmp154_;
	vala_block_add_statement (_tmp149_, (ValaStatement*) _tmp155_);
	_vala_code_node_unref0 (_tmp155_);
	_tmp156_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp157_ = _tmp156_;
	_tmp158_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp158_;
	_tmp159_ = parent_block;
	_tmp160_ = block;
	vala_block_replace_statement (_tmp159_, (ValaStatement*) self, (ValaStatement*) _tmp160_);
	_tmp161_ = block;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp161_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	_tmp162_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp163_ = _tmp162_;
	result = !_tmp163_;
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (iterator_block);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}


ValaExpression*
vala_for_statement_get_condition (ValaForStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void
vala_for_statement_set_condition (ValaForStatement* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_condition;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


ValaBlock*
vala_for_statement_get_body (ValaForStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_for_statement_set_body (ValaForStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_for_statement_class_init (ValaForStatementClass * klass)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_for_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaForStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_for_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_for_statement_real_check;
}


static void
vala_for_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_for_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_for_statement_instance_init (ValaForStatement * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_FOR_STATEMENT_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializer = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->iterator = (ValaList*) _tmp3_;
}


static void
vala_for_statement_finalize (ValaCodeNode * obj)
{
	ValaForStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOR_STATEMENT, ValaForStatement);
	_vala_iterable_unref0 (self->priv->initializer);
	_vala_iterable_unref0 (self->priv->iterator);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->finalize (obj);
}


/**
 * Represents a for iteration statement in the source code.
 */
GType
vala_for_statement_get_type (void)
{
	static volatile gsize vala_for_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_for_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_for_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_for_statement_type_id;
		vala_for_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaForStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_for_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_for_statement_type_id__volatile, vala_for_statement_type_id);
	}
	return vala_for_statement_type_id__volatile;
}



