/* valaccodearraymodule.c generated by valac, the Vala compiler
 * generated from valaccodearraymodule.vala, do not modify */

/* valaccodearraymodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaCCodeArrayModulePrivate {
	gint next_array_dup_id;
	gint next_array_add_id;
};

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_array_module_parent_class = NULL;

#define VALA_CCODE_ARRAY_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModulePrivate))
static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self,
                                                      ValaCCodeExpression* name_cnode,
                                                      ValaInitializerList* initializer_list,
                                                      gint rank,
                                                      gint* i);
static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                                   ValaArrayCreationExpression* expr);
static gchar* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeBaseModule* base,
                                                            const gchar* array_cname,
                                                            gint dim);
static gchar* vala_ccode_array_module_real_get_parameter_array_length_cname (ValaCCodeBaseModule* base,
                                                                      ValaParameter* param,
                                                                      gint dim);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeBaseModule* base,
                                                                                ValaExpression* array_expr,
                                                                                gint dim);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cvalue (ValaCCodeBaseModule* base,
                                                                           ValaTargetValue* value,
                                                                           gint dim);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gchar* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeBaseModule* base,
                                                          const gchar* array_cname);
static void vala_ccode_array_module_real_visit_element_access (ValaCodeVisitor* base,
                                                        ValaElementAccess* expr);
static void vala_ccode_array_module_real_visit_slice_expression (ValaCodeVisitor* base,
                                                          ValaSliceExpression* expr);
static void vala_ccode_array_module_append_struct_array_free_loop (ValaCCodeArrayModule* self,
                                                            ValaStruct* st);
static gchar* vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base,
                                                              ValaStruct* st);
static gchar* vala_ccode_array_module_real_append_struct_array_destroy (ValaCCodeBaseModule* base,
                                                                 ValaStruct* st);
static void vala_ccode_array_module_append_vala_array_free_loop (ValaCCodeArrayModule* self);
static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base);
static ValaTargetValue* vala_ccode_array_module_real_copy_value (ValaCCodeBaseModule* base,
                                                          ValaTargetValue* value,
                                                          ValaCodeNode* node);
static gchar* vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self,
                                                            ValaArrayType* array_type);
static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base,
                                                                           ValaDataType* type,
                                                                           ValaSourceReference* source_reference,
                                                                           gboolean is_chainup);
static gchar* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self,
                                                           ValaArrayType* array_type);
static ValaCCodeExpression* vala_ccode_array_module_real_destroy_value (ValaCCodeBaseModule* base,
                                                                 ValaTargetValue* value,
                                                                 gboolean is_macro_definition);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
static gchar* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self,
                                                           ValaArrayType* array_type);
static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self,
                                               ValaAssignment* assignment);
static void vala_ccode_array_module_real_visit_assignment (ValaCodeVisitor* base,
                                                    ValaAssignment* assignment);
static ValaCCodeParameter* vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base,
                                                                     ValaParameter* param,
                                                                     ValaCCodeFile* decl_space,
                                                                     ValaMap* cparam_map,
                                                                     ValaMap* carg_map);
static void vala_ccode_array_module_finalize (ValaCodeVisitor * obj);


static void
vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self,
                                                 ValaCCodeExpression* name_cnode,
                                                 ValaInitializerList* initializer_list,
                                                 gint rank,
                                                 gint* i)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name_cnode != NULL);
	g_return_if_fail (initializer_list != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		gint _e_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _e_index = 0;
		_tmp0_ = vala_initializer_list_get_initializers (initializer_list);
		_e_list = _tmp0_;
		_tmp1_ = _e_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_e_size = _tmp3_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* e = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			_e_index = _e_index + 1;
			_tmp4_ = _e_index;
			_tmp5_ = _e_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _e_list;
			_tmp7_ = _e_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			e = (ValaExpression*) _tmp8_;
			if (rank > 1) {
				ValaExpression* _tmp9_;
				_tmp9_ = e;
				vala_ccode_array_module_append_initializer_list (self, name_cnode, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, i);
			} else {
				ValaCCodeFunction* _tmp10_;
				ValaCCodeFunction* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				ValaCCodeConstant* _tmp14_;
				ValaCCodeConstant* _tmp15_;
				ValaCCodeElementAccess* _tmp16_;
				ValaCCodeElementAccess* _tmp17_;
				ValaExpression* _tmp18_;
				ValaCCodeExpression* _tmp19_;
				ValaCCodeExpression* _tmp20_;
				gint _tmp21_;
				_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup_printf ("%i", *i);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_ccode_constant_new (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_ccode_element_access_new (name_cnode, (ValaCCodeExpression*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = e;
				_tmp19_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp18_);
				_tmp20_ = _tmp19_;
				vala_ccode_function_add_assignment (_tmp11_, (ValaCCodeExpression*) _tmp17_, _tmp20_);
				_vala_ccode_node_unref0 (_tmp20_);
				_vala_ccode_node_unref0 (_tmp17_);
				_vala_ccode_node_unref0 (_tmp15_);
				_g_free0 (_tmp13_);
				_tmp21_ = *i;
				*i = _tmp21_ + 1;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_ccode_array_module_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                              ValaArrayCreationExpression* expr)
{
	ValaCCodeArrayModule * self;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaArrayType* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaArrayType* _tmp4_;
	ValaCCodeFunctionCall* gnew = NULL;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	gboolean first = FALSE;
	ValaCCodeExpression* cexpr = NULL;
	gboolean _tmp51_ = FALSE;
	ValaDataType* _tmp52_;
	ValaDataType* _tmp53_;
	ValaTypeSymbol* _tmp54_;
	ValaTypeSymbol* _tmp55_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeExpression* _tmp65_;
	ValaLocalVariable* temp_var = NULL;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaLocalVariable* _tmp68_;
	ValaCCodeExpression* name_cnode = NULL;
	ValaLocalVariable* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	ValaCCodeExpression* _tmp72_;
	gint i = 0;
	ValaLocalVariable* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeExpression* _tmp76_;
	ValaCCodeFunctionCall* _tmp77_;
	ValaInitializerList* _tmp78_;
	ValaInitializerList* _tmp79_;
	ValaCCodeExpression* _tmp85_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_target_type ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp1_) : NULL);
	array_type = _tmp2_;
	_tmp4_ = array_type;
	if (_tmp4_ != NULL) {
		ValaArrayType* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = array_type;
		_tmp6_ = vala_array_type_get_fixed_length (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaLocalVariable* temp_var = NULL;
		ValaArrayType* _tmp8_;
		ValaLocalVariable* _tmp9_;
		ValaLocalVariable* _tmp10_;
		ValaCCodeExpression* name_cnode = NULL;
		ValaLocalVariable* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaCCodeExpression* _tmp14_;
		gint i = 0;
		ValaLocalVariable* _tmp15_;
		ValaCCodeExpression* _tmp16_;
		ValaInitializerList* _tmp17_;
		ValaInitializerList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		ValaCCodeExpression* _tmp21_;
		_tmp8_ = array_type;
		_tmp9_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp8_, TRUE, (ValaCodeNode*) expr, FALSE);
		temp_var = _tmp9_;
		_tmp10_ = temp_var;
		vala_local_variable_set_init (_tmp10_, TRUE);
		_tmp11_ = temp_var;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp13_);
		name_cnode = _tmp14_;
		i = 0;
		_tmp15_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp15_, FALSE);
		_tmp16_ = name_cnode;
		_tmp17_ = vala_array_creation_expression_get_initializer_list (expr);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_array_creation_expression_get_rank (expr);
		_tmp20_ = _tmp19_;
		vala_ccode_array_module_append_initializer_list (self, _tmp16_, _tmp18_, _tmp20_, &i);
		_tmp21_ = name_cnode;
		vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp21_);
		_vala_ccode_node_unref0 (name_cnode);
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (array_type);
		return;
	}
	_tmp22_ = vala_ccode_identifier_new ("g_new0");
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_ccode_node_unref0 (_tmp23_);
	gnew = _tmp25_;
	_tmp26_ = gnew;
	_tmp27_ = vala_array_creation_expression_get_element_type (expr);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_identifier_new (_tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (_tmp26_, (ValaCCodeExpression*) _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	first = TRUE;
	cexpr = NULL;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp33_;
		gint _size_size = 0;
		ValaList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _size_index = 0;
		_tmp33_ = vala_array_creation_expression_get_sizes (expr);
		_size_list = _tmp33_;
		_tmp34_ = _size_list;
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_size_size = _tmp36_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp37_;
			gint _tmp38_;
			ValaExpression* size = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_;
			ValaCCodeExpression* csize = NULL;
			ValaExpression* _tmp42_;
			ValaCCodeExpression* _tmp43_;
			ValaCCodeExpression* _tmp44_;
			gboolean _tmp45_;
			_size_index = _size_index + 1;
			_tmp37_ = _size_index;
			_tmp38_ = _size_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _size_list;
			_tmp40_ = _size_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			size = (ValaExpression*) _tmp41_;
			_tmp42_ = size;
			_tmp43_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp42_);
			csize = _tmp43_;
			_tmp44_ = csize;
			vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp44_);
			_tmp45_ = first;
			if (_tmp45_) {
				ValaCCodeExpression* _tmp46_;
				ValaCCodeExpression* _tmp47_;
				_tmp46_ = csize;
				_tmp47_ = _vala_ccode_node_ref0 (_tmp46_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp47_;
				first = FALSE;
			} else {
				ValaCCodeExpression* _tmp48_;
				ValaCCodeExpression* _tmp49_;
				ValaCCodeBinaryExpression* _tmp50_;
				_tmp48_ = cexpr;
				_tmp49_ = csize;
				_tmp50_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, _tmp48_, _tmp49_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = (ValaCCodeExpression*) _tmp50_;
			}
			_vala_ccode_node_unref0 (csize);
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp52_ = vala_array_creation_expression_get_element_type (expr);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_data_type_get_data_type (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		ValaDataType* _tmp56_;
		ValaDataType* _tmp57_;
		ValaTypeSymbol* _tmp58_;
		ValaTypeSymbol* _tmp59_;
		_tmp56_ = vala_array_creation_expression_get_element_type (expr);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_data_type_get_data_type (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp51_ = vala_typesymbol_is_reference_type (_tmp59_);
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		ValaCCodeExpression* _tmp60_;
		ValaCCodeConstant* _tmp61_;
		ValaCCodeConstant* _tmp62_;
		ValaCCodeBinaryExpression* _tmp63_;
		_tmp60_ = cexpr;
		_tmp61_ = vala_ccode_constant_new ("1");
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp60_, (ValaCCodeExpression*) _tmp62_);
		_vala_ccode_node_unref0 (cexpr);
		cexpr = (ValaCCodeExpression*) _tmp63_;
		_vala_ccode_node_unref0 (_tmp62_);
	}
	_tmp64_ = gnew;
	_tmp65_ = cexpr;
	vala_ccode_function_call_add_argument (_tmp64_, _tmp65_);
	_tmp66_ = vala_expression_get_value_type ((ValaExpression*) expr);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp67_, TRUE, (ValaCodeNode*) expr, FALSE);
	temp_var = _tmp68_;
	_tmp69_ = temp_var;
	_tmp70_ = vala_symbol_get_name ((ValaSymbol*) _tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp71_);
	name_cnode = _tmp72_;
	i = 0;
	_tmp73_ = temp_var;
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp73_, FALSE);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = name_cnode;
	_tmp77_ = gnew;
	vala_ccode_function_add_assignment (_tmp75_, _tmp76_, (ValaCCodeExpression*) _tmp77_);
	_tmp78_ = vala_array_creation_expression_get_initializer_list (expr);
	_tmp79_ = _tmp78_;
	if (_tmp79_ != NULL) {
		ValaCCodeExpression* _tmp80_;
		ValaInitializerList* _tmp81_;
		ValaInitializerList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		_tmp80_ = name_cnode;
		_tmp81_ = vala_array_creation_expression_get_initializer_list (expr);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_array_creation_expression_get_rank (expr);
		_tmp84_ = _tmp83_;
		vala_ccode_array_module_append_initializer_list (self, _tmp80_, _tmp82_, _tmp84_, &i);
	}
	_tmp85_ = name_cnode;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp85_);
	_vala_ccode_node_unref0 (name_cnode);
	_vala_code_node_unref0 (temp_var);
	_vala_ccode_node_unref0 (cexpr);
	_vala_ccode_node_unref0 (gnew);
	_vala_code_node_unref0 (array_type);
}


static gchar*
vala_ccode_array_module_real_get_array_length_cname (ValaCCodeBaseModule* base,
                                                     const gchar* array_cname,
                                                     gint dim)
{
	ValaCCodeArrayModule * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s_length%d", array_cname, dim);
	result = _tmp0_;
	return result;
}


static gchar*
vala_ccode_array_module_real_get_parameter_array_length_cname (ValaCCodeBaseModule* base,
                                                               ValaParameter* param,
                                                               gint dim)
{
	ValaCCodeArrayModule * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = vala_get_ccode_array_length_name ((ValaCodeNode*) param);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = vala_get_ccode_array_length_name ((ValaCodeNode*) param);
		result = _tmp3_;
		return result;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = vala_symbol_get_name ((ValaSymbol*) param);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, _tmp7_, dim);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		return result;
	}
}


static ValaCCodeExpression*
vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeBaseModule* base,
                                                           ValaExpression* array_expr,
                                                           gint dim)
{
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	ValaTargetValue* _tmp0_;
	ValaTargetValue* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	_tmp0_ = vala_expression_get_target_value (array_expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp1_, dim);
	result = _tmp2_;
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaCCodeExpression*
vala_ccode_array_module_real_get_array_length_cvalue (ValaCCodeBaseModule* base,
                                                      ValaTargetValue* value,
                                                      gint dim)
{
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaArrayType* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaArrayType* _tmp4_;
	ValaList* size = NULL;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gboolean _tmp29_ = FALSE;
	ValaList* _tmp30_;
	ValaList* _tmp35_;
	gpointer _tmp36_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = vala_target_value_get_value_type (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp1_) : NULL);
	array_type = _tmp2_;
	_tmp4_ = array_type;
	if (_tmp4_ != NULL) {
		ValaArrayType* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = array_type;
		_tmp6_ = vala_array_type_get_fixed_length (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaArrayType* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaCCodeExpression* _tmp11_;
		_tmp8_ = array_type;
		_tmp9_ = vala_array_type_get_length (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp10_);
		result = _tmp11_;
		_vala_code_node_unref0 (array_type);
		return result;
	}
	if (dim == -1) {
		gboolean _tmp12_ = FALSE;
		ValaArrayType* _tmp13_;
		_tmp13_ = array_type;
		if (_tmp13_ != NULL) {
			ValaArrayType* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp14_ = array_type;
			_tmp15_ = vala_array_type_get_rank (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ > 1;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaCCodeExpression* cexpr = NULL;
			ValaCCodeExpression* _tmp17_;
			_tmp17_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, value, 1);
			cexpr = _tmp17_;
			{
				gboolean _tmp18_ = FALSE;
				dim = 2;
				_tmp18_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					ValaCCodeExpression* _tmp23_;
					ValaCCodeExpression* _tmp24_;
					ValaCCodeExpression* _tmp25_;
					ValaCCodeBinaryExpression* _tmp26_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = dim;
						dim = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = array_type;
					_tmp21_ = vala_array_type_get_rank (_tmp20_);
					_tmp22_ = _tmp21_;
					if (!(dim <= _tmp22_)) {
						break;
					}
					_tmp23_ = cexpr;
					_tmp24_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, value, dim);
					_tmp25_ = _tmp24_;
					_tmp26_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, _tmp23_, _tmp25_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp26_;
					_vala_ccode_node_unref0 (_tmp25_);
				}
			}
			result = cexpr;
			_vala_code_node_unref0 (array_type);
			return result;
		} else {
			dim = 1;
		}
	}
	_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (value, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->array_length_cvalues;
	_tmp28_ = _vala_iterable_ref0 (_tmp27_);
	size = _tmp28_;
	_tmp30_ = size;
	if (_tmp30_ == NULL) {
		_tmp29_ = TRUE;
	} else {
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp31_ = size;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ < dim;
	}
	if (_tmp29_) {
		ValaCCodeInvalidExpression* _tmp34_;
		vala_report_error (NULL, "internal error: invalid array_length for given dimension");
		_tmp34_ = vala_ccode_invalid_expression_new ();
		result = (ValaCCodeExpression*) _tmp34_;
		_vala_iterable_unref0 (size);
		_vala_code_node_unref0 (array_type);
		return result;
	}
	_tmp35_ = size;
	_tmp36_ = vala_list_get (_tmp35_, dim - 1);
	result = (ValaCCodeExpression*) _tmp36_;
	_vala_iterable_unref0 (size);
	_vala_code_node_unref0 (array_type);
	return result;
}


static gchar*
vala_ccode_array_module_real_get_array_size_cname (ValaCCodeBaseModule* base,
                                                   const gchar* array_cname)
{
	ValaCCodeArrayModule * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	_tmp0_ = g_strdup_printf ("_%s_size_", array_cname);
	result = _tmp0_;
	return result;
}


static void
vala_ccode_array_module_real_visit_element_access (ValaCodeVisitor* base,
                                                   ValaElementAccess* expr)
{
	ValaCCodeArrayModule * self;
	ValaList* indices = NULL;
	ValaList* _tmp0_;
	gint rank = 0;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaCCodeExpression* ccontainer = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	ValaCCodeExpression* cindex = NULL;
	ValaList* _tmp7_;
	gpointer _tmp8_;
	ValaExpression* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaTargetValue* _tmp90_;
	ValaTargetValue* _tmp91_;
	ValaDataType* _tmp92_;
	ValaDataType* _tmp93_;
	ValaDataType* _tmp94_;
	ValaDataType* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	ValaTargetValue* _tmp102_;
	ValaTargetValue* _tmp103_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_element_access_get_indices (expr);
	indices = _tmp0_;
	_tmp1_ = indices;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	rank = _tmp3_;
	_tmp4_ = vala_element_access_get_container (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
	ccontainer = _tmp6_;
	_tmp7_ = indices;
	_tmp8_ = vala_list_get (_tmp7_, 0);
	_tmp9_ = (ValaExpression*) _tmp8_;
	_tmp10_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_code_node_unref0 (_tmp9_);
	cindex = _tmp11_;
	_tmp12_ = vala_element_access_get_container (expr);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
	_tmp15_ = _tmp14_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
		ValaIntegerLiteral* lit = NULL;
		ValaList* _tmp16_;
		gpointer _tmp17_;
		ValaExpression* _tmp18_;
		ValaIntegerLiteral* _tmp19_;
		ValaMemberAccess* memberaccess = NULL;
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		ValaMemberAccess* _tmp22_;
		gboolean _tmp23_ = FALSE;
		ValaIntegerLiteral* _tmp24_;
		_tmp16_ = indices;
		_tmp17_ = vala_list_get (_tmp16_, 0);
		_tmp18_ = (ValaExpression*) _tmp17_;
		_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp18_) : NULL;
		if (_tmp19_ == NULL) {
			_vala_code_node_unref0 (_tmp18_);
		}
		lit = _tmp19_;
		_tmp20_ = vala_element_access_get_container (expr);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp21_) : NULL);
		memberaccess = _tmp22_;
		_tmp24_ = lit;
		if (_tmp24_ != NULL) {
			ValaMemberAccess* _tmp25_;
			_tmp25_ = memberaccess;
			_tmp23_ = _tmp25_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gint dim = 0;
			ValaIntegerLiteral* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			gint _tmp32_;
			ValaCCodeExpression* _tmp33_;
			ValaCCodeExpression* _tmp34_;
			_tmp26_ = lit;
			_tmp27_ = vala_integer_literal_get_value (_tmp26_);
			_tmp28_ = _tmp27_;
			dim = atoi (_tmp28_);
			_tmp29_ = memberaccess;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = dim;
			_tmp33_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp31_, _tmp32_ + 1);
			_tmp34_ = _tmp33_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
		} else {
			ValaSourceReference* _tmp35_;
			ValaSourceReference* _tmp36_;
			_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp36_ = _tmp35_;
			vala_report_error (_tmp36_, "internal error: only integer literals supported as index");
		}
		_vala_code_node_unref0 (memberaccess);
		_vala_code_node_unref0 (lit);
	} else {
		gboolean _tmp37_ = FALSE;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSymbol* _tmp40_;
		ValaSymbol* _tmp41_;
		_tmp38_ = vala_element_access_get_container (expr);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_expression_get_symbol_reference (_tmp39_);
		_tmp41_ = _tmp40_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_CONSTANT)) {
			gint _tmp42_;
			_tmp42_ = rank;
			_tmp37_ = _tmp42_ > 1;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			ValaArrayList* cindices = NULL;
			GEqualFunc _tmp43_;
			ValaArrayList* _tmp44_;
			ValaArrayList* _tmp45_;
			ValaCCodeExpression* _tmp46_;
			ValaCCodeExpression* _tmp58_;
			ValaArrayList* _tmp59_;
			ValaCCodeElementAccess* _tmp60_;
			ValaCCodeElementAccess* _tmp61_;
			_tmp43_ = g_direct_equal;
			_tmp44_ = vala_array_list_new (VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp43_);
			cindices = _tmp44_;
			_tmp45_ = cindices;
			_tmp46_ = cindex;
			vala_collection_add ((ValaCollection*) _tmp45_, _tmp46_);
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp47_ = FALSE;
					_tmp47_ = TRUE;
					while (TRUE) {
						gint _tmp49_;
						gint _tmp50_;
						ValaArrayList* _tmp51_;
						ValaList* _tmp52_;
						gint _tmp53_;
						gpointer _tmp54_;
						ValaExpression* _tmp55_;
						ValaCCodeExpression* _tmp56_;
						ValaCCodeExpression* _tmp57_;
						if (!_tmp47_) {
							gint _tmp48_;
							_tmp48_ = i;
							i = _tmp48_ + 1;
						}
						_tmp47_ = FALSE;
						_tmp49_ = i;
						_tmp50_ = rank;
						if (!(_tmp49_ < _tmp50_)) {
							break;
						}
						_tmp51_ = cindices;
						_tmp52_ = indices;
						_tmp53_ = i;
						_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
						_tmp55_ = (ValaExpression*) _tmp54_;
						_tmp56_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp55_);
						_tmp57_ = _tmp56_;
						vala_collection_add ((ValaCollection*) _tmp51_, _tmp57_);
						_vala_ccode_node_unref0 (_tmp57_);
						_vala_code_node_unref0 (_tmp55_);
					}
				}
			}
			_tmp58_ = ccontainer;
			_tmp59_ = cindices;
			_tmp60_ = vala_ccode_element_access_new_with_indices (_tmp58_, (ValaList*) _tmp59_);
			_tmp61_ = _tmp60_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (_tmp61_);
			_vala_iterable_unref0 (cindices);
		} else {
			ValaCCodeExpression* _tmp86_;
			ValaCCodeExpression* _tmp87_;
			ValaCCodeElementAccess* _tmp88_;
			ValaCCodeElementAccess* _tmp89_;
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp62_ = FALSE;
					_tmp62_ = TRUE;
					while (TRUE) {
						gint _tmp64_;
						gint _tmp65_;
						ValaCCodeBinaryExpression* cmul = NULL;
						ValaCCodeExpression* _tmp66_;
						ValaExpression* _tmp67_;
						ValaExpression* _tmp68_;
						gint _tmp69_;
						ValaCCodeExpression* _tmp70_;
						ValaCCodeExpression* _tmp71_;
						ValaCCodeBinaryExpression* _tmp72_;
						ValaCCodeBinaryExpression* _tmp73_;
						ValaCCodeBinaryExpression* _tmp74_;
						ValaList* _tmp75_;
						gint _tmp76_;
						gpointer _tmp77_;
						ValaExpression* _tmp78_;
						ValaCCodeExpression* _tmp79_;
						ValaCCodeExpression* _tmp80_;
						ValaCCodeBinaryExpression* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						if (!_tmp62_) {
							gint _tmp63_;
							_tmp63_ = i;
							i = _tmp63_ + 1;
						}
						_tmp62_ = FALSE;
						_tmp64_ = i;
						_tmp65_ = rank;
						if (!(_tmp64_ < _tmp65_)) {
							break;
						}
						_tmp66_ = cindex;
						_tmp67_ = vala_element_access_get_container (expr);
						_tmp68_ = _tmp67_;
						_tmp69_ = i;
						_tmp70_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp68_, _tmp69_ + 1);
						_tmp71_ = _tmp70_;
						_tmp72_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, _tmp66_, _tmp71_);
						_tmp73_ = _tmp72_;
						_vala_ccode_node_unref0 (_tmp71_);
						cmul = _tmp73_;
						_tmp74_ = cmul;
						_tmp75_ = indices;
						_tmp76_ = i;
						_tmp77_ = vala_list_get (_tmp75_, _tmp76_);
						_tmp78_ = (ValaExpression*) _tmp77_;
						_tmp79_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp74_, _tmp80_);
						_vala_ccode_node_unref0 (cindex);
						cindex = (ValaCCodeExpression*) _tmp81_;
						_vala_ccode_node_unref0 (_tmp80_);
						_vala_code_node_unref0 (_tmp78_);
						_tmp82_ = vala_element_access_get_container (expr);
						_tmp83_ = _tmp82_;
						if (vala_expression_is_constant (_tmp83_)) {
							ValaCCodeExpression* _tmp84_;
							ValaCCodeUnaryExpression* _tmp85_;
							_tmp84_ = ccontainer;
							_tmp85_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, _tmp84_);
							_vala_ccode_node_unref0 (ccontainer);
							ccontainer = (ValaCCodeExpression*) _tmp85_;
						}
						_vala_ccode_node_unref0 (cmul);
					}
				}
			}
			_tmp86_ = ccontainer;
			_tmp87_ = cindex;
			_tmp88_ = vala_ccode_element_access_new (_tmp86_, _tmp87_);
			_tmp89_ = _tmp88_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp89_);
			_vala_ccode_node_unref0 (_tmp89_);
		}
	}
	_tmp90_ = vala_expression_get_target_value ((ValaExpression*) expr);
	_tmp91_ = _tmp90_;
	_tmp92_ = vala_expression_get_value_type ((ValaExpression*) expr);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_data_type_copy (_tmp93_);
	_tmp95_ = _tmp94_;
	vala_target_value_set_value_type (_tmp91_, _tmp95_);
	_vala_code_node_unref0 (_tmp95_);
	_tmp96_ = vala_expression_get_lvalue ((ValaExpression*) expr);
	_tmp97_ = _tmp96_;
	if (!_tmp97_) {
		ValaTargetValue* _tmp98_;
		ValaTargetValue* _tmp99_;
		ValaTargetValue* _tmp100_;
		ValaTargetValue* _tmp101_;
		_tmp98_ = vala_expression_get_target_value ((ValaExpression*) expr);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp99_, (ValaCodeNode*) expr, NULL);
		_tmp101_ = _tmp100_;
		vala_expression_set_target_value ((ValaExpression*) expr, _tmp101_);
		_vala_target_value_unref0 (_tmp101_);
	}
	_tmp102_ = vala_expression_get_target_value ((ValaExpression*) expr);
	_tmp103_ = _tmp102_;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
	_vala_ccode_node_unref0 (cindex);
	_vala_ccode_node_unref0 (ccontainer);
	_vala_iterable_unref0 (indices);
}


static void
vala_ccode_array_module_real_visit_slice_expression (ValaCodeVisitor* base,
                                                     ValaSliceExpression* expr)
{
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* ccontainer = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* cstart = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCCodeExpression* _tmp5_;
	ValaCCodeExpression* cstop = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	ValaCCodeBinaryExpression* cstartpointer = NULL;
	ValaCCodeBinaryExpression* _tmp9_;
	ValaCCodeBinaryExpression* splicelen = NULL;
	ValaCCodeBinaryExpression* _tmp10_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_slice_expression_get_container (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	ccontainer = _tmp2_;
	_tmp3_ = vala_slice_expression_get_start (expr);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp4_);
	cstart = _tmp5_;
	_tmp6_ = vala_slice_expression_get_stop (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp7_);
	cstop = _tmp8_;
	_tmp9_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ccontainer, cstart);
	cstartpointer = _tmp9_;
	_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, cstop, cstart);
	splicelen = _tmp10_;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) cstartpointer);
	vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) splicelen);
	_vala_ccode_node_unref0 (splicelen);
	_vala_ccode_node_unref0 (cstartpointer);
	_vala_ccode_node_unref0 (cstop);
	_vala_ccode_node_unref0 (cstart);
	_vala_ccode_node_unref0 (ccontainer);
}


static void
vala_ccode_array_module_append_struct_array_free_loop (ValaCCodeArrayModule* self,
                                                       ValaStruct* st)
{
	ValaCCodeAssignment* cforinit = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeConstant* _tmp3_;
	ValaCCodeAssignment* _tmp4_;
	ValaCCodeAssignment* _tmp5_;
	ValaCCodeBinaryExpression* cforcond = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeAssignment* cforiter = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeBinaryExpression* _tmp18_;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeAssignment* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeIdentifier* cptrarray = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeElementAccess* cea = NULL;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeElementAccess* _tmp27_;
	ValaCCodeElementAccess* _tmp28_;
	ValaCCodeFunctionCall* cfreecall = NULL;
	ValaStructValueType* _tmp29_;
	ValaStructValueType* _tmp30_;
	ValaCCodeExpression* _tmp31_;
	ValaCCodeExpression* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeUnaryExpression* _tmp35_;
	ValaCCodeUnaryExpression* _tmp36_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_ccode_identifier_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_constant_new ("0");
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp1_, (ValaCCodeExpression*) _tmp3_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	_vala_ccode_node_unref0 (_tmp1_);
	cforinit = _tmp5_;
	_tmp6_ = vala_ccode_identifier_new ("i");
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_identifier_new ("array_length");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) _tmp7_, (ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	_vala_ccode_node_unref0 (_tmp7_);
	cforcond = _tmp11_;
	_tmp12_ = vala_ccode_identifier_new ("i");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new ("i");
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_constant_new ("1");
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp15_, (ValaCCodeExpression*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp21_ = _tmp20_;
	_vala_ccode_node_unref0 (_tmp19_);
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp13_);
	cforiter = _tmp21_;
	_tmp22_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp23_ = _tmp22_;
	vala_ccode_function_open_for (_tmp23_, (ValaCCodeExpression*) cforinit, (ValaCCodeExpression*) cforcond, (ValaCCodeExpression*) cforiter);
	_tmp24_ = vala_ccode_identifier_new ("array");
	cptrarray = _tmp24_;
	_tmp25_ = vala_ccode_identifier_new ("i");
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_ccode_node_unref0 (_tmp26_);
	cea = _tmp28_;
	_tmp29_ = vala_struct_value_type_new (st);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp30_, FALSE);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_function_call_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_ccode_node_unref0 (_tmp32_);
	_vala_code_node_unref0 (_tmp30_);
	cfreecall = _tmp34_;
	_tmp35_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) cea);
	_tmp36_ = _tmp35_;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	vala_ccode_function_add_expression (_tmp38_, (ValaCCodeExpression*) cfreecall);
	_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp40_ = _tmp39_;
	vala_ccode_function_close (_tmp40_);
	_vala_ccode_node_unref0 (cfreecall);
	_vala_ccode_node_unref0 (cea);
	_vala_ccode_node_unref0 (cptrarray);
	_vala_ccode_node_unref0 (cforiter);
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (cforinit);
}


static gchar*
vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base,
                                                       ValaStruct* st)
{
	ValaCCodeArrayModule * self;
	gchar* result = NULL;
	gchar* cname = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFile* _tmp4_;
	const gchar* _tmp5_;
	ValaCCodeFunction* fun = NULL;
	const gchar* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeBinaryExpression* ccondarr = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeBinaryExpression* _tmp24_;
	ValaCCodeBinaryExpression* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeFunction* _tmp27_;
	ValaCCodeBinaryExpression* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunctionCall* carrfree = NULL;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFile* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFile* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (st != NULL, NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) st);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_array_free", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cname = _tmp3_;
	_tmp4_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp5_ = cname;
	if (vala_ccode_file_add_declaration (_tmp4_, _tmp5_)) {
		result = cname;
		return result;
	}
	_tmp6_ = cname;
	_tmp7_ = vala_ccode_function_new (_tmp6_, "void");
	fun = _tmp7_;
	_tmp8_ = fun;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = fun;
	_tmp10_ = vala_get_ccode_name ((ValaCodeNode*) st);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s *", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_parameter_new ("array", _tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp9_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp16_ = fun;
	_tmp17_ = vala_ccode_parameter_new ("array_length", "gint");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("array");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_constant_new ("NULL");
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp21_, (ValaCCodeExpression*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_ccode_node_unref0 (_tmp23_);
	_vala_ccode_node_unref0 (_tmp21_);
	ccondarr = _tmp25_;
	_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = ccondarr;
	vala_ccode_function_open_if (_tmp27_, (ValaCCodeExpression*) _tmp28_);
	_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_variable_declarator_new ("i", NULL, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp30_, "int", (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	vala_ccode_array_module_append_struct_array_free_loop (self, st);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	vala_ccode_function_close (_tmp34_);
	_tmp35_ = vala_ccode_identifier_new ("g_free");
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
	_tmp38_ = _tmp37_;
	_vala_ccode_node_unref0 (_tmp36_);
	carrfree = _tmp38_;
	_tmp39_ = carrfree;
	_tmp40_ = vala_ccode_identifier_new ("array");
	_tmp41_ = _tmp40_;
	vala_ccode_function_call_add_argument (_tmp39_, (ValaCCodeExpression*) _tmp41_);
	_vala_ccode_node_unref0 (_tmp41_);
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = carrfree;
	vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) _tmp44_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp45_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp46_ = fun;
	vala_ccode_file_add_function_declaration (_tmp45_, _tmp46_);
	_tmp47_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp48_ = fun;
	vala_ccode_file_add_function (_tmp47_, _tmp48_);
	result = cname;
	_vala_ccode_node_unref0 (carrfree);
	_vala_ccode_node_unref0 (ccondarr);
	_vala_ccode_node_unref0 (fun);
	return result;
}


static gchar*
vala_ccode_array_module_real_append_struct_array_destroy (ValaCCodeBaseModule* base,
                                                          ValaStruct* st)
{
	ValaCCodeArrayModule * self;
	gchar* result = NULL;
	gchar* cname = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFile* _tmp4_;
	const gchar* _tmp5_;
	ValaCCodeFunction* fun = NULL;
	const gchar* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeParameter* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeBinaryExpression* ccondarr = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeConstant* _tmp26_;
	ValaCCodeBinaryExpression* _tmp27_;
	ValaCCodeBinaryExpression* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeBinaryExpression* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaDataType* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	ValaCCodeVariableDeclarator* _tmp37_;
	ValaCCodeVariableDeclarator* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFile* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFile* _tmp43_;
	ValaCCodeFunction* _tmp44_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (st != NULL, NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) st);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_array_destroy", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cname = _tmp3_;
	_tmp4_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp5_ = cname;
	if (vala_ccode_file_add_declaration (_tmp4_, _tmp5_)) {
		result = cname;
		return result;
	}
	_tmp6_ = cname;
	_tmp7_ = vala_ccode_function_new (_tmp6_, "void");
	fun = _tmp7_;
	_tmp8_ = fun;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = fun;
	_tmp10_ = vala_get_ccode_name ((ValaCodeNode*) st);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s *", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_parameter_new ("array", _tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp9_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp16_ = fun;
	_tmp17_ = ((ValaCCodeBaseModule*) self)->int_type;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_parameter_new ("array_length", _tmp19_);
	_tmp21_ = _tmp20_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp22_ = fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp22_);
	_tmp23_ = vala_ccode_identifier_new ("array");
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_constant_new ("NULL");
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp24_, (ValaCCodeExpression*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp24_);
	ccondarr = _tmp28_;
	_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = ccondarr;
	vala_ccode_function_open_if (_tmp30_, (ValaCCodeExpression*) _tmp31_);
	_tmp32_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = ((ValaCCodeBaseModule*) self)->int_type;
	_tmp35_ = vala_get_ccode_name ((ValaCodeNode*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_ccode_variable_declarator_new ("i", NULL, NULL);
	_tmp38_ = _tmp37_;
	vala_ccode_function_add_declaration (_tmp33_, _tmp36_, (ValaCCodeDeclarator*) _tmp38_, 0);
	_vala_ccode_node_unref0 (_tmp38_);
	_g_free0 (_tmp36_);
	vala_ccode_array_module_append_struct_array_free_loop (self, st);
	_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp40_ = _tmp39_;
	vala_ccode_function_close (_tmp40_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp42_ = fun;
	vala_ccode_file_add_function_declaration (_tmp41_, _tmp42_);
	_tmp43_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp44_ = fun;
	vala_ccode_file_add_function (_tmp43_, _tmp44_);
	result = cname;
	_vala_ccode_node_unref0 (ccondarr);
	_vala_ccode_node_unref0 (fun);
	return result;
}


static void
vala_ccode_array_module_append_vala_array_free_loop (ValaCCodeArrayModule* self)
{
	ValaCCodeAssignment* cforinit = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeConstant* _tmp3_;
	ValaCCodeAssignment* _tmp4_;
	ValaCCodeAssignment* _tmp5_;
	ValaCCodeBinaryExpression* cforcond = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeAssignment* cforiter = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeBinaryExpression* _tmp18_;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeAssignment* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeCastExpression* cptrarray = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeCastExpression* _tmp26_;
	ValaCCodeCastExpression* _tmp27_;
	ValaCCodeElementAccess* cea = NULL;
	ValaCCodeIdentifier* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeElementAccess* _tmp30_;
	ValaCCodeElementAccess* _tmp31_;
	ValaCCodeBinaryExpression* cfreecond = NULL;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeBinaryExpression* _tmp34_;
	ValaCCodeBinaryExpression* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunctionCall* cfreecall = NULL;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_constant_new ("0");
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp1_, (ValaCCodeExpression*) _tmp3_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	_vala_ccode_node_unref0 (_tmp1_);
	cforinit = _tmp5_;
	_tmp6_ = vala_ccode_identifier_new ("i");
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_identifier_new ("array_length");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) _tmp7_, (ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	_vala_ccode_node_unref0 (_tmp7_);
	cforcond = _tmp11_;
	_tmp12_ = vala_ccode_identifier_new ("i");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new ("i");
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_constant_new ("1");
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp15_, (ValaCCodeExpression*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp21_ = _tmp20_;
	_vala_ccode_node_unref0 (_tmp19_);
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp13_);
	cforiter = _tmp21_;
	_tmp22_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp23_ = _tmp22_;
	vala_ccode_function_open_for (_tmp23_, (ValaCCodeExpression*) cforinit, (ValaCCodeExpression*) cforcond, (ValaCCodeExpression*) cforiter);
	_tmp24_ = vala_ccode_identifier_new ("array");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp25_, "gpointer*");
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	cptrarray = _tmp27_;
	_tmp28_ = vala_ccode_identifier_new ("i");
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) _tmp29_);
	_tmp31_ = _tmp30_;
	_vala_ccode_node_unref0 (_tmp29_);
	cea = _tmp31_;
	_tmp32_ = vala_ccode_constant_new ("NULL");
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) cea, (ValaCCodeExpression*) _tmp33_);
	_tmp35_ = _tmp34_;
	_vala_ccode_node_unref0 (_tmp33_);
	cfreecond = _tmp35_;
	_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp37_ = _tmp36_;
	vala_ccode_function_open_if (_tmp37_, (ValaCCodeExpression*) cfreecond);
	_tmp38_ = vala_ccode_identifier_new ("destroy_func");
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp39_);
	_tmp41_ = _tmp40_;
	_vala_ccode_node_unref0 (_tmp39_);
	cfreecall = _tmp41_;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) cea);
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) cfreecall);
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_vala_ccode_node_unref0 (cfreecall);
	_vala_ccode_node_unref0 (cfreecond);
	_vala_ccode_node_unref0 (cea);
	_vala_ccode_node_unref0 (cptrarray);
	_vala_ccode_node_unref0 (cforiter);
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (cforinit);
}


static void
vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base)
{
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun = NULL;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeBinaryExpression* ccondarr = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeBinaryExpression* _tmp16_;
	ValaCCodeBinaryExpression* _tmp17_;
	ValaCCodeBinaryExpression* ccondfunc = NULL;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeConstant* _tmp21_;
	ValaCCodeBinaryExpression* _tmp22_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeBinaryExpression* _tmp26_;
	ValaCCodeBinaryExpression* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeVariableDeclarator* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFile* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFile* _tmp36_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeParameter* _tmp41_;
	ValaCCodeParameter* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeParameter* _tmp44_;
	ValaCCodeParameter* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeParameter* _tmp47_;
	ValaCCodeParameter* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeFunctionCall* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* carrfree = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFile* _tmp70_;
	ValaCCodeFunction* _tmp71_;
	ValaCCodeFile* _tmp72_;
	ValaCCodeFunction* _tmp73_;
	self = (ValaCCodeArrayModule*) base;
	_tmp0_ = vala_ccode_function_new ("_vala_array_destroy", "void");
	fun = _tmp0_;
	_tmp1_ = fun;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp1_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp2_ = fun;
	_tmp3_ = vala_ccode_parameter_new ("array", "gpointer");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = fun;
	_tmp6_ = vala_ccode_parameter_new ("array_length", "gint");
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = fun;
	_tmp9_ = vala_ccode_parameter_new ("destroy_func", "GDestroyNotify");
	_tmp10_ = _tmp9_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp11_ = fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("array");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_constant_new ("NULL");
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp15_);
	_tmp17_ = _tmp16_;
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp13_);
	ccondarr = _tmp17_;
	_tmp18_ = vala_ccode_identifier_new ("destroy_func");
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_constant_new ("NULL");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp19_, (ValaCCodeExpression*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	_vala_ccode_node_unref0 (_tmp19_);
	ccondfunc = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccondarr, (ValaCCodeExpression*) ccondfunc);
	_tmp27_ = _tmp26_;
	vala_ccode_function_open_if (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_ccode_variable_declarator_new ("i", NULL, NULL);
	_tmp31_ = _tmp30_;
	vala_ccode_function_add_declaration (_tmp29_, "int", (ValaCCodeDeclarator*) _tmp31_, 0);
	_vala_ccode_node_unref0 (_tmp31_);
	vala_ccode_array_module_append_vala_array_free_loop (self);
	_tmp32_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp33_ = _tmp32_;
	vala_ccode_function_close (_tmp33_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp34_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp35_ = fun;
	vala_ccode_file_add_function_declaration (_tmp34_, _tmp35_);
	_tmp36_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp37_ = fun;
	vala_ccode_file_add_function (_tmp36_, _tmp37_);
	_tmp38_ = vala_ccode_function_new ("_vala_array_free", "void");
	_vala_ccode_node_unref0 (fun);
	fun = _tmp38_;
	_tmp39_ = fun;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp39_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp40_ = fun;
	_tmp41_ = vala_ccode_parameter_new ("array", "gpointer");
	_tmp42_ = _tmp41_;
	vala_ccode_function_add_parameter (_tmp40_, _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = fun;
	_tmp44_ = vala_ccode_parameter_new ("array_length", "gint");
	_tmp45_ = _tmp44_;
	vala_ccode_function_add_parameter (_tmp43_, _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = fun;
	_tmp47_ = vala_ccode_parameter_new ("destroy_func", "GDestroyNotify");
	_tmp48_ = _tmp47_;
	vala_ccode_function_add_parameter (_tmp46_, _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp49_);
	_tmp50_ = vala_ccode_identifier_new ("_vala_array_destroy");
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp51_);
	_tmp53_ = _tmp52_;
	_vala_ccode_node_unref0 (_tmp51_);
	ccall = _tmp53_;
	_tmp54_ = vala_ccode_identifier_new ("array");
	_tmp55_ = _tmp54_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp55_);
	_vala_ccode_node_unref0 (_tmp55_);
	_tmp56_ = vala_ccode_identifier_new ("array_length");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_identifier_new ("destroy_func");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) ccall);
	_tmp62_ = vala_ccode_identifier_new ("g_free");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	carrfree = _tmp65_;
	_tmp66_ = vala_ccode_identifier_new ("array");
	_tmp67_ = _tmp66_;
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) _tmp67_);
	_vala_ccode_node_unref0 (_tmp67_);
	_tmp68_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp69_ = _tmp68_;
	vala_ccode_function_add_expression (_tmp69_, (ValaCCodeExpression*) carrfree);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp70_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp71_ = fun;
	vala_ccode_file_add_function_declaration (_tmp70_, _tmp71_);
	_tmp72_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp73_ = fun;
	vala_ccode_file_add_function (_tmp72_, _tmp73_);
	_vala_ccode_node_unref0 (carrfree);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (ccondfunc);
	_vala_ccode_node_unref0 (ccondarr);
	_vala_ccode_node_unref0 (fun);
}


static void
vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base)
{
	ValaCCodeArrayModule * self;
	ValaCCodeFile* _tmp0_;
	ValaCCodeFunction* fun = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeParameter* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeParameter* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeCastExpression* array = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeCastExpression* _tmp15_;
	ValaCCodeIdentifier* element_size = NULL;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeIdentifier* length = NULL;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* src = NULL;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeBinaryExpression* src_end = NULL;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeIdentifier* dest = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeBinaryExpression* dest_end = NULL;
	ValaCCodeBinaryExpression* _tmp21_;
	ValaCCodeBinaryExpression* src_address = NULL;
	ValaCCodeBinaryExpression* _tmp22_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeBinaryExpression* _tmp24_;
	ValaCCodeBinaryExpression* _tmp25_;
	ValaCCodeBinaryExpression* dest_address = NULL;
	ValaCCodeBinaryExpression* _tmp26_;
	ValaCCodeBinaryExpression* _tmp27_;
	ValaCCodeBinaryExpression* _tmp28_;
	ValaCCodeBinaryExpression* _tmp29_;
	ValaCCodeBinaryExpression* dest_end_address = NULL;
	ValaCCodeBinaryExpression* _tmp30_;
	ValaCCodeBinaryExpression* _tmp31_;
	ValaCCodeBinaryExpression* _tmp32_;
	ValaCCodeBinaryExpression* _tmp33_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	ValaCCodeBinaryExpression* _tmp38_;
	ValaCCodeBinaryExpression* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeBinaryExpression* _tmp44_;
	ValaCCodeBinaryExpression* _tmp45_;
	ValaCCodeBinaryExpression* _tmp46_;
	ValaCCodeBinaryExpression* _tmp47_;
	ValaCCodeBinaryExpression* _tmp48_;
	ValaCCodeBinaryExpression* _tmp49_;
	ValaCCodeFunctionCall* czero1 = NULL;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeFunctionCall* _tmp53_;
	ValaCCodeConstant* _tmp54_;
	ValaCCodeConstant* _tmp55_;
	ValaCCodeBinaryExpression* _tmp56_;
	ValaCCodeBinaryExpression* _tmp57_;
	ValaCCodeBinaryExpression* _tmp58_;
	ValaCCodeBinaryExpression* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunction* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeBinaryExpression* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeBinaryExpression* _tmp67_;
	ValaCCodeBinaryExpression* _tmp68_;
	ValaCCodeBinaryExpression* _tmp69_;
	ValaCCodeFunctionCall* czero2 = NULL;
	ValaCCodeIdentifier* _tmp70_;
	ValaCCodeIdentifier* _tmp71_;
	ValaCCodeFunctionCall* _tmp72_;
	ValaCCodeFunctionCall* _tmp73_;
	ValaCCodeConstant* _tmp74_;
	ValaCCodeConstant* _tmp75_;
	ValaCCodeBinaryExpression* _tmp76_;
	ValaCCodeBinaryExpression* _tmp77_;
	ValaCCodeBinaryExpression* _tmp78_;
	ValaCCodeBinaryExpression* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeFunction* _tmp81_;
	ValaCCodeFunction* _tmp82_;
	ValaCCodeFunction* _tmp83_;
	ValaCCodeBinaryExpression* _tmp84_;
	ValaCCodeBinaryExpression* _tmp85_;
	ValaCCodeFunctionCall* czero3 = NULL;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeFunctionCall* _tmp89_;
	ValaCCodeConstant* _tmp90_;
	ValaCCodeConstant* _tmp91_;
	ValaCCodeBinaryExpression* _tmp92_;
	ValaCCodeBinaryExpression* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunction* _tmp95_;
	ValaCCodeFunction* _tmp96_;
	ValaCCodeFunction* _tmp97_;
	ValaCCodeFile* _tmp98_;
	ValaCCodeFile* _tmp99_;
	self = (ValaCCodeArrayModule*) base;
	_tmp0_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp0_, "string.h", FALSE);
	_tmp1_ = vala_ccode_function_new ("_vala_array_move", "void");
	fun = _tmp1_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp2_ = vala_ccode_parameter_new ("array", "gpointer");
	_tmp3_ = _tmp2_;
	vala_ccode_function_add_parameter (fun, _tmp3_);
	_vala_ccode_node_unref0 (_tmp3_);
	_tmp4_ = vala_ccode_parameter_new ("element_size", "gsize");
	_tmp5_ = _tmp4_;
	vala_ccode_function_add_parameter (fun, _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_parameter_new ("src", "gint");
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (fun, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_parameter_new ("dest", "gint");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (fun, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_parameter_new ("length", "gint");
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_parameter (fun, _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, fun);
	_tmp12_ = vala_ccode_identifier_new ("array");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "char*");
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	array = _tmp15_;
	_tmp16_ = vala_ccode_identifier_new ("element_size");
	element_size = _tmp16_;
	_tmp17_ = vala_ccode_identifier_new ("length");
	length = _tmp17_;
	_tmp18_ = vala_ccode_identifier_new ("src");
	src = _tmp18_;
	_tmp19_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) src, (ValaCCodeExpression*) length);
	src_end = _tmp19_;
	_tmp20_ = vala_ccode_identifier_new ("dest");
	dest = _tmp20_;
	_tmp21_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) length);
	dest_end = _tmp21_;
	_tmp22_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) src, (ValaCCodeExpression*) element_size);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_ccode_node_unref0 (_tmp23_);
	src_address = _tmp25_;
	_tmp26_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) element_size);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) _tmp27_);
	_tmp29_ = _tmp28_;
	_vala_ccode_node_unref0 (_tmp27_);
	dest_address = _tmp29_;
	_tmp30_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) dest_end, (ValaCCodeExpression*) element_size);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) _tmp31_);
	_tmp33_ = _tmp32_;
	_vala_ccode_node_unref0 (_tmp31_);
	dest_end_address = _tmp33_;
	_tmp34_ = vala_ccode_identifier_new ("memmove");
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
	_tmp37_ = _tmp36_;
	_vala_ccode_node_unref0 (_tmp35_);
	ccall = _tmp37_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) dest_address);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) src_address);
	_tmp38_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) length, (ValaCCodeExpression*) element_size);
	_tmp39_ = _tmp38_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (_tmp39_);
	_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_expression (_tmp41_, (ValaCCodeExpression*) ccall);
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) src_end, (ValaCCodeExpression*) dest);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp47_);
	_tmp49_ = _tmp48_;
	vala_ccode_function_open_if (_tmp43_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_vala_ccode_node_unref0 (_tmp47_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp50_ = vala_ccode_identifier_new ("memset");
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp51_);
	_tmp53_ = _tmp52_;
	_vala_ccode_node_unref0 (_tmp51_);
	czero1 = _tmp53_;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) src_address);
	_tmp54_ = vala_ccode_constant_new ("0");
	_tmp55_ = _tmp54_;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) _tmp55_);
	_vala_ccode_node_unref0 (_tmp55_);
	_tmp56_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) src);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) element_size);
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) czero1);
	_tmp62_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest_end);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) _tmp65_, (ValaCCodeExpression*) _tmp67_);
	_tmp69_ = _tmp68_;
	vala_ccode_function_else_if (_tmp63_, (ValaCCodeExpression*) _tmp69_);
	_vala_ccode_node_unref0 (_tmp69_);
	_vala_ccode_node_unref0 (_tmp67_);
	_vala_ccode_node_unref0 (_tmp65_);
	_tmp70_ = vala_ccode_identifier_new ("memset");
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp71_);
	_tmp73_ = _tmp72_;
	_vala_ccode_node_unref0 (_tmp71_);
	czero2 = _tmp73_;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) dest_end_address);
	_tmp74_ = vala_ccode_constant_new ("0");
	_tmp75_ = _tmp74_;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) _tmp75_);
	_vala_ccode_node_unref0 (_tmp75_);
	_tmp76_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp77_, (ValaCCodeExpression*) element_size);
	_tmp79_ = _tmp78_;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) _tmp79_);
	_vala_ccode_node_unref0 (_tmp79_);
	_vala_ccode_node_unref0 (_tmp77_);
	_tmp80_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp81_ = _tmp80_;
	vala_ccode_function_add_expression (_tmp81_, (ValaCCodeExpression*) czero2);
	_tmp82_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest);
	_tmp85_ = _tmp84_;
	vala_ccode_function_else_if (_tmp83_, (ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp86_ = vala_ccode_identifier_new ("memset");
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp87_);
	_tmp89_ = _tmp88_;
	_vala_ccode_node_unref0 (_tmp87_);
	czero3 = _tmp89_;
	vala_ccode_function_call_add_argument (czero3, (ValaCCodeExpression*) src_address);
	_tmp90_ = vala_ccode_constant_new ("0");
	_tmp91_ = _tmp90_;
	vala_ccode_function_call_add_argument (czero3, (ValaCCodeExpression*) _tmp91_);
	_vala_ccode_node_unref0 (_tmp91_);
	_tmp92_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) length, (ValaCCodeExpression*) element_size);
	_tmp93_ = _tmp92_;
	vala_ccode_function_call_add_argument (czero3, (ValaCCodeExpression*) _tmp93_);
	_vala_ccode_node_unref0 (_tmp93_);
	_tmp94_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp95_ = _tmp94_;
	vala_ccode_function_add_expression (_tmp95_, (ValaCCodeExpression*) czero3);
	_tmp96_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp97_ = _tmp96_;
	vala_ccode_function_close (_tmp97_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp98_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function_declaration (_tmp98_, fun);
	_tmp99_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp99_, fun);
	_vala_ccode_node_unref0 (czero3);
	_vala_ccode_node_unref0 (czero2);
	_vala_ccode_node_unref0 (czero1);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (dest_end_address);
	_vala_ccode_node_unref0 (dest_address);
	_vala_ccode_node_unref0 (src_address);
	_vala_ccode_node_unref0 (dest_end);
	_vala_ccode_node_unref0 (dest);
	_vala_ccode_node_unref0 (src_end);
	_vala_ccode_node_unref0 (src);
	_vala_ccode_node_unref0 (length);
	_vala_ccode_node_unref0 (element_size);
	_vala_ccode_node_unref0 (array);
	_vala_ccode_node_unref0 (fun);
}


static void
vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base)
{
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun = NULL;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeParameter* _tmp1_;
	ValaCCodeParameter* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeConstant* _tmp5_;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeVariableDeclarator* _tmp7_;
	ValaCCodeVariableDeclarator* _tmp8_;
	ValaCCodeIdentifier* array_check = NULL;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeElementAccess* array_element_check = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeCastExpression* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeElementAccess* _tmp18_;
	ValaCCodeElementAccess* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeUnaryExpression* _tmp26_;
	ValaCCodeUnaryExpression* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeFile* _tmp36_;
	ValaCCodeFile* _tmp37_;
	self = (ValaCCodeArrayModule*) base;
	_tmp0_ = vala_ccode_function_new ("_vala_array_length", "gint");
	fun = _tmp0_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp1_ = vala_ccode_parameter_new ("array", "gpointer");
	_tmp2_ = _tmp1_;
	vala_ccode_function_add_parameter (fun, _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, fun);
	_tmp3_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_constant_new ("0");
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_variable_declarator_new ("length", (ValaCCodeExpression*) _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	vala_ccode_function_add_declaration (_tmp4_, "int", (ValaCCodeDeclarator*) _tmp8_, 0);
	_vala_ccode_node_unref0 (_tmp8_);
	_vala_ccode_node_unref0 (_tmp6_);
	_tmp9_ = vala_ccode_identifier_new ("array");
	array_check = _tmp9_;
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_open_if (_tmp11_, (ValaCCodeExpression*) array_check);
	_tmp12_ = vala_ccode_identifier_new ("array");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "gpointer*");
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_constant_new ("length");
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp15_, (ValaCCodeExpression*) _tmp17_);
	_tmp19_ = _tmp18_;
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp13_);
	array_element_check = _tmp19_;
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	vala_ccode_function_open_while (_tmp21_, (ValaCCodeExpression*) array_element_check);
	_tmp22_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_identifier_new ("length");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_expression (_tmp23_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp29_ = _tmp28_;
	vala_ccode_function_close (_tmp29_);
	_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp31_ = _tmp30_;
	vala_ccode_function_close (_tmp31_);
	_tmp32_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_identifier_new ("length");
	_tmp35_ = _tmp34_;
	vala_ccode_function_add_return (_tmp33_, (ValaCCodeExpression*) _tmp35_);
	_vala_ccode_node_unref0 (_tmp35_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp36_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function_declaration (_tmp36_, fun);
	_tmp37_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp37_, fun);
	_vala_ccode_node_unref0 (array_element_check);
	_vala_ccode_node_unref0 (array_check);
	_vala_ccode_node_unref0 (fun);
}


static ValaTargetValue*
vala_ccode_array_module_real_copy_value (ValaCCodeBaseModule* base,
                                         ValaTargetValue* value,
                                         ValaCodeNode* node)
{
	ValaCCodeArrayModule * self;
	ValaTargetValue* result = NULL;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaCCodeExpression* cexpr = NULL;
	ValaCCodeExpression* _tmp3_;
	ValaDataType* _tmp4_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_target_value_get_value_type (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	type = _tmp2_;
	_tmp3_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, value);
	cexpr = _tmp3_;
	_tmp4_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp5_;
		ValaArrayType* _tmp6_;
		ValaArrayType* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		ValaTargetValue* temp_value = NULL;
		ValaDataType* _tmp11_;
		ValaTargetValue* _tmp12_;
		ValaCCodeFunctionCall* copy_call = NULL;
		ValaArrayType* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaCCodeIdentifier* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunctionCall* _tmp20_;
		ValaCCodeExpression* _tmp21_;
		ValaCCodeFunctionCall* _tmp22_;
		ValaTargetValue* _tmp23_;
		ValaCCodeExpression* _tmp24_;
		ValaCCodeExpression* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunctionCall* _tmp28_;
		_tmp5_ = type;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp6_;
		_tmp7_ = array_type;
		_tmp8_ = vala_array_type_get_fixed_length (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			ValaTargetValue* _tmp10_;
			_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->copy_value ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), value, node);
			result = _tmp10_;
			_vala_code_node_unref0 (array_type);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp11_ = type;
		_tmp12_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp11_, FALSE, node, NULL);
		temp_value = _tmp12_;
		_tmp13_ = array_type;
		_tmp14_ = vala_ccode_array_module_generate_array_copy_wrapper (self, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_ccode_identifier_new (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_ccode_node_unref0 (_tmp17_);
		_g_free0 (_tmp15_);
		copy_call = _tmp19_;
		_tmp20_ = copy_call;
		_tmp21_ = cexpr;
		vala_ccode_function_call_add_argument (_tmp20_, _tmp21_);
		_tmp22_ = copy_call;
		_tmp23_ = temp_value;
		_tmp24_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_ccode_function_call_add_argument (_tmp22_, _tmp25_);
		_vala_ccode_node_unref0 (_tmp25_);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = copy_call;
		vala_ccode_function_add_expression (_tmp27_, (ValaCCodeExpression*) _tmp28_);
		result = temp_value;
		_vala_ccode_node_unref0 (copy_call);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (cexpr);
		_vala_code_node_unref0 (type);
		return result;
	} else {
		ValaTargetValue* _tmp29_;
		_tmp29_ = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->copy_value ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), value, node);
		result = _tmp29_;
		_vala_ccode_node_unref0 (cexpr);
		_vala_code_node_unref0 (type);
		return result;
	}
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (type);
}


static ValaCCodeExpression*
vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base,
                                                      ValaDataType* type,
                                                      ValaSourceReference* source_reference,
                                                      gboolean is_chainup)
{
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaArrayType* _tmp0_;
		ValaArrayType* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		ValaArrayType* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeExpression* _tmp8_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp0_;
		_tmp1_ = array_type;
		_tmp2_ = vala_array_type_get_fixed_length (_tmp1_);
		_tmp3_ = _tmp2_;
		_vala_assert (!_tmp3_, "!array_type.fixed_length");
		_tmp4_ = array_type;
		_tmp5_ = vala_ccode_array_module_generate_array_dup_wrapper (self, _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_identifier_new (_tmp6_);
		_tmp8_ = (ValaCCodeExpression*) _tmp7_;
		_g_free0 (_tmp6_);
		result = _tmp8_;
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		ValaCCodeExpression* _tmp9_;
		_tmp9_ = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_dup_func_expression ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), type, source_reference, is_chainup);
		result = _tmp9_;
		return result;
	}
}


static ValaCCodeExpression*
vala_ccode_array_module_real_destroy_value (ValaCCodeBaseModule* base,
                                            ValaTargetValue* value,
                                            gboolean is_macro_definition)
{
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaArrayType* _tmp3_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = vala_target_value_get_value_type (value);
	_tmp1_ = _tmp0_;
	array_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp1_) : NULL;
	_tmp3_ = array_type;
	if (_tmp3_ != NULL) {
		ValaArrayType* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = array_type;
		_tmp5_ = vala_array_type_get_fixed_length (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaStruct* st = NULL;
		ValaArrayType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		ValaTypeSymbol* _tmp11_;
		gboolean _tmp12_ = FALSE;
		ValaStruct* _tmp13_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeIdentifier* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeFunctionCall* _tmp39_;
		ValaCCodeExpression* _tmp40_;
		ValaCCodeExpression* _tmp41_;
		ValaCCodeFunctionCall* _tmp42_;
		ValaArrayType* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaCCodeExpression* _tmp46_;
		ValaCCodeExpression* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaArrayType* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		ValaCCodeExpression* _tmp52_;
		ValaCCodeExpression* _tmp53_;
		ValaCCodeCastExpression* _tmp54_;
		ValaCCodeCastExpression* _tmp55_;
		_tmp7_ = array_type;
		_tmp8_ = vala_array_type_get_element_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_data_type_get_data_type (_tmp9_);
		_tmp11_ = _tmp10_;
		st = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp11_) : NULL;
		_tmp13_ = st;
		if (_tmp13_ != NULL) {
			ValaArrayType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp14_ = array_type;
			_tmp15_ = vala_array_type_get_element_type (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_data_type_get_nullable (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = !_tmp18_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaStruct* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			ValaCCodeIdentifier* _tmp22_;
			ValaCCodeIdentifier* _tmp23_;
			ValaCCodeFunctionCall* _tmp24_;
			ValaCCodeFunctionCall* _tmp25_;
			ValaCCodeFunctionCall* _tmp26_;
			ValaCCodeExpression* _tmp27_;
			ValaCCodeExpression* _tmp28_;
			ValaCCodeFunctionCall* _tmp29_;
			ValaArrayType* _tmp30_;
			ValaExpression* _tmp31_;
			ValaExpression* _tmp32_;
			ValaCCodeExpression* _tmp33_;
			ValaCCodeExpression* _tmp34_;
			_tmp19_ = st;
			_tmp20_ = vala_ccode_base_module_append_struct_array_destroy ((ValaCCodeBaseModule*) self, _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_ccode_identifier_new (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp23_);
			_tmp25_ = _tmp24_;
			_vala_ccode_node_unref0 (_tmp23_);
			_g_free0 (_tmp21_);
			ccall = _tmp25_;
			_tmp26_ = ccall;
			_tmp27_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, value);
			_tmp28_ = _tmp27_;
			vala_ccode_function_call_add_argument (_tmp26_, _tmp28_);
			_vala_ccode_node_unref0 (_tmp28_);
			_tmp29_ = ccall;
			_tmp30_ = array_type;
			_tmp31_ = vala_array_type_get_length (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_call_add_argument (_tmp29_, _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			result = (ValaCCodeExpression*) ccall;
			return result;
		}
		((ValaCCodeBaseModule*) self)->requires_array_free = TRUE;
		_tmp35_ = vala_ccode_identifier_new ("_vala_array_destroy");
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
		_tmp38_ = _tmp37_;
		_vala_ccode_node_unref0 (_tmp36_);
		ccall = _tmp38_;
		_tmp39_ = ccall;
		_tmp40_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, value);
		_tmp41_ = _tmp40_;
		vala_ccode_function_call_add_argument (_tmp39_, _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_tmp42_ = ccall;
		_tmp43_ = array_type;
		_tmp44_ = vala_array_type_get_length (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp45_);
		_tmp47_ = _tmp46_;
		vala_ccode_function_call_add_argument (_tmp42_, _tmp47_);
		_vala_ccode_node_unref0 (_tmp47_);
		_tmp48_ = ccall;
		_tmp49_ = array_type;
		_tmp50_ = vala_array_type_get_element_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp51_, FALSE);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_ccode_cast_expression_new (_tmp53_, "GDestroyNotify");
		_tmp55_ = _tmp54_;
		vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		result = (ValaCCodeExpression*) ccall;
		return result;
	} else {
		ValaCCodeExpression* _tmp56_;
		_tmp56_ = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->destroy_value ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), value, is_macro_definition);
		result = _tmp56_;
		return result;
	}
}


static gchar*
vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self,
                                                    ValaArrayType* array_type)
{
	gchar* result = NULL;
	gchar* dup_func = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaCCodeBaseModuleEmitContext* _tmp33_;
	ValaCCodeBaseModuleEmitContext* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaCCodeFile* _tmp184_;
	ValaCCodeFunction* _tmp185_;
	ValaCCodeFile* _tmp186_;
	ValaCCodeFunction* _tmp187_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1;
	_tmp0_ = self->priv->next_array_dup_id;
	_tmp1_ = g_strdup_printf ("_vala_array_dup%d", _tmp0_);
	dup_func = _tmp1_;
	_tmp2_ = dup_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp2_)) {
		result = dup_func;
		return result;
	}
	_tmp3_ = dup_func;
	_tmp4_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_new (_tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	function = _tmp7_;
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = function;
	_tmp10_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_ccode_parameter_new ("self", _tmp11_);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp9_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = function;
	_tmp15_ = vala_ccode_parameter_new ("length", "int");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = vala_array_type_get_element_type (array_type);
	_tmp18_ = _tmp17_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_GENERIC_TYPE)) {
		gchar* func_name = NULL;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaTypeParameter* _tmp21_;
		ValaTypeParameter* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		ValaCCodeFunction* _tmp29_;
		const gchar* _tmp30_;
		ValaCCodeParameter* _tmp31_;
		ValaCCodeParameter* _tmp32_;
		_tmp19_ = vala_array_type_get_element_type (array_type);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_ascii_strdown (_tmp24_, (gssize) -1);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf ("%s_dup_func", _tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		func_name = _tmp28_;
		_tmp29_ = function;
		_tmp30_ = func_name;
		_tmp31_ = vala_ccode_parameter_new (_tmp30_, "GBoxedCopyFunc");
		_tmp32_ = _tmp31_;
		vala_ccode_function_add_parameter (_tmp29_, _tmp32_);
		_vala_ccode_node_unref0 (_tmp32_);
		_g_free0 (func_name);
	}
	_tmp33_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp34_ = _tmp33_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp34_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp34_);
	_tmp35_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_array_type_get_element_type (array_type);
	_tmp37_ = _tmp36_;
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp37_)) {
		ValaCCodeVariableDeclarator* cvardecl = NULL;
		ValaCCodeVariableDeclarator* _tmp38_;
		ValaCCodeFunctionCall* gnew = NULL;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_;
		ValaCCodeFunctionCall* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		ValaCCodeIdentifier* _tmp48_;
		ValaCCodeIdentifier* _tmp49_;
		ValaCCodeExpression* length_expr = NULL;
		ValaCCodeIdentifier* _tmp50_;
		ValaCCodeBinaryOperator length_check_op = 0;
		gboolean _tmp51_ = FALSE;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaTypeSymbol* _tmp54_;
		ValaTypeSymbol* _tmp55_;
		ValaCCodeFunctionCall* _tmp64_;
		ValaCCodeExpression* _tmp65_;
		ValaCCodeBinaryExpression* length_check = NULL;
		ValaCCodeBinaryOperator _tmp66_;
		ValaCCodeIdentifier* _tmp67_;
		ValaCCodeIdentifier* _tmp68_;
		ValaCCodeConstant* _tmp69_;
		ValaCCodeConstant* _tmp70_;
		ValaCCodeBinaryExpression* _tmp71_;
		ValaCCodeBinaryExpression* _tmp72_;
		ValaCCodeFunction* _tmp73_;
		ValaCCodeFunction* _tmp74_;
		ValaCCodeBinaryExpression* _tmp75_;
		ValaCCodeFunction* _tmp76_;
		ValaCCodeFunction* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValaCCodeVariableDeclarator* _tmp80_;
		ValaCCodeFunction* _tmp81_;
		ValaCCodeFunction* _tmp82_;
		ValaCCodeIdentifier* _tmp83_;
		ValaCCodeIdentifier* _tmp84_;
		ValaCCodeFunctionCall* _tmp85_;
		ValaCCodeFunction* _tmp86_;
		ValaCCodeFunction* _tmp87_;
		ValaCCodeVariableDeclarator* _tmp88_;
		ValaCCodeVariableDeclarator* _tmp89_;
		ValaCCodeFunction* _tmp90_;
		ValaCCodeFunction* _tmp91_;
		ValaCCodeIdentifier* _tmp92_;
		ValaCCodeIdentifier* _tmp93_;
		ValaCCodeConstant* _tmp94_;
		ValaCCodeConstant* _tmp95_;
		ValaCCodeAssignment* _tmp96_;
		ValaCCodeAssignment* _tmp97_;
		ValaCCodeIdentifier* _tmp98_;
		ValaCCodeIdentifier* _tmp99_;
		ValaCCodeIdentifier* _tmp100_;
		ValaCCodeIdentifier* _tmp101_;
		ValaCCodeBinaryExpression* _tmp102_;
		ValaCCodeBinaryExpression* _tmp103_;
		ValaCCodeIdentifier* _tmp104_;
		ValaCCodeIdentifier* _tmp105_;
		ValaCCodeUnaryExpression* _tmp106_;
		ValaCCodeUnaryExpression* _tmp107_;
		ValaCCodeFunction* _tmp108_;
		ValaCCodeFunction* _tmp109_;
		ValaCCodeIdentifier* _tmp110_;
		ValaCCodeIdentifier* _tmp111_;
		ValaCCodeIdentifier* _tmp112_;
		ValaCCodeIdentifier* _tmp113_;
		ValaCCodeElementAccess* _tmp114_;
		ValaCCodeElementAccess* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		ValaCCodeIdentifier* _tmp118_;
		ValaCCodeIdentifier* _tmp119_;
		ValaCCodeIdentifier* _tmp120_;
		ValaCCodeIdentifier* _tmp121_;
		ValaCCodeElementAccess* _tmp122_;
		ValaCCodeElementAccess* _tmp123_;
		ValaGLibValue* _tmp124_;
		ValaGLibValue* _tmp125_;
		ValaTargetValue* _tmp126_;
		ValaTargetValue* _tmp127_;
		ValaCCodeExpression* _tmp128_;
		ValaCCodeExpression* _tmp129_;
		ValaCCodeFunction* _tmp130_;
		ValaCCodeFunction* _tmp131_;
		ValaCCodeFunction* _tmp132_;
		ValaCCodeFunction* _tmp133_;
		ValaCCodeIdentifier* _tmp134_;
		ValaCCodeIdentifier* _tmp135_;
		ValaCCodeFunction* _tmp136_;
		ValaCCodeFunction* _tmp137_;
		ValaCCodeFunction* _tmp138_;
		ValaCCodeFunction* _tmp139_;
		ValaCCodeIdentifier* _tmp140_;
		ValaCCodeIdentifier* _tmp141_;
		_tmp38_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
		cvardecl = _tmp38_;
		_tmp39_ = vala_ccode_identifier_new ("g_new0");
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
		_tmp42_ = _tmp41_;
		_vala_ccode_node_unref0 (_tmp40_);
		gnew = _tmp42_;
		_tmp43_ = gnew;
		_tmp44_ = vala_array_type_get_element_type (array_type);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_get_ccode_name ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_ccode_identifier_new (_tmp47_);
		_tmp49_ = _tmp48_;
		vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp49_);
		_vala_ccode_node_unref0 (_tmp49_);
		_g_free0 (_tmp47_);
		_tmp50_ = vala_ccode_identifier_new ("length");
		length_expr = (ValaCCodeExpression*) _tmp50_;
		_tmp52_ = vala_array_type_get_element_type (array_type);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_data_type_get_data_type (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_ != NULL) {
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			_tmp56_ = vala_array_type_get_element_type (array_type);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_data_type_get_data_type (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp51_ = vala_typesymbol_is_reference_type (_tmp59_);
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaCCodeExpression* _tmp60_;
			ValaCCodeConstant* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			ValaCCodeBinaryExpression* _tmp63_;
			_tmp60_ = length_expr;
			_tmp61_ = vala_ccode_constant_new ("1");
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp60_, (ValaCCodeExpression*) _tmp62_);
			_vala_ccode_node_unref0 (length_expr);
			length_expr = (ValaCCodeExpression*) _tmp63_;
			_vala_ccode_node_unref0 (_tmp62_);
			length_check_op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
		} else {
			length_check_op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
		}
		_tmp64_ = gnew;
		_tmp65_ = length_expr;
		vala_ccode_function_call_add_argument (_tmp64_, _tmp65_);
		_tmp66_ = length_check_op;
		_tmp67_ = vala_ccode_identifier_new ("length");
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_ccode_constant_new ("0");
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_ccode_binary_expression_new (_tmp66_, (ValaCCodeExpression*) _tmp68_, (ValaCCodeExpression*) _tmp70_);
		_tmp72_ = _tmp71_;
		_vala_ccode_node_unref0 (_tmp70_);
		_vala_ccode_node_unref0 (_tmp68_);
		length_check = _tmp72_;
		_tmp73_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = length_check;
		vala_ccode_function_open_if (_tmp74_, (ValaCCodeExpression*) _tmp75_);
		_tmp76_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
		_tmp79_ = _tmp78_;
		_tmp80_ = cvardecl;
		vala_ccode_function_add_declaration (_tmp77_, _tmp79_, (ValaCCodeDeclarator*) _tmp80_, 0);
		_g_free0 (_tmp79_);
		_tmp81_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_ccode_identifier_new ("result");
		_tmp84_ = _tmp83_;
		_tmp85_ = gnew;
		vala_ccode_function_add_assignment (_tmp82_, (ValaCCodeExpression*) _tmp84_, (ValaCCodeExpression*) _tmp85_);
		_vala_ccode_node_unref0 (_tmp84_);
		_tmp86_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_ccode_variable_declarator_new ("i", NULL, NULL);
		_tmp89_ = _tmp88_;
		vala_ccode_function_add_declaration (_tmp87_, "int", (ValaCCodeDeclarator*) _tmp89_, 0);
		_vala_ccode_node_unref0 (_tmp89_);
		_tmp90_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_ccode_identifier_new ("i");
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_ccode_constant_new ("0");
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp93_, (ValaCCodeExpression*) _tmp95_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_ccode_identifier_new ("i");
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_ccode_identifier_new ("length");
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) _tmp99_, (ValaCCodeExpression*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_ccode_identifier_new ("i");
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp105_);
		_tmp107_ = _tmp106_;
		vala_ccode_function_open_for (_tmp91_, (ValaCCodeExpression*) _tmp97_, (ValaCCodeExpression*) _tmp103_, (ValaCCodeExpression*) _tmp107_);
		_vala_ccode_node_unref0 (_tmp107_);
		_vala_ccode_node_unref0 (_tmp105_);
		_vala_ccode_node_unref0 (_tmp103_);
		_vala_ccode_node_unref0 (_tmp101_);
		_vala_ccode_node_unref0 (_tmp99_);
		_vala_ccode_node_unref0 (_tmp97_);
		_vala_ccode_node_unref0 (_tmp95_);
		_vala_ccode_node_unref0 (_tmp93_);
		_tmp108_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_ccode_identifier_new ("result");
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_ccode_identifier_new ("i");
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp111_, (ValaCCodeExpression*) _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_array_type_get_element_type (array_type);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_ccode_identifier_new ("self");
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_ccode_identifier_new ("i");
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp119_, (ValaCCodeExpression*) _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_glib_value_new (_tmp117_, (ValaCCodeExpression*) _tmp123_, TRUE);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp125_, (ValaCodeNode*) array_type);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp127_);
		_tmp129_ = _tmp128_;
		vala_ccode_function_add_assignment (_tmp109_, (ValaCCodeExpression*) _tmp115_, _tmp129_);
		_vala_ccode_node_unref0 (_tmp129_);
		_vala_target_value_unref0 (_tmp127_);
		_vala_target_value_unref0 (_tmp125_);
		_vala_ccode_node_unref0 (_tmp123_);
		_vala_ccode_node_unref0 (_tmp121_);
		_vala_ccode_node_unref0 (_tmp119_);
		_vala_ccode_node_unref0 (_tmp115_);
		_vala_ccode_node_unref0 (_tmp113_);
		_vala_ccode_node_unref0 (_tmp111_);
		_tmp130_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp131_ = _tmp130_;
		vala_ccode_function_close (_tmp131_);
		_tmp132_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_ccode_identifier_new ("result");
		_tmp135_ = _tmp134_;
		vala_ccode_function_add_return (_tmp133_, (ValaCCodeExpression*) _tmp135_);
		_vala_ccode_node_unref0 (_tmp135_);
		_tmp136_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp137_ = _tmp136_;
		vala_ccode_function_close (_tmp137_);
		_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_ccode_identifier_new ("NULL");
		_tmp141_ = _tmp140_;
		vala_ccode_function_add_return (_tmp139_, (ValaCCodeExpression*) _tmp141_);
		_vala_ccode_node_unref0 (_tmp141_);
		_vala_ccode_node_unref0 (length_check);
		_vala_ccode_node_unref0 (length_expr);
		_vala_ccode_node_unref0 (gnew);
		_vala_ccode_node_unref0 (cvardecl);
	} else {
		ValaCCodeBinaryExpression* length_check = NULL;
		ValaCCodeIdentifier* _tmp142_;
		ValaCCodeIdentifier* _tmp143_;
		ValaCCodeConstant* _tmp144_;
		ValaCCodeConstant* _tmp145_;
		ValaCCodeBinaryExpression* _tmp146_;
		ValaCCodeBinaryExpression* _tmp147_;
		ValaCCodeFunction* _tmp148_;
		ValaCCodeFunction* _tmp149_;
		ValaCCodeBinaryExpression* _tmp150_;
		ValaCCodeFunctionCall* dup_call = NULL;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeIdentifier* _tmp152_;
		ValaCCodeFunctionCall* _tmp153_;
		ValaCCodeFunctionCall* _tmp154_;
		ValaCCodeFunctionCall* _tmp155_;
		ValaCCodeIdentifier* _tmp156_;
		ValaCCodeIdentifier* _tmp157_;
		ValaCCodeFunctionCall* sizeof_call = NULL;
		ValaCCodeIdentifier* _tmp158_;
		ValaCCodeIdentifier* _tmp159_;
		ValaCCodeFunctionCall* _tmp160_;
		ValaCCodeFunctionCall* _tmp161_;
		ValaCCodeFunctionCall* _tmp162_;
		ValaDataType* _tmp163_;
		ValaDataType* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		ValaCCodeIdentifier* _tmp167_;
		ValaCCodeIdentifier* _tmp168_;
		ValaCCodeFunctionCall* _tmp169_;
		ValaCCodeIdentifier* _tmp170_;
		ValaCCodeIdentifier* _tmp171_;
		ValaCCodeFunctionCall* _tmp172_;
		ValaCCodeBinaryExpression* _tmp173_;
		ValaCCodeBinaryExpression* _tmp174_;
		ValaCCodeFunction* _tmp175_;
		ValaCCodeFunction* _tmp176_;
		ValaCCodeFunctionCall* _tmp177_;
		ValaCCodeFunction* _tmp178_;
		ValaCCodeFunction* _tmp179_;
		ValaCCodeFunction* _tmp180_;
		ValaCCodeFunction* _tmp181_;
		ValaCCodeIdentifier* _tmp182_;
		ValaCCodeIdentifier* _tmp183_;
		_tmp142_ = vala_ccode_identifier_new ("length");
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_constant_new ("0");
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) _tmp143_, (ValaCCodeExpression*) _tmp145_);
		_tmp147_ = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_vala_ccode_node_unref0 (_tmp143_);
		length_check = _tmp147_;
		_tmp148_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = length_check;
		vala_ccode_function_open_if (_tmp149_, (ValaCCodeExpression*) _tmp150_);
		_tmp151_ = vala_ccode_identifier_new ("g_memdup");
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp152_);
		_tmp154_ = _tmp153_;
		_vala_ccode_node_unref0 (_tmp152_);
		dup_call = _tmp154_;
		_tmp155_ = dup_call;
		_tmp156_ = vala_ccode_identifier_new ("self");
		_tmp157_ = _tmp156_;
		vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp157_);
		_vala_ccode_node_unref0 (_tmp157_);
		_tmp158_ = vala_ccode_identifier_new ("sizeof");
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
		_tmp161_ = _tmp160_;
		_vala_ccode_node_unref0 (_tmp159_);
		sizeof_call = _tmp161_;
		_tmp162_ = sizeof_call;
		_tmp163_ = vala_array_type_get_element_type (array_type);
		_tmp164_ = _tmp163_;
		_tmp165_ = vala_get_ccode_name ((ValaCodeNode*) _tmp164_);
		_tmp166_ = _tmp165_;
		_tmp167_ = vala_ccode_identifier_new (_tmp166_);
		_tmp168_ = _tmp167_;
		vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp168_);
		_vala_ccode_node_unref0 (_tmp168_);
		_g_free0 (_tmp166_);
		_tmp169_ = dup_call;
		_tmp170_ = vala_ccode_identifier_new ("length");
		_tmp171_ = _tmp170_;
		_tmp172_ = sizeof_call;
		_tmp173_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp171_, (ValaCCodeExpression*) _tmp172_);
		_tmp174_ = _tmp173_;
		vala_ccode_function_call_add_argument (_tmp169_, (ValaCCodeExpression*) _tmp174_);
		_vala_ccode_node_unref0 (_tmp174_);
		_vala_ccode_node_unref0 (_tmp171_);
		_tmp175_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = dup_call;
		vala_ccode_function_add_return (_tmp176_, (ValaCCodeExpression*) _tmp177_);
		_tmp178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp179_ = _tmp178_;
		vala_ccode_function_close (_tmp179_);
		_tmp180_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_identifier_new ("NULL");
		_tmp183_ = _tmp182_;
		vala_ccode_function_add_return (_tmp181_, (ValaCCodeExpression*) _tmp183_);
		_vala_ccode_node_unref0 (_tmp183_);
		_vala_ccode_node_unref0 (sizeof_call);
		_vala_ccode_node_unref0 (dup_call);
		_vala_ccode_node_unref0 (length_check);
	}
	_tmp184_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp185_ = function;
	vala_ccode_file_add_function_declaration (_tmp184_, _tmp185_);
	_tmp186_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp187_ = function;
	vala_ccode_file_add_function (_tmp186_, _tmp187_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = dup_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gchar*
vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self,
                                                     ValaArrayType* array_type)
{
	gchar* result = NULL;
	gchar* dup_func = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeBaseModuleEmitContext* _tmp20_;
	ValaCCodeBaseModuleEmitContext* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaCCodeFile* _tmp104_;
	ValaCCodeFunction* _tmp105_;
	ValaCCodeFile* _tmp106_;
	ValaCCodeFunction* _tmp107_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1;
	_tmp0_ = self->priv->next_array_dup_id;
	_tmp1_ = g_strdup_printf ("_vala_array_copy%d", _tmp0_);
	dup_func = _tmp1_;
	_tmp2_ = dup_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp2_)) {
		result = dup_func;
		return result;
	}
	_tmp3_ = dup_func;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	function = _tmp4_;
	_tmp5_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp5_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6_ = function;
	_tmp7_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s *", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("self", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp6_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = function;
	_tmp14_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("%s *", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_parameter_new ("dest", _tmp17_);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp20_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp21_ = _tmp20_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp21_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp21_);
	_tmp22_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp22_);
	_tmp23_ = vala_array_type_get_element_type (array_type);
	_tmp24_ = _tmp23_;
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp24_)) {
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeVariableDeclarator* _tmp27_;
		ValaCCodeVariableDeclarator* _tmp28_;
		ValaCCodeFunction* _tmp29_;
		ValaCCodeFunction* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeConstant* _tmp33_;
		ValaCCodeConstant* _tmp34_;
		ValaCCodeAssignment* _tmp35_;
		ValaCCodeAssignment* _tmp36_;
		ValaCCodeIdentifier* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaCCodeExpression* _tmp41_;
		ValaCCodeExpression* _tmp42_;
		ValaCCodeBinaryExpression* _tmp43_;
		ValaCCodeBinaryExpression* _tmp44_;
		ValaCCodeIdentifier* _tmp45_;
		ValaCCodeIdentifier* _tmp46_;
		ValaCCodeUnaryExpression* _tmp47_;
		ValaCCodeUnaryExpression* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeIdentifier* _tmp53_;
		ValaCCodeIdentifier* _tmp54_;
		ValaCCodeElementAccess* _tmp55_;
		ValaCCodeElementAccess* _tmp56_;
		ValaDataType* _tmp57_;
		ValaDataType* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeIdentifier* _tmp60_;
		ValaCCodeIdentifier* _tmp61_;
		ValaCCodeIdentifier* _tmp62_;
		ValaCCodeElementAccess* _tmp63_;
		ValaCCodeElementAccess* _tmp64_;
		ValaGLibValue* _tmp65_;
		ValaGLibValue* _tmp66_;
		ValaTargetValue* _tmp67_;
		ValaTargetValue* _tmp68_;
		ValaCCodeExpression* _tmp69_;
		ValaCCodeExpression* _tmp70_;
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_ccode_variable_declarator_new ("i", NULL, NULL);
		_tmp28_ = _tmp27_;
		vala_ccode_function_add_declaration (_tmp26_, "int", (ValaCCodeDeclarator*) _tmp28_, 0);
		_vala_ccode_node_unref0 (_tmp28_);
		_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_ccode_identifier_new ("i");
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_ccode_constant_new ("0");
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp32_, (ValaCCodeExpression*) _tmp34_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_identifier_new ("i");
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_array_type_get_length (array_type);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) _tmp38_, _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_ccode_identifier_new ("i");
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp46_);
		_tmp48_ = _tmp47_;
		vala_ccode_function_open_for (_tmp30_, (ValaCCodeExpression*) _tmp36_, (ValaCCodeExpression*) _tmp44_, (ValaCCodeExpression*) _tmp48_);
		_vala_ccode_node_unref0 (_tmp48_);
		_vala_ccode_node_unref0 (_tmp46_);
		_vala_ccode_node_unref0 (_tmp44_);
		_vala_ccode_node_unref0 (_tmp42_);
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp36_);
		_vala_ccode_node_unref0 (_tmp34_);
		_vala_ccode_node_unref0 (_tmp32_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_ccode_identifier_new ("dest");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_identifier_new ("i");
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp52_, (ValaCCodeExpression*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_array_type_get_element_type (array_type);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_ccode_identifier_new ("self");
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_ccode_identifier_new ("i");
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp60_, (ValaCCodeExpression*) _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_glib_value_new (_tmp58_, (ValaCCodeExpression*) _tmp64_, TRUE);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp66_, (ValaCodeNode*) array_type);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp68_);
		_tmp70_ = _tmp69_;
		vala_ccode_function_add_assignment (_tmp50_, (ValaCCodeExpression*) _tmp56_, _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_vala_target_value_unref0 (_tmp68_);
		_vala_target_value_unref0 (_tmp66_);
		_vala_ccode_node_unref0 (_tmp64_);
		_vala_ccode_node_unref0 (_tmp62_);
		_vala_ccode_node_unref0 (_tmp60_);
		_vala_ccode_node_unref0 (_tmp56_);
		_vala_ccode_node_unref0 (_tmp54_);
		_vala_ccode_node_unref0 (_tmp52_);
	} else {
		ValaCCodeFile* _tmp71_;
		ValaCCodeFunctionCall* dup_call = NULL;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeIdentifier* _tmp77_;
		ValaCCodeIdentifier* _tmp78_;
		ValaCCodeFunctionCall* _tmp79_;
		ValaCCodeIdentifier* _tmp80_;
		ValaCCodeIdentifier* _tmp81_;
		ValaCCodeFunctionCall* sizeof_call = NULL;
		ValaCCodeIdentifier* _tmp82_;
		ValaCCodeIdentifier* _tmp83_;
		ValaCCodeFunctionCall* _tmp84_;
		ValaCCodeFunctionCall* _tmp85_;
		ValaCCodeFunctionCall* _tmp86_;
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		ValaCCodeIdentifier* _tmp91_;
		ValaCCodeIdentifier* _tmp92_;
		ValaCCodeFunctionCall* _tmp93_;
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		ValaCCodeExpression* _tmp96_;
		ValaCCodeExpression* _tmp97_;
		ValaCCodeFunctionCall* _tmp98_;
		ValaCCodeBinaryExpression* _tmp99_;
		ValaCCodeBinaryExpression* _tmp100_;
		ValaCCodeFunction* _tmp101_;
		ValaCCodeFunction* _tmp102_;
		ValaCCodeFunctionCall* _tmp103_;
		_tmp71_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp71_, "string.h", FALSE);
		_tmp72_ = vala_ccode_identifier_new ("memcpy");
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
		_tmp75_ = _tmp74_;
		_vala_ccode_node_unref0 (_tmp73_);
		dup_call = _tmp75_;
		_tmp76_ = dup_call;
		_tmp77_ = vala_ccode_identifier_new ("dest");
		_tmp78_ = _tmp77_;
		vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
		_vala_ccode_node_unref0 (_tmp78_);
		_tmp79_ = dup_call;
		_tmp80_ = vala_ccode_identifier_new ("self");
		_tmp81_ = _tmp80_;
		vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
		_vala_ccode_node_unref0 (_tmp81_);
		_tmp82_ = vala_ccode_identifier_new ("sizeof");
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp83_);
		_tmp85_ = _tmp84_;
		_vala_ccode_node_unref0 (_tmp83_);
		sizeof_call = _tmp85_;
		_tmp86_ = sizeof_call;
		_tmp87_ = vala_array_type_get_element_type (array_type);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_get_ccode_name ((ValaCodeNode*) _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_ccode_identifier_new (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_ccode_function_call_add_argument (_tmp86_, (ValaCCodeExpression*) _tmp92_);
		_vala_ccode_node_unref0 (_tmp92_);
		_g_free0 (_tmp90_);
		_tmp93_ = dup_call;
		_tmp94_ = vala_array_type_get_length (array_type);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = sizeof_call;
		_tmp99_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, _tmp97_, (ValaCCodeExpression*) _tmp98_);
		_tmp100_ = _tmp99_;
		vala_ccode_function_call_add_argument (_tmp93_, (ValaCCodeExpression*) _tmp100_);
		_vala_ccode_node_unref0 (_tmp100_);
		_vala_ccode_node_unref0 (_tmp97_);
		_tmp101_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp102_ = _tmp101_;
		_tmp103_ = dup_call;
		vala_ccode_function_add_expression (_tmp102_, (ValaCCodeExpression*) _tmp103_);
		_vala_ccode_node_unref0 (sizeof_call);
		_vala_ccode_node_unref0 (dup_call);
	}
	_tmp104_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp105_ = function;
	vala_ccode_file_add_function_declaration (_tmp104_, _tmp105_);
	_tmp106_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp107_ = function;
	vala_ccode_file_add_function (_tmp106_, _tmp107_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = dup_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gchar*
vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self,
                                                    ValaArrayType* array_type)
{
	gchar* result = NULL;
	gchar* add_func = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	gchar* typename = NULL;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	gchar* _tmp22_;
	ValaCCodeExpression* value = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaCCodeFunction* _tmp45_;
	const gchar* _tmp46_;
	ValaCCodeParameter* _tmp47_;
	ValaCCodeParameter* _tmp48_;
	ValaCCodeUnaryExpression* array = NULL;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeUnaryExpression* _tmp51_;
	ValaCCodeUnaryExpression* _tmp52_;
	ValaCCodeUnaryExpression* length = NULL;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeUnaryExpression* size = NULL;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeUnaryExpression* _tmp59_;
	ValaCCodeUnaryExpression* _tmp60_;
	ValaCCodeFunctionCall* renew_call = NULL;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeFunctionCall* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	ValaCCodeIdentifier* _tmp70_;
	ValaCCodeIdentifier* _tmp71_;
	ValaCCodeFunctionCall* _tmp72_;
	ValaCCodeUnaryExpression* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaCCodeBinaryExpression* csizecheck = NULL;
	ValaCCodeUnaryExpression* _tmp84_;
	ValaCCodeUnaryExpression* _tmp85_;
	ValaCCodeBinaryExpression* _tmp86_;
	ValaCCodeFunction* _tmp87_;
	ValaCCodeFunction* _tmp88_;
	ValaCCodeBinaryExpression* _tmp89_;
	ValaCCodeFunction* _tmp90_;
	ValaCCodeFunction* _tmp91_;
	ValaCCodeUnaryExpression* _tmp92_;
	ValaCCodeUnaryExpression* _tmp93_;
	ValaCCodeConstant* _tmp94_;
	ValaCCodeConstant* _tmp95_;
	ValaCCodeUnaryExpression* _tmp96_;
	ValaCCodeBinaryExpression* _tmp97_;
	ValaCCodeBinaryExpression* _tmp98_;
	ValaCCodeConstant* _tmp99_;
	ValaCCodeConstant* _tmp100_;
	ValaCCodeConditionalExpression* _tmp101_;
	ValaCCodeConditionalExpression* _tmp102_;
	ValaCCodeFunction* _tmp103_;
	ValaCCodeFunction* _tmp104_;
	ValaCCodeUnaryExpression* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	ValaCCodeFunction* _tmp107_;
	ValaCCodeFunction* _tmp108_;
	ValaCCodeFunction* _tmp109_;
	ValaCCodeFunction* _tmp110_;
	ValaCCodeUnaryExpression* _tmp111_;
	ValaCCodeUnaryExpression* _tmp112_;
	ValaCCodeUnaryExpression* _tmp113_;
	ValaCCodeUnaryExpression* _tmp114_;
	ValaCCodeElementAccess* _tmp115_;
	ValaCCodeElementAccess* _tmp116_;
	ValaCCodeExpression* _tmp117_;
	ValaDataType* _tmp118_;
	ValaDataType* _tmp119_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	self->priv->next_array_add_id = self->priv->next_array_add_id + 1;
	_tmp0_ = self->priv->next_array_add_id;
	_tmp1_ = g_strdup_printf ("_vala_array_add%d", _tmp0_);
	add_func = _tmp1_;
	_tmp2_ = add_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp2_)) {
		result = add_func;
		return result;
	}
	_tmp3_ = add_func;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	function = _tmp4_;
	_tmp5_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp5_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6_ = function;
	_tmp7_ = vala_get_ccode_name ((ValaCodeNode*) array_type);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s *", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("array", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp6_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = function;
	_tmp14_ = vala_ccode_parameter_new ("length", "int*");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = function;
	_tmp17_ = vala_ccode_parameter_new ("size", "int*");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_array_type_get_element_type (array_type);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_get_ccode_name ((ValaCodeNode*) _tmp21_);
	typename = _tmp22_;
	_tmp23_ = vala_ccode_identifier_new ("value");
	value = (ValaCCodeExpression*) _tmp23_;
	_tmp24_ = vala_array_type_get_element_type (array_type);
	_tmp25_ = _tmp24_;
	if (vala_data_type_is_real_struct_type (_tmp25_)) {
		gboolean _tmp26_ = FALSE;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp27_ = vala_array_type_get_element_type (array_type);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_data_type_get_nullable (_tmp28_);
		_tmp30_ = _tmp29_;
		if (!_tmp30_) {
			_tmp26_ = TRUE;
		} else {
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			_tmp31_ = vala_array_type_get_element_type (array_type);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_data_type_get_value_owned (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp26_ = !_tmp34_;
		}
		if (_tmp26_) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = typename;
			_tmp36_ = g_strconcat ("const ", _tmp35_, NULL);
			_g_free0 (typename);
			typename = _tmp36_;
		}
		_tmp37_ = vala_array_type_get_element_type (array_type);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_get_nullable (_tmp38_);
		_tmp40_ = _tmp39_;
		if (!_tmp40_) {
			const gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeExpression* _tmp43_;
			ValaCCodeUnaryExpression* _tmp44_;
			_tmp41_ = typename;
			_tmp42_ = g_strconcat (_tmp41_, "*", NULL);
			_g_free0 (typename);
			typename = _tmp42_;
			_tmp43_ = value;
			_tmp44_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, _tmp43_);
			_vala_ccode_node_unref0 (value);
			value = (ValaCCodeExpression*) _tmp44_;
		}
	}
	_tmp45_ = function;
	_tmp46_ = typename;
	_tmp47_ = vala_ccode_parameter_new ("value", _tmp46_);
	_tmp48_ = _tmp47_;
	vala_ccode_function_add_parameter (_tmp45_, _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vala_ccode_identifier_new ("array");
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	array = _tmp52_;
	_tmp53_ = vala_ccode_identifier_new ("length");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	_vala_ccode_node_unref0 (_tmp54_);
	length = _tmp56_;
	_tmp57_ = vala_ccode_identifier_new ("size");
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp58_);
	_tmp60_ = _tmp59_;
	_vala_ccode_node_unref0 (_tmp58_);
	size = _tmp60_;
	_tmp61_ = vala_ccode_identifier_new ("g_renew");
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp62_);
	_tmp64_ = _tmp63_;
	_vala_ccode_node_unref0 (_tmp62_);
	renew_call = _tmp64_;
	_tmp65_ = renew_call;
	_tmp66_ = vala_array_type_get_element_type (array_type);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_get_ccode_name ((ValaCodeNode*) _tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_ccode_identifier_new (_tmp69_);
	_tmp71_ = _tmp70_;
	vala_ccode_function_call_add_argument (_tmp65_, (ValaCCodeExpression*) _tmp71_);
	_vala_ccode_node_unref0 (_tmp71_);
	_g_free0 (_tmp69_);
	_tmp72_ = renew_call;
	_tmp73_ = array;
	vala_ccode_function_call_add_argument (_tmp72_, (ValaCCodeExpression*) _tmp73_);
	_tmp74_ = vala_array_type_get_element_type (array_type);
	_tmp75_ = _tmp74_;
	if (vala_data_type_is_reference_type_or_type_parameter (_tmp75_)) {
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeUnaryExpression* _tmp77_;
		ValaCCodeConstant* _tmp78_;
		ValaCCodeConstant* _tmp79_;
		ValaCCodeBinaryExpression* _tmp80_;
		ValaCCodeBinaryExpression* _tmp81_;
		_tmp76_ = renew_call;
		_tmp77_ = size;
		_tmp78_ = vala_ccode_constant_new ("1");
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp77_, (ValaCCodeExpression*) _tmp79_);
		_tmp81_ = _tmp80_;
		vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp81_);
		_vala_ccode_node_unref0 (_tmp81_);
		_vala_ccode_node_unref0 (_tmp79_);
	} else {
		ValaCCodeFunctionCall* _tmp82_;
		ValaCCodeUnaryExpression* _tmp83_;
		_tmp82_ = renew_call;
		_tmp83_ = size;
		vala_ccode_function_call_add_argument (_tmp82_, (ValaCCodeExpression*) _tmp83_);
	}
	_tmp84_ = length;
	_tmp85_ = size;
	_tmp86_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp84_, (ValaCCodeExpression*) _tmp85_);
	csizecheck = _tmp86_;
	_tmp87_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp88_ = _tmp87_;
	_tmp89_ = csizecheck;
	vala_ccode_function_open_if (_tmp88_, (ValaCCodeExpression*) _tmp89_);
	_tmp90_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp91_ = _tmp90_;
	_tmp92_ = size;
	_tmp93_ = size;
	_tmp94_ = vala_ccode_constant_new ("2");
	_tmp95_ = _tmp94_;
	_tmp96_ = size;
	_tmp97_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp95_, (ValaCCodeExpression*) _tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_ccode_constant_new ("4");
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp93_, (ValaCCodeExpression*) _tmp98_, (ValaCCodeExpression*) _tmp100_);
	_tmp102_ = _tmp101_;
	vala_ccode_function_add_assignment (_tmp91_, (ValaCCodeExpression*) _tmp92_, (ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (_tmp102_);
	_vala_ccode_node_unref0 (_tmp100_);
	_vala_ccode_node_unref0 (_tmp98_);
	_vala_ccode_node_unref0 (_tmp95_);
	_tmp103_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp104_ = _tmp103_;
	_tmp105_ = array;
	_tmp106_ = renew_call;
	vala_ccode_function_add_assignment (_tmp104_, (ValaCCodeExpression*) _tmp105_, (ValaCCodeExpression*) _tmp106_);
	_tmp107_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp108_ = _tmp107_;
	vala_ccode_function_close (_tmp108_);
	_tmp109_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp110_ = _tmp109_;
	_tmp111_ = array;
	_tmp112_ = length;
	_tmp113_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) _tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp111_, (ValaCCodeExpression*) _tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = value;
	vala_ccode_function_add_assignment (_tmp110_, (ValaCCodeExpression*) _tmp116_, _tmp117_);
	_vala_ccode_node_unref0 (_tmp116_);
	_vala_ccode_node_unref0 (_tmp114_);
	_tmp118_ = vala_array_type_get_element_type (array_type);
	_tmp119_ = _tmp118_;
	if (vala_data_type_is_reference_type_or_type_parameter (_tmp119_)) {
		ValaCCodeFunction* _tmp120_;
		ValaCCodeFunction* _tmp121_;
		ValaCCodeUnaryExpression* _tmp122_;
		ValaCCodeUnaryExpression* _tmp123_;
		ValaCCodeElementAccess* _tmp124_;
		ValaCCodeElementAccess* _tmp125_;
		ValaCCodeConstant* _tmp126_;
		ValaCCodeConstant* _tmp127_;
		_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = array;
		_tmp123_ = length;
		_tmp124_ = vala_ccode_element_access_new ((ValaCCodeExpression*) _tmp122_, (ValaCCodeExpression*) _tmp123_);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_ccode_constant_new ("NULL");
		_tmp127_ = _tmp126_;
		vala_ccode_function_add_assignment (_tmp121_, (ValaCCodeExpression*) _tmp125_, (ValaCCodeExpression*) _tmp127_);
		_vala_ccode_node_unref0 (_tmp127_);
		_vala_ccode_node_unref0 (_tmp125_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	result = add_func;
	_vala_ccode_node_unref0 (csizecheck);
	_vala_ccode_node_unref0 (renew_call);
	_vala_ccode_node_unref0 (size);
	_vala_ccode_node_unref0 (length);
	_vala_ccode_node_unref0 (array);
	_vala_ccode_node_unref0 (value);
	_g_free0 (typename);
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self,
                                      ValaAssignment* assignment)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (assignment != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (assignment);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static void
vala_ccode_array_module_real_visit_assignment (ValaCodeVisitor* base,
                                               ValaAssignment* assignment)
{
	ValaCCodeArrayModule * self;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	ValaExpression* array = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaArrayType* array_type = NULL;
	ValaExpression* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaArrayType* _tmp9_;
	ValaExpression* element = NULL;
	ValaBinaryExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaSymbol* array_var = NULL;
	ValaExpression* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaArrayType* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	ValaParameter* value_param = NULL;
	ValaExpression* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaParameter* _tmp34_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaArrayType* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeFunctionCall* _tmp42_;
	ValaExpression* _tmp43_;
	ValaCCodeExpression* _tmp44_;
	ValaCCodeExpression* _tmp45_;
	ValaCCodeUnaryExpression* _tmp46_;
	ValaCCodeUnaryExpression* _tmp47_;
	ValaCCodeFunctionCall* _tmp48_;
	ValaExpression* _tmp49_;
	ValaCCodeExpression* _tmp50_;
	ValaCCodeExpression* _tmp51_;
	ValaCCodeUnaryExpression* _tmp52_;
	ValaCCodeUnaryExpression* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaExpression* _tmp55_;
	ValaTargetValue* _tmp56_;
	ValaTargetValue* _tmp57_;
	ValaCCodeExpression* _tmp58_;
	ValaCCodeExpression* _tmp59_;
	ValaCCodeUnaryExpression* _tmp60_;
	ValaCCodeUnaryExpression* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaParameter* _tmp63_;
	ValaExpression* _tmp64_;
	ValaExpression* _tmp65_;
	ValaCCodeExpression* _tmp66_;
	ValaCCodeExpression* _tmp67_;
	ValaCCodeExpression* _tmp68_;
	ValaCCodeExpression* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunction* _tmp71_;
	ValaCCodeFunctionCall* _tmp72_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (assignment != NULL);
	if (!vala_ccode_array_module_is_array_add (self, assignment)) {
		VALA_CODE_VISITOR_CLASS (vala_ccode_array_module_parent_class)->visit_assignment ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), assignment);
		return;
	}
	_tmp0_ = vala_assignment_get_right (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
	binary = _tmp2_;
	_tmp3_ = vala_assignment_get_left (assignment);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (_tmp4_);
	array = _tmp5_;
	_tmp6_ = array;
	_tmp7_ = vala_expression_get_value_type (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp9_;
	_tmp10_ = binary;
	_tmp11_ = vala_binary_expression_get_right (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	element = _tmp13_;
	_tmp14_ = array;
	_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (_tmp16_);
	array_var = _tmp17_;
	_tmp21_ = array_type;
	_tmp22_ = vala_array_type_get_rank (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 1) {
		ValaSymbol* _tmp24_;
		_tmp24_ = array_var;
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaSymbol* _tmp25_;
		_tmp25_ = array_var;
		_tmp19_ = vala_symbol_is_internal_symbol (_tmp25_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp26_ = FALSE;
		ValaSymbol* _tmp27_;
		_tmp27_ = array_var;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp26_ = TRUE;
		} else {
			ValaSymbol* _tmp28_;
			_tmp28_ = array_var;
			_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_FIELD);
		}
		_tmp18_ = _tmp26_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
	} else {
		ValaSourceReference* _tmp29_;
		ValaSourceReference* _tmp30_;
		_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) assignment);
		_tmp30_ = _tmp29_;
		vala_report_error (_tmp30_, "Array concatenation not supported for public array variables and param" \
"eters");
		_vala_code_node_unref0 (array_var);
		_vala_code_node_unref0 (element);
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (array);
		_vala_code_node_unref0 (binary);
		return;
	}
	_tmp31_ = element;
	_tmp32_ = vala_expression_get_target_type (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_parameter_new ("value", _tmp33_, NULL);
	value_param = _tmp34_;
	_tmp35_ = array_type;
	_tmp36_ = vala_ccode_array_module_generate_array_add_wrapper (self, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_identifier_new (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp39_);
	_tmp41_ = _tmp40_;
	_vala_ccode_node_unref0 (_tmp39_);
	_g_free0 (_tmp37_);
	ccall = _tmp41_;
	_tmp42_ = ccall;
	_tmp43_ = array;
	_tmp44_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp45_);
	_tmp47_ = _tmp46_;
	vala_ccode_function_call_add_argument (_tmp42_, (ValaCCodeExpression*) _tmp47_);
	_vala_ccode_node_unref0 (_tmp47_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp48_ = ccall;
	_tmp49_ = array;
	_tmp50_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp49_, -1);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp51_);
	_tmp53_ = _tmp52_;
	vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp54_ = ccall;
	_tmp55_ = array;
	_tmp56_ = vala_expression_get_target_value (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_call_add_argument (_tmp54_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp62_ = ccall;
	_tmp63_ = value_param;
	_tmp64_ = element;
	_tmp65_ = element;
	_tmp66_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp63_, _tmp64_, _tmp67_);
	_tmp69_ = _tmp68_;
	vala_ccode_function_call_add_argument (_tmp62_, _tmp69_);
	_vala_ccode_node_unref0 (_tmp69_);
	_vala_ccode_node_unref0 (_tmp67_);
	_tmp70_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = ccall;
	vala_ccode_function_add_expression (_tmp71_, (ValaCCodeExpression*) _tmp72_);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (value_param);
	_vala_code_node_unref0 (array_var);
	_vala_code_node_unref0 (element);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (array);
	_vala_code_node_unref0 (binary);
}


static ValaCCodeParameter*
vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base,
                                                 ValaParameter* param,
                                                 ValaCCodeFile* decl_space,
                                                 ValaMap* cparam_map,
                                                 ValaMap* carg_map)
{
	ValaCCodeArrayModule * self;
	ValaCCodeParameter* result = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gchar* ctypename = NULL;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	gchar* _tmp5_;
	gchar* name = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaArrayType* _tmp11_;
	ValaArrayType* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	ValaParameterDirection _tmp17_;
	ValaParameterDirection _tmp18_;
	ValaCCodeParameter* main_cparam = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	ValaCCodeParameter* _tmp23_;
	ValaArrayType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	gboolean _tmp32_ = FALSE;
	ValaArrayType* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (param != NULL, NULL);
	g_return_val_if_fail (decl_space != NULL, NULL);
	g_return_val_if_fail (cparam_map != NULL, NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) param);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		ValaCCodeParameter* _tmp2_;
		_tmp2_ = VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_array_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule), param, decl_space, cparam_map, carg_map);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) param);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) _tmp4_);
	ctypename = _tmp5_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, _tmp7_);
	name = _tmp8_;
	_tmp9_ = vala_variable_get_variable_type ((ValaVariable*) param);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp11_;
	_tmp12_ = array_type;
	_tmp13_ = vala_array_type_get_fixed_length (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = ctypename;
		_tmp16_ = g_strconcat (_tmp15_, "*", NULL);
		_g_free0 (ctypename);
		ctypename = _tmp16_;
	}
	_tmp17_ = vala_parameter_get_direction (param);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != VALA_PARAMETER_DIRECTION_IN) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = ctypename;
		_tmp20_ = g_strconcat (_tmp19_, "*", NULL);
		_g_free0 (ctypename);
		ctypename = _tmp20_;
	}
	_tmp21_ = name;
	_tmp22_ = ctypename;
	_tmp23_ = vala_ccode_parameter_new (_tmp21_, _tmp22_);
	main_cparam = _tmp23_;
	_tmp24_ = array_type;
	_tmp25_ = vala_array_type_get_element_type (_tmp24_);
	_tmp26_ = _tmp25_;
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, _tmp26_, decl_space);
	_tmp27_ = main_cparam;
	vala_map_set (cparam_map, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (param), FALSE)), _tmp27_);
	if (carg_map != NULL) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaCCodeExpression* _tmp30_;
		ValaCCodeExpression* _tmp31_;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) param);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp29_);
		_tmp31_ = _tmp30_;
		vala_map_set (carg_map, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (param), FALSE)), _tmp31_);
		_vala_ccode_node_unref0 (_tmp31_);
	}
	_tmp33_ = array_type;
	_tmp34_ = vala_array_type_get_fixed_length (_tmp33_);
	_tmp35_ = _tmp34_;
	if (!_tmp35_) {
		_tmp32_ = vala_get_ccode_array_length ((ValaCodeNode*) param);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gchar* length_ctype = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gboolean _tmp39_;
		ValaParameterDirection _tmp41_;
		ValaParameterDirection _tmp42_;
		_tmp36_ = g_strdup ("int");
		length_ctype = _tmp36_;
		_tmp37_ = vala_get_ccode_array_length_type ((ValaCodeNode*) param);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_ != NULL;
		_g_free0 (_tmp38_);
		if (_tmp39_) {
			gchar* _tmp40_;
			_tmp40_ = vala_get_ccode_array_length_type ((ValaCodeNode*) param);
			_g_free0 (length_ctype);
			length_ctype = _tmp40_;
		}
		_tmp41_ = vala_parameter_get_direction (param);
		_tmp42_ = _tmp41_;
		if (_tmp42_ != VALA_PARAMETER_DIRECTION_IN) {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp43_ = length_ctype;
			_tmp44_ = g_strdup_printf ("%s*", _tmp43_);
			_g_free0 (length_ctype);
			length_ctype = _tmp44_;
		}
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gint _tmp47_;
					ValaArrayType* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					ValaCCodeParameter* cparam = NULL;
					gint _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					const gchar* _tmp54_;
					ValaCCodeParameter* _tmp55_;
					ValaCCodeParameter* _tmp56_;
					gint _tmp57_;
					ValaCCodeParameter* _tmp58_;
					if (!_tmp45_) {
						gint _tmp46_;
						_tmp46_ = dim;
						dim = _tmp46_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp47_ = dim;
					_tmp48_ = array_type;
					_tmp49_ = vala_array_type_get_rank (_tmp48_);
					_tmp50_ = _tmp49_;
					if (!(_tmp47_ <= _tmp50_)) {
						break;
					}
					_tmp51_ = dim;
					_tmp52_ = vala_ccode_base_module_get_parameter_array_length_cname ((ValaCCodeBaseModule*) self, param, _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = length_ctype;
					_tmp55_ = vala_ccode_parameter_new (_tmp53_, _tmp54_);
					_tmp56_ = _tmp55_;
					_g_free0 (_tmp53_);
					cparam = _tmp56_;
					_tmp57_ = dim;
					_tmp58_ = cparam;
					vala_map_set (cparam_map, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) param) + (0.01 * _tmp57_), FALSE)), _tmp58_);
					if (carg_map != NULL) {
						gint _tmp59_;
						ValaCCodeParameter* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
						ValaCCodeExpression* _tmp63_;
						ValaCCodeExpression* _tmp64_;
						_tmp59_ = dim;
						_tmp60_ = cparam;
						_tmp61_ = vala_ccode_parameter_get_name (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp62_);
						_tmp64_ = _tmp63_;
						vala_map_set (carg_map, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) param) + (0.01 * _tmp59_), FALSE)), _tmp64_);
						_vala_ccode_node_unref0 (_tmp64_);
					}
					_vala_ccode_node_unref0 (cparam);
				}
			}
		}
		_g_free0 (length_ctype);
	}
	result = main_cparam;
	_vala_code_node_unref0 (array_type);
	_g_free0 (name);
	_g_free0 (ctypename);
	return result;
}


ValaCCodeArrayModule*
vala_ccode_array_module_construct (GType object_type)
{
	ValaCCodeArrayModule* self = NULL;
	self = (ValaCCodeArrayModule*) vala_ccode_method_call_module_construct (object_type);
	return self;
}


ValaCCodeArrayModule*
vala_ccode_array_module_new (void)
{
	return vala_ccode_array_module_construct (VALA_TYPE_CCODE_ARRAY_MODULE);
}


static void
vala_ccode_array_module_class_init (ValaCCodeArrayModuleClass * klass)
{
	vala_ccode_array_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_ccode_array_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeArrayModulePrivate));
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor*, ValaArrayCreationExpression*)) vala_ccode_array_module_real_visit_array_creation_expression;
	((ValaCCodeBaseModuleClass *) klass)->get_array_length_cname = (gchar* (*) (ValaCCodeBaseModule*, const gchar*, gint)) vala_ccode_array_module_real_get_array_length_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_parameter_array_length_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaParameter*, gint)) vala_ccode_array_module_real_get_parameter_array_length_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_array_length_cexpression = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaExpression*, gint)) vala_ccode_array_module_real_get_array_length_cexpression;
	((ValaCCodeBaseModuleClass *) klass)->get_array_length_cvalue = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaTargetValue*, gint)) vala_ccode_array_module_real_get_array_length_cvalue;
	((ValaCCodeBaseModuleClass *) klass)->get_array_size_cname = (gchar* (*) (ValaCCodeBaseModule*, const gchar*)) vala_ccode_array_module_real_get_array_size_cname;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_ccode_array_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor*, ValaSliceExpression*)) vala_ccode_array_module_real_visit_slice_expression;
	((ValaCCodeBaseModuleClass *) klass)->append_struct_array_free = (gchar* (*) (ValaCCodeBaseModule*, ValaStruct*)) vala_ccode_array_module_real_append_struct_array_free;
	((ValaCCodeBaseModuleClass *) klass)->append_struct_array_destroy = (gchar* (*) (ValaCCodeBaseModule*, ValaStruct*)) vala_ccode_array_module_real_append_struct_array_destroy;
	((ValaCCodeBaseModuleClass *) klass)->append_vala_array_free = (void (*) (ValaCCodeBaseModule*)) vala_ccode_array_module_real_append_vala_array_free;
	((ValaCCodeBaseModuleClass *) klass)->append_vala_array_move = (void (*) (ValaCCodeBaseModule*)) vala_ccode_array_module_real_append_vala_array_move;
	((ValaCCodeBaseModuleClass *) klass)->append_vala_array_length = (void (*) (ValaCCodeBaseModule*)) vala_ccode_array_module_real_append_vala_array_length;
	((ValaCCodeBaseModuleClass *) klass)->copy_value = (ValaTargetValue* (*) (ValaCCodeBaseModule*, ValaTargetValue*, ValaCodeNode*)) vala_ccode_array_module_real_copy_value;
	((ValaCCodeBaseModuleClass *) klass)->get_dup_func_expression = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaDataType*, ValaSourceReference*, gboolean)) vala_ccode_array_module_real_get_dup_func_expression;
	((ValaCCodeBaseModuleClass *) klass)->destroy_value = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaTargetValue*, gboolean)) vala_ccode_array_module_real_destroy_value;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor*, ValaAssignment*)) vala_ccode_array_module_real_visit_assignment;
	((ValaCCodeMethodModuleClass *) klass)->generate_parameter = (ValaCCodeParameter* (*) (ValaCCodeMethodModule*, ValaParameter*, ValaCCodeFile*, ValaMap*, ValaMap*)) vala_ccode_array_module_real_generate_parameter;
}


static void
vala_ccode_array_module_instance_init (ValaCCodeArrayModule * self)
{
	self->priv = VALA_CCODE_ARRAY_MODULE_GET_PRIVATE (self);
	self->priv->next_array_dup_id = 0;
	self->priv->next_array_add_id = 0;
}


static void
vala_ccode_array_module_finalize (ValaCodeVisitor * obj)
{
	ValaCCodeArrayModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule);
	VALA_CODE_VISITOR_CLASS (vala_ccode_array_module_parent_class)->finalize (obj);
}


GType
vala_ccode_array_module_get_type (void)
{
	static volatile gsize vala_ccode_array_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_array_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayModule), 0, (GInstanceInitFunc) vala_ccode_array_module_instance_init, NULL };
		GType vala_ccode_array_module_type_id;
		vala_ccode_array_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_CALL_MODULE, "ValaCCodeArrayModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_array_module_type_id__volatile, vala_ccode_array_module_type_id);
	}
	return vala_ccode_array_module_type_id__volatile;
}



