# 
# Copyright (c) 2017-2018, SyLabs, Inc. All rights reserved.
# Copyright (c) 2017, SingularityWare, LLC. All rights reserved.
#
# Copyright (c) 2015-2017, Gregory M. Kurtzer. All rights reserved.
# 
# Copyright (c) 2016, The Regents of the University of California, through
# Lawrence Berkeley National Laboratory (subject to receipt of any required
# approvals from the U.S. Dept. of Energy).  All rights reserved.
# 
# This software is licensed under a customized 3-clause BSD license.  Please
# consult LICENSE file distributed with the sources of this project regarding
# your rights to use or distribute this software.
# 
# NOTICE.  This Software was developed under funding from the U.S. Department of
# Energy and the U.S. Government consequently retains certain rights. As such,
# the U.S. Government has been granted for itself and others acting on its
# behalf a paid-up, nonexclusive, irrevocable, worldwide license in the Software
# to reproduce, distribute copies to the public, prepare derivative works, and
# perform publicly and display publicly, and to permit other to do so. 
# 
# 

# Disable debugsource packages; otherwise it ends up with an empty %files
#   file in debugsourcefiles.list on Fedora
%undefine _debugsource_packages

# This can be slightly different than %{version}.
# For example, it has dash instead of tilde for release candidates.
%define package_version 3.8.7

Summary: Application and environment virtualization
Name: singularity
Version: 3.8.7
Release: 1%{?dist}
# https://spdx.org/licenses/BSD-3-Clause-LBNL.html
License: BSD-3-Clause-LBNL
URL: https://singularity.hpcng.org
Source: %{name}-%{package_version}.tar.gz

ExclusiveOS: linux
# RPM_BUILD_ROOT wasn't being set ... for some reason
%if "%{sles_version}" == "11"
BuildRoot: /var/tmp/singularity-%{version}-build
%endif

%if "%{_target_vendor}" == "suse"
%if "%{sles_version}" != "11"
BuildRequires: go
%endif
%else
BuildRequires: golang
%endif
BuildRequires: git
BuildRequires: gcc
BuildRequires: make
%if ! 0%{?el6}
%if "%{sles_version}" != "11"
BuildRequires: libseccomp-devel
%endif
%endif
%if "%{_target_vendor}" == "suse"
Requires: squashfs
%else
Requires: squashfs-tools
%endif
BuildRequires: cryptsetup

# there's no golang for ppc64, just ppc64le
ExcludeArch: ppc64

Provides: %{name}-runtime = %{version}-%{release}
Obsoletes: %{name}-runtime < 3.0

%description
Singularity provides functionality to make portable
containers that can be used across host environments.

%debug_package

%prep
%if "%{?buildroot}"
export RPM_BUILD_ROOT="%{buildroot}"
%endif

if [ -d %{name}-%{version} ]; then
    # Clean up old build root
    # First clean go's modcache because directories are unwritable
    GOPATH=$PWD/%{name}-%{version}/gopath go clean -modcache
    rm -rf %{name}-%{version}
fi

# Create our build root
mkdir %{name}-%{version}

%build
cd %{name}-%{version}

# Setup an empty GOPATH for the build
mkdir -p gopath

export GOPATH=$PWD/gopath
export PATH=$GOPATH/bin:$PATH

# Perform the build outside of GOPATH as we are using go modules
tar -xf "%SOURCE0"
cd %{name}-%{package_version}

%if "%{?SOURCE1}" != ""
GOVERSION="$(echo %SOURCE1|sed 's,.*/,,;s/go//;s/\.src.*//')"
if ! ./mlocal/scripts/check-min-go-version go $GOVERSION; then
	# build the go tool chain, the existing version is too old
	pushd ..
	tar -xf %SOURCE1
	cd go/src
	./make.bash
	cd ../..
	export PATH=$PWD/go/bin:$PATH
	popd
fi
%endif


# Not all of these parameters currently have an effect, but they might be
#  used someday.  They are the same parameters as in the configure macro.
./mconfig -V %{version}-%{release} \
        --prefix=%{_prefix} \
        --exec-prefix=%{_exec_prefix} \
        --bindir=%{_bindir} \
        --sbindir=%{_sbindir} \
        --sysconfdir=%{_sysconfdir} \
        --datadir=%{_datadir} \
        --includedir=%{_includedir} \
        --libdir=%{_libdir} \
        --libexecdir=%{_libexecdir} \
        --localstatedir=%{_localstatedir} \
        --sharedstatedir=%{_sharedstatedir} \
        --mandir=%{_mandir} \
        --infodir=%{_infodir}

cd builddir
make old_config=

%install
cd %{name}-%{version}

%if "%{?SOURCE1}" != ""
export PATH=$PWD/go/bin:$PATH
%endif
export GOPATH=$PWD/gopath
export PATH=$GOPATH/bin:$PATH

# Enter the source builddir for the install
cd %{name}-%{package_version}/builddir

make DESTDIR=$RPM_BUILD_ROOT install

%if "%{suse_version}" == "11"
%clean
/bin/rm -rf %{buildroot}
%endif

%files
%attr(4755, root, root) %{_libexecdir}/singularity/bin/starter-suid
%{_bindir}/singularity
%{_bindir}/run-singularity
%dir %{_libexecdir}/singularity
%{_libexecdir}/singularity/bin/starter
%{_libexecdir}/singularity/cni/*
%dir %{_sysconfdir}/singularity
%config(noreplace) %{_sysconfdir}/singularity/*.conf
%config(noreplace) %{_sysconfdir}/singularity/*.toml
%config(noreplace) %{_sysconfdir}/singularity/*.json
%config(noreplace) %{_sysconfdir}/singularity/*.yaml
%config(noreplace) %{_sysconfdir}/singularity/global-pgp-public
%config(noreplace) %{_sysconfdir}/singularity/cgroups/*
%config(noreplace) %{_sysconfdir}/singularity/network/*
%config(noreplace) %{_sysconfdir}/singularity/seccomp-profiles/*
%dir %{_sysconfdir}/bash_completion.d
%{_sysconfdir}/bash_completion.d/*
%dir %{_localstatedir}/singularity
%dir %{_localstatedir}/singularity/mnt
%dir %{_localstatedir}/singularity/mnt/session
%{_mandir}/man1/singularity*


%changelog

