# Singularity Support

Need help? We have several ways to reach us, depending on your preferences and needs.

## Documentation
If you haven't already, read our [documentation](https://apptainer.org/docs/). These docs have common use cases, and might be helpful to browse before submitting an issue. You can contribute to our documentation by creating PRs against the [singularity-admindocs](https://github.com/apptainer/singularity-admindocs) and [singularity-userdocs](https://github.com/apptainer/singularity-userdocs) repositories.

## Github
For issues with code (and especially if you need to share debug output) we recommend Github issues boards.

 - [Singularity Issues](https://github.com/apptainer/singularity/issues): is recommended for most issues with the Singularity software.
 - [User Documentation](https://github.com/apptainer/singularity-userdocs/issues) questions, feedback, and suggestions should go here. Feel free to create an issue on a board and additionally request updated content here.
 - [Admin Documentation](https://github.com/apptainer/singularity-admindocs/issues) questions, feedback, and suggestions should go here. Feel free to create an issue on a board and additionally request updated content here.


### How do I ask for help?
After you identify a bug, you should search the respective issue board for similar problems reported by other users. Another user may be facing the same issue, and you can add a +1 (in message or icon) to indicate to the maintainers that the issue is pressing for you as well. The squeaky wheel gets the grease!

### How is time allocated to addressing issues?
While we wish we could address every issue, there are only so many hours in the day. We rank issues based on the following questions:

 1. How many users are affected?
 2. Is there a proposed work-around?
 2. In how many instances does the proposed work-around fail?

With these simple questions, we can ensure that work is directed and has the maximum impact! However, if your issue doesn't seem to be getting attention you can still move it along using some of the strategies discussed below.

### What if my issue goes stale?
Issues can go stale for a number of reasons. In the bullets below, we will review some of these reasons, along with strategies for managing them:

 1. *The issue needs a gentle reminder*. Try targeting a few people with a "`ping @username any thoughts about this?`" in the case that it was forgotten.
 2. *Was your issue properly explained*? You are much more likely to get help when you give clear instructions for reproducing the issue, and show effort on your part to think about what the problem might be. If possible, try to come up with a way to reproduce the issue that does not involve a special environment or exotic hardware. 
 3. *Is there broad need*? It could be that your issue isn't having a big enough impact for other users to warrant the time for the small development team. In this case, you might try implementing a suggested fix, and then asking for help with the details.
 4. *Is your issue scattered?* When many issues pile up on boards, it sometimes is the case that issues are duplicated. It's important to find these duplicates and merge them into one, because in finding the duplicate you find another user to talk to about the issue.
 5. *Does your issue need to have scope?* The idea of scoping an issue means framing it with respect to other components of the software. For example, if you have a feature request to see metadata about an object, you might frame that in the context of container introspection, and suggest an addition to the software that fits with the "inspect" command. A very powerful thing to do would be to open up an issue that (not only discusses your specific addition) but also opens up discussion to the general community for "How we can do introspection" better. Then create a set of issues and add them to a [Github milestone](https://help.github.com/articles/about-milestones/).  This kind of contribution is much more powerful than simply asking for something.
 
## Google Group
You can reach the community quickly by way of joining our [Google Group](https://groups.google.com/a/lbl.gov/forum/#!forum/singularity).

## Slack
For real time support from the community, you can join our community on slack at [https://apptainer.slack.com/](https://apptainer.slack.com/). Ping the Google Group or one of the admins here to request to be added.

Is there something missing here you'd like to see? Please [let us know](https://github.com/apptainer/singularity/issues).
