#!/usr/bin/perl

# print "Argument Count: ", $#ARGV, "\n";
die "Insufficient arguments!\n" if ($#ARGV < 1);
$source = $ARGV[0];
$dest = $ARGV[1];

print "Generating '$dest' from '$source'\n";
open(SOURCE_FILE, "$source") || die "Can't find $source $OPCODES_H: $!\n";
open(DEST_FILE, ">$dest") || die "Can't create $dest: $DEST_FILE: $!\n";

print DEST_FILE "/*
 * $dest
 *
 *  ShowEQ Distributed under GPL
 *  http://seq.sf.net/
 *
 *  Copyright 2001-2003 Zaphod (dohpaz\@users.sourceforge.net). 
 *
 * This file is automatically generated by packeth2structs.pl from the 
 * forward declaration of structures is $source
 * 
 * **** Do Not Hand Edit *********
 *
 */\n";

while ($line = <SOURCE_FILE>) {
    if ($line =~ m/^struct\s+(\S*)\s+/)
    {
	print DEST_FILE "AddStruct($1);\n";
    }
}

close(SOURCE_FILE);
close(DEST_FILE)
