const {
    inject_ruffle_and_wait,
    open_test,
    play_and_monitor,
} = require("../../utils");
const { expect, use } = require("chai");
const chaiHtml = require("chai-html");
const fs = require("fs");

use(chaiHtml);

describe("Object tag", () => {
    it("loads the test", async () => {
        await open_test(browser, __dirname);
    });

    it("polyfills with ruffle", async () => {
        await inject_ruffle_and_wait(browser);
        const actual = await browser.$("#test-container").getHTML(false);
        const expected = fs.readFileSync(`${__dirname}/expected.html`, "utf8");
        expect(actual).html.to.equal(expected);
    });

    it("Plays a movie with flashvars", async () => {
        await play_and_monitor(
            browser,
            await browser.$("#test-container").$("<ruffle-embed />"),
            `// _level0.a
1

// typeof(a)
string

// _level0.b
3 %3

// typeof(b)
string

// _level0.c


// typeof(c)
string

// _level0.d
undefined

// typeof(d)
undefined

`
        );
    });
});
