/***************************************************************************
                                 visc_dyn.cpp
                             -------------------
    begin                : Mon May 1 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #include "main_widget.h"

 float main_widget::visc_dyn(int box, int x) {
  TheString = new QString("\"dynamic viscosity\": a measure of the resistance to flow of a fluid under an applied force"); 
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==56) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
		if ((x==0)||(x==7)) {
		  TheString->append("\n\n\"poise\": a cgs unit of dynamic viscosity equal\n"
				    "to one dyne-second per square centimeter; the viscosity\n"
				    "of a fluid in which a force of one dyne per square\n"
				    "centimeter maintains a velocity of 1 centimeter per second");
		}
	}
	
	else if ((y==0)||(y==7)) {
	  TheString->append("\n\n\"poise\": a cgs unit of dynamic viscosity equal\n"
			    "to one dyne-second per square centimeter; the viscosity\n"
			    "of a fluid in which a force of one dyne per square\n"
			    "centimeter maintains a velocity of 1 centimeter per second");
	}
	
	if (x!=y) {
	  if ((x==0)||(x==7)) {
	    TheString->append("\n\n\"poise\": a cgs unit of dynamic viscosity equal\n"
			      "to one dyne-second per square centimeter; the viscosity\n"
			      "of a fluid in which a force of one dyne per square\n"
			      "centimeter maintains a velocity of 1 centimeter per second");
	    
	  }  
	}

	if (x==0) {
		if ((y==1)||(y==3)||(y==7)) {
			ret_val = 100.0;
		}
		else if (y==2) {
			ret_val = 98039.20999999999;
		}
		else if (y==4) {
			ret_val = 0.27799999999999997;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 1000.0;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 1488.164;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 47880.26;
		}
		else if (y==10) {
			ret_val = 6894756.999999999;
		}
		else if (y==11) {
			ret_val = 0.413;
		}
		else if (y==13) {
			ret_val = 17857.14;
		}
	}
	else if ((x==1)||(x==3)||(x==7)) {
		if (y==0) {
			ret_val = 0.01;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 1.0;
		}
		else if (y==2) {
			ret_val = 980.3920999999999;
		}
		else if (y==4) {
			ret_val = 0.0027799999999999995;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 10.0;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 14.881639999999999;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 478.8026;
		}
		else if (y==10) {
			ret_val = 68947.56999999999;
		}
		else if (y==11) {
			ret_val = 0.00413;
		}
		else if (y==13) {
			ret_val = 178.5714;
		}
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 1.0200000591600035E-5;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 0.0010200000591600036;
		}
		else if (y==4) {
			ret_val = 2.8356001644648095E-6;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 0.010200000591600035;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 0.015179273680397874;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 0.4883786803259635;
		}
		else if (y==10) {
			ret_val = 70.32652547893848;
		}
		else if (y==11) {
			ret_val = 4.212600244330814E-6;
		}
		else if (y==13) {
			ret_val = 0.18214283856428465;
		}
	}
	else if (x==4) {
		if (y==0) {
			ret_val = 3.5971223021582737;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 359.7122302158274;
		}
		else if (y==2) {
			ret_val = 352659.02877697843;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 3597.1223021582737;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 5353.107913669065;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 172231.1510791367;
		}
		else if (y==10) {
			ret_val = 2.480128417266187E7;
		}
		else if (y==11) {
			ret_val = 1.485611510791367;
		}
		else if (y==13) {
			ret_val = 64234.316546762595;
		}
	}
	else if ((x==5)||(x==6)) {
		if (y==0) {
			ret_val = 0.0010;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 0.1;
		}
		else if (y==2) {
			ret_val = 98.03921;
		}
		else if (y==4) {
			ret_val = 2.78E-4;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 1.0;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 1.488164;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 47.88026;
		}
		else if (y==10) {
			ret_val = 6894.757;
		}
		else if (y==11) {
			ret_val = 4.13E-4;
		}
		else if (y==13) {
			ret_val = 17.85714;
		}
	}
	else if ((x==8)||(x==12)) {
		if (y==0) {
			ret_val = 6.719689496587741E-4;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 0.06719689496587741;
		}
		else if (y==2) {
			ret_val = 65.87930496907599;
		}
		else if (y==4) {
			ret_val = 1.868073680051392E-4;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 0.6719689496587742;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 1.0;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 32.174048021589016;
		}
		else if (y==10) {
			ret_val = 4633.06261944248;
		}
		else if (y==11) {
			ret_val = 2.775231762090737E-4;
		}
		else if (y==13) {
			ret_val = 11.999443609709683;
		}
	}
	else if ((x==9)||(x==14)) {
		if (y==0) {
			ret_val = 2.0885433788371242E-5;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 0.0020885433788371244;
		}
		else if (y==2) {
			ret_val = 2.0475914291192234;
		}
		else if (y==4) {
			ret_val = 5.8061505931672045E-6;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 0.02088543378837124;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 0.0310809506882377;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 1.0;
		}
		else if (y==10) {
			ret_val = 143.99999081040912;
		}
		else if (y==11) {
			ret_val = 8.625684154597324E-6;
		}
		else if (y==13) {
			ret_val = 0.37295411511967563;
		}
	}
	else if (x==10) {
		if (y==0) {
			ret_val = 1.4503774389728312E-7;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 1.4503774389728313E-5;
		}
		else if (y==2) {
			ret_val = 0.014219385831871958;
		}
		else if (y==4) {
			ret_val = 4.03204928034447E-8;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 1.4503774389728312E-4;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 2.1583994910915645E-4;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 0.006944444887615329;
		}
		else if (y==11) {
			ret_val = 5.990058822957793E-8;
		}
		else if (y==13) {
			ret_val = 0.0025899592980579305;
		}
	}
	else if (x==11) {
		if (y==0) {
			ret_val = 2.4213075060532687;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 242.13075060532688;
		}
		else if (y==2) {
			ret_val = 237383.07506053266;
		}
		else if (y==4) {
			ret_val = 0.6731234866828086;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 2421.3075060532688;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 3603.302663438257;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 115932.83292978207;
		}
		else if (y==10) {
			ret_val = 1.6694326876513315E7;
		}
		else if (y==13) {
			ret_val = 43237.62711864407;
		}
	}
	else if (x==13) {
		if (y==0) {
			ret_val = 5.6000008960001434E-5;
		}
		else if ((y==1)||(y==3)||(y==7)) {
			ret_val = 0.005600000896000143;
		}
		else if (y==2) {
			ret_val = 5.4901966384314616;
		}
		else if (y==4) {
			ret_val = 1.5568002490880397E-5;
		}
		else if ((y==5)||(y==6)) {
			ret_val = 0.05600000896000143;
		}
		else if ((y==8)||(y==12)) {
			ret_val = 0.08333719733395158;
		}
		else if ((y==9)||(y==14)) {
			ret_val = 2.681294989007198;
		}
		else if (y==10) {
			ret_val = 386.1064537770326;
		}
		else if (y==11) {
			ret_val = 2.3128003700480592E-5;
		}
	}
	return ret_val;
 }
