/***************************************************************************
                                 mass.cpp
                             -------------------
    begin                : Mon Apr 24 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "main_widget.h"

 float main_widget::mass(int box, int x) {
	TheString = new QString("\"mass\" of \"weight\": The quantity of matter which a body contains,\n"
				"irrespective of its bulk or volume.\n"
     				"Mass and weight are often used, in a general way, as\n"
           			"interchangeable terms, since the weight of a body is\n"
           			"proportional to its mass (under the same or equal\n"
           			"gravitative forces), and the mass is usually\n"
           			"ascertained from the weight. Yet the two ideas, mass\n"
           			"and weight, are quite distinct. Mass is the quantity of\n"
           			"matter in a body; weight is the comparative force with\n"
           			"which it tends towards the center of the earth. A mass\n"
           			"of sugar and a mass of lead are assumed to be equal\n"
           			"when they show an equal weight by balancing each other\n"
           			"in the scales.");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==34) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
		if (x==0) {
			TheString->append("\n\n\"atomic mass unit\": a unit of mass for expressing masses of atoms, molecules, or\n"
                   			  "nuclear particles equal to 1/12 the mass of a single atom of the\n"
                   			  "most abundant carbon isotope 12C -- called also dalton");
		}
		else if (x==1) {
			TheString->append("\n\n\"carat\": a unit of weight for precious stones = 200 mg\n"
       					  "the unit of measurement for the proportion of gold in an\n"
          				  "alloy; 18-karat gold is 75% gold; 24-karat gold is pure gold");
		}
		else if (x==2) {
			TheString->append("\n\n\"grain\": the unit of the English system of weights; -- so called\n"
        			          "because considered equal to the average of grains taken\n"
        				  "from the middle of the ears of wheat. 7,000 grains\n"
        				  "constitute the pound avoirdupois, and 5,760 grains the\n"
        				  "pound troy. A grain is equal to .0648 gram.");
		}
		else if (x==3) {
			TheString->append("\n\n\"gram\": the unit of weight in the metric system. It was intended to\n"
     					  "be exactly, and is very nearly, equivalent to the weight in a\n"
     					  "vacuum of one cubic centimeter of pure water at its maximum\n"
     					  "density. It is equal to 15.432 grains.");
		}
		else if (x==4) {
			TheString->append("\n\n\"hundredweight (long)\": a British unit of weight equivalent to 112 pounds");
		}
		else if (x==5) {
			TheString->append("\n\n\"hundredweight (short)\": a United States unit of weight equivalent to 100 pounds");
		}
		else if (x==6) {
			TheString->append("\n\n\"kilogram\": a measure of weight, being a thousand grams, equal to 2.2046\n"
     					  "pounds avoirdupois (15,432.34 grains). It is equal to the\n"
     					  "weight of a cubic decimeter of distilled water at the\n"
     					  "temperature of maximum density, or 39[deg] Fahrenheit");
		}
		else if (x==8) {
			TheString->append("\n\n\"milligram\": a measure of weight, in the metric system, being the\n"
     					  "thousandth part of a gram, equal to the weight of a cubic\n"
     					  "millimeter of water, or .01543 of a grain avoirdupois.");
		}
		else if (x==9) {
			TheString->append("\n\n\"ounce (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if (x==10) {
			TheString->append("\n\n\"ounce (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (x==11) {
			TheString->append("\n\n\"pennyweight\": a troy weight containing twenty-four grains, or the twentieth\n"
				     "part of an ounce; as, a pennyweight of gold or of arsenic. It\n"
				     "was anciently the weight of a silver penny, whence the name");
		}
		else if (x==12) {
			TheString->append("\n\n\"pounds mass (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if (x==13) {
			TheString->append("\n\n\"pounds mass (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (x==14) {
			TheString->append("\n\n\"slug\": the gravitational unit of mass in the foot-pound-second system\n"
                		   "to which a pound force can impart an acceleration of one foot per\n"
	        	           "second per second and which is equal to the mass of an object\n"
		                   "weighing 32 pounds ");
		}
		else if (x==15) {
			TheString->append("\n\n\"stone\": an avoirdupois unit used to measure the weight of\n"
          				"a human body; equal to 14 pounds");
		}
		else if ((x==16)||(x==17)||(x==18)||(x==19)) {
			TheString->append("\n\n\"ton\": the weight of twenty hundredweight.\n"
					"In England, the ton is 2,240 pounds. In the United\n"
				           "States the ton is commonly estimated at 2,000 pounds,\n"
				           "this being sometimes called the short ton, while that\n"
				           "of 2,240 pounds is called the long ton.\n"
					"(Naut. & Com.) Forty cubic feet of space, being the unit\n"
				         "of measurement of the burden, or carrying capacity, of a\n"
				         "vessel; as a vessel of 300 tons burden. \n"
					"(Naut. & Com.) A certain weight or quantity of\n"
				         "merchandise, with reference to transportation as freight;");
		}
		else if (x==20) {
			TheString->append("\n\n\"tonne\": a unit of weight equivalent to 1000 kilograms; a metric ton");
		}
	}

		else if (y==0) {
			TheString->append("\n\n\"atomic mass unit\": a unit of mass for expressing masses of atoms, molecules, or\n"
                   			  "nuclear particles equal to 1/12 the mass of a single atom of the\n"
                   			  "most abundant carbon isotope 12C -- called also dalton");
		}
		else if (y==1) {
			TheString->append("\n\n\"carat\": a unit of weight for precious stones = 200 mg\n"
       					  "the unit of measurement for the proportion of gold in an\n"
          				  "alloy; 18-karat gold is 75% gold; 24-karat gold is pure gold");
		}
		else if (y==2) {
			TheString->append("\n\n\"grain\": the unit of the English system of weights; -- so called\n"
        			          "because considered equal to the average of grains taken\n"
        				  "from the middle of the ears of wheat. 7,000 grains\n"
        				  "constitute the pound avoirdupois, and 5,760 grains the\n"
        				  "pound troy. A grain is equal to .0648 gram.");
		}
		else if (y==3) {
			TheString->append("\n\n\"gram\": the unit of weight in the metric system. It was intended to\n"
     					  "be exactly, and is very nearly, equivalent to the weight in a\n"
     					  "vacuum of one cubic centimeter of pure water at its maximum\n"
     					  "density. It is equal to 15.432 grains.");
		}
		else if (y==4) {
			TheString->append("\n\n\"hundredweight (long)\": a British unit of weight equivalent to 112 pounds");
		}
		else if (y==5) {
			TheString->append("\n\n\"hundredweight (short)\": a United States unit of weight equivalent to 100 pounds");
		}
		else if (y==6) {
			TheString->append("\n\n\"kilogram\": a measure of weight, being a thousand grams, equal to 2.2046\n"
     					  "pounds avoirdupois (15,432.34 grains). It is equal to the\n"
     					  "weight of a cubic decimeter of distilled water at the\n"
     					  "temperature of maximum density, or 39[deg] Fahrenheit");
		}
		else if (y==8) {
			TheString->append("\n\n\"milligram\": a measure of weight, in the metric system, being the\n"
     					  "thousandth part of a gram, equal to the weight of a cubic\n"
     					  "millimeter of water, or .01543 of a grain avoirdupois.");
		}
		else if (y==9) {
			TheString->append("\n\n\"ounce (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if (y==10) {
			TheString->append("\n\n\"ounce (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (y==11) {
			TheString->append("\n\n\"pennyweight\": a troy weight containing twenty-four grains, or the twentieth\n"
				     "part of an ounce; as, a pennyweight of gold or of arsenic. It\n"
				     "was anciently the weight of a silver penny, whence the name");
		}
		else if (y==12) {
			TheString->append("\n\n\"pounds mass (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if (y==13) {
			TheString->append("\n\n\"pounds mass (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (y==14) {
			TheString->append("\n\n\"slug\": the gravitational unit of mass in the foot-pound-second system\n"
                		   "to which a pound force can impart an acceleration of one foot per\n"
	        	           "second per second and which is equal to the mass of an object\n"
		                   "weighing 32 pounds ");
		}
		else if (y==15) {
			TheString->append("\n\n\"stone\": an avoirdupois unit used to measure the weight of\n"
          				"a human body; equal to 14 pounds");
		}
		else if ((y==16)||(y==17)||(y==18)||(y==19)) {
			TheString->append("\n\n\"ton\": the weight of twenty hundredweight.\n"
					"In England, the ton is 2,240 pounds. In the United\n"
				           "States the ton is commonly estimated at 2,000 pounds,\n"
				           "this being sometimes called the short ton, while that\n"
				           "of 2,240 pounds is called the long ton.\n"
					"(Naut. & Com.) Forty cubic feet of space, being the unit\n"
				         "of measurement of the burden, or carrying capacity, of a\n"
				         "vessel; as a vessel of 300 tons burden. \n"
					"(Naut. & Com.) A certain weight or quantity of\n"
				         "merchandise, with reference to transportation as freight;");
		}
		else if (y==20) {
			TheString->append("\n\n\"tonne\": a unit of weight equivalent to 1000 kilograms; a metric ton");
		}
	
	
	if (x!=y) {
		if (x==0) {
			TheString->append("\n\n\"atomic mass unit\": a unit of mass for expressing masses of atoms, molecules, or\n"
                   			  "nuclear particles equal to 1/12 the mass of a single atom of the\n"
                   			  "most abundant carbon isotope 12C -- called also dalton");
		}
		else if (x==1) {
			TheString->append("\n\n\"carat\": a unit of weight for precious stones = 200 mg\n"
       					  "the unit of measurement for the proportion of gold in an\n"
          				  "alloy; 18-karat gold is 75% gold; 24-karat gold is pure gold");
		}
		else if (x==2) {
			TheString->append("\n\n\"grain\": the unit of the English system of weights; -- so called\n"
        			          "because considered equal to the average of grains taken\n"
        				  "from the middle of the ears of wheat. 7,000 grains\n"
        				  "constitute the pound avoirdupois, and 5,760 grains the\n"
        				  "pound troy. A grain is equal to .0648 gram.");
		}
		else if (x==3) {
			TheString->append("\n\n\"gram\": the unit of weight in the metric system. It was intended to\n"
     					  "be exactly, and is very nearly, equivalent to the weight in a\n"
     					  "vacuum of one cubic centimeter of pure water at its maximum\n"
     					  "density. It is equal to 15.432 grains.");
		}
		else if (x==4) {
			TheString->append("\n\n\"hundredweight (long)\": a British unit of weight equivalent to 112 pounds");
		}
		else if (x==5) {
			TheString->append("\n\n\"hundredweight (short)\": a United States unit of weight equivalent to 100 pounds");
		}
		else if (x==6) {
			TheString->append("\n\n\"kilogram\": a measure of weight, being a thousand grams, equal to 2.2046\n"
     					  "pounds avoirdupois (15,432.34 grains). It is equal to the\n"
     					  "weight of a cubic decimeter of distilled water at the\n"
     					  "temperature of maximum density, or 39[deg] Fahrenheit");
		}
		else if (x==8) {
			TheString->append("\n\n\"milligram\": a measure of weight, in the metric system, being the\n"
     					  "thousandth part of a gram, equal to the weight of a cubic\n"
     					  "millimeter of water, or .01543 of a grain avoirdupois.");
		}
		else if ((x==9)&&(y!=12)) {
			TheString->append("\n\n\"ounce (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if ((x==10)&&(y!=13)) {
			TheString->append("\n\n\"ounce (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (x==11) {
			TheString->append("\n\n\"pennyweight\": a troy weight containing twenty-four grains, or the twentieth\n"
				     "part of an ounce; as, a pennyweight of gold or of arsenic. It\n"
				     "was anciently the weight of a silver penny, whence the name");
		}
		else if ((x==12)&&(y!=9)) {
			TheString->append("\n\n\"pounds mass (avoirdupois)\": avoirdupois: a system of weights by which coarser\n"
        				  "commodities are weighed, such as hay, grain, butter, sugar, tea.\n"
					  "The standard Avoirdupois pound of the United States is\n"
           				  "equivalent to the weight of 27.7015 cubic inches of\n"
 				          "distilled water at 62[deg] Fahrenheit, the barometer\n"
			 		  "being at 30 inches, and the water weighed in the air\n"
				           "with brass weights. In this system of weights 16 drams\n"
				           "make 1 ounce, 16 ounces 1 pound, 25 pounds 1 quarter, 4\n"
				           "quarters 1 hundred weight, and 20 hundred weight 1 ton.\n"
				           "The above pound contains 7,000 grains, or 453.54 grams,\n"
				           "so that 1 pound avoirdupois is equivalent to 1 31-144\n"
				           "pounds troy. (See Troy weight.) Formerly, a hundred\n"
				           "weight was reckoned at 112 pounds, the ton being 2,240\n"
				           "pounds (sometimes called a long ton)");
		}
		else if ((x==13)&&(y!=10)) {
			TheString->append("\n\n\"pounds mass (troy)\": troy weight: the weight which gold and silver, jewels, and\n"
				        "the like, are weighed. It was so named from Troyes, in\n"
				        "France, where it was first adopted in Europe. The troy\n"
				        "ounce is supposed to have been brought from Cairo during\n"
				        "the crusades. In this weight the pound is divided into 12\n"
				        "ounces, the ounce into 20 pennyweights, and the\n"
				        "pennyweight into 24 grains; hence, the troy ounce contains\n"
				        "480 grains, and the troy pound contains 5760 grains. The\n"
				        "avoirdupois pound contains 7000 troy grains; so that 175\n"
				        "pounds troy equal 144 pounds avoirdupois, or 1 pound troy\n"
				        "= 0.82286 of a pound avoirdupois, and 1 ounce troy =\n"
				        "117/175 or 1.09714 ounce avoirdupois. Troy weight when\n"
				        "divided, the pound into 12 ounces, the ounce into 8 drams,\n"
				        "the dram into 3 scruples, and the scruple into 20 grains,\n"
				        "is called apothecaries' weight, used in weighing\n"
				        "medicines, etc. In the standard weights of the United\n"
				        "States, the troy ounce is divided decimally down to the 1/10000 part.");
		}
		else if (x==14) {
			TheString->append("\n\n\"slug\": the gravitational unit of mass in the foot-pound-second system\n"
                		   "to which a pound force can impart an acceleration of one foot per\n"
	        	           "second per second and which is equal to the mass of an object\n"
		                   "weighing 32 pounds ");
		}
		else if (x==15) {
			TheString->append("\n\n\"stone\": an avoirdupois unit used to measure the weight of\n"
          				"a human body; equal to 14 pounds");
		}
		else if ( ((x==16)||(x==17)||(x==18)||(x==19)) && ((y!=16)||(y!=17)||(y!=18)||(y!=19)) ) {
			TheString->append("\n\n\"ton\": the weight of twenty hundredweight.\n"
					"In England, the ton is 2,240 pounds. In the United\n"
				           "States the ton is commonly estimated at 2,000 pounds,\n"
				           "this being sometimes called the short ton, while that\n"
				           "of 2,240 pounds is called the long ton.\n"
					"(Naut. & Com.) Forty cubic feet of space, being the unit\n"
				         "of measurement of the burden, or carrying capacity, of a\n"
				         "vessel; as a vessel of 300 tons burden. \n"
					"(Naut. & Com.) A certain weight or quantity of\n"
				         "merchandise, with reference to transportation as freight;");
		}
		else if (x==20) {
			TheString->append("\n\n\"tonne\": a unit of weight equivalent to 1000 kilograms; a metric ton");
		}
	}
	
	if (x==0) {
		if (y==1) {
			ret_val = 1.204427475399569E23;
		}
		else if (y==2) {
			ret_val = 3.902279378997194E22;
		}
		else if (y==3) {
			ret_val = 6.022137376997844E23;
		}
		else if (y==4) {
			ret_val = 3.0593873077432643E28;
		}
		else if (y==5) {
			ret_val = 2.7315957459621568E28;
		}
		else if (y==6) {
			ret_val = 6.022137376997844E26;
		}
		else if (y==7) {
			ret_val = 5.90569935081359E27;
		}
		else if (y==8) {
			ret_val = 6.022137376997844E20;
		}
		else if (y==9) {
			ret_val = 1.7072470401194793E25;
		}
		else if (y==10) {
			ret_val = 1.873094294627049E25;
		}
		else if (y==11) {
			ret_val = 9.365471473135245E23;
		}
		else if (y==12) {
			ret_val = 2.7315955652980357E26;
		}
		else if (y==13) {
			ret_val = 2.2477127922242163E26;
		}
		else if (y==14) {
			ret_val = 8.788647066616883E27;
		}
		else if (y==15) {
			ret_val = 3.82423379141725E27;
		}
		else if (y==16) {
			ret_val = 1.7564587423368303E25;
		}
		else if (y==17) {
			ret_val = 6.1187746154865284E29;
		}
		else if (y==18) {
			ret_val = 6.022137376997844E29;
		}
		else if (y==19) {
			ret_val =5.463190889710576E29 ;
		}
		else if (y==20) {
			ret_val = 6.022137376997844E29;
		}
	}
	else if (x==1) {
		if (y==0) {
			ret_val = 8.302699999999999E-24;
		}
		else if (y==2) {
			ret_val = 0.32399454999999994;
		}
		else if (y==3) {
			ret_val = 5.0;
		}
		else if (y==4) {
			ret_val = 254011.74999999997;
		}
		else if (y==5) {
			ret_val = 226796.19999999998;
		}
		else if (y==6) {
			ret_val = 5000.0;
		}
		else if (y==7) {
			ret_val = 49033.24999999999;
		}
		else if (y==8) {
			ret_val = 0.004999999999999999;
		}
		else if (y==9) {
			ret_val = 141.74759999999998;
		}
		else if (y==10) {
			ret_val = 155.51739999999998;
		}
		else if (y==11) {
			ret_val = 7.77587;
		}
		else if (y==12) {
			ret_val = 2267.96185;
		}
		else if (y==13) {
			ret_val = 1866.2085;
		}
		else if (y==14) {
			ret_val = 72969.5;
		}
		else if (y==15) {
			ret_val = 31751.4659;
		}
		else if (y==16) {
			ret_val = 145.8335;
		}
		else if (y==17) {
			ret_val = 5080235.0;
		}
		else if (y==18) {
			ret_val = 5000000.0;
		}
		else if (y==19) {
			ret_val = 4535923.5;
		}
		else if (y==20) {
			ret_val = 5000000.0;
		}
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 2.5626048339393366E-23;
		}
		else if (y==1) {
			ret_val = 3.0864716705882866;
		}
		else if (y==3) {
			ret_val = 15.432358352941431;
		}
		else if (y==4) {
			ret_val = 784000.0703715541;
		}
		else if (y==5) {
			ret_val = 700000.0462970751;
		}
		else if (y==6) {
			ret_val = 15432.358352941432;
		}
		else if (y==7) {
			ret_val = 151339.73704187307;
		}
		else if (y==8) {
			ret_val = 0.015432358352941431;
		}
		else if (y==9) {
			ret_val = 437.4999517738802;
		}
		else if (y==10) {
			ret_val = 480.00004938354675;
		}
		else if (y==11) {
			ret_val = 24.00000246917734;
		}
		else if (y==12) {
			ret_val = 7000.000000000001;
		}
		else if (y==13) {
			ret_val = 5759.9996666610605;
		}
		else if (y==14) {
			ret_val = 225218.29456699197;
		}
		else if (y==15) {
			ret_val = 98000.00000000001;
		}
		else if (y==16) {
			ret_val = 450.11096637273687;
		}
		else if (y==17) {
			ret_val = 1.5680001407431083E7;
		}
		else if (y==18) {
			ret_val = 1.5432358352941431E7;
		}
		else if (y==19) {
			ret_val = 1.3999999382705668E7;
		}
		else if (y==20) {
			ret_val = 1.5432358352941431E7;
		}
	}
	else if (x==3) {
		if (y==0) {
			ret_val = 1.66054E-24;
		}
		else if (y==1) {
			ret_val = 0.2;
		}
		else if (y==2) {
			ret_val = 0.06479890999999999;
		}
		else if (y==4) {
			ret_val = 50802.35;
		}
		else if (y==5) {
			ret_val = 45359.24;
		}
		else if (y==6) {
			ret_val = 1000.0;
		}
		else if (y==7) {
			ret_val = 9806.65;
		}
		else if (y==8) {
			ret_val = 0.0010;
		}
		else if (y==9) {
			ret_val = 28.34952;
		}
		else if (y==10) {
			ret_val = 31.103479999999998;
		}
		else if (y==11) {
			ret_val = 1.555174;
		}
		else if (y==12) {
			ret_val = 453.59237;
		}
		else if (y==13) {
			ret_val = 373.2417;
		}
		else if (y==14) {
			ret_val = 14593.9;
		}
		else if (y==15) {
			ret_val = 6350.293180000001;
		}
		else if (y==16) {
			ret_val = 29.1667;
		}
		else if (y==17) {
			ret_val = 1016047.0;
		}
		else if (y==18) {
			ret_val = 1000000.0;
		}
		else if (y==19) {
			ret_val = 907184.7;
		}
		else if (y==20) {
			ret_val = 1000000.0;
		}
	}
	else if (x==4) {
		if (y==0) {
			ret_val = 3.268628321327655E-29;
		}
		else if (y==1) {
			ret_val = 3.9368257570761985E-6;
		}
		else if (y==2) {
			ret_val = 1.2755100895923121E-6;
		}
		else if (y==3) {
			ret_val = 1.9684128785380994E-5;
		}
		else if (y==5) {
			ret_val = 0.8928571217670049;
		}
		else if (y==6) {
			ret_val = 0.01968412878538099;
		}
		else if (y==7) {
			ret_val = 0.1930353615531565;
		}
		else if (y==8) {
			ret_val = 1.9684128785380993E-8;
		}
		else if (y==9) {
			ret_val = 5.580356026837341E-4;
		}
		else if (y==10) {
			ret_val = 6.12244905993522E-4;
		}
		else if (y==11) {
			ret_val = 3.0612245299676104E-5;
		}
		else if (y==12) {
			ret_val = 0.008928570627146186;
		}
		else if (y==13) {
			ret_val = 0.007346937690874537;
		}
		else if (y==14) {
			ret_val = 0.28726820708097167;
		}
		else if (y==15) {
			ret_val = 0.1249999887800466;
		}
		else if (y==16) {
			ret_val = 5.741210790445718E-4;
		}
		else if (y==17) {
			ret_val = 20.0;
		}
		else if (y==18) {
			ret_val = 19.68412878538099;
		}
		else if (y==19) {
			ret_val = 17.85714046692722;
		}
		else if (y==20) {
			ret_val = 19.68412878538099;
		}
	}
	else if (x==5) {
		if (y==0) {
			ret_val = 3.660863806360071E-29;
		}
		else if (y==1) {
			ret_val = 4.409244952075917E-6;
		}
		else if (y==2) {
			ret_val = 1.4285713340876081E-6;
		}
		else if (y==3) {
			ret_val = 2.2046224760379584E-5;
		}
		else if (y==4) {
			ret_val = 1.1200000264554697;
		}
		else if (y==6) {
			ret_val = 0.022046224760379582;
		}
		else if (y==7) {
			ret_val = 0.21619961004637642;
		}
		else if (y==8) {
			ret_val = 2.2046224760379584E-8;
		}
		else if (y==9) {
			ret_val = 6.249998897688762E-4;
		}
		else if (y==10) {
			ret_val = 6.857143109099712E-4;
		}
		else if (y==11) {
			ret_val = 3.428571554549856E-5;
		}
		else if (y==12) {
			ret_val = 0.009999999338613258;
		}
		else if (y==13) {
			ret_val = 0.008228570408146169;
		}
		else if (y==14) {
			ret_val = 0.3217403995305036;
		}
		else if (y==15) {
			ret_val = 0.1399999907405856;
		}
		else if (y==16) {
			ret_val = 6.430156237185632E-4;
		}
		else if (y==17) {
			ret_val = 22.400000529109395;
		}
		else if (y==18) {
			ret_val = 22.046224760379584;
		}
		else if (y==19) {
			ret_val = 19.999997795377524;
		}
		else if (y==20) {
			ret_val = 22.046224760379584;
		}
	}
	else if (x==6) {
		if (y==0) {
			ret_val = 1.66054E-27;
		}
		else if (y==1) {
			ret_val = 2.0E-4;
		}
		else if (y==2) {
			ret_val = 6.479891E-5;
		}
		else if (y==3) {
			ret_val = 0.0010;
		}
		else if (y==4) {
			ret_val = 50.80235;
		}
		else if (y==5) {
			ret_val = 45.35924;
		}
		else if (y==7) {
			ret_val = 9.80665;
		}
		else if (y==8) {
			ret_val = 1.0E-6;
		}
		else if (y==9) {
			ret_val = 0.02834952;
		}
		else if (y==10) {
			ret_val = 0.03110348;
		}
		else if (y==11) {
			ret_val = 0.001555174;
		}
		else if (y==12) {
			ret_val = 0.45359237;
		}
		else if (y==13) {
			ret_val = 0.3732417;
		}
		else if (y==14) {
			ret_val = 14.5939;
		}
		else if (y==15) {
			ret_val = 6.35029318;
		}
		else if (y==16) {
			ret_val = 0.0291667;
		}
		else if (y==17) {
			ret_val = 1016.047;
		}
		else if (y==18) {
			ret_val = 1000.0;
		}
		else if (y==19) {
			ret_val = 907.1847;
		}
		else if (y==20) {
			ret_val = 1000.0;
		}
	}
	else if (x==7) {
		if (y==0) {
			ret_val = 1.6932795602983691E-28;
		}
		else if (y==1) {
			ret_val = 2.0394324259558567E-5;
		}
		else if (y==2) {
			ret_val = 6.60764991102976E-6;
		}
		else if (y==3) {
			ret_val = 1.0197162129779284E-4;
		}
		else if (y==4) {
			ret_val = 5.180397995237925;
		}
		else if (y==5) {
			ret_val = 4.625355243635696;
		}
		else if (y==6) {
			ret_val = 0.10197162129779283;
		}
		else if (y==8) {
			ret_val = 1.0197162129779283E-7;
		}
		else if (y==9) {
			ret_val = 0.002890846517414204;
		}
		else if (y==10) {
			ret_val = 0.003171672283603473;
		}
		else if (y==11) {
			ret_val = 1.585836141801737E-4;
		}
		else if (y==12) {
			ret_val = 0.046253549377208325;
		}
		else if (y==13) {
			ret_val = 0.0380600612849444;
		}
		else if (y==14) {
			ret_val = 1.4881636440578587;
		}
		else if (y==15) {
			ret_val = 0.6475496912809166;
		}
		else if (y==16) {
			ret_val = 0.0029741756869063342;
		}
		else if (y==17) {
			ret_val = 103.60795990475852;
		}
		else if (y==18) {
			ret_val = 101.97162129779284;
		}
		else if (y==19) {
			ret_val = 92.5070946755518;
		}
		else if (y==20) {
			ret_val = 101.97162129779284;
		}
	}
	else if (x==8) {
		if (y==0) {
			ret_val = 1.66054E-21;
		}
		else if (y==1) {
			ret_val = 200.00000000000003;
		}
		else if (y==2) {
			ret_val = 64.79890999999999;
		}
		else if (y==3) {
			ret_val = 1000.0000000000001;
		}
		else if (y==4) {
			ret_val = 5.080235E7;
		}
		else if (y==5) {
			ret_val = 4.535924E7;
		}
		else if (y==6) {
			ret_val = 1000000.0;
		}
		else if (y==7) {
			ret_val = 9806650.0;
		}
		else if (y==9) {
			ret_val = 28349.52;
		}
		else if (y==10) {
			ret_val = 31103.48;
		}
		else if (y==11) {
			ret_val = 1555.1740000000002;
		}
		else if (y==12) {
			ret_val = 453592.37000000005;
		}
		else if (y==13) {
			ret_val = 373241.7;
		}
		else if (y==14) {
			ret_val = 1.45939E7;
		}
		else if (y==15) {
			ret_val = 6350293.180000001;
		}
		else if (y==16) {
			ret_val = 29166.7;
		}
		else if (y==17) {
			ret_val = 1.0160470000000001E9;
		}
		else if (y==18) {
			ret_val = 1.0E9;
		}
		else if (y==19) {
			ret_val = 9.071847000000001E8;
		}
		else if (y==20) {
			ret_val = 1.0E9;
		}
	}
	else if (x==9) {
		if (y==0) {
			ret_val = 5.857383123241593E-26;
		}
		else if (y==1) {
			ret_val = 0.007054793167573913;
		}
		else if (y==2) {
			ret_val = 0.0022857145376711844;
		}
		else if (y==3) {
			ret_val = 0.03527396583786957;
		}
		else if (y==4) {
			ret_val = 1792.0003583834928;
		}
		else if (y==5) {
			ret_val = 1600.0002821917267;
		}
		else if (y==6) {
			ret_val = 35.27396583786957;
		}
		else if (y==7) {
			ret_val = 345.91943708394354;
		}
		else if (y==8) {
			ret_val = 3.527396583786957E-5;
		}
		else if (y==10) {
			ret_val = 1.0971430909588593;
		}
		else if (y==11) {
			ret_val = 0.05485715454794297;
		}
		else if (y==12) {
			ret_val = 16.000001763698293;
		}
		else if (y==13) {
			ret_val = 13.165714975068362;
		}
		else if (y==14) {
			ret_val = 514.7847300412847;
		}
		else if (y==15) {
			ret_val = 224.0000246917761;
		}
		else if (y==16) {
			ret_val = 1.0288251794033902;
		}
		else if (y==17) {
			ret_val = 35840.00716766986;
		}
		else if (y==18) {
			ret_val = 35273.96583786957;
		}
		else if (y==19) {
			ret_val = 32000.00211643795;
		}
		else if (y==20) {
			ret_val = 35273.96583786957;
		}
	}
	else if (x==10) {
		if (y==0) {
			ret_val = 5.338759521442616E-26;
		}
		else if (y==1) {
			ret_val = 0.006430148652176541;
		}
		else if (y==2) {
			ret_val = 0.002083333118995045;
		}
		else if (y==3) {
			ret_val = 0.03215074326088271;
		}
		else if (y==4) {
			ret_val = 1633.3333118995045;
		}
		else if (y==5) {
			ret_val = 1458.3332797487612;
		}
		else if (y==6) {
			ret_val = 32.150743260882706;
		}
		else if (y==7) {
			ret_val = 315.29108639933537;
		}
		else if (y==8) {
			ret_val = 3.215074326088271E-5;
		}
		else if (y==9) {
			ret_val = 0.9114581390892594;
		}
		else if (y==11) {
			ret_val = 0.05;
		}
		else if (y==12) {
			ret_val = 14.583331832965316;
		}
		else if (y==13) {
			ret_val = 11.999998070955405;
		}
		else if (y==14) {
			ret_val = 469.2047320749961;
		}
		else if (y==15) {
			ret_val = 204.16664566151442;
		}
		else if (y==16) {
			ret_val = 0.9377310834671876;
		}
		else if (y==17) {
			ret_val = 32666.66623799009;
		}
		else if (y==18) {
			ret_val = 32150.743260882708;
		}
		else if (y==19) {
			ret_val = 29166.6623799009;
		}
		else if (y==20) {
			ret_val = 32150.743260882708;
		}
	}
	else if (x==11) {
		if (y==0) {
			ret_val = 1.0677519042885233E-24;
		}
		else if (y==1) {
			ret_val = 0.12860297304353083;
		}
		else if (y==2) {
			ret_val = 0.041666662379900896;
		}
		else if (y==3) {
			ret_val = 0.643014865217654;
		}
		else if (y==4) {
			ret_val = 32666.666237990084;
		}
		else if (y==5) {
			ret_val = 29166.665594975224;
		}
		else if (y==6) {
			ret_val = 643.014865217654;
		}
		else if (y==7) {
			ret_val = 6305.821727986707;
		}
		else if (y==8) {
			ret_val = 6.43014865217654E-4;
		}
		else if (y==9) {
			ret_val = 18.22916278178519;
		}
		else if (y==10) {
			ret_val = 20.0;
		}
		else if (y==12) {
			ret_val = 291.6666366593063;
		}
		else if (y==13) {
			ret_val = 239.99996141910808;
		}
		else if (y==14) {
			ret_val = 9384.094641499922;
		}
		else if (y==15) {
			ret_val = 4083.332913230288;
		}
		else if (y==16) {
			ret_val = 18.754621669343752;
		}
		else if (y==17) {
			ret_val = 653333.3247598017;
		}
		else if (y==18) {
			ret_val = 643014.865217654;
		}
		else if (y==19) {
			ret_val = 583333.2475980179;
		}
		else if (y==20) {
			ret_val = 643014.865217654;
		}
	}
	else if (x==12) {
		if (y==0) {
			ret_val = 3.660864048484766E-27;
		}
		else if (y==1) {
			ret_val = 4.4092452436975517E-4;
		}
		else if (y==2) {
			ret_val = 1.4285714285714284E-4;
		}
		else if (y==3) {
			ret_val = 0.002204622621848776;
		}
		else if (y==4) {
			ret_val = 112.00001005307914;
		}
		else if (y==5) {
			ret_val = 100.00000661386785;
		}
		else if (y==6) {
			ret_val = 2.2046226218487757;
		}
		else if (y==7) {
			ret_val = 21.619962434553294;
		}
		else if (y==8) {
			ret_val = 2.2046226218487755E-6;
		}
		else if (y==9) {
			ret_val = 0.062499993110554306;
		}
		else if (y==10) {
			ret_val = 0.06857143562622095;
		}
		else if (y==11) {
			ret_val = 0.003428571781311048;
		}
		else if (y==13) {
			ret_val = 0.8228570952372942;
		}
		else if (y==14) {
			ret_val = 32.174042080998845;
		}
		else if (y==15) {
			ret_val = 14.0;
		}
		else if (y==16) {
			ret_val = 0.06430156662467669;
		}
		else if (y==17) {
			ret_val = 2240.000201061583;
		}
		else if (y==18) {
			ret_val = 2204.622621848776;
		}
		else if (y==19) {
			ret_val = 1999.9999118150952;
		}
		else if (y==20) {
			ret_val = 2204.622621848776;
		}
	}
	else if (x==13) {
		if (y==0) {
			ret_val = 4.4489669830568235E-27;
		}
		else if (y==1) {
			ret_val = 4.4092452436975517E-4;
		}
		else if (y==2) {
			ret_val = 1.4285714285714284E-4;
		}
		else if (y==3) {
			ret_val = 0.002204622621848776;
		}
		else if (y==4) {
			ret_val = 112.00001005307914;
		}
		else if (y==5) {
			ret_val = 100.00000661386785;
		}
		else if (y==6) {
			ret_val = 2.2046226218487757;
		}
		else if (y==7) {
			ret_val = 21.619962434553294;
		}
		else if (y==8) {
			ret_val = 2.2046226218487755E-6;
		}
		else if (y==9) {
			ret_val = 0.062499993110554306;
		}
		else if (y==10) {
			ret_val = 0.06857143562622095;
		}
		else if (y==11) {
			ret_val = 0.003428571781311048;
		}
		else if (y==12) {
			ret_val = 0.8228570952372942;
		}
		else if (y==14) {
			ret_val = 39.100400625117715;
		}
		else if (y==15) {
			ret_val = 17.013889873505562;
		}
		else if (y==16) {
			ret_val = 0.0781442695175807;
		}
		else if (y==17) {
			ret_val = 2722.2226241065778;
		}
		else if (y==18) {
			ret_val = 2679.229035769583;
		}
		else if (y==19) {
			ret_val = 2430.5555890459186;
		}
		else if (y==20) {
			ret_val = 2679.229035769583;
		}
	}
	else if (x==14) {
		if (y==0) {
			ret_val = 1.1378315597612701E-28;
		}
		else if (y==1) {
			ret_val = 1.3704355929532202E-5;
		}
		else if (y==2) {
			ret_val = 4.440136632428617E-6;
		}
		else if (y==3) {
			ret_val = 6.852177964766101E-5;
		}
		else if (y==4) {
			ret_val = 3.4810674322833512;
		}
		else if (y==5) {
			ret_val = 3.1080958482653713;
		}
		else if (y==6) {
			ret_val = 0.06852177964766101;
		}
		else if (y==7) {
			ret_val = 0.6719691103817348;
		}
		else if (y==8) {
			ret_val = 6.852177964766101E-8;
		}
		else if (y==9) {
			ret_val = 0.0019425595625569587;
		}
		else if (y==10) {
			ret_val = 0.002131265802835431;
		}
		else if (y==11) {
			ret_val = 1.0656329014177157E-4;
		}
		else if (y==12) {
			ret_val = 0.031080956427000324;
		}
		else if (y==13) {
			ret_val = 0.025575185522718397;
		}
		else if (y==15) {
			ret_val = 0.43513338997800455;
		}
		else if (y==16) {
			ret_val = 0.0019985541904494345;
		}
		else if (y==17) {
			ret_val = 69.62134864566703;
		}
		else if (y==18) {
			ret_val = 68.521779647661;
		}
		else if (y==19) {
			ret_val = 62.16191011312946;
		}
		else if (y==20) {
			ret_val = 68.521779647661;
		}
	}
	else if (x==15) {
		if (y==0) {
			ret_val = 2.6149028917748326E-28;
		}
		else if (y==1) {
			ret_val = 3.149460888355394E-5;
		}
		else if (y==2) {
			ret_val = 1.020408163265306E-5;
		}
		else if (y==3) {
			ret_val = 1.574730444177697E-4;
		}
		else if (y==4) {
			ret_val = 8.000000718077082;
		}
		else if (y==5) {
			ret_val = 7.1428576152762755;
		}
		else if (y==6) {
			ret_val = 0.1574730444177697;
		}
		else if (y==7) {
			ret_val = 1.544283031039521;
		}
		else if (y==8) {
			ret_val = 1.5747304441776967E-7;
		}
		else if (y==9) {
			ret_val = 0.0044642852221824505;
		}
		else if (y==10) {
			ret_val = 0.0048979596875872115;
		}
		else if (y==11) {
			ret_val = 2.448979843793606E-4;
		}
		else if (y==12) {
			ret_val = 0.07142857142857142;
		}
		else if (y==13) {
			ret_val = 0.05877550680266387;
		}
		else if (y==14) {
			ret_val = 2.298145862928489;
		}
		else if (y==16) {
			ret_val = 0.004592969044619763;
		}
		else if (y==17) {
			ret_val = 160.00001436154164;
		}
		else if (y==18) {
			ret_val = 157.4730444177697;
		}
		else if (y==19) {
			ret_val = 142.85713655822107;
		}
		else if (y==20) {
			ret_val = 157.4730444177697;
		}
	}
    else if (x==16) {
        if (y==0) {
            ret_val = 5.693273493401722E-26; 
        }
        else if (y==1) {
            ret_val = 0.00685713502041712; 
        }
        else if (y==2) {
            ret_val = 0.0022216743752292854;
        }
        else if (y==3) {
            ret_val = 0.0342856751020856;  
        }
        else if (y==4) {
            ret_val = 1741.792866522438;
        }
        else if (y==5) {
            ret_val = 1555.1721655175252;
        }
        else if (y==6) {
            ret_val = 34.2856751020856;  
        }
        else if (y==7) {
            ret_val = 336.2276157398677;
        }
        else if (y==8) {
            ret_val = 3.42856751020856E-5;  
        }
        else if (y==9) {
            ret_val = 0.9719824320200776;   
        }
        else if (y==10) {
            ret_val = 1.0664038098242172;   
        }
        else if (y==11) {
            ret_val = 0.05332019049121087; 
        }
        else if (y==12) {
            ret_val = 15.551720626604999;  
        }
        else if (y==13) {
            ret_val = 12.796843660750103;  
        }
        else if (y==14) {
            ret_val = 500.36171387232696;
        }
        else if (y==15) {
            ret_val = 217.72408877247;      
        }
        else if (y==17) {
            ret_val = 34835.857330448765;
		}
        else if (y==18) {
            ret_val = 34285.675102085595;
        }
        else if (y==19) {
            ret_val = 31103.439881782993;   
        }
        else if (y==20) {
            ret_val = 34285.675102085595;
		}
	}
    else if (x==17) {
        if (y==0) {
            ret_val = 1.6343141606638273E-30;
        }
        else if (y==1) {
            ret_val = 1.9684128785380992E-7;
        }
        else if (y==2) {
            ret_val = 6.37755044796156E-8;  
        }
        else if (y==3) {
            ret_val = 9.842064392690496E-7;
        }
        else if (y==4) {
            ret_val = 0.049999999999999996;
        }
        else if (y==5) {
            ret_val = 0.044642856088350245;
        }
        else if (y==6) {
            ret_val = 9.842064392690496E-4;
        }
        else if (y==7) {
            ret_val = 0.009651768077657824;
        }
        else if (y==8) {
            ret_val = 9.842064392690496E-10;
        }
        else if (y==9) {
            ret_val = 2.7901780134186705E-5;
        }
        else if (y==10) {
            ret_val = 3.06122452996761E-5;
        }
        else if (y==11) {
            ret_val = 1.5306122649838049E-6;
        }
        else if (y==12) {
            ret_val = 4.4642853135730924E-4;
        }
        else if (y==13) {
            ret_val = 3.6734688454372684E-4;
        }
        else if (y==14) {
            ret_val = 0.014363410354048582;
        }
        else if (y==15) {
            ret_val = 0.00624999943900233;
        }
        else if (y==16) {
            ret_val = 2.870605395222859E-5;
        }
        else if (y==18) {
            ret_val = 0.9842064392690495;
        }
        else if (y==19) {
            ret_val = 0.892857023346361;
        }
        else if (y==20) {
            ret_val = 0.9842064392690495;
        }
	}
    else if (x==18) {
        if (y==0) {
            ret_val = 1.66054E-30;           
        }
        else if (y==1) {
            ret_val = 2.0000000000000002E-7;
        }
        else if (y==2) {
            ret_val = 6.479890999999999E-8;
        }
        else if (y==3) {
            ret_val = 1.0E-6;               
        }
        else if (y==4) {
            ret_val = 0.050802349999999996;
        }
        else if (y==5) {
            ret_val = 0.04535924;          
        }
        else if (y==6) {
            ret_val = 0.0010;              
        }
        else if (y==7) {
            ret_val = 0.00980665;          
        }
        else if (y==8) {
            ret_val = 9.999999999999999E-10;
        }
        else if (y==9) {
            ret_val = 2.8349519999999998E-5;
        }
        else if (y==10) {
            ret_val = 3.1103479999999997E-5;
        }
        else if (y==11) {
            ret_val = 1.555174E-6;            
        }
        else if (y==12) {
            ret_val = 4.5359237000000004E-4;
        }
        else if (y==13) {
            ret_val = 3.7324170000000004E-4;
        }
        else if (y==14) {
            ret_val = 0.0145939;           
        }
        else if (y==15) {
            ret_val = 0.00635029318;      
        }
        else if (y==16) {
            ret_val = 2.91667E-5;          
        }
        else if (y==17) {
            ret_val = 1.016047;             
        }
        else if (y==19) {
            ret_val = 0.9071847000000001;  
        }
        else if (y==20) {
            ret_val = 1.0;                      
        }
	}
    else if (x==19) {
        if (y==0) {
            ret_val = 1.8304321049506236E-30;
        }
        else if (y==1) {
            ret_val = 2.2046227190559983E-7;
        }
        else if (y==2) {
            ret_val = 7.142857457803245E-8;
        }
        else if (y==3) {
            ret_val = 1.102311359527999E-6;
        }
        else if (y==4) {
            ret_val = 0.05600000749571724;  
        }
        else if (y==5) {
            ret_val = 0.0500000055115568;  
        }
        else if (y==6) {
            ret_val = 0.001102311359527999;
        }
        else if (y==7) {
            ret_val = 0.010809981693915251;
        }
        else if (y==8) {
            ret_val = 1.1023113595279991E-9; 
        }
        else if (y==9) {
            ret_val = 3.12499979331662E-5;  
        }
        else if (y==10) {
            ret_val = 3.428571932485193E-5;  
        }
        else if (y==11) {
            ret_val = 1.7142859662425965E-6;
        }
        else if (y==12) {
            ret_val = 5.000000220462272E-4;  
        }
        else if (y==13) {
            ret_val = 4.1142856575954157E-4; 
        }
        else if (y==14) {
            ret_val = 0.016087021749815664;
        }
        else if (y==15) {
            ret_val = 0.007000000308647181;
        }
        else if (y==16) {
            ret_val = 3.215078472994529E-5;
        }
        else if (y==17) {
            ret_val = 1.1200001499143448;
        }
        else if (y==18) {
            ret_val = 1.102311359527999;
        }
        else if (y==20) {
            ret_val = 1.102311359527999;
        }
	}
   else if (x==20) {
        if (y==0) {
            ret_val = 1.66054E-30;
        }
        else if (y==1) {
            ret_val = 2.0000000000000002E-7;
        }
        else if (y==2) {
            ret_val = 6.479890999999999E-8;
        }
        else if (y==3) {
            ret_val = 1.0E-6;
        }
        else if (y==4) {
            ret_val = 0.050802349999999996;
        }
        else if (y==5) {
            ret_val = 0.04535924;
        }
        else if (y==6) {
            ret_val = 0.0010;
        }
        else if (y==7) {
            ret_val = 0.00980665;
        }
        else if (y==8) {
            ret_val = 9.999999999999999E-10;
        }
        else if (y==9) {
            ret_val = 2.8349519999999998E-5;
        }
        else if (y==10) {
            ret_val = 3.1103479999999997E-5;
        }
        else if (y==11) {
            ret_val = 1.555174E-6;
        }
        else if (y==12) {
            ret_val = 4.5359237000000004E-4;
        }
        else if (y==13) {
            ret_val = 3.7324170000000004E-4;
        }
        else if (y==14) {
            ret_val = 0.0145939;
        }
        else if (y==15) {
            ret_val = 0.00635029318;
        }
        else if (y==16) {
            ret_val = 2.91667E-5;
        }
        else if (y==17) {
            ret_val = 1.016047;
        }
        else if (y==18) {
            ret_val = 1.0;
        }
        else if (y==19) {
            ret_val = 0.9071847000000001;
        }
    }
	return ret_val;
 }
