/***************************************************************************
                          main_widget.h  -  description
                             -------------------
    begin                : Mon Mar 27 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAIN_WIDGET_H
#define MAIN_WIDGET_H

#include <qwidget.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapp.h>
#include <qdialog.h>
#include <qmessagebox.h>
#include <qstring.h>

#define VERSION "0.5"

/**
  *@author Jan Schaumann
  */

class main_widget : public QWidget  
{
		Q_OBJECT
		public slots:
			void quit();
			void choose(int);
			void convert(int);
			void calculate();
			void info();
			void explain();
			void colors();

			// shoe size functions
			void shoe_convert(int);

		public:
			main_widget(QWidget *parent=0, const char *name=0);
			~main_widget();

			QMessageBox *Info;
			QMessageBox *Explanation;
			QString *TheString;

			float factor;
			float result;
			bool temp;
			bool color;
			bool shoes;
			int temp1;
			int temp2;
			QPushButton *QPushButton_1;
			QPushButton *QPushButton_2;
			QPushButton *QPushButton_3;
			QPushButton *QPushButton_4;
			int num_of_boxes;

			bool EuropUK;
			bool EuropUSM;
			bool EuropUSF;
			bool UKEurop;
			bool UKUSM;
			bool UKUSF;
			bool USMEurop;
			bool USMUK;
			bool USMUSF;
			bool USFEurop;
			bool USFUK;
			bool USFUSM;

		protected:
			void initDialog();
			float acceleration(int, int);
			float angle(int, int);
			float angle_accel(int, int);
			float angle_vel(int, int);
			float area(int, int);
			float bits(int, int);
			float capacitance(int, int);
			float charge(int, int);
			float current(int, int);
			float energy(int, int);
			float force(int, int);
			float illuminance(int, int);
			float inductance(int, int);
			float length(int, int);
			float luminance(int, int);
			float mag_flux(int, int);
			float mass(int, int);
			float power(int, int);
			float pressure(int, int);
			void shoe_sizes();
			float si_prefixes(int, int);
			float spec_heat(int, int);
			float temperature(int, int, float);
			float therm_cond(int, int);
			float time(int, int);
			float torque(int, int);
			float velocity(int, int);
			float visc_dyn(int, int);
			float visc_kin(int, int);
			float voltage(int, int);
			float volume(int, int);
			int current();
	
			QLabel *QLabel_1;
			QLabel *QLabel_2;
			QLabel *QLabel_3;
			QLabel *QLabel_4;
			QLabel *QLabel_5;
			QLabel *QLabel_6;
			QLabel *redLabel1;
			QLabel *greenLabel1;
			QLabel *blueLabel1;
			QLabel *redLabel2;
			QLabel *greenLabel2;
			QLabel *blueLabel2;
	
			QComboBox *QComboBox_1;
			QLineEdit *QLineEdit_1;
			QLineEdit *QLineEdit_2;
			QLineEdit *QLineEdit_3;
			QLineEdit *HexEdit;
			QLineEdit *Red1;
			QLineEdit *Green1;
			QLineEdit *Blue1;
			QLineEdit *Red2;
			QLineEdit *Green2;
			QLineEdit *Blue2;
	
			QComboBox *QComboBox_2;
			QComboBox *QComboBox_3;
			QComboBox *QComboBox_4;
			QComboBox *QComboBox_5;
			QComboBox *QComboBox_6;
			QComboBox *QComboBox_7;
			QComboBox *QComboBox_8;
			QComboBox *QComboBox_9;
			QComboBox *QComboBox_10;
			QComboBox *QComboBox_11;
			QComboBox *QComboBox_12;
			QComboBox *QComboBox_13;
			QComboBox *QComboBox_14;
			QComboBox *QComboBox_15;
			QComboBox *QComboBox_16;
			QComboBox *QComboBox_17;
			QComboBox *QComboBox_18;
			QComboBox *QComboBox_19;
			QComboBox *QComboBox_20;
			QComboBox *QComboBox_21;
			QComboBox *QComboBox_22;
			QComboBox *QComboBox_23;
			QComboBox *QComboBox_24;
			QComboBox *QComboBox_25;
			QComboBox *QComboBox_26;
			QComboBox *QComboBox_27;
			QComboBox *QComboBox_28;
			QComboBox *QComboBox_29;
			QComboBox *QComboBox_30;
			QComboBox *QComboBox_31;
			QComboBox *QComboBox_32;
			QComboBox *QComboBox_33;
			QComboBox *QComboBox_34;
			QComboBox *QComboBox_35;
			QComboBox *QComboBox_36;
			QComboBox *QComboBox_37;
			QComboBox *QComboBox_38;
			QComboBox *QComboBox_39;
			QComboBox *QComboBox_40;
			QComboBox *QComboBox_41;
			QComboBox *QComboBox_42;
			QComboBox *QComboBox_43;
			QComboBox *QComboBox_44;
			QComboBox *QComboBox_45;
			QComboBox *QComboBox_46;
			QComboBox *QComboBox_47;
			QComboBox *QComboBox_48;
			QComboBox *QComboBox_49;
			QComboBox *QComboBox_50;
			QComboBox *QComboBox_51;
			QComboBox *QComboBox_52;
			QComboBox *QComboBox_53;
			QComboBox *QComboBox_54;
			QComboBox *QComboBox_55;
			QComboBox *QComboBox_56;
			QComboBox *QComboBox_57;
			QComboBox *QComboBox_58;
			QComboBox *QComboBox_59;
			QComboBox *QComboBox_60;
			QComboBox *QComboBox_61;
			QComboBox *QComboBox_62;
			QComboBox *QComboBox_63;
			QComboBox *QComboBox_64;
			QComboBox *QComboBox_65;
	
			QComboBox *all[64];
	
			// shoe sizes
			QComboBox *UKsizes;
			QComboBox *European;
	
};
	
#endif
