/***************************************************************************
	                       main_widget.cpp
                             -------------------
    begin                : Mon Mar 27 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "main_widget.h"

#include <stdlib.h>

main_widget::main_widget(QWidget *parent, const char *name) : QWidget(parent,name)
{
		factor = 1.0;
		initDialog();
		convert(0);

		connect(QPushButton_1, SIGNAL(clicked()), SLOT(quit()) );
		connect(QPushButton_2, SIGNAL(clicked()), SLOT(info()) );
		connect(QPushButton_3, SIGNAL(clicked()), SLOT(explain()) );
		connect(QPushButton_4, SIGNAL(clicked()), SLOT(colors()) );
		connect(QComboBox_1, SIGNAL(activated(int)), SLOT(choose(int)) );
		for (int j=0; j<=(num_of_boxes-2); j++) {
				connect(all[j], SIGNAL(activated(int)), SLOT(convert(int)) );
		}
		connect(QLineEdit_1, SIGNAL(textChanged(const QString &)), SLOT(calculate()) );

		// colors
		connect(HexEdit, SIGNAL(returnPressed()), SLOT(colors()) );
		connect(Red1, SIGNAL(returnPressed()), SLOT(colors()) );
		connect(Green1, SIGNAL(returnPressed()), SLOT(colors()) );
		connect(Blue1, SIGNAL(returnPressed()), SLOT(colors()) );

		// shoe sizes
		connect(UKsizes, SIGNAL(activated(int)), SLOT(shoe_convert(int)) );
		connect(European, SIGNAL(activated(int)), SLOT(shoe_convert(int)) );

}

main_widget::~main_widget(){
}

void main_widget::quit() {
	exit(0);
}

void main_widget::explain() {
	Explanation->information(0, "What's this?", *TheString);
}

void main_widget::info() {
	QMessageBox *Info = new QMessageBox();
	Info->about(0, "About KUnit " VERSION, "KUnit " VERSION " (c) Jan Schaumann\n"
						"This program is free software; you can\n"
						"redistribute it and/or modify it under the\n"
						"terms of the GNU Public License as\n"
						"published by the Free Software Foun-\n"
						"dation; either version 2 of the License,\n"
						"or (at your option) any later version.\n"
						"\nAvailable at:\n"
						"      http://www.netmeister.org\n"
						"\nPlease send bug-reports to:\n"
						"      jschauma@netmeister.org\n");

}

void main_widget::choose(int a) {
	temp = false;
	color = false;
	shoes = false;
	factor = 0.0;
	result = 0.0;
	for (int i=0; i<=(num_of_boxes-2); i++) {
		if (all[i]->isVisible())
			all[i]->hide();
	}
	a=2*a;
	all[a]->show();
	all[a+1]->show();
	convert(all[a]->currentItem());
	calculate();
}

void main_widget::convert(int selected) 
{
	temp = false;
	factor = 0.0;
	result = 0.0;
	int j;
	j=0;
	for (int i=0; i<=(num_of_boxes-2); i++) {
		if ((all[i]->currentItem()==selected) && (all[i]->isVisible()))
			j = i;
	}

	switch(QComboBox_1->currentItem()) {
	case 0:
		factor = acceleration(j, selected);
		break;
	case 1:
		factor = angle(j, selected);
		break;
	case 2:
		factor = angle_accel(j, selected);
		break;
	case 3:
		factor = angle_vel(j, selected);
		break;
	case 4:
		factor = area(j, selected);
		break;
	case 5:
		factor = bits(j, selected);
		break;
	case 6:
		factor = capacitance(j, selected);
		break;
	case 7:
		factor = charge(j, selected);
		break;
	case 8:
		color = true;
		temp1 = j;
		temp2 = selected;
		break;
	case 9:
		factor = current(j, selected);
		break;
	case 10:
		factor = energy(j, selected);
		break;
	case 11:
		factor = force(j, selected);		
		break;
	case 12:
		factor = illuminance(j, selected);		
		break;
	case 13:
		factor = inductance(j, selected);		
		break;
	case 14:
		factor = length(j, selected);		
		break;
	case 15:
		factor = luminance(j, selected);		
		break;
	case 16:
		factor = mag_flux(j, selected);		
		break;
	case 17:
		factor = mass(j, selected);		
		break;
	case 18:
		factor = power(j, selected);		
		break;
	case 19:
		factor = pressure(j, selected);		
		break;
	case 20:
		shoes = true;
		shoe_sizes();
		break;
	case 21:
		factor = si_prefixes(j, selected);		
		break;
	case 22:
		factor = spec_heat(j, selected);		
		break;
	case 23:
		temp = true;
		temp1 = j;
		temp2 = selected;
		break;
	case 24:
		factor = therm_cond(j, selected);		
		break;
	case 25:
		factor = time(j, selected);		
		break;
	case 26:
		factor = torque(j, selected);		
		break;
	case 27:
		factor = velocity(j, selected);		
		break;
	case 28:
		factor = visc_dyn(j, selected);		
		break;
	case 29:
		factor = visc_kin(j, selected);		
		break;
	case 30:
		factor = voltage(j, selected);		
		break;
	case 31:
		factor = volume(j, selected);		
		break;
	default:
		break;
	}
	calculate();	
	
}

int main_widget::current() {
	for (int i=0; i<=(num_of_boxes-2); i++) {
		if (all[i]->isVisible()) {
			return i;
		}
	}
	return 0;
}

void main_widget::calculate() {
//	int prec = 12;
	if (QComboBox_1->currentItem() == 23)
		temp = true;
	else
		temp = false;
		
	if (QComboBox_1->currentItem() == 8)
		color = true;
	else
		color = false;
		
	if (QComboBox_1->currentItem() == 20)
		shoes = true;
	else
		shoes = false;
	
	if (!(color)) {
		QLineEdit_1->show();
		Red1->hide();
		redLabel1->hide();
		Green1->hide();
		greenLabel1->hide();
		Blue1->hide();
		blueLabel1->hide();	
		QLineEdit_3->show();
		Red2->hide();
		redLabel2->hide();
		Green2->hide();
		greenLabel2->hide();
		Blue2->hide();
		blueLabel2->hide();
		QPushButton_4->hide();
		QLabel_5->show();
		QLineEdit_2->show();
	}
	
	if (!shoes) {
		if (UKsizes->isVisible())
			UKsizes->hide();
		if (European->isVisible())			
			European->hide();
		QLineEdit_1->show();
	}	
	
	QString input = QLineEdit_1->text();					
	if (temp) {
		float value = input.toFloat();
		result = temperature(temp1, temp2, value);
		QLineEdit_2->setText("--");
		QString *output = new QString;
		*output = output->setNum(result);
		QLineEdit_3->setText(*output);
	}
	if (shoes) {
		QLineEdit_1->hide();
		QLineEdit_2->setText("--");
	}
	if ((!temp)&&(!color)&&(!shoes)) {
		float value = input.toFloat();
		result = value*factor;
		input = input.setNum(factor);
		QLineEdit_2->setText(input);
		QString *output = new QString;
		*output = output->setNum(result);
		QLineEdit_3->setText(*output);
	}
	if (color) {
		int y;
		QLineEdit_1->hide();
		HexEdit->show();
		QLineEdit_2->hide();
		QLabel_5->hide();
		QPushButton_4->show();
		TheString = new QString("\"color\": a property depending on the relations of light to the eye,\n"
        				"by which individual and specific differences in the hues\n"
				        "and tints of objects are apprehended in vision;"
				        "\n\n\"Hexadecimal\" (or \"hex\"): Base 16.  A number representation\n"
   					"using the digits 0-9, with their usual meaning, plus the\n"
     					"letters A-F (or a-f) to represent hexadecimal digits (or\n"
     					"\"hexits\") with values of (decimal) 10 to 15.  The right-most\n"
					"digit counts ones, the next counts multiples of 16, then 16^2 = 256, etc."
					"\n\n\"RGB\": Red, Green, Blue.  The three colours of light which can be\n"
					"mixed to produce any other colour.  Coloured images are often\n"
     					"stored as a sequence of RGB triplets or as separate red, green\n"
     					"and blue overlays though this is not the only possible\n"
     					"representation (see CMYK and HSV).  These colours\n"
     					"correspond to the three \"guns\" in a colour cathode ray tube\n"
     					"and to the colour receptors in the human eye.\n"
     					"Often used as a synonym for colour, as in \"RGB monitor\" as\n"
     					"opposed to monochrome (black and white).");		
			
		if (temp1==16) {
			y=temp2;
			temp2 = all[temp1+1]->currentItem();
		}
		else
			y = all[temp1-1]->currentItem();
		
		if (temp2==0) {
  			QComboBox_19->setCurrentItem(1);
			HexEdit->hide();
			Red1->show();
			redLabel1->show();
			Green1->show();
			greenLabel1->show();
			Blue1->show();
			blueLabel1->show();
			QLineEdit_3->show();
			Red2->hide();
			redLabel2->hide();
			Green2->hide();
			greenLabel2->hide();
			Blue2->hide();
			blueLabel2->hide();
			colors();
		}
		else if (temp2==1) {
  			QComboBox_19->setCurrentItem(0);
			HexEdit->show();
			Red1->hide();
			redLabel1->hide();
			Green1->hide();
			greenLabel1->hide();
			Blue1->hide();
			blueLabel1->hide();
			QLineEdit_3->hide();
			Red2->show();
			redLabel2->show();
			Green2->show();
			greenLabel2->show();
			Blue2->show();
			blueLabel2->show();
		}
	}	
}
