/***************************************************************************
	                          main.cpp
                             -------------------
    begin                : Mon Mar 27 17:24:15 EST 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main_widget.h"

#include <iostream.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

int 
main(int argc, char **argv)
{
		u_int width = 450, height = 400;
		int xoff,yoff;
		int geom = 0;

		/*
		 * yes, I do want to use "getopt()" eventually, but I started out with
		 * only supporting one or two versions and now I'm too lazy to re-write
		 * the whole thing ;-)
		 */

		if ( (argc>3) ||
						// more than two commandline argument
						((argc==3) &&
						 ((strcmp(argv[1],"-geometry")!=0) &&
						  (strcmp(argv[1],"-title")!=0)) ) ||
						// only geometry and title can have more than one argument
						((argc==2) &&
						 ((strcmp(argv[1],"-geometry")!=0) &&
						  (strcmp(argv[1],"-v")!=0) &&
						  (strcmp(argv[1],"--version")!=0) &&
						  (strcmp(argv[1],"-iconic")!=0)) )
		   ) {
				cout << "KUnit " << VERSION << " - A KDE program to convert various units.\n";
				cout << "Usage: kunit [OPTION]\n";
				cout << "If called without an OPTION, the application is started normally.\n\n";
				cout << "KUnit currently supports one and only one of the following options:\n";
				cout << "\t-geometry geometry    set the geometry for kunit (see X(1))\n";
				cout << "\t-h, --help            print out this message and exit\n";
				cout << "\t-iconic               start KUnit iconified\n";
				cout << "\t-title \"title\"      specifies  the  title to be used for this window\n";
				cout << "\t-v, --version         print out version number and exit\n";
				cout << "\nFor more information about KUnit, please see /usr/doc/kunit-" << VERSION << "/README";
				cout << "/usr/share/doc/HTML/en/kunit/index.html, or http://www.netmeister.org/kunit/index.html\n";
				exit(0);
		}

		if (argv[1])
		{

				if ((strcmp(argv[1],"-v")==0)||(strcmp(argv[1],"--version")==0)) 
				{
						cout << "KUnit Version " << VERSION << "\n";
						exit(0);
				}

				if (strcmp(argv[1],"-geometry")==0) 
				{
						bool error = false;

						if (!argv[2])
								error = true;

						geom = XParseGeometry(argv[2],&xoff,&yoff,&width,&height);

						if ( (geom==0) ||
										// any error on input
										(geom==1) ||
										// only +x value
										(geom==4) ||
										// only width
										(geom==13) ||
										// widthxheight+xoff
										(geom==17) ||
										// only -x value
										(geom==29)
										// widthxheight-xoff
						   )
								error = true;

						if (error) 
						{
								cout << "Invalid value for geometry. Please use [WIDTHxHEIGHT][+XOFF+YOFF].\n";
								cout << "Minimum WIDTH is 450.\nMinimum HEIGHT is 400.\n";
								cout << "See X(1) for details.\n";
								exit(0);
						}

						if (width<450)
								width = 450;
						if (height<400)
								height = 400;

				}
		}	
		
		QApplication a(argc, argv);
		int dh = QApplication::desktop()->height();
		int dw = QApplication::desktop()->width();

		
		main_widget *Main = new main_widget();
		if (width==0) 
		{
				width = 450;
				height = 400;
		}

		Main->resize(width,height);
		a.setMainWidget(Main);

		if (geom==3) // +xoff+yoff
				Main->setGeometry(xoff,yoff,450,400);
		else if (geom==35) // +xoff-yoff
				Main->setGeometry(xoff,dh-400-yoff,450,400);
		else if (geom==19) // -xoff+yoff
				Main->setGeometry(dw-450-xoff,yoff,450,400);
		else if (geom==51)  // -xoff-yoff
				Main->setGeometry(dw-450-xoff,dh-400-yoff,450,400);
		else if (geom==15)  // widthxheight+xoff+yoff
				Main->setGeometry(xoff,yoff,width,height);
		else if (geom==47)  // widthxheight+xoff-yoff
				Main->setGeometry(xoff,dh-height-yoff,width,height);
		else if (geom==31)  // widthxheight-xoff+yoff
				Main->setGeometry(dw-width-xoff,yoff,width,height);
		else if (geom==63) // widthxheight-xoff-yoff
				Main->setGeometry(dw-width-xoff,dh-height-yoff,width,height);


		Main->show();

		if (argv[1])
		{
				if (strcmp(argv[1],"-iconic")==0)
						Main->iconify();
		}
		return a.exec();
}
