/***************************************************************************
                                 mag_flux.cpp
                             -------------------
    begin                : Sun Apr 9 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "main_widget.h"

 float main_widget::mag_flux(int box, int x) {
	TheString = new QString("\"magnetic flux\": a) a measure of the strength of a magnetic field over a given area\n"
       				"b): the lines of force surrounding a permanent magnet or a moving charged particle");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==32) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
		if (x==0) {
			TheString->append("\n\n\"maxwell\": a cgs unit of magnetic flux equal to the flux perpendicular\n"
			           	  "to an area of 1 square centimeter in a magnetic field of 1 gauss");
		}
		else if (x==2) {
			TheString->append("\n\n\"weber\": a unit of magnetic flux equal to 100,000,000 maxwells");
		}
	}
	else if (y==0) {
		TheString->append("\n\n\"maxwell\": a cgs unit of magnetic flux equal to the flux perpendicular\n"
		           	  "to an area of 1 square centimeter in a magnetic field of 1 gauss");
	}
	else if (y==2) {
		TheString->append("\n\n\"weber\": a unit of magnetic flux equal to 100,000,000 maxwells");
	}
	
	if (x!=y) {
		if (x==0) {
			TheString->append("\n\n\"maxwell\": a cgs unit of magnetic flux equal to the flux perpendicular\n"
			           	  "to an area of 1 square centimeter in a magnetic field of 1 gauss");
		}
		else if (x==2) {
			TheString->append("\n\n\"weber\": a unit of magnetic flux equal to 100,000,000 maxwells");
		}
	}
	
	if (x==0) {
		if (y==1) {
			ret_val = 12.566370000000001;
		}
		else if (y==2) {
			ret_val = 1.0E8;
		}
	}
	else if (x==1) {
		if (y==0) {
			ret_val = 0.07957747543642277;
		}
		if (y==2) {
			ret_val = 7957747.543642277;
		}
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 1.0E-8;
		}
		else if (y==1) {
			ret_val = 1.256637E-7;
		}
	}
	return ret_val;
 }
