/***************************************************************************
                                 luminance.cpp
                             -------------------
    begin                : Sun Apr 9 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "main_widget.h"

 float main_widget::luminance(int box, int x) {
	TheString = new QString("\"luminance\": the luminous intensity of a surface in a given direction\n"
			        "per unit of projected area");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==30) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
		if (x==2) {
			TheString->append("\n\n\"footlambert\": a former luminance unit equal to one lumen per square foot");
		}
		else if (x==3) {
			TheString->append("\n\n\"lambert\": a cgs unit of illumination equal to the brightness of a\n"
			         	  "perfectly diffusing surface that emits or reflects one lumen per square centimeter");
		}
	}
	else if (y==2) {
		TheString->append("\n\n\"footlambert\": a former luminance unit equal to one lumen per square foot");
	}
	else if (y==3) {
		TheString->append("\n\n\"lambert\": a cgs unit of illumination equal to the brightness of a\n"
		         	  "perfectly diffusing surface that emits or reflects one lumen per square centimeter");
	}
	if (x!=y) {
		if (x==2) {
			TheString->append("\n\n\"footlambert\": a former luminance unit equal to one lumen per square foot");
		}
		else if (x==3) {
			TheString->append("\n\n\"lambert\": a cgs unit of illumination equal to the brightness of a\n"
			         	  "perfectly diffusing surface that emits or reflects one lumen per square centimeter");
		}
	}	
	
	if (x==0) {
		if (y==1) {
			ret_val = 6.45160041625726E-4;
		}
		else if (y==2) {
			ret_val = 0.002210485399060518;
		}
		else if (y==3) {
			ret_val = 2.0536082833388067;
		}
	}
	else if (x==1) {
		if (y==0) {
			ret_val = 1550.003;
		}
		if (y==2) {
			ret_val = 3.426259;
		}
		else if (y==3) {
			ret_val = 3183.099;
		}
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 452.38932608422186;
		}
		else if (y==1) {
			ret_val = 0.29186351644753067;
		}
		else if (y==3) {
			ret_val = 929.0304673406185;
		}
	}
	else if (x==3) {
		if (y==0) {
			ret_val = 0.4869477826482933;
		}
		else if (y==1) {
			ret_val = 3.141592517229279E-4;
		}
		else if (y==2) {
			ret_val = 0.001076390963648947;
		}
	}
	return ret_val;
 }
