/***************************************************************************
                                 length.cpp
                             -------------------
    begin                : Sun Apr 9 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "main_widget.h"

 float main_widget::length(int box, int x) {
	TheString= new QString("\"length\": distance or extent in space");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==28) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
		if (x==0) {
			TheString->append("\n\n\"angstrom\": a metric unit of length equal to one\n"
				  "ten billionth of a meter (or 0.0001 micron); used to specify\n"
				  "wavelengths of electromagnetic radiation");
		}
		else if (x==1) {
			TheString->append("\n\n\"astronomical unit\":  a unit of length used for distances\n"
				  "within the solar system; equal to the mean distance between the Earth\n"
				  "and the Sun (approximately 93 million miles or 150 million kilometers)");
		}
		else if (x==2) {
			TheString->append("\n\n\"centimeter\": a metric unit of length equal to one hundredth of a meter");
		}
		else if (x==3) {
			TheString->append("\n\n\"chain\": a unit of length equal to 66 feet (20 meters)");
		}
		else if (x==4) {
			TheString->append("\n\n\"fanthom\": a measure of length, containing six feet; the space to\n"
        				  "which a man can extend his arms; -- used chiefly in measuring cables, cordage,\n"
        				  "and the depth of navigable water by soundings");
		}
		else if (x==5) {
			TheString->append("\n\n\"fermi\": a metric unit of length equal to one quadrillionth of a meter");
		}
		else if (x==6) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
		}
		else if (x==7) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
		}
		else if (x==8) {
			TheString->append("\n\n\"inch\": measure of length, the twelfth part of a foot, commonly\n"
			        	  "subdivided into halves, quarters, eights, sixteenths, etc., as among mechanics.\n"
			        	  "It was also formerly divided into twelve parts, called lines, and originally into three\n"
			        	  "parts, called barleycorns, its length supposed to have been determined from three grains\n"
			        	  "of barley placed end to end lengthwise. It is also sometimes called a prime ('),\n"
        				  "composed of twelve seconds (''), as in the duodecimal system of arithmetic");
		}
		else if (x==9) {
			TheString->append("\n\n\"kilometer\": a measure of length, being a thousand meters.\n"
					  "It is equal to 3,280.8 feet, or 62137 of a mile");
		}
		else if (x==10) {
			TheString->append("\n\n\"light year\": the distance that light travels in a vacuum in 1 year; 5.88\n"
           				  "trillion miles or 9.46 trillion kilometers");
		}
		else if (x==11) {
			TheString->append("\n\n\"meter\": A measure of length, equal to 39.37 English inches, the\n"
        				  "standard of linear measure in the metric system of weights and measures.\n"
        				  "It was intended to be, and is very nearly, the ten millionth part of the\n"
        				  "distance from the equator to the north pole, as ascertained by actual\n"
        				  "measurement of an arc of a meridian");
		}
		else if (x==13) {
			TheString->append("\n\n\"micron\": a metric unit of length equal to one millionth of a meter");
		}
		else if ((x==14)||(x==16)) {
			TheString->append("\n\n\"nautical mile\": one sixtieth of a degree of a great circle of the earth, or 6080.27 feet");
		}
		else if ((x==15)||(x==17)) {
			TheString->append("\n\n\"mile\": a certain measure of distance, being equivalent in England\n"
     					  "and the United States to 320 poles or rods, or 5,280 feet.\n"
     					  "The distance called a mile varies greatly in different countries. Its length\n"
     					  "in yards is, in Norway, 12,182; in Brunswick, 11,816; in Sweden, 11,660; in Hungary,\n"
           				  "9,139; in Switzerland, 8,548; in Austria, 8,297; in Prussia, 8,238; in Poland, 8,100;\n"
           				  "in Italy, 2,025; in  England and the United States, 1,760; in Spain, 1,552; in the Netherlands, 1,094.");
		}
		else if (x==18) {
			TheString->append("\n\n\"milimeter\": a metric unit of length equal to one thousandth of a meter");
		}
		else if (x==19) {
			TheString->append("\n\n\"mil\": a unit of length equal to one thousandth of an inch; used to specify thickness");
		}
		else if (x==20) {
			TheString->append("\n\n\"parsec\": a unit of astronomical length based on the distance from\n"
           				  "Earth at which stellar parallax is 1 second of arc; equivalent to 3.262 light years");
		}
		else if (x==21) {
			TheString->append("\n\n\"pica\": a linear unit (1/6 inch) used in printing");
		}
		else if (x==22) {
			TheString->append("\n\n\"point\": a linear unit used to measure the size of type; approximately 1/72 inch");
		}
		else if (x==23) {
			TheString->append("\n\n\"rod\": (British) a linear measure of 16.5 feet");
		}
		else if (x==24) {
			TheString->append("\n\n\"yard\": a unit of length equal to 3 feet; defined as 91.44 centimeters;\n"
					  "originally taken to be the average length of a stride");
		}
	}
	
	// determine the string
	else if (y==0) {
		TheString->append("\n\n\"angstrom\": a metric unit of length equal to one\n"
				  "ten billionth of a meter (or 0.0001 micron); used to specify\n"
				  "wavelengths of electromagnetic radiation");
	}
	else if (y==1) {
		TheString->append("\n\n\"astronomical unit\":  a unit of length used for distances\n"
				  "within the solar system; equal to the mean distance between the Earth\n"
				  "and the Sun (approximately 93 million miles or 150 million kilometers)");
	}
	else if (y==2) {
			TheString->append("\n\n\"centimeter\": a metric unit of length equal to one hundredth of a meter");
	}
	else if (y==3) {
			TheString->append("\n\n\"chain\": a unit of length equal to 66 feet (20 meters)");
	}
	else if (y==4) {
			TheString->append("\n\n\"fanthom\": a measure of length, containing six feet; the space to\n"
        				  "which a man can extend his arms; -- used chiefly in measuring cables, cordage,\n"
        				  "and the depth of navigable water by soundings");
	}
	else if (y==5) {
			TheString->append("\n\n\"fermi\": a metric unit of length equal to one quadrillionth of a meter");
	}
	else if (y==6) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
	}
	else if (y==7) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
	}
	else if (y==8) {
			TheString->append("\n\n\"inch\": measure of length, the twelfth part of a foot, commonly\n"
			        	  "subdivided into halves, quarters, eights, sixteenths, etc., as among mechanics.\n"
			        	  "It was also formerly divided into twelve parts, called lines, and originally into three\n"
			        	  "parts, called barleycorns, its length supposed to have been determined from three grains\n"
			        	  "of barley placed end to end lengthwise. It is also sometimes called a prime ('),\n"
        				  "composed of twelve seconds (''), as in the duodecimal system of arithmetic");
	}
	else if (y==9) {
			TheString->append("\n\n\"kilometer\": a measure of length, being a thousand meters.\n"
					  "It is equal to 3,280.8 feet, or 62137 of a mile");
	}
	else if (y==10) {
			TheString->append("\n\n\"light year\": the distance that light travels in a vacuum in 1 year; 5.88\n"
           				  "trillion miles or 9.46 trillion kilometers");
	}
	else if (y==11) {
			TheString->append("\n\n\"meter\": A measure of length, equal to 39.37 English inches, the\n"
        				  "standard of linear measure in the metric system of weights and measures.\n"
        				  "It was intended to be, and is very nearly, the ten millionth part of the\n"
        				  "distance from the equator to the north pole, as ascertained by actual\n"
        				  "measurement of an arc of a meridian");
	}
	else if (y==13) {
			TheString->append("\n\n\"micron\": a metric unit of length equal to one millionth of a meter");
	}
	else if ((y==14)||(y==16)) {
			TheString->append("\n\n\"nautical mile\": one sixtieth of a degree of a great circle of the earth, or 6080.27 feet");
	}
	else if ((y==15)||(y==17)) {
			TheString->append("\n\n\"mile\": a certain measure of distance, being equivalent in England\n"
     					  "and the United States to 320 poles or rods, or 5,280 feet.\n"
     					  "The distance called a mile varies greatly in different countries. Its length\n"
     					  "in yards is, in Norway, 12,182; in Brunswick, 11,816; in Sweden, 11,660; in Hungary,\n"
           				  "9,139; in Switzerland, 8,548; in Austria, 8,297; in Prussia, 8,238; in Poland, 8,100;\n"
           				  "in Italy, 2,025; in  England and the United States, 1,760; in Spain, 1,552; in the Netherlands, 1,094.");
	}
	else if (y==18) {
			TheString->append("\n\n\"milimeter\": a metric unit of length equal to one thousandth of a meter");
	}
	else if (y==19) {
			TheString->append("\n\n\"mil\": a unit of length equal to one thousandth of an inch; used to specify thickness");
	}
	else if (y==20) {
			TheString->append("\n\n\"parsec\": a unit of astronomical length based on the distance from\n"
           				  "Earth at which stellar parallax is 1 second of arc; equivalent to 3.262 light years");
	}
	else if (y==21) {
			TheString->append("\n\n\"pica\": a linear unit (1/6 inch) used in printing");
	}
	else if (y==22) {
			TheString->append("\n\n\"point\": a linear unit used to measure the size of type; approximately 1/72 inch");
	}
	else if (y==23) {
			TheString->append("\n\n\"rod\": (British) a linear measure of 16.5 feet");
	}
	else if (y==24) {
			TheString->append("\n\n\"yard\": a unit of length equal to 3 feet; defined as 91.44 centimeters;\n"
					  "originally taken to be the average length of a stride");
	}

	if (x!=y) {
		if (x==0) {
			TheString->append("\n\n\"angstrom\": a metric unit of length equal to one\n"
				  "ten billionth of a meter (or 0.0001 micron); used to specify\n"
				  "wavelengths of electromagnetic radiation");
		}
		else if (x==1) {
			TheString->append("\n\n\"astronomical unit\":  a unit of length used for distances\n"
				  "within the solar system; equal to the mean distance between the Earth\n"
				  "and the Sun (approximately 93 million miles or 150 million kilometers)");
		}
		else if (x==2) {
			TheString->append("\n\n\"centimeter\": a metric unit of length equal to one hundredth of a meter");
		}
		else if (x==3) {
			TheString->append("\n\n\"chain\": a unit of length equal to 66 feet (20 meters)");
		}
		else if (x==4) {
			TheString->append("\n\n\"fanthom\": a measure of length, containing six feet; the space to\n"
        				  "which a man can extend his arms; -- used chiefly in measuring cables, cordage,\n"
        				  "and the depth of navigable water by soundings");
		}
		else if (x==5) {
			TheString->append("\n\n\"fermi\": a metric unit of length equal to one quadrillionth of a meter");
		}
		else if (x==6) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
		}
		else if (x==7) {
			TheString->append("\n\n\"foot\": a measure of length equivalent to twelve inches; one third of a yard");
		}
		else if (x==8) {
			TheString->append("\n\n\"inch\": measure of length, the twelfth part of a foot, commonly\n"
			        	  "subdivided into halves, quarters, eights, sixteenths, etc., as among mechanics.\n"
			        	  "It was also formerly divided into twelve parts, called lines, and originally into three\n"
			        	  "parts, called barleycorns, its length supposed to have been determined from three grains\n"
			        	  "of barley placed end to end lengthwise. It is also sometimes called a prime ('),\n"
        				  "composed of twelve seconds (''), as in the duodecimal system of arithmetic");
		}
		else if (x==9) {
			TheString->append("\n\n\"kilometer\": a measure of length, being a thousand meters.\n"
					  "It is equal to 3,280.8 feet, or 62137 of a mile");
		}
		else if (x==10) {
			TheString->append("\n\n\"light year\": the distance that light travels in a vacuum in 1 year; 5.88\n"
           				  "trillion miles or 9.46 trillion kilometers");
		}
		else if (x==11) {
			TheString->append("\n\n\"meter\": A measure of length, equal to 39.37 English inches, the\n"
        				  "standard of linear measure in the metric system of weights and measures.\n"
        				  "It was intended to be, and is very nearly, the ten millionth part of the\n"
        				  "distance from the equator to the north pole, as ascertained by actual\n"
        				  "measurement of an arc of a meridian");
		}
		else if (x==13) {
			TheString->append("\n\n\"micron\": a metric unit of length equal to one millionth of a meter");
		}
		else if ((x==14)||(x==16)) {
			TheString->append("\n\n\"nautical mile\": one sixtieth of a degree of a great circle of the earth, or 6080.27 feet");
		}
		else if ((x==15)||(x==17)) {
			TheString->append("\n\n\"mile\": a certain measure of distance, being equivalent in England\n"
     					  "and the United States to 320 poles or rods, or 5,280 feet.\n"
     					  "The distance called a mile varies greatly in different countries. Its length\n"
     					  "in yards is, in Norway, 12,182; in Brunswick, 11,816; in Sweden, 11,660; in Hungary,\n"
           				  "9,139; in Switzerland, 8,548; in Austria, 8,297; in Prussia, 8,238; in Poland, 8,100;\n"
           				  "in Italy, 2,025; in  England and the United States, 1,760; in Spain, 1,552; in the Netherlands, 1,094.");
		}
		else if (x==18) {
			TheString->append("\n\n\"milimeter\": a metric unit of length equal to one thousandth of a meter");
		}
		else if (x==19) {
			TheString->append("\n\n\"mil\": a unit of length equal to one thousandth of an inch; used to specify thickness");
		}
		else if (x==20) {
			TheString->append("\n\n\"parsec\": a unit of astronomical length based on the distance from\n"
           				  "Earth at which stellar parallax is 1 second of arc; equivalent to 3.262 light years");
		}
		else if (x==21) {
			TheString->append("\n\n\"pica\": a linear unit (1/6 inch) used in printing");
		}
		else if (x==22) {
			TheString->append("\n\n\"point\": a linear unit used to measure the size of type; approximately 1/72 inch");
		}
		else if (x==23) {
			TheString->append("\n\n\"rod\": (British) a linear measure of 16.5 feet");
		}
		else if (x==24) {
			TheString->append("\n\n\"yard\": a unit of length equal to 3 feet; defined as 91.44 centimeters;\n"
					  "originally taken to be the average length of a stride");
		}	
	}
		
	// determine the factor
	if (x==0) {
		if (y==1) {
			ret_val = 1.495979E21;
		}
		else if (y==2) {
			ret_val = 1.0E8;
		}
		else if (y==3) {
			ret_val = 2.011684E11;
		}
		else if (y==4) {
			ret_val = 1.828804E10;
		}
		else if (y==5) {
			ret_val = 1.0E-5;
		}
		else if (y==6) {
			ret_val = 3.048E9;
		}
	        else if (y==7) {
        	    ret_val = 3.0480059999999995E9;
	        }
        	else if (y==8) {
	            ret_val = 2.5399999999999997E8;
        	}
	        else if (y==9) {
        	    ret_val = 1.0E13;
	        }
        	else if (y==10) {
	            ret_val = 9.46055E25;
        	}
	        else if (y==11) {
        	    ret_val = 1.0E10;
	        }
        	else if (y==12) {
	            ret_val = 253.99999999999997;
        	}
	        else if (y==13) {
        	    ret_val = 10000.0;
	        }
        	else if ((y==14)||(y==16)) {
	            ret_val = 1.852E13;
        	}
	        else if (y==15) {
        	    ret_val = 1.609344E13;
	        }
	        else if (y==17) {
        	    ret_val =  1.609347E13;
	        }
        	else if (y==18) {
	            ret_val =  1.0E7;
        	}
        	else if (y==19) {
	            ret_val =  254000.0;
        	}
        	else if (y==20) {
	            ret_val =  3.085678E26;
        	}
	        else if (y==21) {
        	    ret_val =  4.217518E7;
	        }
        	else if (y==22) {
	            ret_val =  3514597.9999999995;
        	}
        	else if (y==23) {
	            ret_val =  5.02921E10;
        	}
        	else if (y==24) {
	            ret_val =  9.144E9;
        	}
	}
	else if (x==1) {
		if (y==0) {
			ret_val = 6.684585813036146E-22;
		}
		else if (y==2) {
			ret_val = 6.684585813036146E-14;
		}
		else if (y==3) {
			ret_val = 1.3447274326711806E-10;
		}
		else if (y==4) {
			ret_val = 1.2224797273223756E-11;
		}
		else if (y==5) {
			ret_val = 6.684585813036146E-27;
		}
		else if (y==6) {
			ret_val = 2.037461755813417E-12;
		}
	        else if (y==7) {
        	    ret_val = 2.0374657665649047E-12;
	        }       	
        	else if (y==8) {
	            ret_val = 1.697884796511181E-13;
        	}
	        else if (y==9) {
        	    ret_val = 6.684585813036146E-9;
	        }
        	else if (y==10) {
	            ret_val = 63239.85831351911;
        	}
	        else if (y==11) {
        	    ret_val = 6.684585813036146E-12;
	        }
        	else if (y==12) {
	            ret_val = 1.697884796511181E-19;
        	}
	        else if (y==13) {
        	    ret_val = 6.684585813036145E-18;
	        }
        	else if ((y==14)||(y==16)) {
	            ret_val = 1.2379852925742941E-8;
        	}
	        else if (y==15) {
        	    ret_val =  1.0757798070694843E-8;
	        }
	        else if (y==17) {
        	    ret_val = 1.0757818124452282E-8;
	        }
        	else if (y==18) {
	            ret_val = 6.684585813036146E-15;
        	}
        	else if (y==19) {
	            ret_val = 1.697884796511181E-16;
        	}
	        else if (y==20) {
        	    ret_val =  206264.79382397747;
	        }
        	else if (y==21) {
	            ret_val =  2.8192360989024577E-14;
        	}
	        else if (y==22) {
        	    ret_val = 2.349363192932521E-15;
	        }
        	else if (y==23) {
	            ret_val = 3.3618185816779516E-11;
        	}
        	else if (y==24) {
	            ret_val = 6.112385267440251E-12;
        	}
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 1.0E-8;
		}
		else if (y==1) {
			ret_val = 1.495979E13;
		}
		else if (y==3) {
			ret_val = 2011.684;
		}
		else if (y==4) {
			ret_val = 182.8804;
		}
		else if (y==5) {
			ret_val = 1.0E-13;
		}
		else if (y==6) {
			ret_val = 30.48;
		}
        	else if (y==7) {
	            ret_val = 30.480059999999998;
        	}
	        else if (y==8) {
        	    ret_val = 2.54;
	        }
        	else if (y==9) {
	            ret_val = 100000.0;
        	}
	        else if (y==10) {
        	    ret_val = 9.46055E17;
	        }
        	else if (y==11) {
	            ret_val = 100.0;
        	}
	        else if (y==12) {
        	    ret_val = 2.54E-6;
	        }
        	else if (y==13) {
	            ret_val = 9.999999999999999E-5;
        	}
	        else if ((y==14)||(y==16)) {
        	    ret_val = 185200.0;
	        }
        	else if (y==15) {
	            ret_val = 160934.4;
        	}
        	else if (y==17) {
	            ret_val = 160934.69999999998;
        	}
	        else if (y==18) {
        	    ret_val = 0.1;
	        }
        	else if (y==19) {
	            ret_val = 0.00254;
        	}
	        else if (y==20) {
        	    ret_val = 3.085678E18;
	        }
        	else if (y==21) {
	            ret_val = 0.4217518;
        	}
	        else if (y==22) {
        	    ret_val = 0.03514598;
	        }
        	else if (y==23) {
	            ret_val = 502.921;
        	}
	        else if (y==24) {
        	    ret_val = 91.44;
	        }
	}
	else if (x==3) {
		if (y==0) {
			ret_val = 4.970959653703067E-12;
		}
		else if (y==1) {
			ret_val = 7.43645125178706E9;
		}
		else if (y==2) {
			ret_val = 4.970959653703067E-4;
		}
		else if (y==4) {
			ret_val = 0.09090910898530784;
		}
		else if (y==5) {
			ret_val = 4.9709596537030673E-17;
		}
		else if (y==6) {
			ret_val = 0.015151485024486948;
		}
	        else if (y==7) {
        	    ret_val = 0.015151514850244869;
	        }       	
        	else if (y==8) {
	            ret_val = 0.001262623752040579;
        	}
	        else if (y==9) {
        	    ret_val = 49.70959653703067;
	        }
        	else if (y==10) {
	            ret_val = 4.702801235184055E14;
        	}
	        else if (y==11) {
        	    ret_val = 0.049709596537030665;
	        }
        	else if (y==12) {
	            ret_val = 1.262623752040579E-9;
        	}
	        else if (y==13) {
        	    ret_val = 4.9709596537030664E-8;
	        }
        	else if ((y==14)||(y==16)) {
	            ret_val = 92.0621727865808;
        	}
	        else if (y==15) {
        	    ret_val = 79.99984092929108;
	        }
	        else if (y==17) {
        	    ret_val =  79.9999900580807;
	        }
        	 else if (y==18) {
	            ret_val = 4.970959653703067E-5;
        	}
	        else if (y==19) {
        	    ret_val = 1.262623752040579E-6;
	        }
	        else if (y==20) {
        	    ret_val =  1.5338780842319172E15;
	        }
        	 else if (y==21) {
	            ret_val = 2.096511181676645E-4;
        	}
        	 else if (y==22) {
	            ret_val = 1.747092485698549E-5;
        	}
        	 else if (y==23) {
	            ret_val = 0.25;
        	}
        	 else if (y==24) {
	            ret_val = 0.04545445507346084;
        	}
	}
	else if (x==4) {
		if (y==0) {
			ret_val = 5.4680545318142346E-11;
		}
		else if (y==1) {
			ret_val = 8.180094750448927E10;
		}
		else if (y==2) {
			ret_val = 0.005468054531814235;
		}
		else if (y==3) {
			ret_val = 10.999997812778187;
		}
		else if (y==5) {
			ret_val = 5.468054531814235E-16;
		}
		else if (y==6) {
			ret_val = 0.16666630212969788;
		}
	        else if (y==7) {
        	    ret_val = 0.16666663021296976;
	        }       	
        	else if (y==8) {
	            ret_val = 0.013888858510808155;
        	}
	        else if (y==9) {
        	    ret_val = 546.8054531814234;
	        }
        	else if (y==10) {
	            ret_val = 5.173080330095516E15;
        	}
	        else if (y==11) {
        	    ret_val = 0.5468054531814235;
	        }
        	 else if (y==12) {
	            ret_val = 1.3888858510808156E-8;
        	}
	        else if (y==13) {
        	    ret_val = 5.468054531814234E-7;
	        }
        	else if ((y==14)||(y==16)) {
	            ret_val = 1012.6836992919963;
        	}
	        else if (y==15) {
        	    ret_val = 879.9980752448048;
	        }
        	 else if (y==17) {
	            ret_val = 879.9997156611643;
        	}
	        else if (y==18) {
        	    ret_val = 5.468054531814235E-4;
	        }
        	else if (y==19) {
	            ret_val = 1.3888858510808156E-5;
        	}
        	 else if (y==20) {
	            ret_val = 1.6872655571619484E16;
        	}
	        else if (y==21) {
        	    ret_val = 0.0023061618412908106;
	        }
        	else if (y==22) {
	            ret_val = 1.9218013521405243E-4;
        	}
	        else if (y==23) {
        	    ret_val = 2.7499994531945466;
	        }
        	else if (y==24) {
	            ret_val = 0.4999989063890936;
        	}
	}
	else if (x==5) {
		if (y==0) {
			ret_val = 100000.0;
		}
		else if (y==1) {
			ret_val = 1.4959789999999999E26;
		}
		else if (y==2) {
			ret_val = 1.0E13;
		}
		else if (y==3) {
			ret_val = 2.011684E16;
		}
		else if (y==4) {
			ret_val = 1.828804E15;
		}
		else if (y==6) {
			ret_val = 3.048E14;
		}
        	else if (y==7) {
	            ret_val = 3.0480059999999994E14;
        	}
	        else if (y==8) {
        	    ret_val = 2.5399999999999996E13;
	        }
        	else if (y==9) {
	            ret_val = 9.9999999999999987E17;
        	}
	        else if (y==10) {
        	    ret_val = 9.460549999999999E30;
	        }
        	else if (y==11) {
	            ret_val = 9.999999999999999E14;
        	}
	        else if (y==12) {
	       	    ret_val = 2.5399999999999996E7;
        	}
	        else if (y==13) {
        	    ret_val = 9.999999999999999E8;
	        }
        	else if ((y==14)||(y==16)) {
	            ret_val = 1.85199999999999974E18;
        	}
	        else if (y==15) {
        	    ret_val = 1.609344E18;
	        }
        	else if (y==17) {
	            ret_val = 1.60934699999999974E18;
        	}
	        else if (y==18) {
        	    ret_val = 1.0E12;
	        }
        	else if (y==19) {
	            ret_val = 2.54E10;
        	}
	        else if (y==20) {
        	    ret_val = 3.0856779999999997E31;
	        }
        	else if (y==21) {
	            ret_val = 4.2175179999999995E12;
        	}
	        else if (y==22) {
        	    ret_val = 3.5145979999999994E11;
	        }
        	else if (y==23) {
	            ret_val = 5.02921E15;
        	}
        	else if (y==24) {
	            ret_val = 9.143999999999999E14;
        	}
	}
	else if (x==6) {
		if (y==0) {
			ret_val = 3.280839895013123E-10;
		}
		else if (y==1) {
			ret_val = 4.908067585301837E11;
		}
		else if (y==2) {
			ret_val = 0.03280839895013123;
		}
		else if (y==3) {
			ret_val = 66.0001312335958;
		}
		else if (y==4) {
			ret_val = 6.00001312335958;
		}
		else if (y==5) {
			ret_val = 3.2808398950131234E-15;
		}
		else if (y==7) {
			ret_val = 1.000001968503937;
		}
		else if (y==8) {
			ret_val = 0.08333333333333333;
		}
		else if (y==9) {
			ret_val = 3280.839895013123;
		}
		else if (y==10) {
			ret_val = 3.1038549868766404E16;
		}
		else if (y==11) {
			ret_val = 3.280839895013123;
		}
		else if (y==12) {
			ret_val = 8.333333333333333E-8;
		}
		else if (y==13) {
			ret_val = 3.280839895013123E-6;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 6076.115485564304;
		}
		else if (y==15) {
			ret_val = 5280.0;
		}
		else if (y==17) {
			ret_val = 5280.009842519685;
		}
		else if (y==18) {
			ret_val = 0.0032808398950131233;
		}
		else if (y==19) {
			ret_val = 8.333333333333333E-5;
		}
		else if (y==20) {
			ret_val = 1.0123615485564304E17;
		}
		else if (y==21) {
			ret_val = 0.013837001312335957;
		}
		else if (y==22) {
			ret_val = 0.0011530833333333332;
		}
		else if (y==23) {
			ret_val = 16.50003280839895;
		}
		else if (y==24) {
			ret_val = 3.0;
		}
	}
	else if (x==7) {
		if (y==0) {
			ret_val = 3.280833436679587E-10;
		}
		else if (y==1) {
			ret_val = 4.9080579237704913E11;
		}
		else if (y==2) {
			ret_val = 0.032808334366795866;
		}
		else if (y==3) {
			ret_val = 66.00000131233338;
		}
		else if (y==4) {
			ret_val = 6.000001312333375;
		}
		else if (y==5) {
			ret_val = 3.280833436679587E-15;
		}
		else if (y==6) {
			ret_val = 0.9999980314999382;
		}
		else if (y==8) {
			ret_val = 0.0833331692916615;
		}
		else if (y==9) {
			ret_val = 3280.8334366795866;
		}
		else if (y==10) {
			ret_val = 3.1038488769379064E16;
		}
		else if (y==11) {
			ret_val = 3.280833436679587;
		}
		else if (y==12) {
			ret_val = 8.33331692916615E-8;
		}
		else if (y==13) {
			ret_val = 2808334366795866E-6;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 6076.1035247305945;
		}
		else if (y==15) {
			ret_val = 5279.989606319673;
		}
		else if (y==17) {
			ret_val = 5279.999448819983;
		}
		else if (y==18) {
			ret_val = 0.003280833436679587;
		}
		else if (y==19) {
			ret_val = 8.333316929166151E-5;
		}
		else if (y==20) {
			ret_val = 1.01235955572265936E17;
		}
		else if (y==21) {
			ret_val = 0.013836974074198018;
		}
		else if (y==22) {
			ret_val = 0.0011530810634887202;
		}
		else if (y==23) {
			ret_val = 16.500000328083345;
		}
		else if (y==24) {
			ret_val = 2.9999940944998142;
		}
	}
	else if (x==8) {
		if (y==0) {
			ret_val = 3.937007874015748E-9;
		}
		else if (y==1) {
			ret_val = 5.889681102362205E12;
		}
		else if (y==2) {
			ret_val = 0.3937007874015748;
		}
		else if (y==3) {
			ret_val = 792.0015748031497;
		}
		else if (y==4) {
			ret_val = 72.00015748031497;
		}
		else if (y==5) {
			ret_val = 3.9370078740157484E-14;
		}
		else if (y==6) {
			ret_val = 12.000000000000002;
		}
		else if (y==7) {
			ret_val = 12.000023622047244;
		}
		else if (y==9) {
			ret_val = 39370.078740157485;
		}
		else if (y==10) {
			ret_val = 3.7246259842519686E17;
		}
		else if (y==11) {
			ret_val = 39.37007874015748;
		}
		else if (y==12) {
			ret_val = 1.0E-6;
		}
		else if (y==13) {
			ret_val = 3.937007874015748E-5;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 72913.38582677166;
		}
		else if (y==15) {
			ret_val = 63360.00000000001;
		}
		else if (y==17) {
			ret_val = 63360.118110236224;
		}
		else if (y==18) {
			ret_val = 0.03937007874015748;
		}
		else if (y==19) {
			ret_val = 0.0010;
		}
		else if (y==20) {
			ret_val = 1.21483385826771661E18;
		}
		else if (y==21) {
			ret_val = 0.16604401574803151;
		}
		else if (y==22) {
			ret_val = 0.013837;
		}
		else if (y==23) {
			ret_val = 198.0003937007874;
		}
		else if (y==24) {
			ret_val = 36.0;
		}
	}
	else if (x==9) {
		if (y==0) {
			ret_val = 1.0E-13;
		}
		else if (y==1) {
			ret_val = 1.495979E8;
		}
		else if (y==2) {
			ret_val = 1.0E-5;
		}
		else if (y==3) {
			ret_val = 0.02011684;
		}
		else if (y==4) {
			ret_val = 0.001828804;
		}
		else if (y==5) {
			ret_val = 1.0E-18;
		}
		else if (y==6) {
			ret_val = 3.0480000000000004E-4;
		}
		else if (y==7) {
			ret_val = 3.0480059999999997E-4;
		}
		else if (y==8) {
			ret_val = 2.5399999999999997E-5;
		}
		else if (y==10) {
			ret_val = 9.46055E12;
		}
		else if (y==11) {
			ret_val = 0.0010;
		}
		else if (y==12) {
			ret_val = 2.5399999999999998E-11;
		}
		else if (y==13) {
			ret_val = 9.999999999999999E-10;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.852;
		}
		else if (y==15) {
			ret_val = 1.609344;
		}
		else if (y==17) {
			ret_val = 1.609347;
		}
		else if (y==18) {
			ret_val = 1.0E-6;
		}
		else if (y==19) {
			ret_val = 2.54E-8;
		}
		else if (y==20) {
			ret_val = 3.085678E13;
		}
		else if (y==21) {
			ret_val = 4.217518E-6;
		}
		else if (y==22) {
			ret_val = 3.5145979999999996E-7;
		}
		else if (y==23) {
			ret_val = 0.00502921;
		}
		else if (y==24) {
			ret_val = 9.144E-4;
		}
	}
	else if (x==10) {
		if (y==0) {
			ret_val = 1.0570209977221198E-26;
		}
		else if (y==1) {
			ret_val = 1.581281215151339E-5;
		}
		else if (y==2) {
			ret_val = 1.0570209977221198E-18;
		}
		else if (y==3) {
			ret_val = 2.1263922287816247E-15;
		}
		else if (y==4) {
			ret_val = 1.9330842287182036E-16;
		}
		else if (y==5) {
			ret_val = 1.0570209977221198E-31;
		}
		else if (y==6) {
			ret_val = 3.221800001057021E-17;
		}
		else if (y==7) {
			ret_val = 3.221806343183007E-17;
		}
		else if (y==8) {
			ret_val = 2.684833334214184E-18;
		}
		else if (y==9) {
			ret_val = 1.0570209977221198E-13;
		}
		else if (y==11){
			ret_val = 1.0570209977221198E-16;
		}
		else if (y==12) {
			ret_val = 2.684833334214184E-24;
		}
		else if (y==13) {
			ret_val = 1.0570209977221197E-22;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.9576028877813658E-13;
		}
		else if (y==15) {
			ret_val = 1.7011104005581072E-13;
		}
		else if (y==17) {
			ret_val = 1.7011135716211003E-13;
		}
		else if (y==18) {
			ret_val = 1.0570209977221198E-19;
		}
		else if (y==19) {
			ret_val = 2.6848333342141844E-21;
		}
		else if (y==20) {
			ret_val = 3.261626438209195;
		}
		else if (y==21) {
			ret_val = 4.458005084270999E-19;
		}
		else if (y==22) {
			ret_val = 3.715003884552167E-20;
		}
		else if (y==23) {
			ret_val = 5.315980571954062E-16;
		}
		else if (y==24) {
			ret_val = 9.665400003171063E-17;
		}
	}
	else if (x==11) {
		if (y==0) {
			ret_val = 1.0E-10;
		}
		else if (y==1) {
			ret_val = 1.495979E11;
		}
		else if (y==2) {
			ret_val = 0.01;
		}
		else if (y==3) {
			ret_val = 20.11684;
		}
		else if (y==4) {
			ret_val = 1.828804;
		}
		else if (y==5) {
			ret_val = 1.0E-15;
		}
		else if (y==6) {
			ret_val = 0.3048;
		}
		else if (y==7) {
			ret_val = 0.3048006;
		}
		else if (y==8) {
			ret_val = 0.0254;
		}
		else if (y==9) {
			ret_val = 1000.0;
		}
		else if (y==10) {
			ret_val = 9.46055E15;
		}
		else if (y==12) {
			ret_val = 2.54E-8;
		}
		else if (y==13) {
			ret_val = 1.0E-6;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1852.0;
		}
		else if (y==15) {
			ret_val = 1609.344;
		}
		else if (y==17) {
			ret_val = 1609.347;
		}
		else if (y==18) {
			ret_val = 0.0010;
		}
		else if (y==19) {
			ret_val = 2.54E-5;
		}
		else if (y==20) {
			ret_val = 3.085678E16;
		}
		else if (y==21) {
			ret_val = 0.004217518;
		}
		else if (y==22) {
			ret_val = 3.514598E-4;
		}
		else if (y==23) {
			ret_val = 5.02921;
		}
		else if (y==24) {
			ret_val = 0.9144;
		}
	}
	else if (x==12) {
		if (y==0) {
			ret_val = 0.003937007874015748;
		}
		else if (y==1) {
			ret_val = 5.8896811023622052E18;
		}
		else if (y==2) {
			ret_val = 393700.78740157484;
		}
		else if (y==3) {
			ret_val = 7.920015748031496E8;
		}
		else if (y==4) {
			ret_val = 7.200015748031497E7;
		}
		else if (y==5) {
			ret_val = 3.9370078740157486E-8;
		}
		else if (y==6) {
			ret_val = 1.2000000000000002E7;
		}
		else if (y==7) {
			ret_val = 1.2000023622047244E7;
		}
		else if (y==8) {
			ret_val = 1000000.0;
		}
		else if (y==9) {
			ret_val = 3.937007874015748E10;
		}
		else if (y==10) {
			ret_val = 3.724625984251969E23;
		}
		else if (y==11) {
			ret_val = 3.9370078740157485E7;
		}
		else if (y==13) {
			ret_val = 39.37007874015748;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 7.291338582677165E10;
		}
		else if (y==15) {
			ret_val = 6.336000000000001E10;
		}
		else if (y==17) {
			ret_val = 6.336011811023622E10;
		}
		else if (y==18) {
			ret_val = 39370.078740157485;
		}
		else if (y==19) {
			ret_val = 1000.0000000000001;
		}
		else if (y==20) {
			ret_val = 1.2148338582677164E24;
		}
		else if (y==21) {
			ret_val = 166044.0157480315;
		}
		else if (y==22) {
			ret_val = 13837.0;
		}
		else if (y==23) {
			ret_val = 1.980003937007874E8;
		}
		else if (y==24) {
			ret_val = 3.6E7;
		}
	}
	else if (x==13) {
		if (y==0) {
			ret_val = 1.0E-4;
		}
		else if (y==1) {
			ret_val = 1.495979E17;
		}
		else if (y==2) {
			ret_val = 10000.0;
		}
		else if (y==3) {
			ret_val = 2.011684E7;
		}
		else if (y==4) {
			ret_val = 1828804.0000000002;
		}
		else if (y==5) {
			ret_val = 1.0E-9;
		}
		else if (y==6) {
			ret_val = 304800.00000000006;
		}
		else if (y==7) {
			ret_val = 304800.6;
		}
		else if (y==8) {
			ret_val = 25400.0;
		}
		else if (y==9) {
			ret_val = 1.0E9;
		}
		else if (y==10) {
			ret_val = 9.46055E21;
		}
		else if (y==11) {
			ret_val = 1000000.0;
		}
		else if (y==12) {
			ret_val = 0.0254;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.852E9;
		}
		else if (y==15) {
			ret_val = 1.6093440000000002E9;
		}
		else if (y==17) {
			ret_val = 1.609347E9;
		}
		else if (y==18) {
			ret_val = 1000.0000000000001;
		}
		else if (y==19) {
			ret_val = 25.400000000000002;
		}
		else if (y==20) {
			ret_val = 3.085678E22;
		}
		else if (y==21) {
			ret_val = 4217.518;
		}
		else if (y==22) {
			ret_val = 351.4598;
		}
		else if (y==23) {
			ret_val = 5029210.0;
		}
		else if (y==24) {
			ret_val = 914400.0;
		}
	}
	else if ((x==14)||(x==16)) {
		if (y==0) {
			ret_val = 5.399568034557236E-14;
		}
		else if (y==1) {
			ret_val = 8.077640388768898E7;
		}
		else if (y==2) {
			ret_val = 5.399568034557236E-6;
		}
		else if (y==3) {
			ret_val = 0.010862224622030238;
		}
		else if (y==4) {
			ret_val = 9.87475161987041E-4;
		}
		else if (y==5) {
			ret_val = 5.399568034557236E-19;
		}
		else if (y==6) {
			ret_val = 1.6457883369330455E-4;
		}
		else if (y==7) {
			ret_val = 1.645791576673866E-4;
		}
		else if (y==8) {
			ret_val = 1.3714902807775378E-5;
		}
		else if (y==9) {
			ret_val = 0.5399568034557235;
		}
		else if (y==10) {
			ret_val = 5.108288336933045E12;
		}
		else if (y==11) {
			ret_val = 5.399568034557236E-4;
		}
		else if (y==12) {
			ret_val = 1.3714902807775378E-11;
		}
		else if (y==13) {
			ret_val = 5.399568034557235E-10;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.0;
		}
		else if (y==15) {
			ret_val = 0.8689762419006479;
		}
		else if (y==17) {
			ret_val = 0.8689778617710583;
		}
		else if (y==18) {
			ret_val = 5.399568034557235E-7;
		}
		else if (y==19) {
			ret_val = 1.3714902807775378E-8;
		}
		else if (y==20) {
			ret_val = 1.6661328293736502E13;
		}
		else if (y==21) {
			ret_val = 2.277277537796976E-6;
		}
		else if (y==22) {
			ret_val = 1.897731101511879E-7;
		}
		else if (y==23) {
			ret_val = 0.0027155561555075596;
		}
		else if (y==24) {
			ret_val = 4.937365010799136E-4;
		}
	}
	else if (x==15) {
		if (y==0) {
			ret_val = 6.213711922373339E-14;
		}
		else if (y==1) {
			ret_val = 9.295582547920147E7;
		}
		else if (y==2) {
			ret_val = 6.213711922373339E-6;
		}
		else if (y==3) {
			ret_val = 0.01250002485484769;
		}
		else if (y==4) {
			ret_val = 0.0011363661218484053;
		}
		else if (y==5) {
			ret_val = 6.21371192237334E-19;
		}
		else if (y==6) {
			ret_val = 1.893939393939394E-4;
		}
		else if (y==7) {
			ret_val = 1.8939431221665472E-4;
		}
		else if (y==8) {
			ret_val = 1.5782828282828283E-5;
		}
		else if (y==9) {
			ret_val = 0.621371192237334;
		}
		else if (y==10) {
			ret_val = 5.87851323272091E12;
		}
		else if (y==11) {
			ret_val = 6.213711922373339E-4;
		}
		else if (y==12) {
			ret_val = 1.5782828282828283E-11;
		}
		else if (y==13) {
			ret_val = 6.21371192237334E-10;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.1507794480235425;
		}
		else if (y==17) {
			ret_val = 1.0000018641135766;
		}
		else if (y==18) {
			ret_val = 6.21371192237334E-7;
		}
		else if (y==19) {
			ret_val = 1.5782828282828283E-8;
		}
		else if (y==20) {
			ret_val = 1.917351417720512E13;
		}
		else if (y==21) {
			ret_val = 2.6206441879424163E-6;
		}
		else if (y==22) {
			ret_val = 2.1838699494949494E-7;
		}
		else if (y==23) {
			ret_val = 0.0031250062137119223;
		}
		else if (y==24) {
			ret_val = 5.681818181818182E-4;
		}
	}
	else if (x==17) {
		if (y==0) {
			ret_val = 6.213700339330175E-14;
		}
		else if (y==1) {
			ret_val = 9.295565219930817E7;
		}
		else if (y==2) {
			ret_val = 6.213700339330176E-6;
		}
		else if (y==3) {
			ret_val = 0.012500001553425085;
		}
		else if (y==4) {
			ret_val = 0.0011363640035368383;
		}
		else if (y==5) {
			ret_val = 6.213700339330176E-19;
		}
		else if (y==6) {
			ret_val = 1.8939358634278375E-4;
		}
		else if (y==7) {
			ret_val = 1.893939591648041E-4;
		}
		else if (y==8) {
			ret_val = 1.5782798861898645E-5;
		}
		else if (y==9) {
			ret_val = 0.6213700339330176;
		}
		else if (y==10) {
			ret_val = 5.87850227452501E12;
		}
		else if (y==11) {
			ret_val = 6.213700339330175E-4;
		}
		else if (y==12) {
			ret_val = 1.5782798861898645E-11;
		}
		else if (y==13) {
			ret_val = 6.213700339330175E-10;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1.1507773028439485;
		}
		else if (y==15) {
			ret_val = 0.9999981358898983;
		}
		else if (y==18) {
			ret_val = 6.213700339330176E-7;
		}
		else if (y==19) {
			ret_val = 1.5782798861898645E-8;
		}
		else if (y==20) {
			ret_val = 1.9173478435663656E13;
		}
		else if (y==21) {
			ret_val = 2.6206393027731124E-6;
		}
		else if (y==22) {
			ret_val = 2.1838658785209155E-7;
		}
		else if (y==23) {
			ret_val = 0.0031250003883562714;
		}
		else if (y==24) {
			ret_val = 5.681807590283513E-4;
		}
	}
	else if (x==18) {
		if (y==0) {
			ret_val = 1.0E-7;
		}
		else if (y==1) {
			ret_val = 1.495979E14;
		}
		else if (y==2) {
			ret_val = 10.0;
		}
		else if (y==3) {
			ret_val = 20116.84;
		}
		else if (y==4) {
			ret_val = 1828.804;
		}
		else if (y==5) {
			ret_val = 1.0E-12;
		}
		else if (y==6) {
			ret_val = 304.8;
		}
		else if (y==7) {
			ret_val = 304.8006;
		}
		else if (y==8) {
			ret_val = 25.4;
		}
		else if (y==9) {
			ret_val = 1000000.0;
		}
		else if (y==10) {
			ret_val = 9.46055E18;
		}
		else if (y==11) {
			ret_val = 1000.0;
		}
		else if (y==12) {
			ret_val = 2.5399999999999997E-5;
		}
		else if (y==13) {
			ret_val = 0.0010;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 1852000.0;
		}
		else if (y==15) {
			ret_val = 1609344.0;
		}
		else if (y==17) {
			ret_val = 1609347.0;
		}
		else if (y==19) {
			ret_val = 0.0254;
		}
		else if (y==20) {
			ret_val = 3.085678E19;
		}
		else if (y==21) {
			ret_val = 4.217518;
		}
		else if (y==22) {
			ret_val = 0.3514598;
		}
		else if (y==23) {
			ret_val = 5029.21;
		}
		else if (y==24) {
			ret_val = 914.4;
		}
	}
	else if (x==19) {
		if (y==0) {
			ret_val = 3.937007874015748E-6;
		}
		else if (y==1) {
			ret_val = 5.889681102362205E15;
		}
		else if (y==2) {
			ret_val = 393.7007874015748;
		}
		else if (y==3) {
			ret_val = 792001.5748031496;
		}
		else if (y==4) {
			ret_val = 72000.15748031496;
		}
		else if (y==5) {
			ret_val = 3.9370078740157485E-11;
		}
		else if (y==6) {
			ret_val = 12000.0;
		}
		else if (y==7) {
			ret_val = 12000.023622047243;
		}
		else if (y==8) {
			ret_val = 999.9999999999999;
		}
		else if (y==9) {
			ret_val = 3.937007874015748E7;
		}
		else if (y==10) {
			ret_val = 3.724625984251968E20;
		}
		else if (y==11) {
			ret_val = 39370.07874015748;
		}
		else if (y==12) {
			ret_val = 0.0010;
		}
		else if (y==13) {
			ret_val = 0.03937007874015748;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 7.291338582677165E7;
		}
		else if (y==15) {
			ret_val = 6.336E7;
		}
		else if (y==17) {
			ret_val = 6.336011811023622E7;
		}
		else if (y==18) {
			ret_val = 39.37007874015748;
		}
		else if (y==20) {
			ret_val = 1.2148338582677165E21;
		}
		else if (y==21) {
			ret_val = 166.04401574803148;
		}
		else if (y==22) {
			ret_val = 13.837;
		}
		else if (y==23) {
			ret_val = 198000.3937007874;
		}
		else if (y==24) {
			ret_val = 36000.0;
		}
	}
	else if (x==20) {
		if (y==0) {
			ret_val = 3.2407788498994384E-27;
		}
		else if (y==1) {
			ret_val = 4.848137103093712E-6;
		}
		else if (y==2) {
			ret_val = 3.2407788498994387E-19;
		}
		else if (y==3) {
			ret_val = 6.519422959881102E-16;
		}
		else if (y==4) {
			ret_val = 5.926749323811493E-17;
		}
		else if (y==5) {
			ret_val = 3.240778849899439E-32;
		}
		else if (y==6) {
			ret_val = 9.87789393449349E-18;
		}
		else if (y==7) {
			ret_val = 9.877913379166588E-18;
		}
		else if (y==8) {
			ret_val = 8.231578278744574E-19;
		}
		else if (y==9) {
			ret_val = 3.2407788498994387E-14;
		}
		else if (y==10) {
			ret_val = 0.30659550348416137;
		}
		else if (y==11) {
			ret_val = 3.2407788498994385E-17;
		}
		else if (y==12) {
			ret_val = 8.231578278744574E-25;
		}
		else if (y==13) {
			ret_val = 3.240778849899438E-23;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 6.00192243001376E-14;
		}
		else if (y==15) {
			ret_val = 5.215527997412562E-14;
		}
		else if (y==17) {
			ret_val = 5.215537719749112E-14;
		}
		else if (y==18) {
			ret_val = 3.240778849899439E-20;
		}
		else if (y==19) {
			ret_val = 8.231578278744575E-22;
		}
		else if (y==21) {
			ret_val = 1.366804313347018E-19;
		}
		else if (y==22) {
			ret_val = 1.1390034864298866E-20;
		}
		else if (y==23) {
			ret_val = 1.6298557399702755E-16;
		}
		else if (y==24) {
			ret_val = 2.963368180348047E-17;
		}
	}
	else if (x==21) {
		if (y==0) {
			ret_val = 2.371062790959043E-8;
		}
		else if (y==1) {
			ret_val = 3.547060142956118E13;
		}
		else if (y==2) {
			ret_val = 2.371062790959043;
		}
		else if (y==3) {
			ret_val = 4769.829079567651;
		}
		else if (y==4) {
			ret_val = 433.62091163570614;
		}
		else if (y==5) {
			ret_val = 2.371062790959043E-13;
		}
		else if (y==6) {
			ret_val = 72.26999386843163;
		}
		else if (y==7) {
			ret_val = 72.27013613219907;
		}
		else if (y==8) {
			ret_val = 6.022499489035968;
		}
		else if (y==9) {
			ret_val = 237106.27909590426;
		}
		else if (y==10) {
			ret_val = 2.24315580870075725E18;
		}
		else if (y==11) {
			ret_val = 237.10627909590428;
		}
		else if (y==12) {
			ret_val = 6.022499489035968E-6;
		}
		else if (y==13) {
			ret_val = 2.3710627909590427E-4;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 439120.8288856147;
		}
		else if (y==15) {
			ret_val = 381585.567625319;
		}
		else if (y==17) {
			ret_val = 381586.27894415625;
		}
		else if (y==18) {
			ret_val = 0.2371062790959043;
		}
		else if (y==19) {
			ret_val = 0.006022499489035969;
		}
		else if (y==20) {
			ret_val = 7.316336290680917E18;
		}
		else if (y==22) {
			ret_val = 0.08333332542979069;
		}
		else if (y==23) {
			ret_val = 1192.4572698919128;
		}
		else if (y==24) {
			ret_val = 216.80998160529487;
		}
	}
	else if (x==22) {
		if (y==0) {
			ret_val = 2.8452756190039376E-7;
		}
		else if (y==1) {
			ret_val = 4.256472575241891E14;
		}
		else if (y==2) {
			ret_val = 28.452756190039374;
		}
		else if (y==3) {
			ret_val = 57237.954383403165;
		}
		else if (y==4) {
			ret_val = 5203.451433136877;
		}
		else if (y==5) {
			ret_val = 2.8452756190039374E-12;
		}
		else if (y==6) {
			ret_val = 867.2400086724002;
		}
		else if (y==7) {
			ret_val = 867.2417158377715;
		}
		else if (y==8) {
			ret_val = 72.2700007227;
		}
		else if (y==9) {
			ret_val = 2845275.6190039376;
		}
		else if (y==10) {
			ret_val = 2.69178722573677E19;
		}
		else if (y==11) {
			ret_val = 2845.275619003937;
		}
		else if (y==12) {
			ret_val = 7.227000072270001E-5;
		}
		else if (y==13) {
			ret_val = 0.0028452756190039375;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 5269450.446395292;
		}
		else if (y==15) {
			ret_val = 4579027.245790273;
		}
		else if (y==17) {
			ret_val = 4579035.781617129;
		}
		else if (y==18) {
			ret_val = 2.8452756190039374;
		}
		else if (y==19) {
			ret_val = 0.07227000072270001;
		}
		else if (y==20) {
			ret_val = 8.779604381496831E19;
		}
		else if (y==21) {
			ret_val = 12.000001138110248;
		}
		else if (y==23) {
			ret_val = 14309.488595850791;
		}
		else if (y==24) {
			ret_val = 2601.7200260172003;
		}
	}
	else if (x==23) {
		if (y==0) {
			ret_val = 1.9883838614812268E-11;
		}
		else if (y==1) {
			ret_val = 2.974580500714824E10;
		}
		else if (y==2) {
			ret_val = 0.001988383861481227;
		}
		else if (y==3) {
			ret_val = 4.0;
		}
		else if (y==4) {
			ret_val = 0.36363643594123135;
		}
		else if (y==5) {
			ret_val = 1.988383861481227E-16;
		}
		else if (y==6) {
			ret_val = 0.06060594009794779;
		}
		else if (y==7) {
			ret_val = 0.060606059400979476;
		}
		else if (y==8) {
			ret_val = 0.005050495008162316;
		}
		else if (y==9) {
			ret_val = 198.83838614812268;
		}
		else if (y==10) {
			ret_val = 1.881120494073622E15;
		}
		else if (y==11) {
			ret_val = 0.19883838614812266;
		}
		else if (y==12) {
			ret_val = 5.050495008162316E-9;
		}
		else if (y==13) {
			ret_val = 1.9883838614812266E-7;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 368.2486911463232;
		}
		else if (y==15) {
			ret_val = 319.99936371716433;
		}
		else if (y==17) {
			ret_val = 319.9999602323228;
		}
		else if (y==18) {
			ret_val = 1.9883838614812268E-4;
		}
		else if (y==19) {
			ret_val = 5.050495008162316E-6;
		}
		else if (y==20) {
			ret_val = 6.135512336927669E15;
		}
		else if (y==21) {
			ret_val = 8.38604472670658E-4;
		}
		else if (y==22) {
			ret_val = 6.988369942794196E-5;
		}
		else if (y==24) {
			ret_val = 0.18181782029384336;
		}
	}
	else if (x==24) {
		if (y==0) {
			ret_val = 1.0936132983377078E-10;
		}
		else if (y==1) {
			ret_val = 1.636022528433946E11;
		}
		else if (y==2) {
			ret_val = 0.010936132983377079;
		}
		else if (y==3) {
			ret_val = 22.000043744531933;
		}
		else if (y==4) {
			ret_val = 2.0000043744531935;
		}
		else if (y==5) {
			ret_val = 1.0936132983377078E-15;
		}
		else if (y==6) {
			ret_val = 0.33333333333333337;
		}
		else if (y==7) {
			ret_val = 0.3333339895013123;
		}
		else if (y==8) {
			ret_val = 0.027777777777777776;
		}
		else if (y==9) {
			ret_val = 1093.6132983377079;
		}
		else if (y==10) {
			ret_val = 1.0346183289588802E16;
		}
		else if (y==11) {
			ret_val = 1.0936132983377078;
		}
		else if (y==12) {
			ret_val = 2.7777777777777777E-8;
		}
		else if (y==13) {
			ret_val = 1.0936132983377078E-6;
		}
		else if ((y==14)||(y==16)) {
			ret_val = 2025.3718285214347;
		}
		else if (y==15) {
			ret_val = 2025.3718285214347;
		}
		else if (y==17) {
			ret_val = 1760.003280839895;
		}
		else if (y==18) {
			ret_val = 0.0010936132983377078;
		}
		else if (y==19) {
			ret_val = 2.777777777777778E-5;
		}
		else if (y==20) {
			ret_val = 3.3745384951881016E16;
		}
		else if (y==21) {
			ret_val = 0.004612333770778652;
		}
		else if (y==22) {
			ret_val = 3.843611111111111E-4;
		}
		else if (y==23) {
			ret_val = 5.500010936132983;
		}
	}
	return ret_val;
 }
