/***************************************************************************
                                energy.cpp
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include "main_widget.h"

 float main_widget::energy(int box, int x) {
	TheString = new QString("\"energy\" (or \"work\"): the capacity of a physical system to do work;\n"
				"The kinetic energy of a body is the energy it has in\n"
           			"virtue of being in motion. It is measured by one half\n"
			           "of the product of the mass of each element of the body\n"
			           "multiplied by the square of the velocity of the\n"
			           "element, relative to some given body or point. The\n"
			           "available kinetic energy of a material system\n"
			           "unconnected with any other system is that energy which\n"
			           "is due to the motions of the parts of the system\n"
			           "relative to its center of mass. The potential energy of\n"
			           "a body or system is that energy which is not kinetic;\n"
			           "-- energy due to configuration. Kinetic energy is\n"
			           "sometimes called actual energy. Kinetic energy is\n"
			           "exemplified in the vis viva of moving bodies, in heat,\n"
			           "electric currents, etc.; potential energy, in a bent\n"
			           "spring, or a body suspended a given distance above the\n"
			           "earth and acted on by gravity.");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==20) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
	}
	if (x==0) {
		if (y==1) {
			ret_val = 1.0007715230281613;
		}
		else if (y==2) {
			ret_val = 0.999330841206533;
		}
		else if (y==3) {
			ret_val = 0.003968320164995981;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.003971542742754887;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.0039656662774298235;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.5185828998650307E-22;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
	        else if (y==7) {
        	    ret_val = 9.478169879134377E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
	        }
        	else if (y==8) {
	            ret_val = 0.0012850673329188214;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
        	}
	        else if (y==9) {
        	    ret_val = 3.994111213054094E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
	        }
        	else if ((y==10)||(y==19)) {
	            ret_val = 9.478169879134378E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
        	}
	        else if (y==11) {
        	    ret_val = 3.968320164995981;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==12) {
	            ret_val = 3.971542742754887;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==13) {
        	    ret_val = 3.9656662774298237;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==14) {
	            ret_val = 3412.141156488376;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
        	}
	        else if (y==15) {
        	    ret_val = 100000.37912679516;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	else if (y==16) {
	            ret_val = 99976.11501190458;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==17) {
        	    ret_val =  3965666.2774298233;
	        }
        	else if (y==18) {
	            ret_val =  3.4121411564883757;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
        	}
		TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
	}
	else if (x==1) {
		if (y==0) {
			ret_val = 0.9992290717607283;
		}
		else if (y==2) {
			ret_val = 0.9985604288406716;
		}
		else if (y==3) {
			ret_val = 0.003965260874918314;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.003968480968301023;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.003962609033309025;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.5174121814238495E-22;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
	        else if (y==7) {
        	    ret_val = 9.470862890317938E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
	        }       	
        	else if (y==8) {
	            ret_val = 0.0012840766382225086;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
        	}
	        else if (y==9) {
        	    ret_val = 3.9910320399291587E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
	        }
        	else if ((y==10)||(y==19)) {
	            ret_val = 9.470862890317938E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
        	}
	        else if (y==11) {
        	    ret_val = 3.9652608749183145;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==12) {
	            ret_val = 3.968480968301022;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==13) {
        	    ret_val = 3.9626090333090254;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==14) {
	            ret_val = 3409.5106405144575;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
        	}
	        else if (y==15) {
        	    ret_val =  99923.28601058843;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	else if (y==16) {
	            ret_val =  99899.04060158922;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==17) {
        	    ret_val = 99923.28601058843;
	        }
        	else if (y==18) {
	            ret_val = 3.4095106405144575;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
        	}
		TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
	}
	else if (x==2) {
		if (y==0) {
			ret_val = 1.0006696068667902;
		}
		else if (y==1) {
			ret_val = 1.001441646512069;
		}
		else if (y==3) {
			ret_val = 0.003970977379428084;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.003974202115047186;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.003968321714800589;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.5195997534025703E-22;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
        	else if (y==7) {
	            ret_val = 9.484516526770048E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
        	}
	        else if (y==8) {
        	    ret_val = 0.0012859278228292313;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
	        }
        	else if (y==9) {
	            ret_val = 3.996785697349078E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
        	}
	        else if ((y==10)||(y==19)) {
        	    ret_val = 9.484516526770049E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
	        }
        	else if (y==11) {
	            ret_val = 3.970977379428084;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==12) {
        	    ret_val = 3.9742021150471856;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==13) {
	            ret_val = 3.9683217148005885;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==14) {
        	    ret_val = 3414.4259496372174;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
	        }
        	else if (y==15) {
	            ret_val = 100067.34006734008;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==16) {
        	    ret_val = 100043.05970503154;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	else if (y==17) {
	            ret_val = 3968321.7148005883;
        	}
	        else if (y==18) {
        	    ret_val = 3.4144259496372174;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
	        }
		TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
	}
	else if (x==3) {
		if (y==0) {
			ret_val = 251.99579631221937;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 252.19021687207413;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 251.82717110920032;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==4) {
			ret_val = 1.0008120760485335;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.9993312314894431;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.826765071176077E-20;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
	        else if (y==7) {
        	    ret_val = 2.3884589662749594E-8;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
	        }       	
        	else if (y==8) {
	            ret_val = 0.32383156587369827;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
        	}
	        else if (y==9) {
        	    ret_val = 0.01006499235693131;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
	        }
        	else if ((y==10)||(y==19)) {
	            ret_val = 0.23884589662749595;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
        	}
	        else if (y==11) {
        	    ret_val = 1000.0000000000001;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==12) {
	            ret_val = 1000.8120760485335;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==13) {
        	    ret_val = 999.3312314894431;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==14) {
	            ret_val = 859845.2278589854;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
        	}
	        else if (y==15) {
        	    ret_val = 2.5199675169580586E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	else if (y==16) {
	            ret_val = 2.5193560714626923E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==17) {
        	    ret_val =  9.993312314894431E8;
	        }
        	 else if (y==18) {
	            ret_val = 859.8452278589854;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
        	}
		TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
	}
	else if (x==4) {
		if (y==0) {
			ret_val = 251.7913226098993;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 251.98558541358406;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 251.6228342322562;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 0.9991885828838719;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.9985203570235311;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.8236599684979236E-20;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
	        else if (y==7) {
        	    ret_val = 2.3865209297885542E-8;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
	        }       	
        	else if (y==8) {
	            ret_val = 0.3235688033984058;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
        	}
	        else if (y==9) {
        	    ret_val = 0.010056825449859195;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
	        }
        	else if ((y==10)||(y==19)) {
	            ret_val = 0.23865209297885542;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
        	}
	        else if (y==11) {
        	    ret_val = 999.188582883872;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	 else if (y==12) {
	            ret_val = 1000.0;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==13) {
        	    ret_val = 998.5203570235311;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==14) {
	            ret_val = 859147.5347238795;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
        	}
	        else if (y==15) {
        	    ret_val = 2.517922772182712E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	 else if (y==16) {
	            ret_val = 2.5173118228246864E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==17) {
        	    ret_val = 9.985203570235311E8;
	        }
        	else if (y==18) {
	            ret_val = 859.1475347238795;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
        	}
		TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
	}
	else if (x==5) {
		if (y==0) {
			ret_val = 252.1644359464627;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 252.35898661567873;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 251.99569789674948;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 1.0006692160611854;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 1.0014818355640536;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.8293260038240916E-20;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
        	else if (y==7) {
	            ret_val = 2.3900573613766727E-8;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
        	}
	        else if (y==8) {
        	    ret_val = 0.32404827915869977;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
	        }
        	else if (y==9) {
	            ret_val = 0.010071728011472275;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
        	}
	        else if ((y==10)||(y==19)) {
        	    ret_val = 0.2390057361376673;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
	        }
        	else if (y==11) {
	            ret_val = 1000.6692160611855;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==12) {
	       	    ret_val = 1001.4818355640534;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
        	}
	        else if (y==13) {
        	    ret_val = 1000.0;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	        }
        	else if (y==14) {
	            ret_val = 860420.6500956023;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
        	}
	        else if (y==15) {
        	    ret_val = 2.5216539196940724E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	        }
        	else if (y==16) {
	            ret_val = 2.52104206500956E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
        	}
	        else if (y==17) {
        	    ret_val = 1.0E9;
	        }
        	else if (y==18) {
	            ret_val = 860.4206500956022;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
        	}
		TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
	}
	else if (x==6) {
		if (y==0) {
			ret_val = 6.585086662630525E21;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 6.590167208633184E21;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 6.580680193984484E21;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 2.6131732191562797E19;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 2.615295314538226E19;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 2.6114256111946777E19;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==7) {
			ret_val = 6.241457005723417E11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 8.4622797545859113E18;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 2.63015684781455392E17;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 6.2414570057234166E18;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 2.61317321915628E22;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 2.615295314538226E22;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 2.6114256111946774E22;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 2.24692452206043E25;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 6.585111628458548E26;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 6.583513815465083E26;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 2.6114256111946774E28;
		}
		else if (y==18) {
			ret_val = 2.24692452206043E22;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
		TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
	}
	else if (x==7) {
		if (y==0) {
			ret_val = 1.055056E10;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 1.05587E10;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 1.05435E10;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 4.1868E7;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 4.1902E7;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 4.184E7;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.60219E-12;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==8) {
			ret_val = 1.355818E7;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 421401.10000000003;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 1.0E7;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 4.1868E10;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 4.1902E10;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 4.184E10;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 3.6E13;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 1.05506E15;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 1.054804E15;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 4.184E16;
		}
		else if (y==18) {
			ret_val = 3.6E10;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
	}
	else if (x==8) {
		if (y==0) {
			ret_val = 778.1693413127721;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 778.7697168794041;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 777.6486224552262;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 3.088025088913114;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 3.0905328001250907;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 3.085959914973839;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.1817146549168104E-19;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 7.375621211696555E-8;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==9) {
			ret_val = 0.031080948917922614;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 0.7375621211696556;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 3088.025088913114;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 3090.5328001250905;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 3085.9599149738387;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 2655223.63621076;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 7.781722915612568E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 7.779834756582373E7;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 3.085959914973839E9;
		}
		else if (y==18) {
			ret_val = 2655.22363621076;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
       		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
	}
	else if (x==9) {
		if (y==0) {
			ret_val = 25036.85918237992;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 25056.175695791964;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 25020.105547897238;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 99.35427316160303;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 99.43495638715703;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 99.28782815232329;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.802054622069093E-18;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.373036045705623E-6;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 32.17404985416507;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 23.730360457056232;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 99354.27316160305;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 99434.95638715703;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 99287.82815232329;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 8.542929764540245E7;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 2.503695410382175E9;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 2.5030879131544743E9;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 9.928782815232329E10;
		}
		else if (y==18) {
			ret_val = 85429.29764540245;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
   					  "body through one foot against the force of one poundal");
	}
	else if ((x==10)||(x==19)) {
		if (y==0) {
			ret_val = 1055.056;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 1055.87;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 1054.35;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 4.1868;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 4.1902;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 4.184;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.60219E-19;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 1.0E-7;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 1.355818;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 0.04214011;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 1.0;
		}
		else if (y==11) {
			ret_val = 4186.8;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 4190.2;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 4184.0;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 3600000.0;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 1.05506E8;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 1.054804E8;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 4.184E9;
		}
		else if (y==18) {
			ret_val = 3600.0;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
       		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
	}
	else if (x==11) {
		if (y==0) {
			ret_val = 0.25199579631221936;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 0.2521902168720741;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 0.25182717110920033;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 0.0010;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.0010008120760485334;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 9.99331231489443E-4;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.826765071176077E-23;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.388458966274959E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.238315658736983E-4;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.0064992356931308E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.3884589662749592E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==12) {
			ret_val = 1.0008120760485335;
		}
		else if (y==13) {
			ret_val = 0.9993312314894429;
		}
		else if (y==14) {
			ret_val = 859.8452278589854;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 25199.675169580587;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 25193.56071462692;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 999331.231489443;
		}
		else if (y==18) {
			ret_val = 0.8598452278589853;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
         				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	}
	else if (x==12) {
		if (y==0) {
			ret_val = 0.2517913226098993;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 0.25198558541358407;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 0.25162283423225623;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 9.991885828838718E-4;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.0010;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 9.98520357023531E-4;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.8236599684979235E-23;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.3865209297885543E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.235688033984058E-4;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.0056825449859197E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.3865209297885544E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 0.999188582883872;
		}
		else if (y==13) {
			ret_val = 0.9985203570235311;
		}
		else if (y==14) {
			ret_val = 859.1475347238795;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 25179.227721827123;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 25173.11822824686;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 998520.3570235311;
		}
		else if (y==18) {
			ret_val = 0.8591475347238796;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	}
	else if (x==13) {
		if (y==0) {
			ret_val = 0.2521644359464627;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 0.25235898661567874;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 0.2519956978967495;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 0.0010006692160611855;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.0010014818355640535;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.0010;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.829326003824092E-23;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.390057361376673E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.240482791586998E-4;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.0071728011472276E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.390057361376673E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 1.0006692160611854;
		}
		else if (y==12) {
			ret_val = 1.0014818355640536;
		}
		else if (y==14) {
			ret_val = 860.4206500956022;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 25216.53919694073;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 25210.420650095602;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 1000000.0;
		}
		else if (y==18) {
			ret_val = 0.8604206500956023;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
	}
	else if (x==14) {
		if (y==0) {
			ret_val = 2.9307111111111114E-4;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 2.932972222222222E-4;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 2.9287499999999995E-4;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 1.163E-6;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 1.1639444444444444E-6;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 1.1622222222222223E-6;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 4.450527777777778E-26;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.7777777777777778E-14;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.766161111111111E-7;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.1705586111111111E-8;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.7777777777777776E-7;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 0.001163;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 0.0011639444444444444;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 0.0011622222222222223;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==15) {
			ret_val = 29.307222222222222;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 29.30011111111111;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 1162.2222222222222;
		}
		else if (y==18) {
			ret_val = 0.0010;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
       		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
	}
	else if (x==15) {
		if (y==0) {
			ret_val = 9.99996208746422E-6;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 1.000767728849544E-5;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 9.993270524899058E-6;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 3.968305120087957E-8;
		}
		else if (y==4) {
			ret_val = 3.971527685629253E-8;
		}
		else if (y==5) {
			ret_val = 3.9656512425833604E-8;
		}
		else if (y==6) {
			ret_val = 1.5185771425321783E-27;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 9.47813394498891E-16;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 1.2850624609026974E-8;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 3.9940960703656666E-10;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 9.478133944988911E-9;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 3.9683051200879575E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 3.971527685629253E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 3.9656512425833605E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 0.034121282201960076;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==16) {
			ret_val = 0.9997573597710083;
		}
		else if (y==17) {
			ret_val = 39.656512425833604;
		}
		else if (y==18) {
			ret_val = 3.412128220196008E-5;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	}
	else if (x==16) {
		if (y==0) {
			ret_val = 1.0002389069438493E-5;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 1.0010106142942194E-5;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 9.995695882837E-6;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 3.969268224238816E-8;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 3.9724915718939254E-8;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 3.966613702640491E-8;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 1.5189456998646194E-27;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 9.480434279733486E-16;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 1.2853743444279696E-8;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 3.995065433957399E-10;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 9.480434279733487E-9;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 3.969268224238816E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 3.972491571893925E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 3.966613702640491E-5;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 0.03412956340704055;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 1.0002426991175613;
		}
		else if (y==17) {
			ret_val = 39.666137026404904;
		}
		else if (y==18) {
			ret_val = 3.412956340704055E-5;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
	}
	else if (x==17) {
		if (y==0) {
			ret_val = 2.521644359464627E-7;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 2.5235898661567875E-7;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 2.519956978967495E-7;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 1.0006692160611854E-9;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 1.0014818355640536E-9;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 1.0E-9;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 3.8293260038240913E-29;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.3900573613766728E-17;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.240482791586998E-10;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.0071728011472276E-11;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.390057361376673E-10;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 1.0006692160611856E-6;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 1.0014818355640536E-6;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 1.0E-6;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 8.604206500956023E-4;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 0.025216539196940727;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 0.025210420650095603;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==18) {
			ret_val = 8.604206500956023E-7;
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
		}
	}
	else if (x==18) {
		if (y==0) {
			ret_val = 0.2930711111111111;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==1) {
			ret_val = 0.2932972222222222;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==2) {
			ret_val = 0.292875;
			TheString->append("\n\n\"British Thermal Unit (or Btu)\": a unit of heat\n"
					  "equal to the amount of heat required to raise one pound\n"
					  "of water one degree Fahrenheit at one atmosphere pressure;\n"
					  "equivalent to 251.997 calories");
		}
		else if (y==3) {
			ret_val = 0.001163;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==4) {
			ret_val = 0.0011639444444444444;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==5) {
			ret_val = 0.0011622222222222223;
			TheString->append("\n\n\"calorie\": a unit of heat equal to the amount of heat required to raise\n"
            				  "the temperature of one kilogram of water by one degree\n"
            				  "at one atmosphere pressure");
		}
		else if (y==6) {
			ret_val = 4.4505277777777776E-23;
			TheString->append("\n\n\"electron volt\": a unit of energy equal to the work done by an electron\n"
           				  "accelerated through a potential difference of 1 volt");
		}
		else if (y==7) {
			ret_val = 2.7777777777777777E-11;
	        	TheString->append("\n\n\"erg\": the unit of work or energy in the C. G. S. system, being the\n"
     					  "amount of work done by a dyne working through a distance of\n"
     					  "one centimeter; the amount of energy expended in moving a\n"
     					  "body one centimeter against a force of one dyne. One foot\n"
     					  "pound is equal to 13,560,000 ergs");
		}
		else if (y==8) {
			ret_val = 3.766161111111111E-4;
        		TheString->append("\n\n\"foot pund force\": a unit of energy, or work, being equal to the work done in\n"
     					  "raising one pound avoirdupois against the force of gravity\n"
			     		  "the height of one foot");
		}
		else if (y==9) {
			ret_val = 1.170558611111111E-5;
	        	TheString->append("\n\n\"foot poundal\": a unit of energy or work, equal to the work done in moving a\n"
     					  "body through one foot against the force of one poundal");
		}
		else if ((y==10)||(y==19)) {
			ret_val = 2.777777777777778E-4;
        		TheString->append("\n\n\"joule\" (==\"watt second\"): a unit of electrical energy equal to the work done when a\n"
           				  "current of one ampere passes through a resistance of one\n"
           				  "ohm for one second");
		}
		else if (y==11) {
			ret_val = 1.163;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==12) {
			ret_val = 1.1639444444444444;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==13) {
			ret_val = 1.1622222222222223;
	        	TheString->append("\n\n\'kilocalorie\": a unit of heat equal to the amount of heat required to raise\n"
           				  "the temperature of one kilogram of water by one degree at\n"
           				  "one atmosphere pressure");
		}
		else if (y==14) {
			ret_val = 1000.0;
        		TheString->append("\n\n\"kilowatt hour\": a unit of energy equal to the work done by a power of 1000\n"
           				  "watts operating for one hour");
		}
		else if (y==15) {
			ret_val = 29307.222222222223;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==16) {
			ret_val = 29300.11111111111;
	        	TheString->append("\n\n\"therms\": a unit of heat equal to 100,000 British thermal units");
		}
		else if (y==17) {
			ret_val = 1162222.2222222222;
		}
	            TheString->append("\n\n\"watt hour\":  a unit of energy equal to the power of one watt operating\n"
           			      "for one hour");
	}
	return ret_val;
 }
