/***************************************************************************
                               current.cpp
                             -------------------
    begin                : Thu Apr 6 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


 #include "main_widget.h"

 float main_widget::current(int box, int x) {
	TheString = new QString("\"current\":  a current or stream of electricity\n"
			        "traversing a closed circuit formed of conducting\n"
			        "substances, or passing by means of conductors from one\n"
        			"body to another which is in a different electrical state");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==18) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
	}
	if ((x==0)||(x==2)) {
		if ((y==0)||(y==2)) {
			ret_val = 1.0;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes");
		}
		if (y==1) {
			ret_val = 0.1;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\"."
					"\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					"a unit of current equal to 10 amperes");
		}
		else if (y==3) {
			ret_val = 3.3356E-11;
		}
		else if (y==4) {
			ret_val = 0.07957747;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n"
					"\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					"a unit of current equal to 10 amperes");					
		}
		else if (y==5) {
			ret_val = 1.0E-7;
		}
		else if (y==6) {
			ret_val = 1.0E-4;
		}
		else if (y==7) {
			ret_val = 3.3356400000000004E-11;
		}
	}
	else if (x==1) {
		if ((y==0)||(y==2)) {
			ret_val = 10.0;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes"
					"\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");					
		}
		else if (y==1) {
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");
		}
		else if (y==3) {
			ret_val = 3.3356E-10;
		}
		else if (y==4) {
			ret_val = 0.7957747;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n"
					"\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");			
		}
		else if (y==5) {
			ret_val = 1.0E-6;
		}
		else if (y==6) {
			ret_val = 0.0010;
		}
		else if (y==7) {
			ret_val = 3.33564E-10;
		}
	}
	else if (x==3) {
		if ((y==0)||(y==2)) {
			ret_val = 2.9979613862573452E10;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes");
		}
		else if (y==1) {
			ret_val = 2.997961386257345E9;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");
		}
		else if (y==4) {
			ret_val = 2.385701822760523E9;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==5) {
			ret_val = 2997.961386257345;
		}
		else if (y==6) {
			ret_val = 2997961.3862573453;
		}
		else if (y==7) {
			ret_val = 1.0000119918455452;
		}
	}
	else if (x==4) {
		if ((y==0)||(y==2)) {
			ret_val = 12.566370858485449;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes"
					  "\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==1) {
			ret_val = 1.256637085848545;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\"."
					"\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==3) {
			ret_val = 4.1916386635564064E-10;
		}
		else if (y==4) {
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==5) {
			ret_val = 1.2566370858485448E-6;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==6) {
			ret_val = 0.001256637085848545;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==7) {
			ret_val = 4.1916889290398404E-10;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
	}
	else if (x==5) {
		if ((y==0)||(y==2)) {
			ret_val = 1.0E7;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes");
		}
		else if (y==1) {
			ret_val = 1000000.0;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");
		}
		else if (y==3) {
			ret_val = 3.3356E-4;
		}
		else if (y==4) {
			ret_val = 795774.7;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==6) {
			ret_val = 1000.0000000000001;
		}
		else if (y==7) {
			ret_val = 3.33564E-4;
		}
	}
	else if (x==6) {
		if ((y==0)||(y==2)) {
			ret_val = 10000.0;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes");
		}
		else if (y==1) {
			ret_val = 1000.0;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");
		}
		else if (y==3) {
			ret_val = 3.3356E-7;
		}
		else if (y==4) {
			ret_val = 795.7746999999999;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==5) {
			ret_val = 0.0010;
		}
		else if (y==7) {
			ret_val = 3.3356400000000003E-7;
		}
	}
	else if (x==7) {
		if ((y==0)||(y==2)) {
			ret_val = 2.9979254355985657E10;
			TheString->append("\n\n\"abampere\" (or \"electromagnetic unit of current\"):\n"
					  "a unit of current equal to 10 amperes");
		}
		else if (y==1) {
			ret_val = 2.9979254355985656E9;
			TheString->append("\n\n\"ampere\": The unit of electric current; defined by the International\n"
     					"Electrical Congress in 1893 and by U. S. Statute as, one\n"
     					"tenth of the unit of current of the C. G. S. system of\n"
     					"electro-magnetic units, or the practical equivalent of the\n"
     					"unvarying current which, when passed through a standard\n"
     					"solution of nitrate of silver in water, deposits silver at\n"
     					"the rate of 0.001118 grams per second. Called also the\n"
					"\"international ampere\".");
		}
		else if (y==3) {
			ret_val = 0.9999880082982575;
		}
		else if (y==4) {
			ret_val = 2.3856732141358175E9;
			TheString->append("\n\n\"gilbert\": a unit of magnetomotive force equal to 0.7958 ampere-turns\n");
		}
		else if (y==5) {
			ret_val = 2997.9254355985654;
		}
		else if (y==6) {
			ret_val = 2997925.4355985657;
		}
	}
	return ret_val;
 }
