  /***************************************************************************
                          colors.cpp  -  description
                             -------------------
    begin                : Sun Jul 2 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@netmeister.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main_widget.h"

#include <ctype.h>
#include <stdio.h>

void 
main_widget::colors() 
{

		if (QLineEdit_3->isVisible()) {
				// rgb2hex
				bool isNum = true;
				QString redval = Red1->text();
				QString greenval = Green1->text();
				QString blueval = Blue1->text();
				int R = redval.toInt(&isNum);
				int G = 0;
				int B = 0;
				if (isNum)
						G = greenval.toInt(&isNum);
				if (isNum)
						B = blueval.toInt(&isNum);
				QString output = "--";

				if ((R>255)||(R<0)||(G<0)||(G>255)||(B<0)||(B>255)||(!isNum)) {
						QMessageBox::warning(0, "KUnit 0.4 - Conversion Error!", "Wrong input!\nRGB values must be between 0 and 255!");
				}
				else {
						output.sprintf("%02x%02x%02x\n", R, G, B);
				}

				QLineEdit_3->setText(output);
		}
		else {
				// hex2rgb
				bool error = false;
				unsigned long l;
				int i;
				QString redval = "--";
				QString greenval = "--";
				QString blueval = "--";
				QString hex = HexEdit->text();

				if (hex.length()!=6) {
						QMessageBox::warning(0,"KUnit 0.4 - Conversion Error!", "Wrong input!\nHexadecimal value must have exactly 6 characters!");
				}

				for( i = 0; i < hex.length(); i++ ) 
				{
						if( !isxdigit(hex[i].latin1())) 
						{
								QMessageBox::warning(0,"KUnit 0.4 - Conversion Error!", "Wrong input!\nInput is not a valid hexadecimal number!");
								error = true;
						}
				}

				if (!error) {
						i = sscanf(hex, "%6lx", &l);
						if(i <= 0) {
								QMessageBox::warning(0,"KUnit 0.4 - Conversion Error!", "Wrong input!\nError in hexadecimal value!");
								error = true;
						}
				}

				if (!error) {
						redval.sprintf("%d ", (int)( l & 0xFF0000 ) >> 16 );
						l <<= 8;
						Red2->setText(redval);
						greenval.sprintf("%d ", (int)( l & 0xFF0000 ) >> 16 );
						l <<= 8;
						Green2->setText(greenval);
						blueval.sprintf("%d ", (int)( l & 0xFF0000 ) >> 16 );
						l <<= 8;
						Blue2->setText(blueval);
				}
		}
}
