/***************************************************************************
                               capacitance.cpp
                             -------------------
    begin                : Thu Apr 6 2000
    copyright            : (C) 2000 by Jan Schaumann
    email                : jschauma@stevens-tech.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


 #include "main_widget.h"

 float main_widget::capacitance(int box, int x) {
	TheString = new QString("\"capacitance\": a) the property of an electric nonconductor that\n"
			"permits the storage of energy as a result of the separation of\n"
			"charge that occurs when opposite surfaces of the nonconductor are\n"
	                "maintained at a difference of potential\n"
	                "b) the measure of this property that is equal to the ratio of the\n"
	                "charge on either surface to the potential difference between the surfaces");
	float ret_val;
	ret_val = 0.0;
	int y;
	if (box==12) {
		y=x;
		x = all[box+1]->currentItem();
	}
	else
		y = all[box-1]->currentItem();
	if (x==y) {
		ret_val = 1.0;
	}
	if ((x==0) || (x==1)) {
		if ((y==0)||(y==1)) {
			TheString->append("\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
				"a capacitance unit equal to one billion farads");
			ret_val = 1.0;
		}
		else if ((y==2)||(x==6)) {
			ret_val = 1.1126499999999999E-2;
		}
		else if (y==3) {
			ret_val = 1.0E-9;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity"
					"\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
					"a capacitance unit equal to one billion farads");
		}
		else if (y==4) {
			ret_val = 9.999999999999999E-16;
		}
		else if (y==5) {
			ret_val = 1.0E-21;
		}
	}
	else if ((x==2)||(x==6)) {
		if ((y==0)||(y==1)) {
			ret_val = 8.987552240147396E20;
			TheString->append("\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
				"a capacitance unit equal to one billion farads");
		}
		else if (y==3) {
			ret_val = 8.987552240147396E11;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if (y==4) {
			ret_val = 898755.2240147396;
		}
		else if (y==5) {
			ret_val = 0.8987552240147396;
		}
	}
	else if (x==3) {
		if ((y==0)||(y==1)) {
			ret_val = 1.0E9;
			TheString->append("\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
					"a capacitance unit equal to one billion farads"
					"\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if ((y==2) ||(x==6)){
			ret_val = 1.11265E-12;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if (y==3) {
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}		
		else if (y==4) {
			ret_val = 1.0E-6;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if (y==5) {
			ret_val = 1.0E-12;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
	}
	else if (x==4) {
		if ((y==0)||(y==1)) {
			ret_val = 1.0E15;
			TheString->append("\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
				"a capacitance unit equal to one billion farads");
		}
		else if ((y==2)||(x==6)){
			ret_val = 1.11265E-8;
		}
		else if (y==3) {
			ret_val = 1000000.0;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if (y==5) {
			ret_val = 1.0E-6;
		}
	}
	else if (x==5) {
		if ((y==0)||(y==1)) {
			ret_val = 1.0E21;
			TheString->append("\n\n\"abfarad (or electromagnetic unit of capacitance)\":\n"
				"a capacitance unit equal to one billion farads");
		}
		else if ((y==2)||(x==6)) {
			ret_val = 1.11265;
		}
		else if (y==3) {
			ret_val = 1.0E12;
			TheString->append("\n\n\"farad\": the unit of capacitance equal to the\n"
					"capacitance of a capacitor between whose plates there\n"
					"appears a potential of one volt when it is charged by\n"
					"one coulomb of electricity");
		}
		else if (y==4) {
			ret_val = 1000000.0;
		}
	}
	return ret_val;
 }
