/*
 * JTranslate.java
 *
 * Created on 9 Ιούλιος 2005, 11:20 πμ
 * 
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.tools;

import static com.panayotis.jubler.i18n.I18N.__;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

/**
 *
 * @author teras
 */
public class TranslateGUI extends JPanel {

    private final Translate tool;

    public TranslateGUI(Translate tool) {
        this.tool = tool;
        initComponents();
        String[] names = tool.getTranslators().getNamesList();
        if (names != null) {
            TransMachine.setModel(new DefaultComboBoxModel(names));

            FromLang.setModel(new DefaultComboBoxModel(tool.getCurrentTranslator().getSourceLanguages()));
            FromLang.setSelectedItem(tool.getCurrentTranslator().getDefaultSourceLanguage());

            ToLang.setModel(new DefaultComboBoxModel(tool.getCurrentTranslator().getDestinationLanguagesFor(FromLang.getSelectedItem().toString())));
            ToLang.setSelectedItem(tool.getCurrentTranslator().getDefaultDestinationLanguage());
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        TransMachine = new javax.swing.JComboBox();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        FromLang = new javax.swing.JComboBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        ToLang = new javax.swing.JComboBox();
        jPanel6 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 0, 0, 0));
        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.BorderLayout());

        jLabel1.setText(__("Translator"));
        jPanel2.add(jLabel1, java.awt.BorderLayout.WEST);

        TransMachine.setToolTipText(__("Selection of translation machine"));
        TransMachine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                TransMachineActionPerformed(evt);
            }
        });
        jPanel2.add(TransMachine, java.awt.BorderLayout.CENTER);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jPanel3.setLayout(new java.awt.GridLayout(1, 2));

        jPanel4.setLayout(new java.awt.BorderLayout());

        jLabel2.setText(__("From"));
        jPanel4.add(jLabel2, java.awt.BorderLayout.CENTER);

        FromLang.setToolTipText(__("Original language"));
        jPanel4.add(FromLang, java.awt.BorderLayout.PAGE_END);

        jPanel3.add(jPanel4);

        jPanel5.setLayout(new java.awt.BorderLayout());

        jLabel3.setText(__("To"));
        jPanel5.add(jLabel3, java.awt.BorderLayout.CENTER);

        ToLang.setToolTipText(__("Target language"));
        jPanel5.add(ToLang, java.awt.BorderLayout.PAGE_END);

        jPanel3.add(jPanel5);

        add(jPanel3, java.awt.BorderLayout.CENTER);

        jPanel6.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));

        jTextArea1.setEditable(false);
        jTextArea1.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        jTextArea1.setColumns(20);
        jTextArea1.setFont(jTextArea1.getFont().deriveFont((jTextArea1.getFont().getStyle() | java.awt.Font.ITALIC)));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(2);
        jTextArea1.setText(__("Computer Translated subtitles should be only for personal use, and not for distribution."));
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jScrollPane1.setViewportView(jTextArea1);

        jPanel6.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(jPanel6, java.awt.BorderLayout.PAGE_END);
    }// </editor-fold>//GEN-END:initComponents

private void TransMachineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_TransMachineActionPerformed
    tool.setTranslator(TransMachine.getSelectedIndex());
}//GEN-LAST:event_TransMachineActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JComboBox FromLang;
    javax.swing.JComboBox ToLang;
    private javax.swing.JComboBox TransMachine;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables
}
