/*
 * JRecodeTime.java
 *
 * Created on 25 Ιούνιος 2005, 1:53 πμ
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.tools;

import static com.panayotis.jubler.i18n.I18N.__;
import java.awt.BorderLayout;
import com.panayotis.jubler.options.gui.JRateChooser;
import com.panayotis.jubler.os.SystemDependent;
import javax.swing.JPanel;

/**
 *
 * @author teras
 */
public class RecodeTimeGUI extends JPanel {

    JRateChooser FromR, ToR;

    public RecodeTimeGUI() {
        initComponents();
        FromR = new JRateChooser();
        FromP.add(FromR, BorderLayout.CENTER);
        ToR = new JRateChooser();
        ToP.add(ToR, BorderLayout.CENTER);
    }

    void toggleRecodeMode(boolean status) {
        boolean nostatus = !status;
        FromR.setEnabled(status);
        ToR.setEnabled(status);
        ArrowL.setEnabled(status);
        CustomF.setEnabled(nostatus);
        RecodeL.setEnabled(nostatus);
        CustomC.setEnabled(nostatus);
        CentralL.setEnabled(nostatus);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        Factor = new javax.swing.ButtonGroup();
        jPanel4 = new javax.swing.JPanel();
        AutoB = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        ArrowL = new javax.swing.JLabel();
        FromP = new javax.swing.JPanel();
        ToP = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        CustomB = new javax.swing.JRadioButton();
        jPanel6 = new javax.swing.JPanel();
        RecodeL = new javax.swing.JLabel();
        CustomF = new javax.swing.JTextField();
        jPanel7 = new javax.swing.JPanel();
        CentralL = new javax.swing.JLabel();
        CustomC = new javax.swing.JTextField();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        jPanel4.setOpaque(false);
        jPanel4.setLayout(new java.awt.BorderLayout());

        Factor.add(AutoB);
        AutoB.setSelected(true);
        AutoB.setText(__("Automatically compute based on FPS"));
        AutoB.setToolTipText(__("Use the following FPS in order to automatically compute the desired recoding"));
        AutoB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AutoBActionPerformed(evt);
            }
        });
        jPanel4.add(AutoB, java.awt.BorderLayout.CENTER);

        add(jPanel4);

        jPanel3.setOpaque(false);
        jPanel3.setLayout(new java.awt.GridLayout(1, 2));

        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.BorderLayout());

        ArrowL.setText(" -> ");
        ArrowL.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jPanel2.add(ArrowL, java.awt.BorderLayout.EAST);

        FromP.setOpaque(false);
        FromP.setLayout(new java.awt.BorderLayout());
        jPanel2.add(FromP, java.awt.BorderLayout.CENTER);

        jPanel3.add(jPanel2);

        ToP.setOpaque(false);
        ToP.setLayout(new java.awt.BorderLayout());
        jPanel3.add(ToP);

        add(jPanel3);

        jPanel5.setOpaque(false);
        jPanel5.setLayout(new java.awt.BorderLayout());

        Factor.add(CustomB);
        CustomB.setText(__("Custom"));
        CustomB.setToolTipText(__("Use a custom factor in order to perform the recoding"));
        CustomB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CustomBActionPerformed(evt);
            }
        });
        jPanel5.add(CustomB, java.awt.BorderLayout.CENTER);

        add(jPanel5);

        jPanel6.setOpaque(false);
        jPanel6.setLayout(new java.awt.GridLayout(1, 2));

        RecodeL.setText(__("Recoding factor"));
        RecodeL.setEnabled(false);
        jPanel6.add(RecodeL);

        CustomF.setText("1.0");
        CustomF.setToolTipText(__("The value of the custom factor which will do the recoding"));
        CustomF.setEnabled(false);
        jPanel6.add(CustomF);

        add(jPanel6);

        jPanel7.setOpaque(false);
        jPanel7.setLayout(new java.awt.GridLayout(1, 2));

        CentralL.setText(__("Central time"));
        CentralL.setEnabled(false);
        jPanel7.add(CentralL);

        CustomC.setText("0.0");
        CustomC.setToolTipText(__("The central time point which the recoding occurs. Usually left to 0 to apply evenly to the whole file."));
        CustomC.setEnabled(false);
        jPanel7.add(CustomC);

        add(jPanel7);
    }// </editor-fold>//GEN-END:initComponents
    private void AutoBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AutoBActionPerformed
        toggleRecodeMode(true);
    }//GEN-LAST:event_AutoBActionPerformed

    private void CustomBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CustomBActionPerformed
        toggleRecodeMode(false);
    }//GEN-LAST:event_CustomBActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel ArrowL;
    javax.swing.JRadioButton AutoB;
    private javax.swing.JLabel CentralL;
    javax.swing.JRadioButton CustomB;
    javax.swing.JTextField CustomC;
    javax.swing.JTextField CustomF;
    private javax.swing.ButtonGroup Factor;
    private javax.swing.JPanel FromP;
    private javax.swing.JLabel RecodeL;
    private javax.swing.JPanel ToP;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    // End of variables declaration//GEN-END:variables
}
