/*
 *  WriteOptions.java 
 * 
 *  Created on: 14-Jun-2011 at 20:42:07
 * 
 *  
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * This file is part of Jubler.
 * 
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 * 
 * 
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * Contributor(s):
 * 
 */

/*
 * WriteOptions.java
 *
 * Created on 14-Jun-2011, 20:42:07
 */
package com.panayotis.jubler.subs.loader.binary.SON;

import static com.panayotis.jubler.i18n.I18N.__;

/**
 *
 * @author Hoang Tran
 */
public class WriteImageOptions extends javax.swing.JPanel {

    /**
     * @return the showOptionAgain
     */
    public boolean isShowOptionAgain() {
        return showOptionAgain;
    }

    /**
     * @param showOptionAgain the showOptionAgain to set
     */
    public void setShowOptionAgain(boolean showOptionAgain) {
        this.showOptionAgain = showOptionAgain;
    }

    /**
     * @return the writeImageOption
     */
    public WriteImageOption getWriteImageOption() {
        return writeImageOption;
    }

    /**
     * @param writeImageOption the writeImageOption to set
     */
    public void setWriteImageOption(WriteImageOption writeImageOption) {
        this.writeImageOption = writeImageOption;
    }

    public static enum WriteImageOption {

        UNDEFINED,
        GEN_IMAGE_FROM_TEXT,
        WRTIE_OUT_IMAGE,
        DO_NOT_WRITE_IMAGE
    }
    private boolean showOptionAgain = true;
    private WriteImageOption writeImageOption = WriteImageOption.DO_NOT_WRITE_IMAGE;

    /**
     * Creates new form WriteOptions
     */
    public WriteImageOptions() {
        initComponents();
        WriteOptionGroup.add(optWriteOutImage);
        WriteOptionGroup.add(optDoNotWriteImage);
        WriteOptionGroup.add(optGenImageFromText);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        WriteOptionGroup = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        optGenImageFromText = new javax.swing.JRadioButton();
        optWriteOutImage = new javax.swing.JRadioButton();
        optDoNotWriteImage = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        optShowOptionAgain = new javax.swing.JCheckBox();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new java.awt.GridLayout(3, 0));

        optGenImageFromText.setText(__("Generate images (PNG) from text"));
        optGenImageFromText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optGenImageFromTextActionPerformed(evt);
            }
        });
        jPanel1.add(optGenImageFromText);

        optWriteOutImage.setText(__("Write out current images as PNG"));
        optWriteOutImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optWriteOutImageActionPerformed(evt);
            }
        });
        jPanel1.add(optWriteOutImage);

        optDoNotWriteImage.setSelected(true);
        optDoNotWriteImage.setText(__("Do not write images"));
        optDoNotWriteImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optDoNotWriteImageActionPerformed(evt);
            }
        });
        jPanel1.add(optDoNotWriteImage);

        add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel2.setLayout(new java.awt.GridLayout(1, 0));

        optShowOptionAgain.setSelected(true);
        optShowOptionAgain.setText(__("Show options again"));
        optShowOptionAgain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optShowOptionAgainActionPerformed(evt);
            }
        });
        jPanel2.add(optShowOptionAgain);

        add(jPanel2, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void optShowOptionAgainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optShowOptionAgainActionPerformed
        showOptionAgain = optShowOptionAgain.isSelected();
    }//GEN-LAST:event_optShowOptionAgainActionPerformed

    private void optGenImageFromTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optGenImageFromTextActionPerformed
        writeImageOption = WriteImageOption.GEN_IMAGE_FROM_TEXT;
    }//GEN-LAST:event_optGenImageFromTextActionPerformed

    private void optWriteOutImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optWriteOutImageActionPerformed
        writeImageOption = WriteImageOption.WRTIE_OUT_IMAGE;
    }//GEN-LAST:event_optWriteOutImageActionPerformed

    private void optDoNotWriteImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optDoNotWriteImageActionPerformed
        writeImageOption = WriteImageOption.DO_NOT_WRITE_IMAGE;
    }//GEN-LAST:event_optDoNotWriteImageActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup WriteOptionGroup;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton optDoNotWriteImage;
    private javax.swing.JRadioButton optGenImageFromText;
    private javax.swing.JCheckBox optShowOptionAgain;
    private javax.swing.JRadioButton optWriteOutImage;
    // End of variables declaration//GEN-END:variables
}
