/*
 * JFileOptions.java
 *
 * Created on 24 Ιούνιος 2005, 1:11 μμ
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.subs.loader.gui;

import static com.panayotis.jubler.i18n.I18N.__;

import com.panayotis.jubler.os.SystemDependent;
import com.panayotis.jubler.media.MediaFile;
import com.panayotis.jubler.plugins.Theme;
import com.panayotis.jubler.subs.SubFile;
import com.panayotis.jubler.subs.Subtitles;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

/**
 *
 * @author teras
 */
public abstract class JFileOptions extends JPanel implements ActionListener, MouseListener {

    public static final String[] AvailEncodings;

    static {
        SortedMap encs = Charset.availableCharsets();
        AvailEncodings = new String[encs.size()];
        int pos;
        String item;

        pos = 0;
        for (Iterator it = encs.keySet().iterator(); it.hasNext();) {
            item = it.next().toString();
            AvailEncodings[pos++] = item;
        }
    }

    protected abstract void setPreEncoding(String enc);

    /* Use this method to load options and use them on visual components */
    public abstract void updateVisuals(Subtitles subs, MediaFile mfile);


    /* Use this method to apply default options from various controls */
    protected void applyOptions(SubFile sfile) {
        SubFile.saveDefaultOptions();
    }

    public JFileOptions() {
        initComponents();
    }

    protected void setListItem(JComboBox comp, String value) {
        comp.setSelectedItem(value);
        if (!comp.getSelectedItem().toString().equals(value))
            comp.setSelectedItem("US-ASCII");
    }

    protected void setUnicodeVisible(boolean status) {
        Unicode.setVisible(status);
        uSep.setVisible(status);
    }

    protected JButton getPresetsButton() {
        if (Presets.getParent() != null)
            Presets.getParent().remove(Presets);
        return Presets;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        PreEnc = new javax.swing.JPopupMenu();
        Unicode = new javax.swing.JMenu();
        UTF_8 = new javax.swing.JMenuItem();
        UTF_16 = new javax.swing.JMenuItem();
        UTF_32 = new javax.swing.JMenuItem();
        uSep = new javax.swing.JSeparator();
        EuropeW = new javax.swing.JMenu();
        Western = new javax.swing.JMenu();
        ISO_8859_1 = new javax.swing.JMenuItem();
        ISO_8859_15 = new javax.swing.JMenuItem();
        windows_1252 = new javax.swing.JMenuItem();
        IBM850 = new javax.swing.JMenuItem();
        MacRoman = new javax.swing.JMenuItem();
        Celtic = new javax.swing.JMenu();
        ISO_8859_14 = new javax.swing.JMenuItem();
        Greek = new javax.swing.JMenu();
        ISO_8859_7 = new javax.swing.JMenuItem();
        windows_1253 = new javax.swing.JMenuItem();
        MacGreek = new javax.swing.JMenuItem();
        Icelandic = new javax.swing.JMenu();
        MacIcelandic = new javax.swing.JMenuItem();
        Nordic = new javax.swing.JMenu();
        ISO_8859_10 = new javax.swing.JMenuItem();
        EuropeS = new javax.swing.JMenu();
        ISO_8859_3 = new javax.swing.JMenuItem();
        EuropeE = new javax.swing.JMenu();
        Baltic = new javax.swing.JMenu();
        ISO_8859_4 = new javax.swing.JMenuItem();
        ISO_8859_13 = new javax.swing.JMenuItem();
        windows_1257 = new javax.swing.JMenuItem();
        Central_European = new javax.swing.JMenu();
        ISO_8859_2 = new javax.swing.JMenuItem();
        windows_1250 = new javax.swing.JMenuItem();
        IBM852 = new javax.swing.JMenuItem();
        MacCE = new javax.swing.JMenuItem();
        Croatian = new javax.swing.JMenu();
        MacCroatian = new javax.swing.JMenuItem();
        Cyrillic = new javax.swing.JMenu();
        ISO_8859_5 = new javax.swing.JMenuItem();
        windows_1251 = new javax.swing.JMenuItem();
        IBM855 = new javax.swing.JMenuItem();
        IBM866 = new javax.swing.JMenuItem();
        MacCyrillic = new javax.swing.JMenuItem();
        MacUkraine = new javax.swing.JMenuItem();
        KOI8_R = new javax.swing.JMenuItem();
        Romanian = new javax.swing.JMenu();
        ISO_8859_16 = new javax.swing.JMenuItem();
        MacRomania = new javax.swing.JMenuItem();
        AsiaE = new javax.swing.JMenu();
        ChineseS = new javax.swing.JMenu();
        ISO_2022_CN = new javax.swing.JMenuItem();
        GB2312 = new javax.swing.JMenuItem();
        GBK = new javax.swing.JMenuItem();
        GB18030 = new javax.swing.JMenuItem();
        HZ = new javax.swing.JMenuItem();
        ChineseT = new javax.swing.JMenu();
        Big5 = new javax.swing.JMenuItem();
        Big5_HKSCS = new javax.swing.JMenuItem();
        EUC_TW = new javax.swing.JMenuItem();
        Japanese = new javax.swing.JMenu();
        ISO_2022_JP = new javax.swing.JMenuItem();
        EUC_JP = new javax.swing.JMenuItem();
        Shift_JIS = new javax.swing.JMenuItem();
        Korean = new javax.swing.JMenu();
        ISO_2022_KR = new javax.swing.JMenuItem();
        EUC_KR = new javax.swing.JMenuItem();
        UHC = new javax.swing.JMenuItem();
        Johab = new javax.swing.JMenuItem();
        AsiaS = new javax.swing.JMenu();
        Armenian = new javax.swing.JMenu();
        ARMSCII_8 = new javax.swing.JMenuItem();
        Georgian = new javax.swing.JMenu();
        GEOSTD_8 = new javax.swing.JMenuItem();
        Thai = new javax.swing.JMenu();
        ISO_8859_11 = new javax.swing.JMenuItem();
        windows_874 = new javax.swing.JMenuItem();
        TIS_620 = new javax.swing.JMenuItem();
        Turkish = new javax.swing.JMenu();
        ISO_8859_9 = new javax.swing.JMenuItem();
        windows_1254 = new javax.swing.JMenuItem();
        IBM857 = new javax.swing.JMenuItem();
        MacTurkish = new javax.swing.JMenuItem();
        Vietnamese = new javax.swing.JMenu();
        windows_1258 = new javax.swing.JMenuItem();
        TCVN = new javax.swing.JMenuItem();
        VISCII = new javax.swing.JMenuItem();
        VPS = new javax.swing.JMenuItem();
        Hindi = new javax.swing.JMenu();
        MacDevanagari = new javax.swing.JMenuItem();
        Gujarati = new javax.swing.JMenu();
        MacGujarati = new javax.swing.JMenuItem();
        Gurmukhi = new javax.swing.JMenu();
        MacGurmukhi = new javax.swing.JMenuItem();
        MiddleE = new javax.swing.JMenu();
        Arabic = new javax.swing.JMenu();
        ISO_8859_6 = new javax.swing.JMenuItem();
        windows_1256 = new javax.swing.JMenuItem();
        IBM864 = new javax.swing.JMenuItem();
        MacArabic = new javax.swing.JMenuItem();
        Farsi = new javax.swing.JMenu();
        MacFarsi = new javax.swing.JMenuItem();
        Hebrew = new javax.swing.JMenu();
        ISO_8859_8 = new javax.swing.JMenuItem();
        windows_1255 = new javax.swing.JMenuItem();
        IBM862 = new javax.swing.JMenuItem();
        MacHebrew = new javax.swing.JMenuItem();
        Presets = new javax.swing.JButton();

        Unicode.setText(__("Unicode"));

        UTF_8.setText("UTF-8");
        UTF_8.addActionListener(this);
        Unicode.add(UTF_8);

        UTF_16.setText("UTF-16");
        UTF_16.addActionListener(this);
        Unicode.add(UTF_16);

        UTF_32.setText("UTF-32");
        UTF_32.addActionListener(this);
        Unicode.add(UTF_32);

        PreEnc.add(Unicode);
        PreEnc.add(uSep);

        EuropeW.setText(__("West European"));

        Western.setText(__("Western"));

        ISO_8859_1.setText("ISO-8859-1");
        ISO_8859_1.addActionListener(this);
        Western.add(ISO_8859_1);

        ISO_8859_15.setText("ISO-8859-15");
        ISO_8859_15.addActionListener(this);
        Western.add(ISO_8859_15);

        windows_1252.setText("windows-1252");
        windows_1252.addActionListener(this);
        Western.add(windows_1252);

        IBM850.setText("IBM850");
        IBM850.addActionListener(this);
        Western.add(IBM850);

        MacRoman.setText("MacRoman");
        MacRoman.addActionListener(this);
        Western.add(MacRoman);

        EuropeW.add(Western);

        Celtic.setText(__("Celtic"));

        ISO_8859_14.setText("ISO-8859-14");
        ISO_8859_14.addActionListener(this);
        Celtic.add(ISO_8859_14);

        EuropeW.add(Celtic);

        Greek.setText(__("Greek"));

        ISO_8859_7.setText("ISO-8859-7");
        ISO_8859_7.addActionListener(this);
        Greek.add(ISO_8859_7);

        windows_1253.setText("windows-1253");
        windows_1253.addActionListener(this);
        Greek.add(windows_1253);

        MacGreek.setText("MacGreek");
        MacGreek.addActionListener(this);
        Greek.add(MacGreek);

        EuropeW.add(Greek);

        Icelandic.setText(__("Icelandic"));

        MacIcelandic.setText("MacIcelandic");
        MacIcelandic.addActionListener(this);
        Icelandic.add(MacIcelandic);

        EuropeW.add(Icelandic);

        Nordic.setText(__("Nordic"));

        ISO_8859_10.setText("ISO-8859-10");
        ISO_8859_10.addActionListener(this);
        Nordic.add(ISO_8859_10);

        EuropeW.add(Nordic);

        EuropeS.setText(__("South European"));

        ISO_8859_3.setText("ISO-8859-3");
        ISO_8859_3.addActionListener(this);
        EuropeS.add(ISO_8859_3);

        EuropeW.add(EuropeS);

        PreEnc.add(EuropeW);

        EuropeE.setText(__("East European"));

        Baltic.setText(__("Baltic"));

        ISO_8859_4.setText("ISO-8859-4");
        ISO_8859_4.addActionListener(this);
        Baltic.add(ISO_8859_4);

        ISO_8859_13.setText("ISO-8859-13");
        ISO_8859_13.addActionListener(this);
        Baltic.add(ISO_8859_13);

        windows_1257.setText("windows-1257");
        windows_1257.addActionListener(this);
        Baltic.add(windows_1257);

        EuropeE.add(Baltic);

        Central_European.setText(__("Central European"));

        ISO_8859_2.setText("ISO-8859-2");
        ISO_8859_2.addActionListener(this);
        Central_European.add(ISO_8859_2);

        windows_1250.setText("windows-1250");
        windows_1250.addActionListener(this);
        Central_European.add(windows_1250);

        IBM852.setText("IBM852");
        IBM852.addActionListener(this);
        Central_European.add(IBM852);

        MacCE.setText("MacCE");
        MacCE.addActionListener(this);
        Central_European.add(MacCE);

        EuropeE.add(Central_European);

        Croatian.setText(__("Croatian"));

        MacCroatian.setText("MacCroatian");
        MacCroatian.addActionListener(this);
        Croatian.add(MacCroatian);

        EuropeE.add(Croatian);

        Cyrillic.setText(__("Cyrillic"));

        ISO_8859_5.setText("ISO-8859-5");
        ISO_8859_5.addActionListener(this);
        Cyrillic.add(ISO_8859_5);

        windows_1251.setText("windows-1251");
        windows_1251.addActionListener(this);
        Cyrillic.add(windows_1251);

        IBM855.setText("IBM855");
        IBM855.addActionListener(this);
        Cyrillic.add(IBM855);

        IBM866.setText("IBM866");
        IBM866.addActionListener(this);
        Cyrillic.add(IBM866);

        MacCyrillic.setText("MacCyrillic");
        MacCyrillic.addActionListener(this);
        Cyrillic.add(MacCyrillic);

        MacUkraine.setText("MacUkraine");
        MacUkraine.addActionListener(this);
        Cyrillic.add(MacUkraine);

        KOI8_R.setText("KOI8-R");
        KOI8_R.addActionListener(this);
        Cyrillic.add(KOI8_R);

        EuropeE.add(Cyrillic);

        Romanian.setText(__("Romanian"));

        ISO_8859_16.setText("ISO-8859-16");
        ISO_8859_16.addActionListener(this);
        Romanian.add(ISO_8859_16);

        MacRomania.setText("MacRomania");
        MacRomania.addActionListener(this);
        Romanian.add(MacRomania);

        EuropeE.add(Romanian);

        PreEnc.add(EuropeE);

        AsiaE.setText(__("East Asian"));

        ChineseS.setText(__("Chinese Simplified"));

        ISO_2022_CN.setText("ISO-2022-CN");
        ISO_2022_CN.addActionListener(this);
        ChineseS.add(ISO_2022_CN);

        GB2312.setText("GB2312");
        GB2312.addActionListener(this);
        ChineseS.add(GB2312);

        GBK.setText("GBK");
        GBK.addActionListener(this);
        ChineseS.add(GBK);

        GB18030.setText("GB18030");
        GB18030.addActionListener(this);
        ChineseS.add(GB18030);

        HZ.setText("HZ");
        HZ.addActionListener(this);
        ChineseS.add(HZ);

        AsiaE.add(ChineseS);

        ChineseT.setText(__("Chinese Traditional"));

        Big5.setText("Big5");
        Big5.addActionListener(this);
        ChineseT.add(Big5);

        Big5_HKSCS.setText("Big5-HKSCS");
        Big5_HKSCS.addActionListener(this);
        ChineseT.add(Big5_HKSCS);

        EUC_TW.setText("EUC-TW");
        EUC_TW.addActionListener(this);
        ChineseT.add(EUC_TW);

        AsiaE.add(ChineseT);

        Japanese.setText(__("Japanese"));

        ISO_2022_JP.setText("ISO-2022-JP");
        ISO_2022_JP.addActionListener(this);
        Japanese.add(ISO_2022_JP);

        EUC_JP.setText("EUC-JP");
        EUC_JP.addActionListener(this);
        Japanese.add(EUC_JP);

        Shift_JIS.setText("Shift_JIS");
        Shift_JIS.addActionListener(this);
        Japanese.add(Shift_JIS);

        AsiaE.add(Japanese);

        Korean.setText(__("Korean"));

        ISO_2022_KR.setText("ISO-2022-KR");
        ISO_2022_KR.addActionListener(this);
        Korean.add(ISO_2022_KR);

        EUC_KR.setText("EUC-KR");
        EUC_KR.addActionListener(this);
        Korean.add(EUC_KR);

        UHC.setText("UHC");
        UHC.addActionListener(this);
        Korean.add(UHC);

        Johab.setText("Johab");
        Johab.addActionListener(this);
        Korean.add(Johab);

        AsiaE.add(Korean);

        PreEnc.add(AsiaE);

        AsiaS.setText(__("SE and SW Asian"));

        Armenian.setText(__("Armenian"));

        ARMSCII_8.setText("ARMSCII-8");
        ARMSCII_8.addActionListener(this);
        Armenian.add(ARMSCII_8);

        AsiaS.add(Armenian);

        Georgian.setText(__("Georgian"));

        GEOSTD_8.setText("GEOSTD-8");
        GEOSTD_8.addActionListener(this);
        Georgian.add(GEOSTD_8);

        AsiaS.add(Georgian);

        Thai.setText(__("Thai"));

        ISO_8859_11.setText("ISO-8859-11");
        ISO_8859_11.addActionListener(this);
        Thai.add(ISO_8859_11);

        windows_874.setText("windows-874");
        windows_874.addActionListener(this);
        Thai.add(windows_874);

        TIS_620.setText("TIS-620");
        TIS_620.addActionListener(this);
        Thai.add(TIS_620);

        AsiaS.add(Thai);

        Turkish.setText(__("Turkish"));

        ISO_8859_9.setText("ISO-8859-9");
        ISO_8859_9.addActionListener(this);
        Turkish.add(ISO_8859_9);

        windows_1254.setText("windows-1254");
        windows_1254.addActionListener(this);
        Turkish.add(windows_1254);

        IBM857.setText("IBM857");
        IBM857.addActionListener(this);
        Turkish.add(IBM857);

        MacTurkish.setText("MacTurkish");
        MacTurkish.addActionListener(this);
        Turkish.add(MacTurkish);

        AsiaS.add(Turkish);

        Vietnamese.setText(__("Vietnamese"));

        windows_1258.setText("windows-1258");
        windows_1258.addActionListener(this);
        Vietnamese.add(windows_1258);

        TCVN.setText("TCVN");
        TCVN.addActionListener(this);
        Vietnamese.add(TCVN);

        VISCII.setText("VISCII");
        VISCII.addActionListener(this);
        Vietnamese.add(VISCII);

        VPS.setText("VPS");
        VPS.addActionListener(this);
        Vietnamese.add(VPS);

        AsiaS.add(Vietnamese);

        Hindi.setText(__("Hindi"));

        MacDevanagari.setText("MacDevanagari");
        MacDevanagari.addActionListener(this);
        Hindi.add(MacDevanagari);

        AsiaS.add(Hindi);

        Gujarati.setText(__("Gujarati"));

        MacGujarati.setText("MacGujarati");
        MacGujarati.addActionListener(this);
        Gujarati.add(MacGujarati);

        AsiaS.add(Gujarati);

        Gurmukhi.setText(__("Gurmukhi"));

        MacGurmukhi.setText("MacGurmukhi");
        MacGurmukhi.addActionListener(this);
        Gurmukhi.add(MacGurmukhi);

        AsiaS.add(Gurmukhi);

        PreEnc.add(AsiaS);

        MiddleE.setText(__("Middle Eastern"));

        Arabic.setText(__("Arabic"));

        ISO_8859_6.setText("ISO-8859-6");
        ISO_8859_6.addActionListener(this);
        Arabic.add(ISO_8859_6);

        windows_1256.setText("windows-1256");
        windows_1256.addActionListener(this);
        Arabic.add(windows_1256);

        IBM864.setText("IBM864");
        IBM864.addActionListener(this);
        Arabic.add(IBM864);

        MacArabic.setText("MacArabic");
        MacArabic.addActionListener(this);
        Arabic.add(MacArabic);

        MiddleE.add(Arabic);

        Farsi.setText(__("Farsi"));

        MacFarsi.setText("MacFarsi");
        MacFarsi.addActionListener(this);
        Farsi.add(MacFarsi);

        MiddleE.add(Farsi);

        Hebrew.setText(__("Hebrew"));

        ISO_8859_8.setText("ISO-8859-8");
        ISO_8859_8.addActionListener(this);
        Hebrew.add(ISO_8859_8);

        windows_1255.setText("windows-1255");
        windows_1255.addActionListener(this);
        Hebrew.add(windows_1255);

        IBM862.setText("IBM862");
        IBM862.addActionListener(this);
        Hebrew.add(IBM862);

        MacHebrew.setText("MacHebrew");
        MacHebrew.addActionListener(this);
        Hebrew.add(MacHebrew);

        MiddleE.add(Hebrew);

        PreEnc.add(MiddleE);

        Presets.setIcon(Theme.loadIcon("encs.png"));
        Presets.setToolTipText(__("Use predefined encodings"));
        SystemDependent.setCommandButtonStyle(Presets, "only");
        Presets.addMouseListener(this);
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == UTF_8) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == UTF_16) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == UTF_32) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_1) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_15) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1252) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM850) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacRoman) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_14) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_7) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1253) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacGreek) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacIcelandic) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_10) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_3) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_4) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_13) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1257) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_2) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1250) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM852) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacCE) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacCroatian) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_5) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1251) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM855) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM866) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacCyrillic) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacUkraine) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == KOI8_R) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_16) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacRomania) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_2022_CN) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == GB2312) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == GBK) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == GB18030) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == HZ) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == Big5) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == Big5_HKSCS) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == EUC_TW) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_2022_JP) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == EUC_JP) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == Shift_JIS) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_2022_KR) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == EUC_KR) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == UHC) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == Johab) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ARMSCII_8) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == GEOSTD_8) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_11) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_874) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == TIS_620) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_9) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1254) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM857) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacTurkish) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1258) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == TCVN) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == VISCII) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == VPS) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacDevanagari) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacGujarati) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacGurmukhi) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_6) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1256) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM864) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacArabic) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacFarsi) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == ISO_8859_8) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == windows_1255) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == IBM862) {
            JFileOptions.this.selectPreEncodings(evt);
        }
        else if (evt.getSource() == MacHebrew) {
            JFileOptions.this.selectPreEncodings(evt);
        }
    }

    public void mouseClicked(java.awt.event.MouseEvent evt) {
    }

    public void mouseEntered(java.awt.event.MouseEvent evt) {
    }

    public void mouseExited(java.awt.event.MouseEvent evt) {
    }

    public void mousePressed(java.awt.event.MouseEvent evt) {
        if (evt.getSource() == Presets) {
            JFileOptions.this.PresetsMousePressed(evt);
        }
    }

    public void mouseReleased(java.awt.event.MouseEvent evt) {
    }// </editor-fold>//GEN-END:initComponents

    private void PresetsMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PresetsMousePressed
        if (Presets.isEnabled())
            PreEnc.show(Presets, Presets.getBorder().getBorderInsets(Presets).left / 2, Presets.getHeight() - Presets.getBorder().getBorderInsets(Presets).bottom + 1);
    }//GEN-LAST:event_PresetsMousePressed

    private void selectPreEncodings(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectPreEncodings
        String enc = evt.getActionCommand();
        if (enc.startsWith("Mac")
                || enc.equals("Johab")
                || enc.endsWith("874"))
            enc = "x-" + enc;
        setPreEncoding(enc);
    }//GEN-LAST:event_selectPreEncodings
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem ARMSCII_8;
    private javax.swing.JMenu Arabic;
    private javax.swing.JMenu Armenian;
    private javax.swing.JMenu AsiaE;
    private javax.swing.JMenu AsiaS;
    private javax.swing.JMenu Baltic;
    private javax.swing.JMenuItem Big5;
    private javax.swing.JMenuItem Big5_HKSCS;
    private javax.swing.JMenu Celtic;
    private javax.swing.JMenu Central_European;
    private javax.swing.JMenu ChineseS;
    private javax.swing.JMenu ChineseT;
    private javax.swing.JMenu Croatian;
    private javax.swing.JMenu Cyrillic;
    private javax.swing.JMenuItem EUC_JP;
    private javax.swing.JMenuItem EUC_KR;
    private javax.swing.JMenuItem EUC_TW;
    private javax.swing.JMenu EuropeE;
    private javax.swing.JMenu EuropeS;
    private javax.swing.JMenu EuropeW;
    private javax.swing.JMenu Farsi;
    private javax.swing.JMenuItem GB18030;
    private javax.swing.JMenuItem GB2312;
    private javax.swing.JMenuItem GBK;
    private javax.swing.JMenuItem GEOSTD_8;
    private javax.swing.JMenu Georgian;
    private javax.swing.JMenu Greek;
    private javax.swing.JMenu Gujarati;
    private javax.swing.JMenu Gurmukhi;
    private javax.swing.JMenuItem HZ;
    private javax.swing.JMenu Hebrew;
    private javax.swing.JMenu Hindi;
    private javax.swing.JMenuItem IBM850;
    private javax.swing.JMenuItem IBM852;
    private javax.swing.JMenuItem IBM855;
    private javax.swing.JMenuItem IBM857;
    private javax.swing.JMenuItem IBM862;
    private javax.swing.JMenuItem IBM864;
    private javax.swing.JMenuItem IBM866;
    private javax.swing.JMenuItem ISO_2022_CN;
    private javax.swing.JMenuItem ISO_2022_JP;
    private javax.swing.JMenuItem ISO_2022_KR;
    private javax.swing.JMenuItem ISO_8859_1;
    private javax.swing.JMenuItem ISO_8859_10;
    private javax.swing.JMenuItem ISO_8859_11;
    private javax.swing.JMenuItem ISO_8859_13;
    private javax.swing.JMenuItem ISO_8859_14;
    private javax.swing.JMenuItem ISO_8859_15;
    private javax.swing.JMenuItem ISO_8859_16;
    private javax.swing.JMenuItem ISO_8859_2;
    private javax.swing.JMenuItem ISO_8859_3;
    private javax.swing.JMenuItem ISO_8859_4;
    private javax.swing.JMenuItem ISO_8859_5;
    private javax.swing.JMenuItem ISO_8859_6;
    private javax.swing.JMenuItem ISO_8859_7;
    private javax.swing.JMenuItem ISO_8859_8;
    private javax.swing.JMenuItem ISO_8859_9;
    private javax.swing.JMenu Icelandic;
    private javax.swing.JMenu Japanese;
    private javax.swing.JMenuItem Johab;
    private javax.swing.JMenuItem KOI8_R;
    private javax.swing.JMenu Korean;
    private javax.swing.JMenuItem MacArabic;
    private javax.swing.JMenuItem MacCE;
    private javax.swing.JMenuItem MacCroatian;
    private javax.swing.JMenuItem MacCyrillic;
    private javax.swing.JMenuItem MacDevanagari;
    private javax.swing.JMenuItem MacFarsi;
    private javax.swing.JMenuItem MacGreek;
    private javax.swing.JMenuItem MacGujarati;
    private javax.swing.JMenuItem MacGurmukhi;
    private javax.swing.JMenuItem MacHebrew;
    private javax.swing.JMenuItem MacIcelandic;
    private javax.swing.JMenuItem MacRoman;
    private javax.swing.JMenuItem MacRomania;
    private javax.swing.JMenuItem MacTurkish;
    private javax.swing.JMenuItem MacUkraine;
    private javax.swing.JMenu MiddleE;
    private javax.swing.JMenu Nordic;
    private javax.swing.JPopupMenu PreEnc;
    private javax.swing.JButton Presets;
    private javax.swing.JMenu Romanian;
    private javax.swing.JMenuItem Shift_JIS;
    private javax.swing.JMenuItem TCVN;
    private javax.swing.JMenuItem TIS_620;
    private javax.swing.JMenu Thai;
    private javax.swing.JMenu Turkish;
    private javax.swing.JMenuItem UHC;
    private javax.swing.JMenuItem UTF_16;
    private javax.swing.JMenuItem UTF_32;
    private javax.swing.JMenuItem UTF_8;
    private javax.swing.JMenu Unicode;
    private javax.swing.JMenuItem VISCII;
    private javax.swing.JMenuItem VPS;
    private javax.swing.JMenu Vietnamese;
    private javax.swing.JMenu Western;
    private javax.swing.JSeparator uSep;
    private javax.swing.JMenuItem windows_1250;
    private javax.swing.JMenuItem windows_1251;
    private javax.swing.JMenuItem windows_1252;
    private javax.swing.JMenuItem windows_1253;
    private javax.swing.JMenuItem windows_1254;
    private javax.swing.JMenuItem windows_1255;
    private javax.swing.JMenuItem windows_1256;
    private javax.swing.JMenuItem windows_1257;
    private javax.swing.JMenuItem windows_1258;
    private javax.swing.JMenuItem windows_874;
    // End of variables declaration//GEN-END:variables
//   protected abstract String getDialogVisible
}
