/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jarbundler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.jarbundler.AppBundleProperties;
import net.sourceforge.jarbundler.DocumentType;
import net.sourceforge.jarbundler.Service;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyListWriter {
    private AppBundleProperties bundleProperties;
    private double version = 1.3;
    private Document document = null;
    private FileUtils fileUtils = FileUtils.getFileUtils();

    public PropertyListWriter(AppBundleProperties appBundleProperties) {
        this.bundleProperties = appBundleProperties;
        this.setJavaVersion(appBundleProperties.getJVMVersion());
    }

    private void setJavaVersion(String string) {
        if (string == null) {
            return;
        }
        this.version = Double.valueOf(string.substring(0, 3));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFile(File file) throws BuildException {
        BufferedWriter bufferedWriter = null;
        try {
            this.document = this.createDOM();
            this.buildDOM();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            transformer.transform(new DOMSource(this.document), new StreamResult(bufferedWriter));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            try {
                throw new BuildException((Throwable)transformerConfigurationException);
                catch (TransformerException transformerException) {
                    throw new BuildException((Throwable)transformerException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new BuildException((Throwable)parserConfigurationException);
                }
                catch (IOException iOException) {
                    throw new BuildException("Unable to write  \"" + file + "\"");
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedWriter);
                throw throwable;
            }
        }
        FileUtils.close((Writer)bufferedWriter);
    }

    private Document createDOM() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        org.w3c.dom.DocumentType documentType = dOMImplementation.createDocumentType("plist", "-//Apple Computer//DTD PLIST 1.0//EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
        return dOMImplementation.createDocument(null, "plist", documentType);
    }

    private void buildDOM() {
        List list;
        Hashtable hashtable;
        List list2;
        List list3;
        List list4;
        Element element = this.document.getDocumentElement();
        element.setAttribute("version", "1.0");
        Node node = this.createNode("dict", element);
        this.writeKeyStringPair("CFBundleName", this.bundleProperties.getCFBundleName(), node);
        this.writeKeyStringPair("CFBundleShortVersionString", this.bundleProperties.getCFBundleShortVersionString(), node);
        this.writeKeyStringPair("CFBundleGetInfoString", this.bundleProperties.getCFBundleGetInfoString(), node);
        this.writeKeyStringPair("CFBundleAllowMixedLocalizations", this.bundleProperties.getCFBundleAllowMixedLocalizations() ? "true" : "false", node);
        this.writeKeyStringPair("CFBundleInfoDictionaryVersion", this.bundleProperties.getCFBundleInfoDictionaryVersion(), node);
        this.writeKeyStringPair("CFBundleExecutable", this.bundleProperties.getCFBundleExecutable(), node);
        this.writeKeyStringPair("CFBundleDevelopmentRegion", this.bundleProperties.getCFBundleDevelopmentRegion(), node);
        this.writeKeyStringPair("CFBundlePackageType", this.bundleProperties.getCFBundlePackageType(), node);
        this.writeKeyStringPair("CFBundleSignature", this.bundleProperties.getCFBundleSignature(), node);
        if (this.bundleProperties.getCFBundleVersion() != null) {
            this.writeKeyStringPair("CFBundleVersion", this.bundleProperties.getCFBundleVersion(), node);
        }
        if (this.bundleProperties.getCFBundleIconFile() != null) {
            this.writeKeyStringPair("CFBundleIconFile", this.bundleProperties.getCFBundleIconFile(), node);
        }
        if (this.bundleProperties.getCFBundleIdentifier() != null) {
            this.writeKeyStringPair("CFBundleIdentifier", this.bundleProperties.getCFBundleIdentifier(), node);
        }
        if (this.bundleProperties.getCFBundleHelpBookFolder() != null) {
            this.writeKeyStringPair("CFBundleHelpBookFolder", this.bundleProperties.getCFBundleHelpBookFolder(), node);
        }
        if (this.bundleProperties.getCFBundleHelpBookName() != null) {
            this.writeKeyStringPair("CFBundleHelpBookName", this.bundleProperties.getCFBundleHelpBookName(), node);
        }
        if (this.bundleProperties.getNSHumanReadableCopyright() != null) {
            this.writeKeyStringPair("NSHumanReadableCopyright", this.bundleProperties.getNSHumanReadableCopyright(), node);
        }
        if (this.bundleProperties.getLSUIElement() != null) {
            this.writeKeyBooleanPair("LSUIElement", this.bundleProperties.getLSUIElement(), node);
        }
        if ((list4 = this.bundleProperties.getDocumentTypes()).size() > 0) {
            this.writeDocumentTypes(list4, node);
        }
        this.writeKey("Java", node);
        Node node2 = this.createNode("dict", node);
        this.writeKeyStringPair("MainClass", this.bundleProperties.getMainClass(), node2);
        if (this.bundleProperties.getJVMVersion() != null) {
            this.writeKeyStringPair("JVMVersion", this.bundleProperties.getJVMVersion(), node2);
        }
        if ((list3 = this.bundleProperties.getJVMArchs()) != null && !list3.isEmpty()) {
            this.writeJVMArchs(list3, node2);
        }
        if ((list2 = this.bundleProperties.getLSArchitecturePriority()) != null && !list2.isEmpty()) {
            this.writeLSArchitecturePriority(list2, node2);
        }
        List list5 = this.bundleProperties.getClassPath();
        List list6 = this.bundleProperties.getExtraClassPath();
        if (list5.size() > 0 || list6.size() > 0) {
            this.writeClasspath(list5, list6, node2);
        }
        if (this.bundleProperties.getVMOptions() != null) {
            this.writeKeyStringPair("VMOptions", this.bundleProperties.getVMOptions(), node2);
        }
        if (this.bundleProperties.getWorkingDirectory() != null) {
            this.writeKeyStringPair("WorkingDirectory", this.bundleProperties.getWorkingDirectory(), node2);
        }
        if (this.bundleProperties.getStartOnMainThread() != null) {
            this.writeKey("StartOnMainThread", node2);
            this.createNode(this.bundleProperties.getStartOnMainThread().toString(), node2);
        }
        if (this.bundleProperties.getSplashFile() != null) {
            this.writeKeyStringPair("SplashFile", this.bundleProperties.getSplashFile(), node2);
        }
        if (this.bundleProperties.getArguments() != null) {
            this.writeKeyStringPair("Arguments", this.bundleProperties.getArguments(), node2);
        }
        if (!(hashtable = this.bundleProperties.getJavaProperties()).isEmpty()) {
            this.writeJavaProperties(hashtable, node2);
        }
        if ((list = this.bundleProperties.getServices()).size() > 0) {
            this.writeServices(list, node);
        }
    }

    private void writeDocumentTypes(List list, Node node) {
        this.writeKey("CFBundleDocumentTypes", node);
        Node node2 = this.createNode("array", node);
        for (DocumentType documentType : list) {
            List list2;
            List list3;
            List list4;
            List list5;
            Node node3 = this.createNode("dict", node2);
            this.writeKeyStringPair("CFBundleTypeName", documentType.getName(), node3);
            this.writeKeyStringPair("CFBundleTypeRole", documentType.getRole(), node3);
            File file = documentType.getIconFile();
            if (file != null) {
                this.writeKeyStringPair("CFBundleTypeIconFile", file.getName(), node3);
            }
            if (!(list5 = documentType.getExtensions()).isEmpty()) {
                this.writeKey("CFBundleTypeExtensions", node3);
                this.writeArray(list5, node3);
            }
            if (!(list4 = documentType.getOSTypes()).isEmpty()) {
                this.writeKey("CFBundleTypeOSTypes", node3);
                this.writeArray(list4, node3);
            }
            if (!(list3 = documentType.getMimeTypes()).isEmpty()) {
                this.writeKey("CFBundleTypeMIMETypes", node3);
                this.writeArray(list3, node3);
            }
            if (!(list2 = documentType.getUTIs()).isEmpty()) {
                this.writeKey("LSItemContentTypes", node3);
                this.writeArray(list2, node3);
            }
            if (!documentType.isBundle()) continue;
            this.writeKeyStringPair("LSTypeIsPackage", "true", node3);
        }
    }

    private void writeServices(List list, Node node) {
        this.writeKey("NSServices", node);
        Node node2 = this.createNode("array", node);
        for (Service service : list) {
            String string;
            Object object;
            List list2;
            Node node3 = this.createNode("dict", node2);
            String string2 = service.getPortName();
            if (string2 == null) {
                string2 = this.bundleProperties.getCFBundleName();
            }
            this.writeKeyStringPair("NSPortName", string2, node3);
            this.writeKeyStringPair("NSMessage", service.getMessage(), node3);
            List list3 = service.getSendTypes();
            if (!list3.isEmpty()) {
                this.writeKey("NSSendTypes", node3);
                this.writeArray(list3, node3);
            }
            if (!(list2 = service.getReturnTypes()).isEmpty()) {
                this.writeKey("NSReturnTypes", node3);
                this.writeArray(list2, node3);
            }
            this.writeKey("NSMenuItem", node3);
            Node node4 = this.createNode("dict", node3);
            this.writeKeyStringPair("default", service.getMenuItem(), node4);
            String string3 = service.getKeyEquivalent();
            if (null != string3) {
                this.writeKey("NSKeyEquivalent", node3);
                object = this.createNode("dict", node3);
                this.writeKeyStringPair("default", string3, (Node)object);
            }
            if (null != (object = service.getUserData())) {
                this.writeKeyStringPair("NSUserData", (String)object, node3);
            }
            if (null == (string = service.getTimeout())) continue;
            this.writeKeyStringPair("NSTimeout", string, node3);
        }
    }

    private void writeClasspath(List list, List list2, Node node) {
        this.writeKey("ClassPath", node);
        list.addAll(list2);
        this.writeArray(list, node);
    }

    private void writeJavaProperties(Hashtable hashtable, Node node) {
        this.writeKey("Properties", node);
        Node node2 = this.createNode("dict", node);
        for (String string : hashtable.keySet()) {
            if (string.startsWith("com.apple.") && this.version >= 1.4) {
                System.out.println("Deprecated as of 1.4: " + string);
                continue;
            }
            this.writeKeyStringPair(string, (String)hashtable.get(string), node2);
        }
    }

    private void writeJVMArchs(List list, Node node) {
        this.writeKey("JVMArchs", node);
        this.writeArray(list, node);
    }

    private void writeLSArchitecturePriority(List list, Node node) {
        this.writeKey("LSArchitecturePriority", node);
        this.writeArray(list, node);
    }

    private Node createNode(String string, Node node) {
        Element element = this.document.createElement(string);
        node.appendChild(element);
        return element;
    }

    private void writeKeyStringPair(String string, String string2, Node node) {
        if (string2 == null) {
            return;
        }
        this.writeKey(string, node);
        this.writeString(string2, node);
    }

    private void writeKeyBooleanPair(String string, Boolean bl, Node node) {
        if (bl == null) {
            return;
        }
        this.writeKey(string, node);
        this.writeBoolean(bl, node);
    }

    private void writeKey(String string, Node node) {
        Element element = this.document.createElement("key");
        node.appendChild(element);
        element.appendChild(this.document.createTextNode(string));
    }

    private void writeString(String string, Node node) {
        Element element = this.document.createElement("string");
        element.appendChild(this.document.createTextNode(string));
        node.appendChild(element);
    }

    private void writeArray(List list, Node node) {
        Node node2 = this.createNode("array", node);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.writeString((String)iterator.next(), node2);
        }
    }

    private void writeBoolean(Boolean bl, Node node) {
        Element element = null;
        element = bl != false ? this.document.createElement("true") : this.document.createElement("false");
        node.appendChild(element);
    }
}

