/***************************************************************************
                          qiconpreview.cpp  -  description
                             -------------------
    begin                : Thu Jun 27 2002
    copyright            : (C) 2002 by Vadim A. Khohlov
    email                : xvadim@newmail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qpixmap.h>

#include "qiconpreview.h"
#include "noIcon.xpm"

QIconPreview::QIconPreview(QWidget *parent, const char *name ):
QWidget(parent,name), QFilePreview()
{
    // label for displaying preview pixmap
    label = new QLabel(this);
    label->setFixedSize(32,32);
    label->setMinimumWidth(35);
    label->setFrameStyle(QFrame::Panel | QFrame::Raised);
//    label->setLineWidth(2);
    label->setScaledContents(true);
    label->setPixmap(QPixmap(noIcon));
}/* constructor */

QIconPreview::~QIconPreview()
{
}/* destructor */

void QIconPreview::previewUrl(const QUrl &u)
{
  QString path = u.path();
  QPixmap pix(path);
  if (pix.isNull())
    label->setPixmap(QPixmap(noIcon));
  else
    label->setPixmap(pix);
}/* previewUrl(const QUrl &u) */

