/***************************************************************************
                          qcentralwidget.h  -  description
                             -------------------
    begin                : Sun May 19 2002
    copyright            : (C) 2002 by Vadim A. Khohlov
    email                : xvadim@newmail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QCENTRALWIDGET_H
#define QCENTRALWIDGET_H

#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qvaluestack.h>
#include <qmessagebox.h>
#include <qlistview.h>
#include <qpalette.h>

class QLineEdit;
class QComboBox;
class QCheckBox;
class QTextStream;
class QFile;
class QPushButton;
class QFileDialog;

/**
 * A ListView item for menu's statements.
 */
class IceListViewItem: public QListViewItem
{
public:
	IceListViewItem(IceListViewItem * parent, IceListViewItem * after,
		   	QString label1, QString label2 = QString::null,
			QString label3 = QString::null, QString label4 = QString::null,
			QString label5 = QString::null, QString label6 = QString::null,
			QString label7 = QString::null, QString label8 = QString::null):
		QListViewItem(parent, after,label1, label2, label3, label4, label5,
				label6, label7, label8)
		{	}
	
	IceListViewItem(QListView* parent,
		   	QString label1, QString label2 = QString::null,
			QString label3 = QString::null, QString label4 = QString::null,
			QString label5 = QString::null, QString label6 = QString::null,
			QString label7 = QString::null, QString label8 = QString::null):
		QListViewItem(parent, label1, label2, label3, label4, label5,
				label6, label7, label8)
		{	}
	/**
	 * draws cell.
	 */
	virtual void paintCell(QPainter *p, const QColorGroup &cg,
			int column, int width, int alignment );
}; /* class IceListViewItem: public QListViewItem */

/**
 *The central widget with all controls.
 *@author Vadim A. Khohlov
 */

class QCentralWidget : public QWidget  {
   Q_OBJECT
public:
	QCentralWidget(QWidget *parent, const char *name, QString &cfgDir);
	~QCentralWidget();
  /**
   * Loads main menu from file menuFileName.
   */
  void loadMainMenuFromFile(QString &menuFileName);
  void saveMenu();
  /**
   * Saves menu under new name.
   */
  void saveMenuAs(QString &menuFileName);

  /**
   * Checks dirty flag and saves menu if necessary.
   */
  void checkDirty();
  /**
   * Copy the selected item into the Clipboard.
   */
  void copy();
  /**
   * Cut the selected item into the clipboard.
   */
  void cut();
  /**
   * paste the clipboard into menu.
   */
  void paste();
private: // Private attributes
  /** 
   * Contains a menu's or toolbar's items
   */
  QListView *lvMenu;
  /** 
   * Editor of menu item
   */
  QLineEdit *edItemName;
  /**
   * Editor of icon's filename
   */
  QLineEdit *edIcon;
  /**
   * Editor of program name
   */
  QLineEdit *edExec;
  /** 
   * Types of menu items.
   */
  QComboBox *cbItemType;
  /**
   * Editor for program's keys.
   */
  QLineEdit *edKeys;
  QCheckBox *cbCtrl,
  			*cbAlt,
			*cbShift;
			
  QLineEdit *edResName;
  QLineEdit *edResClass;
  QLineEdit *edTimeOut;
  QPushButton *pbRunXprop;
  QPushButton *pbEdit;
  QPushButton *pbBack;

  QCheckBox *cbRecentMenu;
  /**
   * System menu items: Programs, Themes, Logout, Help, etc.
   */
  QCheckBox *sysMenuItems[8];
  /**  */
  QTextStream *menuStream;
  /**  */
  QFile *menuFile;
  QString menuWord;
  QStringList menuStatement;
  int menuStatementNum;
  int menuWordType;   //type of menu's word - prog, menu etc.
  /** 
   * Contains the value of $PATH.
   */
  QString path;
  /**
   * The list of dirs from $PATH.
   */
  QStringList pathLst;
  /** 
   * The list of paths for icons.
   */
  QStringList iconPathsLst;
  /**
   * The icon's paths.
   */
  QString     iconPath;
  /**
   * a dirty flag - true if menu changed.
   */
  bool isDirty;
  QString execPath;
  int nTabs;		//number of tabs before string
  QString iPath;	//path to icons
  /**
   * The icons' library path.
   */
  QString     iconLibPath;
  QFileDialog *dialog; 
  QString icewmCfgDir;
  /**
   * The private icons' library path (~/.icewm/icons).
   */
  QString	  iconPrivLibPath;

  int nestLevel;	//level of nesting

  /**
   * Dictionary of keys for programs.
   */
   QDict<QString> dictKeys;

	/**
	 * Stack of edited files.
	 */
	QValueStack<QString> stEditedFiles;
  
private: // Private methods
  /** 
   * Loads from file menuFileName main menu 
   * and specified in include and menuprog sttements.
   */
  void loadMenuFromFile(QString &menuFileName);
  /** 
   * Loads menu from menuStream into lvMenu.
   */
  void loadMenuFromStream(IceListViewItem *parentItem);
  /**
   * Loads keys into dictionary.
   */
  void loadKeys(QString &menuFileName);
  /**
   * Saves keys into file respective menuFileName.
   */
  void saveKeys(QString &menuFileName);
  /**
   * Sets keys for current item.
   */
  void setKeys();
  /** 
   * Reads next word from menu's file and returns type of this word.
   */
  int getWord();
  /** No descriptions */
  void saveMenuIntoStream(IceListViewItem *rootItem);
  /**
   * Saves system menu items (ShowHelp, ShowPrograms etc.).
   */
  void saveSysMenu();
  /** 
   * Sets icon iconName for item it.
   */
  void setItemIcon(QString &iconName, IceListViewItem *it);
  /** 
   * Loads IconPath's list.
   */
  void loadIconPath(QString &menuFileName);
  /**
   * Returns true if command executable otherwise returns false.
   */
  bool isExecutable(const QString &command);
  /**
   * Checks appropriate controls for shortcut 'key'.
   */
  void checkKeys(const QString *key);
private slots: // Private slots
  /** No descriptions */
  void slotCurrentChanged(QListViewItem *curItem);
  /** 
   * Inserts new empty item into menu.
   */
  void slotAddItem();
  /** 
   * Sets the current setting into current menuitem.
   */
  void slotSet();
  /** 
   * Browses icon for menu.
   */
  void slotBrowseIcon();
  /** 
   * Browses executables for menu.
   */
  void slotBrowseExec();
  /** No descriptions */
  void slotItemTypeChanged(int newType);
  /** No descriptions */
  void slotDel();
  /**
   * Runs xprop.
   */
  void slotRunXprop();
  /**
   * Starts to edit new file.
   */
  void slotEdit();
  /**
   * Backs to previous editing file.
   */
  void slotBack();
  /**
   * The checkbox is changed.
   */
  void slotCheckBoxChanged();
};

inline
void QCentralWidget::loadMainMenuFromFile(QString &menuFileName)
{
	stEditedFiles.clear();
	loadMenuFromFile(menuFileName);
} /* void QCentralWidget::loadMainMenuFromFile(QString &menuFileName) */

inline
void QCentralWidget::saveMenuAs(QString &menuFileName)
{
	checkDirty();
	stEditedFiles.pop();
	stEditedFiles.push(menuFileName);
	saveMenu();
} /* void QCentralWidget::saveMenuAs(QString &menuFileName) */

/**
* Checks dirty flag and saves menu if necessary.
*/
inline
void QCentralWidget::checkDirty()
{
	if(isDirty && QMessageBox::warning(this, tr("Attention!"),
					tr("Content was changed.\nDo you want to save it?"),
					QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)
		saveMenu();
} /* IcemcApp ::checkDirty() */
	
#endif
