/***************************************************************************
                          qcentralwidget.cpp  -  description
                             -------------------
    begin                : Sun May 19 2002
    copyright            : (C) 2002 by Vadim A. Khohlov
    email                : xvadim@newmail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlistview.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qimage.h>
#include <qapp.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qcolor.h>
#include <qclipboard.h>

#include <qtextstream.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qvalidator.h>

#include <stdlib.h>
#include <unistd.h>

#include "icemc.h"
#include "qcentralwidget.h"
#include "fileopen.xpm"
#include "folder.xpm"
#include "qiconpreview.h"

static const QString topItemName("IceWM's menu/toolbar");
static const QString icerrun("icerrun.py");
static const QString separator("-----");

static const char *mSt[] = {
						"prog",
						"menu",
						"menufile",
						"menuprog",
						"runonce",
						"separator",
						"restart",
						"include",
						"menuprogreload"
					};

static const char *sysMItems[] = {
									"About",
									"Lo&gout",
									"Logout submenu",
									"Programs",
									"Themes",
									"Help",
									"Run",
									"Windo&ws"
								 };

QCentralWidget::QCentralWidget(QWidget *parent, const char *name, QString &cfgDir):
QWidget(parent,name),
path(getenv("PATH")),
isDirty(false),
execPath("/usr/bin"),
nTabs(0),
iPath("/usr/share/icons"),
iconLibPath("/usr/local/share/icewm/icons/"),
dialog(0),
icewmCfgDir(cfgDir),
iconPrivLibPath(cfgDir + "/icons/")
{
	unsigned i;
	for(i = 0; i < sizeof(mSt)/sizeof(mSt[0]); i++)
		menuStatement += mSt[i];
	pathLst = QStringList::split(":", path);

	QVBoxLayout *topLayout = new QVBoxLayout(this);
    CHECK_PTR(topLayout);
	
	QLabel *lbName = new QLabel("Ite&ms of menu/toolbar", this);
	lbName->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	topLayout->addWidget(lbName);
    
	/* menu treeview */
    lvMenu = new QListView(this, "lvMenu");
    CHECK_PTR(lvMenu);
    lvMenu->addColumn(tr("Item's name"));
    lvMenu->addColumn(tr("Icon"));
    lvMenu->addColumn(tr("Executable"));
	lvMenu->setSorting(-1);
    lvMenu->setRootIsDecorated(true);
	IceListViewItem *rootIt=new IceListViewItem(lvMenu, topItemName,
				                            "", "", "999"); 	
	lvMenu->setCurrentItem(rootIt);
	rootIt->setOpen(true);
    topLayout->addWidget(lvMenu);
	lbName->setBuddy(lvMenu);

    QHBox *hb = new QHBox(this);
    CHECK_PTR(hb);
    topLayout->addWidget(hb);

    /* Item attributes */
    QGroupBox *gb = new QGroupBox(3, Horizontal, tr("Item: "), hb);
    CHECK_PTR(gb);

    QVBox *vb = new QVBox(gb);
    CHECK_PTR(vb);

	lbName = new QLabel(tr("&Name: "), vb);
    CHECK_PTR(lbName);
    QLabel *lbIcon = new QLabel(tr("&Icon: "), vb);
    CHECK_PTR(lbIcon);
    QLabel *lbExec = new QLabel(tr("E&xec: "), vb);
    CHECK_PTR(lbExec);
    QLabel *lbKeys = new QLabel(tr("&Keys: "), vb);
    CHECK_PTR(lbKeys);
    QLabel *lbResName = new QLabel(tr("&Res Name: "), vb);
    CHECK_PTR(lbResName);
    QLabel *lbResClass = new QLabel(tr("Re&s Class: "), vb);
    CHECK_PTR(lbResClass);
	QLabel *lbIceRun = new QLabel(tr("IceRrun:"), vb);
	CHECK_PTR(lbIceRun);
	QLabel *lbTimeOut = new QLabel(tr("&TimeOut:"), vb);
	CHECK_PTR(lbTimeOut);

    vb = new QVBox(gb);
    CHECK_PTR(vb);
    edItemName = new QLineEdit(vb);
    CHECK_PTR(edItemName);
    edItemName->setMinimumWidth(150);
    edIcon = new QLineEdit(vb);
    CHECK_PTR(edIcon);
    edIcon->setMinimumWidth(150);
    edExec = new QLineEdit(vb);
    CHECK_PTR(edExec);
    edExec->setMinimumWidth(150);
	//controls for keys
	QHBox *hbKeys = new QHBox(vb);
	CHECK_PTR(hbKeys);
	cbCtrl = new QCheckBox("&Ctrl", hbKeys);
	CHECK_PTR(cbCtrl);
	cbAlt = new QCheckBox("&Alt", hbKeys);
	CHECK_PTR(cbAlt);
	cbShift = new QCheckBox("&Shift", hbKeys);
	CHECK_PTR(cbCtrl);
    edKeys = new QLineEdit(hbKeys);
    CHECK_PTR(edKeys);
    edKeys->setMinimumWidth(100);
	QToolTip::add(edKeys, tr("Type here key for runing menu's item via keyboard"));

    edResName = new QLineEdit(vb);
    CHECK_PTR(edResName);
    edResName->setMinimumWidth(100);
	QToolTip::add(edResName, tr("Type here a WM_NAME for runonce menu's item"));
    edResClass = new QLineEdit(vb);
    CHECK_PTR(edResClass);
    edResClass->setMinimumWidth(100);
	QToolTip::add(edResClass, tr("Type here a WM_CLASS for runonce menu's item"));
	
	cbRecentMenu = new QCheckBox(tr("Sh&ould be added to recent menu"), vb);
	QToolTip::add(cbRecentMenu, tr("Set this flag if menu's item should "
			   	"be added to recent menu"));
	CHECK_PTR(cbRecentMenu);
	edTimeOut = new QLineEdit(vb);
	CHECK_PTR(edTimeOut);
    edTimeOut->setMinimumWidth(50);
	edTimeOut->setValidator(new QIntValidator(this));
	
    lbName->setBuddy(edItemName);
	lbName->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbIcon->setBuddy(edIcon);
	lbIcon->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbExec->setBuddy(edExec);
	lbExec->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbKeys->setBuddy(edKeys);
	lbKeys->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbResName->setBuddy(edResName);
	lbResName->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    lbResClass->setBuddy(edResClass);
	lbResClass->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	lbIceRun->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	lbTimeOut->setBuddy(edTimeOut);
	lbTimeOut->setFrameStyle(QFrame::Panel | QFrame::Sunken);

    vb = new QVBox(gb);
    CHECK_PTR(vb);
    cbItemType = new QComboBox(false, vb);
    CHECK_PTR(cbItemType);
	QToolTip::add(cbItemType, tr("Type of menu's item"));
	for(QStringList::Iterator it = menuStatement.begin(); it != menuStatement.end(); ++it)
	    cbItemType->insertItem((*it).latin1());
    
	QPushButton *pbIconBrowse = new QPushButton(QPixmap(fileopen),
		   							tr("&Browse icon"), vb);
	QToolTip::add(pbIconBrowse, tr("Opens dialog for browsing menu item's icon"));
    CHECK_PTR(pbIconBrowse);
    QPushButton *pbExecBrowse = new QPushButton(QPixmap(fileopen),
		   							tr("Br&owse program"), vb);
	QToolTip::add(pbExecBrowse, tr("Opens dialog for browsing menu item's program"));
    CHECK_PTR(pbExecBrowse);

    pbRunXprop = new QPushButton(tr("Run x&prop"), vb);
    CHECK_PTR(pbRunXprop);
	QToolTip::add(pbRunXprop, tr("Runs xprop for geting wm_class and wm_name"));
	
    gb = new QGroupBox(5, Vertical, tr("Actions: "), hb);
    CHECK_PTR(gb);

    QPushButton *pbSet = new QPushButton(tr("Se&t"), gb);
	CHECK_PTR(pbSet);
	QToolTip::add(pbSet, tr("Applays changes for current item of menu"));
    QPushButton *pbAdd = new QPushButton(tr("A&dd"), gb);
	CHECK_PTR(pbAdd);
	QToolTip::add(pbAdd, tr("Adds new item of menu"));
    QPushButton *pbDel = new QPushButton(tr("De&l"), gb);
	CHECK_PTR(pbDel);
	QToolTip::add(pbDel, tr("Deletes current item of menu"));
    pbEdit = new QPushButton(tr("Edit men&u"), gb);
	CHECK_PTR(pbEdit);
	QToolTip::add(pbEdit, tr("Starts editing menu from include or menufile statements"));
	pbEdit->setEnabled(false);
    pbBack = new QPushButton(tr("Bac&k"), gb);
	CHECK_PTR(pbBack);
	QToolTip::add(pbBack, tr("Returns to previous menufile"));
	pbBack->setEnabled(false);

	gb = new QGroupBox(sizeof(sysMItems)/sizeof(sysMItems[0]),
		   Horizontal, tr("S&ystem menu items:"), this);
	CHECK_PTR(gb);
	topLayout->addWidget(gb);
	for(i = 0; i < sizeof(sysMItems)/sizeof(sysMItems[0]); i++)
	{
		sysMenuItems[i] = new QCheckBox(sysMItems[i], gb);
		CHECK_PTR(sysMenuItems[i]);
		sysMenuItems[i]->setChecked(true);
	} /* 	for(i = 0; i < sizeof(sysMItems)/sizeof(sysMItems[0]); i++) */
	/*default settings for 'ShowProgramsMenu' */
	sysMenuItems[3]->setChecked(false);

	cbItemType->setCurrentItem(0);

    connect(lvMenu, SIGNAL(currentChanged(QListViewItem*)),
                    SLOT(slotCurrentChanged(QListViewItem*)));
    connect(pbAdd, SIGNAL(clicked()), SLOT(slotAddItem()));
	connect(pbExecBrowse, SIGNAL(clicked()), SLOT(slotBrowseExec()));
	connect(pbIconBrowse, SIGNAL(clicked()), SLOT(slotBrowseIcon()));
	connect(pbSet, SIGNAL(clicked()), SLOT(slotSet()));
	connect(cbItemType, SIGNAL(highlighted(int)), SLOT(slotItemTypeChanged(int)));
	connect(pbDel, SIGNAL(clicked()), SLOT(slotDel()));
	connect(pbRunXprop, SIGNAL(clicked()), SLOT(slotRunXprop()));
	connect(pbEdit, SIGNAL(clicked()), SLOT(slotEdit()));
	connect(pbBack, SIGNAL(clicked()), SLOT(slotBack()));
	connect(cbRecentMenu, SIGNAL(clicked()), SLOT(slotCheckBoxChanged()));
	for(i = 0; i < 8; i++)
		connect(sysMenuItems[i], SIGNAL(clicked()), SLOT(slotCheckBoxChanged()));

	if(qApp->argc() > 2)
	{
		iconLibPath = qApp->argv()[2];
	    iconLibPath	+= QString("/icons/");
	} /* 	if(qApp->argc() > 2) */

	dictKeys.setAutoDelete(true);
}//constructor

QCentralWidget::~QCentralWidget()
{
}//destructor

/**
 * Loads menu from file menuFileName.
 */
void QCentralWidget::loadMenuFromFile(QString &menuFileName)
{
	//we should load iconPath only for first main menufile.
	if(!stEditedFiles.count())
		loadIconPath(menuFileName);
	//we should load keys only for first main menufile.
	if(!stEditedFiles.count())
		loadKeys(menuFileName);
	
	lvMenu->clear();
	IceListViewItem *rootIt=new IceListViewItem(lvMenu, topItemName,
				                            "", "", "999");
	nestLevel = 0;
	lvMenu->setCurrentItem(rootIt);
	lvMenu->setSelected(rootIt, true);
	rootIt->setOpen(true);
	
    menuFile   = new QFile(menuFileName);
    if(menuFile->open(IO_ReadOnly))
	{
		menuStream = new QTextStream(menuFile);
    	loadMenuFromStream(rootIt);

    	delete menuStream;
	} /*     if(menuFile->open(IO_ReadOnly)) */
	else
        QMessageBox::warning(this, tr("Error"),
                             tr("Can't open ") + menuFileName);

    delete menuFile;
	isDirty = false;
	stEditedFiles.push(menuFileName);
	((IcemcApp*)parentWidget())->menuFileChanged(menuFileName);
}/* loadMenuFromFile(QString &menuFile) */


/* Types of words in menu */
enum {
        PROG = 0,
        MENU,
        MENUFILE,
		MENUPROG,
        RUNONCE,
        SEPARATOR,
        RESTART,
		INCLUDE,
		MENUPROGRELOAD,
        OB,     //  {
        CB,     //  }
        ID,
		MEOF,
		TOP = 999
     };

/* States of parser */
enum {
		ITEMNAME,
		ICONNAME,
		CMDLINE
	 }; /* States of parser */ 

/**
 * Loads menu from menuStream into lvMenu.
 */
void QCentralWidget::loadMenuFromStream(IceListViewItem *parentItem)
{
    QString itemName, icon;
   	bool isIceRun(false);
    IceListViewItem *lastItem = parentItem;
	QString stNum;
    int t;
	int prevState = CMDLINE;
	
    while((t = getWord()) != MEOF)
      switch(t)
      {
        case CB:
			nestLevel--;
			prevState = CMDLINE;
            return;
		case INCLUDE:
			stNum.setNum(menuStatementNum);
            getWord();  //file's name
			prevState = ITEMNAME;
			if (menuWord[0] != '/')
				menuWord = icewmCfgDir + '/' + menuWord;
			if(menuWord.isEmpty())
				break;
            lastItem = new IceListViewItem(parentItem, lastItem,
                                                 menuWord, "", "", stNum);
			prevState = CMDLINE;
			break;
        case PROG:
        case MENUFILE:
        case MENUPROG:
		case RUNONCE:
		case RESTART:
		case MENUPROGRELOAD:
			stNum.setNum(menuStatementNum);
            getWord();  //prog item's name or ResName\ResClass for runonce
			prevState = ITEMNAME;
			if(menuWord.isEmpty())
				break;
			itemName = menuWord;
            getWord();  //icon's file name
			prevState = ICONNAME;
			if(menuWord.isEmpty())
				break;
            icon = menuWord;
			if(t == RUNONCE)
			{
				getWord(); //prog item's name
				if(menuWord.isEmpty())
					break;
				menuWord.insert(0, '\"');
				menuWord += "\" ";
			} /* if(t == RUNONCE) */
			else
			{
				getWord();
				if(menuWord == icerrun)
				{
					menuWord = QString("");
					isIceRun = true;
            		menuStream->skipWhiteSpace();
				} /* 	if(menuWord == icerrun) */
				else
					isIceRun = false;
				if(t == MENUPROGRELOAD)
				{
					//menuWord contains timeout
					menuWord += " ";
				} /* 	if(t == MENUPROGRELOAD) */
			} /* else if t == RUNONCE*/
            menuWord += menuStream->readLine();  //commandline
			if(menuWord.isEmpty())
				break;
			if (t == MENUFILE && menuWord[0] != '/')
				menuWord = icewmCfgDir + '/' + menuWord;
			
		 	lastItem = new IceListViewItem(parentItem, lastItem,
                             itemName, icon, menuWord,
							 stNum, isIceRun ? "1" : "0",
					 (t == PROG ||
					  t == MENUPROG || t == MENUPROGRELOAD || 
					  t == RUNONCE) && isExecutable(menuWord) ? "1" : "0");
			setItemIcon(icon, lastItem);
			prevState = CMDLINE;
            break;
        case SEPARATOR:
            lastItem = new IceListViewItem(parentItem, lastItem,
                                                 separator, "", "", "5");
			prevState = CMDLINE;
            break;
        case MENU:
            getWord();  //menu item's name
			prevState = ITEMNAME;
			itemName = menuWord;
			if(menuWord.isEmpty())
				break;
            getWord();  //icon's file name (folder)
            icon = menuWord;
			prevState = ICONNAME;
			if(menuWord.isEmpty())
				break;
            getWord();  // {
			if(menuWord.isEmpty())
				break;
			prevState = CMDLINE;
            lastItem = new IceListViewItem(parentItem, lastItem,
                                              itemName, icon, "","1");
			//lastItem->setPixmap(0, folder);
			setItemIcon(icon, lastItem);
			nestLevel++;
            loadMenuFromStream(lastItem);
            break;
		default:
			if(!menuWord.isEmpty())
	        	QMessageBox::warning(this, tr("Error"),
                            tr("Syntax error near word ") + menuWord + 
							tr(". Keyword (prog, separator, menu , menufile, "
							"menuprog or restart) is absent"));
	  }//switch(getWord())
    //while(!menuStream->atEnd())
	if(nestLevel)
        QMessageBox::warning(this, tr("Error"),
                             tr("Syntax error: '}' is absent"));
	if(prevState != CMDLINE)
        QMessageBox::warning(this, tr("Error"),
                             tr("Syntax error near word ") + menuWord);
}/* loadMenuFromStream() */

/**
 * Reads next word from menu's file and returns type of this word.
 */
int QCentralWidget::getWord()
{
	if(menuStream->atEnd())
		return MEOF;
    QChar ch, chn;
    QString w;
    menuStream->skipWhiteSpace();

    *menuStream >> ch;
        
	while(ch == '#')
    {
        w = menuStream->readLine(); //skip comments
        menuStream->skipWhiteSpace();
		if(menuStream->atEnd())
			return MEOF;
		*menuStream >> ch;
	} /* 	while(ch == '#') */	
	
	if(ch == '}')
        return CB;
    if(ch == '{')
        return OB;
    if(ch == '-')
    {
        menuWord = '-';
        return ID;
    }
     
	menuWord = ch;
	if(ch != '"')
	{
		*menuStream >> w;
		menuWord += w;
	} /* 	if(ch != '"') */
	else
	{
		while(*menuStream >> ch, ch != '"')
		{
			if(ch == '\\')
			{
    			*menuStream >> chn;
				if(chn != '"' && chn != '\'')
					menuWord += ch;
				menuWord += chn;
			} /* if(ch == '\\') */
			else
				menuWord += ch;
		} /* while(ch != '"') */
	} /* 	else */
    if(menuWord[0] == '"')
        menuWord = menuWord.remove(0, 1);
	menuWord.replace("\\\"", "\"");
    //what's type of this word?
	menuStatementNum = 0;
	for(QStringList::Iterator it = menuStatement.begin(); 
			it != menuStatement.end(); ++it)
	{
		if(menuWord == *it)
			return menuStatementNum;
		menuStatementNum++;
	} /*for( it = menuStatement.begin(); it != menuStatement.end(); ++it) */
	return ID;
}/* getWord() */

/** No descriptions */
void QCentralWidget::slotCurrentChanged(QListViewItem *curItem)
{
    int itType = curItem->text(3).toInt(0);
	if(itType == TOP)	
		return;
	pbEdit->setEnabled(itType == INCLUDE || itType == MENUFILE);
    if( itType == SEPARATOR || itType ==INCLUDE || itType == TOP)  //separator or include
    {
        edItemName->setEnabled(itType == INCLUDE);
        edExec->setEnabled(false);
        edIcon->setEnabled(false);
        edKeys->setEnabled(false);
		edResName->setEnabled(false);
		edResClass->setEnabled(false);
		edTimeOut->setEnabled(false);
		cbCtrl->setEnabled(false);
		cbAlt->setEnabled(false);
		cbShift->setEnabled(false);
		cbRecentMenu->setEnabled(false);
        if(itType == SEPARATOR)
			edItemName->clear();
		else
        	edItemName->setText(curItem->text(0));
        edIcon->clear();
        edExec->clear();
		edKeys->clear();
		edTimeOut->clear();

        cbItemType->setCurrentItem(itType);
    }/* if(itType == 5) */
    else
    {
		//QString *key;
		 
		if(itType == RUNONCE)
		{
			int pos;
			QString itemName(curItem->text(2));
			itemName.remove(0, 1);
			pos = itemName.find('\"');
			edExec->setText(itemName.mid(pos + 2).stripWhiteSpace());
			itemName.remove((uint)pos, 1000);
			pos = itemName.find('.');
			if(pos != -1)
			{
				edResClass->setText(itemName.mid(pos + 1));
				itemName.remove((uint)pos, 1000);
			} /* if(pos != -1) */
			else
				edResClass->clear();
			edResName->setText(itemName);
			edResName->setEnabled(true);
			edResClass->setEnabled(true);
		} /* if(itType == RUNONCE) */
		else
		{
			QString execStr(curItem->text(2));
			if(itType != MENUPROGRELOAD)
        		edExec->setText(execStr);
			else
			{
				int pos = execStr.find(' ');
				edTimeOut->setText(execStr.left(pos));
				edExec->setText(execStr.mid(pos + 2));
			} /* else MENUPROGRELOAD*/
			edResName->setEnabled(false);
			edResClass->setEnabled(false);
		} /* else */
        edItemName->setText(curItem->text(0));
        edIcon->setText(curItem->text(1));
		edKeys->clear();
		cbCtrl->setChecked(false);
		cbAlt->setChecked(false);
		cbShift->setChecked(false);
		checkKeys(dictKeys[curItem->text(2)]);
		
        edItemName->setEnabled(true);
        edIcon->setEnabled(true);
		cbCtrl->setEnabled(!itType);
		cbAlt->setEnabled(!itType);
		cbShift->setEnabled(!itType);
        edExec->setEnabled(itType != 1);
        edKeys->setEnabled(!itType);
		edTimeOut->setEnabled(itType == MENUPROGRELOAD);
        cbItemType->setCurrentItem( itType);
		
		QString isIceRun(curItem->text(4));
		cbRecentMenu->setChecked(!isIceRun.isNull() && isIceRun[0] == '1');
		cbRecentMenu->setEnabled(itType != 1);
    }/* else if(itType == 5) */
}/* slotCurrentChanged(IceListViewItem *curItem) */

/**
 * Inserts new empty item into menu.
 */
void QCentralWidget::slotAddItem()
{
	IceListViewItem *parentIt, *newIt;
	IceListViewItem *curIt = (IceListViewItem*)lvMenu->currentItem();
	int itType = curIt->text(3).toInt(0);
	parentIt = (itType == TOP || (itType == MENU && curIt->isOpen())) ? curIt:
		       (IceListViewItem*)curIt->parent();
	newIt = new IceListViewItem(parentIt, curIt, "", "", "", curIt->text(3));
	if(itType == MENU)
	{
		newIt->setPixmap(0, folder);
		newIt->setExpandable(true);
		newIt->setText(1, "folder");
		edIcon->setText("folder");
	} /* 	if(itType == 'm') */
	lvMenu->setCurrentItem(newIt);
} /* void QCentralWidget::slotAddItem() */

/**
 * Browses executables for menu.
 */
void QCentralWidget::slotBrowseExec()
{
	int itType = lvMenu->currentItem()->text(3).toInt(0);
	QString fileName = QFileDialog::getOpenFileName( itType ==INCLUDE ?
                      icewmCfgDir : execPath, 0,this);
	if (!fileName.isEmpty())
	{
		//remove dir path if possible
		QFileInfo fi(fileName);
		execPath = fi.dirPath(true);
		if(path.find(execPath) != -1)
			if(itType == INCLUDE)
				edItemName->setText(fi.fileName());
			else
				edExec->setText(fi.fileName());
		else
			if(itType == INCLUDE)
				edItemName->setText(fileName);
			else
				edExec->setText(fileName);
	} /* 	if (!fileName.isEmpty */	
}/* slotBrowseExec() */

/**
 * Browses icon for menu.
 */
void QCentralWidget::slotBrowseIcon()
{
	QString fileName;
    
	if(!dialog)
	{
		QIconPreview *p = new QIconPreview();
    	dialog = new QFileDialog(iPath,QString::null,this,
                                        "newIcon",true);
    	QString filterTypes(tr("Images (*.xpm *.png *.jpg *.gif *.bmp)"
                         ";;All files (*)"));
    	dialog->setFilters(filterTypes);
    	dialog->setMode(QFileDialog::ExistingFile);
    	dialog->setCaption("Please Select Icon");
    	dialog->setContentsPreviewEnabled(true);
    	dialog->setContentsPreview(p,p);
    	dialog->setPreviewMode(QFileDialog::Contents);
	} /* 	if(!dialog) */
	
    if(!dialog->exec())
        return;
    fileName = dialog->selectedFile();

	if (!fileName.isEmpty())
	{
		QFileInfo fi(fileName);
		iPath = fi.dirPath(true);
		if(iconPath.find(iPath) != -1)
			edIcon->setText(fi.fileName());
		else
		{	//may be it's icon in lib path
			iPath += '/';
			int pos;
			pos = fi.fileName().findRev("_16x16.xpm");
			if(pos == -1)
				pos = fi.fileName().findRev("_32x32.xpm");
			if((iPath == iconLibPath || iPath == iconPrivLibPath) && pos != -1)
				edIcon->setText(fi.fileName().remove(pos,10));
			else
				edIcon->setText(fileName);
		} /* else if(iconPath.find(iPath) != -1) */
	} /* 	if (!fileName.isEmpty */	
} /* void QCentralWidget::slotBroseIcon */

/**
 * Sets the current setting into current menuitem.
 */
void QCentralWidget::slotSet()
{
	int itType = cbItemType->currentItem();
	QString item("\"");
	IceListViewItem *curIt = (IceListViewItem*)lvMenu->currentItem();
	if(itType == RUNONCE)
	{
		if(edResClass->text().isEmpty() && edResName->text().isEmpty())
		{
        	QMessageBox::warning(this, tr("Warning"),
                      tr("You must specify Res Name or Res Class or both!"));
			return;
		} /* if(edResClass->text().isEmpty() && edResName->text().isEmpty()) */
		item += edResName->text();
		if(!edResClass->text().isEmpty())
	   		item += '.' + edResClass->text();
	   	item += "\" " + edExec->text();
	} /* if(cbItemType->currentItem() == RUNONCE) */
	else
		if(itType == MENUPROGRELOAD)
		{
			if(edTimeOut->text().isEmpty())
			{
        		QMessageBox::warning(this, tr("Warning"),
                      tr("You must specify a timeout!"));
				return;
			} /* if(edTimeOut->text().isEmpty()) */
			item = edTimeOut->text() + " " + edExec->text();
		} /* if(itType == MENUPROGRELOAD) */
		else
			item = edExec->text();
	
	if(itType == MENUFILE && item[0] != '/')
		item = icewmCfgDir + '/' + item;

	QString itemName(edItemName->text());
	if(itType == INCLUDE && itemName[0] != '/')
		itemName = icewmCfgDir + '/' + itemName;
	
	curIt->setText(0, itType == SEPARATOR ? separator : itemName);
	curIt->setText(1, edIcon->text());
	curIt->setText(2, item);
	if(itType == PROG || itType == MENUPROG || itType == RUNONCE || MENUPROGRELOAD)
		curIt->setText(5, isExecutable(item) ? "1" : "0");
	item.setNum(cbItemType->currentItem());
	curIt->setText(3, item);
	curIt->setText(4, cbRecentMenu->isChecked() ? "1" : "0");
	QString iconName = edIcon->text();
	setItemIcon(iconName, curIt);
	setKeys();
	if(!isDirty)
	{
		isDirty = true;
		((IcemcApp*)parentWidget())->contentChanged();
	} /* 	if(!isDirty) */
} /* void QCentralWidget::slotSet() */

/** No descriptions */
void QCentralWidget::saveMenu()
{
	QString menuFileName(stEditedFiles.top());
	//save old copy of file
	QString bakFileName(menuFileName);
    bakFileName += ".bak";
	QDir d;
	d.rename(menuFileName, bakFileName);
    menuFile   = new QFile(menuFileName);
    if(!menuFile->open(IO_WriteOnly))
    {
        QMessageBox::warning(this, tr("Error"),
                             tr("Can't open ") + menuFileName);
        return;
    }/* if(!menuFile->open()) */
	
    menuStream = new QTextStream(menuFile);
    saveMenuIntoStream((IceListViewItem*)lvMenu->firstChild());

    delete menuStream;
    delete menuFile;

	//we should save keys only for first main menufile.
	if(stEditedFiles.count() == 1)
		saveKeys(menuFileName);

	saveSysMenu();

	isDirty = false;
}/* saveMenu(QString &fileName) */

/** No descriptions */
void QCentralWidget::saveMenuIntoStream(IceListViewItem *rootItem)
{
	QString tabsStr;
    int itType;
	//int spIndex;
	QString itemName;
	QString itemTemp;
	QString iconName;
	QString isIceRun;
    IceListViewItem *curIt = (IceListViewItem*)rootItem->firstChild();
	tabsStr.fill('\t', nTabs);
    while(curIt)
    {
        itType = curIt->text(3).toInt(0);
		itemTemp = curIt->text(0);
		itemTemp.replace('"', "\\\"");
		if(itemTemp.find(' ') != -1)
		{
			itemName = '"';
			itemName += itemTemp + '"';
		} /* if(curIt->text(0).find(' ') != -1) */
		else
			itemName = itemTemp;
		
		itemTemp = curIt->text(1);
		itemTemp.replace('"', "\\\"");
		if(itemTemp.find(' ') != -1)
		{
			iconName = '"';
			iconName += itemTemp + '"';
		} /* if(curIt->text(1).find(' ') != -1) */
		else
			iconName = itemTemp;
		*menuStream << tabsStr;
		//itemName.replace('"', "\\\"");
		//iconName.replace('"', "\\\"");
        switch(itType)
        {
            case MENU:
				*menuStream << menuStatement[itType] << ' ' << itemName << ' ' << 
						                 iconName << " {\n";
				nTabs++;
                saveMenuIntoStream(curIt);
				nTabs--;
				*menuStream << tabsStr << "}\n" << tabsStr <<
				            "# End of " << curIt->text(0) << " menu\n\n";
                break;
			case INCLUDE:
				*menuStream << menuStatement[itType] << ' ' << itemName << '\n';
				break;
            case PROG:
			case MENUFILE:
            case MENUPROG:
            case RESTART:
			case RUNONCE:
			case MENUPROGRELOAD:
				*menuStream << menuStatement[itType] << ' ' << itemName << ' ' <<
						                 iconName << ' ';
				isIceRun = curIt->text(4);
				if(!isIceRun.isNull() && isIceRun[0] == '1')
					*menuStream << icerrun << ' ';
			   	*menuStream << curIt->text(2).stripWhiteSpace() << '\n';
                break;
            case SEPARATOR:
				*menuStream << menuStatement[itType] << '\n';
                break;
        }/* switch(char(itType)) */
        curIt = (IceListViewItem*)curIt->nextSibling();
    }/*while(curIt)*/
}/* saveMenuIntoStream(IceListViewItem *rootItem) */

/** 
 * Sets icon iconName for item it.
 */
void QCentralWidget::setItemIcon(QString &iconName, IceListViewItem *it)
{
	QString fullIconName(iconName);
	
	if(iconName[0] != '/')
	{	//it's relative file name
		//lets find absolute path
		//searching in lib path
		fullIconName = iconPrivLibPath + iconName + "_16x16.xpm";
		if(!QFile::exists(fullIconName))
		{
			fullIconName = iconLibPath + iconName + "_16x16.xpm";
			if(!QFile::exists(fullIconName))
				//searching in IconPath
				for( QStringList::Iterator it = iconPathsLst.begin(); 
						it != iconPathsLst.end(); ++it)
				{
					fullIconName = *it + '/' + iconName;
					if(QFile::exists(fullIconName))
						break;
				} /*for( it!=iconPathsLst.end(); ++it) 	*/
		} /* 		if(!QFile::exists(fullIconName)) */
	} /* 	if(iconName[0] != '/') */
	
	QImage img(fullIconName);
	if(img.isNull())
		return;
	img = img.smoothScale(16, 16);
	QPixmap icon;
	icon.convertFromImage(img);
	it->setPixmap(0, icon);
} /* void QCentralWidget::setItemIcon */

/** No descriptions */
void QCentralWidget::slotItemTypeChanged(int newType)
{
	QString sNum;
	sNum.setNum(newType);
	IceListViewItem *it = (IceListViewItem*)lvMenu->currentItem();
	switch(newType)
	{
		case PROG:	//prog
		case MENUFILE: 
        case MENUPROG:
		case RUNONCE:
        case RESTART:
		case MENUPROGRELOAD:
				edItemName->setEnabled(true);
				edIcon->setEnabled(true);
				edExec->setEnabled(true);
				edResClass->setEnabled(newType == RUNONCE);
				edResName->setEnabled(newType == RUNONCE);
				cbShift->setEnabled(newType == PROG);
				cbAlt->setEnabled(newType == PROG);
				cbCtrl->setEnabled(newType == PROG);
				cbRecentMenu->setEnabled(newType == PROG);
				edKeys->setEnabled(newType == PROG);
				edTimeOut->setEnabled(newType == MENUPROGRELOAD);
				it->setExpandable(false);
				it->setText(3, sNum);
				break;
		case MENU: //menu
				edItemName->setEnabled(true);
				edIcon->setEnabled(true);
				edExec->setEnabled(false);
				edResClass->setEnabled(false);
				edResName->setEnabled(false);
				cbShift->setEnabled(false);
				cbAlt->setEnabled(false);
				cbCtrl->setEnabled(false);
				cbRecentMenu->setEnabled(false);
				edKeys->setEnabled(false);
				edTimeOut->setEnabled(false);
				it->setExpandable(true);
				it->setText(3, "1");
				break;
		case SEPARATOR: //separator
 				edItemName->setEnabled(false);
				edIcon->setEnabled(false);
				edExec->setEnabled(false);
				it->setExpandable(false);
				edResClass->setEnabled(false);
				edResName->setEnabled(false);
				cbShift->setEnabled(false);
				cbAlt->setEnabled(false);
				cbCtrl->setEnabled(false);
				cbRecentMenu->setEnabled(false);
				edKeys->setEnabled(false);
				edTimeOut->setEnabled(false);
				it->setText(3, "5");
				break;
	} /* 	switch(newType) */
} /* void QCentralWidget::slotItemTypeChanged(int newType) */

/** No descriptions */
void QCentralWidget::slotDel()
{
	IceListViewItem *curIt = (IceListViewItem*)lvMenu->currentItem();
	if(curIt->text(3) == "999")
	{
		QMessageBox::warning(this, tr("Warning"),
				tr("Deleting the top-level item is not allowed"));
		return;
	} /* 	if(itType == 't') */
	curIt->parent()->takeItem(curIt);
	delete curIt;
   	if(!isDirty)
	{
		isDirty = true;
		((IcemcApp*)parentWidget())->contentChanged();
	} /* 	if(!isDirty) */
} /* void QCentralWidget::slotDel() */

/**
 * Loads IconPath's list and system menu items.
 */

/**
 * system items for menu.
 */
static const char *prefSysMItems[] = {
									"ShowAbout",
									"ShowLogoutMenu",
									"ShowLogoutSubMenu",
									"ShowProgramsMenu",
									"ShowThemesMenu",
									"ShowHelp",
									"ShowRun",
									"ShowWindowList"
									};

/**
 * system items for taskbar.
 */
static const char *prefSysTItems[] = {
									"TaskBarShowWindowListMenu"
									};

void QCentralWidget::loadIconPath(QString &menuFileName)
{
	int i;
	unsigned j;
	QString s(menuFileName);
	i = s.findRev('/');
	s.replace(i + 1, 100, "preferences");
	
	QFile prefFile(s);

    if(prefFile.open(IO_ReadOnly))
    {
    	QTextStream prefT(&prefFile);
        while ((s = prefT.readLine()) != QString::null)
        {
        	iconPath = s.stripWhiteSpace();
			if(iconPath[0] == '#')
				continue;
            if(iconPath.find("IconPath") != -1)
            {
				i = iconPath.find('\"');
				iconPath.remove(0, i + 1);
				i = iconPath.findRev('\"');
				iconPath.remove(i, 100);
				iconPathsLst = QStringList::split(':', iconPath);
				//break;
			} /* if(bgStr.find("IconPath") != -1) */
			else
				for(j = 0; j < sizeof(prefSysMItems)/sizeof(prefSysMItems[0]); j++)
				{
					if(iconPath.find(prefSysMItems[j]) != -1)
					{
						//skip TaskBarShowWindowListMenu
						if(j == sizeof(prefSysMItems)/sizeof(prefSysMItems[0])-1 &&
								iconPath.find(prefSysTItems[0]) != -1)
							continue;
						i = iconPath.find('=');
						iconPath.remove(0, i + 1);
						sysMenuItems[j]->setChecked(iconPath.stripWhiteSpace()[0] == '1');
					} /* if(iconPath.find(prefSysMItems[j]) != -1) */
				} /* for(j = 0; j < sizeof; j++) */
		} /* while ((s = bakT.readLine()) != QString::null) */
        prefFile.close();
    }/* if(prefFile.open(IO_ReadOnly)) */
} /* void QCentralWidget::loadIconPath() */

/**
 * Loads keys into dictionary.
 */
void QCentralWidget::loadKeys(QString &menuFileName)
{
	int t;
	QString cmdLine;
	QString keyFileName(menuFileName);
	keyFileName = keyFileName.replace(keyFileName.findRev('/') + 1,
			              9, "keys");

    menuFile   = new QFile(keyFileName);
    if(!menuFile->open(IO_ReadOnly))
    {
        QMessageBox::warning(this, tr("Error"),
                             tr("Can't open ") + keyFileName);
        return;
	} /*     if(!menuFile->open(IO_ReadOnly)) */
	
    menuStream = new QTextStream(menuFile);
	
	dictKeys.clear();
	
    while((t = getWord()) != MEOF)
	{
    	getWord();  //keys
		if(menuWord.isEmpty())
			break;
        menuStream->skipWhiteSpace();
        cmdLine = menuStream->readLine();  //commandline
		if(cmdLine.isEmpty())
			break;
		//regroup modificators of keys for monotonous
		int p = menuWord.find("Ctrl+");
		QString uniKey;
		if(p != -1)
		{
			uniKey += "Ctrl+";
			menuWord.remove(p, 5);
		} /* if(p != -1) */
		p = menuWord.find("Alt+");
		if(p != -1)
		{
			uniKey += "Alt+";
			menuWord.remove(p, 4);
		} /* if(p != -1) */
		p = menuWord.find("Shift+");
		if(p != -1)
		{
			uniKey += "Shift+";
			menuWord.remove(p, 6);
		} /* if(p != -1) */
		uniKey += menuWord;
		//add new keys
		dictKeys.insert(cmdLine, new QString(uniKey));
	} /*     while((t = getWord()) != MEOF) */
    
	delete menuStream;
    delete menuFile;
} /* void QCentralWidget::loadKeys(QString &menuFileName) */

/**
 * Saves keys into file respective menuFileName.
 */
void QCentralWidget::saveKeys(QString &menuFileName)
{
	QString keyFileName(menuFileName);
	keyFileName = keyFileName.replace(keyFileName.findRev('/') + 1,
			          9, "keys");
	
	//save old copy of file
    QString bakFileName(keyFileName);
    bakFileName += ".bak";
	QDir d;
	d.rename(keyFileName, bakFileName);
    menuFile   = new QFile(keyFileName);
    if(!menuFile->open(IO_WriteOnly))
    {
        QMessageBox::warning(this, tr("Error"),
                             tr("Can't open ") + keyFileName);
        return;
    }/* if(!menuFile->open()) */
	
    menuStream = new QTextStream(menuFile);
	//saves keys
	QDictIterator<QString> it(dictKeys);
	while(it.current())
	{
		*menuStream << "key \"" << *(it.current()) << 
			           "\" " << it.currentKey() << "\n";
		++it;
	} /* 	while(it.current()) */
	
    delete menuStream;
    delete menuFile;
} /* void QCentralWidget::saveKeys(QString &menuFileName) */

/**
 * Sets keys for current item.
 */
void QCentralWidget::setKeys()
{
	QString keys(cbCtrl->isChecked() ? "Ctrl+" : "");
	if(cbAlt->isChecked())
		keys += "Alt+";
	if(cbShift->isChecked())
		keys += "Shift+";
	keys +=	edKeys->text();
	
	if(keys.isEmpty())
		dictKeys.remove(edExec->text());
	else
	{
		int canMap = 1;
		QDictIterator<QString> it(dictKeys);

		while(it.current())
		{
			if(*(it.current()) == keys && it.currentKey() != edExec->text())
			{
				canMap = QMessageBox::warning(this, tr("Attention!"),
					tr("The keys \'") + keys + tr("\' is already maped to ") +
				   	it.currentKey() + tr(".\nDo you want to remap its to " + 
						edExec->text()) + "?", tr("&No"), tr("&Yes"));
				if(canMap)
					dictKeys.remove(it.currentKey());
				break;
			} /* if(*(it.current()) == keys) */
			++it;
		} /* while(it.current()) */
		if(canMap)
			dictKeys.replace(edExec->text(), new QString(keys));
	} /* else if(!edKeys->text().isEmpty()) */
} /* void QCentralWidget::setKeys() */

/**
* Runs xprop.
*/
void
QCentralWidget ::slotRunXprop()
{
	FILE *fptr;
	QString str;
	QString wm_class("WM_CLASS(STRING) = ");
	QString wm_name("WM_NAME(STRING) = ");
	fptr = popen("xprop", "r");
	if(!fptr)
		return;
	
	QTextStream xpropStream(fptr, IO_ReadOnly);
	while((str = xpropStream.readLine()) != QString::null)
	{
		if(!str.find(wm_class))
		{
			str = str.remove(0, wm_class.length() + 1);
			edResClass->setText(str.remove(str.length() - 1, 1));
		} /* 		if(!str.find(wm_class)) */
		if(!str.find(wm_name))
		{
			str = str.remove(0, wm_name.length() + 1);
			edResName->setText(str.remove(str.length() - 1, 1));
		} /* 		if(!str.find(wm_class)) */
	} /* 	while((str = xpropStream.readLine()) != QString::null) */
	pclose(fptr);
} /* QCentralWidget ::slotRunXprop() */

/**
* Starts to edit new file.
*/
void
QCentralWidget::slotEdit()
{
	IceListViewItem *curIt = (IceListViewItem*)lvMenu->currentItem();
	QString fileName(curIt->text(curIt->text(3).toInt(0) == INCLUDE ? 0 : 2));
	
	checkDirty();
	loadMenuFromFile(fileName);
	pbBack->setEnabled(true);
} /* QCentralWidget ::slotEdit() */

/**
* Backs to previous editing file.
*/
void
QCentralWidget::slotBack()
{
	checkDirty();
	QString fileName(stEditedFiles.pop());	//current fileName
	fileName = stEditedFiles.pop();			//previous fileName
	
	loadMenuFromFile(fileName);
	pbBack->setEnabled(stEditedFiles.count() > 1);
} /* QCentralWidget ::slotBack() */

/**
* Returns true if command executable otherwise returns false.
*/
bool
QCentralWidget::isExecutable(const QString &command)
{
	QString cmd(command);
	QString fullCmd;
	int i;
	if(cmd[0] == '\"')
	{	//it's runoncw statement
		cmd.remove(0,1);
		i = cmd.find('\"');
		cmd = cmd.mid(i + 2).stripWhiteSpace();
	} /* 	if(cmd[0] == '\"') */
	
	i = cmd.find(' ');
	if(i != -1)
		cmd.truncate(i);
	
	QFileInfo fileInfo(cmd);
	if(!fileInfo.isRelative())
		return fileInfo.isExecutable();
	
	for(QStringList::Iterator it = pathLst.begin(); it != pathLst.end(); ++it)
	{
		fullCmd = *it + "/" + cmd;
		fileInfo.setFile(fullCmd);
		if(fileInfo.isExecutable())
			return true;
	} /*for(QStringList::Iterator it */
	return false;
} /* QCentralWidget ::isExecutable(const QString &cmd) */

/**
* draws cell.
*/
void
IceListViewItem::paintCell( QPainter *p, const QColorGroup &cg,
	   int column, int width, int alignment )
{
	QColorGroup _cg( cg );
    QColor c = _cg.text();
	char itemChar = text(3).constref(0);

    if ((itemChar == '0' || itemChar == '3' || itemChar == '4') &&
			text(5)[0] == '0')
        _cg.setColor( QColorGroup::Text, Qt::red );

    QListViewItem::paintCell( p, _cg, column, width, alignment );
    _cg.setColor( QColorGroup::Text, c );
} /* IceListViewItem::void paintCell( ) */

/**
* Copy the selected item into the Clipboard.
*/
void
QCentralWidget::copy()
{
	int i;
	//int itType = cbItemType->currentItem();
	IceListViewItem *curIt = (IceListViewItem*)lvMenu->currentItem();
	QClipboard *cb = QApplication::clipboard();
	QString text4Clip(cbItemType->currentText());
	QString subText;
	QString *pKeys;

	for(i = 0; i < 2; i++)
	{
		subText = curIt->text(i);
		if(subText.find(' ') != -1)
		{
			text4Clip += " \"";
			text4Clip += subText + '\"';
		} /* if(subText.find(' ') != -1) */
		else
			text4Clip += " " + subText;
	} /* 	for(i = 0; i < 2; i++) */
	if(cbRecentMenu->isChecked())
		text4Clip += " " + icerrun;
	text4Clip += " " + curIt->text(2) + "\n";
	pKeys = dictKeys[curIt->text(2)];
	if(pKeys)
		text4Clip += *pKeys;
//some tricks from  Iain Hibbert <plunky at rya-online dot net>
//some inconsistencies with Qt3 and Qt2
#if QT_VERSION >= 0x030000
	cb->setText(text4Clip, QClipboard::Selection);
#else
	cb->setText(text4Clip);
#endif
} /* QCentralWidget ::copy() */

/**
* Cut the selected item into the clipboard.
*/
void
QCentralWidget::cut()
{
	copy();
	slotDel();
} /* QCentralWidget ::cut() */

/**
* paste the clipboard into menu.
*/
void
QCentralWidget::paste()
{
#if QT_VERSION >= 0x030000
	QString clipText(QApplication::clipboard()->text(QClipboard::Selection));
#else
	QString clipText(QApplication::clipboard()->text());
#endif

	int pos;
	int pos2;
	int nStatement;
	QString word;
	
	pos2 = clipText.find('\n');
	pos = clipText.find(' ');
	if(pos != -1 && pos2 != -1)
	{
		//extracting keys and menu item
#if QT_VERSION >= 0x030000
		QString keys(clipText.section('\n', 1, 1));
		clipText = clipText.section('\n', 0, 0);
#else
		QString keys(clipText.mid(pos2 + 1, clipText.find('\n', pos2 + 1) - pos2 - 1));
		clipText = clipText.left(pos2);
#endif
		QStringList::Iterator it;
		word = clipText.left(pos);
		nStatement = 0;
		for(  it = menuStatement.begin(); 
			it != menuStatement.end() && *it != word; ++it, nStatement++)
			;
		if(it != menuStatement.end())
		{
			slotAddItem();
			cbItemType->setCurrentItem(nStatement);
			if(nStatement != SEPARATOR)
			{
				pos2 = (clipText[++pos] == '\"') ? 
				   clipText.find('\"', ++pos) :	
				   clipText.find(' ', pos);
				word = clipText.mid(pos, pos2 - pos);
				edItemName->setText(word);
				if(nStatement != INCLUDE)
				{
					pos = clipText[pos2] == '\"' ? pos2 + 2 : pos2 + 1;
					pos2 = (clipText[pos] == '\"') ? 
				   			clipText.find('\"', ++pos) :	
				   			clipText.find(' ', pos);
					word = clipText.mid(pos, pos2 - pos);
					edIcon->setText(word);
					if(nStatement != MENU)
					{
						if(nStatement == RUNONCE)
						{
							pos = clipText[pos2] == '\"' ? pos2+2 : pos2+1;
							pos2 = (clipText[pos] == '\"') ? 
				   					clipText.find('\"', ++pos) :	
				   					clipText.find(' ', pos);
							word = clipText.mid(pos, pos2 - pos);
							pos = word.find('.');
							if(pos == -1)
								edResName->setText(word);
							else
							{
								edResName->setText(word.left(pos));
								edResClass->setText(word.mid(pos + 1));
							} /* else */
						} /* if(nStatement == RUNONCE) */
						word = clipText.mid(clipText[pos2] == '\"' ?
								   pos2 + 2 : pos2 + 1).stripWhiteSpace();
						if(word.left(icerrun.length()) == icerrun)
						{
							word = word.mid(icerrun.length() + 1);
							cbRecentMenu->setChecked(true);
						} /*if(word.left(icerrun.length()) == icerrun) */
						edExec->setText(word);
					} /* if(nStatement != MENU) */
				} /* if(nStatement != INCLUDE) */
			} /* if(nStatement != SEPARATOR) */
			checkKeys(&keys);
			slotSet();
			return;
		} /* if(it != menuStatement.end()) */
	} /* if(pos != -1) */
	else
		QMessageBox::critical(this, tr("Error !!"), tr("Wrong text format"));
} /* QCentralWidget ::paste() */

/**
* Checks appropriate controls for shortcut 'key'.
*/
void
QCentralWidget::checkKeys(const QString *key)
{
	if(key)
	{
		int pos;
		QString keys(*key);
		pos = keys.find("Ctrl+");
		if(pos != -1)
		{
			keys.remove(pos, 5);
			cbCtrl->setChecked(true);
		} /* if(pos != -1) */
		pos = keys.find("Alt+");
		if(pos != -1)
		{
			keys.remove(pos, 4);
			cbAlt->setChecked(true);
		} /* if(pos != -1) */
		pos = keys.find("Shift+");
		if(pos != -1)
		{
			keys.remove(pos, 6);
			cbShift->setChecked(true);
		} /* if(pos != -1) */
		edKeys->setText(keys);
	} /* if(key) */
} /* QCentralWidget ::checkKeys(const QString *key) */

/**
* Saves system menu items (ShowHelp, ShowPrograms etc.).
*/
void
QCentralWidget::saveSysMenu()
{
	QString prefFileName(icewmCfgDir + "/preferences");
    //backup copy of preferences
    QString bakPrefFileName(prefFileName);
    bakPrefFileName += ".bak";
    ::rename( QFile::encodeName(prefFileName), QFile::encodeName(bakPrefFileName));

    QFile bakFile(bakPrefFileName);
    QFile prefFile(prefFileName);
    QString s, menuStr;
	unsigned j;

	if(bakFile.exists())
    {
        if(bakFile.open(IO_ReadOnly) && prefFile.open(IO_WriteOnly))
        {
            QTextStream bakT(&bakFile);
            QTextStream prefT(&prefFile);
            while ((s = bakT.readLine()) != QString::null)
            {
                menuStr = s.stripWhiteSpace();
				//don't change comments
				if(menuStr[0] != '#')
					for(j = 0; j < sizeof(prefSysMItems)/sizeof(prefSysMItems[0]); j++)
					{
						if(j == sizeof(prefSysMItems)/sizeof(prefSysMItems[0])-1 &&
								menuStr.find(prefSysTItems[0]) != -1)
							continue;
						if(menuStr.find(prefSysMItems[j]) != -1)
						{
							prefT << prefSysMItems[j] << " = " << 
								(sysMenuItems[j]->isChecked() ? 1 : 0) << " # 0/1\n";
							break;
						} /* 	if(menuStr.find(prefSysMItems[j]) != -1) */
					} /* 	for(j = 0; */
				if( menuStr[0] == '#' || j == sizeof(prefSysMItems)/sizeof(prefSysMItems[0]))
                	prefT << s << '\n';
            }/* while ((s = bakT.readLine()) != QString::null) */
            bakFile.close();
            prefFile.close();
        }/* if(bakFile.open(IO_ReadOnly)) */
    }/* if(bakFile.exists()) */
} /* QCentralWidget ::saveSysMenu() */

/**
* The checkbox is changed.
*/
void
QCentralWidget::slotCheckBoxChanged()
{
	if(!isDirty)
	{
		isDirty = true;
		((IcemcApp*)parentWidget())->contentChanged();
	} /* 	if(!isDirty) */
} /* QCentralWidget ::slotCheckBoxChanged() */
