/***************************************************************************
                          icemc.h  -  description
                             -------------------
    begin                :   17 22:11:56 EEST 2002
    copyright            : (C) 2002 by Vadim A. Khohlov
    email                : xvadim@newmail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ICEMC_H
#define ICEMC_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qpainter.h>

class QCentralWidget;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar and statusbar.
  */
class IcemcApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    IcemcApp();
    /** destructor */
    ~IcemcApp();
    /** initializes all QActions of the application */
    void initActions();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** this creates the toolbars. Change the toobar look and add new toolbars in this
     * function */
    void initToolBar();
    /** setup the statusbar */
    void initStatusBar();

	/**
	 * Called by centralwidget after changing the content.
	 * Adds '[*]' into caption.
	 */
	void contentChanged();
	
	/**
	 * Called by centralwidget after changing the menufile.
	 */
	void menuFileChanged(const QString &mFileName);
	
  public slots:

    /** open a document */
    void slotFileOpen();
    /** save a document */
    void slotFileSave();
    /** save a document under a different filename*/
    void slotFileSaveAs();
    /** exits the application */
    void slotFileQuit();
    /** toggle the toolbar*/
    void slotViewToolBar(bool toggle);
    /** toggle the statusbar*/
    void slotViewStatusBar(bool toggle);
	/** cuts a selected item to clipboard */
	void slotCut();
	/** copys a selected item to clipboard */
	void slotCopy();
	/** pastes a text from clipboard AFTER selected item */
	void slotPaste();

    /** shows an about dlg*/
    void slotHelpAbout();


  private:

    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** view_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    /** the main toolbar */
    QToolBar *fileToolbar;
    /** actions for the application initialized in initActions() and used to en/disable them
      * according to your needs during the program */
    QAction *fileOpen;
    QAction *fileSave;
    QAction *fileSaveAs;
    QAction *fileClose;
    QAction *filePrint;
    QAction *fileQuit;
	QAction *fileRestartIce;

	QAction *editCut;
	QAction *editCopy;
	QAction *editPaste;

    QAction *viewToolBar;
    QAction *viewStatusBar;

    QAction *helpAboutApp;

    QCentralWidget *centralWidget;
    /**  */
    QString menuFileName;
    /** Private directory with IceWM's configs.
     */
    QString icewmCfgDir;
	QString programName;

	/**
	 * Checks dirty flag of centralwidget and saves menu if necessary.
	 */
	void checkDirty();

private slots: // Private slots
  /** No descriptions */
  void slotRestartIcewm();
};
#endif 

