{- This module was generated from data in the Kate syntax
   highlighting file cmake.xml, version 1.14, by Alexander Neundorf (neundorf@kde.org) -}

module Text.Highlighting.Kate.Syntax.Cmake
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "CMake"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "CMakeLists.txt;*.cmake;"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("CMake","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("CMake","Normal Text") -> return ()
      ("CMake","Detect Variables") -> return ()
      ("CMake","Command Args") -> return ()
      ("CMake","Macro Args") -> return ()
      ("CMake","Comment") -> (popContext) >> pEndLine
      ("CMake","String") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_commands = Set.fromList $ words $ "add_custom_command add_custom_target add_definitions add_dependencies add_executable add_library add_subdirectory add_test aux_source_directory break build_command build_name cmake_minimum_required cmake_policy configure_file create_test_sourcelist define_property else elseif enable_language enable_testing endforeach endfunction endif endmacro endwhile exec_program execute_process export export_library_dependencies file find_file find_library find_package find_path find_program fltk_wrap_ui foreach function get_cmake_property get_directory_property get_filename_component get_property get_source_file_property get_target_property get_test_property if include include_directories include_external_msproject include_regular_expression install install_files install_programs install_targets link_directories link_libraries list load_cache load_command macro make_directory mark_as_advanced math message option output_required_files project qt_wrap_cpp qt_wrap_ui remove remove_definitions return separate_arguments set set_directory_properties set_property set_source_files_properties set_target_properties set_tests_properties site_name source_group string subdir_depends subdirs target_link_libraries try_compile try_run unset use_mangled_mesa utility_source variable_requires variable_watch while write_file"
list_itkvtk'5fcommands = Set.fromList $ words $ "itk_wrap_tcl vtk_make_instantiator vtk_wrap_java vtk_wrap_python vtk_wrap_tcl"
list_special'5fargs = Set.fromList $ words $ "A ABSOLUTE AFTER ALL ALPHABET AND APPEND APPEND_STRING ARCHIVE ARGS ASCII AUTHOR_WARNING B BEFORE BRIEF_DOCS BUNDLE CACHE CLEAR CMAKE_FIND_ROOT_PATH_BOTH CMAKE_FLAGS CODE COMMAND COMMAND_NAME COMMENT COMPARE COMPILE_DEFINITIONS COMPILE_OUTPUT_VARIABLE COMPILE_RESULT_VAR COMPONENT COMPONENTS CONFIG CONFIGS CONFIGURATION CONFIGURATIONS CONFIGURE COPYONLY COPY_FILE CRLF DEFINED DEFINITION DEPENDS DESTINATION DIRECTORY DIRECTORY_PERMISSIONS DOC DOS DOWNLOAD ENV EQUAL ERROR_FILE ERROR_QUIET ERROR_STRIP_TRAILING_WHITESPACE ERROR_VARIABLE ESCAPE_QUOTES EXACT EXCLUDE EXCLUDE_FROM_ALL EXISTS EXPECTED_HASH EXPECTED_MD5 EXPORT EXPR EXT EXTRA_INCLUDE FATAL_ERROR FILE FILES FILES_MATCHING FILE_PERMISSIONS FIND FOLLOW_SYMLINKS FOO FORCE FRAMEWORK FULL_DOCS FUNCTION GET GLOB GLOBAL GLOB_RECURSE GREATER GROUP_EXECUTE GROUP_READ GUID HEX HINTS IMPLICIT_DEPENDS IMPORTED IN INACTIVITY_TIMEOUT INCLUDE_INTERNALS INHERITED INPUT_FILE INSERT IS_ABSOLUTE IS_DIRECTORY IS_NEWER_THAN IS_SYMLINK ITEMS LENGTH LENGTH_MAXIMUM LENGTH_MINIMUM LESS LF LIBRARY LIMIT LIMIT_COUNT LIMIT_INPUT LIMIT_OUTPUT LINK_INTERFACE_LIBRARIES LISTS LOG MACOSX_BUNDLE MAIN_DEPENDENCY MAKE_DIRECTORY MATCH MATCHALL MATCHES MODULE NAME NAMELINK_ONLY NAMELINK_SKIP NAMES NAMESPACE NAME_WE NEW NEWLINE_CONSUME NEWLINE_STYLE NOT NOTEQUAL NO_CMAKE_BUILDS_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_FIND_ROOT_PATH NO_CMAKE_PACKAGE_REGISTRY NO_CMAKE_PATH NO_CMAKE_SYSTEM_PACKAGE_REGISTRY NO_CMAKE_SYSTEM_PATH NO_DEFAULT_PATH NO_HEX_CONVERSION NO_MODULE NO_POLICY_SCOPE NO_SOURCE_PERMISSIONS NO_SYSTEM_ENVIRONMENT_PATH OBJECT OFFSET OLD ONLY_CMAKE_FIND_ROOT_PATH OPTIONAL OPTIONAL_COMPONENTS OR OUTPUT OUTPUT_DIRECTORY OUTPUT_FILE OUTPUT_QUIET OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE OWNER_EXECUTE OWNER_READ OWNER_WRITE PACKAGE PARENT_SCOPE PATH PATHS PATH_SUFFIXES PATH_TO_MESA PATTERN PERMISSIONS PLATFORM POLICY POP POST_BUILD PREORDER PRE_BUILD PRE_LINK PRIVATE_HEADER PROGRAM PROGRAMS PROGRAM_ARGS PROJECT_NAME PROPERTIES PROPERTY PUBLIC_HEADER PUSH QUIET RANDOM RANDOM_SEED RANGE READ READ_WITH_PREFIX REALPATH REGEX REGULAR_EXPRESSION RELATIVE RELATIVE_PATH REMOVE REMOVE_AT REMOVE_DUPLICATES REMOVE_ITEM REMOVE_RECURSE RENAME REPLACE REQUIRED REQUIRED_VARIABLE1 REQUIRED_VARIABLE2 RESOURCE RESULT_VAR RESULT_VARIABLE RETURN_VALUE REVERSE RUNTIME RUNTIME_DIRECTORY RUN_OUTPUT_VARIABLE RUN_RESULT_VAR SCRIPT SEND_ERROR SET SHA1 SHA224 SHA256 SHA384 SHARED SHOW_PROGRESS SORT SOURCE SOURCES STATIC STATUS STREQUAL STRGREATER STRINGS STRIP STRLESS SUBSTRING SYSTEM TARGET TARGETS TEST TEST_VARIABLE TIMEOUT TLS_CAINFO TLS_VERIFY TOLOWER TOUPPER TO_CMAKE_PATH TO_NATIVE_PATH TYPE UNIX UPLOAD USE_SOURCE_PERMISSIONS VALUE VAR VAR2 VARIABLE VERBATIM VERSION VERSION_EQUAL VERSION_GREATER VERSION_LESS WARNING WIN32 WORKING_DIRECTORY WRITE"
list_extra'5fspecial'5fargs = Set.fromList $ words $ "GLOBAL INTERNAL"
list_properties = Set.fromList $ words $ "ABSTRACT ADDITIONAL_MAKE_CLEAN_FILES ADVANCED ALLOW_DUPLICATE_CUSTOM_TARGETS ARCHIVE_OUTPUT_DIRECTORY ARCHIVE_OUTPUT_NAME ATTACHED_FILES ATTACHED_FILES_ON_FAIL AUTOMOC AUTOMOC_MOC_OPTIONS BUILD_WITH_INSTALL_RPATH BUNDLE BUNDLE_EXTENSION CACHE_VARIABLES CLEAN_NO_CUSTOM COMPILE_DEFINITIONS COMPILE_FLAGS COST DEBUG_CONFIGURATIONS DEBUG_POSTFIX DEFINE_SYMBOL DEFINITIONS DEPENDS DISABLED_FEATURES ENABLED_FEATURES ENABLED_LANGUAGES ENABLE_EXPORTS ENVIRONMENT EXCLUDE_FROM_ALL EXTERNAL_OBJECT EchoString FAIL_REGULAR_EXPRESSION FIND_LIBRARY_USE_LIB64_PATHS FIND_LIBRARY_USE_OPENBSD_VERSIONING FOLDER FRAMEWORK Fortran_FORMAT Fortran_MODULE_DIRECTORY GENERATED GENERATOR_FILE_NAME GLOBAL_DEPENDS_DEBUG_MODE GLOBAL_DEPENDS_NO_CYCLES GNUtoMS HAS_CXX HEADER_FILE_ONLY HELPSTRING IMPLICIT_DEPENDS_INCLUDE_TRANSFORM IMPORTED IMPORTED_CONFIGURATIONS IMPORTED_IMPLIB IMPORTED_LINK_DEPENDENT_LIBRARIES IMPORTED_LINK_INTERFACE_LANGUAGES IMPORTED_LINK_INTERFACE_LIBRARIES IMPORTED_LINK_INTERFACE_MULTIPLICITY IMPORTED_LOCATION IMPORTED_NO_SONAME IMPORTED_SONAME IMPORT_PREFIX IMPORT_SUFFIX INCLUDE_DIRECTORIES INCLUDE_REGULAR_EXPRESSION INSTALL_NAME_DIR INSTALL_RPATH INSTALL_RPATH_USE_LINK_PATH INTERPROCEDURAL_OPTIMIZATION IN_TRY_COMPILE KEEP_EXTENSION LABELS LANGUAGE LIBRARY_OUTPUT_DIRECTORY LIBRARY_OUTPUT_NAME LINKER_LANGUAGE LINK_DEPENDS LINK_DIRECTORIES LINK_FLAGS LINK_INTERFACE_LIBRARIES LINK_INTERFACE_MULTIPLICITY LINK_SEARCH_END_STATIC LINK_SEARCH_START_STATIC LISTFILE_STACK LOCATION MACOSX_BUNDLE MACOSX_BUNDLE_INFO_PLIST MACOSX_FRAMEWORK_INFO_PLIST MACOSX_PACKAGE_LOCATION MACROS MEASUREMENT MODIFIED NO_SONAME OBJECT_DEPENDS OBJECT_OUTPUTS OSX_ARCHITECTURES OUTPUT_NAME PACKAGES_FOUND PACKAGES_NOT_FOUND PARENT_DIRECTORY PASS_REGULAR_EXPRESSION PDB_NAME PDB_OUTPUT_DIRECTORY POSITION_INDEPENDENT_CODE POST_INSTALL_SCRIPT PREDEFINED_TARGETS_FOLDER PREFIX PRE_INSTALL_SCRIPT PRIVATE_HEADER PROCESSORS PROJECT_LABEL PUBLIC_HEADER REPORT_UNDEFINED_PROPERTIES REQUIRED_FILES RESOURCE RESOURCE_LOCK RULE_LAUNCH_COMPILE RULE_LAUNCH_CUSTOM RULE_LAUNCH_LINK RULE_MESSAGES RUNTIME_OUTPUT_DIRECTORY RUNTIME_OUTPUT_NAME RUN_SERIAL SKIP_BUILD_RPATH SOURCES SOVERSION STATIC_LIBRARY_FLAGS STRINGS SUFFIX SYMBOLIC TARGET_ARCHIVES_MAY_BE_SHARED_LIBS TARGET_SUPPORTS_SHARED_LIBS TEST_INCLUDE_FILE TIMEOUT TYPE USE_FOLDERS VALUE VARIABLES VERSION VS_DOTNET_REFERENCES VS_GLOBAL_KEYWORD VS_GLOBAL_PROJECT_TYPES VS_KEYWORD VS_SCC_AUXPATH VS_SCC_LOCALPATH VS_SCC_PROJECTNAME VS_SCC_PROVIDER VS_WINRT_EXTENSIONS VS_WINRT_REFERENCES WILL_FAIL WIN32_EXECUTABLE WORKING_DIRECTORY WRAP_EXCLUDE __CMAKE_DELETE_CACHE_CHANGE_VARS_"
list_extra'5fproperties = Set.fromList $ words $ "COMMANDS DEFINITION"

regex_'23'5cs'2aBEGIN'2e'2a'24 = compileRegex "#\\s*BEGIN.*$"
regex_'23'5cs'2aEND'2e'2a'24 = compileRegex "#\\s*END.*$"
regex_'5cw'2b'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "\\w+\\s*(?=\\()"
regex_'5c'24ENV'5c'7b'5cs'2a'5cw'2b'5cs'2a'5c'7d = compileRegex "\\$ENV\\{\\s*\\w+\\s*\\}"
regex_'5c'24'5c'7b'5cs'2a'5cw'2b'5cs'2a'5c'7d = compileRegex "\\$\\{\\s*\\w+\\s*\\}"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'22'28'3f'3d'5b_'29'3b'5d'7c'24'29 = compileRegex "\"(?=[ );]|$)"
regex_'5c'5c'5b'22'24n'5c'5c'5d = compileRegex "\\\\[\"$n\\\\]"

parseRules ("CMake","Normal Text") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_commands >>= withAttribute KeywordTok) >>~ pushContext ("CMake","Command Args"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_itkvtk'5fcommands >>= withAttribute FunctionTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aBEGIN'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aEND'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("CMake","Comment"))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   ((pRegExpr regex_'5cw'2b'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute FunctionTok) >>~ pushContext ("CMake","Macro Args"))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Detect Variables") =
  (((pRegExpr regex_'5c'24ENV'5c'7b'5cs'2a'5cw'2b'5cs'2a'5c'7d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5cs'2a'5cw'2b'5cs'2a'5c'7d >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Detect Variables")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Command Args") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special'5fargs >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extra'5fspecial'5fargs >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_properties >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extra'5fproperties >>= withAttribute OtherTok))
   <|>
   ((parseRules ("CMake","Macro Args")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Command Args")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Macro Args") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "\\\"" >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("CMake","String"))
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Macro Args")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CMake","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("CMake","String") =
  (((pRegExpr regex_'22'28'3f'3d'5b_'29'3b'5d'7c'24'29 >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'22'24n'5c'5c'5d >>= withAttribute CharTok))
   <|>
   ((parseRules ("CMake","Detect Variables")))
   <|>
   (currentContext >>= \x -> guard (x == ("CMake","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("CMake","Normal Text") <|> fail ("Unknown context" ++ show x)
