GNATdoc.Documentation = {
  "label": "Gtkada.Printing",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gtkada_Print_Operation",
          "qualifier": "",
          "line": 104,
          "column": 9,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 104,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation",
                      "href": "docs/gtkada__printing___spec.html#L104C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Gtkada_Print_Operation_Record",
          "qualifier": "",
          "line": 102,
          "column": 9,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L102C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Operation_Record",
                      "href": "docs/gtk__print_operation___spec.html#L97C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "Gtk_Print_Operation_Record",
              "docHref": "docs/gtk__print_operation___spec.html#L97C9"
            }
          ]
        }
      ],
      "label": "Tagged types"
    },
    {
      "entities": [
        {
          "label": "Connect_And_Run",
          "qualifier": "",
          "line": 110,
          "column": 13,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 110,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect_And_Run",
                      "href": "docs/gtkada__printing___spec.html#L110C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 111,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L111C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 112,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Action",
                      "href": "docs/gtkada__printing___spec.html#L112C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Operation_Action",
                      "href": "docs/gtk__print_operation___spec.html#L122C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 113,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Parent",
                      "href": "docs/gtkada__printing___spec.html#L113C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Window_Record",
                      "href": "docs/gtk__window___spec.html#L73C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 114,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtkada__printing___spec.html#L114C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 115,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Operation_Result",
                      "href": "docs/gtk__print_operation___spec.html#L114C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Runs the print operation, using the handlers installed in Op.\n"
                },
                {
                  "kind": "span",
                  "text": "See Gtk.Print_Operations.Run.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 111,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Action",
              "line": 112,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Operation.Gtk_Print_Operation_Action",
                "docHref": "docs/gtk__print_operation___spec.html#L122C9"
              },
              "description": [
              ]
            },
            {
              "label": "Parent",
              "line": 113,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 114,
              "column": 7,
              "type": {
                "label": "Glib.Error.GError",
                "docHref": "docs/glib__error___spec.html#L36C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New",
          "qualifier": "",
          "line": 106,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New",
                      "href": "docs/gtkada__printing___spec.html#L106C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L106C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation",
                      "href": "docs/gtkada__printing___spec.html#L104C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 106,
              "column": 23,
              "type": {
                "label": "Gtkada.Printing.Gtkada_Print_Operation",
                "docHref": "docs/gtkada__printing___spec.html#L104C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 107,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 107,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/gtkada__printing___spec.html#L107C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtkada__printing___spec.html#L107C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initialize the print operation\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Widget",
              "line": 107,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    },
    {
      "entities": [
        {
          "label": "Begin_Print",
          "qualifier": "",
          "line": 142,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 142,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Begin_Print",
                      "href": "docs/gtkada__printing___spec.html#L142C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 143,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L143C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 144,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L144C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called after the user has finished changing print settings in the\n"
                },
                {
                  "kind": "span",
                  "text": "dialog, before the actual rendering starts.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A typical use is to use the parameters from the\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk_Print_Context and paginate the document accordingly, and then\n"
                },
                {
                  "kind": "span",
                  "text": "set the number of pages with Gtk.Print_Operation.Set_N_Pages.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 143,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 144,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Done",
          "qualifier": "",
          "line": 152,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 152,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Done",
                      "href": "docs/gtkada__printing___spec.html#L152C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 153,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L153C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 154,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Result",
                      "href": "docs/gtkada__printing___spec.html#L154C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Operation_Result",
                      "href": "docs/gtk__print_operation___spec.html#L114C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called when the print operation run has finished doing everything\n"
                },
                {
                  "kind": "span",
                  "text": "required for printing.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Result gives you information about what happened during the run.\n"
                },
                {
                  "kind": "span",
                  "text": "If Result is Result_Error then you can call Get_Error for more\n"
                },
                {
                  "kind": "span",
                  "text": "information.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If you enabled print status tracking then\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Operation.Is_Finished may still return False after\n"
                },
                {
                  "kind": "span",
                  "text": "done was emitted.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 153,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Result",
              "line": 154,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Operation.Gtk_Print_Operation_Result",
                "docHref": "docs/gtk__print_operation___spec.html#L114C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Draw_Page",
          "qualifier": "",
          "line": 127,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 127,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Draw_Page",
                      "href": "docs/gtkada__printing___spec.html#L127C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 128,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L128C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 129,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L129C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 130,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Page_Number",
                      "href": "docs/gtkada__printing___spec.html#L130C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called for every page that is printed. This handler must render the\n"
                },
                {
                  "kind": "span",
                  "text": "page Page_Number onto the cairo context obtained from Context using\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Context.Get_Cairo_Context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Use Gtk.Print_Operation.Set_Use_Full_Page and\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Operation.Set_Unit before starting the print operation to set\n"
                },
                {
                  "kind": "span",
                  "text": "up the transformation of the cairo context according to your needs.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This is the main printing handler. This has to be overridden for the\n"
                },
                {
                  "kind": "span",
                  "text": "printing operation to work.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 128,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 129,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            },
            {
              "label": "Page_Number",
              "line": 130,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "End_Print",
          "qualifier": "",
          "line": 166,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 166,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "End_Print",
                      "href": "docs/gtkada__printing___spec.html#L166C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 167,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L167C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 168,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L168C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called after all pages have been rendered.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This handler can clean up any resources that have been allocated\n"
                },
                {
                  "kind": "span",
                  "text": "in Begin_Print.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 167,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 168,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Paginate",
          "qualifier": "",
          "line": 174,
          "column": 13,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 174,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Paginate",
                      "href": "docs/gtkada__printing___spec.html#L174C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 175,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L175C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 176,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L176C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called after the \"begin-print\" signal, but before the actual rendering\n"
                },
                {
                  "kind": "span",
                  "text": "starts. It keeps getting called until it returns True.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The \"paginate\" signal is intended to be used for paginating a document\n"
                },
                {
                  "kind": "span",
                  "text": "in small chunks, to avoid blocking the user interface for a long\n"
                },
                {
                  "kind": "span",
                  "text": "time. This function should update the number of pages using\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Operation.Set_N_Pages, and return True if the document\n"
                },
                {
                  "kind": "span",
                  "text": "has been completely paginated.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If you don't need to do pagination in chunks, you can simply do\n"
                },
                {
                  "kind": "span",
                  "text": "it all in the \"begin-print\" handler, and set the number of pages\n"
                },
                {
                  "kind": "span",
                  "text": "from there.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 175,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 176,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Preview",
          "qualifier": "",
          "line": 190,
          "column": 13,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 190,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Preview",
                      "href": "docs/gtkada__printing___spec.html#L190C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 191,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L191C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 192,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Preview",
                      "href": "docs/gtkada__printing___spec.html#L192C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Operation_Preview",
                      "href": "docs/gtk__print_operation_preview___spec.html#L34C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 193,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L193C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 194,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Parent",
                      "href": "docs/gtkada__printing___spec.html#L194C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Window",
                      "href": "docs/gtk__window___spec.html#L74C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 195,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called when a preview is requested from the native dialog.\n"
                },
                {
                  "kind": "span",
                  "text": "This should return True if the in order to take over control of the\n"
                },
                {
                  "kind": "span",
                  "text": "preview.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default handler for this signal uses an external viewer\n"
                },
                {
                  "kind": "span",
                  "text": "application to preview.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "To implement a custom print preview, the overridden implementation\n"
                },
                {
                  "kind": "span",
                  "text": "should return True\n"
                },
                {
                  "kind": "span",
                  "text": "In order to use the provided Context for the preview implementation, it\n"
                },
                {
                  "kind": "span",
                  "text": "must be given a suitable cairo context with Set_Cairo_Context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The custom preview implementation can use\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Operation_Preview.Is_Selected and\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Print_Operation_Preview.Render_Page to find pages which\n"
                },
                {
                  "kind": "span",
                  "text": "are selected for print and render them. The preview must be\n"
                },
                {
                  "kind": "span",
                  "text": "finished by calling Gtk.Print_Operation_Preview.End_Preview\n"
                },
                {
                  "kind": "span",
                  "text": "(typically in response to the user clicking a close button).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 191,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Preview",
              "line": 192,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Operation_Preview.Gtk_Print_Operation_Preview",
                "docHref": "docs/gtk__print_operation_preview___spec.html#L34C9"
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 193,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            },
            {
              "label": "Parent",
              "line": 194,
              "column": 7,
              "type": {
                "label": "Gtk.Window.Gtk_Window",
                "docHref": "docs/gtk__window___spec.html#L74C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Request_Page_Setup",
          "qualifier": "",
          "line": 215,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 215,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Request_Page_Setup",
                      "href": "docs/gtkada__printing___spec.html#L215C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 216,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L216C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 217,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Context",
                      "href": "docs/gtkada__printing___spec.html#L217C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Print_Context",
                      "href": "docs/gtk__print_context___spec.html#L93C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 218,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Page_Number",
                      "href": "docs/gtkada__printing___spec.html#L218C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 219,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Setup",
                      "href": "docs/gtkada__printing___spec.html#L219C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Page_Setup",
                      "href": "docs/gtk__page_setup___spec.html#L72C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called once for every page that is printed, to give the application\n"
                },
                {
                  "kind": "span",
                  "text": "a chance to modify the page setup. Any changes done to setup will be\n"
                },
                {
                  "kind": "span",
                  "text": "in force only for printing this page.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 216,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Context",
              "line": 217,
              "column": 7,
              "type": {
                "label": "Gtk.Print_Context.Gtk_Print_Context",
                "docHref": "docs/gtk__print_context___spec.html#L93C9"
              },
              "description": [
              ]
            },
            {
              "label": "Page_Number",
              "line": 218,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Setup",
              "line": 219,
              "column": 7,
              "type": {
                "label": "Gtk.Page_Setup.Gtk_Page_Setup",
                "docHref": "docs/gtk__page_setup___spec.html#L72C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Status_Changed",
          "qualifier": "",
          "line": 224,
          "column": 14,
          "src": "srcs/gtkada-printing.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 224,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status_Changed",
                      "href": "docs/gtkada__printing___spec.html#L224C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Op",
                      "href": "docs/gtkada__printing___spec.html#L224C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Print_Operation_Record",
                      "href": "docs/gtkada__printing___spec.html#L232C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Called between the various phases of the print operation.\n"
                },
                {
                  "kind": "span",
                  "text": "See Gtk_Print_Status for the phases that are being discriminated.\n"
                },
                {
                  "kind": "span",
                  "text": "Use Gtk.Print_Operation.Get_Status to find out the current\n"
                },
                {
                  "kind": "span",
                  "text": "status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Op",
              "line": 224,
              "column": 30,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Dispatching subprograms"
    }
  ]
};