GNATdoc.Documentation = {
  "label": "Gtkada.Multi_Paned",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Root_Pane",
          "qualifier": "",
          "line": 49,
          "column": 4,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 49,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Root_Pane"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The root pane. If you split this one, the newly added window will be\n"
                },
                {
                  "kind": "span",
                  "text": "next to all other windows. For instance, if you split vertically with\n"
                },
                {
                  "kind": "span",
                  "text": "the main_pane the following window, you will get:\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+-----+------+        +-----+------+"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "|  1  |      |        |  1  |      |"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+-----+  3   |    =>  +-----+  3   |"
                    }
                  ]
                },
                {
                  "number": 4,
                  "children": [
                    {
                      "kind": "span",
                      "text": "|  2  |      |        |  2  |      |"
                    }
                  ]
                },
                {
                  "number": 5,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+-----+------+        +-----+------+"
                    }
                  ]
                },
                {
                  "number": 6,
                  "children": [
                    {
                      "kind": "span",
                      "text": "                      |     4      |"
                    }
                  ]
                },
                {
                  "number": 7,
                  "children": [
                    {
                      "kind": "span",
                      "text": "                      +------------+"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Constants and variables"
    },
    {
      "entities": [
        {
          "label": "Debug_Level_Change",
          "qualifier": "",
          "line": 266,
          "column": 9,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 266,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Level_Change",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Preserve",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C32"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Increase",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C48"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Decrease",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C64"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C9"
                    }
                  ]
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Debug_Preserve",
              "line": 266,
              "column": 32,
              "description": [
              ]
            },
            {
              "label": "Debug_Increase",
              "line": 266,
              "column": 48,
              "description": [
              ]
            },
            {
              "label": "Debug_Decrease",
              "line": 266,
              "column": 64,
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Simple types"
    },
    {
      "entities": [
        {
          "label": "Gtkada_Multi_Paned",
          "qualifier": "",
          "line": 42,
          "column": 9,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 42,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned",
                      "href": "docs/gtkada__multi_paned___spec.html#L42C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Pane",
          "qualifier": "",
          "line": 44,
          "column": 9,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 44,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L44C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "An area of the window, which can is splitted either horizontally or\n"
                },
                {
                  "kind": "span",
                  "text": "vertically. It can contain one or several children, next to each other,\n"
                },
                {
                  "kind": "span",
                  "text": "or on top of one another.\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Child_Iterator",
          "qualifier": "",
          "line": 213,
          "column": 9,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 213,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L213C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Record types"
    },
    {
      "entities": [
        {
          "label": "Gtkada_Multi_Paned_Record",
          "qualifier": "",
          "line": 40,
          "column": 9,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 40,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L40C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Fixed.Gtk_Fixed_Record",
                      "href": "docs/gtk__fixed___spec.html#L73C9"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 41,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "Gtk_Fixed_Record",
              "docHref": "docs/gtk__fixed___spec.html#L73C9"
            }
          ]
        }
      ],
      "label": "Tagged types"
    },
    {
      "entities": [
        {
          "label": "At_End",
          "qualifier": "",
          "line": 221,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 221,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "At_End",
                      "href": "docs/gtkada__multi_paned___spec.html#L221C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L221C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "True if there is no more child to be returned\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 221,
              "column": 21,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Dump",
          "qualifier": "",
          "line": 260,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 260,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dump",
                      "href": "docs/gtkada__multi_paned___spec.html#L260C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Split",
                      "href": "docs/gtkada__multi_paned___spec.html#L260C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Dump the configuration of Split to stdout. This is only intended for\n"
                },
                {
                  "kind": "span",
                  "text": "testing purposes. If you want to save and restore this configuration,\n"
                },
                {
                  "kind": "span",
                  "text": "you should look at Gtkada.MDI instead, which contains all the\n"
                },
                {
                  "kind": "span",
                  "text": "subprograms needed to handle desktops.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Split",
              "line": 260,
              "column": 20,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Depth",
          "qualifier": "",
          "line": 239,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 239,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Depth",
                      "href": "docs/gtkada__multi_paned___spec.html#L239C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L239C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Natural"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the depth of the current child (0 means the child is at the\n"
                },
                {
                  "kind": "span",
                  "text": "toplevel, 1 that this is a child directly underneath,...).\n"
                },
                {
                  "kind": "span",
                  "text": "This can be used to detect when the Iter has finished traversing one\n"
                },
                {
                  "kind": "span",
                  "text": "of the panes.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 239,
              "column": 24,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Orientation",
          "qualifier": "",
          "line": 233,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 233,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L233C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 234,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L234C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the orientation of the current child. This is only relevant if\n"
                },
                {
                  "kind": "span",
                  "text": "the child doesn't contain a widget (and therefore Get_Widget has\n"
                },
                {
                  "kind": "span",
                  "text": "returned null).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 234,
              "column": 7,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Pane",
          "qualifier": "",
          "line": 131,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 131,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L131C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Current_Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L131C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L275C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L275C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the pane that contains the widget. See comment for Split below.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Current_Pane",
              "line": 131,
              "column": 23,
              "type": {
                "label": "Gtkada.Multi_Paned.Pane",
                "docHref": "docs/gtkada__multi_paned___spec.html#L44C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Size",
          "qualifier": "",
          "line": 245,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 245,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L245C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 246,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L246C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 247,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L247C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L247C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "               "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 248,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Parent_Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L248C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Parent_Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L248C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 249,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Parent_Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L249C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the size of the current element (pane or widget), as well as the\n"
                },
                {
                  "kind": "span",
                  "text": "parent's pane (the resizable area that contains notebooks or other\n"
                },
                {
                  "kind": "span",
                  "text": "panes). The parent size is the total size devoted to its children,\n"
                },
                {
                  "kind": "span",
                  "text": "omitting the size occupied by resize handles.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 246,
              "column": 7,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 247,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 247,
              "column": 14,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Parent_Width",
              "line": 248,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Parent_Height",
              "line": 248,
              "column": 21,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Parent_Orientation",
              "line": 249,
              "column": 7,
              "type": {
                "label": "Gtk.Enums.Gtk_Orientation",
                "docHref": "docs/gtk__enums___spec.html#L255C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 65,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 65,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/gtkada__multi_paned___spec.html#L65C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the internal type\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Widget",
          "qualifier": "",
          "line": 227,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 227,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Widget",
                      "href": "docs/gtkada__multi_paned___spec.html#L227C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L227C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget",
                      "href": "docs/gtk__widget___spec.html#L344C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the widget embedded in the current child. This returns null if\n"
                },
                {
                  "kind": "span",
                  "text": "the current child is only used as a pane separator (horizontal or\n"
                },
                {
                  "kind": "span",
                  "text": "vertical). You mustn't remove the widget from the paned widget, or the\n"
                },
                {
                  "kind": "span",
                  "text": "iterator becomes invalid.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 227,
              "column": 25,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New",
          "qualifier": "",
          "line": 61,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 61,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New",
                      "href": "docs/gtkada__multi_paned___spec.html#L61C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L61C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned",
                      "href": "docs/gtkada__multi_paned___spec.html#L42C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 61,
              "column": 23,
              "type": {
                "label": "Gtkada.Multi_Paned.Gtkada_Multi_Paned",
                "docHref": "docs/gtkada__multi_paned___spec.html#L42C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Handle_Size",
          "qualifier": "",
          "line": 68,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 68,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Handle_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L68C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 69,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L69C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "returns the size of the handle\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 69,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 62,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 62,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/gtkada__multi_paned___spec.html#L62C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L62C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a new paned window.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 62,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Next",
          "qualifier": "",
          "line": 224,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 224,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Next",
                      "href": "docs/gtkada__multi_paned___spec.html#L224C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtkada__multi_paned___spec.html#L224C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "in"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Move to the next child of Iterator\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Iter",
              "line": 224,
              "column": 20,
              "type": {
                "label": "Gtkada.Multi_Paned.Child_Iterator",
                "docHref": "docs/gtkada__multi_paned___spec.html#L213C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Print_Debug",
          "qualifier": "",
          "line": 267,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 267,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Print_Debug",
                      "href": "docs/gtkada__multi_paned___spec.html#L267C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 268,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Msg",
                      "href": "docs/gtkada__multi_paned___spec.html#L268C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Mode",
                      "href": "docs/gtkada__multi_paned___spec.html#L268C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Level_Change",
                      "href": "docs/gtkada__multi_paned___spec.html#L266C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Debug_Preserve"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Debug support\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Msg",
              "line": 268,
              "column": 7,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            },
            {
              "label": "Mode",
              "line": 268,
              "column": 21,
              "type": {
                "label": "Gtkada.Multi_Paned.Debug_Level_Change",
                "docHref": "docs/gtkada__multi_paned___spec.html#L266C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    },
    {
      "entities": [
        {
          "label": "Add_Child",
          "qualifier": "",
          "line": 77,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 77,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Child",
                      "href": "docs/gtkada__multi_paned___spec.html#L77C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 78,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L78C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 79,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "New_Child",
                      "href": "docs/gtkada__multi_paned___spec.html#L79C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 80,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L80C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 81,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Orientation_Horizontal"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 82,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fixed_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L82C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 83,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L83C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L83C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "-"
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 84,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/gtkada__multi_paned___spec.html#L84C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "True"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Add new child, splitting as needed.\n"
                },
                {
                  "kind": "span",
                  "text": "This should be used when there is no child yet\n"
                },
                {
                  "kind": "span",
                  "text": "The window is splitted in two by default. However, if Width and Height\n"
                },
                {
                  "kind": "span",
                  "text": "are specified (or left to -1 for automatic computation), the window is\n"
                },
                {
                  "kind": "span",
                  "text": "splitted so that amount of screen space is left to the widget\n"
                },
                {
                  "kind": "span",
                  "text": "(leaving some minimum amount of space to other children as needed).\n"
                },
                {
                  "kind": "span",
                  "text": "If Fixed_Size is true, then the size of the dock will not change when\n"
                },
                {
                  "kind": "span",
                  "text": "Win is resized. Otherwise, it will keep its relative size (x% of the\n"
                },
                {
                  "kind": "span",
                  "text": "total size of Win). This Fixed_Size setting will be reset to False\n"
                },
                {
                  "kind": "span",
                  "text": "as soon as the user has resized a pane with the mouse.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 78,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "New_Child",
              "line": 79,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Orientation",
              "line": 80,
              "column": 7,
              "type": {
                "label": "Gtk.Enums.Gtk_Orientation",
                "docHref": "docs/gtk__enums___spec.html#L255C9"
              },
              "description": [
              ]
            },
            {
              "label": "Fixed_Size",
              "line": 82,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 83,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 83,
              "column": 14,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 84,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Freeze",
          "qualifier": "",
          "line": 198,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 198,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Freeze",
                      "href": "docs/gtkada__multi_paned___spec.html#L198C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L198C22"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Freeze the window, ie when a child is inserted, no computation of its\n"
                },
                {
                  "kind": "span",
                  "text": "size is done, and will not generate immediate resizing.\n"
                },
                {
                  "kind": "span",
                  "text": "You only need to call this procedure when restoring Win to a previously\n"
                },
                {
                  "kind": "span",
                  "text": "state saved, and never if you are using the GtkAda.MDI which takes care\n"
                },
                {
                  "kind": "span",
                  "text": "of it on its own.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 198,
              "column": 22,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Pane",
          "qualifier": "",
          "line": 128,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 128,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L128C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 129,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L129C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 130,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtkada__multi_paned___spec.html#L130C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L275C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 129,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Widget",
              "line": 130,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Opaque_Resizing",
          "qualifier": "",
          "line": 72,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 72,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Opaque_Resizing",
                      "href": "docs/gtkada__multi_paned___spec.html#L72C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 73,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L73C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Opaque",
                      "href": "docs/gtkada__multi_paned___spec.html#L73C47"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Whether resizing of the widgets should be opaque or not. The default\n"
                },
                {
                  "kind": "span",
                  "text": "is not to do opaque resizing for efficiency reasons\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 73,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Opaque",
              "line": 73,
              "column": 47,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Size",
          "qualifier": "",
          "line": 108,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 108,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L108C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 109,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L109C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 110,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtkada__multi_paned___spec.html#L110C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 111,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L111C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L111C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "-"
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 112,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fixed_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L112C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 113,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Force_Given_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L113C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Try to update the size of Widget considering its siblings.\n"
                },
                {
                  "kind": "span",
                  "text": "If Force_Given_Size is true then Widget will have the exact sizes\n"
                },
                {
                  "kind": "span",
                  "text": "given to this function. Thus it will ignore the actual state of the\n"
                },
                {
                  "kind": "span",
                  "text": "multipaned and can deform its siblings.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 109,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Widget",
              "line": 110,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 111,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 111,
              "column": 14,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Fixed_Size",
              "line": 112,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            },
            {
              "label": "Force_Given_Size",
              "line": 113,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Split",
          "qualifier": "",
          "line": 96,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 96,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Split",
                      "href": "docs/gtkada__multi_paned___spec.html#L96C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 97,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L97C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 98,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ref_Widget",
                      "href": "docs/gtkada__multi_paned___spec.html#L98C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 99,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "New_Child",
                      "href": "docs/gtkada__multi_paned___spec.html#L99C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 100,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L100C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 101,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fixed_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L101C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L102C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L102C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "-"
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/gtkada__multi_paned___spec.html#L103C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "True"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Split the pane containing Ref_Widget, and add New_Child\n"
                },
                {
                  "kind": "span",
                  "text": "in the new pane (on the right or at the bottom if After is True, on the\n"
                },
                {
                  "kind": "span",
                  "text": "left or at the top if After is False).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 97,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Ref_Widget",
              "line": 98,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "New_Child",
              "line": 99,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Orientation",
              "line": 100,
              "column": 7,
              "type": {
                "label": "Gtk.Enums.Gtk_Orientation",
                "docHref": "docs/gtk__enums___spec.html#L255C9"
              },
              "description": [
              ]
            },
            {
              "label": "Fixed_Size",
              "line": 101,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 102,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 102,
              "column": 14,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 103,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Split",
          "qualifier": "",
          "line": 134,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 134,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Split",
                      "href": "docs/gtkada__multi_paned___spec.html#L134C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 135,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L135C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 136,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ref_Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L136C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pane",
                      "href": "docs/gtkada__multi_paned___spec.html#L275C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 137,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "New_Child",
                      "href": "docs/gtkada__multi_paned___spec.html#L137C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 138,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L138C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 139,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fixed_Size",
                      "href": "docs/gtkada__multi_paned___spec.html#L139C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 140,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/gtkada__multi_paned___spec.html#L140C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/gtkada__multi_paned___spec.html#L140C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "-"
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 141,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/gtkada__multi_paned___spec.html#L141C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "True"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Split Ref_Pane to display New_Child to one of its sides.\n"
                },
                {
                  "kind": "span",
                  "text": "See the comments for Root_Pane above.\n"
                },
                {
                  "kind": "span",
                  "text": "The examples below assume that you are using one of the two split\n"
                },
                {
                  "kind": "span",
                  "text": "procedures, either with a Ref_Pane or a Ref_Widget. In the former case,\n"
                },
                {
                  "kind": "span",
                  "text": "the pane is obtained with a call to Get_Pane(Ref_Widget).\n"
                },
                {
                  "kind": "span",
                  "text": "As you will see, the results are different (although they might appear\n"
                },
                {
                  "kind": "span",
                  "text": "similar sometimes on this simple example.\n"
                },
                {
                  "kind": "span",
                  "text": "In all these examples, we split either vertically or horizontally, and\n"
                },
                {
                  "kind": "span",
                  "text": "add a new widget \"4\".\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Given the following setup:\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+---+---+"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "| 1 |   |"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+---+ 3 |"
                    }
                  ]
                },
                {
                  "number": 4,
                  "children": [
                    {
                      "kind": "span",
                      "text": "| 2 |   |"
                    }
                  ]
                },
                {
                  "number": 5,
                  "children": [
                    {
                      "kind": "span",
                      "text": "+---+---+"
                    }
                  ]
                },
                {
                  "number": 6,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Ref_Pane = Get_Pane (\"1\")              Ref_Widget = \"1\"\n"
                },
                {
                  "kind": "span",
                  "text": "Split vertically\n"
                },
                {
                  "kind": "span",
                  "text": "After=True  After=False        After=True   After=False\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+   +---+---+          +---+---+    +---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "| 1 | 3 |   | 4 | 3 |          | 1 | 3 |    | 4 | 3 |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+   |   +---+   |          +---+   |    +---+   |\n"
                },
                {
                  "kind": "span",
                  "text": "| 2 |   |   | 1 |   |          | 4 |   |    | 1 |   |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+   |   +---+   |          +---+   |    +---+   |\n"
                },
                {
                  "kind": "span",
                  "text": "| 4 |   |   | 2 |   |          | 2 |   |    | 2 |   |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+   +---+---+          +---+---+    +---+---+\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Split horizontally\n"
                },
                {
                  "kind": "span",
                  "text": "After=True     After=False     After=True     After=False\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+---+  +---+---+---+   +---+---+---+  +---+---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "| 1 | 4 | 3 |  | 4 | 1 | 3 |   | 1 | 4 | 3 |  | 4 | 1 | 3 |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+   |   |  |   +---+   |   +---+---+   |  +---+---+   |\n"
                },
                {
                  "kind": "span",
                  "text": "| 2 |   |   |  |   | 2 |   |   |   2   |   |  |   2   |   |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+---+  +---+---+---+   +-------+---+  +-------+---+\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Ref_Pane = Get_Pane (\"3\")             Ref_Widget = \"3\"\n"
                },
                {
                  "kind": "span",
                  "text": "Split vertically\n"
                },
                {
                  "kind": "span",
                  "text": "After=True   After=False       After=True     After=False\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+    +-------+         +---+---+      +---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "| 1 | 3 |    |   4   |         | 1 | 3 |      | 1 | 4 |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+   |    +---+---+         +---+---+      +---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "| 2 |   |    | 1 | 3 |         | 2 | 4 |      | 2 | 3 |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+    +---+   |         +---+---+      +---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "|   4   |    | 2 |   |\n"
                },
                {
                  "kind": "span",
                  "text": "+-------+    +---+---+\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Split horizontally\n"
                },
                {
                  "kind": "span",
                  "text": "After=True     After=False     After=True     After=False\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+---+  +---+---+---+   +---+---+---+  +---+---+---+\n"
                },
                {
                  "kind": "span",
                  "text": "| 1 | 3 | 4 |  | 4 | 1 | 3 |   | 1 | 3 | 4 |  | 1 | 4 | 3 |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+   |   |  |   +---+   |   +---+   |   |  +---+   |   |\n"
                },
                {
                  "kind": "span",
                  "text": "| 2 |   |   |  |   | 2 |   |   | 2 |   |   |  | 2 |   |   |\n"
                },
                {
                  "kind": "span",
                  "text": "+---+---+---+  +---+---+---+   +---+---+---+  +---+---+---+\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 135,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Ref_Pane",
              "line": 136,
              "column": 7,
              "type": {
                "label": "Gtkada.Multi_Paned.Pane",
                "docHref": "docs/gtkada__multi_paned___spec.html#L44C9"
              },
              "description": [
              ]
            },
            {
              "label": "New_Child",
              "line": 137,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Orientation",
              "line": 138,
              "column": 7,
              "type": {
                "label": "Gtk.Enums.Gtk_Orientation",
                "docHref": "docs/gtk__enums___spec.html#L255C9"
              },
              "description": [
              ]
            },
            {
              "label": "Fixed_Size",
              "line": 139,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 140,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 140,
              "column": 14,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 141,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Splitted_Area",
          "qualifier": "",
          "line": 119,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 119,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Splitted_Area",
                      "href": "docs/gtkada__multi_paned___spec.html#L119C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 120,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L120C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 121,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ref_Widget",
                      "href": "docs/gtkada__multi_paned___spec.html#L121C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 122,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Orientation",
                      "href": "docs/gtkada__multi_paned___spec.html#L122C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Enums.Gtk_Orientation",
                      "href": "docs/gtk__enums___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 123,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/gtkada__multi_paned___spec.html#L123C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "True"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget",
                      "href": "docs/gtk__widget___spec.html#L344C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the widget in the splitted area next to Ref_Widget if any exist.\n"
                },
                {
                  "kind": "span",
                  "text": "Orientation and After define which splitted area we are looking at.\n"
                },
                {
                  "kind": "span",
                  "text": "null is returned if there are no such splitted area.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 120,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Ref_Widget",
              "line": 121,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Orientation",
              "line": 122,
              "column": 7,
              "type": {
                "label": "Gtk.Enums.Gtk_Orientation",
                "docHref": "docs/gtk__enums___spec.html#L255C9"
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 123,
              "column": 7,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Start",
          "qualifier": "",
          "line": 215,
          "column": 13,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 215,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Start",
                      "href": "docs/gtkada__multi_paned___spec.html#L215C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 216,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L216C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Iterator",
                      "href": "docs/gtkada__multi_paned___spec.html#L278C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return an iterator to the first child of the window. This also returns\n"
                },
                {
                  "kind": "span",
                  "text": "children which are not widget, but are used to organize the window into\n"
                },
                {
                  "kind": "span",
                  "text": "horizontal and vertical panes\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 216,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Thaw",
          "qualifier": "",
          "line": 205,
          "column": 14,
          "src": "srcs/gtkada-multi_paned.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 205,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Thaw",
                      "href": "docs/gtkada__multi_paned___spec.html#L205C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Win",
                      "href": "docs/gtkada__multi_paned___spec.html#L205C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada_Multi_Paned_Record",
                      "href": "docs/gtkada__multi_paned___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Opposite of Freeze. You should call Size_Allocate on Win afterward to\n"
                },
                {
                  "kind": "span",
                  "text": "force a recomputation of the size\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Win",
              "line": 205,
              "column": 20,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Dispatching subprograms"
    }
  ]
};