GNATdoc.Documentation = {
  "label": "Gtkada.MDI.Desktop",
  "qualifier": "(nested)",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Load_Desktop_Function",
          "qualifier": "",
          "line": 867,
          "column": 12,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 867,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 868,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L868C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window",
                      "href": "docs/gtkada__mdi___spec.html#L67C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Node",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L868C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L868C58"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 869,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Child",
                      "href": "docs/gtkada__mdi___spec.html#L73C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A general function that loads a widget from an XML tree.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "As for Save_Desktop_Function, this function should return null if it\n"
                },
                {
                  "kind": "span",
                  "text": "doesn't know how to handle Node or if Node doesn't describe a widget\n"
                },
                {
                  "kind": "span",
                  "text": "type that it can handle.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns an MDI_Widget that has been put in the MDI.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Menu_Registration_Procedure",
          "qualifier": "",
          "line": 817,
          "column": 12,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 817,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                                 "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 818,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L818C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 819,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item_Name",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L819C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 820,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Accel_Path",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L820C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Function used to register in the application a static menu\n"
                },
                {
                  "kind": "span",
                  "text": "created by the MDI.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Save_Desktop_Function",
          "qualifier": "",
          "line": 852,
          "column": 12,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 852,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 853,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L853C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 854,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L854C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A general function that dumps the parameters of a widget into an XML\n"
                },
                {
                  "kind": "span",
                  "text": "tree.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: you should register one such function for all the widget types\n"
                },
                {
                  "kind": "span",
                  "text": "you will put in the MDI and that need to be saved when a desktop is\n"
                },
                {
                  "kind": "span",
                  "text": "saved. The MDI will call all the registered functions one after the\n"
                },
                {
                  "kind": "span",
                  "text": "other. Therefore, your function should return null if Widget is not\n"
                },
                {
                  "kind": "span",
                  "text": "of a type that is it can handle.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Before calling the registered save_desktop_function, the MDI will\n"
                },
                {
                  "kind": "span",
                  "text": "first use the child's Save_Desktop primitive function.\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Create_Menu",
          "qualifier": "",
          "line": 833,
          "column": 16,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 833,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Menu",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L833C16"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 834,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L834C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "               "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 835,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Accel_Path_Prefix",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L835C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"<gtkada>\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 836,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L836C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 837,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Registration",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L837C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Menu_Registration_Procedure",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L817C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 838,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Menu.Gtk_Menu",
                      "href": "docs/gtk__menu___spec.html#L86C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a dynamic menu that can then be inserted into a menu bar. This\n"
                },
                {
                  "kind": "span",
                  "text": "menu is dynamic, ie its content will changed based on the focus\n"
                },
                {
                  "kind": "span",
                  "text": "child.\n"
                },
                {
                  "kind": "span",
                  "text": "If this function is called several times, a new menu is created\n"
                },
                {
                  "kind": "span",
                  "text": "every time. Accel_Path_Prefix must be the same for every call.\n"
                },
                {
                  "kind": "span",
                  "text": "Accel_Path_Prefix is used so that the key shortcuts associated with\n"
                },
                {
                  "kind": "span",
                  "text": "these menu items can be changed dynamically by the user (see\n"
                },
                {
                  "kind": "span",
                  "text": "gtk-accel_map.ads). The prefix must start with \"\n"
                },
                {
                  "kind": "span",
                  "text": "<\" and end with \">\".\n"
                },
                {
                  "kind": "span",
                  "text": "User is used for the callbacks on perspective changes, and passed to\n"
                },
                {
                  "kind": "span",
                  "text": "Load_Perspective\n"
                },
                {
                  "kind": "span",
                  "text": "With recent versions of gtk+, the use of Glib.Menu_Model.Gmenu_Model\n"
                },
                {
                  "kind": "span",
                  "text": "is encouraged, so you should use Set_Menu_Model above instead.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 834,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Accel_Path_Prefix",
              "line": 835,
              "column": 10,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 836,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            },
            {
              "label": "Registration",
              "line": 837,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.Menu_Registration_Procedure",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L817C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Perspective",
          "qualifier": "",
          "line": 911,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 911,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Perspective",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L911C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 912,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L912C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 913,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Name",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L913C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 914,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L914C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a new perspective with the current desktop layout. If another\n"
                },
                {
                  "kind": "span",
                  "text": "perspective with the same name exists, it is replaced.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 912,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Name",
              "line": 913,
              "column": 10,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 914,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Define_Perspective",
          "qualifier": "",
          "line": 918,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 918,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Define_Perspective",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L918C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 919,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L919C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 920,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "XML",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L920C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 921,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L921C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Define a new perspective (in the same format as returned by\n"
                },
                {
                  "kind": "span",
                  "text": "Save_Desktop, the central area is under control of the user so you\n"
                },
                {
                  "kind": "span",
                  "text": "cannot change it).\n"
                },
                {
                  "kind": "span",
                  "text": "If such a perspective already exists, nothing is done (since the user\n"
                },
                {
                  "kind": "span",
                  "text": "might have modified it already).\n"
                },
                {
                  "kind": "span",
                  "text": "XML's root node is the\n"
                },
                {
                  "kind": "span",
                  "text": "<perspective> node, including its \"name\"\n"
                },
                {
                  "kind": "span",
                  "text": "attribute.\n"
                },
                {
                  "kind": "span",
                  "text": "XML must be freed by the caller.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 919,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "XML",
              "line": 920,
              "column": 10,
              "type": {
                "label": "Glib.XML.Node_Ptr",
                "docHref": "docs/glib__xml___spec.html#L47C9"
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 921,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Free_Registered_Desktop_Functions",
          "qualifier": "",
          "line": 950,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 950,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Free_Registered_Desktop_Functions",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L950C17"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Free the memory allocated for the registered functions.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_XML_Content",
          "qualifier": "",
          "line": 944,
          "column": 16,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 944,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_XML_Content",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L944C16"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 945,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L945C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 946,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Tag",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L946C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return the first XML subtree starting with 'Tag'. This allows a\n"
                },
                {
                  "kind": "span",
                  "text": "module to retrieve its content after the 'Load_Desktop' call.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 945,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Tag",
              "line": 946,
              "column": 10,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Load_Perspective",
          "qualifier": "",
          "line": 901,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 901,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Load_Perspective",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L901C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 902,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L902C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 903,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Name",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L903C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 904,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L904C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Replace the current perspective by another one. This preserves the\n"
                },
                {
                  "kind": "span",
                  "text": "editor area.\n"
                },
                {
                  "kind": "span",
                  "text": "If the perspective does not exist, nothing is done, unless no\n"
                },
                {
                  "kind": "span",
                  "text": "perspective is currently loaded (in which case we load the first\n"
                },
                {
                  "kind": "span",
                  "text": "on in the list).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 902,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Name",
              "line": 903,
              "column": 10,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 904,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Register_Desktop_Functions",
          "qualifier": "",
          "line": 878,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 878,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Register_Desktop_Functions",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L878C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 879,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Save",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L879C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Save_Desktop_Function",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L852C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 880,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Load",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L880C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Load_Desktop_Function",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L867C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Register a set of functions to save and load desktops for some\n"
                },
                {
                  "kind": "span",
                  "text": "specific widget types. This can be called multiple times.\n"
                },
                {
                  "kind": "span",
                  "text": "Save might be null.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Save",
              "line": 879,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.Save_Desktop_Function",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L852C12"
              },
              "description": [
              ]
            },
            {
              "label": "Load",
              "line": 880,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.Load_Desktop_Function",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L867C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Restore_Desktop",
          "qualifier": "",
          "line": 885,
          "column": 16,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 885,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Restore_Desktop",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L885C16"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 886,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L886C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 887,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Perspectives",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L887C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 888,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "From_Tree",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L888C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 889,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L889C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Restore the contents of the MDI from its saved XML tree.\n"
                },
                {
                  "kind": "span",
                  "text": "Perspectives is the list of perspectives. It is cloned as needed, so\n"
                },
                {
                  "kind": "span",
                  "text": "the caller is still responsible for freeing it. The first perspective\n"
                },
                {
                  "kind": "span",
                  "text": "is loaded.\n"
                },
                {
                  "kind": "span",
                  "text": "From_Tree is the part of the desktop that describes the editor area.\n"
                },
                {
                  "kind": "span",
                  "text": "User is passed as a parameter to all of the Load_Desktop_Function\n"
                },
                {
                  "kind": "span",
                  "text": "registered by the widgets.\n"
                },
                {
                  "kind": "span",
                  "text": "Return False if the desktop couldn't be loaded\n"
                },
                {
                  "kind": "span",
                  "text": "It also restores the size and position of the toplevel window that\n"
                },
                {
                  "kind": "span",
                  "text": "contains the MDI\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 886,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Perspectives",
              "line": 887,
              "column": 10,
              "type": {
                "label": "Glib.XML.Node_Ptr",
                "docHref": "docs/glib__xml___spec.html#L47C9"
              },
              "description": [
              ]
            },
            {
              "label": "From_Tree",
              "line": 888,
              "column": 10,
              "type": {
                "label": "Glib.XML.Node_Ptr",
                "docHref": "docs/glib__xml___spec.html#L47C9"
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 889,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Save_Desktop",
          "qualifier": "",
          "line": 931,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 931,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Save_Desktop",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L931C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 932,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L932C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 933,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L933C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 934,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Perspectives",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L934C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 935,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Central",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L935C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Xml_Int.Node_Ptr",
                      "href": "docs/glib__xml___spec.html#L47C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return XML representations of the perspectives and central area. Both\n"
                },
                {
                  "kind": "span",
                  "text": "nodes need to be freed by the caller, and can be saved in a file (to\n"
                },
                {
                  "kind": "span",
                  "text": "be passed to Restore_Desktop later on).\n"
                },
                {
                  "kind": "span",
                  "text": "This function calls each of the registered function for the children\n"
                },
                {
                  "kind": "span",
                  "text": "of the MDI.\n"
                },
                {
                  "kind": "span",
                  "text": "It also saves the size and position of the toplevel window that\n"
                },
                {
                  "kind": "span",
                  "text": "contains the MDI\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 932,
              "column": 10,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 933,
              "column": 10,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            },
            {
              "label": "Perspectives",
              "line": 934,
              "column": 10,
              "type": {
                "label": "Glib.XML.Node_Ptr",
                "docHref": "docs/glib__xml___spec.html#L47C9"
              },
              "description": [
              ]
            },
            {
              "label": "Central",
              "line": 935,
              "column": 10,
              "type": {
                "label": "Glib.XML.Node_Ptr",
                "docHref": "docs/glib__xml___spec.html#L47C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Menu_Model",
          "qualifier": "",
          "line": 824,
          "column": 17,
          "src": "srcs/gtkada-mdi.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 824,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Menu_Model",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L824C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 825,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L825C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "MDI_Window_Record",
                      "href": "docs/gtkada__mdi___spec.html#L1401C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 826,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "App",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L826C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Application.Gtk_Application_Record",
                      "href": "docs/gtk__application___spec.html#L108C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 827,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L827C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu.Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 828,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User",
                      "href": "docs/gtkada__mdi___desktop___spec.html#L828C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Associates a menu model with the MDI.\n"
                },
                {
                  "kind": "span",
                  "text": "This model will be filled and maintained by the MDI, to provide\n"
                },
                {
                  "kind": "span",
                  "text": "useful actions like floating/docking items, selecting items,...\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "MDI",
              "line": 825,
              "column": 11,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "App",
              "line": 826,
              "column": 11,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Model",
              "line": 827,
              "column": 11,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User",
              "line": 828,
              "column": 11,
              "type": {
                "label": "Gtkada.MDI.Desktop.User_Data",
                "docHref": "docs/gtkada__mdi___desktop___spec.html#L809C12"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};