GNATdoc.Documentation = {
  "label": "Gtk.Tree_Model_Filter.Set_Visible_Func_User_Data",
  "qualifier": "(nested)",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gtk_Tree_Model_Filter_Visible_Func",
          "qualifier": "",
          "line": 359,
          "column": 12,
          "src": "srcs/gtk-tree_model_filter.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 359,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                                        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 360,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L360C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Tree_Model.Gtk_Tree_Model",
                      "href": "docs/gtk__tree_model___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 361,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Iter",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L361C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Tree_Model.Gtk_Tree_Iter",
                      "href": "docs/gtk__tree_model___spec.html#L1288C6"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 362,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L362C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A function which decides whether the row indicated by Iter is visible.\n"
                },
                {
                  "kind": "span",
                  "text": "\"model\": the child model of the\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model_Filter.Gtk_Tree_Model_Filter\n"
                },
                {
                  "kind": "span",
                  "text": "\"iter\": a Gtk.Tree_Model.Gtk_Tree_Iter pointing to the row in Model\n"
                },
                {
                  "kind": "span",
                  "text": "whose visibility is determined\n"
                },
                {
                  "kind": "span",
                  "text": "\"data\": user data given to Gtk.Tree_Model_Filter.Set_Visible_Func\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Set_Visible_Func",
          "qualifier": "",
          "line": 370,
          "column": 17,
          "src": "srcs/gtk-tree_model_filter.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 370,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Visible_Func",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L370C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 371,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L371C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Tree_Model_Filter.Gtk_Tree_Model_Filter_Record",
                      "href": "docs/gtk__tree_model_filter___spec.html#L107C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 372,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Func",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L372C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Tree_Model_Filter_Visible_Func",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L359C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 373,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data",
                      "href": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L373C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the visible function used when filtering the Filter to be Func.\n"
                },
                {
                  "kind": "span",
                  "text": "The function should return True if the given row should be visible\n"
                },
                {
                  "kind": "span",
                  "text": "and False otherwise.\n"
                },
                {
                  "kind": "span",
                  "text": "If the condition calculated by the function changes over time (e.g.\n"
                },
                {
                  "kind": "span",
                  "text": "because it depends on some global parameters), you must call\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model_Filter.Refilter to keep the visibility information of\n"
                },
                {
                  "kind": "span",
                  "text": "the model up-to-date.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that Func is called whenever a row is inserted, when it may\n"
                },
                {
                  "kind": "span",
                  "text": "still be empty. The visible function should therefore take special\n"
                },
                {
                  "kind": "span",
                  "text": "care of empty rows, like in the example below.\n"
                },
                {
                  "kind": "span",
                  "text": "|[\n"
                },
                {
                  "kind": "span",
                  "text": "<!-- language=\"C\" --> static gboolean visible_func (GtkTreeModel\n"
                },
                {
                  "kind": "ul",
                  "children": [
                    {
                      "kind": "li",
                      "children": [
                        {
                          "kind": "span",
                          "text": "model, GtkTreeIter *iter, gpointer data) { // Visible if row is\n"
                        }
                      ]
                    }
                  ]
                },
                {
                  "kind": "span",
                  "text": "non-empty and first column is \"HI\" gchar *str; gboolean visible =\n"
                },
                {
                  "kind": "span",
                  "text": "FALSE;\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_tree_model_get (model, iter, 0, &str, -1); if (str && strcmp\n"
                },
                {
                  "kind": "span",
                  "text": "(str, \"HI\") == 0) visible = TRUE; g_free (str);\n"
                },
                {
                  "kind": "span",
                  "text": "return visible; } ]|\n"
                },
                {
                  "kind": "span",
                  "text": "Note that Gtk.Tree_Model_Filter.Set_Visible_Func or\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model_Filter.Set_Visible_Column can only be called once for\n"
                },
                {
                  "kind": "span",
                  "text": "a given filter model.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.4\n"
                },
                {
                  "kind": "span",
                  "text": "\"func\": A Gtk_Tree_Model_Filter_Visible_Func, the visible function\n"
                },
                {
                  "kind": "span",
                  "text": "\"data\": User data to pass to the visible function, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 371,
              "column": 11,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Func",
              "line": 372,
              "column": 11,
              "type": {
                "label": "Gtk.Tree_Model_Filter.Set_Visible_Func_User_Data.Gtk_Tree_Model_Filter_Visible_Func",
                "docHref": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L359C12"
              },
              "description": [
              ]
            },
            {
              "label": "Data",
              "line": 373,
              "column": 11,
              "type": {
                "label": "Gtk.Tree_Model_Filter.Set_Visible_Func_User_Data.User_Data_Type",
                "docHref": "docs/gtk__tree_model_filter___set_visible_func_user_data___spec.html#L355C12"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};