GNATdoc.Documentation = {
  "label": "Gtk.Main",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gtk_Key_Snoop_Func",
          "qualifier": "",
          "line": 39,
          "column": 9,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 39,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 40,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Grab_Widget",
                      "href": "docs/gtk__main___spec.html#L40C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 41,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Event",
                      "href": "docs/gtk__main___spec.html#L41C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Event.Gdk_Event_Key",
                      "href": "docs/gdk__event___spec.html#L428C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Key snooper functions are called before normal event delivery. They can\n"
                },
                {
                  "kind": "span",
                  "text": "be used to implement custom key event handling.\n"
                },
                {
                  "kind": "span",
                  "text": "\"grab_widget\": the widget to which the event will be delivered\n"
                },
                {
                  "kind": "span",
                  "text": "\"event\": the key event\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Check_Version",
          "qualifier": "",
          "line": 115,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 115,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Check_Version",
                      "href": "docs/gtk__main___spec.html#L115C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 116,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Required_Major",
                      "href": "docs/gtk__main___spec.html#L116C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 117,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Required_Minor",
                      "href": "docs/gtk__main___spec.html#L117C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 118,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Required_Micro",
                      "href": "docs/gtk__main___spec.html#L118C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks that the GTK+ library in use is compatible with the given\n"
                },
                {
                  "kind": "span",
                  "text": "version. Generally you would pass in the constants GTK_MAJOR_VERSION,\n"
                },
                {
                  "kind": "span",
                  "text": "GTK_MINOR_VERSION, GTK_MICRO_VERSION as the three arguments to this\n"
                },
                {
                  "kind": "span",
                  "text": "function; that produces a check that the library in use is compatible\n"
                },
                {
                  "kind": "span",
                  "text": "with the version of GTK+ the application or module was compiled against.\n"
                },
                {
                  "kind": "span",
                  "text": "Compatibility is defined by two things: first the version of the\n"
                },
                {
                  "kind": "span",
                  "text": "running library is newer than the version\n"
                },
                {
                  "kind": "span",
                  "text": "Required_Major.required_minor.Required_Micro. Second the running library\n"
                },
                {
                  "kind": "span",
                  "text": "must be binary compatible with the version\n"
                },
                {
                  "kind": "span",
                  "text": "Required_Major.required_minor.Required_Micro (same major version.)\n"
                },
                {
                  "kind": "span",
                  "text": "This function is primarily for GTK+ modules; the module can call this\n"
                },
                {
                  "kind": "span",
                  "text": "function to check that it wasn't loaded into an incompatible version of\n"
                },
                {
                  "kind": "span",
                  "text": "GTK+. However, such a check isn't completely reliable, since the module\n"
                },
                {
                  "kind": "span",
                  "text": "may be linked against an old version of GTK+ and calling the old version\n"
                },
                {
                  "kind": "span",
                  "text": "of Gtk.Main.Check_Version, but still get loaded into an application\n"
                },
                {
                  "kind": "span",
                  "text": "using a newer version of GTK+.\n"
                },
                {
                  "kind": "span",
                  "text": "\"required_major\": the required major version\n"
                },
                {
                  "kind": "span",
                  "text": "\"required_minor\": the required minor version\n"
                },
                {
                  "kind": "span",
                  "text": "\"required_micro\": the required micro version\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Required_Major",
              "line": 116,
              "column": 8,
              "type": {
                "label": "Glib.Guint",
                "docHref": "docs/glib___spec.html#L55C9"
              },
              "description": [
              ]
            },
            {
              "label": "Required_Minor",
              "line": 117,
              "column": 8,
              "type": {
                "label": "Glib.Guint",
                "docHref": "docs/glib___spec.html#L55C9"
              },
              "description": [
              ]
            },
            {
              "label": "Required_Micro",
              "line": 118,
              "column": 8,
              "type": {
                "label": "Glib.Guint",
                "docHref": "docs/glib___spec.html#L55C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Device_Grab_Add",
          "qualifier": "",
          "line": 248,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 248,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device_Grab_Add",
                      "href": "docs/gtk__main___spec.html#L248C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 249,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtk__main___spec.html#L249C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 250,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device",
                      "href": "docs/gtk__main___spec.html#L250C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Device.Gdk_Device_Record",
                      "href": "docs/gdk__device___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 251,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Block_Others",
                      "href": "docs/gtk__main___spec.html#L251C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a GTK+ grab on Device, so all the events on Device and its\n"
                },
                {
                  "kind": "span",
                  "text": "associated pointer or keyboard (if any) are delivered to Widget. If the\n"
                },
                {
                  "kind": "span",
                  "text": "Block_Others parameter is True, any other devices will be unable to\n"
                },
                {
                  "kind": "span",
                  "text": "interact with Widget during the grab.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                },
                {
                  "kind": "span",
                  "text": "\"widget\": a Gtk.Widget.Gtk_Widget\n"
                },
                {
                  "kind": "span",
                  "text": "\"device\": a Gdk.Device.Gdk_Device to grab on.\n"
                },
                {
                  "kind": "span",
                  "text": "\"block_others\": True to prevent other devices to interact with Widget.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Widget",
              "line": 249,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Device",
              "line": 250,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Block_Others",
              "line": 251,
              "column": 8,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Device_Grab_Remove",
          "qualifier": "",
          "line": 261,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 261,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device_Grab_Remove",
                      "href": "docs/gtk__main___spec.html#L261C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 262,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtk__main___spec.html#L262C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 263,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device",
                      "href": "docs/gtk__main___spec.html#L263C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Device.Gdk_Device_Record",
                      "href": "docs/gdk__device___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Removes a device grab from the given widget.\n"
                },
                {
                  "kind": "span",
                  "text": "You have to pair calls to Gtk.Main.Device_Grab_Add and\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Main.Device_Grab_Remove.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                },
                {
                  "kind": "span",
                  "text": "\"widget\": a Gtk.Widget.Gtk_Widget\n"
                },
                {
                  "kind": "span",
                  "text": "\"device\": a Gdk.Device.Gdk_Device\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Widget",
              "line": 262,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Device",
              "line": 263,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Disable_Setlocale",
          "qualifier": "",
          "line": 139,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 139,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Disable_Setlocale",
                      "href": "docs/gtk__main___spec.html#L139C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Prevents gtk_init, gtk_init_check, gtk_init_with_args and\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_parse_args from automatically calling `setlocale (LC_ALL, \"\")`. You\n"
                },
                {
                  "kind": "span",
                  "text": "would want to use this function if you wanted to set the locale for your\n"
                },
                {
                  "kind": "span",
                  "text": "program to something other than the user's locale, or if you wanted to\n"
                },
                {
                  "kind": "span",
                  "text": "set different values for different locale categories.\n"
                },
                {
                  "kind": "span",
                  "text": "Most programs should not need to call this function.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Events_Pending",
          "qualifier": "",
          "line": 156,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 156,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Events_Pending",
                      "href": "docs/gtk__main___spec.html#L156C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks if any events are pending.\n"
                },
                {
                  "kind": "span",
                  "text": "This can be used to update the UI and invoke timeouts etc. while doing\n"
                },
                {
                  "kind": "span",
                  "text": "some time intensive computation.\n"
                },
                {
                  "kind": "span",
                  "text": "## Updating the UI during a long computation\n"
                },
                {
                  "kind": "span",
                  "text": "|[\n"
                },
                {
                  "kind": "span",
                  "text": "<!-- language=\"C\" --> // computation going on...\n"
                },
                {
                  "kind": "span",
                  "text": "while (gtk_events_pending ()) gtk_main_iteration ();\n"
                },
                {
                  "kind": "span",
                  "text": "// ...computation continued ]|\n"
                }
              ]
            }
          ]
        },
        {
          "label": "False",
          "qualifier": "",
          "line": 241,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 241,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False",
                      "href": "docs/gtk__main___spec.html#L241C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Analogical to Gtk.Main.True, this function does nothing but always\n"
                },
                {
                  "kind": "span",
                  "text": "returns False.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Binary_Age",
          "qualifier": "",
          "line": 103,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Binary_Age",
                      "href": "docs/gtk__main___spec.html#L103C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the binary age as passed to `libtool` when building the GTK+\n"
                },
                {
                  "kind": "span",
                  "text": "library the process is running against. If `libtool` means nothing to\n"
                },
                {
                  "kind": "span",
                  "text": "you, don't worry about it.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Current_Event",
          "qualifier": "",
          "line": 277,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 277,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current_Event",
                      "href": "docs/gtk__main___spec.html#L277C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Event.Gdk_Event",
                      "href": "docs/gdk__event___spec.html#L761C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Obtains a copy of the event currently being processed by GTK+.\n"
                },
                {
                  "kind": "span",
                  "text": "For example, if you are handling a Gtk.Button.Gtk_Button::clicked\n"
                },
                {
                  "kind": "span",
                  "text": "signal, the current event will be the Gdk.Event.Gdk_Event_Button that\n"
                },
                {
                  "kind": "span",
                  "text": "triggered the ::clicked signal.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Current_Event_Device",
          "qualifier": "",
          "line": 294,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 294,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current_Event_Device",
                      "href": "docs/gtk__main___spec.html#L294C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Device.Gdk_Device",
                      "href": "docs/gdk__device___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is a current event and it has a device, return that device,\n"
                },
                {
                  "kind": "span",
                  "text": "otherwise return null.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Current_Event_State",
          "qualifier": "",
          "line": 287,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 287,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current_Event_State",
                      "href": "docs/gtk__main___spec.html#L287C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 288,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "State",
                      "href": "docs/gtk__main___spec.html#L288C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "             "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Types.Gdk_Modifier_Type",
                      "href": "docs/gdk__types___spec.html#L167C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 289,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Has_Current_Event",
                      "href": "docs/gtk__main___spec.html#L289C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is a current event and it has a state field, place that state\n"
                },
                {
                  "kind": "span",
                  "text": "field in State and return True, otherwise return False.\n"
                },
                {
                  "kind": "span",
                  "text": "\"state\": a location to store the state of the current event\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "State",
              "line": 288,
              "column": 8,
              "type": {
                "label": "Gdk.Types.Gdk_Modifier_Type",
                "docHref": "docs/gdk__types___spec.html#L167C9"
              },
              "description": [
              ]
            },
            {
              "label": "Has_Current_Event",
              "line": 289,
              "column": 8,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Current_Event_Time",
          "qualifier": "",
          "line": 283,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 283,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current_Event_Time",
                      "href": "docs/gtk__main___spec.html#L283C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint32",
                      "href": "docs/glib___spec.html#L68C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is a current event and it has a timestamp, return that\n"
                },
                {
                  "kind": "span",
                  "text": "timestamp, otherwise return GDK_CURRENT_TIME.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Default_Language",
          "qualifier": "",
          "line": 147,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 147,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Default_Language",
                      "href": "docs/gtk__main___spec.html#L147C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pango.Language.Pango_Language",
                      "href": "docs/pango__language___spec.html#L39C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the Pango.Language.Pango_Language for the default language\n"
                },
                {
                  "kind": "span",
                  "text": "currently in effect. (Note that this can change over the life of an\n"
                },
                {
                  "kind": "span",
                  "text": "application.) The default language is derived from the current locale.\n"
                },
                {
                  "kind": "span",
                  "text": "It determines, for example, whether GTK+ uses the right-to-left or\n"
                },
                {
                  "kind": "span",
                  "text": "left-to-right text direction.\n"
                },
                {
                  "kind": "span",
                  "text": "This function is equivalent to Pango.Language.Get_Default. See that\n"
                },
                {
                  "kind": "span",
                  "text": "function for details.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Event_Widget",
          "qualifier": "",
          "line": 298,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 298,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Event_Widget",
                      "href": "docs/gtk__main___spec.html#L298C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 299,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Event",
                      "href": "docs/gtk__main___spec.html#L299C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Event.Gdk_Event",
                      "href": "docs/gdk__event___spec.html#L761C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget",
                      "href": "docs/gtk__widget___spec.html#L344C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If Event is null or the event was not associated with any widget,\n"
                },
                {
                  "kind": "span",
                  "text": "returns null, otherwise returns the widget that received the event\n"
                },
                {
                  "kind": "span",
                  "text": "originally.\n"
                },
                {
                  "kind": "span",
                  "text": "\"event\": a Gdk.Event.Gdk_Event\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Event",
              "line": 299,
              "column": 8,
              "type": {
                "label": "Gdk.Event.Gdk_Event",
                "docHref": "docs/gdk__event___spec.html#L761C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Interface_Age",
          "qualifier": "",
          "line": 109,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 109,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Interface_Age",
                      "href": "docs/gtk__main___spec.html#L109C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the interface age as passed to `libtool` when building the GTK+\n"
                },
                {
                  "kind": "span",
                  "text": "library the process is running against. If `libtool` means nothing to\n"
                },
                {
                  "kind": "span",
                  "text": "you, don't worry about it.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Major_Version",
          "qualifier": "",
          "line": 76,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 76,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Major_Version",
                      "href": "docs/gtk__main___spec.html#L76C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the major version number of the GTK+ library. (e.g. in GTK+\n"
                },
                {
                  "kind": "span",
                  "text": "version 3.1.5 this is 3.)\n"
                },
                {
                  "kind": "span",
                  "text": "This function is in the library, so it represents the GTK+ library your\n"
                },
                {
                  "kind": "span",
                  "text": "code is running against. Contrast with the GTK_MAJOR_VERSION macro,\n"
                },
                {
                  "kind": "span",
                  "text": "which represents the major version of the GTK+ headers you have included\n"
                },
                {
                  "kind": "span",
                  "text": "when compiling your code.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Micro_Version",
          "qualifier": "",
          "line": 94,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 94,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Micro_Version",
                      "href": "docs/gtk__main___spec.html#L94C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the micro version number of the GTK+ library. (e.g. in GTK+\n"
                },
                {
                  "kind": "span",
                  "text": "version 3.1.5 this is 5.)\n"
                },
                {
                  "kind": "span",
                  "text": "This function is in the library, so it represents the GTK+ library your\n"
                },
                {
                  "kind": "span",
                  "text": "code is are running against. Contrast with the GTK_MICRO_VERSION macro,\n"
                },
                {
                  "kind": "span",
                  "text": "which represents the micro version of the GTK+ headers you have included\n"
                },
                {
                  "kind": "span",
                  "text": "when compiling your code.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Minor_Version",
          "qualifier": "",
          "line": 85,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 85,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Minor_Version",
                      "href": "docs/gtk__main___spec.html#L85C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the minor version number of the GTK+ library. (e.g. in GTK+\n"
                },
                {
                  "kind": "span",
                  "text": "version 3.1.5 this is 1.)\n"
                },
                {
                  "kind": "span",
                  "text": "This function is in the library, so it represents the GTK+ library your\n"
                },
                {
                  "kind": "span",
                  "text": "code is are running against. Contrast with the GTK_MINOR_VERSION macro,\n"
                },
                {
                  "kind": "span",
                  "text": "which represents the minor version of the GTK+ headers you have included\n"
                },
                {
                  "kind": "span",
                  "text": "when compiling your code.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.0\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Grab_Get_Current",
          "qualifier": "",
          "line": 245,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 245,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Grab_Get_Current",
                      "href": "docs/gtk__main___spec.html#L245C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget",
                      "href": "docs/gtk__widget___spec.html#L344C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Queries the current grab of the default window group.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Init",
          "qualifier": "",
          "line": 62,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 62,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init",
                      "href": "docs/gtk__main___spec.html#L62C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initialize GtkAda's internal structures.\n"
                },
                {
                  "kind": "span",
                  "text": "This subprogram should be called before any other one in GtkAda.\n"
                },
                {
                  "kind": "span",
                  "text": "If GtkAda could not be initialized (no access to the display, etc.), the\n"
                },
                {
                  "kind": "span",
                  "text": "application exits with an error\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Init_Check",
          "qualifier": "",
          "line": 68,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 68,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init_Check",
                      "href": "docs/gtk__main___spec.html#L68C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initialize GtkAda's internal structures.\n"
                },
                {
                  "kind": "span",
                  "text": "Return False if there was an error (no access to the display, etc.)\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Key_Snooper_Install",
          "qualifier": "",
          "line": 51,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 51,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key_Snooper_Install",
                      "href": "docs/gtk__main___spec.html#L51C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Snooper",
                      "href": "docs/gtk__main___spec.html#L51C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Key_Snoop_Func",
                      "href": "docs/gtk__main___spec.html#L39C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Snooper",
              "line": 51,
              "column": 34,
              "type": {
                "label": "Gtk.Main.Gtk_Key_Snoop_Func",
                "docHref": "docs/gtk__main___spec.html#L39C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Key_Snooper_Remove",
          "qualifier": "",
          "line": 271,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 271,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key_Snooper_Remove",
                      "href": "docs/gtk__main___spec.html#L271C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Snooper_Handler_Id",
                      "href": "docs/gtk__main___spec.html#L271C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Snooper_Handler_Id",
              "line": 271,
              "column": 34,
              "type": {
                "label": "Glib.Guint",
                "docHref": "docs/glib___spec.html#L55C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Main",
          "qualifier": "",
          "line": 197,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 197,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main",
                      "href": "docs/gtk__main___spec.html#L197C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Runs the main loop until Gtk.Main.Main_Quit is called.\n"
                },
                {
                  "kind": "span",
                  "text": "You can nest calls to Gtk.Main.Main. In that case Gtk.Main.Main_Quit\n"
                },
                {
                  "kind": "span",
                  "text": "will make the innermost invocation of the main loop return.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Main_Do_Event",
          "qualifier": "",
          "line": 165,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 165,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main_Do_Event",
                      "href": "docs/gtk__main___spec.html#L165C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Event",
                      "href": "docs/gtk__main___spec.html#L165C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Event.Gdk_Event",
                      "href": "docs/gdk__event___spec.html#L761C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Processes a single GDK event.\n"
                },
                {
                  "kind": "span",
                  "text": "This is public only to allow filtering of events between GDK and GTK+.\n"
                },
                {
                  "kind": "span",
                  "text": "You will not usually need to call this function directly.\n"
                },
                {
                  "kind": "span",
                  "text": "While you should not call this function directly, you might want to\n"
                },
                {
                  "kind": "span",
                  "text": "know how exactly events are handled. So here is what this function does\n"
                },
                {
                  "kind": "span",
                  "text": "with the event:\n"
                },
                {
                  "kind": "span",
                  "text": "1. Compress enter/leave notify events. If the event passed build an\n"
                },
                {
                  "kind": "span",
                  "text": "enter/leave pair together with the next event (peeked from GDK), both\n"
                },
                {
                  "kind": "span",
                  "text": "events are thrown away. This is to avoid a backlog of (de-)highlighting\n"
                },
                {
                  "kind": "span",
                  "text": "widgets crossed by the pointer.\n"
                },
                {
                  "kind": "span",
                  "text": "2. Find the widget which got the event. If the widget can't be\n"
                },
                {
                  "kind": "span",
                  "text": "determined the event is thrown away unless it belongs to a INCR\n"
                },
                {
                  "kind": "span",
                  "text": "transaction.\n"
                },
                {
                  "kind": "span",
                  "text": "3. Then the event is pushed onto a stack so you can query the currently\n"
                },
                {
                  "kind": "span",
                  "text": "handled event with Gtk.Main.Get_Current_Event.\n"
                },
                {
                  "kind": "span",
                  "text": "4. The event is sent to a widget. If a grab is active all events for\n"
                },
                {
                  "kind": "span",
                  "text": "widgets that are not in the contained in the grab widget are sent to the\n"
                },
                {
                  "kind": "span",
                  "text": "latter with a few exceptions: - Deletion and destruction events are\n"
                },
                {
                  "kind": "span",
                  "text": "still sent to the event widget for obvious reasons. - Events which\n"
                },
                {
                  "kind": "span",
                  "text": "directly relate to the visual representation of the event widget. -\n"
                },
                {
                  "kind": "span",
                  "text": "Leave events are delivered to the event widget if there was an enter\n"
                },
                {
                  "kind": "span",
                  "text": "event delivered to it before without the paired leave event. - Drag\n"
                },
                {
                  "kind": "span",
                  "text": "events are not redirected because it is unclear what the semantics of\n"
                },
                {
                  "kind": "span",
                  "text": "that would be. Another point of interest might be that all key events\n"
                },
                {
                  "kind": "span",
                  "text": "are first passed through the key snooper functions if there are any.\n"
                },
                {
                  "kind": "span",
                  "text": "Read the description of Gtk.Main.Key_Snooper_Install if you need this\n"
                },
                {
                  "kind": "span",
                  "text": "feature.\n"
                },
                {
                  "kind": "span",
                  "text": "5. After finishing the delivery the event is popped from the event\n"
                },
                {
                  "kind": "span",
                  "text": "stack.\n"
                },
                {
                  "kind": "span",
                  "text": "\"event\": An event to process (normally passed by GDK)\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Event",
              "line": 165,
              "column": 29,
              "type": {
                "label": "Gdk.Event.Gdk_Event",
                "docHref": "docs/gdk__event___spec.html#L761C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Main_Iteration",
          "qualifier": "",
          "line": 209,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 209,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main_Iteration",
                      "href": "docs/gtk__main___spec.html#L209C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Runs a single iteration of the mainloop.\n"
                },
                {
                  "kind": "span",
                  "text": "If no events are waiting to be processed GTK+ will block until the next\n"
                },
                {
                  "kind": "span",
                  "text": "event is noticed. If you don't want to block look at\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Main.Main_Iteration_Do or check if any events are pending with\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Main.Events_Pending first.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Main_Iteration_Do",
          "qualifier": "",
          "line": 216,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 216,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main_Iteration_Do",
                      "href": "docs/gtk__main___spec.html#L216C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blocking",
                      "href": "docs/gtk__main___spec.html#L216C32"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Runs a single iteration of the mainloop. If no events are available\n"
                },
                {
                  "kind": "span",
                  "text": "either return or block depending on the value of Blocking.\n"
                },
                {
                  "kind": "span",
                  "text": "\"blocking\": True if you want GTK+ to block if no events are pending\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Blocking",
              "line": 216,
              "column": 32,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Main_Level",
          "qualifier": "",
          "line": 202,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 202,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main_Level",
                      "href": "docs/gtk__main___spec.html#L202C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Asks for the current nesting level of the main loop.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Main_Quit",
          "qualifier": "",
          "line": 205,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 205,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Main_Quit",
                      "href": "docs/gtk__main___spec.html#L205C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Makes the innermost invocation of the main loop return when it regains\n"
                },
                {
                  "kind": "span",
                  "text": "control.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Propagate_Event",
          "qualifier": "",
          "line": 305,
          "column": 14,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 305,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Propagate_Event",
                      "href": "docs/gtk__main___spec.html#L305C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 306,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Widget",
                      "href": "docs/gtk__main___spec.html#L306C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk.Widget.Gtk_Widget_Record",
                      "href": "docs/gtk__widget___spec.html#L343C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 307,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Event",
                      "href": "docs/gtk__main___spec.html#L307C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Event.Gdk_Event",
                      "href": "docs/gdk__event___spec.html#L761C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sends an event to a widget, propagating the event to parent widgets if\n"
                },
                {
                  "kind": "span",
                  "text": "the event remains unhandled.\n"
                },
                {
                  "kind": "span",
                  "text": "Events received by GTK+ from GDK normally begin in\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Main.Main_Do_Event. Depending on the type of event, existence of\n"
                },
                {
                  "kind": "span",
                  "text": "modal dialogs, grabs, etc., the event may be propagated; if so, this\n"
                },
                {
                  "kind": "span",
                  "text": "function is used.\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Main.Propagate_Event calls Gtk.Widget.Event on each widget it\n"
                },
                {
                  "kind": "span",
                  "text": "decides to send the event to. So Gtk.Widget.Event is the lowest-level\n"
                },
                {
                  "kind": "span",
                  "text": "function; it simply emits the Gtk.Widget.Gtk_Widget::event and possibly\n"
                },
                {
                  "kind": "span",
                  "text": "an event-specific signal on a widget. Gtk.Main.Propagate_Event is a bit\n"
                },
                {
                  "kind": "span",
                  "text": "higher-level, and Gtk.Main.Main_Do_Event is the highest level.\n"
                },
                {
                  "kind": "span",
                  "text": "All that said, you most likely don't want to use any of these\n"
                },
                {
                  "kind": "span",
                  "text": "functions; synthesizing events is rarely needed. There are almost\n"
                },
                {
                  "kind": "span",
                  "text": "certainly better ways to achieve your goals. For example, use\n"
                },
                {
                  "kind": "span",
                  "text": "Gdk.Window.Invalidate_Rect or Gtk.Widget.Queue_Draw instead of making up\n"
                },
                {
                  "kind": "span",
                  "text": "expose events.\n"
                },
                {
                  "kind": "span",
                  "text": "\"widget\": a Gtk.Widget.Gtk_Widget\n"
                },
                {
                  "kind": "span",
                  "text": "\"event\": an event\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Widget",
              "line": 306,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Event",
              "line": 307,
              "column": 8,
              "type": {
                "label": "Gdk.Event.Gdk_Event",
                "docHref": "docs/gdk__event___spec.html#L761C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "True",
          "qualifier": "",
          "line": 221,
          "column": 13,
          "src": "srcs/gtk-main.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 221,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "True",
                      "href": "docs/gtk__main___spec.html#L221C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "All this function does it to return True.\n"
                },
                {
                  "kind": "span",
                  "text": "This can be useful for example if you want to inhibit the deletion of a\n"
                },
                {
                  "kind": "span",
                  "text": "window. Of course you should not do this as the user expects a reaction\n"
                },
                {
                  "kind": "span",
                  "text": "from clicking the close icon of the window...\n"
                },
                {
                  "kind": "span",
                  "text": "## A persistent window\n"
                },
                {
                  "kind": "span",
                  "text": "|[\n"
                },
                {
                  "kind": "span",
                  "text": "<!-- language=\"C\" --> include\n"
                },
                {
                  "kind": "span",
                  "text": "<gtk/gtk.h>\n"
                },
                {
                  "kind": "span",
                  "text": "int main (int argc, char **argv) { GtkWidget *win, *but; const char\n"
                },
                {
                  "kind": "ul",
                  "children": [
                    {
                      "kind": "li",
                      "children": [
                        {
                          "kind": "span",
                          "text": "text = \"Close yourself. I mean it!\";\n"
                        }
                      ]
                    }
                  ]
                },
                {
                  "kind": "span",
                  "text": "gtk_init (&argc, &argv);\n"
                },
                {
                  "kind": "span",
                  "text": "win = gtk_window_new (GTK_WINDOW_TOPLEVEL); g_signal_connect (win,\n"
                },
                {
                  "kind": "span",
                  "text": "\"delete-event\", G_CALLBACK (gtk_true), NULL); g_signal_connect (win,\n"
                },
                {
                  "kind": "span",
                  "text": "\"destroy\", G_CALLBACK (gtk_main_quit), NULL);\n"
                },
                {
                  "kind": "span",
                  "text": "but = gtk_button_new_with_label (text); g_signal_connect_swapped (but,\n"
                },
                {
                  "kind": "span",
                  "text": "\"clicked\", G_CALLBACK (gtk_object_destroy), win); gtk_container_add\n"
                },
                {
                  "kind": "span",
                  "text": "(GTK_CONTAINER (win), but);\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_widget_show_all (win);\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_main ();\n"
                },
                {
                  "kind": "span",
                  "text": "return 0; } ]|\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};