GNATdoc.Documentation = {
  "label": "Gtk.Builder",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Translation_Domain_Property",
          "qualifier": "",
          "line": 584,
          "column": 4,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 584,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Translation_Domain_Property"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Properties.Property_String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The translation domain used when translating property values that have\n"
                },
                {
                  "kind": "span",
                  "text": "been marked as translatable in interface descriptions. If the\n"
                },
                {
                  "kind": "span",
                  "text": "translation domain is null, Gtk.Builder.Gtk_Builder uses gettext,\n"
                },
                {
                  "kind": "span",
                  "text": "otherwise g_dgettext.\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Constants and variables"
    },
    {
      "entities": [
        {
          "label": "Gtk_Builder",
          "qualifier": "",
          "line": 196,
          "column": 9,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 196,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Gtk_Builder_Connect_Func",
          "qualifier": "",
          "line": 202,
          "column": 9,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 202,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 203,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L203C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 204,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Object",
                      "href": "docs/gtk__builder___spec.html#L204C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 205,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Signal_Name",
                      "href": "docs/gtk__builder___spec.html#L205C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Signal_Name",
                      "href": "docs/glib___spec.html#L229C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 206,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Handler_Name",
                      "href": "docs/gtk__builder___spec.html#L206C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 207,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect_Object",
                      "href": "docs/gtk__builder___spec.html#L207C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 208,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Flags",
                      "href": "docs/gtk__builder___spec.html#L208C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.G_Connect_Flags",
                      "href": "docs/glib___spec.html#L236C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This is the signature of a function used to connect signals. It is used\n"
                },
                {
                  "kind": "span",
                  "text": "by the Gtk.Builder.Connect_Signals and Gtk.Builder.Connect_Signals_Full\n"
                },
                {
                  "kind": "span",
                  "text": "methods. It is mainly intended for interpreted language bindings, but\n"
                },
                {
                  "kind": "span",
                  "text": "could be useful where the programmer wants more control over the signal\n"
                },
                {
                  "kind": "span",
                  "text": "connection process. Note that this function can only be called once,\n"
                },
                {
                  "kind": "span",
                  "text": "subsequent calls will do nothing.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"builder\": a Gtk.Builder.Gtk_Builder\n"
                },
                {
                  "kind": "span",
                  "text": "\"object\": object to connect a signal to\n"
                },
                {
                  "kind": "span",
                  "text": "\"signal_name\": name of the signal\n"
                },
                {
                  "kind": "span",
                  "text": "\"handler_name\": name of the handler\n"
                },
                {
                  "kind": "span",
                  "text": "\"connect_object\": a Glib.Object.GObject, if non-null, use\n"
                },
                {
                  "kind": "span",
                  "text": "g_signal_connect_object\n"
                },
                {
                  "kind": "span",
                  "text": "\"flags\": Glib.G_Connect_Flags to use\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Gtk_Builder_Record",
          "qualifier": "",
          "line": 195,
          "column": 9,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 195,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "GObject_Record",
              "docHref": "docs/glib__object___spec.html#L40C9"
            }
          ],
          "inherited": [
            {
              "label": "Gtkada_Builder_Record",
              "docHref": "docs/gtkada__builder___spec.html#L82C9"
            }
          ]
        }
      ],
      "label": "Tagged types"
    },
    {
      "entities": [
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 332,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 332,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/gtk__builder___spec.html#L332C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Gtk_Builder_New",
          "qualifier": "",
          "line": 241,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 241,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_New",
                      "href": "docs/gtk__builder___spec.html#L241C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new empty builder object.\n"
                },
                {
                  "kind": "span",
                  "text": "This function is only useful if you intend to make multiple calls to\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Add_From_File, Gtk.Builder.Add_From_Resource or\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Add_From_String in order to merge multiple UI descriptions\n"
                },
                {
                  "kind": "span",
                  "text": "into a single builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Most users will probably want to use Gtk.Builder.Gtk_New_From_File,\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Gtk_New_From_Resource or Gtk.Builder.Gtk_New_From_String.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Gtk_Builder_New_From_File",
          "qualifier": "",
          "line": 266,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 266,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_New_From_File",
                      "href": "docs/gtk__builder___spec.html#L266C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 267,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/gtk__builder___spec.html#L267C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the [GtkBuilder UI definition][BUILDER-UI] in the file Filename.\n"
                },
                {
                  "kind": "span",
                  "text": "If there is an error opening the file or parsing the description then\n"
                },
                {
                  "kind": "span",
                  "text": "the program will be aborted. You should only ever attempt to parse user\n"
                },
                {
                  "kind": "span",
                  "text": "interface descriptions that are shipped as part of your program.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "\"filename\": filename of user interface description file\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Filename",
              "line": 267,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_Builder_New_From_Resource",
          "qualifier": "",
          "line": 289,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 289,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_New_From_Resource",
                      "href": "docs/gtk__builder___spec.html#L289C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 290,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Resource_Path",
                      "href": "docs/gtk__builder___spec.html#L290C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the [GtkBuilder UI definition][BUILDER-UI] at Resource_Path.\n"
                },
                {
                  "kind": "span",
                  "text": "If there is an error locating the resurce or parsing the description\n"
                },
                {
                  "kind": "span",
                  "text": "then the program will be aborted.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "\"resource_path\": a Gresource.Gresource resource path\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Resource_Path",
              "line": 290,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_Builder_New_From_String",
          "qualifier": "",
          "line": 318,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 318,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_New_From_String",
                      "href": "docs/gtk__builder___spec.html#L318C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 319,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String",
                      "href": "docs/gtk__builder___spec.html#L319C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 320,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Length",
                      "href": "docs/gtk__builder___spec.html#L320C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gssize",
                      "href": "docs/glib___spec.html#L72C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the user interface described by String (in the [GtkBuilder UI\n"
                },
                {
                  "kind": "span",
                  "text": "definition][BUILDER-UI] format).\n"
                },
                {
                  "kind": "span",
                  "text": "If String is null-terminated then Length should be -1. If Length is not\n"
                },
                {
                  "kind": "ul",
                  "children": [
                    {
                      "kind": "li",
                      "children": [
                        {
                          "kind": "span",
                          "text": "1 then it is the length of String.\n"
                        }
                      ]
                    }
                  ]
                },
                {
                  "kind": "span",
                  "text": "If there is an error parsing String then the program will be aborted.\n"
                },
                {
                  "kind": "span",
                  "text": "You should not attempt to parse user interface description from\n"
                },
                {
                  "kind": "span",
                  "text": "untrusted sources.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "\"string\": a user interface (XML) description\n"
                },
                {
                  "kind": "span",
                  "text": "\"length\": the length of String, or -1\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "String",
              "line": 319,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Length",
              "line": 320,
              "column": 8,
              "type": {
                "label": "Glib.Gssize",
                "docHref": "docs/glib___spec.html#L72C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New",
          "qualifier": "",
          "line": 228,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 228,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New",
                      "href": "docs/gtk__builder___spec.html#L228C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L228C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 228,
              "column": 23,
              "type": {
                "label": "Gtk.Builder.Gtk_Builder",
                "docHref": "docs/gtk__builder___spec.html#L196C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New_From_File",
          "qualifier": "",
          "line": 251,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 251,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New_From_File",
                      "href": "docs/gtk__builder___spec.html#L251C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 252,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L252C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 253,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/gtk__builder___spec.html#L253C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 252,
              "column": 8,
              "type": {
                "label": "Gtk.Builder.Gtk_Builder",
                "docHref": "docs/gtk__builder___spec.html#L196C9"
              },
              "description": [
              ]
            },
            {
              "label": "Filename",
              "line": 253,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New_From_Resource",
          "qualifier": "",
          "line": 275,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 275,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New_From_Resource",
                      "href": "docs/gtk__builder___spec.html#L275C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 276,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L276C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 277,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Resource_Path",
                      "href": "docs/gtk__builder___spec.html#L277C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 276,
              "column": 8,
              "type": {
                "label": "Gtk.Builder.Gtk_Builder",
                "docHref": "docs/gtk__builder___spec.html#L196C9"
              },
              "description": [
              ]
            },
            {
              "label": "Resource_Path",
              "line": 277,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gtk_New_From_String",
          "qualifier": "",
          "line": 297,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 297,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_New_From_String",
                      "href": "docs/gtk__builder___spec.html#L297C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 298,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L298C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder",
                      "href": "docs/gtk__builder___spec.html#L196C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 299,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String",
                      "href": "docs/gtk__builder___spec.html#L299C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 300,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Length",
                      "href": "docs/gtk__builder___spec.html#L300C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gssize",
                      "href": "docs/glib___spec.html#L72C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 298,
              "column": 8,
              "type": {
                "label": "Gtk.Builder.Gtk_Builder",
                "docHref": "docs/gtk__builder___spec.html#L196C9"
              },
              "description": [
              ]
            },
            {
              "label": "String",
              "line": 299,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Length",
              "line": 300,
              "column": 8,
              "type": {
                "label": "Glib.Gssize",
                "docHref": "docs/glib___spec.html#L72C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 229,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 229,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/gtk__builder___spec.html#L229C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L229C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new empty builder object.\n"
                },
                {
                  "kind": "span",
                  "text": "This function is only useful if you intend to make multiple calls to\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Add_From_File, Gtk.Builder.Add_From_Resource or\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Add_From_String in order to merge multiple UI descriptions\n"
                },
                {
                  "kind": "span",
                  "text": "into a single builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Most users will probably want to use Gtk.Builder.Gtk_New_From_File,\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Gtk_New_From_Resource or Gtk.Builder.Gtk_New_From_String.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize does nothing if the object was already created with another\n"
                },
                {
                  "kind": "span",
                  "text": "call to Initialize* or G_New.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 229,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_From_File",
          "qualifier": "",
          "line": 254,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 254,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_From_File",
                      "href": "docs/gtk__builder___spec.html#L254C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 255,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L255C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 256,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/gtk__builder___spec.html#L256C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the [GtkBuilder UI definition][BUILDER-UI] in the file Filename.\n"
                },
                {
                  "kind": "span",
                  "text": "If there is an error opening the file or parsing the description then\n"
                },
                {
                  "kind": "span",
                  "text": "the program will be aborted. You should only ever attempt to parse user\n"
                },
                {
                  "kind": "span",
                  "text": "interface descriptions that are shipped as part of your program.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_From_File does nothing if the object was already created\n"
                },
                {
                  "kind": "span",
                  "text": "with another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"filename\": filename of user interface description file\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 255,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Filename",
              "line": 256,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_From_Resource",
          "qualifier": "",
          "line": 278,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 278,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_From_Resource",
                      "href": "docs/gtk__builder___spec.html#L278C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 279,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L279C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 280,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Resource_Path",
                      "href": "docs/gtk__builder___spec.html#L280C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the [GtkBuilder UI definition][BUILDER-UI] at Resource_Path.\n"
                },
                {
                  "kind": "span",
                  "text": "If there is an error locating the resurce or parsing the description\n"
                },
                {
                  "kind": "span",
                  "text": "then the program will be aborted.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_From_Resource does nothing if the object was already created\n"
                },
                {
                  "kind": "span",
                  "text": "with another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"resource_path\": a Gresource.Gresource resource path\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 279,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Resource_Path",
              "line": 280,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_From_String",
          "qualifier": "",
          "line": 301,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 301,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_From_String",
                      "href": "docs/gtk__builder___spec.html#L301C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 302,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L302C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 303,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String",
                      "href": "docs/gtk__builder___spec.html#L303C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 304,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Length",
                      "href": "docs/gtk__builder___spec.html#L304C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gssize",
                      "href": "docs/glib___spec.html#L72C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Builds the user interface described by String (in the [GtkBuilder UI\n"
                },
                {
                  "kind": "span",
                  "text": "definition][BUILDER-UI] format).\n"
                },
                {
                  "kind": "span",
                  "text": "If String is null-terminated then Length should be -1. If Length is not\n"
                },
                {
                  "kind": "ul",
                  "children": [
                    {
                      "kind": "li",
                      "children": [
                        {
                          "kind": "span",
                          "text": "1 then it is the length of String.\n"
                        }
                      ]
                    }
                  ]
                },
                {
                  "kind": "span",
                  "text": "If there is an error parsing String then the program will be aborted.\n"
                },
                {
                  "kind": "span",
                  "text": "You should not attempt to parse user interface description from\n"
                },
                {
                  "kind": "span",
                  "text": "untrusted sources.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_From_String does nothing if the object was already created\n"
                },
                {
                  "kind": "span",
                  "text": "with another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"string\": a user interface (XML) description\n"
                },
                {
                  "kind": "span",
                  "text": "\"length\": the length of String, or -1\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 302,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "String",
              "line": 303,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Length",
              "line": 304,
              "column": 8,
              "type": {
                "label": "Glib.Gssize",
                "docHref": "docs/glib___spec.html#L72C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    },
    {
      "entities": [
        {
          "label": "Add_From_File",
          "qualifier": "",
          "line": 339,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 339,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_From_File",
                      "href": "docs/gtk__builder___spec.html#L339C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 340,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L340C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 341,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/gtk__builder___spec.html#L341C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 342,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L342C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a file containing a [GtkBuilder UI definition][BUILDER-UI] and\n"
                },
                {
                  "kind": "span",
                  "text": "merges it with the current contents of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Most users will probably want to use Gtk.Builder.Gtk_New_From_File.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR, G_MARKUP_ERROR or G_FILE_ERROR\n"
                },
                {
                  "kind": "span",
                  "text": "domain.\n"
                },
                {
                  "kind": "span",
                  "text": "It's not really reasonable to attempt to handle failures of this call.\n"
                },
                {
                  "kind": "span",
                  "text": "You should not use this function with untrusted files (ie: files that\n"
                },
                {
                  "kind": "span",
                  "text": "are not part of your application). Broken Gtk.Builder.Gtk_Builder files\n"
                },
                {
                  "kind": "span",
                  "text": "can easily crash your program, and it's possible that memory was leaked\n"
                },
                {
                  "kind": "span",
                  "text": "leading up to the reported failure. The only reasonable thing to do when\n"
                },
                {
                  "kind": "span",
                  "text": "an error is detected is to call g_error.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"filename\": the name of the file to parse\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 340,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Filename",
              "line": 341,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 342,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_From_Resource",
          "qualifier": "",
          "line": 358,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 358,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_From_Resource",
                      "href": "docs/gtk__builder___spec.html#L358C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 359,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L359C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 360,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Resource_Path",
                      "href": "docs/gtk__builder___spec.html#L360C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 361,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L361C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a resource file containing a [GtkBuilder UI\n"
                },
                {
                  "kind": "span",
                  "text": "definition][BUILDER-UI] and merges it with the current contents of\n"
                },
                {
                  "kind": "span",
                  "text": "Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Most users will probably want to use Gtk.Builder.Gtk_New_From_Resource.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR, G_MARKUP_ERROR or\n"
                },
                {
                  "kind": "span",
                  "text": "G_RESOURCE_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "It's not really reasonable to attempt to handle failures of this call.\n"
                },
                {
                  "kind": "span",
                  "text": "The only reasonable thing to do when an error is detected is to call\n"
                },
                {
                  "kind": "span",
                  "text": "g_error.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.4\n"
                },
                {
                  "kind": "span",
                  "text": "\"resource_path\": the path of the resource file to parse\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 359,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Resource_Path",
              "line": 360,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 361,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_From_String",
          "qualifier": "",
          "line": 375,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 375,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_From_String",
                      "href": "docs/gtk__builder___spec.html#L375C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 376,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L376C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 377,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Buffer",
                      "href": "docs/gtk__builder___spec.html#L377C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 378,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L378C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a string containing a [GtkBuilder UI definition][BUILDER-UI] and\n"
                },
                {
                  "kind": "span",
                  "text": "merges it with the current contents of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Most users will probably want to use Gtk.Builder.Gtk_New_From_String.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR, G_MARKUP_ERROR or\n"
                },
                {
                  "kind": "span",
                  "text": "G_VARIANT_PARSE_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "It's not really reasonable to attempt to handle failures of this call.\n"
                },
                {
                  "kind": "span",
                  "text": "The only reasonable thing to do when an error is detected is to call\n"
                },
                {
                  "kind": "span",
                  "text": "g_error.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"buffer\": the string to parse\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 376,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Buffer",
              "line": 377,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 378,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_Objects_From_File",
          "qualifier": "",
          "line": 391,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 391,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Objects_From_File",
                      "href": "docs/gtk__builder___spec.html#L391C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 392,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L392C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 393,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/gtk__builder___spec.html#L393C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 394,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Object_Ids",
                      "href": "docs/gtk__builder___spec.html#L394C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GNAT.Strings.String_List"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 395,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L395C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a file containing a [GtkBuilder UI definition][BUILDER-UI]\n"
                },
                {
                  "kind": "span",
                  "text": "building only the requested objects and merges them with the current\n"
                },
                {
                  "kind": "span",
                  "text": "contents of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR, G_MARKUP_ERROR or G_FILE_ERROR\n"
                },
                {
                  "kind": "span",
                  "text": "domain.\n"
                },
                {
                  "kind": "span",
                  "text": "If you are adding an object that depends on an object that is not its\n"
                },
                {
                  "kind": "span",
                  "text": "child (for instance a Gtk.Tree_View.Gtk_Tree_View that depends on its\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model.Gtk_Tree_Model), you have to explicitly list all of them\n"
                },
                {
                  "kind": "span",
                  "text": "in Object_Ids.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.14\n"
                },
                {
                  "kind": "span",
                  "text": "\"filename\": the name of the file to parse\n"
                },
                {
                  "kind": "span",
                  "text": "\"object_ids\": nul-terminated array of objects to build\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 392,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Filename",
              "line": 393,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Object_Ids",
              "line": 394,
              "column": 8,
              "type": {
                "label": "String_List"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 395,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_Objects_From_Resource",
          "qualifier": "",
          "line": 410,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 410,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Objects_From_Resource",
                      "href": "docs/gtk__builder___spec.html#L410C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 411,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L411C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 412,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Resource_Path",
                      "href": "docs/gtk__builder___spec.html#L412C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 413,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Object_Ids",
                      "href": "docs/gtk__builder___spec.html#L413C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GNAT.Strings.String_List"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 414,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L414C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a resource file containing a [GtkBuilder UI\n"
                },
                {
                  "kind": "span",
                  "text": "definition][BUILDER-UI] building only the requested objects and merges\n"
                },
                {
                  "kind": "span",
                  "text": "them with the current contents of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR, G_MARKUP_ERROR or\n"
                },
                {
                  "kind": "span",
                  "text": "G_RESOURCE_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "If you are adding an object that depends on an object that is not its\n"
                },
                {
                  "kind": "span",
                  "text": "child (for instance a Gtk.Tree_View.Gtk_Tree_View that depends on its\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model.Gtk_Tree_Model), you have to explicitly list all of them\n"
                },
                {
                  "kind": "span",
                  "text": "in Object_Ids.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.4\n"
                },
                {
                  "kind": "span",
                  "text": "\"resource_path\": the path of the resource file to parse\n"
                },
                {
                  "kind": "span",
                  "text": "\"object_ids\": nul-terminated array of objects to build\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 411,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Resource_Path",
              "line": 412,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Object_Ids",
              "line": 413,
              "column": 8,
              "type": {
                "label": "String_List"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 414,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_Objects_From_String",
          "qualifier": "",
          "line": 429,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 429,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Objects_From_String",
                      "href": "docs/gtk__builder___spec.html#L429C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 430,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L430C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 431,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Buffer",
                      "href": "docs/gtk__builder___spec.html#L431C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 432,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Length",
                      "href": "docs/gtk__builder___spec.html#L432C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gsize",
                      "href": "docs/glib___spec.html#L71C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 433,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Object_Ids",
                      "href": "docs/gtk__builder___spec.html#L433C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GNAT.Strings.String_List"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 434,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Error",
                      "href": "docs/gtk__builder___spec.html#L434C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Error.GError",
                      "href": "docs/glib__error___spec.html#L36C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Parses a string containing a [GtkBuilder UI definition][BUILDER-UI]\n"
                },
                {
                  "kind": "span",
                  "text": "building only the requested objects and merges them with the current\n"
                },
                {
                  "kind": "span",
                  "text": "contents of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors 0 will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR or G_MARKUP_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "If you are adding an object that depends on an object that is not its\n"
                },
                {
                  "kind": "span",
                  "text": "child (for instance a Gtk.Tree_View.Gtk_Tree_View that depends on its\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Tree_Model.Gtk_Tree_Model), you have to explicitly list all of them\n"
                },
                {
                  "kind": "span",
                  "text": "in Object_Ids.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.14\n"
                },
                {
                  "kind": "span",
                  "text": "\"buffer\": the string to parse\n"
                },
                {
                  "kind": "span",
                  "text": "\"length\": the length of Buffer (may be -1 if Buffer is nul-terminated)\n"
                },
                {
                  "kind": "span",
                  "text": "\"object_ids\": nul-terminated array of objects to build\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 430,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Buffer",
              "line": 431,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Length",
              "line": 432,
              "column": 8,
              "type": {
                "label": "Glib.Gsize",
                "docHref": "docs/glib___spec.html#L71C9"
              },
              "description": [
              ]
            },
            {
              "label": "Object_Ids",
              "line": 433,
              "column": 8,
              "type": {
                "label": "String_List"
              },
              "description": [
              ]
            },
            {
              "label": "Error",
              "line": 434,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Connect_Signals",
          "qualifier": "",
          "line": 449,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 449,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect_Signals",
                      "href": "docs/gtk__builder___spec.html#L449C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 450,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L450C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 451,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/gtk__builder___spec.html#L451C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This method is a simpler variation of Gtk.Builder.Connect_Signals_Full.\n"
                },
                {
                  "kind": "span",
                  "text": "It uses symbols explicitly added to Builder with prior calls to\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_builder_add_callback_symbol. In the case that symbols are not\n"
                },
                {
                  "kind": "span",
                  "text": "explicitly added; it uses GModule's introspective features (by opening\n"
                },
                {
                  "kind": "span",
                  "text": "the module null) to look at the application's symbol table. From here it\n"
                },
                {
                  "kind": "span",
                  "text": "tries to match the signal handler names given in the interface\n"
                },
                {
                  "kind": "span",
                  "text": "description with symbols in the application and connects the signals.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that this function can only be called once, subsequent calls will\n"
                },
                {
                  "kind": "span",
                  "text": "do nothing.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that unless gtk_builder_add_callback_symbol is called for all\n"
                },
                {
                  "kind": "span",
                  "text": "signal callbacks which are referenced by the loaded XML, this function\n"
                },
                {
                  "kind": "span",
                  "text": "will require that GModule be supported on the platform.\n"
                },
                {
                  "kind": "span",
                  "text": "If you rely on GModule support to lookup callbacks in the symbol table,\n"
                },
                {
                  "kind": "span",
                  "text": "the following details should be noted:\n"
                },
                {
                  "kind": "span",
                  "text": "When compiling applications for Windows, you must declare signal\n"
                },
                {
                  "kind": "span",
                  "text": "callbacks with G_MODULE_EXPORT, or they will not be put in the symbol\n"
                },
                {
                  "kind": "span",
                  "text": "table. On Linux and Unices, this is not necessary; applications should\n"
                },
                {
                  "kind": "span",
                  "text": "instead be compiled with the -Wl,--export-dynamic CFLAGS, and linked\n"
                },
                {
                  "kind": "span",
                  "text": "against gmodule-export-2.0.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"user_data\": user data to pass back with all signals\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 450,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User_Data",
              "line": 451,
              "column": 8,
              "type": {
                "label": "Address"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Connect_Signals_Full",
          "qualifier": "",
          "line": 474,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 474,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect_Signals_Full",
                      "href": "docs/gtk__builder___spec.html#L474C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 475,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L475C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 476,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Func",
                      "href": "docs/gtk__builder___spec.html#L476C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Connect_Func",
                      "href": "docs/gtk__builder___spec.html#L202C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function can be thought of the interpreted language binding\n"
                },
                {
                  "kind": "span",
                  "text": "version of Gtk.Builder.Connect_Signals, except that it does not require\n"
                },
                {
                  "kind": "span",
                  "text": "GModule to function correctly.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"func\": the function used to connect the signals\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 475,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Func",
              "line": 476,
              "column": 8,
              "type": {
                "label": "Gtk.Builder.Gtk_Builder_Connect_Func",
                "docHref": "docs/gtk__builder___spec.html#L202C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Expose_Object",
          "qualifier": "",
          "line": 483,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 483,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Expose_Object",
                      "href": "docs/gtk__builder___spec.html#L483C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 484,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L484C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 485,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Name",
                      "href": "docs/gtk__builder___spec.html#L485C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 486,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Object",
                      "href": "docs/gtk__builder___spec.html#L486C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Add Object to the Builder object pool so it can be referenced just like\n"
                },
                {
                  "kind": "span",
                  "text": "any other object built by builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.8\n"
                },
                {
                  "kind": "span",
                  "text": "\"name\": the name of the object exposed to the builder\n"
                },
                {
                  "kind": "span",
                  "text": "\"object\": the object to expose\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 484,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Name",
              "line": 485,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Object",
              "line": 486,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Object",
          "qualifier": "",
          "line": 493,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 493,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Object",
                      "href": "docs/gtk__builder___spec.html#L493C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 494,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L494C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 495,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Name",
                      "href": "docs/gtk__builder___spec.html#L495C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject",
                      "href": "docs/glib__object___spec.html#L41C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the object named Name. Note that this function does not increment\n"
                },
                {
                  "kind": "span",
                  "text": "the reference count of the returned object.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"name\": name of object to get\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 494,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Name",
              "line": 495,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Objects",
          "qualifier": "",
          "line": 501,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 501,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Objects",
                      "href": "docs/gtk__builder___spec.html#L501C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 502,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L502C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 503,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.Object_List.GSlist",
                      "href": "docs/glib__gslist___generic_slist___spec.html#L108C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets all objects that have been constructed by Builder. Note that this\n"
                },
                {
                  "kind": "span",
                  "text": "function does not increment the reference counts of the returned\n"
                },
                {
                  "kind": "span",
                  "text": "objects.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 502,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Translation_Domain",
          "qualifier": "",
          "line": 509,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 509,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Translation_Domain",
                      "href": "docs/gtk__builder___spec.html#L509C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 510,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L510C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the translation domain of Builder.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 510,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type_From_Name",
          "qualifier": "",
          "line": 522,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 522,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type_From_Name",
                      "href": "docs/gtk__builder___spec.html#L522C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 523,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L523C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 524,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Type_Name",
                      "href": "docs/gtk__builder___spec.html#L524C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Looks up a type by name, using the virtual function that\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Gtk_Builder has for that purpose. This is mainly used when\n"
                },
                {
                  "kind": "span",
                  "text": "implementing the Gtk.Buildable.Gtk_Buildable interface on a type.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"type_name\": type name to lookup\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 523,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Type_Name",
              "line": 524,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Lookup_Callback_Symbol",
          "qualifier": "",
          "line": 531,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 531,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Lookup_Callback_Symbol",
                      "href": "docs/gtk__builder___spec.html#L531C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 532,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L532C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 533,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Callback_Name",
                      "href": "docs/gtk__builder___spec.html#L533C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Fetches a symbol previously added to Builder with\n"
                },
                {
                  "kind": "span",
                  "text": "gtk_builder_add_callback_symbols\n"
                },
                {
                  "kind": "span",
                  "text": "This function is intended for possible use in language bindings or for\n"
                },
                {
                  "kind": "span",
                  "text": "any case that one might be cusomizing signal connections using\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Connect_Signals_Full\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 3.10\n"
                },
                {
                  "kind": "span",
                  "text": "\"callback_name\": The name of the callback\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 532,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Callback_Name",
              "line": 533,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Translation_Domain",
          "qualifier": "",
          "line": 514,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 514,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Translation_Domain",
                      "href": "docs/gtk__builder___spec.html#L514C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 515,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L515C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 516,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Domain",
                      "href": "docs/gtk__builder___spec.html#L516C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the translation domain of Builder. See\n"
                },
                {
                  "kind": "span",
                  "text": "Gtk.Builder.Gtk_Builder:translation-domain.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"domain\": the translation domain or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 515,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Domain",
              "line": 516,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Value_From_String",
          "qualifier": "",
          "line": 542,
          "column": 14,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 542,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value_From_String",
                      "href": "docs/gtk__builder___spec.html#L542C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 543,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L543C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 544,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pspec",
                      "href": "docs/gtk__builder___spec.html#L544C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "in"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Param_Spec",
                      "href": "docs/glib___spec.html#L266C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 545,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String",
                      "href": "docs/gtk__builder___spec.html#L545C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 546,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value",
                      "href": "docs/gtk__builder___spec.html#L546C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Values.GValue",
                      "href": "docs/glib__values___spec.html#L238C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 547,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Success",
                      "href": "docs/gtk__builder___spec.html#L547C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function demarshals a value from a string. This function calls\n"
                },
                {
                  "kind": "span",
                  "text": "g_value_init on the Value argument, so it need not be initialised\n"
                },
                {
                  "kind": "span",
                  "text": "beforehand.\n"
                },
                {
                  "kind": "span",
                  "text": "This function can handle char, uchar, boolean, int, uint, long, ulong,\n"
                },
                {
                  "kind": "span",
                  "text": "enum, flags, float, double, string, Gdk.Color.Gdk_Color,\n"
                },
                {
                  "kind": "span",
                  "text": "Gdk.RGBA.Gdk_RGBA and Gtk.Adjustment.Gtk_Adjustment type values. Support\n"
                },
                {
                  "kind": "span",
                  "text": "for Gtk.Widget.Gtk_Widget type values is still to come.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors False will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"pspec\": the Glib.Param_Spec for the property\n"
                },
                {
                  "kind": "span",
                  "text": "\"string\": the string representation of the value\n"
                },
                {
                  "kind": "span",
                  "text": "\"value\": the Glib.Values.GValue to store the result in\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 543,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Pspec",
              "line": 544,
              "column": 8,
              "type": {
                "label": "Glib.Param_Spec",
                "docHref": "docs/glib___spec.html#L266C9"
              },
              "description": [
              ]
            },
            {
              "label": "String",
              "line": 545,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Value",
              "line": 546,
              "column": 8,
              "type": {
                "label": "Glib.Values.GValue",
                "docHref": "docs/glib__values___spec.html#L44C9"
              },
              "description": [
              ]
            },
            {
              "label": "Success",
              "line": 547,
              "column": 8,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Value_From_String_Type",
          "qualifier": "",
          "line": 562,
          "column": 13,
          "src": "srcs/gtk-builder.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 562,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value_From_String_Type",
                      "href": "docs/gtk__builder___spec.html#L562C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 563,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Builder",
                      "href": "docs/gtk__builder___spec.html#L563C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtk_Builder_Record",
                      "href": "docs/gtk__builder___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 564,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "The_Type",
                      "href": "docs/gtk__builder___spec.html#L564C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 565,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String",
                      "href": "docs/gtk__builder___spec.html#L565C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 566,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value",
                      "href": "docs/gtk__builder___spec.html#L566C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Values.GValue",
                      "href": "docs/glib__values___spec.html#L238C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Like Gtk.Builder.Value_From_String, this function demarshals a value\n"
                },
                {
                  "kind": "span",
                  "text": "from a string, but takes a GType instead of Glib.Param_Spec. This\n"
                },
                {
                  "kind": "span",
                  "text": "function calls g_value_init on the Value argument, so it need not be\n"
                },
                {
                  "kind": "span",
                  "text": "initialised beforehand.\n"
                },
                {
                  "kind": "span",
                  "text": "Upon errors False will be returned and Error will be assigned a\n"
                },
                {
                  "kind": "span",
                  "text": "Gerror.Gerror from the GTK_BUILDER_ERROR domain.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.12\n"
                },
                {
                  "kind": "span",
                  "text": "\"type\": the GType of the value\n"
                },
                {
                  "kind": "span",
                  "text": "\"string\": the string representation of the value\n"
                },
                {
                  "kind": "span",
                  "text": "\"value\": the Glib.Values.GValue to store the result in\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Builder",
              "line": 563,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "The_Type",
              "line": 564,
              "column": 8,
              "type": {
                "label": "Glib.GType",
                "docHref": "docs/glib___spec.html#L284C9"
              },
              "description": [
              ]
            },
            {
              "label": "String",
              "line": 565,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Value",
              "line": 566,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Dispatching subprograms"
    }
  ]
};