GNATdoc.Documentation = {
  "label": "Glib.Utils",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Get_Home_Dir",
          "qualifier": "",
          "line": 33,
          "column": 13,
          "src": "srcs/glib-utils.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 33,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Home_Dir",
                      "href": "docs/glib__utils___spec.html#L33C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current user's home directory. As with most UNIX tools, this\n"
                },
                {
                  "kind": "span",
                  "text": "function will return the value of the HOME environment variable if it\n"
                },
                {
                  "kind": "span",
                  "text": "is set to an existing absolute path name, falling back to the passwd\n"
                },
                {
                  "kind": "span",
                  "text": "file in the case that it is unset. If the path given in HOME is\n"
                },
                {
                  "kind": "span",
                  "text": "non-absolute, does not exist, or is not a directory, the result is\n"
                },
                {
                  "kind": "span",
                  "text": "undefined. Before version 2.36 this function would ignore the HOME\n"
                },
                {
                  "kind": "span",
                  "text": "environment variable, taking the value from the passwd database\n"
                },
                {
                  "kind": "span",
                  "text": "instead. This was changed to increase the compatibility of GLib with\n"
                },
                {
                  "kind": "span",
                  "text": "other programs (and the XDG basedir specification) and to increase\n"
                },
                {
                  "kind": "span",
                  "text": "testability of programs based on GLib (by making it easier to run them\n"
                },
                {
                  "kind": "span",
                  "text": "from test frameworks). If your program has a strong requirement for\n"
                },
                {
                  "kind": "span",
                  "text": "either the new or the old behaviour (and if you don't wish to increase\n"
                },
                {
                  "kind": "span",
                  "text": "your GLib dependency to ensure that the new behaviour is in effect)\n"
                },
                {
                  "kind": "span",
                  "text": "then you should either directly check the HOME environment variable\n"
                },
                {
                  "kind": "span",
                  "text": "yourself or unset it before calling any functions in GLib.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns:\n"
                },
                {
                  "kind": "span",
                  "text": "the current user's home directory.\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};