GNATdoc.Documentation = {
  "label": "Glib.Menu",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gmenu",
          "qualifier": "",
          "line": 46,
          "column": 9,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 46,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu",
                      "href": "docs/glib__menu___spec.html#L46C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Gmenu_Item",
          "qualifier": "",
          "line": 49,
          "column": 9,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 49,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Gmenu_Item_Record",
          "qualifier": "",
          "line": 48,
          "column": 9,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 48,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "GObject_Record",
              "docHref": "docs/glib__object___spec.html#L40C9"
            }
          ]
        },
        {
          "label": "Gmenu_Record",
          "qualifier": "",
          "line": 45,
          "column": 9,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 45,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "Gmenu_Model_Record",
              "docHref": "docs/glib__menu_model___spec.html#L146C9"
            }
          ]
        }
      ],
      "label": "Tagged types"
    },
    {
      "entities": [
        {
          "label": "G_New",
          "qualifier": "",
          "line": 55,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 55,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New",
                      "href": "docs/glib__menu___spec.html#L55C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L55C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu",
                      "href": "docs/glib__menu___spec.html#L46C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu.\n"
                },
                {
                  "kind": "span",
                  "text": "The new menu has no items.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 55,
              "column": 21,
              "type": {
                "label": "Glib.Menu.Gmenu",
                "docHref": "docs/glib__menu___spec.html#L46C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "G_New",
          "qualifier": "",
          "line": 75,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 75,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New",
                      "href": "docs/glib__menu___spec.html#L75C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 76,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L76C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 77,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L77C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 78,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L78C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Label is non-null it is used to set the \"label\" attribute of the new\n"
                },
                {
                  "kind": "span",
                  "text": "item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Detailed_Action is non-null it is used to set the \"action\" and\n"
                },
                {
                  "kind": "span",
                  "text": "possibly the \"target\" attribute of the new item. See\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Detailed_Action for more information.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 76,
              "column": 8,
              "type": {
                "label": "Glib.Menu.Gmenu_Item",
                "docHref": "docs/glib__menu___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 77,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 78,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "G_New_From_Model",
          "qualifier": "",
          "line": 118,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 118,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New_From_Model",
                      "href": "docs/glib__menu___spec.html#L118C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 119,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L119C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 120,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/glib__menu___spec.html#L120C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 121,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item_Index",
                      "href": "docs/glib__menu___spec.html#L121C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a Glib.Menu.Gmenu_Item as an exact copy of an existing menu\n"
                },
                {
                  "kind": "span",
                  "text": "item in a Glib.Menu_Model.Gmenu_Model.\n"
                },
                {
                  "kind": "span",
                  "text": "Item_Index must be valid (ie: be sure to call\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu_Model.Get_N_Items first).\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.34\n"
                },
                {
                  "kind": "span",
                  "text": "\"model\": a Glib.Menu_Model.Gmenu_Model\n"
                },
                {
                  "kind": "span",
                  "text": "\"item_index\": the index of an item in Model\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 119,
              "column": 8,
              "type": {
                "label": "Glib.Menu.Gmenu_Item",
                "docHref": "docs/glib__menu___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Model",
              "line": 120,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Item_Index",
              "line": 121,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "G_New_Section",
          "qualifier": "",
          "line": 155,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 155,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New_Section",
                      "href": "docs/glib__menu___spec.html#L155C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 156,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L156C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 157,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L157C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 158,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L158C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a section.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Section.\n"
                },
                {
                  "kind": "span",
                  "text": "The effect of having one menu appear as a section of another is exactly\n"
                },
                {
                  "kind": "span",
                  "text": "as it sounds: the items from Section become a direct part of the menu\n"
                },
                {
                  "kind": "span",
                  "text": "that Menu_Item is added to.\n"
                },
                {
                  "kind": "span",
                  "text": "Visual separation is typically displayed between two non-empty\n"
                },
                {
                  "kind": "span",
                  "text": "sections. If Label is non-null then it will be encorporated into this\n"
                },
                {
                  "kind": "span",
                  "text": "visual indication. This allows for labeled subsections of a menu.\n"
                },
                {
                  "kind": "span",
                  "text": "As a simple example, consider a typical \"Edit\" menu from a simple\n"
                },
                {
                  "kind": "span",
                  "text": "program. It probably contains an \"Undo\" and \"Redo\" item, followed by a\n"
                },
                {
                  "kind": "span",
                  "text": "separator, followed by \"Cut\", \"Copy\" and \"Paste\".\n"
                },
                {
                  "kind": "span",
                  "text": "This would be accomplished by creating three Glib.Menu.Gmenu instances.\n"
                },
                {
                  "kind": "span",
                  "text": "The first would be populated with the \"Undo\" and \"Redo\" items, and the\n"
                },
                {
                  "kind": "span",
                  "text": "second with the \"Cut\", \"Copy\" and \"Paste\" items. The first and second\n"
                },
                {
                  "kind": "span",
                  "text": "menus would then be added as submenus of the third. In XML format, this\n"
                },
                {
                  "kind": "span",
                  "text": "would look something like the following: |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'>\n"
                },
                {
                  "kind": "span",
                  "text": "<section> <item label='Undo'/> <item label='Redo'/> <section>\n"
                },
                {
                  "kind": "span",
                  "text": "<item label='Cut'/> <item label='Copy'/> <item label='Paste'/>\n"
                },
                {
                  "kind": "span",
                  "text": "]|\n"
                },
                {
                  "kind": "span",
                  "text": "The following example is exactly equivalent. It is more illustrative of\n"
                },
                {
                  "kind": "span",
                  "text": "the exact relationship between the menus and items (keeping in mind that\n"
                },
                {
                  "kind": "span",
                  "text": "the 'link' element defines a new menu that is linked to the containing\n"
                },
                {
                  "kind": "span",
                  "text": "one). The style of the second example is more verbose and difficult to\n"
                },
                {
                  "kind": "span",
                  "text": "read (and therefore not recommended except for the purpose of\n"
                },
                {
                  "kind": "span",
                  "text": "understanding what is really going on). |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'> <item>\n"
                },
                {
                  "kind": "span",
                  "text": "<link name='section'> <item label='Undo'/> <item label='Redo'/>\n"
                },
                {
                  "kind": "span",
                  "text": "<item> <link name='section'> <item label='Cut'/> <item\n  label='Copy'/> <item label='Paste'/> ]|\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 156,
              "column": 8,
              "type": {
                "label": "Glib.Menu.Gmenu_Item",
                "docHref": "docs/glib__menu___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 157,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 158,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "G_New_Submenu",
          "qualifier": "",
          "line": 268,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 268,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New_Submenu",
                      "href": "docs/glib__menu___spec.html#L268C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 269,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L269C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 270,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L270C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 271,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L271C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 269,
              "column": 8,
              "type": {
                "label": "Glib.Menu.Gmenu_Item",
                "docHref": "docs/glib__menu___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 270,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 271,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type_Menu",
          "qualifier": "",
          "line": 72,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 72,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type_Menu",
                      "href": "docs/glib__menu___spec.html#L72C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Type_Menu_Item",
          "qualifier": "",
          "line": 303,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 303,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type_Menu_Item",
                      "href": "docs/glib__menu___spec.html#L303C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Gmenu_Item_New",
          "qualifier": "",
          "line": 105,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 105,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_New",
                      "href": "docs/glib__menu___spec.html#L105C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L106C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 107,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L107C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Label is non-null it is used to set the \"label\" attribute of the new\n"
                },
                {
                  "kind": "span",
                  "text": "item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Detailed_Action is non-null it is used to set the \"action\" and\n"
                },
                {
                  "kind": "span",
                  "text": "possibly the \"target\" attribute of the new item. See\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Detailed_Action for more information.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Label",
              "line": 106,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 107,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gmenu_Item_New_From_Model",
          "qualifier": "",
          "line": 144,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 144,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_New_From_Model",
                      "href": "docs/glib__menu___spec.html#L144C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 145,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/glib__menu___spec.html#L145C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 146,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item_Index",
                      "href": "docs/glib__menu___spec.html#L146C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a Glib.Menu.Gmenu_Item as an exact copy of an existing menu\n"
                },
                {
                  "kind": "span",
                  "text": "item in a Glib.Menu_Model.Gmenu_Model.\n"
                },
                {
                  "kind": "span",
                  "text": "Item_Index must be valid (ie: be sure to call\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu_Model.Get_N_Items first).\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.34\n"
                },
                {
                  "kind": "span",
                  "text": "\"model\": a Glib.Menu_Model.Gmenu_Model\n"
                },
                {
                  "kind": "span",
                  "text": "\"item_index\": the index of an item in Model\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Model",
              "line": 145,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Item_Index",
              "line": 146,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gmenu_Item_New_Section",
          "qualifier": "",
          "line": 231,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 231,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_New_Section",
                      "href": "docs/glib__menu___spec.html#L231C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 232,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L232C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 233,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L233C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 234,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a section.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Section.\n"
                },
                {
                  "kind": "span",
                  "text": "The effect of having one menu appear as a section of another is exactly\n"
                },
                {
                  "kind": "span",
                  "text": "as it sounds: the items from Section become a direct part of the menu\n"
                },
                {
                  "kind": "span",
                  "text": "that Menu_Item is added to.\n"
                },
                {
                  "kind": "span",
                  "text": "Visual separation is typically displayed between two non-empty\n"
                },
                {
                  "kind": "span",
                  "text": "sections. If Label is non-null then it will be encorporated into this\n"
                },
                {
                  "kind": "span",
                  "text": "visual indication. This allows for labeled subsections of a menu.\n"
                },
                {
                  "kind": "span",
                  "text": "As a simple example, consider a typical \"Edit\" menu from a simple\n"
                },
                {
                  "kind": "span",
                  "text": "program. It probably contains an \"Undo\" and \"Redo\" item, followed by a\n"
                },
                {
                  "kind": "span",
                  "text": "separator, followed by \"Cut\", \"Copy\" and \"Paste\".\n"
                },
                {
                  "kind": "span",
                  "text": "This would be accomplished by creating three Glib.Menu.Gmenu instances.\n"
                },
                {
                  "kind": "span",
                  "text": "The first would be populated with the \"Undo\" and \"Redo\" items, and the\n"
                },
                {
                  "kind": "span",
                  "text": "second with the \"Cut\", \"Copy\" and \"Paste\" items. The first and second\n"
                },
                {
                  "kind": "span",
                  "text": "menus would then be added as submenus of the third. In XML format, this\n"
                },
                {
                  "kind": "span",
                  "text": "would look something like the following: |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'>\n"
                },
                {
                  "kind": "span",
                  "text": "<section> <item label='Undo'/> <item label='Redo'/> <section>\n"
                },
                {
                  "kind": "span",
                  "text": "<item label='Cut'/> <item label='Copy'/> <item label='Paste'/>\n"
                },
                {
                  "kind": "span",
                  "text": "]|\n"
                },
                {
                  "kind": "span",
                  "text": "The following example is exactly equivalent. It is more illustrative of\n"
                },
                {
                  "kind": "span",
                  "text": "the exact relationship between the menus and items (keeping in mind that\n"
                },
                {
                  "kind": "span",
                  "text": "the 'link' element defines a new menu that is linked to the containing\n"
                },
                {
                  "kind": "span",
                  "text": "one). The style of the second example is more verbose and difficult to\n"
                },
                {
                  "kind": "span",
                  "text": "read (and therefore not recommended except for the purpose of\n"
                },
                {
                  "kind": "span",
                  "text": "understanding what is really going on). |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'> <item>\n"
                },
                {
                  "kind": "span",
                  "text": "<link name='section'> <item label='Undo'/> <item label='Redo'/>\n"
                },
                {
                  "kind": "span",
                  "text": "<item> <link name='section'> <item label='Cut'/> <item\n  label='Copy'/> <item label='Paste'/> ]|\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Label",
              "line": 232,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 233,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gmenu_Item_New_Submenu",
          "qualifier": "",
          "line": 292,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 292,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_New_Submenu",
                      "href": "docs/glib__menu___spec.html#L292C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 293,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L293C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 294,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L294C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 295,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item",
                      "href": "docs/glib__menu___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Label",
              "line": 293,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 294,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gmenu_New",
          "qualifier": "",
          "line": 67,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 67,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_New",
                      "href": "docs/glib__menu___spec.html#L67C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu",
                      "href": "docs/glib__menu___spec.html#L46C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu.\n"
                },
                {
                  "kind": "span",
                  "text": "The new menu has no items.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 60,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 60,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/glib__menu___spec.html#L60C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L60C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu.\n"
                },
                {
                  "kind": "span",
                  "text": "The new menu has no items.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize does nothing if the object was already created with another\n"
                },
                {
                  "kind": "span",
                  "text": "call to Initialize* or G_New.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 60,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 89,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 89,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/glib__menu___spec.html#L89C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 90,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L90C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 91,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L91C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 92,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L92C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Label is non-null it is used to set the \"label\" attribute of the new\n"
                },
                {
                  "kind": "span",
                  "text": "item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Detailed_Action is non-null it is used to set the \"action\" and\n"
                },
                {
                  "kind": "span",
                  "text": "possibly the \"target\" attribute of the new item. See\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Detailed_Action for more information.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize does nothing if the object was already created with another\n"
                },
                {
                  "kind": "span",
                  "text": "call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 90,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 91,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 92,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_From_Model",
          "qualifier": "",
          "line": 130,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 130,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_From_Model",
                      "href": "docs/glib__menu___spec.html#L130C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 131,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L131C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 132,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/glib__menu___spec.html#L132C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 133,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item_Index",
                      "href": "docs/glib__menu___spec.html#L133C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a Glib.Menu.Gmenu_Item as an exact copy of an existing menu\n"
                },
                {
                  "kind": "span",
                  "text": "item in a Glib.Menu_Model.Gmenu_Model.\n"
                },
                {
                  "kind": "span",
                  "text": "Item_Index must be valid (ie: be sure to call\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu_Model.Get_N_Items first).\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.34\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_From_Model does nothing if the object was already created\n"
                },
                {
                  "kind": "span",
                  "text": "with another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"model\": a Glib.Menu_Model.Gmenu_Model\n"
                },
                {
                  "kind": "span",
                  "text": "\"item_index\": the index of an item in Model\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 131,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Model",
              "line": 132,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Item_Index",
              "line": 133,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_Section",
          "qualifier": "",
          "line": 192,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 192,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_Section",
                      "href": "docs/glib__menu___spec.html#L192C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 193,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L193C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 194,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L194C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 195,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L195C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a section.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Section.\n"
                },
                {
                  "kind": "span",
                  "text": "The effect of having one menu appear as a section of another is exactly\n"
                },
                {
                  "kind": "span",
                  "text": "as it sounds: the items from Section become a direct part of the menu\n"
                },
                {
                  "kind": "span",
                  "text": "that Menu_Item is added to.\n"
                },
                {
                  "kind": "span",
                  "text": "Visual separation is typically displayed between two non-empty\n"
                },
                {
                  "kind": "span",
                  "text": "sections. If Label is non-null then it will be encorporated into this\n"
                },
                {
                  "kind": "span",
                  "text": "visual indication. This allows for labeled subsections of a menu.\n"
                },
                {
                  "kind": "span",
                  "text": "As a simple example, consider a typical \"Edit\" menu from a simple\n"
                },
                {
                  "kind": "span",
                  "text": "program. It probably contains an \"Undo\" and \"Redo\" item, followed by a\n"
                },
                {
                  "kind": "span",
                  "text": "separator, followed by \"Cut\", \"Copy\" and \"Paste\".\n"
                },
                {
                  "kind": "span",
                  "text": "This would be accomplished by creating three Glib.Menu.Gmenu instances.\n"
                },
                {
                  "kind": "span",
                  "text": "The first would be populated with the \"Undo\" and \"Redo\" items, and the\n"
                },
                {
                  "kind": "span",
                  "text": "second with the \"Cut\", \"Copy\" and \"Paste\" items. The first and second\n"
                },
                {
                  "kind": "span",
                  "text": "menus would then be added as submenus of the third. In XML format, this\n"
                },
                {
                  "kind": "span",
                  "text": "would look something like the following: |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'>\n"
                },
                {
                  "kind": "span",
                  "text": "<section> <item label='Undo'/> <item label='Redo'/> <section>\n"
                },
                {
                  "kind": "span",
                  "text": "<item label='Cut'/> <item label='Copy'/> <item label='Paste'/>\n"
                },
                {
                  "kind": "span",
                  "text": "]|\n"
                },
                {
                  "kind": "span",
                  "text": "The following example is exactly equivalent. It is more illustrative of\n"
                },
                {
                  "kind": "span",
                  "text": "the exact relationship between the menus and items (keeping in mind that\n"
                },
                {
                  "kind": "span",
                  "text": "the 'link' element defines a new menu that is linked to the containing\n"
                },
                {
                  "kind": "span",
                  "text": "one). The style of the second example is more verbose and difficult to\n"
                },
                {
                  "kind": "span",
                  "text": "read (and therefore not recommended except for the purpose of\n"
                },
                {
                  "kind": "span",
                  "text": "understanding what is really going on). |[\n"
                },
                {
                  "kind": "span",
                  "text": "<menu id='edit-menu'> <item>\n"
                },
                {
                  "kind": "span",
                  "text": "<link name='section'> <item label='Undo'/> <item label='Redo'/>\n"
                },
                {
                  "kind": "span",
                  "text": "<item> <link name='section'> <item label='Cut'/> <item\n  label='Copy'/> <item label='Paste'/> ]|\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_Section does nothing if the object was already created with\n"
                },
                {
                  "kind": "span",
                  "text": "another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 193,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 194,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 195,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Initialize_Submenu",
          "qualifier": "",
          "line": 279,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 279,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize_Submenu",
                      "href": "docs/glib__menu___spec.html#L279C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 280,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L280C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 281,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L281C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 282,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L282C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Menu.Gmenu_Item representing a submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "This is a convenience API around Glib.Menu.G_New and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize_Submenu does nothing if the object was already created with\n"
                },
                {
                  "kind": "span",
                  "text": "another call to Initialize* or G_New.\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 280,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 281,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 282,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    },
    {
      "entities": [
        {
          "label": "Append",
          "qualifier": "",
          "line": 310,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 310,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Append",
                      "href": "docs/glib__menu___spec.html#L310C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 311,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L311C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 312,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L312C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 313,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L313C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for appending a normal menu item to the end of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New and Glib.Menu.Insert_Item for a more\n"
                },
                {
                  "kind": "span",
                  "text": "flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 311,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 312,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 313,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Append_Item",
          "qualifier": "",
          "line": 321,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 321,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Append_Item",
                      "href": "docs/glib__menu___spec.html#L321C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 322,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L322C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 323,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item",
                      "href": "docs/glib__menu___spec.html#L323C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Appends Item to the end of Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "See Glib.Menu.Insert_Item for more information.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"item\": a Glib.Menu.Gmenu_Item to append\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 322,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Item",
              "line": 323,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Append_Section",
          "qualifier": "",
          "line": 329,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 329,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Append_Section",
                      "href": "docs/glib__menu___spec.html#L329C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 330,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L330C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 331,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L331C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 332,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L332C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for appending a section menu item to the end of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New_Section and Glib.Menu.Insert_Item for a\n"
                },
                {
                  "kind": "span",
                  "text": "more flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 330,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 331,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 332,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Append_Submenu",
          "qualifier": "",
          "line": 340,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 340,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Append_Submenu",
                      "href": "docs/glib__menu___spec.html#L340C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 341,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L341C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 342,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L342C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 343,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L343C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for appending a submenu menu item to the end of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New_Submenu and Glib.Menu.Insert_Item for a\n"
                },
                {
                  "kind": "span",
                  "text": "more flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 341,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 342,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 343,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Freeze",
          "qualifier": "",
          "line": 351,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 351,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Freeze",
                      "href": "docs/glib__menu___spec.html#L351C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L351C22"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Marks Menu as frozen.\n"
                },
                {
                  "kind": "span",
                  "text": "After the menu is frozen, it is an error to attempt to make any changes\n"
                },
                {
                  "kind": "span",
                  "text": "to it. In effect this means that the Glib.Menu.Gmenu API must no longer\n"
                },
                {
                  "kind": "span",
                  "text": "be used.\n"
                },
                {
                  "kind": "span",
                  "text": "This function causes Glib.Menu_Model.Is_Mutable to begin returning\n"
                },
                {
                  "kind": "span",
                  "text": "False, which has some positive performance implications.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 351,
              "column": 22,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Attribute_Value",
          "qualifier": "",
          "line": 477,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 477,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Attribute_Value",
                      "href": "docs/glib__menu___spec.html#L477C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 478,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L478C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 479,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Attribute",
                      "href": "docs/glib__menu___spec.html#L479C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 480,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Expected_Type",
                      "href": "docs/glib__menu___spec.html#L480C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Variant.Gvariant_Type",
                      "href": "docs/glib__variant___spec.html#L296C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 481,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Variant.Gvariant",
                      "href": "docs/glib__variant___spec.html#L244C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Queries the named Attribute on Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Expected_Type is specified and the attribute does not have this\n"
                },
                {
                  "kind": "span",
                  "text": "type, null is returned. null is also returned if the attribute simply\n"
                },
                {
                  "kind": "span",
                  "text": "does not exist.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.34\n"
                },
                {
                  "kind": "span",
                  "text": "\"attribute\": the attribute name to query\n"
                },
                {
                  "kind": "span",
                  "text": "\"expected_type\": the expected type of the attribute\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 478,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Attribute",
              "line": 479,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Expected_Type",
              "line": 480,
              "column": 8,
              "type": {
                "label": "Glib.Variant.Gvariant_Type",
                "docHref": "docs/glib__variant___spec.html#L296C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Link",
          "qualifier": "",
          "line": 511,
          "column": 13,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 511,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Link",
                      "href": "docs/glib__menu___spec.html#L511C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 512,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L512C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 513,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Link",
                      "href": "docs/glib__menu___spec.html#L513C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model",
                      "href": "docs/glib__menu_model___spec.html#L147C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Queries the named Link on Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.34\n"
                },
                {
                  "kind": "span",
                  "text": "\"link\": the link name to query\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 512,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Link",
              "line": 513,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Insert",
          "qualifier": "",
          "line": 360,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 360,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Insert",
                      "href": "docs/glib__menu___spec.html#L360C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 361,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L361C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 362,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Position",
                      "href": "docs/glib__menu___spec.html#L362C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 363,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L363C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 364,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L364C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for inserting a normal menu item into Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "Combine Glib.Menu.G_New and Glib.Menu.Insert_Item for a more flexible\n"
                },
                {
                  "kind": "span",
                  "text": "alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"position\": the position at which to insert the item\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 361,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Position",
              "line": 362,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 363,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 364,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Insert_Item",
          "qualifier": "",
          "line": 373,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 373,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Insert_Item",
                      "href": "docs/glib__menu___spec.html#L373C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 374,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L374C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 375,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Position",
                      "href": "docs/glib__menu___spec.html#L375C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 376,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item",
                      "href": "docs/glib__menu___spec.html#L376C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Inserts Item into Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "The \"insertion\" is actually done by copying all of the attribute and\n"
                },
                {
                  "kind": "span",
                  "text": "link values of Item and using them to form a new item within Menu. As\n"
                },
                {
                  "kind": "span",
                  "text": "such, Item itself is not really inserted, but rather, a menu item that\n"
                },
                {
                  "kind": "span",
                  "text": "is exactly the same as the one presently described by Item.\n"
                },
                {
                  "kind": "span",
                  "text": "This means that Item is essentially useless after the insertion occurs.\n"
                },
                {
                  "kind": "span",
                  "text": "Any changes you make to it are ignored unless it is inserted again (at\n"
                },
                {
                  "kind": "span",
                  "text": "which point its updated values will be copied).\n"
                },
                {
                  "kind": "span",
                  "text": "You should probably just free Item once you're done.\n"
                },
                {
                  "kind": "span",
                  "text": "There are many convenience functions to take care of common cases. See\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Insert, Glib.Menu.Insert_Section and Glib.Menu.Insert_Submenu\n"
                },
                {
                  "kind": "span",
                  "text": "as well as \"prepend\" and \"append\" variants of each of these functions.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"position\": the position at which to insert the item\n"
                },
                {
                  "kind": "span",
                  "text": "\"item\": the Glib.Menu.Gmenu_Item to insert\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 374,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Position",
              "line": 375,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Item",
              "line": 376,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Insert_Section",
          "qualifier": "",
          "line": 393,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 393,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Insert_Section",
                      "href": "docs/glib__menu___spec.html#L393C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 394,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L394C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 395,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Position",
                      "href": "docs/glib__menu___spec.html#L395C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 396,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L396C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 397,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L397C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for inserting a section menu item into Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "Combine Glib.Menu.G_New_Section and Glib.Menu.Insert_Item for a more\n"
                },
                {
                  "kind": "span",
                  "text": "flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"position\": the position at which to insert the item\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 394,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Position",
              "line": 395,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 396,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 397,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Insert_Submenu",
          "qualifier": "",
          "line": 406,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 406,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Insert_Submenu",
                      "href": "docs/glib__menu___spec.html#L406C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 407,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L407C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 408,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Position",
                      "href": "docs/glib__menu___spec.html#L408C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 409,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L409C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 410,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L410C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for inserting a submenu menu item into Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "Combine Glib.Menu.G_New_Submenu and Glib.Menu.Insert_Item for a more\n"
                },
                {
                  "kind": "span",
                  "text": "flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"position\": the position at which to insert the item\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 407,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Position",
              "line": 408,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 409,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 410,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Prepend",
          "qualifier": "",
          "line": 419,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 419,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Prepend",
                      "href": "docs/glib__menu___spec.html#L419C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 420,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L420C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 421,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L421C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 422,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L422C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for prepending a normal menu item to the start of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New and Glib.Menu.Insert_Item for a more\n"
                },
                {
                  "kind": "span",
                  "text": "flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the detailed action string, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 420,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 421,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 422,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Prepend_Item",
          "qualifier": "",
          "line": 430,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 430,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Prepend_Item",
                      "href": "docs/glib__menu___spec.html#L430C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 431,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L431C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 432,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Item",
                      "href": "docs/glib__menu___spec.html#L432C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Prepends Item to the start of Menu.\n"
                },
                {
                  "kind": "span",
                  "text": "See Glib.Menu.Insert_Item for more information.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"item\": a Glib.Menu.Gmenu_Item to prepend\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 431,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Item",
              "line": 432,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Prepend_Section",
          "qualifier": "",
          "line": 438,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 438,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Prepend_Section",
                      "href": "docs/glib__menu___spec.html#L438C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 439,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L439C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 440,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L440C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 441,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L441C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for prepending a section menu item to the start of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New_Section and Glib.Menu.Insert_Item for a\n"
                },
                {
                  "kind": "span",
                  "text": "more flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model with the items of the section\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 439,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 440,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 441,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Prepend_Submenu",
          "qualifier": "",
          "line": 449,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 449,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Prepend_Submenu",
                      "href": "docs/glib__menu___spec.html#L449C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 450,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L450C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 451,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L451C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 452,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L452C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function for prepending a submenu menu item to the start of\n"
                },
                {
                  "kind": "span",
                  "text": "Menu. Combine Glib.Menu.G_New_Submenu and Glib.Menu.Insert_Item for a\n"
                },
                {
                  "kind": "span",
                  "text": "more flexible alternative.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the section label, or null\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model with the items of the submenu\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 450,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 451,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 452,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Remove",
          "qualifier": "",
          "line": 460,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 460,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Remove",
                      "href": "docs/glib__menu___spec.html#L460C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 461,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L461C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 462,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Position",
                      "href": "docs/glib__menu___spec.html#L462C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Removes an item from the menu.\n"
                },
                {
                  "kind": "span",
                  "text": "Position gives the index of the item to remove.\n"
                },
                {
                  "kind": "span",
                  "text": "It is an error if position is not in range the range from 0 to one less\n"
                },
                {
                  "kind": "span",
                  "text": "than the number of items in the menu.\n"
                },
                {
                  "kind": "span",
                  "text": "It is not possible to remove items by identity since items are added to\n"
                },
                {
                  "kind": "span",
                  "text": "the menu simply by copying their links and attributes (ie: identity of\n"
                },
                {
                  "kind": "span",
                  "text": "the item itself is not preserved).\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"position\": the position of the item to remove\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 461,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Position",
              "line": 462,
              "column": 8,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Remove_All",
          "qualifier": "",
          "line": 473,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 473,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Remove_All",
                      "href": "docs/glib__menu___spec.html#L473C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L473C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Record",
                      "href": "docs/glib__menu___spec.html#L45C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Removes all items in the menu.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.38\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 473,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Action_And_Target_Value",
          "qualifier": "",
          "line": 535,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 535,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Action_And_Target_Value",
                      "href": "docs/glib__menu___spec.html#L535C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 536,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L536C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 537,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Action",
                      "href": "docs/glib__menu___spec.html#L537C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 538,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Target_Value",
                      "href": "docs/glib__menu___spec.html#L538C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Variant.Gvariant",
                      "href": "docs/glib__variant___spec.html#L244C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets or unsets the \"action\" and \"target\" attributes of Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Action is null then both the \"action\" and \"target\" attributes are\n"
                },
                {
                  "kind": "span",
                  "text": "unset (and Target_Value is ignored).\n"
                },
                {
                  "kind": "span",
                  "text": "If Action is non-null then the \"action\" attribute is set. The \"target\"\n"
                },
                {
                  "kind": "span",
                  "text": "attribute is then set to the value of Target_Value if it is non-null or\n"
                },
                {
                  "kind": "span",
                  "text": "unset otherwise.\n"
                },
                {
                  "kind": "span",
                  "text": "Normal menu items (ie: not submenu, section or other custom item types)\n"
                },
                {
                  "kind": "span",
                  "text": "are expected to have the \"action\" attribute set to identify the action\n"
                },
                {
                  "kind": "span",
                  "text": "that they are associated with. The state type of the action help to\n"
                },
                {
                  "kind": "span",
                  "text": "determine the disposition of the menu item. See Glib.Action.Gaction and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Action_Group.Gaction_Group for an overview of actions.\n"
                },
                {
                  "kind": "span",
                  "text": "In general, clicking on the menu item will result in activation of the\n"
                },
                {
                  "kind": "span",
                  "text": "named action with the \"target\" attribute given as the parameter to the\n"
                },
                {
                  "kind": "span",
                  "text": "action invocation. If the \"target\" attribute is not set then the action\n"
                },
                {
                  "kind": "span",
                  "text": "is invoked with no parameter.\n"
                },
                {
                  "kind": "span",
                  "text": "If the action has no state then the menu item is usually drawn as a\n"
                },
                {
                  "kind": "span",
                  "text": "plain menu item (ie: with no additional decoration).\n"
                },
                {
                  "kind": "span",
                  "text": "If the action has a boolean state then the menu item is usually drawn\n"
                },
                {
                  "kind": "span",
                  "text": "as a toggle menu item (ie: with a checkmark or equivalent indication).\n"
                },
                {
                  "kind": "span",
                  "text": "The item should be marked as 'toggled' or 'checked' when the boolean\n"
                },
                {
                  "kind": "span",
                  "text": "state is True.\n"
                },
                {
                  "kind": "span",
                  "text": "If the action has a string state then the menu item is usually drawn as\n"
                },
                {
                  "kind": "span",
                  "text": "a radio menu item (ie: with a radio bullet or equivalent indication).\n"
                },
                {
                  "kind": "span",
                  "text": "The item should be marked as 'selected' when the string state is equal\n"
                },
                {
                  "kind": "span",
                  "text": "to the value of the Target property.\n"
                },
                {
                  "kind": "span",
                  "text": "See g_menu_item_set_action_and_target or Glib.Menu.Set_Detailed_Action\n"
                },
                {
                  "kind": "span",
                  "text": "for two equivalent calls that are probably more convenient for most\n"
                },
                {
                  "kind": "span",
                  "text": "uses.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"action\": the name of the action for this item\n"
                },
                {
                  "kind": "span",
                  "text": "\"target_value\": a Glib.Variant.Gvariant to use as the action target\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 536,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Action",
              "line": 537,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Target_Value",
              "line": 538,
              "column": 8,
              "type": {
                "label": "Glib.Variant.Gvariant",
                "docHref": "docs/glib__variant___spec.html#L244C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Attribute_Value",
          "qualifier": "",
          "line": 490,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 490,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Attribute_Value",
                      "href": "docs/glib__menu___spec.html#L490C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 491,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L491C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 492,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Attribute",
                      "href": "docs/glib__menu___spec.html#L492C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 493,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value",
                      "href": "docs/glib__menu___spec.html#L493C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Variant.Gvariant",
                      "href": "docs/glib__variant___spec.html#L244C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets or unsets an attribute on Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "The attribute to set or unset is specified by Attribute. This can be\n"
                },
                {
                  "kind": "span",
                  "text": "one of the standard attribute names G_MENU_ATTRIBUTE_LABEL,\n"
                },
                {
                  "kind": "span",
                  "text": "G_MENU_ATTRIBUTE_ACTION, G_MENU_ATTRIBUTE_TARGET, or a custom attribute\n"
                },
                {
                  "kind": "span",
                  "text": "name. Attribute names are restricted to lowercase characters, numbers\n"
                },
                {
                  "kind": "span",
                  "text": "and '-'. Furthermore, the names must begin with a lowercase character,\n"
                },
                {
                  "kind": "span",
                  "text": "must not end with a '-', and must not contain consecutive dashes.\n"
                },
                {
                  "kind": "span",
                  "text": "must consist only of lowercase ASCII characters, digits and '-'.\n"
                },
                {
                  "kind": "span",
                  "text": "If Value is non-null then it is used as the new value for the\n"
                },
                {
                  "kind": "span",
                  "text": "attribute. If Value is null then the attribute is unset. If the Value\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Variant.Gvariant is floating, it is consumed.\n"
                },
                {
                  "kind": "span",
                  "text": "See also g_menu_item_set_attribute for a more convenient way to do the\n"
                },
                {
                  "kind": "span",
                  "text": "same.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"attribute\": the attribute to set\n"
                },
                {
                  "kind": "span",
                  "text": "\"value\": a Glib.Variant.Gvariant to use as the value, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 491,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Attribute",
              "line": 492,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Value",
              "line": 493,
              "column": 8,
              "type": {
                "label": "Glib.Variant.Gvariant",
                "docHref": "docs/glib__variant___spec.html#L244C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Detailed_Action",
          "qualifier": "",
          "line": 571,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 571,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L571C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 572,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L572C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 573,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Detailed_Action",
                      "href": "docs/glib__menu___spec.html#L573C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the \"action\" and possibly the \"target\" attribute of Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "The format of Detailed_Action is the same format parsed by\n"
                },
                {
                  "kind": "span",
                  "text": "g_action_parse_detailed_name.\n"
                },
                {
                  "kind": "span",
                  "text": "See g_menu_item_set_action_and_target or\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Menu.Set_Action_And_Target_Value for more flexible (but slightly\n"
                },
                {
                  "kind": "span",
                  "text": "less convenient) alternatives.\n"
                },
                {
                  "kind": "span",
                  "text": "See also Glib.Menu.Set_Action_And_Target_Value for a description of the\n"
                },
                {
                  "kind": "span",
                  "text": "semantics of the action and target attributes.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"detailed_action\": the \"detailed\" action string\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 572,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Detailed_Action",
              "line": 573,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Icon",
          "qualifier": "",
          "line": 585,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 585,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Icon",
                      "href": "docs/glib__menu___spec.html#L585C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 586,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L586C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 587,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Icon",
                      "href": "docs/glib__menu___spec.html#L587C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.G_Icon.G_Icon",
                      "href": "docs/glib__g_icon___spec.html#L65C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets (or unsets) the icon on Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "This call is the same as calling Glib.G_Icon.Serialize and using the\n"
                },
                {
                  "kind": "span",
                  "text": "result as the value to Glib.Menu.Set_Attribute_Value for\n"
                },
                {
                  "kind": "span",
                  "text": "G_MENU_ATTRIBUTE_ICON.\n"
                },
                {
                  "kind": "span",
                  "text": "This API is only intended for use with \"noun\" menu items; things like\n"
                },
                {
                  "kind": "span",
                  "text": "bookmarks or applications in an \"Open With\" menu. Don't use it on menu\n"
                },
                {
                  "kind": "span",
                  "text": "items corresponding to verbs (eg: stock icons for 'Save' or 'Quit').\n"
                },
                {
                  "kind": "span",
                  "text": "If Icon is null then the icon is unset.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.38\n"
                },
                {
                  "kind": "span",
                  "text": "\"icon\": a Glib.G_Icon.G_Icon, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 586,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Icon",
              "line": 587,
              "column": 8,
              "type": {
                "label": "Glib.G_Icon.G_Icon",
                "docHref": "docs/glib__g_icon___spec.html#L65C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Label",
          "qualifier": "",
          "line": 599,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 599,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Label",
                      "href": "docs/glib__menu___spec.html#L599C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 600,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L600C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 601,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Label",
                      "href": "docs/glib__menu___spec.html#L601C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets or unsets the \"label\" attribute of Menu_Item.\n"
                },
                {
                  "kind": "span",
                  "text": "If Label is non-null it is used as the label for the menu item. If it\n"
                },
                {
                  "kind": "span",
                  "text": "is null then the label attribute is unset.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"label\": the label to set, or null to unset\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 600,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Label",
              "line": 601,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Link",
          "qualifier": "",
          "line": 518,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 518,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Link",
                      "href": "docs/glib__menu___spec.html#L518C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 519,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L519C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 520,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Link",
                      "href": "docs/glib__menu___spec.html#L520C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "UTF8_String",
                      "href": "docs/glib___spec.html#L79C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 521,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Model",
                      "href": "docs/glib__menu___spec.html#L521C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a link from Menu_Item to Model if non-null, or unsets it.\n"
                },
                {
                  "kind": "span",
                  "text": "Links are used to establish a relationship between a particular menu\n"
                },
                {
                  "kind": "span",
                  "text": "item and another menu. For example, G_MENU_LINK_SUBMENU is used to\n"
                },
                {
                  "kind": "span",
                  "text": "associate a submenu with a particular menu item, and G_MENU_LINK_SECTION\n"
                },
                {
                  "kind": "span",
                  "text": "is used to create a section. Other types of link can be used, but there\n"
                },
                {
                  "kind": "span",
                  "text": "is no guarantee that clients will be able to make sense of them. Link\n"
                },
                {
                  "kind": "span",
                  "text": "types are restricted to lowercase characters, numbers and '-'.\n"
                },
                {
                  "kind": "span",
                  "text": "Furthermore, the names must begin with a lowercase character, must not\n"
                },
                {
                  "kind": "span",
                  "text": "end with a '-', and must not contain consecutive dashes.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"link\": type of link to establish or unset\n"
                },
                {
                  "kind": "span",
                  "text": "\"model\": the Glib.Menu_Model.Gmenu_Model to link to (or null to unset)\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 519,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Link",
              "line": 520,
              "column": 8,
              "type": {
                "label": "Glib.UTF8_String",
                "docHref": "docs/glib___spec.html#L79C12"
              },
              "description": [
              ]
            },
            {
              "label": "Model",
              "line": 521,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Section",
          "qualifier": "",
          "line": 608,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 608,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Section",
                      "href": "docs/glib__menu___spec.html#L608C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 609,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L609C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 610,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Section",
                      "href": "docs/glib__menu___spec.html#L610C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets or unsets the \"section\" link of Menu_Item to Section.\n"
                },
                {
                  "kind": "span",
                  "text": "The effect of having one menu appear as a section of another is exactly\n"
                },
                {
                  "kind": "span",
                  "text": "as it sounds: the items from Section become a direct part of the menu\n"
                },
                {
                  "kind": "span",
                  "text": "that Menu_Item is added to. See Glib.Menu.G_New_Section for more\n"
                },
                {
                  "kind": "span",
                  "text": "information about what it means for a menu item to be a section.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"section\": a Glib.Menu_Model.Gmenu_Model, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 609,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Section",
              "line": 610,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Submenu",
          "qualifier": "",
          "line": 619,
          "column": 14,
          "src": "srcs/glib-menu.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 619,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Submenu",
                      "href": "docs/glib__menu___spec.html#L619C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 620,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__menu___spec.html#L620C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gmenu_Item_Record",
                      "href": "docs/glib__menu___spec.html#L48C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 621,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Submenu",
                      "href": "docs/glib__menu___spec.html#L621C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Menu_Model.Gmenu_Model_Record",
                      "href": "docs/glib__menu_model___spec.html#L146C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets or unsets the \"submenu\" link of Menu_Item to Submenu.\n"
                },
                {
                  "kind": "span",
                  "text": "If Submenu is non-null, it is linked to. If it is null then the link is\n"
                },
                {
                  "kind": "span",
                  "text": "unset.\n"
                },
                {
                  "kind": "span",
                  "text": "The effect of having one menu appear as a submenu of another is exactly\n"
                },
                {
                  "kind": "span",
                  "text": "as it sounds.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.32\n"
                },
                {
                  "kind": "span",
                  "text": "\"submenu\": a Glib.Menu_Model.Gmenu_Model, or null\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 620,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Submenu",
              "line": 621,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Dispatching subprograms"
    }
  ]
};