GNATdoc.Documentation = {
  "label": "Glib.Cancellable",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Signal_Cancelled",
          "qualifier": "",
          "line": 260,
          "column": 4,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 260,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Signal_Cancelled"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Signal_Name"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "string",
                      "text": "\"cancelled\""
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Constants and variables"
    },
    {
      "entities": [
        {
          "label": "Cb_Gcancellable_Void",
          "qualifier": "",
          "line": 255,
          "column": 9,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 255,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                                "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L255C60"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cb_GObject_Void",
          "qualifier": "",
          "line": 257,
          "column": 9,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 257,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 258,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L258C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Gcallback",
          "qualifier": "",
          "line": 44,
          "column": 9,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 44,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type used for callback functions in structure definitions and\n"
                },
                {
                  "kind": "span",
                  "text": "function signatures. This doesn't mean that all callback functions must\n"
                },
                {
                  "kind": "span",
                  "text": "take no parameters and return void. The required signature of a callback\n"
                },
                {
                  "kind": "span",
                  "text": "function is determined by the context in which is used (e.g. the signal\n"
                },
                {
                  "kind": "span",
                  "text": "to which it is connected). Use G_CALLBACK to cast the callback function\n"
                },
                {
                  "kind": "span",
                  "text": "to a Gcallback.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Gcancellable",
          "qualifier": "",
          "line": 38,
          "column": 9,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 38,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable",
                      "href": "docs/glib__cancellable___spec.html#L38C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Gcancellable_Record",
          "qualifier": "",
          "line": 37,
          "column": 9,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 37,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "new"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "with"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    }
                  ]
                }
              ]
            }
          ],
          "inherits": [
            {
              "label": "GObject_Record",
              "docHref": "docs/glib__object___spec.html#L40C9"
            }
          ]
        }
      ],
      "label": "Tagged types"
    },
    {
      "entities": [
        {
          "label": "G_New",
          "qualifier": "",
          "line": 56,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 56,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "G_New",
                      "href": "docs/glib__cancellable___spec.html#L56C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L56C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable",
                      "href": "docs/glib__cancellable___spec.html#L38C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Cancellable.Gcancellable object.\n"
                },
                {
                  "kind": "span",
                  "text": "Applications that want to start one or more operations that should be\n"
                },
                {
                  "kind": "span",
                  "text": "cancellable should create a Glib.Cancellable.Gcancellable and pass it to\n"
                },
                {
                  "kind": "span",
                  "text": "the operations.\n"
                },
                {
                  "kind": "span",
                  "text": "One Glib.Cancellable.Gcancellable can be used in multiple consecutive\n"
                },
                {
                  "kind": "span",
                  "text": "operations or in multiple concurrent operations.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 56,
              "column": 21,
              "type": {
                "label": "Glib.Cancellable.Gcancellable",
                "docHref": "docs/glib__cancellable___spec.html#L38C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Gcancellable_New",
          "qualifier": "",
          "line": 74,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 74,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_New",
                      "href": "docs/glib__cancellable___spec.html#L74C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable",
                      "href": "docs/glib__cancellable___spec.html#L38C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Cancellable.Gcancellable object.\n"
                },
                {
                  "kind": "span",
                  "text": "Applications that want to start one or more operations that should be\n"
                },
                {
                  "kind": "span",
                  "text": "cancellable should create a Glib.Cancellable.Gcancellable and pass it to\n"
                },
                {
                  "kind": "span",
                  "text": "the operations.\n"
                },
                {
                  "kind": "span",
                  "text": "One Glib.Cancellable.Gcancellable can be used in multiple consecutive\n"
                },
                {
                  "kind": "span",
                  "text": "operations or in multiple concurrent operations.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Current",
          "qualifier": "",
          "line": 248,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 248,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current",
                      "href": "docs/glib__cancellable___spec.html#L248C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable",
                      "href": "docs/glib__cancellable___spec.html#L38C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the top cancellable from the stack.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 82,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 82,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/glib__cancellable___spec.html#L82C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.GType",
                      "href": "docs/glib___spec.html#L284C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Initialize",
          "qualifier": "",
          "line": 64,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 64,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Initialize",
                      "href": "docs/glib__cancellable___spec.html#L64C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L64C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Glib.Cancellable.Gcancellable object.\n"
                },
                {
                  "kind": "span",
                  "text": "Applications that want to start one or more operations that should be\n"
                },
                {
                  "kind": "span",
                  "text": "cancellable should create a Glib.Cancellable.Gcancellable and pass it to\n"
                },
                {
                  "kind": "span",
                  "text": "the operations.\n"
                },
                {
                  "kind": "span",
                  "text": "One Glib.Cancellable.Gcancellable can be used in multiple consecutive\n"
                },
                {
                  "kind": "span",
                  "text": "operations or in multiple concurrent operations.\n"
                },
                {
                  "kind": "span",
                  "text": "Initialize does nothing if the object was already created with another\n"
                },
                {
                  "kind": "span",
                  "text": "call to Initialize* or G_New.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 64,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    },
    {
      "entities": [
        {
          "label": "Cancel",
          "qualifier": "",
          "line": 89,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 89,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cancel",
                      "href": "docs/glib__cancellable___spec.html#L89C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L89C22"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Will set Cancellable to cancelled, and will emit the\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Gcancellable::cancelled signal. (However, see the\n"
                },
                {
                  "kind": "span",
                  "text": "warning about race conditions in the documentation for that signal if\n"
                },
                {
                  "kind": "span",
                  "text": "you are planning to connect to it.)\n"
                },
                {
                  "kind": "span",
                  "text": "This function is thread-safe. In other words, you can safely call it\n"
                },
                {
                  "kind": "span",
                  "text": "from a thread other than the one running the operation that was passed\n"
                },
                {
                  "kind": "span",
                  "text": "the Cancellable.\n"
                },
                {
                  "kind": "span",
                  "text": "The convention within gio is that cancelling an asynchronous operation\n"
                },
                {
                  "kind": "span",
                  "text": "causes it to complete asynchronously. That is, if you cancel the\n"
                },
                {
                  "kind": "span",
                  "text": "operation from the same thread in which it is running, then the\n"
                },
                {
                  "kind": "span",
                  "text": "operation's Gasync_Ready_Callback will not be invoked until the\n"
                },
                {
                  "kind": "span",
                  "text": "application returns to the main loop.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 89,
              "column": 22,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Connect",
          "qualifier": "",
          "line": 103,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect",
                      "href": "docs/glib__cancellable___spec.html#L103C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 104,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L104C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 105,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Callback",
                      "href": "docs/glib__cancellable___spec.html#L105C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcallback",
                      "href": "docs/glib__cancellable___spec.html#L44C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data_Destroy_Func",
                      "href": "docs/glib__cancellable___spec.html#L106C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.G_Destroy_Notify_Address",
                      "href": "docs/glib___spec.html#L190C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gulong",
                      "href": "docs/glib___spec.html#L54C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function to connect to the\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Gcancellable::cancelled signal. Also handles the race\n"
                },
                {
                  "kind": "span",
                  "text": "condition that may happen if the cancellable is cancelled right before\n"
                },
                {
                  "kind": "span",
                  "text": "connecting.\n"
                },
                {
                  "kind": "span",
                  "text": "Callback is called at most once, either directly at the time of the\n"
                },
                {
                  "kind": "span",
                  "text": "connect if Cancellable is already cancelled, or when Cancellable is\n"
                },
                {
                  "kind": "span",
                  "text": "cancelled in some thread.\n"
                },
                {
                  "kind": "span",
                  "text": "Data_Destroy_Func will be called when the handler is disconnected, or\n"
                },
                {
                  "kind": "span",
                  "text": "immediately if the cancellable is already cancelled.\n"
                },
                {
                  "kind": "span",
                  "text": "See Glib.Cancellable.Gcancellable::cancelled for details on how to use\n"
                },
                {
                  "kind": "span",
                  "text": "this.\n"
                },
                {
                  "kind": "span",
                  "text": "Since GLib 2.40, the lock protecting Cancellable is not held when\n"
                },
                {
                  "kind": "span",
                  "text": "Callback is invoked. This lifts a restriction in place for earlier GLib\n"
                },
                {
                  "kind": "span",
                  "text": "versions which now makes it easier to write cleanup code that\n"
                },
                {
                  "kind": "span",
                  "text": "unconditionally invokes e.g. Glib.Cancellable.Cancel.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.22\n"
                },
                {
                  "kind": "span",
                  "text": "\"callback\": The Gcallback to connect.\n"
                },
                {
                  "kind": "span",
                  "text": "\"data_destroy_func\": Free function for Data or null.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 104,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Callback",
              "line": 105,
              "column": 8,
              "type": {
                "label": "Glib.Cancellable.Gcallback",
                "docHref": "docs/glib__cancellable___spec.html#L44C9"
              },
              "description": [
              ]
            },
            {
              "label": "Data_Destroy_Func",
              "line": 106,
              "column": 8,
              "type": {
                "label": "Glib.G_Destroy_Notify_Address",
                "docHref": "docs/glib___spec.html#L190C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Disconnect",
          "qualifier": "",
          "line": 166,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 166,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Disconnect",
                      "href": "docs/glib__cancellable___spec.html#L166C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 167,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L167C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 168,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Handler_Id",
                      "href": "docs/glib__cancellable___spec.html#L168C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gulong",
                      "href": "docs/glib___spec.html#L54C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Disconnects a handler from a cancellable instance similar to\n"
                },
                {
                  "kind": "span",
                  "text": "g_signal_handler_disconnect. Additionally, in the event that a signal\n"
                },
                {
                  "kind": "span",
                  "text": "handler is currently running, this call will block until the handler has\n"
                },
                {
                  "kind": "span",
                  "text": "finished. Calling this function from a\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Gcancellable::cancelled signal handler will therefore\n"
                },
                {
                  "kind": "span",
                  "text": "result in a deadlock.\n"
                },
                {
                  "kind": "span",
                  "text": "This avoids a race condition where a thread cancels at the same time as\n"
                },
                {
                  "kind": "span",
                  "text": "the cancellable operation is finished and the signal handler is removed.\n"
                },
                {
                  "kind": "span",
                  "text": "See Glib.Cancellable.Gcancellable::cancelled for details on how to use\n"
                },
                {
                  "kind": "span",
                  "text": "this.\n"
                },
                {
                  "kind": "span",
                  "text": "If Cancellable is null or Handler_Id is %0 this function does nothing.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.22\n"
                },
                {
                  "kind": "span",
                  "text": "\"handler_id\": Handler id of the handler to be disconnected, or %0.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 167,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Handler_Id",
              "line": 168,
              "column": 8,
              "type": {
                "label": "Glib.Gulong",
                "docHref": "docs/glib___spec.html#L54C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Fd",
          "qualifier": "",
          "line": 183,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 183,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Fd",
                      "href": "docs/glib__cancellable___spec.html#L183C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 184,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L184C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the file descriptor for a cancellable job. This can be used to\n"
                },
                {
                  "kind": "span",
                  "text": "implement cancellable operations on Unix systems. The returned fd will\n"
                },
                {
                  "kind": "span",
                  "text": "turn readable when Cancellable is cancelled.\n"
                },
                {
                  "kind": "span",
                  "text": "You are not supposed to read from the fd yourself, just check for\n"
                },
                {
                  "kind": "span",
                  "text": "readable status. Reading to unset the readable status is done with\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Reset.\n"
                },
                {
                  "kind": "span",
                  "text": "After a successful return from this function, you should use\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Release_Fd to free up resources allocated for the\n"
                },
                {
                  "kind": "span",
                  "text": "returned file descriptor.\n"
                },
                {
                  "kind": "span",
                  "text": "See also g_cancellable_make_pollfd.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 184,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Is_Cancelled",
          "qualifier": "",
          "line": 196,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 196,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Is_Cancelled",
                      "href": "docs/glib__cancellable___spec.html#L196C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 197,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L197C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks if a cancellable job has been cancelled.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 197,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "On_Cancelled",
          "qualifier": "",
          "line": 261,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 261,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "On_Cancelled",
                      "href": "docs/glib__cancellable___spec.html#L261C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 262,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L262C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 263,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Call",
                      "href": "docs/glib__cancellable___spec.html#L263C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cb_Gcancellable_Void",
                      "href": "docs/glib__cancellable___spec.html#L255C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 264,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/glib__cancellable___spec.html#L264C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 262,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Call",
              "line": 263,
              "column": 8,
              "type": {
                "label": "Glib.Cancellable.Cb_Gcancellable_Void",
                "docHref": "docs/glib__cancellable___spec.html#L255C9"
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 264,
              "column": 8,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "On_Cancelled",
          "qualifier": "",
          "line": 265,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 265,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "On_Cancelled",
                      "href": "docs/glib__cancellable___spec.html#L265C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 266,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L266C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 267,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Call",
                      "href": "docs/glib__cancellable___spec.html#L267C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cb_GObject_Void",
                      "href": "docs/glib__cancellable___spec.html#L257C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 268,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Slot",
                      "href": "docs/glib__cancellable___spec.html#L268C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Object.GObject_Record",
                      "href": "docs/glib__object___spec.html#L720C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 269,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "After",
                      "href": "docs/glib__cancellable___spec.html#L269C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "False"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Emitted when the operation has been cancelled.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Can be used by implementations of cancellable operations. If the\n"
                },
                {
                  "kind": "span",
                  "text": "operation is cancelled from another thread, the signal will be emitted\n"
                },
                {
                  "kind": "span",
                  "text": "in the thread that cancelled the operation, not the thread that is\n"
                },
                {
                  "kind": "span",
                  "text": "running the operation.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that disconnecting from this signal (or any signal) in a\n"
                },
                {
                  "kind": "span",
                  "text": "multi-threaded program is prone to race conditions. For instance it is\n"
                },
                {
                  "kind": "span",
                  "text": "possible that a signal handler may be invoked even after a call to\n"
                },
                {
                  "kind": "span",
                  "text": "g_signal_handler_disconnect for that handler has already returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There is also a problem when cancellation happens right before\n"
                },
                {
                  "kind": "span",
                  "text": "connecting to the signal. If this happens the signal will unexpectedly\n"
                },
                {
                  "kind": "span",
                  "text": "not be emitted, and checking before connecting to the signal leaves a\n"
                },
                {
                  "kind": "span",
                  "text": "race condition where this is still happening.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "In order to make it safe and easy to connect handlers there are two\n"
                },
                {
                  "kind": "span",
                  "text": "helper functions: Glib.Cancellable.Connect and\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Disconnect which protect against problems like this.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "An example of how to us this: |[\n"
                },
                {
                  "kind": "span",
                  "text": "<!-- language=\"C\" --> // Make sure we\n"
                },
                {
                  "kind": "span",
                  "text": "don't do unnecessary work if already cancelled if\n"
                },
                {
                  "kind": "span",
                  "text": "(g_cancellable_set_error_if_cancelled (cancellable, error)) return;\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "// Set up all the data needed to be able to handle cancellation // of\n"
                },
                {
                  "kind": "span",
                  "text": "the operation my_data = my_data_new (...);\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "id = 0; if (cancellable) id = g_cancellable_connect (cancellable,\n"
                },
                {
                  "kind": "span",
                  "text": "G_CALLBACK (cancelled_handler) data, NULL);\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "// cancellable operation here...\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "g_cancellable_disconnect (cancellable, id);\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "// cancelled_handler is never called after this, it is now safe // to\n"
                },
                {
                  "kind": "span",
                  "text": "free the data my_data_free (my_data); ]|\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that the cancelled signal is emitted in the thread that the user\n"
                },
                {
                  "kind": "span",
                  "text": "cancelled from, which may be the main thread. So, the cancellable signal\n"
                },
                {
                  "kind": "span",
                  "text": "should not do something that can block.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 266,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Call",
              "line": 267,
              "column": 8,
              "type": {
                "label": "Glib.Cancellable.Cb_GObject_Void",
                "docHref": "docs/glib__cancellable___spec.html#L257C9"
              },
              "description": [
              ]
            },
            {
              "label": "Slot",
              "line": 268,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "After",
              "line": 269,
              "column": 8,
              "type": {
                "label": "Boolean"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pop_Current",
          "qualifier": "",
          "line": 200,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 200,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pop_Current",
                      "href": "docs/glib__cancellable___spec.html#L200C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L200C27"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pops Cancellable off the cancellable stack (verifying that Cancellable\n"
                },
                {
                  "kind": "span",
                  "text": "is on the top of the stack).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 200,
              "column": 27,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Push_Current",
          "qualifier": "",
          "line": 204,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 204,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Push_Current",
                      "href": "docs/glib__cancellable___spec.html#L204C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L204C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pushes Cancellable onto the cancellable stack. The current cancellable\n"
                },
                {
                  "kind": "span",
                  "text": "can then be received using Glib.Cancellable.Get_Current.\n"
                },
                {
                  "kind": "span",
                  "text": "This is useful when implementing cancellable operations in code that\n"
                },
                {
                  "kind": "span",
                  "text": "does not allow you to pass down the cancellable object.\n"
                },
                {
                  "kind": "span",
                  "text": "This is typically called automatically by e.g. Gfile.Gfile operations,\n"
                },
                {
                  "kind": "span",
                  "text": "so you rarely have to call this yourself.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 204,
              "column": 28,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Release_Fd",
          "qualifier": "",
          "line": 212,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 212,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Release_Fd",
                      "href": "docs/glib__cancellable___spec.html#L212C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L212C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Releases a resources previously allocated by Glib.Cancellable.Get_Fd or\n"
                },
                {
                  "kind": "span",
                  "text": "g_cancellable_make_pollfd.\n"
                },
                {
                  "kind": "span",
                  "text": "For compatibility reasons with older releases, calling this function is\n"
                },
                {
                  "kind": "span",
                  "text": "not strictly required, the resources will be automatically freed when\n"
                },
                {
                  "kind": "span",
                  "text": "the Cancellable is finalized. However, the Cancellable will block scarce\n"
                },
                {
                  "kind": "span",
                  "text": "file descriptors until it is finalized if this function is not called.\n"
                },
                {
                  "kind": "span",
                  "text": "This can cause the application to run out of file descriptors when many\n"
                },
                {
                  "kind": "span",
                  "text": "GCancellables are used at the same time.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.22\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 212,
              "column": 26,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Reset",
          "qualifier": "",
          "line": 223,
          "column": 14,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 223,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Reset",
                      "href": "docs/glib__cancellable___spec.html#L223C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L223C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Resets Cancellable to its uncancelled state.\n"
                },
                {
                  "kind": "span",
                  "text": "If cancellable is currently in use by any cancellable operation then\n"
                },
                {
                  "kind": "span",
                  "text": "the behavior of this function is undefined.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 223,
              "column": 21,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Error_If_Cancelled",
          "qualifier": "",
          "line": 228,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 228,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Error_If_Cancelled",
                      "href": "docs/glib__cancellable___spec.html#L228C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 229,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L229C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If the Cancellable is cancelled, sets the error to notify that the\n"
                },
                {
                  "kind": "span",
                  "text": "operation was cancelled.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 229,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Source_New",
          "qualifier": "",
          "line": 233,
          "column": 13,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 233,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Source_New",
                      "href": "docs/glib__cancellable___spec.html#L233C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 234,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___spec.html#L234C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Main.G_Source",
                      "href": "docs/glib__main___spec.html#L147C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a source that triggers if Cancellable is cancelled and calls\n"
                },
                {
                  "kind": "span",
                  "text": "its callback of type Gcancellable_Source_Func. This is primarily useful\n"
                },
                {
                  "kind": "span",
                  "text": "for attaching to another (non-cancellable) source with\n"
                },
                {
                  "kind": "span",
                  "text": "g_source_add_child_source to add cancellability to it.\n"
                },
                {
                  "kind": "span",
                  "text": "For convenience, you can call this with a null\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Gcancellable, in which case the source will never\n"
                },
                {
                  "kind": "span",
                  "text": "trigger.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.28\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 234,
              "column": 8,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Dispatching subprograms"
    },
    {
      "entities": [
        {
          "label": "Connect_User_Data",
          "href": "../docs/glib__cancellable___connect_user_data___spec.html#L129C12",
          "qualifier": "",
          "summary": [
          ],
          "description": [
          ]
        }
      ],
      "label": "Nested packages"
    }
  ]
};