GNATdoc.Documentation = {
  "label": "Glib.Cancellable.Connect_User_Data",
  "qualifier": "(nested)",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gcallback",
          "qualifier": "",
          "line": 131,
          "column": 12,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 131,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                               "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L131C43"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type used for callback functions in structure definitions and\n"
                },
                {
                  "kind": "span",
                  "text": "function signatures. This doesn't mean that all callback functions must\n"
                },
                {
                  "kind": "span",
                  "text": "take no parameters and return void. The required signature of a callback\n"
                },
                {
                  "kind": "span",
                  "text": "function is determined by the context in which is used (e.g. the signal\n"
                },
                {
                  "kind": "span",
                  "text": "to which it is connected). Use G_CALLBACK to cast the callback function\n"
                },
                {
                  "kind": "span",
                  "text": "to a Gcallback.\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Connect",
          "qualifier": "",
          "line": 139,
          "column": 16,
          "src": "srcs/glib-cancellable.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 139,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Connect",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L139C16"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 140,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L140C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "not"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "null"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Cancellable.Gcancellable_Record",
                      "href": "docs/glib__cancellable___spec.html#L37C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "'"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Class"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 141,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Callback",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L141C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gcallback",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L131C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 142,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L142C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 143,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data_Destroy_Func",
                      "href": "docs/glib__cancellable___connect_user_data___spec.html#L143C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.G_Destroy_Notify_Address",
                      "href": "docs/glib___spec.html#L190C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gulong",
                      "href": "docs/glib___spec.html#L54C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Convenience function to connect to the\n"
                },
                {
                  "kind": "span",
                  "text": "Glib.Cancellable.Gcancellable::cancelled signal. Also handles the\n"
                },
                {
                  "kind": "span",
                  "text": "race condition that may happen if the cancellable is cancelled right\n"
                },
                {
                  "kind": "span",
                  "text": "before connecting.\n"
                },
                {
                  "kind": "span",
                  "text": "Callback is called at most once, either directly at the time of the\n"
                },
                {
                  "kind": "span",
                  "text": "connect if Cancellable is already cancelled, or when Cancellable is\n"
                },
                {
                  "kind": "span",
                  "text": "cancelled in some thread.\n"
                },
                {
                  "kind": "span",
                  "text": "Data_Destroy_Func will be called when the handler is disconnected,\n"
                },
                {
                  "kind": "span",
                  "text": "or immediately if the cancellable is already cancelled.\n"
                },
                {
                  "kind": "span",
                  "text": "See Glib.Cancellable.Gcancellable::cancelled for details on how to\n"
                },
                {
                  "kind": "span",
                  "text": "use this.\n"
                },
                {
                  "kind": "span",
                  "text": "Since GLib 2.40, the lock protecting Cancellable is not held when\n"
                },
                {
                  "kind": "span",
                  "text": "Callback is invoked. This lifts a restriction in place for earlier\n"
                },
                {
                  "kind": "span",
                  "text": "GLib versions which now makes it easier to write cleanup code that\n"
                },
                {
                  "kind": "span",
                  "text": "unconditionally invokes e.g. Glib.Cancellable.Cancel.\n"
                },
                {
                  "kind": "span",
                  "text": "Since: gtk+ 2.22\n"
                },
                {
                  "kind": "span",
                  "text": "\"callback\": The Gcallback to connect.\n"
                },
                {
                  "kind": "span",
                  "text": "\"data\": Data to pass to Callback.\n"
                },
                {
                  "kind": "span",
                  "text": "\"data_destroy_func\": Free function for Data or null.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 140,
              "column": 11,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Callback",
              "line": 141,
              "column": 11,
              "type": {
                "label": "Glib.Cancellable.Connect_User_Data.Gcallback",
                "docHref": "docs/glib__cancellable___connect_user_data___spec.html#L131C12"
              },
              "description": [
              ]
            },
            {
              "label": "Data",
              "line": 142,
              "column": 11,
              "type": {
                "label": "Glib.Cancellable.Connect_User_Data.User_Data_Type",
                "docHref": "docs/glib__cancellable___connect_user_data___spec.html#L127C12"
              },
              "description": [
              ]
            },
            {
              "label": "Data_Destroy_Func",
              "line": 143,
              "column": 11,
              "type": {
                "label": "Glib.G_Destroy_Notify_Address",
                "docHref": "docs/glib___spec.html#L190C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};