GNATdoc.Documentation = {
  "label": "Gdk.Window.Invalidate_Maybe_Recurse_User_Data",
  "qualifier": "(nested)",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Gdk_Window_Child_Func",
          "qualifier": "",
          "line": 1369,
          "column": 12,
          "src": "srcs/gdk-window.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1369,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1370,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Window",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1370C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Gdk_Window",
                      "href": "docs/gdk___spec.html#L43C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1371,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1371C10"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A function of this type is passed to\n"
                },
                {
                  "kind": "span",
                  "text": "Gdk.Window.Invalidate_Maybe_Recurse. It gets called for each child of\n"
                },
                {
                  "kind": "span",
                  "text": "the window to determine whether to recursively invalidate it or now.\n"
                },
                {
                  "kind": "span",
                  "text": "\"window\": a Gdk.Gdk_Window\n"
                },
                {
                  "kind": "span",
                  "text": "\"user_data\": user data\n"
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Invalidate_Maybe_Recurse",
          "qualifier": "",
          "line": 1378,
          "column": 17,
          "src": "srcs/gdk-window.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1378,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Invalidate_Maybe_Recurse",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1378C17"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1379,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Self",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1379C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk.Gdk_Window",
                      "href": "docs/gdk___spec.html#L43C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1380,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Region",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1380C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo.Region.Cairo_Region",
                      "href": "docs/cairo__region___spec.html#L202C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1381,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Child_Func",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1381C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdk_Window_Child_Func",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1369C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1382,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "          "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1382C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data_Type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds Region to the update area for Window. The update area is the\n"
                },
                {
                  "kind": "span",
                  "text": "region that needs to be redrawn, or \"dirty region.\" The call\n"
                },
                {
                  "kind": "span",
                  "text": "Gdk.Window.Process_Updates sends one or more expose events to the\n"
                },
                {
                  "kind": "span",
                  "text": "window, which together cover the entire update area. An application\n"
                },
                {
                  "kind": "span",
                  "text": "would normally redraw the contents of Window in response to those\n"
                },
                {
                  "kind": "span",
                  "text": "expose events.\n"
                },
                {
                  "kind": "span",
                  "text": "GDK will call Gdk.Window.Process_All_Updates on your behalf whenever\n"
                },
                {
                  "kind": "span",
                  "text": "your program returns to the main loop and becomes idle, so normally\n"
                },
                {
                  "kind": "span",
                  "text": "there's no need to do that manually, you just need to invalidate\n"
                },
                {
                  "kind": "span",
                  "text": "regions that you know should be redrawn.\n"
                },
                {
                  "kind": "span",
                  "text": "The Child_Func parameter controls whether the region of each child\n"
                },
                {
                  "kind": "span",
                  "text": "window that intersects Region will also be invalidated. Only children\n"
                },
                {
                  "kind": "span",
                  "text": "for which Child_Func returns TRUE will have the area invalidated.\n"
                },
                {
                  "kind": "span",
                  "text": "\"region\": a cairo_region_t\n"
                },
                {
                  "kind": "span",
                  "text": "\"child_func\": function to use to decide if to recurse to a child,\n"
                },
                {
                  "kind": "span",
                  "text": "null means never recurse.\n"
                },
                {
                  "kind": "span",
                  "text": "\"user_data\": data passed to Child_Func\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Self",
              "line": 1379,
              "column": 11,
              "type": {
                "label": "Gdk.Gdk_Window",
                "docHref": "docs/gdk___spec.html#L43C9"
              },
              "description": [
              ]
            },
            {
              "label": "Region",
              "line": 1380,
              "column": 11,
              "type": {
                "label": "Cairo.Region.Cairo_Region",
                "docHref": "docs/cairo__region___spec.html#L37C9"
              },
              "description": [
              ]
            },
            {
              "label": "Child_Func",
              "line": 1381,
              "column": 11,
              "type": {
                "label": "Gdk.Window.Invalidate_Maybe_Recurse_User_Data.Gdk_Window_Child_Func",
                "docHref": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1369C12"
              },
              "description": [
              ]
            },
            {
              "label": "User_Data",
              "line": 1382,
              "column": 11,
              "type": {
                "label": "Gdk.Window.Invalidate_Maybe_Recurse_User_Data.User_Data_Type",
                "docHref": "docs/gdk__window___invalidate_maybe_recurse_user_data___spec.html#L1365C12"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};