GNATdoc.Documentation = {
  "label": "Cairo.SVG",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Create",
          "qualifier": "",
          "line": 26,
          "column": 13,
          "src": "srcs/cairo-svg.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 26,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create",
                      "href": "docs/cairo__svg___spec.html#L26C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 27,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/cairo__svg___spec.html#L27C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 28,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width_In_Point",
                      "href": "docs/cairo__svg___spec.html#L28C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 29,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height_In_Point",
                      "href": "docs/cairo__svg___spec.html#L29C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a SVG surface of the specified size in points to be written to\n"
                },
                {
                  "kind": "span",
                  "text": "filename.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The SVG surface backend recognizes the following MIME types for the data\n"
                },
                {
                  "kind": "span",
                  "text": "attached to a surface (see Cairo.Surface.Set_Mime_Data) when it is\n"
                },
                {
                  "kind": "span",
                  "text": "used as a source pattern for drawing on this surface:\n"
                },
                {
                  "kind": "span",
                  "text": "CAIRO_MIME_TYPE_JPEG, CAIRO_MIME_TYPE_PNG, CAIRO_MIME_TYPE_URI. If any\n"
                },
                {
                  "kind": "span",
                  "text": "of them is specified, the SVG backend emits a href with the content of\n"
                },
                {
                  "kind": "span",
                  "text": "MIME data instead of a surface snapshot (PNG, Base64-encoded) in the\n"
                },
                {
                  "kind": "span",
                  "text": "corresponding image tag.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The unofficial MIME type CAIRO_MIME_TYPE_URI is examined first. If\n"
                },
                {
                  "kind": "span",
                  "text": "present, the URI is emitted as is: assuring the correctness of URI is\n"
                },
                {
                  "kind": "span",
                  "text": "left to the client code.\n"
                },
                {
                  "kind": "span",
                  "text": "If CAIRO_MIME_TYPE_URI is not present, but CAIRO_MIME_TYPE_JPEG or\n"
                },
                {
                  "kind": "span",
                  "text": "CAIRO_MIME_TYPE_PNG is specified, the corresponding data is\n"
                },
                {
                  "kind": "span",
                  "text": "Base64-encoded and emitted.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "filename :\n"
                },
                {
                  "kind": "span",
                  "text": "a filename for the SVG output (must be writable), NULL may be used to\n"
                },
                {
                  "kind": "span",
                  "text": "specify no output. This will generate a SVG surface that may be queried\n"
                },
                {
                  "kind": "span",
                  "text": "and used as a source, without generating a temporary file.\n"
                },
                {
                  "kind": "span",
                  "text": "width_in_points :\n"
                },
                {
                  "kind": "span",
                  "text": "width of the surface, in points (1 point == 1/72.0 inch)\n"
                },
                {
                  "kind": "span",
                  "text": "height_in_points :\n"
                },
                {
                  "kind": "span",
                  "text": "height of the surface, in points (1 point == 1/72.0 inch)\n"
                },
                {
                  "kind": "span",
                  "text": "Returns :\n"
                },
                {
                  "kind": "span",
                  "text": "a pointer to the newly created surface. The caller owns the surface and\n"
                },
                {
                  "kind": "span",
                  "text": "should call Cairo.Surface.Destroy when done with it. This function\n"
                },
                {
                  "kind": "span",
                  "text": "always returns a valid pointer, but it will return a pointer to a \"nil\"\n"
                },
                {
                  "kind": "span",
                  "text": "surface if an error such as out of memory occurs. You can use\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Status to check for this.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Filename",
              "line": 27,
              "column": 7,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            },
            {
              "label": "Width_In_Point",
              "line": 28,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height_In_Point",
              "line": 29,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};