GNATdoc.Documentation = {
  "label": "Cairo.Surface",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Cairo_Surface_Type",
          "qualifier": "",
          "line": 41,
          "column": 9,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 41,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type",
                      "href": "docs/cairo__surface___spec.html#L41C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 42,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Image",
                      "href": "docs/cairo__surface___spec.html#L42C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 43,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Pdf",
                      "href": "docs/cairo__surface___spec.html#L43C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 44,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Ps",
                      "href": "docs/cairo__surface___spec.html#L44C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 45,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Xlib",
                      "href": "docs/cairo__surface___spec.html#L45C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 46,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Xcb",
                      "href": "docs/cairo__surface___spec.html#L46C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 47,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Glitz",
                      "href": "docs/cairo__surface___spec.html#L47C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 48,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Quartz",
                      "href": "docs/cairo__surface___spec.html#L48C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 49,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Win32",
                      "href": "docs/cairo__surface___spec.html#L49C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 50,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Beos",
                      "href": "docs/cairo__surface___spec.html#L50C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 51,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Directfb",
                      "href": "docs/cairo__surface___spec.html#L51C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 52,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Svg",
                      "href": "docs/cairo__surface___spec.html#L52C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 53,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Os2",
                      "href": "docs/cairo__surface___spec.html#L53C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 54,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Win32_Printing",
                      "href": "docs/cairo__surface___spec.html#L54C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 55,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type_Quartz_Image",
                      "href": "docs/cairo__surface___spec.html#L55C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo__surface___spec.html#L41C9"
                    }
                  ]
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Surface_Type_Image",
              "line": 42,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Pdf",
              "line": 43,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Ps",
              "line": 44,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Xlib",
              "line": 45,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Xcb",
              "line": 46,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Glitz",
              "line": 47,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Quartz",
              "line": 48,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Win32",
              "line": 49,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Beos",
              "line": 50,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Directfb",
              "line": 51,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Svg",
              "line": 52,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Os2",
              "line": 53,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Win32_Printing",
              "line": 54,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Cairo_Surface_Type_Quartz_Image",
              "line": 55,
              "column": 7,
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Simple types"
    },
    {
      "entities": [
        {
          "label": "Copy_Page",
          "qualifier": "",
          "line": 354,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 354,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy_Page",
                      "href": "docs/cairo__surface___spec.html#L354C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L354C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Emits the current page for backends that support multiple pages,\n"
                },
                {
                  "kind": "span",
                  "text": "but doesn't clear it, so that the contents of the current page will\n"
                },
                {
                  "kind": "span",
                  "text": "be retained for the next page.  Use Cairo.Surface.Show_Page if you\n"
                },
                {
                  "kind": "span",
                  "text": "want to get an empty page after the emission.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There is a convenience function for this that takes a Cairo_Context,\n"
                },
                {
                  "kind": "span",
                  "text": "namely Cairo.Copy_Page.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.6\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 354,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Similar",
          "qualifier": "",
          "line": 82,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 82,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Similar",
                      "href": "docs/cairo__surface___spec.html#L82C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 83,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Other",
                      "href": "docs/cairo__surface___spec.html#L83C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 84,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Content",
                      "href": "docs/cairo__surface___spec.html#L84C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content",
                      "href": "docs/cairo___spec.html#L316C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 85,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/cairo__surface___spec.html#L85C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 86,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo__surface___spec.html#L86C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 87,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Other: an existing surface used to select the backend of the new surface\n"
                },
                {
                  "kind": "span",
                  "text": "Content: the Content for the new surface\n"
                },
                {
                  "kind": "span",
                  "text": "Width: Width of the new surface, (in device-space units)\n"
                },
                {
                  "kind": "span",
                  "text": "Height: Height of the new surface (in device-space units)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a new surface that is as compatible as possible with an\n"
                },
                {
                  "kind": "span",
                  "text": "existing surface. For example the new surface will have the same\n"
                },
                {
                  "kind": "span",
                  "text": "fallback resolution and font options as other. Generally, the new\n"
                },
                {
                  "kind": "span",
                  "text": "surface will also use the same backend as other, unless that is\n"
                },
                {
                  "kind": "span",
                  "text": "not possible for some reason. The type of the returned surface may\n"
                },
                {
                  "kind": "span",
                  "text": "be examined with Cairo.Surface.Get_Type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initially the surface contents are all 0 (transparent if contents\n"
                },
                {
                  "kind": "span",
                  "text": "have transparency, black otherwise.)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a pointer to the newly allocated surface. The caller\n"
                },
                {
                  "kind": "span",
                  "text": "owns the surface and should call Cairo.Surface.Destroy when done\n"
                },
                {
                  "kind": "span",
                  "text": "with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function always returns a valid pointer, but it will return a\n"
                },
                {
                  "kind": "span",
                  "text": "pointer to a \"nil\" surface if other is already in an error state\n"
                },
                {
                  "kind": "span",
                  "text": "or any other error occurs.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Other",
              "line": 83,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Content",
              "line": 84,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Content",
                "docHref": "docs/cairo___spec.html#L316C12"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 85,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 86,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Destroy",
          "qualifier": "",
          "line": 141,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 141,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__surface___spec.html#L141C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L141C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Decreases the reference count on surface by one. If the result is\n"
                },
                {
                  "kind": "span",
                  "text": "zero, then surface and all associated resources are freed.  See\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Reference.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 141,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Finish",
          "qualifier": "",
          "line": 123,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 123,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Finish",
                      "href": "docs/cairo__surface___spec.html#L123C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L123C22"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: the Cairo_Surface to finish\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function finishes the surface and drops all references to\n"
                },
                {
                  "kind": "span",
                  "text": "external resources.  For example, for the Xlib backend it means\n"
                },
                {
                  "kind": "span",
                  "text": "that cairo will no longer access the drawable, which can be freed.\n"
                },
                {
                  "kind": "span",
                  "text": "After calling Cairo.Surface.Finish the only valid operations on a\n"
                },
                {
                  "kind": "span",
                  "text": "surface are getting and setting user, referencing and\n"
                },
                {
                  "kind": "span",
                  "text": "destroying, and flushing and finishing it.\n"
                },
                {
                  "kind": "span",
                  "text": "Further drawing to the surface will not affect the\n"
                },
                {
                  "kind": "span",
                  "text": "surface but will instead trigger a Cairo_Status_Surface_Finished\n"
                },
                {
                  "kind": "span",
                  "text": "error.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "When the last call to Cairo.Surface.Destroy decreases the\n"
                },
                {
                  "kind": "span",
                  "text": "reference count to zero, cairo will call Cairo.Surface.Finish if\n"
                },
                {
                  "kind": "span",
                  "text": "it hasn't been called already, before freeing the resources\n"
                },
                {
                  "kind": "span",
                  "text": "associated with the surface.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 123,
              "column": 22,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Flush",
          "qualifier": "",
          "line": 235,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 235,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Flush",
                      "href": "docs/cairo__surface___spec.html#L235C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L235C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Do any pending drawing for the surface and also restore any\n"
                },
                {
                  "kind": "span",
                  "text": "temporary modification's cairo has made to the surface's\n"
                },
                {
                  "kind": "span",
                  "text": "state. This function must be called before switching from\n"
                },
                {
                  "kind": "span",
                  "text": "drawing on the surface with cairo to drawing on it directly\n"
                },
                {
                  "kind": "span",
                  "text": "with native APIs. If the surface doesn't support direct access,\n"
                },
                {
                  "kind": "span",
                  "text": "then this function does nothing.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 235,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Content",
          "qualifier": "",
          "line": 179,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 179,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Content",
                      "href": "docs/cairo__surface___spec.html#L179C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L179C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content",
                      "href": "docs/cairo___spec.html#L316C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the content type of surface which indicates\n"
                },
                {
                  "kind": "span",
                  "text": "whether the surface contains color and/or alpha information. See\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Content.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The content type of surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 179,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Device_Offset",
          "qualifier": "",
          "line": 292,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 292,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Device_Offset",
                      "href": "docs/cairo__surface___spec.html#L292C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 293,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L293C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 294,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Offset",
                      "href": "docs/cairo__surface___spec.html#L294C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 295,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Offset",
                      "href": "docs/cairo__surface___spec.html#L295C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "X_Offset: the offset in the X direction, in device units\n"
                },
                {
                  "kind": "span",
                  "text": "Y_Offset: the offset in the Y direction, in device units\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the previous device offset set by\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Set_Device_Offset.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 293,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "X_Offset",
              "line": 294,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y_Offset",
              "line": 295,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Fallback_Resolution",
          "qualifier": "",
          "line": 340,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 340,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Fallback_Resolution",
                      "href": "docs/cairo__surface___spec.html#L340C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 341,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L341C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 342,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Pixels_Per_Inch",
                      "href": "docs/cairo__surface___spec.html#L342C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 343,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Pixels_Per_Inch",
                      "href": "docs/cairo__surface___spec.html#L343C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "X_Pixels_Per_Inch: horizontal pixels per inch\n"
                },
                {
                  "kind": "span",
                  "text": "Y_Pixels_Per_Inch: vertical pixels per inch\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the previous fallback resolution set by\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Set_Fallback_Resolution, or default fallback\n"
                },
                {
                  "kind": "span",
                  "text": "resolution if never set.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 341,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "X_Pixels_Per_Inch",
              "line": 342,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y_Pixels_Per_Inch",
              "line": 343,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Font_Options",
          "qualifier": "",
          "line": 222,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 222,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Font_Options",
                      "href": "docs/cairo__surface___spec.html#L222C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 223,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L223C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 224,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__surface___spec.html#L224C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options object into which to store\n"
                },
                {
                  "kind": "span",
                  "text": "the retrieved options. All existing values are overwritten\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Retrieves the default font rendering options for the surface.\n"
                },
                {
                  "kind": "span",
                  "text": "This allows display surfaces to report the correct subpixel order\n"
                },
                {
                  "kind": "span",
                  "text": "for rendering on them, print surfaces to disable hinting of\n"
                },
                {
                  "kind": "span",
                  "text": "metrics and so forth. The result can then be used with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Scaled_Font.Create.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 223,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Options",
              "line": 224,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Reference_Count",
          "qualifier": "",
          "line": 148,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 148,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Reference_Count",
                      "href": "docs/cairo__surface___spec.html#L148C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L148C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the current reference count of surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current reference count of surface.  If the\n"
                },
                {
                  "kind": "span",
                  "text": "object is a nil object, 0 will be returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 148,
              "column": 34,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 169,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 169,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/cairo__surface___spec.html#L169C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L169C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface_Type",
                      "href": "docs/cairo__surface___spec.html#L41C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the type of the backend used to create\n"
                },
                {
                  "kind": "span",
                  "text": "a surface. See Cairo_Surface_Type for available types.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The type of surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 169,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_User_Data",
          "qualifier": "",
          "line": 190,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 190,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_User_Data",
                      "href": "docs/cairo__surface___spec.html#L190C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 191,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L191C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 192,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__surface___spec.html#L192C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of the Cairo_User_Data_Key the user data was\n"
                },
                {
                  "kind": "span",
                  "text": "attached to\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return user data previously attached to surface using the specified\n"
                },
                {
                  "kind": "span",
                  "text": "key.  If no user data has been attached with the given key this\n"
                },
                {
                  "kind": "span",
                  "text": "function returns null.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the user data previously attached or null.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 191,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 192,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Has_Show_Text_Glyphs",
          "qualifier": "",
          "line": 378,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 378,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Has_Show_Text_Glyphs",
                      "href": "docs/cairo__surface___spec.html#L378C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 379,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L379C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 380,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns whether the surface supports\n"
                },
                {
                  "kind": "span",
                  "text": "sophisticated Cairo_Show_Text_Glyphs operations.  That is,\n"
                },
                {
                  "kind": "span",
                  "text": "whether it actually uses the provided text and cluster data\n"
                },
                {
                  "kind": "span",
                  "text": "to a Cairo_Show_Text_Glyphs call.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: Even if this function returns FALSE, a\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Show_Text_Glyphs operation targeted at surface will\n"
                },
                {
                  "kind": "span",
                  "text": "still succeed.  It just will\n"
                },
                {
                  "kind": "span",
                  "text": "act like a Cairo_Show_Glyphs operation.  Users can use this\n"
                },
                {
                  "kind": "span",
                  "text": "function to avoid computing UTF-8 text and cluster mapping if the\n"
                },
                {
                  "kind": "span",
                  "text": "target surface does not use it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: TRUE if surface supports\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Show_Text_Glyphs, FALSE otherwise"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 379,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Mark_Dirty",
          "qualifier": "",
          "line": 245,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 245,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Mark_Dirty",
                      "href": "docs/cairo__surface___spec.html#L245C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L245C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Tells cairo that drawing has been done to surface using means other\n"
                },
                {
                  "kind": "span",
                  "text": "than cairo, and that cairo should reread any cached areas. Note\n"
                },
                {
                  "kind": "span",
                  "text": "that you must call Cairo.Surface.Flush before doing such drawing.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 245,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Mark_Dirty_Rectangle",
          "qualifier": "",
          "line": 252,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 252,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Mark_Dirty_Rectangle",
                      "href": "docs/cairo__surface___spec.html#L252C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 253,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L253C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 254,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo__surface___spec.html#L254C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 255,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo__surface___spec.html#L255C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 256,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/cairo__surface___spec.html#L256C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 257,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo__surface___spec.html#L257C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "X: X coordinate of dirty rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y coordinate of dirtY rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Width: Width of dirty rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Height: Height of dirty rectangle\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Like Cairo.Surface.Mark_Dirty, but drawing has been done only to\n"
                },
                {
                  "kind": "span",
                  "text": "the specified rectangle, so that cairo can retain cached contents\n"
                },
                {
                  "kind": "span",
                  "text": "for other parts of the surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Any cached clip set on the surface will be reset by this function,\n"
                },
                {
                  "kind": "span",
                  "text": "to make sure that future cairo calls have the clip set that they\n"
                },
                {
                  "kind": "span",
                  "text": "expect.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 253,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 254,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 255,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 256,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 257,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Reference",
          "qualifier": "",
          "line": 111,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 111,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Reference",
                      "href": "docs/cairo__surface___spec.html#L111C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L111C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Increases the reference count on surface by one. This prevents\n"
                },
                {
                  "kind": "span",
                  "text": "surface from being destroyed until a matching call to\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Destroy is made.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The number of references to a Cairo_Surface can be get using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Get_Reference_Count.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the referenced Cairo_Surface.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 111,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Device_Offset",
          "qualifier": "",
          "line": 272,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 272,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Device_Offset",
                      "href": "docs/cairo__surface___spec.html#L272C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 273,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L273C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 274,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Offset",
                      "href": "docs/cairo__surface___spec.html#L274C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 275,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Offset",
                      "href": "docs/cairo__surface___spec.html#L275C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "X_Offset: the offset in the X direction, in device units\n"
                },
                {
                  "kind": "span",
                  "text": "Y_Offset: the offset in the Y direction, in device units\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets an offset that is added to the device coordinates determined\n"
                },
                {
                  "kind": "span",
                  "text": "by the CTM when drawing to surface. One use case for this function\n"
                },
                {
                  "kind": "span",
                  "text": "is when we want to create a Cairo_Surface that redirects drawing\n"
                },
                {
                  "kind": "span",
                  "text": "for a portion of an onscreen surface to an offscreen surface in a\n"
                },
                {
                  "kind": "span",
                  "text": "way that is completely invisible to the user of the cairo\n"
                },
                {
                  "kind": "span",
                  "text": "API. Setting a transformation via Cairo.Translate isn't\n"
                },
                {
                  "kind": "span",
                  "text": "sufficient to do this, since functions like\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Device_To_User will expose the hidden offset.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that the offset affects drawing to the surface as well as\n"
                },
                {
                  "kind": "span",
                  "text": "using the surface in a source pattern.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 273,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "X_Offset",
              "line": 274,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y_Offset",
              "line": 275,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Fallback_Resolution",
          "qualifier": "",
          "line": 305,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 305,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Fallback_Resolution",
                      "href": "docs/cairo__surface___spec.html#L305C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 306,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L306C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "           "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 307,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Pixels_Per_Inch",
                      "href": "docs/cairo__surface___spec.html#L307C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 308,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Pixels_Per_Inch",
                      "href": "docs/cairo__surface___spec.html#L308C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "X_Pixels_Per_Inch: horizontal setting for pixels per inch\n"
                },
                {
                  "kind": "span",
                  "text": "Y_Pixels_Per_Inch: vertical setting for pixels per inch\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Set the horizontal and vertical resolution for image fallbacks.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "When certain operations aren't supported natively by a backend,\n"
                },
                {
                  "kind": "span",
                  "text": "cairo will fallback by rendering operations to an image and then\n"
                },
                {
                  "kind": "span",
                  "text": "overlaying that image onto the output. For backends that are\n"
                },
                {
                  "kind": "span",
                  "text": "natively vector-oriented, this function can be used to set the\n"
                },
                {
                  "kind": "span",
                  "text": "resolution used for these image fallbacks, (larger values will\n"
                },
                {
                  "kind": "span",
                  "text": "result in more detailed images, but also larger file sizes).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Some examples of natively vector-oriented backends are the ps, pdf,\n"
                },
                {
                  "kind": "span",
                  "text": "and svg backends.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "For backends that are natively raster-oriented, image fallbacks are\n"
                },
                {
                  "kind": "span",
                  "text": "still possible, but they are always performed at the native\n"
                },
                {
                  "kind": "span",
                  "text": "device resolution. So this function has no effect on those\n"
                },
                {
                  "kind": "span",
                  "text": "backends.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: The fallback resolution only takes effect at the time of\n"
                },
                {
                  "kind": "span",
                  "text": "completing a page (with Cairo.Show_Page or Cairo.Copy_Page) so\n"
                },
                {
                  "kind": "span",
                  "text": "there is currently no way to have more than one fallback resolution\n"
                },
                {
                  "kind": "span",
                  "text": "in effect on a single page.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default fallback resoultion is 300 pixels per inch in both\n"
                },
                {
                  "kind": "span",
                  "text": "dimensions.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 306,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "X_Pixels_Per_Inch",
              "line": 307,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y_Pixels_Per_Inch",
              "line": 308,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_User_Data",
          "qualifier": "",
          "line": 203,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 203,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_User_Data",
                      "href": "docs/cairo__surface___spec.html#L203C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 204,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L204C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 205,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__surface___spec.html#L205C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 206,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/cairo__surface___spec.html#L206C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 207,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__surface___spec.html#L207C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Destroy_Func",
                      "href": "docs/cairo___spec.html#L188C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of a Cairo_User_Data_Key to attach the user data to\n"
                },
                {
                  "kind": "span",
                  "text": "User_Data: the user data to attach to the surface\n"
                },
                {
                  "kind": "span",
                  "text": "Destroy: a Cairo_Destroy_Func which will be called when the\n"
                },
                {
                  "kind": "span",
                  "text": "surface is destroyed or when new user data is attached using the\n"
                },
                {
                  "kind": "span",
                  "text": "same key.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Attach user data to surface.  To remove user data from a surface,\n"
                },
                {
                  "kind": "span",
                  "text": "call this function with the key that was used to set it and null\n"
                },
                {
                  "kind": "span",
                  "text": "for data.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success or Cairo_Status_No_Memory if a\n"
                },
                {
                  "kind": "span",
                  "text": "slot could not be allocated for the user data.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 204,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 205,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User_Data",
              "line": 206,
              "column": 7,
              "type": {
                "label": "Address"
              },
              "description": [
              ]
            },
            {
              "label": "Destroy",
              "line": 207,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Destroy_Func",
                "docHref": "docs/cairo___spec.html#L188C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Show_Page",
          "qualifier": "",
          "line": 367,
          "column": 14,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 367,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Show_Page",
                      "href": "docs/cairo__surface___spec.html#L367C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L367C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Emits and clears the current page for backends that support multiple\n"
                },
                {
                  "kind": "span",
                  "text": "pages.  Use Cairo.Surface.Copy_Page if you don't want to clear the page.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There is a convenience function for this that takes a Cairo_Context,\n"
                },
                {
                  "kind": "span",
                  "text": "namely Cairo_Show_Page.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.6\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 367,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Status",
          "qualifier": "",
          "line": 158,
          "column": 13,
          "src": "srcs/cairo-surface.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 158,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo__surface___spec.html#L158C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__surface___spec.html#L158C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks whether an error has previously occurred for this\n"
                },
                {
                  "kind": "span",
                  "text": "surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, Cairo_Status_Null_Pointer,\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Status_No_Memory, Cairo_Status_Read_Error,"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Status_Invalid_Content, Cairo_Status_Invalid_Format, or"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Status_Invalid_Visual."
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 158,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};