GNATdoc.Documentation = {
  "label": "Cairo.Png",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Create_From_Png",
          "qualifier": "",
          "line": 50,
          "column": 13,
          "src": "srcs/cairo-png.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 50,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_From_Png",
                      "href": "docs/cairo__png___spec.html#L50C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 51,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/cairo__png___spec.html#L51C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 52,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Filename: name of PNG file to load\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new image surface and initializes the contents to the\n"
                },
                {
                  "kind": "span",
                  "text": "given PNG file.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a new Cairo_Surface initialized with the contents\n"
                },
                {
                  "kind": "span",
                  "text": "of the PNG file, or a \"nil\" surface if any error occurred. A nil\n"
                },
                {
                  "kind": "span",
                  "text": "surface can be checked for with Cairo.Surface.Status (Surface) which\n"
                },
                {
                  "kind": "span",
                  "text": "may return one of the following values:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Status_No_Memory\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_File_Not_Found\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Read_Error\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Alternatively, you can allow errors to propagate through the drawing\n"
                },
                {
                  "kind": "span",
                  "text": "operations and check the status on the context upon completion\n"
                },
                {
                  "kind": "span",
                  "text": "using Cairo_Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Filename",
              "line": 51,
              "column": 7,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Write_To_Png",
          "qualifier": "",
          "line": 33,
          "column": 13,
          "src": "srcs/cairo-png.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 33,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Write_To_Png",
                      "href": "docs/cairo__png___spec.html#L33C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 34,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__png___spec.html#L34C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 35,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filename",
                      "href": "docs/cairo__png___spec.html#L35C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "String"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 36,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface with pixel contents\n"
                },
                {
                  "kind": "span",
                  "text": "Filename: the name of a file to write to\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Writes the contents of surface to a new file filename as a PNG\n"
                },
                {
                  "kind": "span",
                  "text": "image.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success if the PNG file was written\n"
                },
                {
                  "kind": "span",
                  "text": "successfully. Otherwise, Cairo_Status_No_Memory if memory could not\n"
                },
                {
                  "kind": "span",
                  "text": "be allocated for the operation or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Surface_Type_Mismatch if the surface does not have\n"
                },
                {
                  "kind": "span",
                  "text": "pixel contents, or Cairo_Status_Write_Error if an I/O error occurs\n"
                },
                {
                  "kind": "span",
                  "text": "while attempting to write the file.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 34,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Filename",
              "line": 35,
              "column": 7,
              "type": {
                "label": "String"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};