GNATdoc.Documentation = {
  "label": "Cairo.Pattern",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Cairo_Extend",
          "qualifier": "",
          "line": 89,
          "column": 9,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 89,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend",
                      "href": "docs/cairo__pattern___spec.html#L89C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 90,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend_None",
                      "href": "docs/cairo__pattern___spec.html#L90C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 91,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Pixels outside of the source pattern are fully transparent"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 92,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 93,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend_Repeat",
                      "href": "docs/cairo__pattern___spec.html#L93C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 94,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is tiled by repeating"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 95,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 96,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend_Reflect",
                      "href": "docs/cairo__pattern___spec.html#L96C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 97,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is tiled by reflecting at the edges (Implemented for"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 98,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  surface patterns since 1.6)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 99,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 100,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend_Pad",
                      "href": "docs/cairo__pattern___spec.html#L100C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 101,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Pixels outside of the pattern copy"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the closest pixel from the source (Since 1.2; but only"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  implemented for surface patterns since 1.6)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 104,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo__pattern___spec.html#L89C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_extend is used to describe how pattern color/alpha will be\n"
                },
                {
                  "kind": "span",
                  "text": "determined for areas \"outside\" the pattern's natural area, (for\n"
                },
                {
                  "kind": "span",
                  "text": "example, outside the surface bounds or outside the gradient\n"
                },
                {
                  "kind": "span",
                  "text": "geometry).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default extend mode is CAIRO_EXTEND_NONE for surface patterns\n"
                },
                {
                  "kind": "span",
                  "text": "and CAIRO_EXTEND_PAD for gradient patterns.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Extend_None",
              "line": 90,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Pixels outside of the source pattern are fully transparent\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Extend_Repeat",
              "line": 93,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is tiled by repeating\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Extend_Reflect",
              "line": 96,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is tiled by reflecting at the edges (Implemented for\n"
                    },
                    {
                      "kind": "span",
                      "text": "surface patterns since 1.6)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Extend_Pad",
              "line": 100,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Pixels outside of the pattern copy\n"
                    },
                    {
                      "kind": "span",
                      "text": "the closest pixel from the source (Since 1.2; but only\n"
                    },
                    {
                      "kind": "span",
                      "text": "implemented for surface patterns since 1.6)\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Filter",
          "qualifier": "",
          "line": 111,
          "column": 9,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 111,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter",
                      "href": "docs/cairo__pattern___spec.html#L111C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 112,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Fast",
                      "href": "docs/cairo__pattern___spec.html#L112C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 113,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A high-performance filter, with quality similar to"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 114,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Cairo_Filter_Nearest"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 115,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 116,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Good",
                      "href": "docs/cairo__pattern___spec.html#L116C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 117,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A reasonable-performance filter, with quality similar to"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 118,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Cairo_Filter_Bilinear"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 119,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 120,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Best",
                      "href": "docs/cairo__pattern___spec.html#L120C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 121,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The highest-quality available, performance may"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 122,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  not be suitable for interactive use."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 123,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 124,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Nearest",
                      "href": "docs/cairo__pattern___spec.html#L124C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 125,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Nearest-neighbor filtering"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 126,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 127,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Bilinear",
                      "href": "docs/cairo__pattern___spec.html#L127C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 128,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Linear interpolation in two dimensions"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 129,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 130,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter_Gaussian",
                      "href": "docs/cairo__pattern___spec.html#L130C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 131,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  This filter value is currently unimplemented, and should not be used"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 132,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  in current code."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 133,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo__pattern___spec.html#L111C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_filter is used to indicate what filtering should be\n"
                },
                {
                  "kind": "span",
                  "text": "applied when reading pixel values from patterns. See\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Set_Source for indicating the desired filter to be\n"
                },
                {
                  "kind": "span",
                  "text": "used with a particular pattern.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Filter_Fast",
              "line": 112,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A high-performance filter, with quality similar to\n"
                    },
                    {
                      "kind": "span",
                      "text": "Cairo_Filter_Nearest\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Filter_Good",
              "line": 116,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A reasonable-performance filter, with quality similar to\n"
                    },
                    {
                      "kind": "span",
                      "text": "Cairo_Filter_Bilinear\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Filter_Best",
              "line": 120,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The highest-quality available, performance may\n"
                    },
                    {
                      "kind": "span",
                      "text": "not be suitable for interactive use.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Filter_Nearest",
              "line": 124,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Nearest-neighbor filtering\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Filter_Bilinear",
              "line": 127,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Linear interpolation in two dimensions\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Filter_Gaussian",
              "line": 130,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "This filter value is currently unimplemented, and should not be used\n"
                    },
                    {
                      "kind": "span",
                      "text": "in current code.\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Pattern_Type",
          "qualifier": "",
          "line": 64,
          "column": 9,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 64,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type",
                      "href": "docs/cairo__pattern___spec.html#L64C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 65,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type_Solid",
                      "href": "docs/cairo__pattern___spec.html#L65C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 66,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is a solid (uniform) color. It may be opaque or"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 67,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  translucent."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 68,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 69,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type_Surface",
                      "href": "docs/cairo__pattern___spec.html#L69C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 70,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is a based on a surface (an image)."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 71,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 72,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type_Linear",
                      "href": "docs/cairo__pattern___spec.html#L72C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 73,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is a linear gradient."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 74,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 75,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type_Radial",
                      "href": "docs/cairo__pattern___spec.html#L75C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 76,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The pattern is a radial gradient."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 77,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo__pattern___spec.html#L64C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Pattern_Type is used to describe the type of a given pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type of a pattern is determined by the function used to create\n"
                },
                {
                  "kind": "span",
                  "text": "it. The Cairo.Pattern.Create_Rgb and Cairo.Pattern.Create_Rgba\n"
                },
                {
                  "kind": "span",
                  "text": "functions create Solid patterns. The remaining\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Create_<> functions map to pattern types in obvious\n"
                },
                {
                  "kind": "span",
                  "text": "ways.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The pattern type can be queried with Cairo.Pattern.Get_Type\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Most Cairo_Pattern functions can be called with a pattern of any type,\n"
                },
                {
                  "kind": "span",
                  "text": "(though trying to change the extend or filter for a solid pattern will\n"
                },
                {
                  "kind": "span",
                  "text": "have no effect). A notable exception is Cairo.Pattern.Add_Color_Stop_Rgb\n"
                },
                {
                  "kind": "span",
                  "text": "and Cairo.Pattern.Add_Color_Stop_Rgba which must only be called with\n"
                },
                {
                  "kind": "span",
                  "text": "gradient patterns (either Linear or Radial). Otherwise the pattern will\n"
                },
                {
                  "kind": "span",
                  "text": "be shutdown and put into an error state.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Pattern_Type_Solid",
              "line": 65,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is a solid (uniform) color. It may be opaque or\n"
                    },
                    {
                      "kind": "span",
                      "text": "translucent.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Pattern_Type_Surface",
              "line": 69,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is a based on a surface (an image).\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Pattern_Type_Linear",
              "line": 72,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is a linear gradient.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Pattern_Type_Radial",
              "line": 75,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The pattern is a radial gradient.\n"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Simple types"
    },
    {
      "entities": [
        {
          "label": "Add_Color_Stop_Rgb",
          "qualifier": "",
          "line": 347,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 347,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Color_Stop_Rgb",
                      "href": "docs/cairo__pattern___spec.html#L347C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 348,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L348C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 349,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo__pattern___spec.html#L349C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 350,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L350C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 351,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L351C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 352,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L352C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Offset: an Offset in the range [0.0 .. 1.0]\n"
                },
                {
                  "kind": "span",
                  "text": "Red: Red component of color\n"
                },
                {
                  "kind": "span",
                  "text": "Green: Green component of color\n"
                },
                {
                  "kind": "span",
                  "text": "Blue: Blue component of color\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds an opaque color stop to a gradient pattern. The offset\n"
                },
                {
                  "kind": "span",
                  "text": "specifies the location along the gradient's control vector. For\n"
                },
                {
                  "kind": "span",
                  "text": "example, a linear gradient's control vector is from (X0,Y0) to\n"
                },
                {
                  "kind": "span",
                  "text": "(X1,Y1) while a radial gradient's control vector is from any point\n"
                },
                {
                  "kind": "span",
                  "text": "on the start circle to the corresponding point on the end circle.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The color is specified in the same way as in Cairo.Set_Source_Rgb.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If two (or more) stops are specified with identical offset values,\n"
                },
                {
                  "kind": "span",
                  "text": "they will be sorted according to the order in which the stops are\n"
                },
                {
                  "kind": "span",
                  "text": "added, (stops added earlier will compare less than stops added\n"
                },
                {
                  "kind": "span",
                  "text": "later). This can be useful for reliably making sharp color\n"
                },
                {
                  "kind": "span",
                  "text": "transitions instead of the typical blend.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: If the pattern is not a gradient pattern, (eg. a linear or\n"
                },
                {
                  "kind": "span",
                  "text": "radial pattern), then the pattern will be put into an error status\n"
                },
                {
                  "kind": "span",
                  "text": "with a status of Cairo_Status_Pattern_Type_Mismatch.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 348,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 349,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 350,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 351,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 352,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Add_Color_Stop_Rgba",
          "qualifier": "",
          "line": 378,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 378,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Add_Color_Stop_Rgba",
                      "href": "docs/cairo__pattern___spec.html#L378C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 379,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L379C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 380,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo__pattern___spec.html#L380C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 381,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L381C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 382,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L382C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 383,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L383C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 384,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo__pattern___spec.html#L384C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Offset: an Offset in the range [0.0 .. 1.0]\n"
                },
                {
                  "kind": "span",
                  "text": "Red: Red component of color\n"
                },
                {
                  "kind": "span",
                  "text": "Green: Green component of color\n"
                },
                {
                  "kind": "span",
                  "text": "Blue: Blue component of color\n"
                },
                {
                  "kind": "span",
                  "text": "Alpha: Alpha component of color\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a translucent color stop to a gradient pattern. The offset\n"
                },
                {
                  "kind": "span",
                  "text": "specifies the location along the gradient's control vector. For\n"
                },
                {
                  "kind": "span",
                  "text": "example, a linear gradient's control vector is from (x0,y0) to\n"
                },
                {
                  "kind": "span",
                  "text": "(x1,y1) while a radial gradient's control vector is from any point\n"
                },
                {
                  "kind": "span",
                  "text": "on the start circle to the corresponding point on the end circle.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The color is specified in the same way as in Cairo_Set_Source_Rgba.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If two (or more) stops are specified with identical offset values,\n"
                },
                {
                  "kind": "span",
                  "text": "they will be sorted according to the order in which the stops are\n"
                },
                {
                  "kind": "span",
                  "text": "added, (stops added earlier will compare less than stops added\n"
                },
                {
                  "kind": "span",
                  "text": "later). This can be useful for reliably making sharp color\n"
                },
                {
                  "kind": "span",
                  "text": "transitions instead of the typical blend.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: If the pattern is not a gradient pattern, (eg. a linear or\n"
                },
                {
                  "kind": "span",
                  "text": "radial pattern), then the pattern will be put into an error status\n"
                },
                {
                  "kind": "span",
                  "text": "with a status of Cairo_Status_Pattern_Type_Mismatch.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 379,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 380,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 381,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 382,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 383,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 384,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_For_Surface",
          "qualifier": "",
          "line": 184,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 184,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_For_Surface",
                      "href": "docs/cairo__pattern___spec.html#L184C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 185,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__pattern___spec.html#L185C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 186,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Surface: the Surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a new Cairo_Pattern for the given surface.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the newly created Cairo_Pattern if successful, or\n"
                },
                {
                  "kind": "span",
                  "text": "an error pattern in case of no memory.  The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Cairo.Pattern.Destroy when\n"
                },
                {
                  "kind": "span",
                  "text": "finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but if an error\n"
                },
                {
                  "kind": "span",
                  "text": "occurred the pattern status will be set to an error. To inspect\n"
                },
                {
                  "kind": "span",
                  "text": "the status of a pattern use Cairo.Pattern.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 185,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Linear",
          "qualifier": "",
          "line": 200,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 200,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Linear",
                      "href": "docs/cairo__pattern___spec.html#L200C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 201,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo__pattern___spec.html#L201C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 202,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo__pattern___spec.html#L202C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 203,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo__pattern___spec.html#L203C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 204,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo__pattern___spec.html#L204C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 205,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "X0: x coordinate of the start point\n"
                },
                {
                  "kind": "span",
                  "text": "Y0: y coordinate of the start point\n"
                },
                {
                  "kind": "span",
                  "text": "X1: x coordinate of the end point\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: y coordinate of the end point\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Create a new linear gradient Cairo_Pattern along the line defined\n"
                },
                {
                  "kind": "span",
                  "text": "by (X0, Y0) and (X1, Y1).  Before using the gradient pattern, a\n"
                },
                {
                  "kind": "span",
                  "text": "number of color stops should be defined using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Add_Color_Stop_Rgb or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Add_Color_Stop_Rgba.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: The coordinates here are in pattern space. For a new pattern,\n"
                },
                {
                  "kind": "span",
                  "text": "pattern space is identical to user space, but the relationship\n"
                },
                {
                  "kind": "span",
                  "text": "between the spaces can be changed with Cairo.Pattern.Set_Matrix.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the newly created Cairo_Pattern if successful, or\n"
                },
                {
                  "kind": "span",
                  "text": "an error pattern in case of no memory.  The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Cairo.Pattern.Destroy when\n"
                },
                {
                  "kind": "span",
                  "text": "finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but if an error\n"
                },
                {
                  "kind": "span",
                  "text": "occurred the pattern status will be set to an error.  To inspect\n"
                },
                {
                  "kind": "span",
                  "text": "the status of a pattern use Cairo.Pattern.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "X0",
              "line": 201,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 202,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 203,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 204,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Radial",
          "qualifier": "",
          "line": 230,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 230,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Radial",
                      "href": "docs/cairo__pattern___spec.html#L230C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 231,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cx0",
                      "href": "docs/cairo__pattern___spec.html#L231C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 232,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cy0",
                      "href": "docs/cairo__pattern___spec.html#L232C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 233,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius0",
                      "href": "docs/cairo__pattern___spec.html#L233C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 234,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cx1",
                      "href": "docs/cairo__pattern___spec.html#L234C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 235,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cy1",
                      "href": "docs/cairo__pattern___spec.html#L235C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 236,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius1",
                      "href": "docs/cairo__pattern___spec.html#L236C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 237,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cx0: X coordinate for the center of the start circle\n"
                },
                {
                  "kind": "span",
                  "text": "Cy0: Y coordinate for the center of the start circle\n"
                },
                {
                  "kind": "span",
                  "text": "Radius0: radius of the start circle\n"
                },
                {
                  "kind": "span",
                  "text": "Cx1: X coordinate for the center of the end circle\n"
                },
                {
                  "kind": "span",
                  "text": "Cy1: Y coordinate for the center of the end circle\n"
                },
                {
                  "kind": "span",
                  "text": "Radius1: radius of the end circle\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new radial gradient Cairo_Pattern between the two circles\n"
                },
                {
                  "kind": "span",
                  "text": "defined by (Cx0, Cy0, Radius0) and (Cx1, Cy1, Radius1). Before using the\n"
                },
                {
                  "kind": "span",
                  "text": "gradient pattern, a number of color stops should be defined using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Add_Color_Stop_Rgb or Cairo.Pattern.Add_Color_Stop_Rgba.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: The coordinates here are in pattern space. For a new pattern,\n"
                },
                {
                  "kind": "span",
                  "text": "pattern space is identical to user space, but the relationship\n"
                },
                {
                  "kind": "span",
                  "text": "between the spaces can be changed with Cairo.Pattern.Set_Matrix.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the newly created Cairo_Pattern if successful, or\n"
                },
                {
                  "kind": "span",
                  "text": "an error pattern in case of no memory.  The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Cairo.Pattern.Destroy when\n"
                },
                {
                  "kind": "span",
                  "text": "finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but if an error\n"
                },
                {
                  "kind": "span",
                  "text": "occurred the pattern status will be set to an error.  To inspect\n"
                },
                {
                  "kind": "span",
                  "text": "the status of a pattern use Cairo.Pattern.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cx0",
              "line": 231,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cy0",
              "line": 232,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius0",
              "line": 233,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cx1",
              "line": 234,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cy1",
              "line": 235,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius1",
              "line": 236,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Rgb",
          "qualifier": "",
          "line": 136,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 136,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Rgb",
                      "href": "docs/cairo__pattern___spec.html#L136C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 137,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L137C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 138,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L138C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 139,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L139C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 140,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Red:   Red component of the color\n"
                },
                {
                  "kind": "span",
                  "text": "Green: Green component of the color\n"
                },
                {
                  "kind": "span",
                  "text": "Blue:  Blue component of the color\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Cairo_Pattern corresponding to an opaque color.  The\n"
                },
                {
                  "kind": "span",
                  "text": "color components are floating point numbers in the range 0 to 1.\n"
                },
                {
                  "kind": "span",
                  "text": "If the values passed in are outside that range, they will be\n"
                },
                {
                  "kind": "span",
                  "text": "clamped.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the newly created Cairo_Pattern if successful, or\n"
                },
                {
                  "kind": "span",
                  "text": "an error pattern in case of no memory.  The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Cairo.Pattern.Destroy when\n"
                },
                {
                  "kind": "span",
                  "text": "finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but if an error\n"
                },
                {
                  "kind": "span",
                  "text": "occurred the pattern status will be set to an error. To inspect\n"
                },
                {
                  "kind": "span",
                  "text": "the status of a pattern use Cairo.Pattern.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Red",
              "line": 137,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 138,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 139,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create_Rgba",
          "qualifier": "",
          "line": 159,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 159,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create_Rgba",
                      "href": "docs/cairo__pattern___spec.html#L159C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 160,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L160C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 161,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L161C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 162,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L162C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 163,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo__pattern___spec.html#L163C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 164,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Red: Red component of the color\n"
                },
                {
                  "kind": "span",
                  "text": "Green: Green component of the color\n"
                },
                {
                  "kind": "span",
                  "text": "Blue: Blue component of the color\n"
                },
                {
                  "kind": "span",
                  "text": "Alpha: Alpha component of the color\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Cairo_Pattern corresponding to a translucent color.\n"
                },
                {
                  "kind": "span",
                  "text": "The color components are floating point numbers in the range 0 to\n"
                },
                {
                  "kind": "span",
                  "text": "1.  If the values passed in are outside that range, they will be\n"
                },
                {
                  "kind": "span",
                  "text": "clamped.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the newly created Cairo_Pattern if successful, or\n"
                },
                {
                  "kind": "span",
                  "text": "an error pattern in case of no memory.  The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Cairo.Pattern.Destroy when\n"
                },
                {
                  "kind": "span",
                  "text": "finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but if an error\n"
                },
                {
                  "kind": "span",
                  "text": "occurred the pattern status will be set to an error. To inspect\n"
                },
                {
                  "kind": "span",
                  "text": "the status of a pattern use Cairo.Pattern.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Red",
              "line": 160,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 161,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 162,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 163,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Destroy",
          "qualifier": "",
          "line": 275,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 275,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__pattern___spec.html#L275C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L275C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Decreases the reference count on pattern by one. If the result is\n"
                },
                {
                  "kind": "span",
                  "text": "zero, then pattern and all associated resources are freed.  See\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Reference.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 275,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Color_Stop_Count",
          "qualifier": "",
          "line": 561,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 561,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Color_Stop_Count",
                      "href": "docs/cairo__pattern___spec.html#L561C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 562,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L562C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 563,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Count",
                      "href": "docs/cairo__pattern___spec.html#L563C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 564,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Count: return value for the number of color stops, or NULL\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the number of color stops specified in the given gradient\n"
                },
                {
                  "kind": "span",
                  "text": "pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch if pattern is not a gradient\n"
                },
                {
                  "kind": "span",
                  "text": "pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 562,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Count",
              "line": 563,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Color_Stop_Rgba",
          "qualifier": "",
          "line": 533,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 533,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Color_Stop_Rgba",
                      "href": "docs/cairo__pattern___spec.html#L533C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 534,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L534C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 535,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Index",
                      "href": "docs/cairo__pattern___spec.html#L535C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 536,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo__pattern___spec.html#L536C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 537,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L537C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 538,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L538C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 539,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L539C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 540,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo__pattern___spec.html#L540C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 541,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Index: Index of the stop to return data for\n"
                },
                {
                  "kind": "span",
                  "text": "Offset: return value for the Offset of the stop, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Red: return value for Red component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Green: return value for Green component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Blue: return value for Blue component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Alpha: return value for Alpha component of color, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the color and offset information at the given index for a\n"
                },
                {
                  "kind": "span",
                  "text": "gradient pattern.  Values of index are 0 to 1 less than the number\n"
                },
                {
                  "kind": "span",
                  "text": "returned by Cairo.Pattern.Get_Color_Stop_Count.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or Cairo_Status_Invalid_Index\n"
                },
                {
                  "kind": "span",
                  "text": "if index is not valid for the given pattern.  If the pattern is\n"
                },
                {
                  "kind": "span",
                  "text": "not a gradient pattern, Cairo_Status_Pattern_Type_Mismatch is\n"
                },
                {
                  "kind": "span",
                  "text": "returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 534,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Index",
              "line": 535,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 536,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 537,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 538,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 539,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 540,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Extend",
          "qualifier": "",
          "line": 461,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 461,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Extend",
                      "href": "docs/cairo__pattern___spec.html#L461C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L461C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend",
                      "href": "docs/cairo__pattern___spec.html#L89C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current extend mode for a pattern.  See Cairo_Extend\n"
                },
                {
                  "kind": "span",
                  "text": "for details on the semantics of each extend strategy.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current extend strategy used for drawing the\n"
                },
                {
                  "kind": "span",
                  "text": "pattern.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 461,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Filter",
          "qualifier": "",
          "line": 487,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 487,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Filter",
                      "href": "docs/cairo__pattern___spec.html#L487C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L487C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter",
                      "href": "docs/cairo__pattern___spec.html#L111C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current filter for a pattern.  See Cairo_Filter\n"
                },
                {
                  "kind": "span",
                  "text": "for details on each filter.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current filter used for resizing the pattern.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 487,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Linear_Points",
          "qualifier": "",
          "line": 577,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 577,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Linear_Points",
                      "href": "docs/cairo__pattern___spec.html#L577C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 578,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L578C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 579,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo__pattern___spec.html#L579C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 580,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo__pattern___spec.html#L580C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 581,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo__pattern___spec.html#L581C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 582,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo__pattern___spec.html#L582C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 583,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "X0: return value for the x coordinate of the first point, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Y0: return value for the y coordinate of the first point, or null\n"
                },
                {
                  "kind": "span",
                  "text": "X1: return value for the x coordinate of the second point, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: return value for the y coordinate of the second point, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the gradient endpoints for a linear gradient.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch if pattern is not a linear\n"
                },
                {
                  "kind": "span",
                  "text": "gradient pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 578,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "X0",
              "line": 579,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 580,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 581,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 582,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Matrix",
          "qualifier": "",
          "line": 441,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 441,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Matrix",
                      "href": "docs/cairo__pattern___spec.html#L441C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 442,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L442C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 443,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__pattern___spec.html#L443C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Matrix: return value for the Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Stores the pattern's transformation matrix into matrix.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 442,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Matrix",
              "line": 443,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Radial_Circles",
          "qualifier": "",
          "line": 598,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 598,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Radial_Circles",
                      "href": "docs/cairo__pattern___spec.html#L598C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 599,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L599C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 600,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo__pattern___spec.html#L600C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 601,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo__pattern___spec.html#L601C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 602,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "R0",
                      "href": "docs/cairo__pattern___spec.html#L602C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 603,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo__pattern___spec.html#L603C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 604,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo__pattern___spec.html#L604C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 605,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "R1",
                      "href": "docs/cairo__pattern___spec.html#L605C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 606,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "X0: return value for the x coordinate of the center of the first\n"
                },
                {
                  "kind": "span",
                  "text": "circle, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Y0: return value for the y coordinate of the center of the first\n"
                },
                {
                  "kind": "span",
                  "text": "circle, or null\n"
                },
                {
                  "kind": "span",
                  "text": "R0: return value for the radius of the first circle, or null\n"
                },
                {
                  "kind": "span",
                  "text": "X1: return value for the x coordinate of the center of the second\n"
                },
                {
                  "kind": "span",
                  "text": "circle, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: return value for the y coordinate of the center of the second\n"
                },
                {
                  "kind": "span",
                  "text": "circle, or null\n"
                },
                {
                  "kind": "span",
                  "text": "R1: return value for the radius of the second circle, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the gradient endpoint circles for a radial gradient, each\n"
                },
                {
                  "kind": "span",
                  "text": "specified as a center coordinate and a radius.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch if pattern is not a radial\n"
                },
                {
                  "kind": "span",
                  "text": "gradient pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 599,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "X0",
              "line": 600,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 601,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "R0",
              "line": 602,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 603,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 604,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "R1",
              "line": 605,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Reference_Count",
          "qualifier": "",
          "line": 282,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 282,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Reference_Count",
                      "href": "docs/cairo__pattern___spec.html#L282C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L282C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the current reference count of pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current reference count of pattern.  If the\n"
                },
                {
                  "kind": "span",
                  "text": "object is a nil object, 0 will be returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 282,
              "column": 34,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Rgba",
          "qualifier": "",
          "line": 495,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 495,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Rgba",
                      "href": "docs/cairo__pattern___spec.html#L495C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 496,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L496C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 497,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo__pattern___spec.html#L497C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 498,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo__pattern___spec.html#L498C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 499,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo__pattern___spec.html#L499C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 500,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo__pattern___spec.html#L500C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 501,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Red: return value for Red component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Green: return value for Green component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Blue: return value for Blue component of color, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Alpha: return value for Alpha component of color, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the solid color for a solid color pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch if the pattern is not a solid\n"
                },
                {
                  "kind": "span",
                  "text": "color pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 496,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 497,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 498,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 499,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 500,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Surface",
          "qualifier": "",
          "line": 516,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 516,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Surface",
                      "href": "docs/cairo__pattern___spec.html#L516C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 517,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L517C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 518,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo__pattern___spec.html#L518C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 519,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Surface: return value for Surface of pattern, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the surface of a surface pattern.  The reference returned in\n"
                },
                {
                  "kind": "span",
                  "text": "surface is owned by the pattern; the caller should call\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Reference if the surface is to be retained.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch if the pattern is not a surface\n"
                },
                {
                  "kind": "span",
                  "text": "pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 517,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Surface",
              "line": 518,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 337,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 337,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/cairo__pattern___spec.html#L337C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L337C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern_Type",
                      "href": "docs/cairo__pattern___spec.html#L64C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the type a pattern.\n"
                },
                {
                  "kind": "span",
                  "text": "See Cairo_Pattern_Type for available types.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The type of pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 337,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_User_Data",
          "qualifier": "",
          "line": 301,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 301,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_User_Data",
                      "href": "docs/cairo__pattern___spec.html#L301C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 302,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L302C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 303,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__pattern___spec.html#L303C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of the Cairo_User_Data_Key the user data was\n"
                },
                {
                  "kind": "span",
                  "text": "attached to\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return user data previously attached to pattern using the\n"
                },
                {
                  "kind": "span",
                  "text": "specified key.  If no user data has been attached with the given\n"
                },
                {
                  "kind": "span",
                  "text": "key this function returns System.Null_Address.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the user data previously attached or System.Null_Address.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 302,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 303,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Reference",
          "qualifier": "",
          "line": 263,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 263,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Reference",
                      "href": "docs/cairo__pattern___spec.html#L263C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L263C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Increases the reference count on pattern by one. This prevents\n"
                },
                {
                  "kind": "span",
                  "text": "pattern from being destroyed until a matching call to\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Destroy is made.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The number of references to a Cairo_Pattern can be get using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Get_Reference_Count.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the referenced Cairo_Pattern.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 263,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Extend",
          "qualifier": "",
          "line": 449,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 449,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Extend",
                      "href": "docs/cairo__pattern___spec.html#L449C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L449C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Extend",
                      "href": "docs/cairo__pattern___spec.html#L449C51"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Extend",
                      "href": "docs/cairo__pattern___spec.html#L89C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Extend: a Cairo_Extend describing how the area outside of the\n"
                },
                {
                  "kind": "span",
                  "text": "pattern will be drawn\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the mode to be used for drawing outside the area of a pattern.\n"
                },
                {
                  "kind": "span",
                  "text": "See Cairo_Extend for details on the semantics of each extend\n"
                },
                {
                  "kind": "span",
                  "text": "strategy.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default extend mode is Cairo_Extend_None for surface patterns\n"
                },
                {
                  "kind": "span",
                  "text": "and Cairo_Extend_PAd for gradient patterns.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 449,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Extend",
              "line": 449,
              "column": 51,
              "type": {
                "label": "Cairo.Pattern.Cairo_Extend",
                "docHref": "docs/cairo__pattern___spec.html#L89C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Filter",
          "qualifier": "",
          "line": 470,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 470,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Filter",
                      "href": "docs/cairo__pattern___spec.html#L470C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L470C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Filter",
                      "href": "docs/cairo__pattern___spec.html#L470C51"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Filter",
                      "href": "docs/cairo__pattern___spec.html#L111C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Filter: a Cairo_Filter describing the Filter to use for resizing\n"
                },
                {
                  "kind": "span",
                  "text": "the pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the filter to be used for resizing when using this pattern.\n"
                },
                {
                  "kind": "span",
                  "text": "See Cairo_Filter for details on each filter.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that you might want to control filtering even when you do not\n"
                },
                {
                  "kind": "span",
                  "text": "have an explicit Cairo_Pattern object, (for example when using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Set_Source_Surface). In these cases, it is convenient to\n"
                },
                {
                  "kind": "span",
                  "text": "use Cairo_Get_Source to get access to the pattern that cairo\n"
                },
                {
                  "kind": "span",
                  "text": "creates implicitly. For example:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Set_Source_Surface (Cr, Image, X, Y);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Set_Filter (Cairo_Get_Source (Cr), Cairo_Filter_Nearest);\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 470,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Filter",
              "line": 470,
              "column": 51,
              "type": {
                "label": "Cairo.Pattern.Cairo_Filter",
                "docHref": "docs/cairo__pattern___spec.html#L111C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Matrix",
          "qualifier": "",
          "line": 410,
          "column": 14,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 410,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Matrix",
                      "href": "docs/cairo__pattern___spec.html#L410C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 411,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L411C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 412,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__pattern___spec.html#L412C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the pattern's transformation matrix to matrix. This matrix is\n"
                },
                {
                  "kind": "span",
                  "text": "a transformation from user space to pattern space.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "When a pattern is first created it always has the identity matrix\n"
                },
                {
                  "kind": "span",
                  "text": "for its transformation matrix, which means that pattern space is\n"
                },
                {
                  "kind": "span",
                  "text": "initially identical to user space.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Important: Please note that the direction of this transformation\n"
                },
                {
                  "kind": "span",
                  "text": "matrix is from user space to pattern space. This means that if you\n"
                },
                {
                  "kind": "span",
                  "text": "imagine the flow from a pattern to user space (and on to device\n"
                },
                {
                  "kind": "span",
                  "text": "space), then coordinates in that flow will be transformed by the\n"
                },
                {
                  "kind": "span",
                  "text": "inverse of the pattern matrix.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "For example, if you want to make a pattern appear twice as large as\n"
                },
                {
                  "kind": "span",
                  "text": "it does by default the correct code to use is:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo.Matrix.Init_Scale (Matrix, 0.5, 0.5);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Set_Matrix (Pattern, Matrix);\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Meanwhile, using values of 2.0 rather than 0.5 in the code above\n"
                },
                {
                  "kind": "span",
                  "text": "would cause the pattern to appear at half of its default size.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Also, please note the discussion of the user-space locking\n"
                },
                {
                  "kind": "span",
                  "text": "semantics of Cairo_Set_Source.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 411,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Matrix",
              "line": 412,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_User_Data",
          "qualifier": "",
          "line": 316,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 316,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_User_Data",
                      "href": "docs/cairo__pattern___spec.html#L316C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 317,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L317C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 318,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__pattern___spec.html#L318C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 319,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/cairo__pattern___spec.html#L319C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 320,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__pattern___spec.html#L320C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Destroy_Func",
                      "href": "docs/cairo___spec.html#L188C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of a Cairo_User_Data_Key to attach the user data to\n"
                },
                {
                  "kind": "span",
                  "text": "User_Data: the user data to attach to the Cairo_Pattern\n"
                },
                {
                  "kind": "span",
                  "text": "Destroy: a Cairo_Destroy_Func which will be called when the\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Context is destroyed or when new user data is attached using the\n"
                },
                {
                  "kind": "span",
                  "text": "same key.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Attach user data to pattern.  To remove user data from a surface,\n"
                },
                {
                  "kind": "span",
                  "text": "call this function with the key that was used to set it and Null_Address\n"
                },
                {
                  "kind": "span",
                  "text": "for data.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success or Cairo_Status_No_Memory if a\n"
                },
                {
                  "kind": "span",
                  "text": "slot could not be allocated for the user data.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 317,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 318,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User_Data",
              "line": 319,
              "column": 7,
              "type": {
                "label": "Address"
              },
              "description": [
              ]
            },
            {
              "label": "Destroy",
              "line": 320,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Destroy_Func",
                "docHref": "docs/cairo___spec.html#L188C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Status",
          "qualifier": "",
          "line": 292,
          "column": 13,
          "src": "srcs/cairo-pattern.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 292,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo__pattern___spec.html#L292C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo__pattern___spec.html#L292C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks whether an error has previously occurred for this\n"
                },
                {
                  "kind": "span",
                  "text": "pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success, Cairo_Status_No_Memory, or\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Pattern_Type_Mismatch.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 292,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};