GNATdoc.Documentation = {
  "label": "Cairo.Matrix",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Init",
          "qualifier": "",
          "line": 33,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 33,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init",
                      "href": "docs/cairo__matrix___spec.html#L33C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 34,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L34C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 35,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xx",
                      "href": "docs/cairo__matrix___spec.html#L35C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 36,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yx",
                      "href": "docs/cairo__matrix___spec.html#L36C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 37,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xy",
                      "href": "docs/cairo__matrix___spec.html#L37C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 38,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yy",
                      "href": "docs/cairo__matrix___spec.html#L38C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 39,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo__matrix___spec.html#L39C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 40,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo__matrix___spec.html#L40C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Xx: Xx component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Yx: Yx component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Xy: Xy component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Yy: Yy component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "X0: X translation component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Y0: Y translation component of the affine transformation\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets matrix to be the affine transformation given by\n"
                },
                {
                  "kind": "span",
                  "text": "Xx, Yx, Xy, Yy, X0, Y0. The transformation is given\n"
                },
                {
                  "kind": "span",
                  "text": "by:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "X_new = Xx * X + Xy * Y + X0;\n"
                },
                {
                  "kind": "span",
                  "text": "Y_new = Yx * X + Yy * Y + Y0;\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 34,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Xx",
              "line": 35,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yx",
              "line": 36,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Xy",
              "line": 37,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yy",
              "line": 38,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X0",
              "line": 39,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 40,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Init_Identity",
          "qualifier": "",
          "line": 56,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 56,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init_Identity",
                      "href": "docs/cairo__matrix___spec.html#L56C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L56C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Modifies matrix to be an identity transformation.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 56,
              "column": 29,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Init_Rotate",
          "qualifier": "",
          "line": 83,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 83,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init_Rotate",
                      "href": "docs/cairo__matrix___spec.html#L83C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L83C27"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radians",
                      "href": "docs/cairo__matrix___spec.html#L83C57"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Radians: angle of rotation, in Radians. The direction of rotation\n"
                },
                {
                  "kind": "span",
                  "text": "is defined such that positive angles rotate in the direction from\n"
                },
                {
                  "kind": "span",
                  "text": "the positive X axis toward the positive Y axis. With the default\n"
                },
                {
                  "kind": "span",
                  "text": "axis orientation of cairo, positive angles rotate in a clockwise\n"
                },
                {
                  "kind": "span",
                  "text": "direction.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initialized matrix to a transformation that rotates by radians.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 83,
              "column": 27,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Radians",
              "line": 83,
              "column": 57,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Init_Scale",
          "qualifier": "",
          "line": 72,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 72,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init_Scale",
                      "href": "docs/cairo__matrix___spec.html#L72C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 73,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L73C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 74,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Sx",
                      "href": "docs/cairo__matrix___spec.html#L74C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 75,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Sy",
                      "href": "docs/cairo__matrix___spec.html#L75C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Sx: scale factor in the X direction\n"
                },
                {
                  "kind": "span",
                  "text": "Sy: scale factor in the Y direction\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initializes matrix to a transformation that scales by Sx and Sy\n"
                },
                {
                  "kind": "span",
                  "text": "in the X and Y dimensions, respectively.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 73,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Sx",
              "line": 74,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Sy",
              "line": 75,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Init_Translate",
          "qualifier": "",
          "line": 61,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 61,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Init_Translate",
                      "href": "docs/cairo__matrix___spec.html#L61C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 62,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L62C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 63,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Tx",
                      "href": "docs/cairo__matrix___spec.html#L63C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 64,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ty",
                      "href": "docs/cairo__matrix___spec.html#L64C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Tx: amount to translate in the X direction\n"
                },
                {
                  "kind": "span",
                  "text": "Ty: amount to translate in the Y direction\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Initializes matrix to a transformation that translates by Tx and\n"
                },
                {
                  "kind": "span",
                  "text": "Ty in the X and Y dimensions, respectively.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 62,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Tx",
              "line": 63,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Ty",
              "line": 64,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Invert",
          "qualifier": "",
          "line": 130,
          "column": 13,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 130,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Invert",
                      "href": "docs/cairo__matrix___spec.html#L130C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L130C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Changes matrix to be the inverse of its original value. Not\n"
                },
                {
                  "kind": "span",
                  "text": "all transformation matrices have inverses; if the matrix\n"
                },
                {
                  "kind": "span",
                  "text": "collapses points together (it is \"degenerate\"),\n"
                },
                {
                  "kind": "span",
                  "text": "then it has no inverse and this function will fail.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns: If matrix has an inverse, modifies matrix to\n"
                },
                {
                  "kind": "span",
                  "text": "be the inverse matrix and returns Cairo_Status_Success. Otherwise,\n"
                },
                {
                  "kind": "span",
                  "text": "returns Cairo_Status_Invalid_Matrix.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 130,
              "column": 21,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Multiply",
          "qualifier": "",
          "line": 142,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 142,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Multiply",
                      "href": "docs/cairo__matrix___spec.html#L142C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 143,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Result",
                      "href": "docs/cairo__matrix___spec.html#L143C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 144,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "A",
                      "href": "docs/cairo__matrix___spec.html#L144C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 145,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "B",
                      "href": "docs/cairo__matrix___spec.html#L145C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Result: a Cairo_Matrix in which to store the Result\n"
                },
                {
                  "kind": "span",
                  "text": "A: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "B: a Cairo_Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Multiplies the affine transformations in a and b together\n"
                },
                {
                  "kind": "span",
                  "text": "and stores the result in result. The effect of the resulting\n"
                },
                {
                  "kind": "span",
                  "text": "transformation is to first apply the transformation in a to the\n"
                },
                {
                  "kind": "span",
                  "text": "coordinates and then apply the transformation in b to the\n"
                },
                {
                  "kind": "span",
                  "text": "coordinates.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "It is allowable for result to be identical to either a or b.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Result",
              "line": 143,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "A",
              "line": 144,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "B",
              "line": 145,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Rotate",
          "qualifier": "",
          "line": 118,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 118,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Rotate",
                      "href": "docs/cairo__matrix___spec.html#L118C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L118C22"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radians",
                      "href": "docs/cairo__matrix___spec.html#L118C52"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Radians: angle of rotation, in Radians. The direction of rotation\n"
                },
                {
                  "kind": "span",
                  "text": "is defined such that positive angles rotate in the direction from\n"
                },
                {
                  "kind": "span",
                  "text": "the positive X axis toward the positive Y axis. With the default\n"
                },
                {
                  "kind": "span",
                  "text": "axis orientation of cairo, positive angles rotate in a clockwise\n"
                },
                {
                  "kind": "span",
                  "text": "direction.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Applies rotation by radians to the transformation in matrix. The effect\n"
                },
                {
                  "kind": "span",
                  "text": "of the new transformation is to first rotate the coordinates by radians,\n"
                },
                {
                  "kind": "span",
                  "text": "then apply the original transformation to the coordinates.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 118,
              "column": 22,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Radians",
              "line": 118,
              "column": 52,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Scale",
          "qualifier": "",
          "line": 106,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Scale",
                      "href": "docs/cairo__matrix___spec.html#L106C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 107,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L107C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 108,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Sx",
                      "href": "docs/cairo__matrix___spec.html#L108C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 109,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Sy",
                      "href": "docs/cairo__matrix___spec.html#L109C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Sx: scale factor in the X direction\n"
                },
                {
                  "kind": "span",
                  "text": "Sy: scale factor in the Y direction\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Applies scaling by Sx, Sy to the transformation in matrix. The\n"
                },
                {
                  "kind": "span",
                  "text": "effect of the new transformation is to first scale the coordinates\n"
                },
                {
                  "kind": "span",
                  "text": "by Sx and Sy, then apply the original transformation to the coordinates.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 107,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Sx",
              "line": 108,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Sy",
              "line": 109,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Transform_Distance",
          "qualifier": "",
          "line": 158,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 158,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Transform_Distance",
                      "href": "docs/cairo__matrix___spec.html#L158C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 159,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L159C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 160,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dx",
                      "href": "docs/cairo__matrix___spec.html#L160C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 161,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dy",
                      "href": "docs/cairo__matrix___spec.html#L161C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Dx: X component of a distance vector. An in/out parameter\n"
                },
                {
                  "kind": "span",
                  "text": "Dy: Y component of a distance vector. An in/out parameter\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Transforms the distance vector (Dx,Dy) by matrix. This is\n"
                },
                {
                  "kind": "span",
                  "text": "similar to Cairo.Matrix.Transform_Point except that the translation\n"
                },
                {
                  "kind": "span",
                  "text": "components of the transformation are ignored. The calculation of\n"
                },
                {
                  "kind": "span",
                  "text": "the returned vector is as follows:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Dx2 = Dx1 * A + Dy1 * C;\n"
                },
                {
                  "kind": "span",
                  "text": "Dy2 = Dx1 * B + Dy1 * D;\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Affine transformations are position invariant, so the same vector\n"
                },
                {
                  "kind": "span",
                  "text": "always transforms to the same vector. If (X1,Y1) transforms\n"
                },
                {
                  "kind": "span",
                  "text": "to (X2,Y2) then (X1+Dx1,Y1+Dy1) will transform to\n"
                },
                {
                  "kind": "span",
                  "text": "(X1+Dx2,Y1+Dy2) for all values of X1 and X2.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 159,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Dx",
              "line": 160,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Dy",
              "line": 161,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Transform_Point",
          "qualifier": "",
          "line": 179,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 179,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Transform_Point",
                      "href": "docs/cairo__matrix___spec.html#L179C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 180,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L180C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 181,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo__matrix___spec.html#L181C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 182,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo__matrix___spec.html#L182C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "X: X position. An in/out parameter\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y position. An in/out parameter\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Transforms the point (X, Y) by matrix.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 180,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 181,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 182,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Translate",
          "qualifier": "",
          "line": 93,
          "column": 14,
          "src": "srcs/cairo-matrix.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 93,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Translate",
                      "href": "docs/cairo__matrix___spec.html#L93C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 94,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo__matrix___spec.html#L94C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 95,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Tx",
                      "href": "docs/cairo__matrix___spec.html#L95C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 96,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ty",
                      "href": "docs/cairo__matrix___spec.html#L96C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Matrix: a Cairo_Matrix\n"
                },
                {
                  "kind": "span",
                  "text": "Tx: amount to translate in the X direction\n"
                },
                {
                  "kind": "span",
                  "text": "Ty: amount to translate in the Y direction\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Applies a translation by Tx, Ty to the transformation in\n"
                },
                {
                  "kind": "span",
                  "text": "matrix. The effect of the new transformation is to first translate\n"
                },
                {
                  "kind": "span",
                  "text": "the coordinates by Tx and Ty, then apply the original transformation\n"
                },
                {
                  "kind": "span",
                  "text": "to the coordinates.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Matrix",
              "line": 94,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Tx",
              "line": 95,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Ty",
              "line": 96,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};