GNATdoc.Documentation = {
  "label": "Cairo.Font_Options",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Copy",
          "qualifier": "",
          "line": 42,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 42,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy",
                      "href": "docs/cairo__font_options___spec.html#L42C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 43,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Original",
                      "href": "docs/cairo__font_options___spec.html#L43C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 44,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Original: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Allocates a new font options object copying the option values from\n"
                },
                {
                  "kind": "span",
                  "text": "original.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a newly allocated Cairo_Font_Options. Free with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Destroy. If memory cannot be allocated, then a\n"
                },
                {
                  "kind": "span",
                  "text": "special error object is returned where all operations on the object do\n"
                },
                {
                  "kind": "span",
                  "text": "nothing. You can check for this with Cairo.Font_Options.Status.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Original",
              "line": 43,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create",
          "qualifier": "",
          "line": 33,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 33,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create",
                      "href": "docs/cairo__font_options___spec.html#L33C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Allocates a new font options object with all options initialized\n"
                },
                {
                  "kind": "span",
                  "text": "to default values.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a newly allocated Cairo_Font_Options. Free with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Destroy. If memory cannot be allocated, then a\n"
                },
                {
                  "kind": "span",
                  "text": "special error object is returned where all operations on the object do\n"
                },
                {
                  "kind": "span",
                  "text": "nothing. You can check for this with Cairo.Font_Options.Status.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Destroy",
          "qualifier": "",
          "line": 55,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 55,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__font_options___spec.html#L55C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L55C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Destroys a Cairo_Font_Options object created with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Create or Cairo.Font_Options.Copy.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 55,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Equal",
          "qualifier": "",
          "line": 80,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 80,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Equal",
                      "href": "docs/cairo__font_options___spec.html#L80C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 81,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L81C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 82,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Other",
                      "href": "docs/cairo__font_options___spec.html#L82C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 83,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Other: another Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Compares two font options objects for equality.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: True if all fields of the two font options objects match.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that this function will return False if either object is in\n"
                },
                {
                  "kind": "span",
                  "text": "error.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 81,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Other",
              "line": 82,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Antialias",
          "qualifier": "",
          "line": 115,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 115,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Antialias",
                      "href": "docs/cairo__font_options___spec.html#L115C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 116,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L116C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 117,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias",
                      "href": "docs/cairo___spec.html#L772C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the antialiasing mode for the font options object.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the antialiasing mode\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 116,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Hint_Metrics",
          "qualifier": "",
          "line": 178,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 178,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Hint_Metrics",
                      "href": "docs/cairo__font_options___spec.html#L178C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 179,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L179C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 180,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics",
                      "href": "docs/cairo___spec.html#L1999C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the metrics hinting mode for the font options object.\n"
                },
                {
                  "kind": "span",
                  "text": "See the documentation for Cairo_Hint_Metrics for full details.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the metrics hinting mode for the font options object\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 179,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Hint_Style",
          "qualifier": "",
          "line": 157,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 157,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Hint_Style",
                      "href": "docs/cairo__font_options___spec.html#L157C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 158,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L158C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 159,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style",
                      "href": "docs/cairo___spec.html#L1971C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the hint style for font outlines for the font options object.\n"
                },
                {
                  "kind": "span",
                  "text": "See the documentation for Cairo_Hint_Style for full details.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the hint style for the font options object\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 158,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Subpixel_Order",
          "qualifier": "",
          "line": 136,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 136,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Subpixel_Order",
                      "href": "docs/cairo__font_options___spec.html#L136C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 137,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L137C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 138,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order",
                      "href": "docs/cairo___spec.html#L1950C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the subpixel order for the font options object.\n"
                },
                {
                  "kind": "span",
                  "text": "See the documentation for Cairo_Subpixel_Order for full details.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the subpixel order for the font options object\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 137,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Hash",
          "qualifier": "",
          "line": 93,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 93,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Hash",
                      "href": "docs/cairo__font_options___spec.html#L93C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 94,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L94C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 95,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gulong",
                      "href": "docs/glib___spec.html#L54C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Compute a hash for the font options object; this value will\n"
                },
                {
                  "kind": "span",
                  "text": "be useful when storing an object containing a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "in a hash table.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the hash value for the font options object.\n"
                },
                {
                  "kind": "span",
                  "text": "The return value can be cast to a 32-bit type if a\n"
                },
                {
                  "kind": "span",
                  "text": "32-bit hash value is needed.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 94,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Merge",
          "qualifier": "",
          "line": 69,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 69,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Merge",
                      "href": "docs/cairo__font_options___spec.html#L69C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 70,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L70C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 71,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Other",
                      "href": "docs/cairo__font_options___spec.html#L71C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Other: anOther Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Merges non-default options from other into options, replacing\n"
                },
                {
                  "kind": "span",
                  "text": "existing values. This operation can be thought of as somewhat\n"
                },
                {
                  "kind": "span",
                  "text": "similar to compositing other onto options with the operation\n"
                },
                {
                  "kind": "span",
                  "text": "of Cairo_Operation_Over.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 70,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Other",
              "line": 71,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Antialias",
          "qualifier": "",
          "line": 106,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Antialias",
                      "href": "docs/cairo__font_options___spec.html#L106C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 107,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L107C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 108,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Antialias",
                      "href": "docs/cairo__font_options___spec.html#L108C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias",
                      "href": "docs/cairo___spec.html#L772C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Antialias: the new Antialiasing mode\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the antialiasing mode for the font options object. This\n"
                },
                {
                  "kind": "span",
                  "text": "specifies the type of antialiasing to do when rendering text.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 107,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Antialias",
              "line": 108,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Antialias",
                "docHref": "docs/cairo___spec.html#L772C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Hint_Metrics",
          "qualifier": "",
          "line": 167,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 167,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Hint_Metrics",
                      "href": "docs/cairo__font_options___spec.html#L167C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 168,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L168C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 169,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Hint_Metrics",
                      "href": "docs/cairo__font_options___spec.html#L169C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics",
                      "href": "docs/cairo___spec.html#L1999C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Hint_Metrics: the new metrics hinting mode\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the metrics hinting mode for the font options object. This\n"
                },
                {
                  "kind": "span",
                  "text": "controls whether metrics are quantized to integer values in\n"
                },
                {
                  "kind": "span",
                  "text": "device units.\n"
                },
                {
                  "kind": "span",
                  "text": "See the documentation for Cairo_Hint_Metrics for full details.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 168,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Hint_Metrics",
              "line": 169,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Hint_Metrics",
                "docHref": "docs/cairo___spec.html#L1999C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Hint_Style",
          "qualifier": "",
          "line": 146,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 146,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Hint_Style",
                      "href": "docs/cairo__font_options___spec.html#L146C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 147,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L147C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 148,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Hint_Style",
                      "href": "docs/cairo__font_options___spec.html#L148C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style",
                      "href": "docs/cairo___spec.html#L1971C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Hint_Style: the new hint style\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the hint style for font outlines for the font options object.\n"
                },
                {
                  "kind": "span",
                  "text": "This controls whether to fit font outlines to the pixel grid,\n"
                },
                {
                  "kind": "span",
                  "text": "and if so, whether to optimize for fidelity or contrast.\n"
                },
                {
                  "kind": "span",
                  "text": "See the documentation for Cairo_Hint_Style for full details.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 147,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Hint_Style",
              "line": 148,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Hint_Style",
                "docHref": "docs/cairo___spec.html#L1971C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_Subpixel_Order",
          "qualifier": "",
          "line": 124,
          "column": 14,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 124,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_Subpixel_Order",
                      "href": "docs/cairo__font_options___spec.html#L124C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 125,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L125C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 126,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Subpixel_Order",
                      "href": "docs/cairo__font_options___spec.html#L126C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order",
                      "href": "docs/cairo___spec.html#L1950C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                },
                {
                  "kind": "span",
                  "text": "Subpixel_Order: the new subpixel order\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Sets the subpixel order for the font options object. The subpixel\n"
                },
                {
                  "kind": "span",
                  "text": "order specifies the order of color elements within each pixel on\n"
                },
                {
                  "kind": "span",
                  "text": "the display device when rendering with an antialiasing mode of\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Antialias_Subpixel. See the documentation for\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Subpixel_Order for full details.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 125,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            },
            {
              "label": "Subpixel_Order",
              "line": 126,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Subpixel_Order",
                "docHref": "docs/cairo___spec.html#L1950C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Status",
          "qualifier": "",
          "line": 61,
          "column": 13,
          "src": "srcs/cairo-font_options.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 61,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo__font_options___spec.html#L61C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo__font_options___spec.html#L61C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks whether an error has previously occurred for this\n"
                },
                {
                  "kind": "span",
                  "text": "font options object\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success or Cairo_Status_No_Memory\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Options",
              "line": 61,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};