GNATdoc.Documentation = {
  "label": "Cairo.Font_Face",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Destroy",
          "qualifier": "",
          "line": 50,
          "column": 14,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 50,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__font_face___spec.html#L50C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L50C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Decreases the reference count on Font_Face by one. If the result\n"
                },
                {
                  "kind": "span",
                  "text": "is zero, then Font_Face and all associated resources are freed.\n"
                },
                {
                  "kind": "span",
                  "text": "See Cairo.Font_Face.Reference.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 50,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Reference_Count",
          "qualifier": "",
          "line": 57,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 57,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Reference_Count",
                      "href": "docs/cairo__font_face___spec.html#L57C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L57C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the current reference count of Font_Face.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current reference count of Font_Face.  If the\n"
                },
                {
                  "kind": "span",
                  "text": "object is a nil object, 0 will be returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 57,
              "column": 34,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Type",
          "qualifier": "",
          "line": 76,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 76,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Type",
                      "href": "docs/cairo__font_face___spec.html#L76C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L76C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type",
                      "href": "docs/cairo___spec.html#L2308C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a font face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the type of the backend used to create\n"
                },
                {
                  "kind": "span",
                  "text": "a font face. See Cairo_Font_Type for available types.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The type of Font_Face.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 76,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_User_Data",
          "qualifier": "",
          "line": 86,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 86,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_User_Data",
                      "href": "docs/cairo__font_face___spec.html#L86C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 87,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L87C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 88,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__font_face___spec.html#L88C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of the Cairo_User_Data_Key the user data was\n"
                },
                {
                  "kind": "span",
                  "text": "attached to\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return user data previously attached to Font_Face using the specified\n"
                },
                {
                  "kind": "span",
                  "text": "key.  If no user data has been attached with the given key this\n"
                },
                {
                  "kind": "span",
                  "text": "function returns System.Null_Address.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the user data previously attached or System.Null_Address.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 87,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 88,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Reference",
          "qualifier": "",
          "line": 37,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 37,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Reference",
                      "href": "docs/cairo__font_face___spec.html#L37C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L37C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face, (may be Null_Font_Face in which case this\n"
                },
                {
                  "kind": "span",
                  "text": "function does nothing).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Increases the reference count on Font_Face by one. This prevents\n"
                },
                {
                  "kind": "span",
                  "text": "Font_Face from being destroyed until a matching call to\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Destroy is made.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The number of references to a Cairo_Font_Face can be get using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Get_Reference_Count.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the referenced Cairo_Font_Face.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 37,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Set_User_Data",
          "qualifier": "",
          "line": 99,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 99,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Set_User_Data",
                      "href": "docs/cairo__font_face___spec.html#L99C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 100,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L100C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 101,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo__font_face___spec.html#L101C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "User_Data",
                      "href": "docs/cairo__font_face___spec.html#L102C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 103,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo__font_face___spec.html#L103C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Destroy_Func",
                      "href": "docs/cairo___spec.html#L188C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of a Cairo_User_Data_Key to attach the user data to\n"
                },
                {
                  "kind": "span",
                  "text": "User_Data: the user data to attach to the font face\n"
                },
                {
                  "kind": "span",
                  "text": "Destroy: a Cairo_Destroy_Func which will be called when the\n"
                },
                {
                  "kind": "span",
                  "text": "font face is destroyed or when new user data is attached using the\n"
                },
                {
                  "kind": "span",
                  "text": "same key.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Attach user data to Font_Face.  To remove user data from a font face,\n"
                },
                {
                  "kind": "span",
                  "text": "call this function with the key that was used to set it and\n"
                },
                {
                  "kind": "span",
                  "text": "System.Null_Address for data.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success or Cairo_Status_No_Memory if a\n"
                },
                {
                  "kind": "span",
                  "text": "slot could not be allocated for the user data.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 100,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 101,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "User_Data",
              "line": 102,
              "column": 7,
              "type": {
                "label": "Address"
              },
              "description": [
              ]
            },
            {
              "label": "Destroy",
              "line": 103,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Destroy_Func",
                "docHref": "docs/cairo___spec.html#L188C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Status",
          "qualifier": "",
          "line": 67,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 67,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo__font_face___spec.html#L67C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L67C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: a Cairo_Font_Face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Checks whether an error has previously occurred for this\n"
                },
                {
                  "kind": "span",
                  "text": "font face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: Cairo_Status_Success or another error such as\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_No_Memory.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 67,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Toy_Font_Face_Create",
          "qualifier": "",
          "line": 118,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 118,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Toy_Font_Face_Create",
                      "href": "docs/cairo__font_face___spec.html#L118C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 119,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Family",
                      "href": "docs/cairo__font_face___spec.html#L119C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada.Types.Chars_Ptr",
                      "href": "docs/gtkada__types___spec.html#L137C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 120,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Slant",
                      "href": "docs/cairo__font_face___spec.html#L120C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant",
                      "href": "docs/cairo___spec.html#L1937C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 121,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Weight",
                      "href": "docs/cairo__font_face___spec.html#L121C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Weight",
                      "href": "docs/cairo___spec.html#L1944C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 122,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Family: a font Family name, encoded in UTF-8\n"
                },
                {
                  "kind": "span",
                  "text": "Slant: the Slant for the font\n"
                },
                {
                  "kind": "span",
                  "text": "Weight: the Weight for the font\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a font face from a triplet of family, slant, and weight.\n"
                },
                {
                  "kind": "span",
                  "text": "These font faces are used in implementation of the the Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "\"toy\" font API.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If Family is the zero-length string \"\", the platform-specific default\n"
                },
                {
                  "kind": "span",
                  "text": "family is assumed.  The default family then can be queried using\n"
                },
                {
                  "kind": "span",
                  "text": "Toy_Font_Face_Get_Family.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Cairo_Select_Font_Face function uses this to create font faces.\n"
                },
                {
                  "kind": "span",
                  "text": "See that function for limitations of toy font faces.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a newly created Cairo_Font_Face. Free with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Destroy when you are done using it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Family",
              "line": 119,
              "column": 7,
              "type": {
                "label": "Gtkada.Types.Chars_Ptr",
                "docHref": "docs/gtkada__types___spec.html#L50C9"
              },
              "description": [
              ]
            },
            {
              "label": "Slant",
              "line": 120,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Slant",
                "docHref": "docs/cairo___spec.html#L1937C9"
              },
              "description": [
              ]
            },
            {
              "label": "Weight",
              "line": 121,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Weight",
                "docHref": "docs/cairo___spec.html#L1944C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Toy_Font_Face_Get_Family",
          "qualifier": "",
          "line": 143,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 143,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Toy_Font_Face_Get_Family",
                      "href": "docs/cairo__font_face___spec.html#L143C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 144,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L144C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 145,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gtkada.Types.Chars_Ptr",
                      "href": "docs/gtkada__types___spec.html#L137C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: A toy font face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the familly name of a toy font.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The family name.  This string is owned by the font face\n"
                },
                {
                  "kind": "span",
                  "text": "and remains valid as long as the font face is alive (referenced).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 144,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Toy_Font_Face_Get_Slant",
          "qualifier": "",
          "line": 155,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 155,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Toy_Font_Face_Get_Slant",
                      "href": "docs/cairo__font_face___spec.html#L155C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 156,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L156C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 157,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant",
                      "href": "docs/cairo___spec.html#L1937C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: A toy font face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the slant a toy font.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The slant value\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 156,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Toy_Font_Face_Get_Weight",
          "qualifier": "",
          "line": 166,
          "column": 13,
          "src": "srcs/cairo-font_face.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 166,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Toy_Font_Face_Get_Weight",
                      "href": "docs/cairo__font_face___spec.html#L166C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 167,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Face",
                      "href": "docs/cairo__font_face___spec.html#L167C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 168,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Weight",
                      "href": "docs/cairo___spec.html#L1944C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Font_Face: A toy font face\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the weight a toy font.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: The weight value\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Font_Face",
              "line": 167,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Face",
                "docHref": "docs/cairo___spec.html#L1777C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Subprograms"
    }
  ]
};