GNATdoc.Documentation = {
  "label": "Cairo",
  "qualifier": "",
  "summary": [
  ],
  "description": [
  ],
  "entities": [
    {
      "entities": [
        {
          "label": "Cairo_Content_Alpha",
          "qualifier": "",
          "line": 328,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 328,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content_Alpha"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "8192"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "CAIRO_CONTENT_ALPHA: The surface will hold alpha content only.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Content_Color",
          "qualifier": "",
          "line": 325,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 325,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content_Color"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "4096"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The surface will hold color content only.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Content_Color_Alpha",
          "qualifier": "",
          "line": 331,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 331,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content_Color_Alpha"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "12288"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "CAIRO_CONTENT_COLOR_ALPHA: The surface will hold color and alpha\n"
                },
                {
                  "kind": "span",
                  "text": "content.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Text_Cluster_Flag_Backward",
          "qualifier": "",
          "line": 1848,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1848,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Cluster_Flag_Backward"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Cluster_Flags"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The clusters in the cluster array map to glyphs in the glyph array from\n"
                },
                {
                  "kind": "span",
                  "text": "end to start.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "No_Dashes",
          "qualifier": "",
          "line": 928,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 928,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "No_Dashes"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dash_Array"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ".."
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "others"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "=>"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "0.0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Context",
          "qualifier": "",
          "line": 2737,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2737,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Context"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Font_Face",
          "qualifier": "",
          "line": 2741,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2741,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Font_Face"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Font_Options",
          "qualifier": "",
          "line": 2742,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2742,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Font_Options"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Pattern",
          "qualifier": "",
          "line": 2739,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2739,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Pattern"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Scaled_Font",
          "qualifier": "",
          "line": 2740,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2740,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Scaled_Font"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Scaled_Font"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Null_Surface",
          "qualifier": "",
          "line": 2738,
          "column": 4,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2738,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Null_Surface"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "constant"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Constants and variables"
    },
    {
      "entities": [
        {
          "label": "Cairo_Antialias",
          "qualifier": "",
          "line": 772,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 772,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias",
                      "href": "docs/cairo___spec.html#L772C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 773,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 774,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias_Default",
                      "href": "docs/cairo___spec.html#L774C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 775,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Use the default antialiasing for the subsystem and target device"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 776,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 777,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias_None",
                      "href": "docs/cairo___spec.html#L777C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 778,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Use a bilevel alpha mask"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 779,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 780,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias_Gray",
                      "href": "docs/cairo___spec.html#L780C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 781,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Perform single-color antialiasing (using shades of gray for black"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 782,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  text on a white background, for example)."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 783,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 784,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias_Subpixel",
                      "href": "docs/cairo___spec.html#L784C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 785,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Perform antialiasing by taking advantage of the order of subpixel"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 786,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  elements on devices such as LCD panels"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 787,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L772C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies the type of antialiasing to do when rendering text or shapes.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Antialias_Default",
              "line": 774,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Use the default antialiasing for the subsystem and target device\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Antialias_None",
              "line": 777,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Use a bilevel alpha mask\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Antialias_Gray",
              "line": 780,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Perform single-color antialiasing (using shades of gray for black\n"
                    },
                    {
                      "kind": "span",
                      "text": "text on a white background, for example).\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Antialias_Subpixel",
              "line": 784,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Perform antialiasing by taking advantage of the order of subpixel\n"
                    },
                    {
                      "kind": "span",
                      "text": "elements on devices such as LCD panels\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Content",
          "qualifier": "",
          "line": 316,
          "column": 12,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 316,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "subtype"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content",
                      "href": "docs/cairo___spec.html#L316C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_content is used to describe the content that a surface will\n"
                },
                {
                  "kind": "span",
                  "text": "contain, whether color information, alpha information (translucence\n"
                },
                {
                  "kind": "span",
                  "text": "vs. opacity), or both.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: The large values here are designed to keep Cairo_Content\n"
                },
                {
                  "kind": "span",
                  "text": "values distinct from Cairo_Format values so that the\n"
                },
                {
                  "kind": "span",
                  "text": "implementation can detect the error if users confuse the two types.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Context",
          "qualifier": "",
          "line": 77,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 77,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L77C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Context contains the current state of the rendering device,\n"
                },
                {
                  "kind": "span",
                  "text": "including coordinates of yet to be drawn shapes.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo contexts, as Cairo_Context objects are named, are central to\n"
                },
                {
                  "kind": "span",
                  "text": "cairo and all drawing with cairo is always done to a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "object.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Memory management of Cairo_Context is done with subprograms\n"
                },
                {
                  "kind": "span",
                  "text": "Reference and Destroy, see below.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Fill_Rule",
          "qualifier": "",
          "line": 815,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 815,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Fill_Rule",
                      "href": "docs/cairo___spec.html#L815C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 816,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Fill_Rule_Winding",
                      "href": "docs/cairo___spec.html#L816C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 817,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  If the path crosses the ray from left-to-right, counts +1. If the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 818,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  path crosses the ray from right to left, counts -1. (Left and right"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 819,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  are determined from the perspective of looking along the ray from"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 820,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the starting point). If the total count is non-zero, the point will"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 821,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  be filled."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 822,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 823,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Fill_Rule_Even_Odd",
                      "href": "docs/cairo___spec.html#L823C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 824,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Counts the total number of"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 825,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  intersections, without regard to the orientation of the contour. If"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 826,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the total number of intersections is odd, the point will be filled."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 827,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L815C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Fill_Rule is used to select how paths are filled. For both\n"
                },
                {
                  "kind": "span",
                  "text": "fill rules, whether or not a point is included in the fill is\n"
                },
                {
                  "kind": "span",
                  "text": "determined by taking a ray from that point to infinity and looking\n"
                },
                {
                  "kind": "span",
                  "text": "at intersections with the path. The ray can be in any direction,\n"
                },
                {
                  "kind": "span",
                  "text": "as long as it doesn't pass through the end point of a segment\n"
                },
                {
                  "kind": "span",
                  "text": "or have a tricky intersection such as intersecting tangent to the path.\n"
                },
                {
                  "kind": "span",
                  "text": "(Note that filling is not actually implemented in this way. This\n"
                },
                {
                  "kind": "span",
                  "text": "is just a description of the rule that is applied.)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default fill rule is Cairo_Fill_Rule_Winding.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Fill_Rule_Winding",
              "line": 816,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "If the path crosses the ray from left-to-right, counts +1. If the\n"
                    },
                    {
                      "kind": "span",
                      "text": "path crosses the ray from right to left, counts -1. (Left and right\n"
                    },
                    {
                      "kind": "span",
                      "text": "are determined from the perspective of looking along the ray from\n"
                    },
                    {
                      "kind": "span",
                      "text": "the starting point). If the total count is non-zero, the point will\n"
                    },
                    {
                      "kind": "span",
                      "text": "be filled.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Fill_Rule_Even_Odd",
              "line": 823,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Counts the total number of\n"
                    },
                    {
                      "kind": "span",
                      "text": "intersections, without regard to the orientation of the contour. If\n"
                    },
                    {
                      "kind": "span",
                      "text": "the total number of intersections is odd, the point will be filled.\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Font_Face",
          "qualifier": "",
          "line": 1777,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1777,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L1777C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Font_Face specifies all aspects of a font other\n"
                },
                {
                  "kind": "span",
                  "text": "than the size or font matrix (a font matrix is used to distort\n"
                },
                {
                  "kind": "span",
                  "text": "a font by sheering it or scaling it unequally in the two\n"
                },
                {
                  "kind": "span",
                  "text": "directions) . A font face can be set on a Cairo_Context by using\n"
                },
                {
                  "kind": "span",
                  "text": "Set_Font_Face; the size and font matrix are set with\n"
                },
                {
                  "kind": "span",
                  "text": "Set_Font_Size and Set_Font_Matrix.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There are various types of font faces, depending on the font backend\n"
                },
                {
                  "kind": "span",
                  "text": "they use. The type of a font face can be queried using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Get_Type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Memory management of Cairo_Font_Face is done with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Reference and Cairo.Font_Face.Destroy.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Cairo_glyph structure holds information about a single glyph when\n"
                },
                {
                  "kind": "span",
                  "text": "drawing or measuring text. A font is (in simple terms) a collection of\n"
                },
                {
                  "kind": "span",
                  "text": "shapes used to draw text. A glyph is one of these shapes. There can be\n"
                },
                {
                  "kind": "span",
                  "text": "multiple glyphs for a single character (alternates to be used in\n"
                },
                {
                  "kind": "span",
                  "text": "different contexts, for example), or a glyph can be a ligature of\n"
                },
                {
                  "kind": "span",
                  "text": "multiple characters. Cairo doesn't expose any way of converting input\n"
                },
                {
                  "kind": "span",
                  "text": "text into glyphs, so in order to use the Cairo interfaces that take\n"
                },
                {
                  "kind": "span",
                  "text": "arrays of glyphs, you must directly access the appropriate underlying\n"
                },
                {
                  "kind": "span",
                  "text": "font system.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that the offsets given by X and Y are not cumulative. When\n"
                },
                {
                  "kind": "span",
                  "text": "drawing or measuring text, each glyph is individually positioned\n"
                },
                {
                  "kind": "span",
                  "text": "with respect to the overall origin\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Font_Options",
          "qualifier": "",
          "line": 2017,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2017,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2017C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "An opaque structure holding all options that are used when\n"
                },
                {
                  "kind": "span",
                  "text": "rendering fonts.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Individual features of a Cairo_Font_Options can be set or\n"
                },
                {
                  "kind": "span",
                  "text": "accessed using functions named\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Set_\n"
                },
                {
                  "kind": "span",
                  "text": "<feature_Name> and\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Get_\n"
                },
                {
                  "kind": "span",
                  "text": "<feature_Name>, like\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Set_Antialias and\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Get_Antialias.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New features may be added to a Cairo_font_options in the\n"
                },
                {
                  "kind": "span",
                  "text": "future.  For this reason, Cairo.Font_Options.Copy,\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Equal, Cairo.Font_Options.Merge, and\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Options.Hash should be used to copy, check\n"
                },
                {
                  "kind": "span",
                  "text": "for equality, merge, or compute a hash value of\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Font_Options objects.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Font_Slant",
          "qualifier": "",
          "line": 1937,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1937,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant",
                      "href": "docs/cairo___spec.html#L1937C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1938,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                             "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant_Normal",
                      "href": "docs/cairo___spec.html#L1938C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1939,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                             "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant_Italic",
                      "href": "docs/cairo___spec.html#L1939C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1940,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                             "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Slant_Oblique",
                      "href": "docs/cairo___spec.html#L1940C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1937C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies variants of a font face based on their slant.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Font_Slant_Normal",
              "line": 1938,
              "column": 30,
              "description": [
              ]
            },
            {
              "label": "Cairo_Font_Slant_Italic",
              "line": 1939,
              "column": 30,
              "description": [
              ]
            },
            {
              "label": "Cairo_Font_Slant_Oblique",
              "line": 1940,
              "column": 30,
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Font_Type",
          "qualifier": "",
          "line": 2308,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2308,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type",
                      "href": "docs/cairo___spec.html#L2308C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2309,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type_Toy",
                      "href": "docs/cairo___spec.html#L2309C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2310,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The font was created using cairo's toy font api (Since: 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2311,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2312,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type_Ft",
                      "href": "docs/cairo___spec.html#L2312C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2313,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The font is of type FreeType"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2314,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2315,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type_Win32",
                      "href": "docs/cairo___spec.html#L2315C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2316,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The font is of type Win32"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2317,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2318,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type_Quartz",
                      "href": "docs/cairo___spec.html#L2318C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2319,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The font is of type Quartz (Since: 1.6)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2320,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2321,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Type_User",
                      "href": "docs/cairo___spec.html#L2321C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2322,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The font was create using cairo's user font api"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2323,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2308C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_font_type is used to describe the type of a given font\n"
                },
                {
                  "kind": "span",
                  "text": "face or scaled font. The font types are also known as \"font\n"
                },
                {
                  "kind": "span",
                  "text": "backends\" within Cairo.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type of a font face is determined by the function used to\n"
                },
                {
                  "kind": "span",
                  "text": "create it, which will generally be of the form\n"
                },
                {
                  "kind": "span",
                  "text": "<type>_Font_Face_Create. The font face type\n"
                },
                {
                  "kind": "span",
                  "text": "can be queried\n"
                },
                {
                  "kind": "span",
                  "text": "with Cairo.Font_Face.Get_Type\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The various Cairo_Font_Face functions can be used with a font face\n"
                },
                {
                  "kind": "span",
                  "text": "of any type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type of a scaled font is determined by the type of the font\n"
                },
                {
                  "kind": "span",
                  "text": "face passed to Cairo.Scaled_Font.Create. The scaled font type can\n"
                },
                {
                  "kind": "span",
                  "text": "be queried with Cairo.Scaled_Font.Get_Type\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The various Cairo_scaled_font functions can be used with scaled\n"
                },
                {
                  "kind": "span",
                  "text": "fonts of any type, but some font backends also provide\n"
                },
                {
                  "kind": "span",
                  "text": "type-specific functions that must only be called with a scaled font\n"
                },
                {
                  "kind": "span",
                  "text": "of the appropriate type. These functions have names that begin with\n"
                },
                {
                  "kind": "span",
                  "text": "<type>_Scaled_Font such as Ft_Scaled_Font_Lock_Face.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The behavior of calling a type-specific function with a scaled font\n"
                },
                {
                  "kind": "span",
                  "text": "of the wrong type is undefined.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Font_Type_Toy",
              "line": 2309,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The font was created using cairo's toy font api (Since: 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Font_Type_Ft",
              "line": 2312,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The font is of type FreeType\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Font_Type_Win32",
              "line": 2315,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The font is of type Win32\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Font_Type_Quartz",
              "line": 2318,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The font is of type Quartz (Since: 1.6)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Font_Type_User",
              "line": 2321,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The font was create using cairo's user font api\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Font_Weight",
          "qualifier": "",
          "line": 1944,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1944,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Weight",
                      "href": "docs/cairo___spec.html#L1944C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1945,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Weight_Normal",
                      "href": "docs/cairo___spec.html#L1945C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1946,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                              "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Weight_Bold",
                      "href": "docs/cairo___spec.html#L1946C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1944C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies variants of a font face based on their weight.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Font_Weight_Normal",
              "line": 1945,
              "column": 31,
              "description": [
              ]
            },
            {
              "label": "Cairo_Font_Weight_Bold",
              "line": 1946,
              "column": 31,
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Format",
          "qualifier": "",
          "line": 133,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 133,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Format",
                      "href": "docs/cairo___spec.html#L133C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 134,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_Invalid",
                      "href": "docs/cairo___spec.html#L134C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 135,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_ARGB32",
                      "href": "docs/cairo___spec.html#L135C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 136,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_RGB24",
                      "href": "docs/cairo___spec.html#L136C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 137,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_A8",
                      "href": "docs/cairo___spec.html#L137C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 138,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_A1",
                      "href": "docs/cairo___spec.html#L138C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 139,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_RGB16_565",
                      "href": "docs/cairo___spec.html#L139C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 140,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Format_RGB30",
                      "href": "docs/cairo___spec.html#L140C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L133C9"
                    }
                  ]
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Format_Invalid",
              "line": 134,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_ARGB32",
              "line": 135,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_RGB24",
              "line": 136,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_A8",
              "line": 137,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_A1",
              "line": 138,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_RGB16_565",
              "line": 139,
              "column": 7,
              "description": [
              ]
            },
            {
              "label": "Format_RGB30",
              "line": 140,
              "column": 7,
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Hint_Metrics",
          "qualifier": "",
          "line": 1999,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1999,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics",
                      "href": "docs/cairo___spec.html#L1999C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2000,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics_Default",
                      "href": "docs/cairo___spec.html#L2000C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2001,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Hint metrics in the default manner for the font backend and target"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2002,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  device"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2003,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2004,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics_Off",
                      "href": "docs/cairo___spec.html#L2004C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2005,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Do not hint font metrics"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2006,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 2007,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Metrics_On",
                      "href": "docs/cairo___spec.html#L2007C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2008,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Hint font metrics"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2009,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1999C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies whether to hint font metrics; hinting font metrics\n"
                },
                {
                  "kind": "span",
                  "text": "means quantizing them so that they are integer values in\n"
                },
                {
                  "kind": "span",
                  "text": "device space. Doing this improves the consistency of\n"
                },
                {
                  "kind": "span",
                  "text": "letter and line spacing, however it also means that text\n"
                },
                {
                  "kind": "span",
                  "text": "will be laid out differently at different zoom factors.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Hint_Metrics_Default",
              "line": 2000,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Hint metrics in the default manner for the font backend and target\n"
                    },
                    {
                      "kind": "span",
                      "text": "device\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Metrics_Off",
              "line": 2004,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Do not hint font metrics\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Metrics_On",
              "line": 2007,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Hint font metrics\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Hint_Style",
          "qualifier": "",
          "line": 1971,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1971,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style",
                      "href": "docs/cairo___spec.html#L1971C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1972,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style_Default",
                      "href": "docs/cairo___spec.html#L1972C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1973,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Use the default hint style for font backend and target device"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1974,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1975,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style_None",
                      "href": "docs/cairo___spec.html#L1975C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1976,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Do not hint outlines"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1977,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1978,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style_Slight",
                      "href": "docs/cairo___spec.html#L1978C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1979,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Hint outlines slightly to improve contrast while retaining good"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1980,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  fidelity to the original shapes."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1981,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1982,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style_Medium",
                      "href": "docs/cairo___spec.html#L1982C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1983,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Hint outlines with medium strength giving a compromise between"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1984,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  fidelity to the original shapes and contrast"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1985,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1986,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Hint_Style_Full",
                      "href": "docs/cairo___spec.html#L1986C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1987,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Hint outlines to maximize contrast"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1988,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1971C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies the type of hinting to do on font outlines. Hinting\n"
                },
                {
                  "kind": "span",
                  "text": "is the process of fitting outlines to the pixel grid in order\n"
                },
                {
                  "kind": "span",
                  "text": "to improve the appearance of the result. Since hinting outlines\n"
                },
                {
                  "kind": "span",
                  "text": "involves distorting them, it also reduces the faithfulness\n"
                },
                {
                  "kind": "span",
                  "text": "to the original outline shapes. Not all of the outline hinting\n"
                },
                {
                  "kind": "span",
                  "text": "styles are supported by all font backends.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Hint_Style_Default",
              "line": 1972,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Use the default hint style for font backend and target device\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Style_None",
              "line": 1975,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Do not hint outlines\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Style_Slight",
              "line": 1978,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Hint outlines slightly to improve contrast while retaining good\n"
                    },
                    {
                      "kind": "span",
                      "text": "fidelity to the original shapes.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Style_Medium",
              "line": 1982,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Hint outlines with medium strength giving a compromise between\n"
                    },
                    {
                      "kind": "span",
                      "text": "fidelity to the original shapes and contrast\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Hint_Style_Full",
              "line": 1986,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Hint outlines to maximize contrast\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Line_Cap",
          "qualifier": "",
          "line": 867,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 867,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Cap",
                      "href": "docs/cairo___spec.html#L867C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 868,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Cap_Butt",
                      "href": "docs/cairo___spec.html#L868C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 869,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  start(stop) the line exactly at the start(end) point"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 870,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 871,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Cap_Round",
                      "href": "docs/cairo___spec.html#L871C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 872,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  use a round ending, the center of the circle is the end point"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 873,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 874,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Cap_Square",
                      "href": "docs/cairo___spec.html#L874C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 875,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  use squared ending, the center of the square is the end point"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 876,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L867C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies how to render the endpoints of the path when stroking.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default line cap style is Cairo_Line_Cap_Butt.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Line_Cap_Butt",
              "line": 868,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "start(stop) the line exactly at the start(end) point\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Line_Cap_Round",
              "line": 871,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "use a round ending, the center of the circle is the end point\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Line_Cap_Square",
              "line": 874,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "use squared ending, the center of the square is the end point\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Line_Join",
          "qualifier": "",
          "line": 895,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 895,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Join",
                      "href": "docs/cairo___spec.html#L895C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 896,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Join_Miter",
                      "href": "docs/cairo___spec.html#L896C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 897,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  use a sharp (angled) corner, see Set_Miter_Limit"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 898,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 899,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Join_Round",
                      "href": "docs/cairo___spec.html#L899C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 900,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  use a rounded join, the center of the circle is the joint point"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 901,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 902,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Join_Bevel",
                      "href": "docs/cairo___spec.html#L902C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 903,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  use a cut-off join, the join is cut off at half the line width from"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 904,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the joint point"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 905,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L895C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies how to render the junction of two lines when stroking.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default line join style is Cairo_Line_Join_Miter.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Line_Join_Miter",
              "line": 896,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "use a sharp (angled) corner, see Set_Miter_Limit\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Line_Join_Round",
              "line": 899,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "use a rounded join, the center of the circle is the joint point\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Line_Join_Bevel",
              "line": 902,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "use a cut-off join, the join is cut off at half the line width from\n"
                    },
                    {
                      "kind": "span",
                      "text": "the joint point\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Operator",
          "qualifier": "",
          "line": 574,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 574,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator",
                      "href": "docs/cairo___spec.html#L574C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 575,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Clear",
                      "href": "docs/cairo___spec.html#L575C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 576,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  clear destination layer (bounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 577,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 578,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Source",
                      "href": "docs/cairo___spec.html#L578C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 579,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  replace destination layer (bounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 580,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 581,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Over",
                      "href": "docs/cairo___spec.html#L581C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 582,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  draw source layer on top of destination layer (bounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 583,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 584,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_In",
                      "href": "docs/cairo___spec.html#L584C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 585,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  draw source where there was destination content (unbounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 586,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 587,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Out",
                      "href": "docs/cairo___spec.html#L587C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 588,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  draw source where there was no destination content (unbounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 589,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 590,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Atop",
                      "href": "docs/cairo___spec.html#L590C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 591,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  draw source on top of destination content and only there"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 592,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 593,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Dest",
                      "href": "docs/cairo___spec.html#L593C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 594,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  ignore the source"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 595,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 596,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Dest_Over",
                      "href": "docs/cairo___spec.html#L596C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 597,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  draw destination on top of source"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 598,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 599,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Dest_In",
                      "href": "docs/cairo___spec.html#L599C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 600,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  leave destination only where there was source content (unbounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 601,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 602,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Dest_Out",
                      "href": "docs/cairo___spec.html#L602C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 603,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  leave destination only where there was no source content"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 604,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 605,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Dest_Atop",
                      "href": "docs/cairo___spec.html#L605C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 606,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  leave destination on top of source content and only there (unbounded)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 607,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 608,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Xor",
                      "href": "docs/cairo___spec.html#L608C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 609,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  source and destination are shown where there is only one of them"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 610,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 611,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Add",
                      "href": "docs/cairo___spec.html#L611C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 612,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  source and destination layers are accumulated"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 613,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 614,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator_Saturate",
                      "href": "docs/cairo___spec.html#L614C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 615,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  like over, but assuming source and dest are disjoint geometries"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 616,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L574C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_operator is used to set the compositing operator for all cairo\n"
                },
                {
                  "kind": "span",
                  "text": "drawing operations.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The default operator is Cairo_Operator_Over.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The operators marked as \"unbounded\" modify their destination even\n"
                },
                {
                  "kind": "span",
                  "text": "outside of the mask layer (that is, their effect is not bound by the\n"
                },
                {
                  "kind": "span",
                  "text": "mask layer). However, their effect can still be limited by way of\n"
                },
                {
                  "kind": "span",
                  "text": "clipping.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "To keep things simple, the operator descriptions here document the\n"
                },
                {
                  "kind": "span",
                  "text": "behavior for when both source and destination are either fully\n"
                },
                {
                  "kind": "span",
                  "text": "transparent or fully opaque. The actual implementation works for\n"
                },
                {
                  "kind": "span",
                  "text": "translucent layers too.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "For a more detailed explanation of the effects of each operator,\n"
                },
                {
                  "kind": "span",
                  "text": "including the mathematical definitions, see\n"
                },
                {
                  "kind": "span",
                  "text": "http://cairographics.org/operators/\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Operator_Clear",
              "line": 575,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "clear destination layer (bounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Source",
              "line": 578,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "replace destination layer (bounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Over",
              "line": 581,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "draw source layer on top of destination layer (bounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_In",
              "line": 584,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "draw source where there was destination content (unbounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Out",
              "line": 587,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "draw source where there was no destination content (unbounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Atop",
              "line": 590,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "draw source on top of destination content and only there\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Dest",
              "line": 593,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "ignore the source\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Dest_Over",
              "line": 596,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "draw destination on top of source\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Dest_In",
              "line": 599,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "leave destination only where there was source content (unbounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Dest_Out",
              "line": 602,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "leave destination only where there was no source content\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Dest_Atop",
              "line": 605,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "leave destination on top of source content and only there (unbounded)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Xor",
              "line": 608,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "source and destination are shown where there is only one of them\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Add",
              "line": 611,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "source and destination layers are accumulated\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Operator_Saturate",
              "line": 614,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "like over, but assuming source and dest are disjoint geometries\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Path_Data_Type",
          "qualifier": "",
          "line": 2529,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2529,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Data_Type",
                      "href": "docs/cairo___spec.html#L2529C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2530,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Move_To",
                      "href": "docs/cairo___spec.html#L2530C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A move-to operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2531,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Line_To",
                      "href": "docs/cairo___spec.html#L2531C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A line-to operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2532,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Curve_To",
                      "href": "docs/cairo___spec.html#L2532C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A curve-to operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2533,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Close_Path",
                      "href": "docs/cairo___spec.html#L2533C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  A close-path operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2534,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2529C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_path_data is used to describe the type of one portion\n"
                },
                {
                  "kind": "span",
                  "text": "of a path when represented as a Cairo_Path.\n"
                },
                {
                  "kind": "span",
                  "text": "See Cairo_Path_Data for details.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Path_Move_To",
              "line": 2530,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A move-to operation\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Path_Line_To",
              "line": 2531,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A line-to operation\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Path_Curve_To",
              "line": 2532,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A curve-to operation\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Path_Close_Path",
              "line": 2533,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "A close-path operation\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Pattern",
          "qualifier": "",
          "line": 172,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 172,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L172C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Pattern represents a source when drawing onto a\n"
                },
                {
                  "kind": "span",
                  "text": "surface. There are different subtypes of Cairo_Pattern,\n"
                },
                {
                  "kind": "span",
                  "text": "for different types of sources; for example,\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Create_Rgb creates a pattern for a solid\n"
                },
                {
                  "kind": "span",
                  "text": "opaque color.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Other than various Cairo.Pattern.Create_\n"
                },
                {
                  "kind": "span",
                  "text": "<type>\n"
                },
                {
                  "kind": "span",
                  "text": "functions, some of the pattern types can be implicitly created\n"
                },
                {
                  "kind": "span",
                  "text": "using various Set_Source_\n"
                },
                {
                  "kind": "span",
                  "text": "<type> functions; for example Set_Source_Rgb.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The type of a pattern can be queried with Cairo.Pattern.Get_Type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Memory management of Cairo_Pattern is done with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Reference and Cairo.Pattern.Destroy.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Rectangle_Array",
          "qualifier": "",
          "line": 1706,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1706,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_Array",
                      "href": "docs/cairo___spec.html#L1706C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "array"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Natural"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "of"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle",
                      "href": "docs/cairo___spec.html#L1691C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Scaled_Font",
          "qualifier": "",
          "line": 1764,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1764,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Scaled_Font",
                      "href": "docs/cairo___spec.html#L1764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Scaled_Font is a font scaled to a particular size and device\n"
                },
                {
                  "kind": "span",
                  "text": "resolution. A Cairo_Scaled_Font is most useful for low-level font\n"
                },
                {
                  "kind": "span",
                  "text": "usage where a library or application wants to cache a reference\n"
                },
                {
                  "kind": "span",
                  "text": "to a scaled font to speed up the computation of metrics.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There are various types of scaled fonts, depending on the font backend\n"
                },
                {
                  "kind": "span",
                  "text": "they use. The type of a scaled font can be queried using\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Scaled_Font.Get_Type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Memory management of Cairo_Scaled_Font is done with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Scaled_Font.Reference and Cairo.Scaled_Font.Destroy.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Status",
          "qualifier": "",
          "line": 216,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 216,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 217,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 218,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Success",
                      "href": "docs/cairo___spec.html#L218C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 219,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  no error has occurred"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 220,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 221,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_No_Memory",
                      "href": "docs/cairo___spec.html#L221C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 222,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  out of memory"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 223,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 224,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Restore",
                      "href": "docs/cairo___spec.html#L224C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 225,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Cairo_Restore called without matching Cairo_Save"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 226,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 227,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Pop_Group",
                      "href": "docs/cairo___spec.html#L227C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 228,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  no saved group to pop"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 229,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 230,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_No_Current_Point",
                      "href": "docs/cairo___spec.html#L230C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 231,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  no current point defined"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 232,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 233,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Matrix",
                      "href": "docs/cairo___spec.html#L233C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 234,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid matrix (not invertible)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 235,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 236,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Status",
                      "href": "docs/cairo___spec.html#L236C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 237,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Cairo_status"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 238,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 239,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Null_Pointer",
                      "href": "docs/cairo___spec.html#L239C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 240,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  NULL pointer"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 241,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 242,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_String",
                      "href": "docs/cairo___spec.html#L242C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 243,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  input string not valid UTF-8"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 244,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 245,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Path_Data",
                      "href": "docs/cairo___spec.html#L245C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 246,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  input path data not valid"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 247,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 248,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Read_Error",
                      "href": "docs/cairo___spec.html#L248C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 249,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  error while reading from input stream"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 250,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 251,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Write_Error",
                      "href": "docs/cairo___spec.html#L251C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 252,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  error while writing to output stream"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 253,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 254,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Surface_Finished",
                      "href": "docs/cairo___spec.html#L254C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 255,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  target surface has been finished"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 256,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 257,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Surface_Type_Mismatch",
                      "href": "docs/cairo___spec.html#L257C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 258,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the surface type is not appropriate for the operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 259,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 260,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Pattern_Type_Mismatch",
                      "href": "docs/cairo___spec.html#L260C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 261,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the pattern type is not appropriate for the operation"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 262,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 263,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Content",
                      "href": "docs/cairo___spec.html#L263C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 264,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Cairo_content"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 265,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 266,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Format",
                      "href": "docs/cairo___spec.html#L266C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 267,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Cairo_format"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 268,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 269,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Visual",
                      "href": "docs/cairo___spec.html#L269C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 270,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Visual*"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 271,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 272,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_File_Not_Found",
                      "href": "docs/cairo___spec.html#L272C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 273,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  file not found"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 274,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 275,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Dash",
                      "href": "docs/cairo___spec.html#L275C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 276,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for a dash setting"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 277,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 278,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Dsc_Comment",
                      "href": "docs/cairo___spec.html#L278C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 279,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for a DSC comment (Since 1.2)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 280,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 281,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Index",
                      "href": "docs/cairo___spec.html#L281C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 282,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid index passed to getter (Since 1.4)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 283,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 284,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Clip_Not_Representable",
                      "href": "docs/cairo___spec.html#L284C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 285,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  clip region not representable in desired format (Since 1.4)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 286,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 287,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Temp_File_Error",
                      "href": "docs/cairo___spec.html#L287C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 288,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  error creating or writing to a temporary file (Since 1.6)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 289,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 290,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Stride",
                      "href": "docs/cairo___spec.html#L290C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 291,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for stride (Since 1.6)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 292,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 293,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Font_Type_Mismatch",
                      "href": "docs/cairo___spec.html#L293C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 294,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the font type is not appropriate for the operation (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 295,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 296,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_User_Font_Immutable",
                      "href": "docs/cairo___spec.html#L296C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 297,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the user-font is immutable (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 298,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 299,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_User_Font_Error",
                      "href": "docs/cairo___spec.html#L299C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 300,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  error occurred in a user-font callback function (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 301,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 302,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Negative_Count",
                      "href": "docs/cairo___spec.html#L302C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 303,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  negative number used where it is not allowed (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 304,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 305,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Clusters",
                      "href": "docs/cairo___spec.html#L305C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 306,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  input clusters do not represent the accompanying text and glyph"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 307,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  array (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 308,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 309,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Slant",
                      "href": "docs/cairo___spec.html#L309C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 310,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Cairo_Font_Slant (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 311,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 312,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status_Invalid_Weight",
                      "href": "docs/cairo___spec.html#L312C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 313,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  invalid value for an input Cairo_Font_Weight (Since 1.8)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 314,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L216C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Status is used to indicate errors that can occur when\n"
                },
                {
                  "kind": "span",
                  "text": "using Cairo. In some cases it is returned directly by functions.\n"
                },
                {
                  "kind": "span",
                  "text": "but when using Cairo_T, the last error, if any, is stored in\n"
                },
                {
                  "kind": "span",
                  "text": "the context and can be retrieved with Cairo_Status.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "New entries may be added in future versions.  Use\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_To_String\n"
                },
                {
                  "kind": "span",
                  "text": "to get a human-readable representation of an error message.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Status_Success",
              "line": 218,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "no error has occurred\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_No_Memory",
              "line": 221,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "out of memory\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Restore",
              "line": 224,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Restore called without matching Cairo_Save\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Pop_Group",
              "line": 227,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "no saved group to pop\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_No_Current_Point",
              "line": 230,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "no current point defined\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Matrix",
              "line": 233,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid matrix (not invertible)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Status",
              "line": 236,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Cairo_status\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Null_Pointer",
              "line": 239,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "NULL pointer\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_String",
              "line": 242,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "input string not valid UTF-8\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Path_Data",
              "line": 245,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "input path data not valid\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Read_Error",
              "line": 248,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "error while reading from input stream\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Write_Error",
              "line": 251,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "error while writing to output stream\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Surface_Finished",
              "line": 254,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "target surface has been finished\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Surface_Type_Mismatch",
              "line": 257,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "the surface type is not appropriate for the operation\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Pattern_Type_Mismatch",
              "line": 260,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "the pattern type is not appropriate for the operation\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Content",
              "line": 263,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Cairo_content\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Format",
              "line": 266,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Cairo_format\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Visual",
              "line": 269,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Visual*\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_File_Not_Found",
              "line": 272,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "file not found\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Dash",
              "line": 275,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for a dash setting\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Dsc_Comment",
              "line": 278,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for a DSC comment (Since 1.2)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Index",
              "line": 281,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid index passed to getter (Since 1.4)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Clip_Not_Representable",
              "line": 284,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "clip region not representable in desired format (Since 1.4)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Temp_File_Error",
              "line": 287,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "error creating or writing to a temporary file (Since 1.6)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Stride",
              "line": 290,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for stride (Since 1.6)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Font_Type_Mismatch",
              "line": 293,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "the font type is not appropriate for the operation (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_User_Font_Immutable",
              "line": 296,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "the user-font is immutable (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_User_Font_Error",
              "line": 299,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "error occurred in a user-font callback function (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Negative_Count",
              "line": 302,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "negative number used where it is not allowed (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Clusters",
              "line": 305,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "input clusters do not represent the accompanying text and glyph\n"
                    },
                    {
                      "kind": "span",
                      "text": "array (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Slant",
              "line": 309,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Cairo_Font_Slant (Since 1.8)\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Status_Invalid_Weight",
              "line": 312,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "invalid value for an input Cairo_Font_Weight (Since 1.8)\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Subpixel_Order",
          "qualifier": "",
          "line": 1950,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1950,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order",
                      "href": "docs/cairo___spec.html#L1950C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1951,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order_Default",
                      "href": "docs/cairo___spec.html#L1951C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1952,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Use the default subpixel order for the target device"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1953,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1954,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order_Rgb",
                      "href": "docs/cairo___spec.html#L1954C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1955,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Subpixel elements are arranged horizontally with red at the left"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1956,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1957,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order_Bgr",
                      "href": "docs/cairo___spec.html#L1957C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1958,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Subpixel elements are arranged horizontally with blue at the left"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1959,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1960,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order_Vrgb",
                      "href": "docs/cairo___spec.html#L1960C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1961,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Subpixel elements are arranged vertically with red at the top"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1962,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1963,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Subpixel_Order_Vbgr",
                      "href": "docs/cairo___spec.html#L1963C7"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1964,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Subpixel elements are arranged vertically with blue at the top"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1965,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1950C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The subpixel order specifies the order of color elements within\n"
                },
                {
                  "kind": "span",
                  "text": "each pixel on the display device when rendering with an\n"
                },
                {
                  "kind": "span",
                  "text": "antialiasing mode of CAIRO_ANTIALIAS_SUBPIXEL.\n"
                }
              ]
            }
          ],
          "literals": [
            {
              "label": "Cairo_Subpixel_Order_Default",
              "line": 1951,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Use the default subpixel order for the target device\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Subpixel_Order_Rgb",
              "line": 1954,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Subpixel elements are arranged horizontally with red at the left\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Subpixel_Order_Bgr",
              "line": 1957,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Subpixel elements are arranged horizontally with blue at the left\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Subpixel_Order_Vrgb",
              "line": 1960,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Subpixel elements are arranged vertically with red at the top\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Cairo_Subpixel_Order_Vbgr",
              "line": 1963,
              "column": 7,
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Subpixel elements are arranged vertically with blue at the top\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Surface",
          "qualifier": "",
          "line": 92,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 92,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L92C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "private"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Surface represents an image, either as the destination\n"
                },
                {
                  "kind": "span",
                  "text": "of a drawing operation or as source when drawing onto another\n"
                },
                {
                  "kind": "span",
                  "text": "surface.  To draw to a Cairo_Surface, create a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "with the surface as the target, using Create.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "There are different subtypes of Cairo_Surface for\n"
                },
                {
                  "kind": "span",
                  "text": "different drawing backends; for example, Cairo.Image_Surface.Create\n"
                },
                {
                  "kind": "span",
                  "text": "creates a bitmap image in memory.\n"
                },
                {
                  "kind": "span",
                  "text": "The type of a surface can be queried with Cairo.Surface.Get_Type.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Memory management of Cairo_Surface is done with\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Reference and Cairo.Surface.Destroy.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Text_Cluster_Flags",
          "qualifier": "",
          "line": 1843,
          "column": 12,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1843,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "subtype"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Cluster_Flags",
                      "href": "docs/cairo___spec.html#L1843C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifies properties of a text cluster mapping.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Color_Range",
          "qualifier": "",
          "line": 684,
          "column": 12,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 684,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "subtype"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Color_Range",
                      "href": "docs/cairo___spec.html#L684C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "range"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "0.0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ".."
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "1.0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Dash_Array",
          "qualifier": "",
          "line": 926,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 926,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dash_Array",
                      "href": "docs/cairo___spec.html#L926C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "array"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Natural"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "range"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "<>"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "of"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Path_Data_Array",
          "qualifier": "",
          "line": 2624,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2624,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Data_Array",
                      "href": "docs/cairo___spec.html#L2624C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "array"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Natural"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "of"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Data",
                      "href": "docs/cairo___spec.html#L2552C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Simple types"
    },
    {
      "entities": [
        {
          "label": "Cairo_Destroy_Func",
          "qualifier": "",
          "line": 188,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 188,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "                                     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Arg1",
                      "href": "docs/cairo___spec.html#L188C49"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Data: The Data element being destroyed.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_destroy_func the type of function which is called when a\n"
                },
                {
                  "kind": "span",
                  "text": "data element is destroyed. It is passed the pointer to the data\n"
                },
                {
                  "kind": "span",
                  "text": "element and should free any memory and resources allocated for it.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Matrix_Access",
          "qualifier": "",
          "line": 129,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 129,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix_Access",
                      "href": "docs/cairo___spec.html#L129C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Path_Access",
          "qualifier": "",
          "line": 2636,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2636,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Access",
                      "href": "docs/cairo___spec.html#L2636C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path",
                      "href": "docs/cairo___spec.html#L2627C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Status: the current error Status\n"
                },
                {
                  "kind": "span",
                  "text": "Data: the elements in the path\n"
                },
                {
                  "kind": "span",
                  "text": "Num_Data: the number of elements in the data array\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A data structure for holding a path. This data structure serves as the\n"
                },
                {
                  "kind": "span",
                  "text": "return value for Copy_Path and Copy_Path_Flat as well the input value\n"
                },
                {
                  "kind": "span",
                  "text": "for Append_Path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Cairo_Path_Data for hints on how to iterate over the\n"
                },
                {
                  "kind": "span",
                  "text": "actual data within the path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The num_data member gives the number of elements in the data\n"
                },
                {
                  "kind": "span",
                  "text": "array. This number is larger than the number of independent path\n"
                },
                {
                  "kind": "span",
                  "text": "portions (defined in Cairo_Path_Data_Type), since the data\n"
                },
                {
                  "kind": "span",
                  "text": "includes both headers and coordinates for each portion.\n"
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Rectangle_Array_Access",
          "qualifier": "",
          "line": 1707,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1707,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_Array_Access",
                      "href": "docs/cairo___spec.html#L1707C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_Array",
                      "href": "docs/cairo___spec.html#L1706C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Rectangle_List_Access",
          "qualifier": "",
          "line": 1728,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1728,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_List_Access",
                      "href": "docs/cairo___spec.html#L1728C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_List",
                      "href": "docs/cairo___spec.html#L1709C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Dash_Array_Access",
          "qualifier": "",
          "line": 2477,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2477,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dash_Array_Access",
                      "href": "docs/cairo___spec.html#L2477C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dash_Array",
                      "href": "docs/cairo___spec.html#L926C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Path_Data_Array_Access",
          "qualifier": "",
          "line": 2625,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2625,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Data_Array_Access",
                      "href": "docs/cairo___spec.html#L2625C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "all"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Data_Array",
                      "href": "docs/cairo___spec.html#L2624C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ],
      "label": "Access types"
    },
    {
      "entities": [
        {
          "label": "Cairo_Font_Extents",
          "qualifier": "",
          "line": 1888,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1888,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Extents",
                      "href": "docs/cairo___spec.html#L1888C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1889,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Ascent",
                      "href": "docs/cairo___spec.html#L1889C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1890,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The distance that the font extends above the baseline."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1891,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Note that this is not always exactly equal to the maximum"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1892,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  of the extents of all the glyphs in the font, but rather"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1893,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  is picked to express the font designer's intent as to"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1894,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  how the font should align with elements above it."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1895,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1896,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Descent",
                      "href": "docs/cairo___spec.html#L1896C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "       "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1897,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The distance that the font extends below the baseline."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1898,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  This value is positive for typical fonts that include"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1899,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  portions below the baseline. Note that this is not always"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1900,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  exactly equal to the maximum of the extents of all the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1901,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  glyphs in the font, but rather is picked to express the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1902,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  font designer's intent as to how the the font should"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1903,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  align with elements below it."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1904,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1905,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo___spec.html#L1905C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1906,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The recommended vertical distance between baselines when"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1907,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  setting consecutive lines of text with the font. This"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1908,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  is greater than ascent+descent by a"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1909,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  quantity known as the line spacing or external leading. When space is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1910,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  at a premium, most fonts can be set with only a distance of"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1911,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  ascent+descent between lines."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1912,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1913,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Max_X_Advance",
                      "href": "docs/cairo___spec.html#L1913C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1914,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The maximum distance in the X direction that"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1915,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the the origin is advanced for any glyph in the font."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1916,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1917,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Max_Y_Advance",
                      "href": "docs/cairo___spec.html#L1917C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1918,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The maximum distance in the Y direction that"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1919,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the the origin is advanced for any glyph in the font."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1920,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  this will be zero for normal fonts used for horizontal"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1921,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  writing. (The scripts of East Asia are sometimes written"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1922,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  vertically.)"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1923,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1888C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Cairo_font_extents structure stores metric information for\n"
                },
                {
                  "kind": "span",
                  "text": "a font. Values are given in the current user-space coordinate\n"
                },
                {
                  "kind": "span",
                  "text": "system.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Because font metrics are in user-space coordinates, they are\n"
                },
                {
                  "kind": "span",
                  "text": "mostly, but not entirely, independent of the current transformation\n"
                },
                {
                  "kind": "span",
                  "text": "matrix. If you call Scale (Cr, 2.0, 2.0), text will be drawn twice as\n"
                },
                {
                  "kind": "span",
                  "text": "big, but the reported text extents will not be doubled. They will\n"
                },
                {
                  "kind": "span",
                  "text": "change slightly due to hinting (so you can't assume that metrics are\n"
                },
                {
                  "kind": "span",
                  "text": "independent of the transformation matrix), but otherwise will remain\n"
                },
                {
                  "kind": "span",
                  "text": "unchanged.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Ascent",
              "line": 1889,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The distance that the font extends above the baseline.\n"
                    },
                    {
                      "kind": "span",
                      "text": "Note that this is not always exactly equal to the maximum\n"
                    },
                    {
                      "kind": "span",
                      "text": "of the extents of all the glyphs in the font, but rather\n"
                    },
                    {
                      "kind": "span",
                      "text": "is picked to express the font designer's intent as to\n"
                    },
                    {
                      "kind": "span",
                      "text": "how the font should align with elements above it.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Descent",
              "line": 1896,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The distance that the font extends below the baseline.\n"
                    },
                    {
                      "kind": "span",
                      "text": "This value is positive for typical fonts that include\n"
                    },
                    {
                      "kind": "span",
                      "text": "portions below the baseline. Note that this is not always\n"
                    },
                    {
                      "kind": "span",
                      "text": "exactly equal to the maximum of the extents of all the\n"
                    },
                    {
                      "kind": "span",
                      "text": "glyphs in the font, but rather is picked to express the\n"
                    },
                    {
                      "kind": "span",
                      "text": "font designer's intent as to how the the font should\n"
                    },
                    {
                      "kind": "span",
                      "text": "align with elements below it.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Height",
              "line": 1905,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The recommended vertical distance between baselines when\n"
                    },
                    {
                      "kind": "span",
                      "text": "setting consecutive lines of text with the font. This\n"
                    },
                    {
                      "kind": "span",
                      "text": "is greater than ascent+descent by a\n"
                    },
                    {
                      "kind": "span",
                      "text": "quantity known as the line spacing or external leading. When space is\n"
                    },
                    {
                      "kind": "span",
                      "text": "at a premium, most fonts can be set with only a distance of\n"
                    },
                    {
                      "kind": "span",
                      "text": "ascent+descent between lines.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Max_X_Advance",
              "line": 1913,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The maximum distance in the X direction that\n"
                    },
                    {
                      "kind": "span",
                      "text": "the the origin is advanced for any glyph in the font.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Max_Y_Advance",
              "line": 1917,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The maximum distance in the Y direction that\n"
                    },
                    {
                      "kind": "span",
                      "text": "the the origin is advanced for any glyph in the font.\n"
                    },
                    {
                      "kind": "span",
                      "text": "this will be zero for normal fonts used for horizontal\n"
                    },
                    {
                      "kind": "span",
                      "text": "writing. (The scripts of East Asia are sometimes written\n"
                    },
                    {
                      "kind": "span",
                      "text": "vertically.)\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Glyph",
          "qualifier": "",
          "line": 1805,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1805,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Glyph",
                      "href": "docs/cairo___spec.html#L1805C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1806,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Index",
                      "href": "docs/cairo___spec.html#L1806C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gulong",
                      "href": "docs/glib___spec.html#L54C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1807,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Glyph Index in the font. The exact interpretation of the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1808,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  glyph index depends on the font technology being used."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1809,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1810,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1810C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1811,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The offset in the X direction between the origin used for"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1812,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  drawing or measuring the string and the origin of this glyph."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1813,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1814,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1814C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1815,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The offset in the Y direction between the origin used for drawing or"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1816,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  measuring the string and the origin of this glyph."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1817,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1805C9"
                    }
                  ]
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Index",
              "line": 1806,
              "column": 7,
              "type": {
                "label": "Glib.Gulong",
                "docHref": "docs/glib___spec.html#L54C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Glyph Index in the font. The exact interpretation of the\n"
                    },
                    {
                      "kind": "span",
                      "text": "glyph index depends on the font technology being used.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "X",
              "line": 1810,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The offset in the X direction between the origin used for\n"
                    },
                    {
                      "kind": "span",
                      "text": "drawing or measuring the string and the origin of this glyph.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Y",
              "line": 1814,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The offset in the Y direction between the origin used for drawing or\n"
                    },
                    {
                      "kind": "span",
                      "text": "measuring the string and the origin of this glyph.\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Matrix",
          "qualifier": "",
          "line": 106,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 106,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 107,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xx",
                      "href": "docs/cairo___spec.html#L107C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 108,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yx",
                      "href": "docs/cairo___spec.html#L108C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 109,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xy",
                      "href": "docs/cairo___spec.html#L109C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 110,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yy",
                      "href": "docs/cairo___spec.html#L110C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 111,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo___spec.html#L111C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 112,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo___spec.html#L112C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 113,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L106C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Xx: Xx component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Yx: Yx component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Xy: Xy component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Yy: Yy component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "X0: X translation component of the affine transformation\n"
                },
                {
                  "kind": "span",
                  "text": "Y0: Y translation component of the affine transformation\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Cairo_Matrix holds an affine transformation, such as a scale,\n"
                },
                {
                  "kind": "span",
                  "text": "rotation, shear, or a combination of those. The transformation of\n"
                },
                {
                  "kind": "span",
                  "text": "a point (X, Y) is given by:\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "X_New = Xx * X + Xy * Y + X0;"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Y_New = Yx * X + Yy * Y + Y0;"
                    }
                  ]
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Xx",
              "line": 107,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yx",
              "line": 108,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Xy",
              "line": 109,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yy",
              "line": 110,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X0",
              "line": 111,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 112,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Path",
          "qualifier": "",
          "line": 2627,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2627,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path",
                      "href": "docs/cairo___spec.html#L2627C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2628,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo___spec.html#L2628C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2629,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Data",
                      "href": "docs/cairo___spec.html#L2629C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Data_Array_Access",
                      "href": "docs/cairo___spec.html#L2625C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2630,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Warning: for efficiency reasons, Data is a direct mapping to the C"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2631,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  structure. Therefore, there is no bounds checking on this array,"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2632,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the user needs to make sure only to access data between indexes"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2633,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  0 and Num_Data-1."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2634,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Num_Data",
                      "href": "docs/cairo___spec.html#L2634C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2635,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2627C9"
                    }
                  ]
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Status",
              "line": 2628,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Status",
                "docHref": "docs/cairo___spec.html#L216C9"
              },
              "description": [
              ]
            },
            {
              "label": "Data",
              "line": 2629,
              "column": 7,
              "type": {
                "label": "Cairo.Path_Data_Array_Access",
                "docHref": "docs/cairo___spec.html#L2625C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Warning: for efficiency reasons, Data is a direct mapping to the C\n"
                    },
                    {
                      "kind": "span",
                      "text": "structure. Therefore, there is no bounds checking on this array,\n"
                    },
                    {
                      "kind": "span",
                      "text": "the user needs to make sure only to access data between indexes\n"
                    },
                    {
                      "kind": "span",
                      "text": "0 and Num_Data-1.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Num_Data",
              "line": 2634,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Path_Data",
          "qualifier": "",
          "line": 2552,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2552,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Data",
                      "href": "docs/cairo___spec.html#L2552C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Discr",
                      "href": "docs/cairo___spec.html#L2552C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":="
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2553,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "case"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Discr"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2554,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "when"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "number",
                      "text": "0"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "=>"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2555,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Header",
                      "href": "docs/cairo___spec.html#L2555C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Header_Type",
                      "href": "docs/cairo___spec.html#L2540C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2556,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "when"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "others"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "=>"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2557,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "            "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Point",
                      "href": "docs/cairo___spec.html#L2557C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Point_Type",
                      "href": "docs/cairo___spec.html#L2546C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2558,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "case"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2559,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2552C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_path_data is used to represent the path data inside a\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The data structure is designed to try to balance the demands of\n"
                },
                {
                  "kind": "span",
                  "text": "efficiency and ease-of-use. A path is represented as an array of\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Path_Data, which is a union of headers and points.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Each portion of the path is represented by one or more elements in\n"
                },
                {
                  "kind": "span",
                  "text": "the array, (one header followed by 0 or more points). The length\n"
                },
                {
                  "kind": "span",
                  "text": "value of the header is the number of array elements for the current\n"
                },
                {
                  "kind": "span",
                  "text": "portion including the header, (ie. length == 1 +  of points), and\n"
                },
                {
                  "kind": "span",
                  "text": "where the number of points for each element type is as follows:\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Path_Move_To:     1 point"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Path_Line_To:     1 point"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Path_Curve_To:    3 points"
                    }
                  ]
                },
                {
                  "number": 4,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo_Path_Close_Path:  0 points"
                    }
                  ]
                },
                {
                  "number": 5,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The semantics and ordering of the coordinate values are consistent\n"
                },
                {
                  "kind": "span",
                  "text": "with Move_To, Line_To, Curve_To, and Close_Path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Here is sample code for iterating through a Cairo_Path:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "declare\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "J    : Gint;"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Path : Cairo_Path;"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Data : Cairo_Path_Data;"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "begin\n"
                },
                {
                  "kind": "span",
                  "text": "Path = Copy_Path (Cr);\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "J := 0;\n"
                },
                {
                  "kind": "span",
                  "text": "while J < Path.Num_Data loop\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Data := Path.Data(J);"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "case Data.Header.Path_Type is"
                    }
                  ]
                },
                {
                  "number": 4,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 5,
                  "children": [
                    {
                      "kind": "span",
                      "text": "    when Cairo_Path_Move_To =>"
                    }
                  ]
                },
                {
                  "number": 6,
                  "children": [
                    {
                      "kind": "span",
                      "text": "       Do_Move_To_Things (Data(1).Point.X, Data(1).Point.Y);"
                    }
                  ]
                },
                {
                  "number": 7,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 8,
                  "children": [
                    {
                      "kind": "span",
                      "text": "    when Cairo_Path_Line_To =>"
                    }
                  ]
                },
                {
                  "number": 9,
                  "children": [
                    {
                      "kind": "span",
                      "text": "       Do_Line_To_Things (Data(1).Point.X, Data(1).Point.Y);"
                    }
                  ]
                },
                {
                  "number": 10,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 11,
                  "children": [
                    {
                      "kind": "span",
                      "text": "    when Cairo_Path_Curve_To =>"
                    }
                  ]
                },
                {
                  "number": 12,
                  "children": [
                    {
                      "kind": "span",
                      "text": "       Do_Curve_To_Things (Data(1).Point.X, Data(1).Point.Y,"
                    }
                  ]
                },
                {
                  "number": 13,
                  "children": [
                    {
                      "kind": "span",
                      "text": "                           Data(2).Point.X, Data(2).Point.Y,"
                    }
                  ]
                },
                {
                  "number": 14,
                  "children": [
                    {
                      "kind": "span",
                      "text": "                           Data(3).Point.X, Data(3).Point.Y);"
                    }
                  ]
                },
                {
                  "number": 15,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 16,
                  "children": [
                    {
                      "kind": "span",
                      "text": "    when Cairo_Path_Curve_To =>"
                    }
                  ]
                },
                {
                  "number": 17,
                  "children": [
                    {
                      "kind": "span",
                      "text": "       Do_Close_Path_Things;"
                    }
                  ]
                },
                {
                  "number": 18,
                  "children": [
                    {
                      "kind": "span",
                      "text": "end case;"
                    }
                  ]
                },
                {
                  "number": 19,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                },
                {
                  "number": 20,
                  "children": [
                    {
                      "kind": "span",
                      "text": "J := J + Path.Data[J].Header.Length;"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "end loop;\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Path_Destroy (Path);\n"
                },
                {
                  "kind": "span",
                  "text": "end;\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "As of cairo 1.4, cairo does not mind if there are more elements in\n"
                },
                {
                  "kind": "span",
                  "text": "a portion of the path than needed.  Such elements can be used by\n"
                },
                {
                  "kind": "span",
                  "text": "users of the cairo API to hold extra values in the path data\n"
                },
                {
                  "kind": "span",
                  "text": "structure.  For this reason, it is recommended that applications\n"
                },
                {
                  "kind": "span",
                  "text": "always use Data.Header.Length to iterate over the path data, instead of\n"
                },
                {
                  "kind": "span",
                  "text": "hardcoding the number of elements for each element type.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Discr",
              "line": 2552,
              "column": 26,
              "type": {
                "label": "Glib.Guint",
                "docHref": "docs/glib___spec.html#L55C9"
              },
              "description": [
              ]
            },
            {
              "label": "Header",
              "line": 2555,
              "column": 13,
              "type": {
                "label": "Cairo.Header_Type",
                "docHref": "docs/cairo___spec.html#L2540C9"
              },
              "description": [
              ]
            },
            {
              "label": "Point",
              "line": 2557,
              "column": 13,
              "type": {
                "label": "Cairo.Point_Type",
                "docHref": "docs/cairo___spec.html#L2546C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Rectangle",
          "qualifier": "",
          "line": 1691,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1691,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle",
                      "href": "docs/cairo___spec.html#L1691C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1692,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1692C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1693,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1693C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1694,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/cairo___spec.html#L1694C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1695,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo___spec.html#L1695C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1696,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1691C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "X: X coordinate of the left side of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y coordinate of the the top side of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Width: Width of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Height: Height of the rectangle\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A data structure for holding a rectangle.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "X",
              "line": 1692,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1693,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Width",
              "line": 1694,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Height",
              "line": 1695,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Rectangle_List",
          "qualifier": "",
          "line": 1709,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1709,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_List",
                      "href": "docs/cairo___spec.html#L1709C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1710,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Status",
                      "href": "docs/cairo___spec.html#L1710C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Status",
                      "href": "docs/cairo___spec.html#L216C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1711,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Rectangles",
                      "href": "docs/cairo___spec.html#L1711C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_Array_Access",
                      "href": "docs/cairo___spec.html#L1707C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1712,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Warning: for efficiency reasons, Rectangles is a direct mapping to"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1713,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  the C structure. Therefore, there is no bounds checking on this"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1714,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  array, user needs to make sure only to access data between indexes 0"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1715,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  and Num_Rectanges-1."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1716,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Num_Rectangles",
                      "href": "docs/cairo___spec.html#L1716C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1717,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1709C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Status: Error Status of the rectangle list\n"
                },
                {
                  "kind": "span",
                  "text": "Rectangles: Array containing the Rectangles\n"
                },
                {
                  "kind": "span",
                  "text": "Num_Rectangles: Number of rectangles in this list\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A data structure for holding a Dynamically allocated\n"
                },
                {
                  "kind": "span",
                  "text": "array of rectangles.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Status",
              "line": 1710,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Status",
                "docHref": "docs/cairo___spec.html#L216C9"
              },
              "description": [
              ]
            },
            {
              "label": "Rectangles",
              "line": 1711,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Rectangle_Array_Access",
                "docHref": "docs/cairo___spec.html#L1707C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Warning: for efficiency reasons, Rectangles is a direct mapping to\n"
                    },
                    {
                      "kind": "span",
                      "text": "the C structure. Therefore, there is no bounds checking on this\n"
                    },
                    {
                      "kind": "span",
                      "text": "array, user needs to make sure only to access data between indexes 0\n"
                    },
                    {
                      "kind": "span",
                      "text": "and Num_Rectanges-1.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Num_Rectangles",
              "line": 1716,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Cairo_Text_Cluster",
          "qualifier": "",
          "line": 1820,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1820,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Cluster",
                      "href": "docs/cairo___spec.html#L1820C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1821,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Num_Bytes",
                      "href": "docs/cairo___spec.html#L1821C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1822,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The number of bytes of UTF-8 text covered by cluster"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1823,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1824,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Num_Glyphs",
                      "href": "docs/cairo___spec.html#L1824C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1825,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The number of glyphs covered by cluster"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1826,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1820C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Cairo_text_cluster structure holds information about a single text\n"
                },
                {
                  "kind": "span",
                  "text": "cluster. A text cluster is a minimal mapping of some glyphs\n"
                },
                {
                  "kind": "span",
                  "text": "corresponding to some UTF-8 text.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "For a cluster to be valid, both num_bytes and num_glyphs should\n"
                },
                {
                  "kind": "span",
                  "text": "be non-negative, and at least one should be non-zero.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that clusters with zero glyphs are not as well supported as\n"
                },
                {
                  "kind": "span",
                  "text": "normal clusters.  For example, PDF rendering applications typically\n"
                },
                {
                  "kind": "span",
                  "text": "ignore those clusters when PDF text is being selected.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Show_Text_Glyphs for how clusters are used in advanced\n"
                },
                {
                  "kind": "span",
                  "text": "text operations.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.8\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Num_Bytes",
              "line": 1821,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The number of bytes of UTF-8 text covered by cluster\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Num_Glyphs",
              "line": 1824,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The number of glyphs covered by cluster\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_Text_Extents",
          "qualifier": "",
          "line": 1852,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1852,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Extents",
                      "href": "docs/cairo___spec.html#L1852C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1853,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Bearing",
                      "href": "docs/cairo___spec.html#L1853C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1854,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The horizontal distance from the origin to the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1855,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  leftmost part of the glyphs as drawn. Positive if the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1856,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  glyphs lie entirely to the right of the origin."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1857,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1858,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Bearing",
                      "href": "docs/cairo___spec.html#L1858C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1859,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  The vertical distance from the origin to the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1860,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  topmost part of the glyphs as drawn. Positive only if the"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1861,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  glyphs lie completely below the origin; will usually be"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1862,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  negative."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1863,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1864,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/cairo___spec.html#L1864C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1865,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Width of the glyphs as drawn"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1866,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1867,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo___spec.html#L1867C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1868,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Height of the glyphs as drawn"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1869,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1870,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X_Advance",
                      "href": "docs/cairo___spec.html#L1870C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1871,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Distance to advance in the X direction after drawing these glyphs"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1872,
                  "children": [
                  ]
                },
                {
                  "kind": "line",
                  "number": 1873,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y_Advance",
                      "href": "docs/cairo___spec.html#L1873C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1874,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  Distance to advance in the Y direction"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1875,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  after drawing these glyphs. Will typically be zero except"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1876,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "comment",
                      "text": "--  for vertical text layout as found in East-Asian languages."
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1877,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L1852C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Cairo_text_extents structure stores the extents of a single glyph\n"
                },
                {
                  "kind": "span",
                  "text": "or a string of glyphs in user-space coordinates. Because text extents\n"
                },
                {
                  "kind": "span",
                  "text": "are in user-space coordinates, they are mostly, but not entirely,\n"
                },
                {
                  "kind": "span",
                  "text": "independent of the current transformation matrix. If you call\n"
                },
                {
                  "kind": "span",
                  "text": "Scale (Cr, 2.0, 2.0), text will be drawn twice as big, but the reported\n"
                },
                {
                  "kind": "span",
                  "text": "text extents will not be doubled. They will change slightly due to\n"
                },
                {
                  "kind": "span",
                  "text": "hinting (so you can't assume that metrics are independent of the\n"
                },
                {
                  "kind": "span",
                  "text": "transformation matrix), but otherwise will remain unchanged.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "X_Bearing",
              "line": 1853,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The horizontal distance from the origin to the\n"
                    },
                    {
                      "kind": "span",
                      "text": "leftmost part of the glyphs as drawn. Positive if the\n"
                    },
                    {
                      "kind": "span",
                      "text": "glyphs lie entirely to the right of the origin.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Y_Bearing",
              "line": 1858,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "The vertical distance from the origin to the\n"
                    },
                    {
                      "kind": "span",
                      "text": "topmost part of the glyphs as drawn. Positive only if the\n"
                    },
                    {
                      "kind": "span",
                      "text": "glyphs lie completely below the origin; will usually be\n"
                    },
                    {
                      "kind": "span",
                      "text": "negative.\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Width",
              "line": 1864,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Width of the glyphs as drawn\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Height",
              "line": 1867,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Height of the glyphs as drawn\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "X_Advance",
              "line": 1870,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Distance to advance in the X direction after drawing these glyphs\n"
                    }
                  ]
                }
              ]
            },
            {
              "label": "Y_Advance",
              "line": 1873,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
                {
                  "kind": "paragraph",
                  "children": [
                    {
                      "kind": "span",
                      "text": "Distance to advance in the Y direction\n"
                    },
                    {
                      "kind": "span",
                      "text": "after drawing these glyphs. Will typically be zero except\n"
                    },
                    {
                      "kind": "span",
                      "text": "for vertical text layout as found in East-Asian languages.\n"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "label": "Cairo_User_Data_Key",
          "qualifier": "",
          "line": 195,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 195,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 196,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Unused",
                      "href": "docs/cairo___spec.html#L196C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 197,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L195C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Unused: not used; ignore.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_User_Data_Key is used for attaching user data to cairo\n"
                },
                {
                  "kind": "span",
                  "text": "data structures.  The actual contents of the struct is never used,\n"
                },
                {
                  "kind": "span",
                  "text": "and there is no need to initialize the object; only the unique\n"
                },
                {
                  "kind": "span",
                  "text": "address of a Cairo_User_Data_Key object is used.  Typically, you\n"
                },
                {
                  "kind": "span",
                  "text": "would just use the address of a static Cairo_User_Data_Key object.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Unused",
              "line": 196,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Header_Type",
          "qualifier": "",
          "line": 2540,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2540,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Header_Type",
                      "href": "docs/cairo___spec.html#L2540C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2541,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Type",
                      "href": "docs/cairo___spec.html#L2541C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Data_Type",
                      "href": "docs/cairo___spec.html#L2529C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2542,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Length",
                      "href": "docs/cairo___spec.html#L2542C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2543,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2540C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A Path header. See Cairo_Path_Data for details.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "Path_Type",
              "line": 2541,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Path_Data_Type",
                "docHref": "docs/cairo___spec.html#L2529C9"
              },
              "description": [
              ]
            },
            {
              "label": "Length",
              "line": 2542,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Point_Type",
          "qualifier": "",
          "line": 2546,
          "column": 9,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2546,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "type"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Point_Type",
                      "href": "docs/cairo___spec.html#L2546C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "is"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2547,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L2547C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2548,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L2548C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "aliased"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2549,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "end"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "record"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";",
                      "href": "docs/cairo___spec.html#L2546C9"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A geometrical point. See Cairo_Path_Data for details.\n"
                }
              ]
            }
          ],
          "fields": [
            {
              "label": "X",
              "line": 2547,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 2548,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        }
      ],
      "label": "Record types"
    },
    {
      "entities": [
        {
          "label": "Append_Path",
          "qualifier": "",
          "line": 2703,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2703,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Append_Path",
                      "href": "docs/cairo___spec.html#L2703C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2704,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2704C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2705,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path",
                      "href": "docs/cairo___spec.html#L2705C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path",
                      "href": "docs/cairo___spec.html#L2627C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Path: Path to be appended\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Append the path onto the current path. The path may be either the return\n"
                },
                {
                  "kind": "span",
                  "text": "value from one of Copy_Path or Copy_Path_Flat or it may be constructed\n"
                },
                {
                  "kind": "span",
                  "text": "manually. See Cairo_Path for details on how the path data structure\n"
                },
                {
                  "kind": "span",
                  "text": "should be initialized, and note that Path.Status must be initialized to\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Status_Success.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2704,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Path",
              "line": 2705,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Arc",
          "qualifier": "",
          "line": 1169,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1169,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Arc",
                      "href": "docs/cairo___spec.html#L1169C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1170,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1170C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1171,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xc",
                      "href": "docs/cairo___spec.html#L1171C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1172,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yc",
                      "href": "docs/cairo___spec.html#L1172C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1173,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius",
                      "href": "docs/cairo___spec.html#L1173C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1174,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Angle1",
                      "href": "docs/cairo___spec.html#L1174C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1175,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Angle2",
                      "href": "docs/cairo___spec.html#L1175C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Xc: X position of the center of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Yc: Y position of the center of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Radius: the Radius of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Angle1: the start angle, in radians\n"
                },
                {
                  "kind": "span",
                  "text": "Angle2: the end angle, in radians\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a circular arc of the given radius to the current path.  The\n"
                },
                {
                  "kind": "span",
                  "text": "arc is centered at (Xc, Yc), begins at Angle1 and proceeds in\n"
                },
                {
                  "kind": "span",
                  "text": "the direction of increasing angles to end at Angle2. If Angle2 is\n"
                },
                {
                  "kind": "span",
                  "text": "less than Angle1 it will be progressively increased by 2*M_PI\n"
                },
                {
                  "kind": "span",
                  "text": "until it is greater than Angle1.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is a current point, an initial line segment will be added\n"
                },
                {
                  "kind": "span",
                  "text": "to the path to connect the current point to the beginning of the\n"
                },
                {
                  "kind": "span",
                  "text": "arc. If this initial line is undesired, it can be avoided by\n"
                },
                {
                  "kind": "span",
                  "text": "calling New_Sub_Path before calling Arc.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Angles are measured in radians. An angle of 0.0 is in the direction\n"
                },
                {
                  "kind": "span",
                  "text": "of the positive X axis (in user space). An angle of M_PI/2.0 radians\n"
                },
                {
                  "kind": "span",
                  "text": "(90 degrees) is in the direction of the positive Y axis (in\n"
                },
                {
                  "kind": "span",
                  "text": "user space). Angles increase in the direction from the positive X\n"
                },
                {
                  "kind": "span",
                  "text": "axis toward the positive Y axis. So with the default transformation\n"
                },
                {
                  "kind": "span",
                  "text": "matrix, angles increase in a clockwise direction.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "(To convert from degrees to radians, use degrees * (Pi / 180.0))\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function gives the arc in the direction of increasing angles;\n"
                },
                {
                  "kind": "span",
                  "text": "see Cairo_Arc_Negative to get the arc in the direction of\n"
                },
                {
                  "kind": "span",
                  "text": "decreasing angles.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The arc is circular in user space. To achieve an elliptical arc,\n"
                },
                {
                  "kind": "span",
                  "text": "you can scale the current transformation matrix by different\n"
                },
                {
                  "kind": "span",
                  "text": "amounts in the X and Y directions. For example, to draw an ellipse\n"
                },
                {
                  "kind": "span",
                  "text": "in the box given by X, Y, Width, Height:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cairo_Save (Cr);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Translate (Cr, X + Width / 2.0, Y + Height / 2.0);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Scale (Cr, Width / 2.0, Height / 2.0);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Arc (Cr, 0.0, 0.0, 1.0, 0.0, 2 * Pi);\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Restore (Cr);\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1170,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Xc",
              "line": 1171,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yc",
              "line": 1172,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius",
              "line": 1173,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Angle1",
              "line": 1174,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Angle2",
              "line": 1175,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Arc_Negative",
          "qualifier": "",
          "line": 1218,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1218,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Arc_Negative",
                      "href": "docs/cairo___spec.html#L1218C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1219,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1219C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1220,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Xc",
                      "href": "docs/cairo___spec.html#L1220C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1221,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Yc",
                      "href": "docs/cairo___spec.html#L1221C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1222,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius",
                      "href": "docs/cairo___spec.html#L1222C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1223,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Angle1",
                      "href": "docs/cairo___spec.html#L1223C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1224,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Angle2",
                      "href": "docs/cairo___spec.html#L1224C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Xc: X position of the center of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Yc: Y position of the center of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Radius: the Radius of the arc\n"
                },
                {
                  "kind": "span",
                  "text": "Angle1: the start angle, in radians\n"
                },
                {
                  "kind": "span",
                  "text": "Angle2: the end angle, in radians\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a circular arc of the given radius to the current path.  The\n"
                },
                {
                  "kind": "span",
                  "text": "arc is centered at (Xc, Yc), begins at Angle1 and proceeds in\n"
                },
                {
                  "kind": "span",
                  "text": "the direction of decreasing angles to end at Angle2. If Angle2 is\n"
                },
                {
                  "kind": "span",
                  "text": "greater than Angle1 it will be progressively decreased by 2*Pi\n"
                },
                {
                  "kind": "span",
                  "text": "until it is less than Angle1.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Arc for more details. This function differs only in the\n"
                },
                {
                  "kind": "span",
                  "text": "direction of the arc between the two angles.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1219,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Xc",
              "line": 1220,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Yc",
              "line": 1221,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius",
              "line": 1222,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Angle1",
              "line": 1223,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Angle2",
              "line": 1224,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Clip",
          "qualifier": "",
          "line": 1632,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1632,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Clip",
                      "href": "docs/cairo___spec.html#L1632C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1632C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Establishes a new clip region by intersecting the current clip\n"
                },
                {
                  "kind": "span",
                  "text": "region with the current path as it would be filled by Fill\n"
                },
                {
                  "kind": "span",
                  "text": "and according to the current fill rule (see Set_Fill_Rule).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "After Clip, the current path will be cleared from the cairo\n"
                },
                {
                  "kind": "span",
                  "text": "context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The current clip region affects all drawing operations by\n"
                },
                {
                  "kind": "span",
                  "text": "effectively masking out any changes to the surface that are outside\n"
                },
                {
                  "kind": "span",
                  "text": "the current clip region.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Calling Clip can only make the clip region smaller, never\n"
                },
                {
                  "kind": "span",
                  "text": "larger. But the current clip is part of the graphics state, so a\n"
                },
                {
                  "kind": "span",
                  "text": "temporary restriction of the clip region can be achieved by\n"
                },
                {
                  "kind": "span",
                  "text": "calling Clip within a Save/Restore\n"
                },
                {
                  "kind": "span",
                  "text": "pair. The only other means of increasing the size of the clip\n"
                },
                {
                  "kind": "span",
                  "text": "region is Reset_Clip.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1632,
              "column": 20,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Clip_Extents",
          "qualifier": "",
          "line": 1674,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1674,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Clip_Extents",
                      "href": "docs/cairo___spec.html#L1674C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1675,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1675C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1676,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo___spec.html#L1676C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1677,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo___spec.html#L1677C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1678,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X2",
                      "href": "docs/cairo___spec.html#L1678C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1679,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y2",
                      "href": "docs/cairo___spec.html#L1679C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X1: left of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: top of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "X2: right of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y2: bottom of the resulting extents\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Computes a bounding box in user coordinates covering the area inside the\n"
                },
                {
                  "kind": "span",
                  "text": "current clip.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1675,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 1676,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 1677,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X2",
              "line": 1678,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y2",
              "line": 1679,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Clip_Preserve",
          "qualifier": "",
          "line": 1653,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1653,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Clip_Preserve",
                      "href": "docs/cairo___spec.html#L1653C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1653C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Establishes a new clip region by intersecting the current clip\n"
                },
                {
                  "kind": "span",
                  "text": "region with the current path as it would be filled by Fill\n"
                },
                {
                  "kind": "span",
                  "text": "and according to the current fill rule (see Set_Fill_Rule).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Unlike Clip, Clip_Preserve preserves the path within\n"
                },
                {
                  "kind": "span",
                  "text": "the cairo context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The current clip region affects all drawing operations by\n"
                },
                {
                  "kind": "span",
                  "text": "effectively masking out any changes to the surface that are outside\n"
                },
                {
                  "kind": "span",
                  "text": "the current clip region.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Calling Clip_Preserve can only make the clip region smaller, never\n"
                },
                {
                  "kind": "span",
                  "text": "larger. But the current clip is part of the graphics state, so a\n"
                },
                {
                  "kind": "span",
                  "text": "temporary restriction of the clip region can be achieved by\n"
                },
                {
                  "kind": "span",
                  "text": "calling Clip_Preserve within a Save/Restore\n"
                },
                {
                  "kind": "span",
                  "text": "pair. The only other means of increasing the size of the clip\n"
                },
                {
                  "kind": "span",
                  "text": "region is Reset_Clip.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1653,
              "column": 29,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Close_Path",
          "qualifier": "",
          "line": 1327,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1327,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Close_Path",
                      "href": "docs/cairo___spec.html#L1327C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1327C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a line segment to the path from the current point to the\n"
                },
                {
                  "kind": "span",
                  "text": "beginning of the current sub-path, (the most recent point passed to\n"
                },
                {
                  "kind": "span",
                  "text": "Move_To), and closes this sub-path. After this call the\n"
                },
                {
                  "kind": "span",
                  "text": "current point will be at the joined endpoint of the sub-path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The behavior of Close_Path is distinct from simply calling\n"
                },
                {
                  "kind": "span",
                  "text": "Line_To with the equivalent coordinate in the case of\n"
                },
                {
                  "kind": "span",
                  "text": "stroking. When a closed sub-path is stroked, there are no caps on\n"
                },
                {
                  "kind": "span",
                  "text": "the ends of the sub-path. Instead, there is a line join connecting\n"
                },
                {
                  "kind": "span",
                  "text": "the final and initial segments of the sub-path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is no current point before the call to Close_Path,\n"
                },
                {
                  "kind": "span",
                  "text": "this function will have no effect.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: As of cairo version 1.2.4 any call to Close_Path will\n"
                },
                {
                  "kind": "span",
                  "text": "place an explicit MOVE_TO element into the path immediately after\n"
                },
                {
                  "kind": "span",
                  "text": "the CLOSE_PATH element, (which can be seen in Copy_Path for\n"
                },
                {
                  "kind": "span",
                  "text": "example). This can simplify path processing in some cases as it may\n"
                },
                {
                  "kind": "span",
                  "text": "not be necessary to save the \"last move_to point\" during processing\n"
                },
                {
                  "kind": "span",
                  "text": "as the MOVE_TO immediately after the CLOSE_PATH will provide that\n"
                },
                {
                  "kind": "span",
                  "text": "point.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1327,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Copy_Clip_Rectangle_List",
          "qualifier": "",
          "line": 1730,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1730,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy_Clip_Rectangle_List",
                      "href": "docs/cairo___spec.html#L1730C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1731,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1731C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1732,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Rectangle_List_Access",
                      "href": "docs/cairo___spec.html#L1728C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current clip region as a list of rectangles in user\n"
                },
                {
                  "kind": "span",
                  "text": "coordinates.\n"
                },
                {
                  "kind": "span",
                  "text": "Never returns NULL.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The status in the list may be Cairo_Status_Clip_Not_Representable to\n"
                },
                {
                  "kind": "span",
                  "text": "indicate that the clip region cannot be represented as a list of\n"
                },
                {
                  "kind": "span",
                  "text": "user-space rectangles. The status may have other values to indicate\n"
                },
                {
                  "kind": "span",
                  "text": "other errors.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns: the current clip region as a list of rectangles in user\n"
                },
                {
                  "kind": "span",
                  "text": "coordinates,\n"
                },
                {
                  "kind": "span",
                  "text": "which should be destroyed using Rectangle_List_Destroy.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1731,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Copy_Page",
          "qualifier": "",
          "line": 1487,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1487,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy_Page",
                      "href": "docs/cairo___spec.html#L1487C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1487C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Emits the current page for backends that support multiple pages, but\n"
                },
                {
                  "kind": "span",
                  "text": "doesn't clear it, so, the contents of the current page will be retained\n"
                },
                {
                  "kind": "span",
                  "text": "for the next page too.  Use Show_Page if you want to get an\n"
                },
                {
                  "kind": "span",
                  "text": "empty page after the emission.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This is a convenience function that simply calls\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Copy_Page on Cr's target.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1487,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Copy_Path",
          "qualifier": "",
          "line": 2653,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2653,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy_Path",
                      "href": "docs/cairo___spec.html#L2653C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2653C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Access",
                      "href": "docs/cairo___spec.html#L2636C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a copy of the current path and returns it to the user as a\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Path. See Cairo_Path_Data for hints on how to iterate\n"
                },
                {
                  "kind": "span",
                  "text": "over the returned data structure.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but the result\n"
                },
                {
                  "kind": "span",
                  "text": "will have no data (Data = null and Num_Data = 0), if\n"
                },
                {
                  "kind": "span",
                  "text": "either of the following conditions hold:\n"
                }
              ]
            },
            {
              "kind": "ul",
              "children": [
                {
                  "kind": "li",
                  "children": [
                    {
                      "kind": "span",
                      "text": "> If there is insufficient memory to copy the path. In this\n"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "case Path.Status will be set to Cairo_Status_No_Memory"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "ul",
              "children": [
                {
                  "kind": "li",
                  "children": [
                    {
                      "kind": "span",
                      "text": "> If Cr is already in an error state. In this case\n"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Path.Status will contain the same status that\n"
                },
                {
                  "kind": "span",
                  "text": "would be returned by Status.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the copy of the current path. The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Path_Destroy when finished with it.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2653,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Copy_Path_Flat",
          "qualifier": "",
          "line": 2674,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2674,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Copy_Path_Flat",
                      "href": "docs/cairo___spec.html#L2674C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2674C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path_Access",
                      "href": "docs/cairo___spec.html#L2636C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets a flattened copy of the current path and returns it to the\n"
                },
                {
                  "kind": "span",
                  "text": "user as a Cairo_Path. See Cairo_Path_Data for hints on\n"
                },
                {
                  "kind": "span",
                  "text": "how to iterate over the returned data structure.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function is like Copy_Path except that any curves\n"
                },
                {
                  "kind": "span",
                  "text": "in the path will be approximated with piecewise-linear\n"
                },
                {
                  "kind": "span",
                  "text": "approximations, (accurate to within the current tolerance\n"
                },
                {
                  "kind": "span",
                  "text": "value). That is, the result is guaranteed to not have any elements\n"
                },
                {
                  "kind": "span",
                  "text": "of type Cairo_Path_Curve_To which will instead be replaced by a\n"
                },
                {
                  "kind": "span",
                  "text": "series of Cairo_Path_Line_To elements.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but the result will\n"
                },
                {
                  "kind": "span",
                  "text": "have no data (Data = null and Num_Data = 0), if either of the following\n"
                },
                {
                  "kind": "span",
                  "text": "conditions hold:\n"
                }
              ]
            },
            {
              "kind": "ul",
              "children": [
                {
                  "kind": "li",
                  "children": [
                    {
                      "kind": "span",
                      "text": "> If there is insufficient memory to copy the path. In this\n"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "case Path.Status will be set to Cairo_Status_No_Memory"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "ul",
              "children": [
                {
                  "kind": "li",
                  "children": [
                    {
                      "kind": "span",
                      "text": "> If Cr is already in an error state. In this case\n"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Path.Status will contain the same status that\n"
                },
                {
                  "kind": "span",
                  "text": "would be returned by Status.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the copy of the current path. The caller owns the\n"
                },
                {
                  "kind": "span",
                  "text": "returned object and should call Path_Destroy when finished\n"
                },
                {
                  "kind": "span",
                  "text": "with it.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2674,
              "column": 29,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Create",
          "qualifier": "",
          "line": 335,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 335,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Create",
                      "href": "docs/cairo___spec.html#L335C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Target",
                      "href": "docs/cairo___spec.html#L335C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Target: Target surface for the context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Creates a new Cairo_Context with all graphics state parameters set to\n"
                },
                {
                  "kind": "span",
                  "text": "default values and with target as a target surface. The target\n"
                },
                {
                  "kind": "span",
                  "text": "surface should be constructed with a backend-specific function such\n"
                },
                {
                  "kind": "span",
                  "text": "as Cairo.Image_Surface.Create.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function references target, so you can immediately\n"
                },
                {
                  "kind": "span",
                  "text": "call Cairo.Surface.Destroy on it if you don't need to\n"
                },
                {
                  "kind": "span",
                  "text": "maintain a separate reference to it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a newly allocated Cairo_Context with a reference\n"
                },
                {
                  "kind": "span",
                  "text": "count of 1. The initial reference count should be released\n"
                },
                {
                  "kind": "span",
                  "text": "with Destroy when you are done using the Cairo_Context.\n"
                },
                {
                  "kind": "span",
                  "text": "This function never returns NULL. If memory cannot be\n"
                },
                {
                  "kind": "span",
                  "text": "allocated, a special Cairo_Context object will be returned on\n"
                },
                {
                  "kind": "span",
                  "text": "which Status returns Cairo_Status_No_Memory.\n"
                },
                {
                  "kind": "span",
                  "text": "You can use this object normally, but no drawing will\n"
                },
                {
                  "kind": "span",
                  "text": "be done.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Target",
              "line": 335,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Curve_To",
          "qualifier": "",
          "line": 1144,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1144,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Curve_To",
                      "href": "docs/cairo___spec.html#L1144C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1145,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1145C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1146,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo___spec.html#L1146C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1147,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo___spec.html#L1147C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1148,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X2",
                      "href": "docs/cairo___spec.html#L1148C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1149,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y2",
                      "href": "docs/cairo___spec.html#L1149C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1150,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X3",
                      "href": "docs/cairo___spec.html#L1150C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1151,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y3",
                      "href": "docs/cairo___spec.html#L1151C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X1: the X coordinate of the first control point\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: the Y coordinate of the first control point\n"
                },
                {
                  "kind": "span",
                  "text": "X2: the X coordinate of the second control point\n"
                },
                {
                  "kind": "span",
                  "text": "Y2: the Y coordinate of the second control point\n"
                },
                {
                  "kind": "span",
                  "text": "X3: the X coordinate of the end of the curve\n"
                },
                {
                  "kind": "span",
                  "text": "Y3: the Y coordinate of the end of the curve\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a cubic B\u00E9zier spline to the path from the current point to\n"
                },
                {
                  "kind": "span",
                  "text": "position (X3, Y3) in user-space coordinates, using (X1, Y1) and\n"
                },
                {
                  "kind": "span",
                  "text": "(X2, Y2) as the control points. After this call the current point\n"
                },
                {
                  "kind": "span",
                  "text": "will be (X3, Y3).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is no current point before the call to Curve_To\n"
                },
                {
                  "kind": "span",
                  "text": "this function will behave as if preceded by a call to\n"
                },
                {
                  "kind": "span",
                  "text": "Move_To (Cr, X1, Y1).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1145,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 1146,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 1147,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X2",
              "line": 1148,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y2",
              "line": 1149,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X3",
              "line": 1150,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y3",
              "line": 1151,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Destroy",
          "qualifier": "",
          "line": 368,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 368,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Destroy",
                      "href": "docs/cairo___spec.html#L368C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L368C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 368,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Device_To_User",
          "qualifier": "",
          "line": 1073,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1073,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device_To_User",
                      "href": "docs/cairo___spec.html#L1073C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1074,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1074C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1075,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1075C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1076,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1076C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo\n"
                },
                {
                  "kind": "span",
                  "text": "X: X value of coordinate (in/out parameter)\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y value of coordinate (in/out parameter)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Transform a coordinate from device space to user space by\n"
                },
                {
                  "kind": "span",
                  "text": "multiplying the given point by the inverse of the current\n"
                },
                {
                  "kind": "span",
                  "text": "transformation matrix (CTM).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1074,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 1075,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1076,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Device_To_User_Distance",
          "qualifier": "",
          "line": 1085,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1085,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Device_To_User_Distance",
                      "href": "docs/cairo___spec.html#L1085C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1086,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1086C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1087,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dx",
                      "href": "docs/cairo___spec.html#L1087C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1088,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dy",
                      "href": "docs/cairo___spec.html#L1088C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Dx: X component of a distance vector (in/out parameter)\n"
                },
                {
                  "kind": "span",
                  "text": "Dy: Y component of a distance vector (in/out parameter)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Transform a distance vector from device space to user space. This\n"
                },
                {
                  "kind": "span",
                  "text": "function is similar to Device_To_User except that the\n"
                },
                {
                  "kind": "span",
                  "text": "translation components of the inverse CTM will be ignored when\n"
                },
                {
                  "kind": "span",
                  "text": "transforming (Dx,dy).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1086,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Dx",
              "line": 1087,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Dy",
              "line": 1088,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Fill",
          "qualifier": "",
          "line": 1469,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1469,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fill",
                      "href": "docs/cairo___spec.html#L1469C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1469C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that fills the current path according to the\n"
                },
                {
                  "kind": "span",
                  "text": "current fill rule, (each sub-path is implicitly closed before being\n"
                },
                {
                  "kind": "span",
                  "text": "filled). After Fill, the current path will be cleared from\n"
                },
                {
                  "kind": "span",
                  "text": "the cairo context. See Set_Fill_Rule and Fill_Preserve.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1469,
              "column": 20,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Fill_Extents",
          "qualifier": "",
          "line": 1585,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1585,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fill_Extents",
                      "href": "docs/cairo___spec.html#L1585C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1586,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1586C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1587,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo___spec.html#L1587C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1588,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo___spec.html#L1588C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1589,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X2",
                      "href": "docs/cairo___spec.html#L1589C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1590,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y2",
                      "href": "docs/cairo___spec.html#L1590C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X1: left of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: top of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "X2: right of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y2: bottom of the resulting extents\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Computes a bounding box in user coordinates covering the area that\n"
                },
                {
                  "kind": "span",
                  "text": "would be affected, (the \"inked\" area), by a Fill operation\n"
                },
                {
                  "kind": "span",
                  "text": "given the current path and fill parameters. If the current path is\n"
                },
                {
                  "kind": "span",
                  "text": "empty, returns an empty rectangle ((0,0), (0,0)). Surface\n"
                },
                {
                  "kind": "span",
                  "text": "dimensions and clipping are not taken into account.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Contrast with Path_Extents, which is similar, but returns\n"
                },
                {
                  "kind": "span",
                  "text": "non-zero extents for some paths with no inked area, (such as a\n"
                },
                {
                  "kind": "span",
                  "text": "simple line segment).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that Fill_Extents must necessarily do more work to\n"
                },
                {
                  "kind": "span",
                  "text": "compute the precise inked areas in light of the fill rule, so\n"
                },
                {
                  "kind": "span",
                  "text": "Path_Extents may be more desirable for sake of performance\n"
                },
                {
                  "kind": "span",
                  "text": "if the non-inked path extents are desired.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Fill, Set_Fill_Rule and Fill_Preserve.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1586,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 1587,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 1588,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "X2",
              "line": 1589,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y2",
              "line": 1590,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Fill_Preserve",
          "qualifier": "",
          "line": 1477,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1477,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Fill_Preserve",
                      "href": "docs/cairo___spec.html#L1477C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1477C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that fills the current path according to the\n"
                },
                {
                  "kind": "span",
                  "text": "current fill rule, (each sub-path is implicitly closed before being\n"
                },
                {
                  "kind": "span",
                  "text": "filled). Unlike Fill, Fill_Preserve preserves the path within the\n"
                },
                {
                  "kind": "span",
                  "text": "cairo context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Set_Fill_Rule and Fill.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1477,
              "column": 29,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Font_Extents",
          "qualifier": "",
          "line": 2299,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2299,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Font_Extents",
                      "href": "docs/cairo___spec.html#L2299C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2300,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2300C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2301,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Extents",
                      "href": "docs/cairo___spec.html#L2301C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Extents",
                      "href": "docs/cairo___spec.html#L1888C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Extents: a Cairo_Font_Extents object into which the results\n"
                },
                {
                  "kind": "span",
                  "text": "will be stored.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the font extents for the currently selected font.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2300,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Extents",
              "line": 2301,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Antialias",
          "qualifier": "",
          "line": 2382,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2382,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Antialias",
                      "href": "docs/cairo___spec.html#L2382C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2382C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Antialias",
                      "href": "docs/cairo___spec.html#L772C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current shape antialiasing mode, as set by Set_Antialias.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current shape antialiasing mode.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2382,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Context",
          "qualifier": "",
          "line": 88,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 88,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Context",
                      "href": "docs/cairo___spec.html#L88C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 89,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Value",
                      "href": "docs/cairo___spec.html#L89C8"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glib.Values.GValue",
                      "href": "docs/glib__values___spec.html#L238C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Support for callbacks that receive a Cairo_Context as parameter.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Value",
              "line": 89,
              "column": 8,
              "type": {
                "label": "Glib.Values.GValue",
                "docHref": "docs/glib__values___spec.html#L44C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Current_Point",
          "qualifier": "",
          "line": 2399,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2399,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Current_Point",
                      "href": "docs/cairo___spec.html#L2399C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2400,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2400C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2401,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L2401C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2402,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L2402C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: return value for X coordinate of the current point\n"
                },
                {
                  "kind": "span",
                  "text": "Y: return value for Y coordinate of the current point\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current point of the current path, which is\n"
                },
                {
                  "kind": "span",
                  "text": "conceptually the final point reached by the path so far.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The current point is returned in the user-space coordinate\n"
                },
                {
                  "kind": "span",
                  "text": "system. If there is no defined current point or if cr is in an\n"
                },
                {
                  "kind": "span",
                  "text": "error status, X and Y will both be set to 0.0. It is possible to\n"
                },
                {
                  "kind": "span",
                  "text": "check this in advance with Has_Current_Point.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Most path construction functions alter the current point. See the\n"
                },
                {
                  "kind": "span",
                  "text": "following for details on how they affect the current point:\n"
                },
                {
                  "kind": "span",
                  "text": "New_Path, New_Sub_Path, Append_Path, Close_Path, Move_To, Line_To,\n"
                },
                {
                  "kind": "span",
                  "text": "Curve_To, Rel_Move_To, Rel_Line_To, Rel_Curve_To, Arc, Arc_Negative,\n"
                },
                {
                  "kind": "span",
                  "text": "Rectangle, Text_Path, Glyph_Path, Stroke_To_Path.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Some functions use and alter the current point but do not otherwise\n"
                },
                {
                  "kind": "span",
                  "text": "change current path: Show_Text.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Some functions unset the current path and as a result, current point:\n"
                },
                {
                  "kind": "span",
                  "text": "Fill, Stroke.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2400,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 2401,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 2402,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Dash",
          "qualifier": "",
          "line": 2479,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2479,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Dash",
                      "href": "docs/cairo___spec.html#L2479C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2480,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2480C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2481,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dashes",
                      "href": "docs/cairo___spec.html#L2481C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Dash_Array_Access",
                      "href": "docs/cairo___spec.html#L2477C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2482,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo___spec.html#L2482C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "out"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Dashes: return value for the dash array, or null\n"
                },
                {
                  "kind": "span",
                  "text": "Offset: return value for the current dash Offset, or null\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current dash array.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2480,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Dashes",
              "line": 2481,
              "column": 7,
              "type": {
                "label": "Cairo.Dash_Array_Access",
                "docHref": "docs/cairo___spec.html#L2477C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 2482,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Dash_Count",
          "qualifier": "",
          "line": 2465,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2465,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Dash_Count",
                      "href": "docs/cairo___spec.html#L2465C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2465C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the length of the dash array in cr (0 if dashing\n"
                },
                {
                  "kind": "span",
                  "text": "is not currently in effect).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See also Set_Dash and Get_Dash.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the length of the dash array, or 0 if no dash array set.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2465,
              "column": 29,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Fill_Rule",
          "qualifier": "",
          "line": 2427,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2427,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Fill_Rule",
                      "href": "docs/cairo___spec.html#L2427C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2427C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Fill_Rule",
                      "href": "docs/cairo___spec.html#L815C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current fill rule, as set by Set_Fill_Rule.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current fill rule.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2427,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Font_Face",
          "qualifier": "",
          "line": 2143,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2143,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Font_Face",
                      "href": "docs/cairo___spec.html#L2143C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2143C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Face",
                      "href": "docs/cairo___spec.html#L2776C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current font face for a Cairo_Context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current font face.  This object is owned by\n"
                },
                {
                  "kind": "span",
                  "text": "cairo. To keep a reference to it, you must call\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Font_Face.Reference.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function never returns Null_Font_Face. If memory cannot be\n"
                },
                {
                  "kind": "span",
                  "text": "allocated, a special \"nil\" Cairo_Font_Face object will be returned on\n"
                },
                {
                  "kind": "span",
                  "text": "which Cairo.Font_Face.Status returns Cairo_Status_No_Memory. Using this\n"
                },
                {
                  "kind": "span",
                  "text": "nil object will cause its error state to propagate to other objects it\n"
                },
                {
                  "kind": "span",
                  "text": "is passed to, (for example, calling Set_Font_Face with a nil font\n"
                },
                {
                  "kind": "span",
                  "text": "will trigger an error that will shutdown the Cairo_Context object).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2143,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Font_Matrix",
          "qualifier": "",
          "line": 2100,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2100,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Font_Matrix",
                      "href": "docs/cairo___spec.html#L2100C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2101,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2101C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo___spec.html#L2102C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Matrix: return value for the Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Stores the current font matrix into matrix. See Set_Font_Matrix.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2101,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Matrix",
              "line": 2102,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Font_Options",
          "qualifier": "",
          "line": 2120,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2120,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Font_Options",
                      "href": "docs/cairo___spec.html#L2120C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2121,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2121C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2122,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Options",
                      "href": "docs/cairo___spec.html#L2122C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Font_Options",
                      "href": "docs/cairo___spec.html#L2779C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Options: a Cairo_Font_Options object into which to store\n"
                },
                {
                  "kind": "span",
                  "text": "the retrieved options. All existing values are overwritten\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Retrieves font rendering options set via Set_Font_Options.\n"
                },
                {
                  "kind": "span",
                  "text": "Note that the returned options do not include any options derived\n"
                },
                {
                  "kind": "span",
                  "text": "from the underlying surface; they are literally the options\n"
                },
                {
                  "kind": "span",
                  "text": "passed to Set_Font_Options.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2121,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Options",
              "line": 2122,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Font_Options",
                "docHref": "docs/cairo___spec.html#L2017C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Group_Target",
          "qualifier": "",
          "line": 2511,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2511,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Group_Target",
                      "href": "docs/cairo___spec.html#L2511C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2511C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current destination surface for the context. This is either\n"
                },
                {
                  "kind": "span",
                  "text": "the original target surface as passed to Create or the target\n"
                },
                {
                  "kind": "span",
                  "text": "surface for the current group as started by the most recent call to\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group or Push_Group_With_Content.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but the result\n"
                },
                {
                  "kind": "span",
                  "text": "can be a \"nil\" surface if cr is already in an error state,\n"
                },
                {
                  "kind": "span",
                  "text": "(ie. Cairo_Status /= Cairo_Status_Success).\n"
                },
                {
                  "kind": "span",
                  "text": "A nil surface is indicated by Cairo_Status /= Cairo_Status_Success.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the target surface. This object is owned by cairo. To\n"
                },
                {
                  "kind": "span",
                  "text": "keep a reference to it, you must call Cairo.Surface.Reference.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2511,
              "column": 31,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Line_Cap",
          "qualifier": "",
          "line": 2444,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2444,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Line_Cap",
                      "href": "docs/cairo___spec.html#L2444C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2444C27"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Cap",
                      "href": "docs/cairo___spec.html#L867C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current line cap style, as set by Set_Line_Cap.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current line cap style.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2444,
              "column": 27,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Line_Join",
          "qualifier": "",
          "line": 2451,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2451,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Line_Join",
                      "href": "docs/cairo___spec.html#L2451C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2451C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Line_Join",
                      "href": "docs/cairo___spec.html#L895C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current line join style, as set by Set_Line_Join.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current line join style.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2451,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Line_Width",
          "qualifier": "",
          "line": 2434,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2434,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Line_Width",
                      "href": "docs/cairo___spec.html#L2434C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2434C29"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function returns the current line width value exactly as set by\n"
                },
                {
                  "kind": "span",
                  "text": "Set_Line_Width. Note that the value is unchanged even if\n"
                },
                {
                  "kind": "span",
                  "text": "the CTM has changed between the calls to Set_Line_Width and\n"
                },
                {
                  "kind": "span",
                  "text": "Get_Line_Width.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current line width.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2434,
              "column": 29,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Matrix",
          "qualifier": "",
          "line": 2491,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2491,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Matrix",
                      "href": "docs/cairo___spec.html#L2491C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2491C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Matrix",
                      "href": "docs/cairo___spec.html#L2491C46"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Matrix",
                      "href": "docs/cairo___spec.html#L106C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Matrix: return value for the Matrix\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Stores the current transformation matrix (CTM) into matrix.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2491,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Matrix",
              "line": 2491,
              "column": 46,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Miter_Limit",
          "qualifier": "",
          "line": 2458,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2458,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Miter_Limit",
                      "href": "docs/cairo___spec.html#L2458C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2458C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current miter limit, as set by Set_Miter_Limit.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current miter limit.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2458,
              "column": 30,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Operator",
          "qualifier": "",
          "line": 2359,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2359,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Operator",
                      "href": "docs/cairo___spec.html#L2359C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2359C27"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Operator",
                      "href": "docs/cairo___spec.html#L574C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current compositing operator for a cairo context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current compositing operator.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2359,
              "column": 27,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Reference_Count",
          "qualifier": "",
          "line": 380,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 380,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Reference_Count",
                      "href": "docs/cairo___spec.html#L380C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L380C34"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Guint",
                      "href": "docs/glib___spec.html#L55C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns the current reference count of cr.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current reference count of cr.  If the\n"
                },
                {
                  "kind": "span",
                  "text": "object is a nil object, 0 will be returned.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 380,
              "column": 34,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Scaled_Font",
          "qualifier": "",
          "line": 2173,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2173,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Scaled_Font",
                      "href": "docs/cairo___spec.html#L2173C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2173C30"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Scaled_Font",
                      "href": "docs/cairo___spec.html#L2773C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current scaled font for a Cairo_Context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current scaled font. This object is owned by\n"
                },
                {
                  "kind": "span",
                  "text": "cairo. To keep a reference to it, you must call\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Scaled_Font.Reference.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function never returns Null_Font_Face. If memory cannot be\n"
                },
                {
                  "kind": "span",
                  "text": "allocated, a special \"nil\" Cairo_Scaled_Font object will be returned on\n"
                },
                {
                  "kind": "span",
                  "text": "which Cairo.Font_Face.Status returns Cairo_Status_No_Memory. Using this\n"
                },
                {
                  "kind": "span",
                  "text": "nil object will cause its error state to propagate to other objects it\n"
                },
                {
                  "kind": "span",
                  "text": "is passed to, (for example, calling Set_Font_Face with a nil font\n"
                },
                {
                  "kind": "span",
                  "text": "will trigger an error that will shutdown the Cairo_Context object).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2173,
              "column": 30,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Source",
          "qualifier": "",
          "line": 2366,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2366,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Source",
                      "href": "docs/cairo___spec.html#L2366C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2366C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current source pattern for Cr.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current source pattern. This object is owned by\n"
                },
                {
                  "kind": "span",
                  "text": "cairo. To keep a reference to it, you must call\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Reference.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2366,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Target",
          "qualifier": "",
          "line": 2497,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2497,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Target",
                      "href": "docs/cairo___spec.html#L2497C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2497C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the target surface for the cairo context as passed to Create.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This function will always return a valid pointer, but the result\n"
                },
                {
                  "kind": "span",
                  "text": "can be a \"nil\" surface if cr is already in an error state,\n"
                },
                {
                  "kind": "span",
                  "text": "(ie. Cairo_Status /= Cairo_Status_Success).\n"
                },
                {
                  "kind": "span",
                  "text": "A nil surface is indicated by\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Surface.Status/= Cairo_Status_Success.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the target surface. This object is owned by cairo. To\n"
                },
                {
                  "kind": "span",
                  "text": "keep a reference to it, you must call Cairo.Surface.Reference.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2497,
              "column": 25,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_Tolerance",
          "qualifier": "",
          "line": 2375,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2375,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_Tolerance",
                      "href": "docs/cairo___spec.html#L2375C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2375C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the current tolerance value, as set by Set_Tolerance.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the current tolerance value.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2375,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Get_User_Data",
          "qualifier": "",
          "line": 390,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 390,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Get_User_Data",
                      "href": "docs/cairo___spec.html#L390C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 391,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L391C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 392,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Key",
                      "href": "docs/cairo___spec.html#L392C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_User_Data_Key",
                      "href": "docs/cairo___spec.html#L195C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 393,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "System.Address"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Key: the address of the Cairo_User_Data_Key the user data was\n"
                },
                {
                  "kind": "span",
                  "text": "attached to\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return user data previously attached to cr using the specified\n"
                },
                {
                  "kind": "span",
                  "text": "key.  If no user data has been attached with the given key this\n"
                },
                {
                  "kind": "span",
                  "text": "function returns NULL.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: the user data previously attached or NULL.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.4\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 391,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Key",
              "line": 392,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Glyph_Extents",
          "qualifier": "",
          "line": 2278,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2278,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glyph_Extents",
                      "href": "docs/cairo___spec.html#L2278C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2279,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2279C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "         "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2280,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Glyphs",
                      "href": "docs/cairo___spec.html#L2280C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Glyph",
                      "href": "docs/cairo___spec.html#L1805C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2281,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Num_Glyphs",
                      "href": "docs/cairo___spec.html#L2281C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gint",
                      "href": "docs/glib___spec.html#L49C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 2282,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Extents",
                      "href": "docs/cairo___spec.html#L2282C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Text_Extents",
                      "href": "docs/cairo___spec.html#L1852C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a Cairo_Context\n"
                },
                {
                  "kind": "span",
                  "text": "Glyphs: an array of Cairo_Glyph objects\n"
                },
                {
                  "kind": "span",
                  "text": "Num_Glyphs: the number of elements in glyphs\n"
                },
                {
                  "kind": "span",
                  "text": "Extents: a Cairo_Text_Extents object into which the results\n"
                },
                {
                  "kind": "span",
                  "text": "will be stored\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Gets the extents for an array of glyphs. The extents describe a\n"
                },
                {
                  "kind": "span",
                  "text": "user-space rectangle that encloses the \"inked\" portion of the\n"
                },
                {
                  "kind": "span",
                  "text": "glyphs, (as they would be drawn by Show_Glyphs).\n"
                },
                {
                  "kind": "span",
                  "text": "Additionally, the X_Advance and Y_Advance values indicate the\n"
                },
                {
                  "kind": "span",
                  "text": "amount by which the current point would be advanced by\n"
                },
                {
                  "kind": "span",
                  "text": "Show_Glyphs.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note that whitespace glyphs do not contribute to the size of the\n"
                },
                {
                  "kind": "span",
                  "text": "rectangle (Extents.Width and Extents.Height).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2279,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Glyphs",
              "line": 2280,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Num_Glyphs",
              "line": 2281,
              "column": 7,
              "type": {
                "label": "Glib.Gint",
                "docHref": "docs/glib___spec.html#L49C9"
              },
              "description": [
              ]
            },
            {
              "label": "Extents",
              "line": 2282,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Has_Current_Point",
          "qualifier": "",
          "line": 2389,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2389,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Has_Current_Point",
                      "href": "docs/cairo___spec.html#L2389C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L2389C32"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Returns whether a current point is defined on the current path.\n"
                },
                {
                  "kind": "span",
                  "text": "See Get_Current_Point for details on the current point.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: whether a current point is defined.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.6\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 2389,
              "column": 32,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Identity_Matrix",
          "qualifier": "",
          "line": 1041,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1041,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Identity_Matrix",
                      "href": "docs/cairo___spec.html#L1041C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1041C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Resets the current transformation matrix (CTM) by setting it equal\n"
                },
                {
                  "kind": "span",
                  "text": "to the identity matrix. That is, the user-space and device-space\n"
                },
                {
                  "kind": "span",
                  "text": "axes will be aligned and one user-space unit will transform to one\n"
                },
                {
                  "kind": "span",
                  "text": "device-space unit.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1041,
              "column": 31,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "In_Fill",
          "qualifier": "",
          "line": 1531,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1531,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "In_Fill",
                      "href": "docs/cairo___spec.html#L1531C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1532,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1532C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1533,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1533C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1534,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1534C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1535,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: X coordinate of the point to test\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y coordinate of the point to test\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Tests whether the given point is inside the area that would be\n"
                },
                {
                  "kind": "span",
                  "text": "affected by a Fill operation given the current path and\n"
                },
                {
                  "kind": "span",
                  "text": "filling parameters. Surface dimensions and clipping are not taken\n"
                },
                {
                  "kind": "span",
                  "text": "into account.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Fill, Set_Fill_Rule and Fill_Preserve.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: A non-zero value if the point is inside, or zero if\n"
                },
                {
                  "kind": "span",
                  "text": "outside.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1532,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 1533,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1534,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "In_Stroke",
          "qualifier": "",
          "line": 1511,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1511,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "In_Stroke",
                      "href": "docs/cairo___spec.html#L1511C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1512,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1512C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1513,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1513C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1514,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1514C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "    "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1515,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Boolean"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: X coordinate of the point to test\n"
                },
                {
                  "kind": "span",
                  "text": "Y: Y coordinate of the point to test\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Tests whether the given point is inside the area that would be\n"
                },
                {
                  "kind": "span",
                  "text": "affected by a Stroke operation given the current path and\n"
                },
                {
                  "kind": "span",
                  "text": "stroking parameters. Surface dimensions and clipping are not taken\n"
                },
                {
                  "kind": "span",
                  "text": "into account.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "See Stroke, Set_Line_Width, Set_Line_Join,\n"
                },
                {
                  "kind": "span",
                  "text": "Set_Line_Cap, Set_Dash, and Stroke_Preserve.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: A non-zero value if the point is inside, or zero if\n"
                },
                {
                  "kind": "span",
                  "text": "outside.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1512,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 1513,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1514,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Line_To",
          "qualifier": "",
          "line": 1132,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1132,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Line_To",
                      "href": "docs/cairo___spec.html#L1132C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1132C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1132C43"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1132C56"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: the X coordinate of the end of the new line\n"
                },
                {
                  "kind": "span",
                  "text": "Y: the Y coordinate of the end of the new line\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a line to the path from the current point to position (X, Y)\n"
                },
                {
                  "kind": "span",
                  "text": "in user-space coordinates. After this call the current point\n"
                },
                {
                  "kind": "span",
                  "text": "will be (X, Y).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "If there is no current point before the call to Line_To\n"
                },
                {
                  "kind": "span",
                  "text": "this function will behave as Move_To (Cr, X, Y).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1132,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 1132,
              "column": 43,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1132,
              "column": 56,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Mask",
          "qualifier": "",
          "line": 1405,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1405,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Mask",
                      "href": "docs/cairo___spec.html#L1405C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1405C20"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo___spec.html#L1405C40"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Pattern: a Cairo_Pattern\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that paints the current source using the alpha\n"
                },
                {
                  "kind": "span",
                  "text": "channel of pattern as a mask. (Opaque areas of pattern are painted with\n"
                },
                {
                  "kind": "span",
                  "text": "the source, transparent areas are not painted.)\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1405,
              "column": 20,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Pattern",
              "line": 1405,
              "column": 40,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Mask_Surface",
          "qualifier": "",
          "line": 1413,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1413,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Mask_Surface",
                      "href": "docs/cairo___spec.html#L1413C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1414,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1414C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "        "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1415,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo___spec.html#L1415C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1416,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface_X",
                      "href": "docs/cairo___spec.html#L1416C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1417,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface_Y",
                      "href": "docs/cairo___spec.html#L1417C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Surface: a Cairo_Surface\n"
                },
                {
                  "kind": "span",
                  "text": "Surface_X: X coordinate at which to place the origin of surface\n"
                },
                {
                  "kind": "span",
                  "text": "Surface_Y: Y coordinate at which to place the origin of surface\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that paints the current source\n"
                },
                {
                  "kind": "span",
                  "text": "using the alpha channel of surface as a mask. (Opaque\n"
                },
                {
                  "kind": "span",
                  "text": "areas of surface are painted with the source, transparent\n"
                },
                {
                  "kind": "span",
                  "text": "areas are not painted.)\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1414,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Surface",
              "line": 1415,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            },
            {
              "label": "Surface_X",
              "line": 1416,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Surface_Y",
              "line": 1417,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Move_To",
          "qualifier": "",
          "line": 1108,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1108,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Move_To",
                      "href": "docs/cairo___spec.html#L1108C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1108C23"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1108C43"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1108C56"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: the X coordinate of the new position\n"
                },
                {
                  "kind": "span",
                  "text": "Y: the Y coordinate of the new position\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Begin a new sub-path. After this call the current point will be (X, Y).\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1108,
              "column": 23,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X",
              "line": 1108,
              "column": 43,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y",
              "line": 1108,
              "column": 56,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "New_Path",
          "qualifier": "",
          "line": 1102,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1102,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "New_Path",
                      "href": "docs/cairo___spec.html#L1102C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1102C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Clears the current path. After this call there will be no path and\n"
                },
                {
                  "kind": "span",
                  "text": "no current point.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1102,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "New_Sub_Path",
          "qualifier": "",
          "line": 1115,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1115,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "New_Sub_Path",
                      "href": "docs/cairo___spec.html#L1115C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1115C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Begin a new sub-path. Note that the existing path is not\n"
                },
                {
                  "kind": "span",
                  "text": "affected. After this call there will be no current point.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "In many cases, this call is not needed since new sub-paths are\n"
                },
                {
                  "kind": "span",
                  "text": "frequently started with Move_To.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A call to New_Sub_Path is particularly useful when\n"
                },
                {
                  "kind": "span",
                  "text": "beginning a new sub-path with one of the Arc calls. This\n"
                },
                {
                  "kind": "span",
                  "text": "makes things easier as it is no longer necessary to manually\n"
                },
                {
                  "kind": "span",
                  "text": "compute the arc's initial coordinates for a call to\n"
                },
                {
                  "kind": "span",
                  "text": "Move_To.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1115,
              "column": 28,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Paint",
          "qualifier": "",
          "line": 1390,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1390,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Paint",
                      "href": "docs/cairo___spec.html#L1390C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1390C21"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that paints the current source everywhere within\n"
                },
                {
                  "kind": "span",
                  "text": "the current clip region.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1390,
              "column": 21,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Paint_With_Alpha",
          "qualifier": "",
          "line": 1396,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1396,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Paint_With_Alpha",
                      "href": "docs/cairo___spec.html#L1396C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1396C32"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo___spec.html#L1396C52"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Alpha: Alpha value, between 0 (transparent) and 1 (opaque)\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "A drawing operator that paints the current source everywhere within the\n"
                },
                {
                  "kind": "span",
                  "text": "current clip region using a mask of constant alpha value alpha. The\n"
                },
                {
                  "kind": "span",
                  "text": "effect is similar to Paint, but the drawing is faded out using the alpha\n"
                },
                {
                  "kind": "span",
                  "text": "value.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1396,
              "column": 32,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 1396,
              "column": 52,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Path_Destroy",
          "qualifier": "",
          "line": 2715,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 2715,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Destroy",
                      "href": "docs/cairo___spec.html#L2715C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path",
                      "href": "docs/cairo___spec.html#L2715C28"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Path",
                      "href": "docs/cairo___spec.html#L2627C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Path: a path previously returned by either Copy_Path or Copy_Path_Flat.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Immediately releases all memory associated with Path. After a call\n"
                },
                {
                  "kind": "span",
                  "text": "to Path_Destroy the Path pointer is no longer valid and should not be\n"
                },
                {
                  "kind": "span",
                  "text": "used further.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Note: Path_Destroy should only be called with an access to a\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Path returned by a cairo function. Any path that is created\n"
                },
                {
                  "kind": "span",
                  "text": "manually (ie. outside of cairo) should be destroyed manually as well.\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Path",
              "line": 2715,
              "column": 28,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Path_Extents",
          "qualifier": "",
          "line": 1352,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1352,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Path_Extents",
                      "href": "docs/cairo___spec.html#L1352C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1353,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1353C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1354,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo___spec.html#L1354C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1355,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo___spec.html#L1355C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1356,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X2",
                      "href": "docs/cairo___spec.html#L1356C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1357,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y2",
                      "href": "docs/cairo___spec.html#L1357C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "access"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X1: left of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y1: top of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "X2: right of the resulting extents\n"
                },
                {
                  "kind": "span",
                  "text": "Y2: bottom of the resulting extents\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Computes a bounding box in user-space coordinates covering the\n"
                },
                {
                  "kind": "span",
                  "text": "points on the current path. If the current path is empty, returns\n"
                },
                {
                  "kind": "span",
                  "text": "an empty rectangle ((0,0), (0,0)). Stroke parameters, fill rule,\n"
                },
                {
                  "kind": "span",
                  "text": "surface dimensions and clipping are not taken into account.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Contrast with Fill_Extents and Stroke_Extents which\n"
                },
                {
                  "kind": "span",
                  "text": "return the extents of only the area that would be \"inked\" by\n"
                },
                {
                  "kind": "span",
                  "text": "the corresponding drawing operations.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The result of Path_Extents is defined as equivalent to the\n"
                },
                {
                  "kind": "span",
                  "text": "limit of Stroke_Extents with Cairo_Line_Cap_Round as the\n"
                },
                {
                  "kind": "span",
                  "text": "line width approaches 0.0, (but never reaching the empty-rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "returned by Cairo_Stroke_Extents for a line width of 0.0).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Specifically, this means that zero-area sub-paths such as\n"
                },
                {
                  "kind": "span",
                  "text": "Move_To;Line_To segments, (even degenerate cases where the coordinates\n"
                },
                {
                  "kind": "span",
                  "text": "to both calls are identical), will be considered as contributing to the\n"
                },
                {
                  "kind": "span",
                  "text": "extents. However, a lone Move_To will not contribute to the results of\n"
                },
                {
                  "kind": "span",
                  "text": "Path_Extents.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.6\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 1353,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 1354,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 1355,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "X2",
              "line": 1356,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            },
            {
              "label": "Y2",
              "line": 1357,
              "column": 7,
              "type": {
                "label": ""
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Add_Color_Stop_Rgb",
          "qualifier": "",
          "line": 653,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 653,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Add_Color_Stop_Rgb",
                      "href": "docs/cairo___spec.html#L653C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 654,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo___spec.html#L654C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 655,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo___spec.html#L655C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 656,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo___spec.html#L656C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo___spec.html#L656C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo___spec.html#L656C19"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 654,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 655,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 656,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 656,
              "column": 12,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 656,
              "column": 19,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Add_Color_Stop_Rgba",
          "qualifier": "",
          "line": 660,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 660,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Add_Color_Stop_Rgba",
                      "href": "docs/cairo___spec.html#L660C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 661,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo___spec.html#L661C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 662,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Offset",
                      "href": "docs/cairo___spec.html#L662C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 663,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo___spec.html#L663C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo___spec.html#L663C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo___spec.html#L663C19"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo___spec.html#L663C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 661,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            },
            {
              "label": "Offset",
              "line": 662,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Red",
              "line": 663,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 663,
              "column": 12,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 663,
              "column": 19,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 663,
              "column": 25,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Create_For_Surface",
          "qualifier": "",
          "line": 636,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 636,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Create_For_Surface",
                      "href": "docs/cairo___spec.html#L636C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 637,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Surface",
                      "href": "docs/cairo___spec.html#L637C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Surface",
                      "href": "docs/cairo___spec.html#L2767C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Surface",
              "line": 637,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Surface",
                "docHref": "docs/cairo___spec.html#L92C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Create_Linear",
          "qualifier": "",
          "line": 641,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 641,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Create_Linear",
                      "href": "docs/cairo___spec.html#L641C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 642,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X0",
                      "href": "docs/cairo___spec.html#L642C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y0",
                      "href": "docs/cairo___spec.html#L642C11"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X1",
                      "href": "docs/cairo___spec.html#L642C15"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y1",
                      "href": "docs/cairo___spec.html#L642C19"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "X0",
              "line": 642,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y0",
              "line": 642,
              "column": 11,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "X1",
              "line": 642,
              "column": 15,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Y1",
              "line": 642,
              "column": 19,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Create_Radial",
          "qualifier": "",
          "line": 646,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 646,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Create_Radial",
                      "href": "docs/cairo___spec.html#L646C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 647,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cx0",
                      "href": "docs/cairo___spec.html#L647C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cy0",
                      "href": "docs/cairo___spec.html#L647C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius0",
                      "href": "docs/cairo___spec.html#L647C17"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cx1",
                      "href": "docs/cairo___spec.html#L647C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cy1",
                      "href": "docs/cairo___spec.html#L647C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Radius1",
                      "href": "docs/cairo___spec.html#L647C36"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cx0",
              "line": 647,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cy0",
              "line": 647,
              "column": 12,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius0",
              "line": 647,
              "column": 17,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cx1",
              "line": 647,
              "column": 26,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Cy1",
              "line": 647,
              "column": 31,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Radius1",
              "line": 647,
              "column": 36,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Create_Rgb",
          "qualifier": "",
          "line": 628,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 628,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Create_Rgb",
                      "href": "docs/cairo___spec.html#L628C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 629,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo___spec.html#L629C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo___spec.html#L629C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo___spec.html#L629C19"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Red",
              "line": 629,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 629,
              "column": 12,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 629,
              "column": 19,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Create_Rgba",
          "qualifier": "",
          "line": 632,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 632,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Create_Rgba",
                      "href": "docs/cairo___spec.html#L632C13"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 633,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Red",
                      "href": "docs/cairo___spec.html#L633C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Green",
                      "href": "docs/cairo___spec.html#L633C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Blue",
                      "href": "docs/cairo___spec.html#L633C19"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ","
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Alpha",
                      "href": "docs/cairo___spec.html#L633C25"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Red",
              "line": 633,
              "column": 7,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Green",
              "line": 633,
              "column": 12,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Blue",
              "line": 633,
              "column": 19,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            },
            {
              "label": "Alpha",
              "line": 633,
              "column": 25,
              "type": {
                "label": "Glib.Gdouble",
                "docHref": "docs/glib___spec.html#L59C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pattern_Destroy",
          "qualifier": "",
          "line": 650,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 650,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern_Destroy",
                      "href": "docs/cairo___spec.html#L650C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pattern",
                      "href": "docs/cairo___spec.html#L650C31"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Pattern",
              "line": 650,
              "column": 31,
              "type": {
                "label": "Cairo.Cairo_Pattern",
                "docHref": "docs/cairo___spec.html#L172C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pop_Group",
          "qualifier": "",
          "line": 512,
          "column": 13,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 512,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "function"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pop_Group",
                      "href": "docs/cairo___spec.html#L512C13"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L512C24"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "return"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Pattern",
                      "href": "docs/cairo___spec.html#L2770C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Terminates the redirection begun by a call to Push_Group or\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group_With_Content and returns a new pattern containing the results\n"
                },
                {
                  "kind": "span",
                  "text": "of all drawing operations performed to the group.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Pop_Group function calls Restore, (balancing a call to Save by the\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group function), so that any changes to the graphics state will not\n"
                },
                {
                  "kind": "span",
                  "text": "be visible outside the group.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Return value: a newly created (surface) pattern containing the\n"
                },
                {
                  "kind": "span",
                  "text": "results of all drawing operations performed to the group. The\n"
                },
                {
                  "kind": "span",
                  "text": "caller owns the returned object and should call\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo.Pattern.Destroy when finished with it.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 512,
              "column": 24,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Pop_Group_To_Source",
          "qualifier": "",
          "line": 530,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 530,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Pop_Group_To_Source",
                      "href": "docs/cairo___spec.html#L530C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L530C35"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Terminates the redirection begun by a call to Push_Group or\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group_With_Content and installs the resulting pattern as the source\n"
                },
                {
                  "kind": "span",
                  "text": "pattern in the given cairo context.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The behavior of this function is equivalent to the sequence of\n"
                },
                {
                  "kind": "span",
                  "text": "operations:\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "declare\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Group: Cairo_Pattern := Pop_Group (Cr);"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "begin\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Set_Source (Cr, Group);"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Cairo.Pattern.Destroy (Group);"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "end;\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "but is more convenient as their is no need for a variable to store\n"
                },
                {
                  "kind": "span",
                  "text": "the short-lived pointer to the pattern.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Pop_Group function calls Restore, (balancing a call to Save by the\n"
                },
                {
                  "kind": "span",
                  "text": "push_group function), so that any changes to the graphics state will not\n"
                },
                {
                  "kind": "span",
                  "text": "be visible outside the group.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 530,
              "column": 35,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Push_Group",
          "qualifier": "",
          "line": 450,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 450,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Push_Group",
                      "href": "docs/cairo___spec.html#L450C14"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L450C26"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Temporarily redirects drawing to an intermediate surface known as a\n"
                },
                {
                  "kind": "span",
                  "text": "group. The redirection lasts until the group is completed by a call\n"
                },
                {
                  "kind": "span",
                  "text": "to Pop_Group or Pop_Group_To_Source.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "These calls provide the result of any drawing to the group as a pattern,\n"
                },
                {
                  "kind": "span",
                  "text": "(either as an explicit object, or set as the source pattern).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "This group functionality can be convenient for performing\n"
                },
                {
                  "kind": "span",
                  "text": "intermediate compositing. One common use of a group is to render\n"
                },
                {
                  "kind": "span",
                  "text": "objects as opaque within the group, (so that they occlude each\n"
                },
                {
                  "kind": "span",
                  "text": "other), and then blend the result with translucence onto the\n"
                },
                {
                  "kind": "span",
                  "text": "destination.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Groups can be nested arbitrarily deep by making balanced calls to\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group/Pop_Group. Each call pushes/pops the new target group\n"
                },
                {
                  "kind": "span",
                  "text": "onto/from a stack.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The Push_Group function calls Save so that any changes to the graphics\n"
                },
                {
                  "kind": "span",
                  "text": "state will not be visible outside the group, (the pop_group functions\n"
                },
                {
                  "kind": "span",
                  "text": "call Restore).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "By default the intermediate group will have a content type of\n"
                },
                {
                  "kind": "span",
                  "text": "Cairo_Content_Color_Alphe. Other content types can be chosen for\n"
                },
                {
                  "kind": "span",
                  "text": "the group by using Push_Group_With_Content instead.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "As an example, here is how one might fill and stroke a path with\n"
                },
                {
                  "kind": "span",
                  "text": "translucence, but without any portion of the fill being visible\n"
                },
                {
                  "kind": "span",
                  "text": "under the stroke:\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Push_Group (Cr);"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Set_Source (Cr, Fill_Pattern);"
                    }
                  ]
                },
                {
                  "number": 3,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Fill_Preserve (Cr);"
                    }
                  ]
                },
                {
                  "number": 4,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Set_Source (Cr, Stroke_Pattern);"
                    }
                  ]
                },
                {
                  "number": 5,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Stroke (Cr);"
                    }
                  ]
                },
                {
                  "number": 6,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Pop_Group_To_Source (Cr);"
                    }
                  ]
                },
                {
                  "number": 7,
                  "children": [
                    {
                      "kind": "span",
                      "text": "Paint_With_Alpha (Cr, Alpha);"
                    }
                  ]
                },
                {
                  "number": 8,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 450,
              "column": 26,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Push_Group_With_Content",
          "qualifier": "",
          "line": 492,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 492,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Push_Group_With_Content",
                      "href": "docs/cairo___spec.html#L492C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 493,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L493C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 494,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Content",
                      "href": "docs/cairo___spec.html#L494C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Content",
                      "href": "docs/cairo___spec.html#L316C12"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "Content: a Cairo_Content indicating the type of group that\n"
                }
              ]
            },
            {
              "kind": "code",
              "children": [
                {
                  "number": 1,
                  "children": [
                    {
                      "kind": "span",
                      "text": "will be created"
                    }
                  ]
                },
                {
                  "number": 2,
                  "children": [
                    {
                      "kind": "span",
                      "text": ""
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Temporarily redirects drawing to an intermediate surface known as a\n"
                },
                {
                  "kind": "span",
                  "text": "group. The redirection lasts until the group is completed by a call to\n"
                },
                {
                  "kind": "span",
                  "text": "Pop_Group or Pop_Group_To_Source. These calls provide the result of any\n"
                },
                {
                  "kind": "span",
                  "text": "drawing to the group as a pattern, (either as an explicit object, or set\n"
                },
                {
                  "kind": "span",
                  "text": "as the source pattern).\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "The group will have a content type of content. The ability to control\n"
                },
                {
                  "kind": "span",
                  "text": "this content type is the only distinction between this function and\n"
                },
                {
                  "kind": "span",
                  "text": "Push_Group which you should see for a more detailed description of group\n"
                },
                {
                  "kind": "span",
                  "text": "rendering.\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Since: 1.2\n"
                }
              ]
            }
          ],
          "parameters": [
            {
              "label": "Cr",
              "line": 493,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Context",
                "docHref": "docs/cairo___spec.html#L77C9"
              },
              "description": [
              ]
            },
            {
              "label": "Content",
              "line": 494,
              "column": 7,
              "type": {
                "label": "Cairo.Cairo_Content",
                "docHref": "docs/cairo___spec.html#L316C12"
              },
              "description": [
              ]
            }
          ]
        },
        {
          "label": "Rectangle",
          "qualifier": "",
          "line": 1304,
          "column": 14,
          "src": "srcs/cairo.ads.html",
          "summary": [
          ],
          "description": [
            {
              "kind": "code",
              "children": [
                {
                  "kind": "line",
                  "number": 1304,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "   "
                    },
                    {
                      "kind": "span",
                      "cssClass": "keyword",
                      "text": "procedure"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Rectangle",
                      "href": "docs/cairo___spec.html#L1304C14"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1305,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "("
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cr",
                      "href": "docs/cairo___spec.html#L1305C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "     "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Cairo_Context",
                      "href": "docs/cairo___spec.html#L2764C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1306,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "X",
                      "href": "docs/cairo___spec.html#L1306C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1307,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Y",
                      "href": "docs/cairo___spec.html#L1307C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1308,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Width",
                      "href": "docs/cairo___spec.html#L1308C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "  "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                },
                {
                  "kind": "line",
                  "number": 1309,
                  "children": [
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": "      "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Height",
                      "href": "docs/cairo___spec.html#L1309C7"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ":"
                    },
                    {
                      "kind": "span",
                      "cssClass": "text",
                      "text": " "
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": "Gdouble",
                      "href": "docs/glib___spec.html#L59C9"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ")"
                    },
                    {
                      "kind": "span",
                      "cssClass": "identifier",
                      "text": ";"
                    }
                  ]
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Cr: a cairo context\n"
                },
                {
                  "kind": "span",
                  "text": "X: the X coordinate of the top left corner of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Y: the Y coordinate to the top left corner of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Width: the Width of the rectangle\n"
                },
                {
                  "kind": "span",
                  "text": "Height: the Height of the rectangle\n"
                }
              ]
            },
            {
              "kind": "paragraph",
              "children": [
                {
                  "kind": "span",
                  "text": "Adds a closed sub-path rectangle of the g